% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{endometrial}
\alias{endometrial}
\title{Histology grade and risk factors for 79 cases of endometrial cancer}
\format{
A data frame with 79 rows and 4 variables:
\itemize{
\item \code{NV}: neovasculization with coding 0 for absent and 1 for present
\item \code{PI}: pulsality index of arteria uterina
\item \code{EH}: endometrium height
\item \code{HG} histology grade with coding 0 for low grade and 1 for high grade
}
}
\source{
The packaged data set was downloaded in \code{.dat} format from
\url{https://users.stat.ufl.edu/~aa/glm/data/}. The latter link
provides the data sets used in Agresti (2015).

\if{html}{\out{<div class="sourceCode">}}\preformatted{The endometrial data set was first analyzed in Heinze and
Schemper (2002), and was originally provided by Dr
E. Asseryanis from the Medical University of Vienna.
}\if{html}{\out{</div>}}
}
\usage{
endometrial
}
\description{
Histology grade and risk factors for 79 cases of endometrial cancer
}
\references{
Agresti A (2015). \emph{Foundations of Linear and Generalized Linear
Models}.  Wiley Series in Probability and Statistics. Wiley.

Heinze G, Schemper M (2002). A Solution to the Problem of
Separation in Logistic Regression. \emph{Statistics in Medicine},
\strong{21}, 2409–2419. \doi{10.1002/sim.1047}.

Kosmidis I, Firth D (2021). Jeffreys-prior penalty, finiteness
and shrinkage in binomial-response generalized linear
models. \emph{Biometrika}, \strong{108}, 71-82. \doi{10.1093/biomet/asaa052}.
}
\seealso{
\code{\link[=brglm_fit]{brglm_fit()}}
}
\keyword{datasets}
