% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-numeric.R
\name{chk_numeric}
\alias{chk_numeric}
\alias{vld_numeric}
\title{Check Numeric}
\usage{
chk_numeric(x, x_name = NULL)

vld_numeric(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if numeric using

\code{is.numeric(x)}

\strong{Pass}: \code{1}, \code{1:2}, \code{NA_real_}, \code{integer(0)}, \code{matrix(1:3)}.

\strong{Fail}: \code{TRUE}, \code{"1"}, \code{NA}, \code{NULL}.
}
\section{Functions}{
\itemize{
\item \code{vld_numeric()}: Validate Numeric

}}
\examples{
# chk_numeric
chk_numeric(1)
try(chk_numeric("1"))
# vld_numeric
vld_numeric(1)
vld_numeric(1:2)
vld_numeric(NA_real_)
vld_numeric(integer(0))
vld_numeric("1")
vld_numeric(TRUE)
}
\seealso{
\code{\link[=is.numeric]{is.numeric()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other data_type_checkers: 
\code{\link{chk_character}()},
\code{\link{chk_character_or_factor}()},
\code{\link{chk_complex}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_integer}()},
\code{\link{chk_logical}()},
\code{\link{chk_raw}()}
}
\concept{data_type_checkers}
