% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoned-time.R
\name{zoned_time_info}
\alias{zoned_time_info}
\title{Info: zoned-time}
\usage{
zoned_time_info(x)
}
\arguments{
\item{x}{\verb{[clock_zoned_time]}

A zoned-time.}
}
\value{
A data frame of low level information.
}
\description{
\code{zoned_time_info()} retrieves a set of low-level information generally not
required for most date-time manipulations. It returns a data frame with the
same columns as \code{\link[=sys_time_info]{sys_time_info()}}, but the \code{begin} and \code{end} columns are
zoned-times with the same time zone as \code{x}.
}
\examples{
x <- year_month_day(2021, 03, 14, c(01, 03), c(59, 00), c(59, 00))
x <- as_naive_time(x)
x <- as_zoned_time(x, "America/New_York")

# x[1] is in EST, x[2] is in EDT
x

info <- zoned_time_info(x)
info

# `end` can be used to iterate through daylight saving time transitions
zoned_time_info(info$end)
}
