% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCV_datasets.R
\docType{data}
\name{DBCV_datasets}
\alias{DBCV_datasets}
\alias{Dataset_1}
\alias{Dataset_2}
\alias{Dataset_3}
\alias{Dataset_4}
\title{DBCV Paper Datasets}
\format{
Four data frames with the following 3 variables.
\describe{
\item{x}{a numeric vector}
\item{y}{a numeric vector}
\item{class}{an integer vector indicating the class label. 0 means noise.} }
}
\source{
https://github.com/pajaskowiak/dbcv
}
\description{
The four synthetic 2D datasets used in Moulavi et al (2014).
}
\examples{
data("Dataset_1")
clplot(Dataset_1[, c("x", "y")], cl = Dataset_1$class)

data("Dataset_2")
clplot(Dataset_2[, c("x", "y")], cl = Dataset_2$class)

data("Dataset_3")
clplot(Dataset_3[, c("x", "y")], cl = Dataset_3$class)

data("Dataset_4")
clplot(Dataset_4[, c("x", "y")], cl = Dataset_4$class)
}
\references{
Davoud Moulavi and Pablo A. Jaskowiak and
Ricardo J. G. B. Campello and Arthur Zimek and Jörg Sander (2014).
Density-Based Clustering Validation. In
\emph{Proceedings of the 2014 SIAM International Conference on Data Mining,}
pages 839-847
\doi{10.1137/1.9781611973440.96}
}
\keyword{datasets}
