% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_scaleBy.R
\name{by_scale}
\alias{by_scale}
\alias{scaleBy}
\alias{scale_by}
\title{Scale a dataframe or matrix}
\usage{
scaleBy(formula, data = parent.frame(), center = TRUE, scale = TRUE)

scale_by(data, formula, center = TRUE, scale = TRUE)
}
\arguments{
\item{formula}{Variables to split data frame by, as \code{as.quoted}
variables, a formula or character vector.}

\item{data}{A dataframe or matrix}

\item{center}{Logical, should data be centered.}

\item{scale}{Logical, should data be scaled.}
}
\value{
A list of objects of same class as \code{x}
}
\description{
Split a dataframe into a list according to the levels
of variables in the dataframe and scale the numeric variables
in each dataframe in the list.
}
\examples{

scaleBy(~Species, data=iris, center=TRUE, scale=FALSE)
scaleBy(~1, data=iris, center=TRUE, scale=FALSE)

scale_by(iris, ~Species)
scale_by(iris, ~1)

## Not combine list of dataframes to one dataframe e.g. as:
a <- scale_by(iris, ~Species)
d <- do.call(rbind, a)
}
\seealso{
\code{\link{orderBy}}, \code{\link{order_by}},
\code{\link{summaryBy}}, \code{\link{summary_by}},
\code{\link{transformBy}}, \code{\link{transform_by}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
