% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_drive_create.R
\name{shared_drive_create}
\alias{shared_drive_create}
\title{Create a new shared drive}
\usage{
shared_drive_create(name)
}
\arguments{
\item{name}{Character. Name of the new shared drive. Must be non-empty and not
entirely whitespace.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per shared drive.
}
\description{
A shared drive supports files owned by an organization rather than an
individual user. Shared drives follow different sharing and ownership models
from a specific user's "My Drive". Shared drives are the successors to the
earlier concept of Team Drives. Learn more about \link[=shared_drives]{shared drives}.
}
\examples{
\dontrun{
shared_drive_create("my-awesome-shared-drive")

# clean up
shared_drive_rm("my-awesome-shared-drive")
}
}
\seealso{
Wraps the \code{drives.create} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/reference/drives/create}
}
}
