% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor2string.R
\name{step_factor2string}
\alias{step_factor2string}
\alias{tidy.step_factor2string}
\title{Convert Factors to Strings}
\usage{
step_factor2string(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = FALSE,
  skip = FALSE,
  id = rand_id("factor2string")
)

\method{tidy}{step_factor2string}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will be converted to strings. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variables that will be
converted. This is \code{NULL} until computed by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_factor2string} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
columns that will be affected).
}
\description{
\code{step_factor2string} will convert one or more factor
vectors to strings.
}
\details{
\code{prep} has an option \code{strings_as_factors} that
defaults to \code{TRUE}. If this step is used with the default
option, the string(s() produced by this step will be converted
to factors after all of the steps have been prepped.
}
\examples{
library(modeldata)
data(okc)

rec <- recipe(~ diet + location, data = okc)

rec <- rec \%>\%
  step_string2factor(diet)

factor_test <- rec \%>\%
  prep(training = okc,
       strings_as_factors = FALSE) \%>\%
  juice
# diet is a
class(factor_test$diet)

rec <- rec \%>\%
  step_factor2string(diet)

string_test <- rec \%>\%
  prep(training = okc,
       strings_as_factors = FALSE) \%>\%
  juice
# diet is a
class(string_test$diet)

tidy(rec, number = 1)
}
\seealso{
\code{\link[=step_string2factor]{step_string2factor()}} \code{\link[=step_dummy]{step_dummy()}}
}
\concept{factors}
\concept{preprocessing}
\concept{variable_encodings}
\keyword{datagen}
