% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{group_vfold_cv}
\alias{group_vfold_cv}
\title{Group V-Fold Cross-Validation}
\usage{
group_vfold_cv(data, group = NULL, v = NULL, ...)
}
\arguments{
\item{data}{A data frame.}

\item{group}{This could be a single character value or a variable
name that corresponds to a variable that exists in the data frame.}

\item{v}{The number of partitions of the data set. If let
\code{NULL}, \code{v} will be set to the number of unique values
in the group.}

\item{...}{Not currently used.}
}
\value{
A tibble with classes \code{group_vfold_cv},
\code{rset}, \code{tbl_df}, \code{tbl}, and \code{data.frame}.
The results include a column for the data split objects and an
identification variable.
}
\description{
Group V-fold cross-validation creates splits of the data based
on some grouping variable (which may have more than a single row
associated with it). The function can create as many splits as
there are unique values of the grouping variable or it can
create a smaller set of splits where more than one value is left
out at a time.
}
\examples{
set.seed(3527)
test_data <- data.frame(id = sort(sample(1:20, size = 80, replace = TRUE)))
test_data$dat <- runif(nrow(test_data))

set.seed(5144)
split_by_id <- group_vfold_cv(test_data, group = "id")

get_id_left_out <- function(x)
  unique(assessment(x)$id)

library(purrr)
table(map_int(split_by_id$splits, get_id_left_out))

set.seed(5144)
split_by_some_id <- group_vfold_cv(test_data, group = "id", v = 7)
held_out <- map(split_by_some_id$splits, get_id_left_out)
table(unlist(held_out))
# number held out per resample:
map_int(held_out, length)
}
