# `unitizer` NEWS

## v1.4.22

* Fix unnamed arguments error in a call to `deparse` that manifested with
  improvements changes in r-devel.
* Fix bad `all.equal` method NAMESPACE entries (h/t @MichaelChirico), see
  [source issue](https://github.com/r-lib/roxygen2/issues/1587) for details.

## v1.4.21

* Suppress test caused to fail by checks added to `parent.env<-` in r-devel r86545.

## v1.4.20

* Add explicit alias for `fansi-package` now that it is no longer 
  auto-generated by roxgen2 from the [`@docType package` directive](https://github.com/r-lib/roxygen2/issues/1491).

## v1.4.19

* [#293](https://github.com/brodieG/unitizer/issues/293): Output all failed
  tests in non-interactive mode, instead of just the first one.
* [#292](https://github.com/brodieG/unitizer/issues/292): Clarify warnings about
  stderr in transcript mode.
* Fully unhook the evaluation environment chain prior to storing unitizers.
  Previously only the portions of the chain part of the unitizer was unhooked,
  but with some tests it becomes possible to capture environments created during
  the `pre` expression evaluations.  This could cause warnings about package
  environments being unavailable on reload of RDSes.

## v1.4.18

* [#289](https://github.com/brodieG/unitizer/issues/289): Better document
  pitfalls of non-ASCII in e.g. literals in tests.  Related: we no longer
  attempt to do a parse/deparse round trip when displaying recorded test
  expressions as the round trip could fail in some cases.
* [#288](https://github.com/brodieG/unitizer/issues/288): Prevent upgrade prompt
  in non-interactive mode interrupting result display (regression introduced in
  1.4.15).
* [#286](https://github.com/brodieG/unitizer/issues/286): Add a "transcript"
  mode where test output can better be interpreted as a log, intended
  non-interactive mode.
* [#272](https://github.com/brodieG/unitizer/issues/272): Highlight silently
  emitted conditions in tests that have otherwise no other output.
* [#252](https://github.com/brodieG/unitizer/issues/252),
  [#253](https://github.com/brodieG/unitizer/issues/252): Better documentation
  of feature incompatibility with `devtools::load_all`, and more graceful
  recovery from failures caused by the incompatibility.  This only affects
  `unitizer` sessions run with package search path management enabled (h/t
  @blset).
* [#247](https://github.com/brodieG/unitizer/issues/247): Disallow running
  `unitizer` without first attaching it to the search path.
* [#245](https://github.com/brodieG/unitizer/issues/245): Fix re-run bookmarking
  when reviewing multiple unitizers with `unitize_dir`.

## v1.4.16-17

* [#285](https://github.com/brodieG/unitizer/issues/285): Relax condition call
* [#284](https://github.com/brodieG/unitizer/issues/284): Handle CTRL+C
  interrupts while multi-line editing.
* [#283](https://github.com/brodieG/unitizer/issues/283): Multi-unitizer upgrade
  regression introduced in 1.4.15.
* Address CRAN failures due to path inconsistencies on Windows machines.
* [#279](https://github.com/brodieG/unitizer/issues/279): Multi-line input
  parsing works in non-English locales.

## v1.4.15.9000

Non-CRAN release to fix test issues under `covr` and on older R versions.

## v1.4.15

* Test suite switched to `aammrtf`, removing suggests dependency to `testthat`.
* Upgrade process modified so that old `unitizer` that pass tests are not
  required to be upgraded.
* `show.progress` parameter added to control chattiness of progress updates.
* Invalid `unitizers` now prevent review of valid `unitizers`.  Fix the invalid
  `unitizers`, or remove them from the review list (e.g. by moving them out of
  the primary `unitizer` directory).
* `review` exposes `use.diff` and `show.progress` parameters.
* [#278](https://github.com/brodieG/unitizer/issues/278): Show more context when
  returning to a test via browser or on re-evaluation.
* [#277](https://github.com/brodieG/unitizer/issues/277): Handle CTRL+C
  interrupts so they do not kill the `unitizer` session (h/t
  [@milesmcbain](https://milesmcbain.micro.blog/2021/06/10/debugging-cantrip-from.html)).

## v1.4.13-14

* `unitizer` no longer directly accesses `.Traceback` to set traces in
  interactive sessions.  Instead, `traceback()` and `.traceback()` are masked
  at the interactive prompt.

## v1.4.11-12

* [#248](https://github.com/brodieG/unitizer/issues/248): Ensure vignettes can
  be tested with `tools::testInstalledPackage`.
* [#250](https://github.com/brodieG/unitizer/issues/250),
  [#251](https://github.com/brodieG/unitizer/issues/251),
  [#254](https://github.com/brodieG/unitizer/issues/254): Comment parsing
  improvements (h/t
  [@blset](https://github.com/brodieG/unitizer/issues/created_by/blset),
  [@kalibera](https://github.com/kalibera/))
* [#263](https://github.com/brodieG/unitizer/issues/263): Clarify documentation
  about potential state management issuess.  This includes renaming
  "recommended" state management mode (see `?unitizerState`) to "suggested"
  ("recommended" still works).
* [#268](https://github.com/brodieG/unitizer/issues/268): `options(warn=2)` now
  works at the `unitizer` prompt in interactive mode.
* [#265](https://github.com/brodieG/unitizer/issues/265): Bad vignette links in
  README (h/t [@moodymudskipper](https://github.com/moodymudskipper)).
* [#260](https://github.com/brodieG/unitizer/issues/260): Remove old test error
  display code.
* [#246](https://github.com/brodieG/unitizer/issues/246),
  [#243](https://github.com/brodieG/unitizer/issues/243): Assorted documentation
  updates.
  [#254](https://github.com/brodieG/unitizer/issues/254): Comment parsing.
* Fix `sprintf` unused argument errors in new versions of r-devel (h/t
  [@kalibera](https://github.com/kalibera/)).
* `stringsAsFactors` rose from the grave; we put it back.

## v1.4.10

* Banish ghosts of `stringsAsFactors`.

## v1.4.9

* [#262](https://github.com/brodieG/unitizer/issues/262) Interactive prompt
  slowness caused by recent R changes to `showConnections()`.
* [#261](https://github.com/brodieG/unitizer/issues/261) RDS files are
  explicitly saved in serialization version 2 for backwards compatibility.
* [#244](https://github.com/brodieG/unitizer/issues/244) Squash all partial
  match warnings that `unitizer` emitted under `options(warnPartialMatch*)`.
* Tests explicitly set `stringsAsFactors=TRUE` so they don't fail with the
  anticipated changed for R4.0.
* Adds the 'unitizer.restarts.ok' option to suppress warnings about being run
  within `withRestart` blocks.

## v1.4.8

* `install.packages` calls in tests now use a temporary folder for library.

## v1.4.7

* Set `RNGversion()` in internal tests due to changes to R sampling mechanism.

## v1.4.6

* [#258](https://github.com/brodieG/unitizer/issues/258) Remove `devtools` as a
  suggests dependency (reported by @jimhester).
* [#257](https://github.com/brodieG/unitizer/issues/257) Ensure all slots in
  S4 prototypes exist in the class definition (reported by B. Ripley).

## v1.4.5

* Colors in test browser working again.
* [#220](https://github.com/brodieG/unitizer/issues/220) Fix vignette ordering
  on CRAN.
* [#225](https://github.com/brodieG/unitizer/issues/225) Inferring file
  locations when not in pkg top level.
* [#237](https://github.com/brodieG/unitizer/issues/237) Option to turn off
  diffs.
* [#239](https://github.com/brodieG/unitizer/issues/239) Document issues with
  deparsing doubles in tests.
* [#242](https://github.com/brodieG/unitizer/issues/242) Correctly parse
  newlines in prompt input.
* [#241](https://github.com/brodieG/unitizer/issues/241) `q()` actually works
  now.
* [#231](https://github.com/brodieG/unitizer/issues/231) Report parse warnings
  at prompt.
* [#234](https://github.com/brodieG/unitizer/issues/234) Random seed issues.
* [#220](https://github.com/brodieG/unitizer/issues/220) Re-order vignettes.
* Wrap `diffObj` call in `try` to avoid killing `unitizer` section when
  `diffObj` errors.
* Modify `test_dir` calls to use `wrap` on `testthat` versions greater than
  0.1.2.

## v1.4.4

* Fix tests broken by R-devel 3.4.1 improvements to S4 deparsing
* [#232](https://github.com/brodieG/unitizer/issues/232) document that
  `.Last.value` does not work
* [#228](https://github.com/brodieG/unitizer/issues/228) more docs on handling
  RDS files
* README typos (@eddelbuettel)
* Improve vignette index

## v1.4.3

* [#221](https://github.com/brodieG/unitizer/issues/221) Crash on Re-Run due to
  poor comparison of parsed test file sources
* [#222](https://github.com/brodieG/unitizer/issues/222) Allow loading of
  `unitizers` generated by later versions of the package in earlier version of
  the packages provided the object validates
* [#224](https://github.com/brodieG/unitizer/issues/224) Slow re-eval in
  recommended state mode with lots of files

## v1.4.1-2

Fixing CRAN submission errors.

## v1.4.0

First Release to CRAN.

* [#213](https://github.com/brodieG/unitizer/issues/213): Disable advanced state
  management by default to comply with CRAN
* [#203](https://github.com/brodieG/unitizer/issues/203): Better reporting of
  search path state differences
* Assorted bugfixes and enhancements:
  [#214](https://github.com/brodieG/unitizer/issues/214),
  [#215](https://github.com/brodieG/unitizer/issues/215),
  [#208](https://github.com/brodieG/unitizer/issues/208),
  [#201](https://github.com/brodieG/unitizer/issues/201),
  [#208](https://github.com/brodieG/unitizer/issues/208),
  [#199](https://github.com/brodieG/unitizer/issues/199),
  [#197](https://github.com/brodieG/unitizer/issues/197)

## v1.2.0 - v1.3.0

Interim release to get changes over past year out on the master branch.

### Improvement / Changes:

* [#194](https://github.com/brodieG/unitizer/issues/194): Performance
  improvements
* [#102](https://github.com/brodieG/unitizer/issues/102): Ability to break out
  of multi file review with `QQ`
* [#186](https://github.com/brodieG/unitizer/issues/186): If you type `q()` or
  `quit()` by mistake you can now cancel that action before `unitizer`
  terminates unceremoniously
* [#142](https://github.com/brodieG/unitizer/issues/142): Ability to run
  `unitize` and `unitize_dir` without specifying any arguments (infer from
  working directory)
* [#168](https://github.com/brodieG/unitizer/issues/168): Failing tests now will
  display all output and conditions
* [#171](https://github.com/brodieG/unitizer/issues/171): Flush warnings in
  `unitizer` REPL
* Improved integration of object diffs via `.DIFF` and `.diff`
* Display improvements, including:
    * Cleaner separation of `unitizer` meta-output vs. test or command line
    * [#164](https://github.com/brodieG/unitizer/issues/164), [#176](https://github.com/brodieG/unitizer/issues/176): Streamline state difference display
* Several other [enhancements](https://github.com/brodieG/unitizer/issues?utf8=%E2%9C%93&q=is%3Aissue%20is%3Aopen%20label%3A%22fixed%20in%20dev%22%20milestone%3A1.2.0%20-label%3Aenhancement%20)

### Bugfixes:

* [#188](https://github.com/brodieG/unitizer/issues/188): Search path issues
  in r-devel @[richierocks](https://github.com/richierocks)
* Fix unintended detaching of `tools:rstudio`, and [many](https://github.com/brodieG/unitizer/issues?utf8=%E2%9C%93&q=is%3Aissue%20milestone%3A1.2.0%20label%3Abug%20) [others](https://github.com/brodieG/unitizer/issues?utf8=%E2%9C%93&q=is%3Aissue%20milestone%3A1.3.0%20label%3Abug%20)
* `base.env` now unique for each `unitizer`

## v1.1.0

### Improvement / Changes:

* [#161](https://github.com/brodieG/unitizer/issues/161): Compare objects with `diffobj::diffObj`
* [#166](https://github.com/brodieG/unitizer/issues/166): More systematic
  handling of `library`/`attach`/`detach`

### Bugfixes:

* Several unitizer prompt issues:
    * No longer capture prompt evals so `debug` is usable again
    * Parse errors reported correctly
    * [#165](https://github.com/brodieG/unitizer/issues/165): Confusing Help
      Prompt
* Reference state properly preserved (previously would incorrectly use new state
  for reference tests kept in store)
* Internal shimming of library/detach/attach more robust
* Updated tests for changes in testthat, R

## v1.0.0-1.0.9

### Improvement / Changes:

* More comprehensive state tracking and resetting:
    * options, random.seed, and wd are tracked in addition to search path
    * state is reset when reviewing tests as well as when executing them
    * you are alerted off state differences between new and reference tests
      on error
    * State control parameters are streamlined; API breaking
* Whether an expression is ignored or not is now a function of whether the
  expression returns visibly or not
* Pre and post test scripts
    * 'helper' directory renamed '_pre'
    * Can now use a '_post' directory to run cleanup
* Interactive environment cleanup
    * Display tweaks
    * Contextual help tweaks
* Vignette updates
* Demo update
* Added `Rdiff_obj` to run a `tools::Rdiff` directly on two R objects

### Internal:

* Reduced storage requirements for the `unitizer` stores
    * No longer storing assignments both as test value and object in environment
    * Calls recorded deparsed instead of as call objects
* Shimming used for search path tracking is more lightweight
* Text capture much more robust

### Issues Fixed:
  107, 106, 104, 103, 101, 99, 98, 94, 93, 90, 85, 84, 77, 74, 71, 67, 127, 115,
  132, 134

## v0.9.0

### Improvements / Changes:

* Complete restructure of internal test management to allow for much more robust
  `unitize_dir` behavior (#51)
* Added `testthat` -> `unitizer` translation utilities
  (see `?testthat_translate_file`)
* Can now pre-load objects before unitizing; `unitize_dir` and `unitize` by
  default auto-preload files in subdir 'helper'
* Renamed arg `env.clean` to `par.env` (technically API breaking, but since no
  one is using this package yet...)
* Many usability fixes (#48, #68, #82, #83), and improved text display
* Improved path inference to better guess desired unitizer based on partiallly
  specified file names (#72)

### Other

* `unitize_dir` works with empty dirs (#78)
* Better management of file locations and names (#35, #75)

## v0.8.1

### Bugfixes

* `review` now properly infers unitizer locations

## v0.8.0

### Improvements:

* Added ability to accept multiple tests at once (Issue #45, use wisely...)
* `unitize` can now infer partially specified test file names (in particular,
  will know to look in `pkgname/tests/unitizer`; see `?infer_unitizer_location`)
* `parse_with_comments` no longer run in non-interactive mode (#63)
* Test call now part of output of test object `show` method (#54)

### Bugfixes:

* Comments inside `unitizer_sect` preserved (#64)
* Ignored tests assigned to first non-ignored test section (#57)
* Prompt display issues (#65, #66)

### Internal:

* `search_path_cleanup` more robust (#59)
* `get_text_capture` tests added (#60)

## v0.7.1

### Improvements:

* Reduced test execution and parsing overhead
* Better handling of call recording for traceback and condition calls
* `editFunNames` becomes `editCalls` and provides more comprehensive editing of
  calls (Issue #52)

### Bufixes:

* Comment handling in calls (Issues #56, #58)
* Comment deparsing (Issues #39, #47, #52)

## v0.7.0

### Improvements:

* Failed tests now automatically output a snippet of new and reference objects
  (Issue #34)
* Text handling generally improved (better wrapping, etc. Issue #38)
* Parsing speed improved (Issue #15)
* Got rid of `get*` functions, instead, access test details with `.NEW`/`.REF`
  (Issue #29)
* Implemented `editFunNames` to allow user to modify stored calls in `unitizer`
  so that tests can be re-used even if function names are changed

## v0.6.5

Doc updates; should have been part of 0.6.4, but was too rushed to push...

## v0.6.4

### Improvements:

* Comment parsing faster (issue #15)

### Bugfixes:

* Reference section logic improved (assume fixes #36 until there is evidence
  against)
* Several parse errors fixed

### Other:

* Now depends on R 3.1.2 (not really, but that's what we are developing on and
  don't have bandwidth to test against multiple R versions)

## v0.6.3

### Bugfixes:

* stderr now show in `review` mode (issue #43)
* package startup messages suppressed (issue #23)
* small demo bug

## v0.6.2

### Bugfixes:

* Better whitespace wrapping in terminal mode (partially addresses #38)
* Can now drop all items in review mode (issue #37)
* Workaround an R parse bug (issue #41)
* `traceback()` now works for `stop(simpleError(...))` type stops

Behavior changes:

* History is only subbed out if you need to type input (issue #40)

#### v0.6.1

Minor release, no substantive changes.

### Bugfixes:

* Loading a `unitizer` no longer automatically modifies it through `upgrade`
* `upgrade` cleaned up and has tests now
* calling functions in form `pkg::fun` or `pkg:::fun` no longer causes problems
  when checking for ignoredness

### Behavior changes:

* `get` no longer warns if `unitizer` ids don't match

## v0.6.0

### New Features:

* Added a demo (`demo(unitizer)`)
* Broke up and updated vignettes
* `unitize_dir` allows you to run all tests in a directory (issue #24)
* `review` allows you to review and drop tests from an existing `unitizer` store
  (issue #21)
* Test navigation mechanism improved (issue #26)
    * Typing R at the unitizer prompt now allows you to review all tests
    * You can skip ahead too
* `unitize(..., force.update=TRUE)` will overwrite unitizer even if there were
  no changes recorded (issue #19)

### Behavior changes:

* `unitize` now runs with `search.path.clean=TRUE` by default

### Bugfixes:

* Comparison function warnings not captured (issue #14)
* Search path restoration error messages fixed (issue #22)
* Navigation regressions fixed (issue #30)

### Other:

Summary titles cleaned up, interative prompts made clearer, package reload warn
conflicts quieted (d2fe594c747, #23)

## v0.5.0

### New Features:

* Can now run tests in clean environment (i.e. objects from .GlobalEnv will not
  be visible) (issue #13)
* Can now run tests with clean search path (i.e. only the basic R libraries are
  loaded) (also issue #13), use `unitize(..., search.path.clean=TRUE)`
* New vignette "Reproducible Tests" discusses the above features

### Bugfixes:

* Expressions printed as tests evaluated now truncated corretly (issue #4)
* Incorrect displaying/hiding of ignored tests in some circumstances fixed

### Other Improvements:

* Summary no longer includes "removed" tests in matrix, since those are section-
  less
* Other minor clean-up of the interactive environment prompting

## v0.4.3

### Many interactive use bug fixes:

* LBB now parsed properly (issue #5)
* Non interactive parse (issue #11)
* Review and Back behavior consistent now in interactive use (issue #3)
* Other interactive use cleanup (issues #6, 12, 10, 9)
* Vignette now done properly

## v0.4.2

* Fixed setOldClass conflicts with RJSONIO (issue #1)
* Fixed run_ls not finding base env under certain circumstances (issue #2)
* Fixed conditionLists looping issue introduced when fixing issue #1
