% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt.R
\name{brick.wall}
\alias{brick.wall}
\alias{dwpt.brick.wall}
\alias{brick.wall.2d}
\title{Replace Boundary Wavelet Coefficients with Missing Values}
\usage{
brick.wall(x, wf, method = "modwt")

dwpt.brick.wall(x, wf, n.levels, method = "modwpt")

brick.wall.2d(x, method = "modwt")
}
\arguments{
\item{x}{DWT/MODWT/DWPT/MODWPT object}

\item{wf}{Character string; name of wavelet filter}

\item{method}{Either \code{\link{dwt}} or \code{\link{modwt}} for
\code{brick.wall}, or either \code{\link{dwpt}} or \code{\link{modwpt}} for
\code{dwpt.brick.wall}}

\item{n.levels}{Specifies the depth of the decomposition. This must be a
number less than or equal to log(length(x),2).}
}
\value{
Same object as \code{x} only with some missing values.
}
\description{
Sets the first \eqn{n} wavelet coefficients to \code{NA}.
}
\details{
The fact that observed time series are finite causes boundary issues.  One
way to get around this is to simply remove any wavelet coefficient computed
involving the boundary.  This is done here by replacing boundary wavelet
coefficients with \code{NA}.
}
\references{
Lindsay, R. W., D. B. Percival and D. A. Rothrock (1996). The
discrete wavelet transform and the scale anlaysis of the surface properties
of sea ice, \emph{IEEE Transactions on Geoscience and Remote Sensing},
\bold{34}, No. 3, 771-787.

Percival, D. B. and A. T. Walden (2000) \emph{Wavelet Methods for Time
Series Analysis}, Cambridge University Press.
}
\author{
B. Whitcher
}
\keyword{ts}
