% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{url_accessible}
\alias{url_accessible}
\title{Test if a URL is accessible}
\usage{
url_accessible(x, use_curl = !capabilities("libcurl"), ...)
}
\arguments{
\item{x}{A URL as a character string.}

\item{use_curl}{Whether to use the \pkg{curl} package or the
\code{curlGetHeaders()} function in base R to send the request to the URL.
By default, \pkg{curl} will be used when base R does not have the
\command{libcurl} capability (which should be rare).}

\item{...}{Arguments to be passed to \code{curlGetHeaders()}.}
}
\value{
\code{TRUE} or \code{FALSE}.
}
\description{
Try to send a \code{HEAD} request to a URL using
\code{\link{curlGetHeaders}()} or the \pkg{curl} package, and see if it
returns a successful status code.
}
\examples{
xfun::url_accessible("https://yihui.org")
}
