% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axTicksByTime.R
\name{axTicksByTime}
\alias{axTicksByTime}
\title{Compute x-Axis Tickmark Locations by Time}
\usage{
axTicksByTime(
  x,
  ticks.on = "auto",
  k = 1,
  labels = TRUE,
  format.labels = TRUE,
  ends = TRUE,
  gt = 2,
  lt = 30
)
}
\arguments{
\item{x}{An object indexed by time or a vector of times/dates.}

\item{ticks.on}{Time unit for tick locations.}

\item{k}{Frequency of tick locations.}

\item{labels}{Should a labeled vector be returned?}

\item{format.labels}{Either a logical value specifying whether labels should
be formatted, or a character string specifying the format to use.}

\item{ends}{Should the ends be adjusted?}

\item{gt}{Lower bound on number of tick locations.}

\item{lt}{Upper bound on number of tick locations.}
}
\value{
A numeric vector of index element locations where tick marks should
be drawn. These are \emph{locations} (e.g. 1, 2, 3, ...), \emph{not} the
index timestamps.

If possible, the result will be named using formatted values from the index
timestamps. The names will be used for the tick mark labels.
}
\description{
Compute x-axis tickmarks like \code{\link[=axTicks]{axTicks()}} in base but with respect to
time. This function is written for internal use, and documented for those
wishing to use it for customized plots.
}
\details{
The default \code{ticks.on = "auto"} uses heuristics to compute sensible tick
locations. Use a combination of \code{ticks.on} and \code{k} to create tick locations
at specific intervals. For example, \code{ticks.on = "days"} and \code{k = 7} will
create tick marks every 7 days.

When \code{format.labels} is a character string the possible values are the same
as those listed in the Details section of \code{\link[=strptime]{strptime()}}.
}
\examples{

data(sample_matrix)
axTicksByTime(as.xts(sample_matrix),'auto')
axTicksByTime(as.xts(sample_matrix),'weeks')
axTicksByTime(as.xts(sample_matrix),'months',7)

}
\seealso{
\code{\link[=endpoints]{endpoints()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
