% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflate.R
\name{inflate}
\alias{inflate}
\title{Uncompress a raw GZIP stream}
\usage{
inflate(buffer, pos = 1L, size = NULL)
}
\arguments{
\item{buffer}{Raw vector, containing the data to uncompress.}

\item{pos}{Start position of data to uncompress in \code{buffer}.}

\item{size}{Uncompressed size estimate, or \code{NULL}. If not given, or too
small, the output buffer is resized multiple times.}
}
\value{
Named list with three entries:
\itemize{
\item \code{output}: raw vector, the uncompressed data,
\item \code{bytes_read}: number of bytes used from \code{buffer},
\item \code{bytes_written}: number of bytes written to the output buffer.
}
}
\description{
Uncompress a raw GZIP stream
}
\examples{
data_gz <- deflate(charToRaw("Hello world!"))
inflate(data_gz$output)
}
\seealso{
\code{\link[base:memCompress]{base::memDecompress()}} does the same with \code{type = "gzip"},
but it does not tell you the number of bytes read from the input.
}
