// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerMonitor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.servermon {
  public class ServerMonitor_2_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor:2.0.1", null);

    public ServerMonitor_2_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ServerMonitor_2_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ServerMonitor_2_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ServerMonitor_2_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum ServerReachability {
      WAITING,
      REACHABLE,
      UNREACHABLE,
      ERROR,
    }

    public enum ServerPowerState {
      UNKNOWN,
      ON,
      OFF,
      SHUTTING_DOWN,
    }

    public enum ServerPowerControlResult {
      NO_ERROR,
      SHUTDOWN_CMD_FAILED,
      SWITCHING_OFF_FAILED,
      SWITCHING_ON_FAILED,
      POWER_CHECK_TIMEOUT,
    }

    public enum ServerPowerCheckMethod {
      TIMER,
      POWER_DROP,
    }

    public class ServerPowerSettings : ICloneable {
      public object Clone() {
        ServerPowerSettings copy = new ServerPowerSettings();
        copy.enabled = this.enabled;
        copy.target = this.target;
        copy.powerCheck = this.powerCheck;
        copy.powerThreshold = this.powerThreshold;
        copy.timeout = this.timeout;
        copy.shutdownCmd = this.shutdownCmd;
        copy.username = this.username;
        copy.password = this.password;
        copy.sshPort = this.sshPort;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["enabled"] = this.enabled;
        json["target"] = this.target != null ? this.target.Encode() : JsonValue.Null;
        json["powerCheck"] = (int)this.powerCheck;
        json["powerThreshold"] = this.powerThreshold;
        json["timeout"] = this.timeout;
        json["shutdownCmd"] = this.shutdownCmd;
        json["username"] = this.username;
        json["password"] = this.password;
        json["sshPort"] = this.sshPort;
        return json;
      }

      public static ServerPowerSettings Decode(LightJson.JsonObject json, Agent agent) {
        ServerPowerSettings inst = new ServerPowerSettings();
        inst.enabled = (bool)json["enabled"];
        inst.target = ObjectProxy.Decode(json["target"], agent);
        inst.powerCheck = (Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerCheckMethod)(int)json["powerCheck"];
        inst.powerThreshold = (double)json["powerThreshold"];
        inst.timeout = (int)json["timeout"];
        inst.shutdownCmd = (string)json["shutdownCmd"];
        inst.username = (string)json["username"];
        inst.password = (string)json["password"];
        inst.sshPort = (int)json["sshPort"];
        return inst;
      }

      public bool enabled = false;
      public ObjectProxy target = null;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerCheckMethod powerCheck = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerCheckMethod.TIMER;
      public double powerThreshold = 0.0;
      public int timeout = 0;
      public string shutdownCmd = "";
      public string username = "";
      public string password = "";
      public int sshPort = 0;
    }

    public class ServerSettings : ICloneable {
      public object Clone() {
        ServerSettings copy = new ServerSettings();
        copy.host = this.host;
        copy.enabled = this.enabled;
        copy.pingInterval = this.pingInterval;
        copy.retryInterval = this.retryInterval;
        copy.activationCount = this.activationCount;
        copy.failureCount = this.failureCount;
        copy.resumeDelay = this.resumeDelay;
        copy.resumeCount = this.resumeCount;
        copy.powerSettings = this.powerSettings;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["host"] = this.host;
        json["enabled"] = this.enabled;
        json["pingInterval"] = this.pingInterval;
        json["retryInterval"] = this.retryInterval;
        json["activationCount"] = this.activationCount;
        json["failureCount"] = this.failureCount;
        json["resumeDelay"] = this.resumeDelay;
        json["resumeCount"] = this.resumeCount;
        json["powerSettings"] = this.powerSettings.Encode();
        return json;
      }

      public static ServerSettings Decode(LightJson.JsonObject json, Agent agent) {
        ServerSettings inst = new ServerSettings();
        inst.host = (string)json["host"];
        inst.enabled = (bool)json["enabled"];
        inst.pingInterval = (int)json["pingInterval"];
        inst.retryInterval = (int)json["retryInterval"];
        inst.activationCount = (int)json["activationCount"];
        inst.failureCount = (int)json["failureCount"];
        inst.resumeDelay = (int)json["resumeDelay"];
        inst.resumeCount = (int)json["resumeCount"];
        inst.powerSettings = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerSettings.Decode(json["powerSettings"], agent);
        return inst;
      }

      public string host = "";
      public bool enabled = false;
      public int pingInterval = 0;
      public int retryInterval = 0;
      public int activationCount = 0;
      public int failureCount = 0;
      public int resumeDelay = 0;
      public int resumeCount = 0;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerSettings powerSettings = new Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerSettings();
    }

    public class ServerStatus : ICloneable {
      public object Clone() {
        ServerStatus copy = new ServerStatus();
        copy.powerState = this.powerState;
        copy.lastPowerControlResult = this.lastPowerControlResult;
        copy.reachable = this.reachable;
        copy.lastRequest = this.lastRequest;
        copy.lastResponse = this.lastResponse;
        copy.requests = this.requests;
        copy.responses = this.responses;
        copy.failures = this.failures;
        copy.resumes = this.resumes;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["powerState"] = (int)this.powerState;
        json["lastPowerControlResult"] = (int)this.lastPowerControlResult;
        json["reachable"] = (int)this.reachable;
        json["lastRequest"] = (this.lastRequest.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["lastResponse"] = (this.lastResponse.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["requests"] = this.requests;
        json["responses"] = this.responses;
        json["failures"] = this.failures;
        json["resumes"] = this.resumes;
        return json;
      }

      public static ServerStatus Decode(LightJson.JsonObject json, Agent agent) {
        ServerStatus inst = new ServerStatus();
        inst.powerState = (Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerState)(int)json["powerState"];
        inst.lastPowerControlResult = (Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult)(int)json["lastPowerControlResult"];
        inst.reachable = (Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerReachability)(int)json["reachable"];
        inst.lastRequest = new System.DateTime(json["lastRequest"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.lastResponse = new System.DateTime(json["lastResponse"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.requests = (int)json["requests"];
        inst.responses = (int)json["responses"];
        inst.failures = (int)json["failures"];
        inst.resumes = (int)json["resumes"];
        return inst;
      }

      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerState powerState = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerState.UNKNOWN;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult lastPowerControlResult = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult.NO_ERROR;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerReachability reachable = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerReachability.WAITING;
      public System.DateTime lastRequest = new System.DateTime(0);
      public System.DateTime lastResponse = new System.DateTime(0);
      public int requests = 0;
      public int responses = 0;
      public int failures = 0;
      public int resumes = 0;
    }

    public class ServerPowerStateEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerPowerStateEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int id = 0;
      public string host = "";
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerState oldPowerState = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerState.UNKNOWN;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerState newPowerState = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerState.UNKNOWN;
    }

    public class ServerPowerControlInitiatedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerPowerControlInitiatedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int id = 0;
      public string host = "";
      public bool on = false;
    }

    public class ServerPowerControlCompletedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerPowerControlCompletedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int id = 0;
      public string host = "";
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult result = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult.NO_ERROR;
    }

    public class ServerReachabilityEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerReachabilityEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int id = 0;
      public string host = "";
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerReachability reachable = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerReachability.WAITING;
    }

    public class ServerAddedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerAddedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int id = 0;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings = new Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings();
    }

    public class ServerSettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerSettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int id = 0;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings oldSettings = new Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings();
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings newSettings = new Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings();
    }

    public class ServerDeletedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerDeletedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int id = 0;
    }

    public class Server : ICloneable {
      public object Clone() {
        Server copy = new Server();
        copy.settings = this.settings;
        copy.status = this.status;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["settings"] = this.settings.Encode();
        json["status"] = this.status.Encode();
        return json;
      }

      public static Server Decode(LightJson.JsonObject json, Agent agent) {
        Server inst = new Server();
        inst.settings = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings.Decode(json["settings"], agent);
        inst.status = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerStatus.Decode(json["status"], agent);
        return inst;
      }

      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings = new Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings();
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerStatus status = new Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerStatus();
    }

    public const int ERR_NO_SUCH_ID = 1;

    public const int ERR_INVALID_SETTINGS = 2;

    public const int ERR_DUPLICATE_HOSTNAME = 3;

    public const int ERR_MAX_SERVERS_REACHED = 4;

    public class AddServerResult {
      public int _ret_;
      public int id;
    }

    public AddServerResult addServer(Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("addServer", _parameters);
      var _ret = new AddServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.id = (int)_result["id"];
      return _ret;
    }

    public AsyncRequest addServer(Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<AddServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addServer(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addServer(Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<AddServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addServer", _parameters,
        _result => {
          try {
            var _ret = new AddServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.id = (int)_result["id"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyServerResult {
      public int _ret_;
    }

    public ModifyServerResult modifyServer(int id, Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("modifyServer", _parameters);
      var _ret = new ModifyServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyServer(int id, Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<ModifyServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyServer(id, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyServer(int id, Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<ModifyServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyServer", _parameters,
        _result => {
          try {
            var _ret = new ModifyServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteServerResult {
      public int _ret_;
    }

    public DeleteServerResult deleteServer(int id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("deleteServer", _parameters);
      var _ret = new DeleteServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteServer(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteServer", _parameters,
        _result => {
          try {
            var _ret = new DeleteServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetServerResult {
      public int _ret_;
      public Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server server;
    }

    public GetServerResult getServer(int id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("getServer", _parameters);
      var _ret = new GetServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.server = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server.Decode(_result["server"], agent);
      return _ret;
    }

    public AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getServer(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getServer", _parameters,
        _result => {
          try {
            var _ret = new GetServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.server = Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server.Decode(_result["server"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListServersResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server> _ret_;
    }

    public ListServersResult listServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("listServers", _parameters);
      var _ret = new ListServersResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server>(_value["key"], Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest listServers(AsyncRpcResponse<ListServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listServers(AsyncRpcResponse<ListServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listServers", _parameters,
        _result => {
          try {
            var _ret = new ListServersResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server>(_value["key"], Com.Raritan.Idl.servermon.ServerMonitor_2_0_1.Server.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class PowerControlResult {
      public int _ret_;
    }

    public PowerControlResult powerControl(int id, bool on) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;
      _parameters["on"] = on;

      var _result = RpcCall("powerControl", _parameters);
      var _ret = new PowerControlResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest powerControl(int id, bool on, AsyncRpcResponse<PowerControlResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return powerControl(id, on, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest powerControl(int id, bool on, AsyncRpcResponse<PowerControlResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
        _parameters["on"] = on;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("powerControl", _parameters,
        _result => {
          try {
            var _ret = new PowerControlResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
