/**
 * @file yaml_parser_all.h
 *
 * @author John Wason, PhD
 *
 * @copyright Copyright 2023 Wason Technology, LLC
 *
 * @par License
 * Software License Agreement (Apache License)
 * @par
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * @par
 * http://www.apache.org/licenses/LICENSE-2.0
 * @par
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#include "action_parser.h"
#include "actuator_parser.h"
#include "bignum_parser.h"
#include "color_parser.h"
#include "datatype_parser.h"
#include "datetime_parser.h"
#include "datetime__clock_parser.h"
#include "device_parser.h"
#include "device__clock_parser.h"
#include "device__isoch_parser.h"
#include "eventlog_parser.h"
#include "fiducial_parser.h"
#include "geometry_parser.h"
#include "geometry__shapes_parser.h"
#include "geometryf_parser.h"
#include "geometryi_parser.h"
#include "gps_parser.h"
#include "hid__joystick_parser.h"
#include "identifier_parser.h"
#include "image_parser.h"
#include "imaging_parser.h"
#include "imaging__camerainfo_parser.h"
#include "imu_parser.h"
#include "laserscan_parser.h"
#include "laserscanner_parser.h"
#include "lighting_parser.h"
#include "objectrecognition_parser.h"
#include "octree_parser.h"
#include "param_parser.h"
#include "pid_parser.h"
#include "pointcloud_parser.h"
#include "pointcloud__sensor_parser.h"
#include "resource_parser.h"
#include "resource__device_parser.h"
#include "robotics__joints_parser.h"
#include "robotics__payload_parser.h"
#include "robotics__robot_parser.h"
#include "robotics__tool_parser.h"
#include "robotics__trajectory_parser.h"
#include "sensor_parser.h"
#include "sensordata_parser.h"
#include "servo_parser.h"
#include "signal_parser.h"
#include "units_parser.h"
#include "uuid_parser.h"
