use std::fmt::Display;

/// Severity associated with report and diff items
#[derive(Clone, Copy, Debug, PartialEq, PartialOrd)]
#[cfg_attr(feature = "cli", derive(clap::ValueEnum))]
#[non_exhaustive]
// keep in sync with the Python enum
pub enum Severity {
    /// Fatal problems that prevent further processing
    Fatal = 4,
    /// Probable errors that require manual investigation
    Error = 3,
    /// Potential issues that might or might not be harmless
    Warning = 2,
    /// Additional information provided for some situations
    Info = 1,
    /// Information only useful for debugging purposes
    Debug = 0,
}

impl Display for Severity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Severity::Fatal => write!(f, "fatal"),
            Severity::Error => write!(f, "error"),
            Severity::Warning => write!(f, "warning"),
            Severity::Info => write!(f, "info"),
            Severity::Debug => write!(f, "debug"),
        }
    }
}
