An associated item was specified more than once in a trait object.

Erroneous code example:

```compile_fail,E0719
trait FooTrait {}
trait BarTrait {}

// error: associated type `Item` in trait `Iterator` is specified twice
type Foo = dyn Iterator<Item = u32, Item = u32>;
```

To fix this, remove the duplicate specifier:

Corrected example:

```
type Foo = dyn Iterator<Item = u32>; // ok!
```

For more information about associated types, see [the book][bk-at]. For more
information on associated type bounds, see [RFC 2289][rfc-2289].

[bk-at]: https://doc.rust-lang.org/book/ch19-03-advanced-traits.html#specifying-placeholder-types-in-trait-definitions-with-associated-types
[rfc-2289]: https://rust-lang.github.io/rfcs/2289-associated-type-bounds.html
