# DO NOT EDIT THIS FILE!
#
# This file is generated from the CDP specification. If you need to make
# changes, edit the generator and regenerate all modules.
#
# CDP version: v0.0.1510116

from __future__ import annotations

from abc import ABC, ABCMeta, abstractmethod
from typing import TYPE_CHECKING, Any, TypeAlias, cast


if TYPE_CHECKING:
    from collections.abc import MutableMapping

    from typing_extensions import Self


T_JSON_DICT: TypeAlias = dict[str, Any]
_event_parsers: MutableMapping[str, type[CDPEvent]] = {}


class _CDPEventMetaBase(type):
    def __new__(
        cls,
        name,
        bases,
        namespace,
        event: str | None = None,
        **kwargs,
    ) -> _CDPEventMetaBase:
        obj = super().__new__(cls, name, bases, namespace, **kwargs)
        if event is not None:
            _event_parsers[event] = cast("type[CDPEvent]", obj)

        return obj


class _CDPEventMeta(_CDPEventMetaBase, ABCMeta):
    pass


class CDPEvent(ABC, metaclass=_CDPEventMeta):
    @classmethod
    @abstractmethod
    def from_json(cls, json: T_JSON_DICT) -> Self:  # pragma: no cover
        raise NotImplementedError


def parse_json_event(json: T_JSON_DICT) -> CDPEvent:
    """Parse a JSON dictionary into a CDP event."""
    return _event_parsers[json["method"]].from_json(json["params"])
