namespace tlfloat {
  namespace detail {
    static constexpr const char *sinCoefStr[] = {
      "0x1p+0",  // 1
      "0x1.55555555555555555555555555555555555555555555555555555555555555555p-3",  // 0.166667
      "0x1.11111111111111111111111111111111111111111111111111111111111111111p-7",  // 0.00833333
      "0x1.a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01ap-13",  // 0.000198413
      "0x1.71de3a556c7338faac1c88e500171de3a556c7338faac1c88e500171de3a556c7p-19",  // 2.75573e-06
      "0x1.ae64567f544e38fe747e4b837dc71e202b72f11b6aaac590f0129fef8e3a91f28p-26",  // 2.50521e-08
      "0x1.6124613a86d097ca38331d23af684d3b3757bf4471c732840d301a3425ee6a9fap-33",  // 1.6059e-10
      "0x1.ae7f3e733b81f11d8656b0ee8cafe91ebd5ec707db2878187199b98b26ed00c29p-41",  // 7.64716e-13
      "0x1.952c77030ad4a6b2605197771affea7748d1ac43a117079e890927198e0c3cf36p-49",  // 2.81146e-15
      "0x1.2f49b4681415724ca1ec3b7b9674b57eb741a062878d7ef76b1154a8d61e1ea73p-57",  // 8.22064e-18
      "0x1.71b8ef6dcf5718bef146fcee6e45218487a0757f6d2b4571e19b38e15309e5fa2p-66",  // 1.95729e-20
      "0x1.761b413163819d97b8704dd7f627984d6ff0465264584e5cf884c736f7f1bb2bap-75",  // 3.86817e-23
      "0x1.3f3ccdd165fa8d4e44a419776f10b893fff294c13014bdbff99dad68eee2c1da2p-84",  // 6.44695e-26
      "0x1.d1ab1c2dccea320a9a18f15d427734a0749e62d53e1ccbda09a68ca1d127c285p-94",  // 9.18369e-29
      "0x1.259f98b4358ad7abe30e7766f1291d666f5d9049ed27987f64aa97ba866741e76p-103",  // 1.131e-31
      "0x1.434d2e783f5bc42e1ee46fa6bfc3913b62f2db6e93b6e244b31ba1023acd155d7p-113",  // 1.21613e-34
      "0x1.3981254dd0d51b5382cdffa974227d50dc124925687348048ea66d958e5a43436p-123",  // 1.15163e-37
      "0x1.0dc59c716d91f2833c7f5a7e0623b3afda3303ff7d9742b4532af69b5e875343ep-133",  // 9.67759e-41
      "0x1.9ec8d1c94e85af4c78b15c3d89d2f3fcb2a927344305c831b36193c49a9107539p-144",  // 7.26546e-44
      "0x1.1e99449a4bacde0104476aeb4c3ab2f3022f1749c497dc344e5775a5e6d373f61p-154",  // 4.90247e-47
      "0x1.65e61c39d0240c7e25cfd1b1b2dca885a152887a1738054011e8d8d92a3dc1833p-165",  // 2.98931e-50
      "0x1.95db45257e5122dcbae56def3720370619e16b6b8c9493b419fab93c928f2c86p-176",  // 1.65521e-53
      "0x1.a3cb8722206478e02c5e91c64cabec5f43a03d75f74a8d65fce02aa71f1773defp-187",  // 8.35965e-57
      "0x1.8da8e0a127eb9b78b454d8b628e52abe2d969b50b8fe645081a8890682562822fp-198",  // 3.86663e-60
      "0x1.5a42f0dfeb085d94a3fd410e1231c72d6f18e8c3ad46004619d32fe9cdca266e9p-209",  // 1.64397e-63
      "0x1.161872bf7b8233772d91c5d112d44064bd9e588eb2eaeb2337e0d3f566d55a7fcp-220",  // 6.44696e-67
      "0x1.9d4f1058674df40f206da45356515f54b343c3e4ccf98ffed6939f55aec0fd65dp-232",  // 2.33925e-70
    };

    static constexpr const char *cosCoefStr[] = {
      "0x1p+0",  // 1
      "0x1p-1",  // 0.5
      "0x1.55555555555555555555555555555555555555555555555555555555555555555p-5",  // 0.0416667
      "0x1.6c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16cp-10",  // 0.00138889
      "0x1.a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01ap-16",  // 2.48016e-05
      "0x1.27e4fb7789f5c72ef016d3ea6678e4b61ddf05c2d95567d3a50ccdf4b1c84456cp-22",  // 2.75573e-07
      "0x1.1eed8eff8d897b544da987acfe84bec01cf74b679c71d90b4ab7154a5ed1b6a1bp-29",  // 2.08768e-09
      "0x1.93974a8c07c9d20badf145dfa3e4ea8cd188da975d75f096ea801df2747e30b67p-37",  // 1.14707e-11
      "0x1.ae7f3e733b81f11d8656b0ee8cafe91ebd5ec707db2878187199b98b26ed00c29p-45",  // 4.77948e-14
      "0x1.6827863b97d977bb004886a2c2aa9786799dee7500f806c5cf2494887e43c4669p-53",  // 1.56192e-16
      "0x1.e542ba402022507a9cad2bf8f0babbfdf2029a373f48cb25781bbaa7bcfcfdd85p-62",  // 4.11032e-19
      "0x1.0ce396db7f8529450c90b7f338ec7577a874b28b381f7852d29f6f2f8235be876p-70",  // 8.89679e-22
      "0x1.f2cf01972f577cca4b4067ca9d8a20673feb086ddb20687bf6065ef3f5424ee4ep-80",  // 1.61174e-24
      "0x1.88e85fc6a4e59a38f2050ba6b01494676265a363ec684bfff82486a888798c203p-89",  // 2.4796e-27
      "0x1.0a18a2635085d373c5c51c354a8d42a4d4eccac2feebe233733a998109cd93b9bp-98",  // 3.27989e-30
      "0x1.3932c5047d60e60caded4c2989c574b187db44931f192b328d82c3fa28f6acb29p-108",  // 3.76999e-33
      "0x1.434d2e783f5bc42e1ee46fa6bfc3913b62f2db6e93b6e244b31ba1023acd155d7p-118",  // 3.80039e-36
      "0x1.2710231c0fd7a13f8a2b4af9d6b70c8856a7cc5f715d70f53af6fdb9ef6403124p-128",  // 3.38716e-39
      "0x1.df983290c2ca92b06b8d12a7275bea1c2e9395546d7eaf797768d2db52b7b078ap-139",  // 2.68822e-42
      "0x1.5d4acb9c0c3aae913d370a4ec4e78a182aa96461e799145fbf7a97623151b553ep-149",  // 1.91196e-45
      "0x1.ca8ed42a12ae3001a07244abad2ab7eb36b1bedc6dbfc6ba16f255d63e1f1ff01p-160",  // 1.22562e-48
      "0x1.10af527530de836c4d9225dcb909a4f81963742c4273d33d01747474b27831eap-170",  // 7.11741e-52
      "0x1.272b1b03fec6a4fd9f327e7f6de8e232fb8cab36f1e06b6bb5cd9dfd81dc7d78cp-181",  // 3.76184e-55
      "0x1.240804f65951062ca46e4f25c6084b63a97a9a0f47dad1ab1f37c4a0c7b74579bp-192",  // 1.81732e-58
      "0x1.091b406b6ff267a5cd8de5cec5ee1c7ec90f1235d0a99835abc5b0af018ec56cap-203",  // 8.05548e-62
      "0x1.bb36f6e12cd78205f0a05345360246a08e345d236d2666c0210e51cf1be4083bap-215",  // 3.28795e-65
      "0x1.56457989358c8e1c86dacc15037b62f224741e3979beab3f09b23ff2f4b7d1d85p-226",  // 1.2398e-68
      "0x1.e9d8f6ed83ea9c83b4a7df335cd23818889c2a8a6e31425d70174194f50aa7952p-238",  // 4.33194e-72
    };

    static constexpr const char *tanCoefStr[] = {
      "0x1p+0",  // 1
      "0x1.55555555555555555555555555555555555555555555555555555555555555555p-2",  // 0.333333
      "0x1.11111111111111111111111111111111111111111111111111111111111111111p-3",  // 0.133333
      "0x1.ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1ba1bap-5",  // 0.0539683
      "0x1.664f4882c10f9f32d6bba49dd81664f4882c10f9f32d6bba49dd81664f4882c1p-6",  // 0.0218695
      "0x1.226e355e6c23c8f5b51c3974fb201d943551d033403abcd18e00916ce73a05fc6p-7",  // 0.00886324
      "0x1.d6d3d0e157ddfb5fcc0da5c9a3ccbf7803392d31f0f1e489aed531efa6d26e87fp-9",  // 0.00359213
      "0x1.7da36452b75e2b6a1d935e8b44c332e280ce9b23015763f9a2e6a037d980b9255p-10",  // 0.00145583
      "0x1.355824803674452236558fc7c8c4fa131ee47a6efb5bcc8488abdd1852d67f1e8p-11",  // 0.000590027
      "0x1.f57d7734d166421aab5227996a014ee33533957a54b46573823e26625e6342897p-13",  // 0.000239129
      "0x1.967e18afcafac8a27ad6f4aec67c988153224339d65502fc723bdbedebd085423p-14",  // 9.69154e-05
      "0x1.497d8eea2525933e5a05c9a50c6421139aedab67102ccb01abed979489a855ccep-15",  // 3.92783e-05
      "0x1.0b132d39a60504ec9d30b0658500bf1949290cf2324e41fcc351d9c6574b60b28p-16",  // 1.59189e-05
      "0x1.b0f72d3ee24e922d11bbab2ac11e2eba4af0306249bcb930bb58b0113e21d2579p-18",  // 6.45169e-06
      "0x1.5ef2da474e5b6c7b3c5028bb861fa405ca59dc51e637c80297bd77c8e44004b8dp-19",  // 2.61477e-06
      "0x1.1c77df95c1c0d02dc9139620f15ba7a8ac4fc1a4e8925de5e9f6908d90d78776bp-20",  // 1.05973e-06
      "0x1.cd299de4ae6bb384dfb0d8b8d524ebda3c47ff027d158d4dc1f56acbc56357845p-22",  // 4.29491e-07
      "0x1.75cde6563fed8e86fb51ef870af5f42e294d35c9d7a3de838d564c79c8041626bp-23",  // 1.74066e-07
      "0x1.2efe8db3aff1f23114006472b898a2a16d216a7897780f92c0b4105f63325742dp-24",  // 7.05464e-08
      "0x1.eb3229047434bca678aab17c61a99ba2a33aa5291c045f64c3f8904afbd676ba5p-26",  // 2.85914e-08
      "0x1.8e25ff9327e2b98b1141fe7f008ea28771332489c0d52ecb35be9ef1393114c87p-27",  // 1.15876e-08
      "0x1.42ba1a349b4901148f65da823d34eb19beab79bd676ba12dcb664f7b016326d3dp-28",  // 4.6963e-09
      "0x1.0597b61cb3092292027ce60a84edabdb6c9c6a4b7302e0adb75164831e95ea83p-29",  // 1.90334e-09
      "0x1.a813f6eaa7058527550642834433baebc467a339f0d50e5b96d9f8ca557c1fbc7p-31",  // 7.71393e-10
      "0x1.57bea2950f11e4282ba8d79e4a096024115aae4da54d3b6dc85d3a71371cd7707p-32",  // 3.12634e-10
      "0x1.16a101c5fde961fd1dd595ffe284dd729619804411fe8fe27d0cf7cc4ba294314p-33",  // 1.26706e-10
    };

    static constexpr const char *atanCoefStr[] = {
      "0x1p+0",  // 1
      "-0x1.55555555555555555555555555555555555555555555555555555555555555555p-2",  // -0.333333
      "0x1.99999999999999999999999999999999999999999999999999999999999999999p-3",  // 0.2
      "-0x1.24924924924924924924924924924924924924924924924924924924924924924p-3",  // -0.142857
      "0x1.c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c7p-4",  // 0.111111
      "-0x1.745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1p-4",  // -0.0909091
      "0x1.3b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13bp-4",  // 0.0769231
      "-0x1.11111111111111111111111111111111111111111111111111111111111111111p-4",  // -0.0666667
      "0x1.e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1ep-5",  // 0.0588235
      "-0x1.af286bca1af286bca1af286bca1af286bca1af286bca1af286bca1af286bca1afp-5",  // -0.0526316
      "0x1.86186186186186186186186186186186186186186186186186186186186186186p-5",  // 0.047619
      "-0x1.642c8590b21642c8590b21642c8590b21642c8590b21642c8590b21642c8590b2p-5",  // -0.0434783
      "0x1.47ae147ae147ae147ae147ae147ae147ae147ae147ae147ae147ae147ae147ae1p-5",  // 0.04
      "-0x1.2f684bda12f684bda12f684bda12f684bda12f684bda12f684bda12f684bda12fp-5",  // -0.037037
      "0x1.1a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611ap-5",  // 0.0344828
      "-0x1.08421084210842108421084210842108421084210842108421084210842108421p-5",  // -0.0322581
      "0x1.f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1p-6",  // 0.030303
      "-0x1.d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d4p-6",  // -0.0285714
      "0x1.bacf914c1bacf914c1bacf914c1bacf914c1bacf914c1bacf914c1bacf914c1bap-6",  // 0.027027
      "-0x1.a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a4p-6",  // -0.025641
      "0x1.8f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c1p-6",  // 0.0243902
      "-0x1.7d05f417d05f417d05f417d05f417d05f417d05f417d05f417d05f417d05f417dp-6",  // -0.0232558
      "0x1.6c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16cp-6",  // 0.0222222
    };

    static constexpr const char *expCoefStr[] = {
      "0x1p+0",  // 1
      "0x1p+0",  // 1
      "0x1p-1",  // 0.5
      "0x1.55555555555555555555555555555555555555555555555555555555555555555p-3",  // 0.166667
      "0x1.55555555555555555555555555555555555555555555555555555555555555555p-5",  // 0.0416667
      "0x1.11111111111111111111111111111111111111111111111111111111111111111p-7",  // 0.00833333
      "0x1.6c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16cp-10",  // 0.00138889
      "0x1.a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01ap-13",  // 0.000198413
      "0x1.a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01ap-16",  // 2.48016e-05
      "0x1.71de3a556c7338faac1c88e500171de3a556c7338faac1c88e500171de3a556c7p-19",  // 2.75573e-06
      "0x1.27e4fb7789f5c72ef016d3ea6678e4b61ddf05c2d95567d3a50ccdf4b1c84456cp-22",  // 2.75573e-07
      "0x1.ae64567f544e38fe747e4b837dc71e202b72f11b6aaac590f0129fef8e3a91f28p-26",  // 2.50521e-08
      "0x1.1eed8eff8d897b544da987acfe84bec01cf74b679c71d90b4ab7154a5ed1b6a1bp-29",  // 2.08768e-09
      "0x1.6124613a86d097ca38331d23af684d3b3757bf4471c732840d301a3425ee6a9fap-33",  // 1.6059e-10
      "0x1.93974a8c07c9d20badf145dfa3e4ea8cd188da975d75f096ea801df2747e30b67p-37",  // 1.14707e-11
      "0x1.ae7f3e733b81f11d8656b0ee8cafe91ebd5ec707db2878187199b98b26ed00c29p-41",  // 7.64716e-13
      "0x1.ae7f3e733b81f11d8656b0ee8cafe91ebd5ec707db2878187199b98b26ed00c29p-45",  // 4.77948e-14
      "0x1.952c77030ad4a6b2605197771affea7748d1ac43a117079e890927198e0c3cf36p-49",  // 2.81146e-15
      "0x1.6827863b97d977bb004886a2c2aa9786799dee7500f806c5cf2494887e43c4669p-53",  // 1.56192e-16
      "0x1.2f49b4681415724ca1ec3b7b9674b57eb741a062878d7ef76b1154a8d61e1ea73p-57",  // 8.22064e-18
      "0x1.e542ba402022507a9cad2bf8f0babbfdf2029a373f48cb25781bbaa7bcfcfdd85p-62",  // 4.11032e-19
      "0x1.71b8ef6dcf5718bef146fcee6e45218487a0757f6d2b4571e19b38e15309e5fa2p-66",  // 1.95729e-20
      "0x1.0ce396db7f8529450c90b7f338ec7577a874b28b381f7852d29f6f2f8235be876p-70",  // 8.89679e-22
      "0x1.761b413163819d97b8704dd7f627984d6ff0465264584e5cf884c736f7f1bb2bap-75",  // 3.86817e-23
      "0x1.f2cf01972f577cca4b4067ca9d8a20673feb086ddb20687bf6065ef3f5424ee4ep-80",  // 1.61174e-24
      "0x1.3f3ccdd165fa8d4e44a419776f10b893fff294c13014bdbff99dad68eee2c1da2p-84",  // 6.44695e-26
      "0x1.88e85fc6a4e59a38f2050ba6b01494676265a363ec684bfff82486a888798c203p-89",  // 2.4796e-27
      "0x1.d1ab1c2dccea320a9a18f15d427734a0749e62d53e1ccbda09a68ca1d127c285p-94",  // 9.18369e-29
      "0x1.0a18a2635085d373c5c51c354a8d42a4d4eccac2feebe233733a998109cd93b9bp-98",  // 3.27989e-30
      "0x1.259f98b4358ad7abe30e7766f1291d666f5d9049ed27987f64aa97ba866741e76p-103",  // 1.131e-31
      "0x1.3932c5047d60e60caded4c2989c574b187db44931f192b328d82c3fa28f6acb29p-108",  // 3.76999e-33
      "0x1.434d2e783f5bc42e1ee46fa6bfc3913b62f2db6e93b6e244b31ba1023acd155d7p-113",  // 1.21613e-34
      "0x1.434d2e783f5bc42e1ee46fa6bfc3913b62f2db6e93b6e244b31ba1023acd155d7p-118",  // 3.80039e-36
      "0x1.3981254dd0d51b5382cdffa974227d50dc124925687348048ea66d958e5a43436p-123",  // 1.15163e-37
      "0x1.2710231c0fd7a13f8a2b4af9d6b70c8856a7cc5f715d70f53af6fdb9ef6403124p-128",  // 3.38716e-39
      "0x1.0dc59c716d91f2833c7f5a7e0623b3afda3303ff7d9742b4532af69b5e875343ep-133",  // 9.67759e-41
      "0x1.df983290c2ca92b06b8d12a7275bea1c2e9395546d7eaf797768d2db52b7b078ap-139",  // 2.68822e-42
      "0x1.9ec8d1c94e85af4c78b15c3d89d2f3fcb2a927344305c831b36193c49a9107539p-144",  // 7.26546e-44
    };

    static constexpr const char *logCoefStr[] = {
      "0x1p+1",  // 2
      "0x1.55555555555555555555555555555555555555555555555555555555555555555p-1",  // 0.666667
      "0x1.99999999999999999999999999999999999999999999999999999999999999999p-2",  // 0.4
      "0x1.24924924924924924924924924924924924924924924924924924924924924924p-2",  // 0.285714
      "0x1.c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c7p-3",  // 0.222222
      "0x1.745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1745d1p-3",  // 0.181818
      "0x1.3b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13b13bp-3",  // 0.153846
      "0x1.11111111111111111111111111111111111111111111111111111111111111111p-3",  // 0.133333
      "0x1.e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1e1ep-4",  // 0.117647
      "0x1.af286bca1af286bca1af286bca1af286bca1af286bca1af286bca1af286bca1afp-4",  // 0.105263
      "0x1.86186186186186186186186186186186186186186186186186186186186186186p-4",  // 0.0952381
      "0x1.642c8590b21642c8590b21642c8590b21642c8590b21642c8590b21642c8590b2p-4",  // 0.0869565
      "0x1.47ae147ae147ae147ae147ae147ae147ae147ae147ae147ae147ae147ae147ae1p-4",  // 0.08
      "0x1.2f684bda12f684bda12f684bda12f684bda12f684bda12f684bda12f684bda12fp-4",  // 0.0740741
      "0x1.1a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611a7b9611ap-4",  // 0.0689655
      "0x1.08421084210842108421084210842108421084210842108421084210842108421p-4",  // 0.0645161
      "0x1.f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1f07c1p-5",  // 0.0606061
      "0x1.d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d41d4p-5",  // 0.0571429
      "0x1.bacf914c1bacf914c1bacf914c1bacf914c1bacf914c1bacf914c1bacf914c1bap-5",  // 0.0540541
      "0x1.a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a4p-5",  // 0.0512821
      "0x1.8f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c18f9c1p-5",  // 0.0487805
      "0x1.7d05f417d05f417d05f417d05f417d05f417d05f417d05f417d05f417d05f417dp-5",  // 0.0465116
      "0x1.6c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16cp-5",  // 0.0444444
      "0x1.5c9882b9310572620ae4c415c9882b9310572620ae4c415c9882b9310572620aep-5",  // 0.0425532
      "0x1.4e5e0a72f05397829cbc14e5e0a72f05397829cbc14e5e0a72f05397829cbc14ep-5",  // 0.0408163
      "0x1.41414141414141414141414141414141414141414141414141414141414141414p-5",  // 0.0392157
      "0x1.3521cfb2b78c13521cfb2b78c13521cfb2b78c13521cfb2b78c13521cfb2b78c1p-5",  // 0.0377358
      "0x1.29e4129e4129e4129e4129e4129e4129e4129e4129e4129e4129e4129e4129e41p-5",  // 0.0363636
      "0x1.1f7047dc11f7047dc11f7047dc11f7047dc11f7047dc11f7047dc11f7047dc11fp-5",  // 0.0350877
      "0x1.15b1e5f75270d0456c797dd49c34115b1e5f75270d0456c797dd49c34115b1e5fp-5",  // 0.0338983
      "0x1.0c9714fbcda3ac10c9714fbcda3ac10c9714fbcda3ac10c9714fbcda3ac10c971p-5",  // 0.0327869
      "0x1.04104104104104104104104104104104104104104104104104104104104104104p-5",  // 0.031746
      "0x1.f81f81f81f81f81f81f81f81f81f81f81f81f81f81f81f81f81f81f81f81f81f8p-6",  // 0.0307692
      "0x1.e9131abf0b7672a07a44c6afc2dd9ca81e9131abf0b7672a07a44c6afc2dd9ca8p-6",  // 0.0298507
      "0x1.dae6076b981dae6076b981dae6076b981dae6076b981dae6076b981dae6076b98p-6",  // 0.0289855
    };

    static constexpr const char *cbrtCoefStr[] = {
      "0x1p+0",  // 1
      "-0x1.55555555555555555555555555555555555555555555555555555555555555555p-2",  // -0.333333
      "0x1.c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c71c7p-3",  // 0.222222
      "-0x1.61f9add3c0ca4587e6b74f0329161f9add3c0ca4587e6b74f0329161f9add3c0cp-3",  // -0.17284
      "0x1.26fabb85cb5339f140436c82a23d1a5663075fde49beaee172d4ce7c5010db20ap-3",  // 0.144033
      "-0x1.ff4c33f8fa07b9c44d41ab0490ae2da6cdc88409d528625393d743c668a5c0167p-4",  // -0.124829
    };

    static constexpr const char *gammaCoefStr[] = {
      "0x1.55555555555555555555555555555555555555555555555555555555555555555p-4",  // 0.0833333
      "-0x1.6c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16c16cp-9",  // -0.00277778
      "0x1.a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01a01ap-11",  // 0.000793651
      "-0x1.38138138138138138138138138138138138138138138138138138138138138138p-11",  // -0.000595238
      "0x1.b951e2b18ff23570ea73806e5478ac63fc8d5c3a9ce01b951e2b18ff23570ea73p-11",  // 0.000841751
      "-0x1.f6ab0d9993c7c81f6ab0d9993c7c81f6ab0d9993c7c81f6ab0d9993c7c81f6abp-10",  // -0.00191753
      "0x1.a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a41a4p-8",  // 0.00641026
      "-0x1.e4286cb0f5397dc2064a8ed3175b9fe4286cb0f5397dc2064a8ed3175b9fe4286p-6",  // -0.0295507
      "0x1.6fe96381e067ffa1876fe96381e067ffa1876fe96381e067ffa1876fe96381e06p-3",  // 0.179644
      "-0x1.6476701181f39edbdb9ce625987d4c0e9162983e954e04476701181f39edbdb9cp+0",  // -1.39243
      "0x1.ace44322ce005a74f53910c8b380169d3d4e44322ce005a74f53910c8b380169dp+3",  // 13.4029
      "-0x1.39b2525cccc1aab67ee25d73c0f9473b68952525cccc1aab67ee25d73c0f9473bp+7",  // -156.848
      "0x1.12234e81b4e81b4e81b4e81b4e81b4e81b4e81b4e81b4e81b4e81b4e81b4e81b4p+11",  // 2193.1
      "-0x1.1a198ae1c4ab7eb3feddd849691fe36729b25c5fa4a108591aa839b7978d16bbdp+15",  // -36108.8
      "0x1.51a2089a6e11a38433dc9fb888d3995db9600d30469ab0572c127abdcac58108dp+19",  // 691472
      "-0x1.d1089b142d3577880c2d3577880c2d3577880c2d3577880c2d3577880c2d35778p+23",  // -1.52382e+07
      "0x1.6d29a0f6433b79890cede62433b79890cede62433b79890cede62433b79890cedp+28",  // 3.82901e+08
      "-0x1.445119d9e466ed5d4c049ab892ec2c69b51180f27e0f43f1e60cd6fd4a438b9bbp+33",  // -1.08823e+10
      "0x1.43779bc9d4024e6a171024e6a171024e6a171024e6a171024e6a171024e6a171p+38",  // 3.4732e+11
      "-0x1.6800b7bc07a8c854486b02e295ec854486b02e295ec854486b02e295ec854486bp+43",  // -1.23696e+13
      "0x1.bc8cd6f8f1f755c78753cdb5d5c8db31ddd9593d0ae7da3d55812a5a765b9ebafp+48",  // 4.88788e+14
      "-0x1.2efaec50eee5379680a13e9fb108c896e406f8bc2a2cc36997aad26cf51c74b9p+54",  // -2.13203e+16
      "0x1.c5c266feb5e17db216d6146a5a9e66b907b4cb2fa644d4de8d74a474098596889p+59",  // 1.02178e+18
      "-0x1.73c1280b15b1202d69f25ff30d9bdd4413b1b1035a8ae2ac3ea14fa61e9675192p+65",  // -5.35755e+19
      "0x1.4befddf3ce358f90064d5699917e7ef88f1e8e2b610c81d2167b2bdaa31141b3bp+71",  // 3.06158e+21
      "-0x1.41df01caf2a81099b4c924b8d90c9234d29bdde119739d7a0e2e61e78a27f1333p+77",  // -1.89999e+23
      "0x1.51d7fc91b42fbb332f20ec1619c04add8eb0f2f7e904d200cd74ee21a90463d06p+83",  // 1.27634e+25
      "-0x1.7eb054866aadf62e4992b56ad97d85de77436bde251628f048136e6f8f2d97d85p+89",  // -9.25285e+26
      "0x1.d28166e47cd8fa1ceee1cce20862db968b81d6f1d0dad3abdbf7fb54c66d0ee5p+95",  // 7.21882e+28
      "-0x1.31342a0d12ce4cc7f198769e8a306bc22e9631937ac14fa96b8e7d039ab9dc374p+102",  // -6.04518e+30
      "0x1.ab9d9181cb599fdab1f7db2b872005987b1a9448be405987b1a9448be405987b1p+108",  // 5.42067e+32
      "-0x1.400a6d954abb28dc25cb7384e71e1b1a99958544402feeeada99958544402feeep+115",  // -5.19296e+34
      "0x1.feb94900e31a08f00a73200abc4e59d9826bcbb3431848c6801ceb0c52be31b39p+121",  // 5.30366e+36
      "-0x1.b1959bd1fa84a486a39cca5b435920df12e1b004135bf4cac31ed2676b3d63991p+128",  // -5.76333e+38
      "0x1.86eb77e97a0097e8da4c14c29ffba6dafac985398a2a50786c12225f1a19d211ap+135",  // 6.65116e+40
      "-0x1.75a66c437f64a59273b1d1e2d66f326cb2c4a8eee9a081265e60576553decf60bp+142",  // -8.13738e+42
    };
  }
}
