// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQRDMLAH_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SQRDMLAH_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sqrdmlah_4S[] = {
  0x00000000, 0x00000001, 0x00007ffc, 0x00000020,
  0x00000000, 0x00000080, 0x00000002, 0x00000020,
  0x0000007e, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000082, 0x00000020,
  0x00000000, 0x00000001, 0x00000082, 0x00000020,
  0x00000000, 0x00000001, 0x00000082, 0x00000020,
  0x00000000, 0x00000001, 0x00333202, 0x00000020,
  0x00000000, 0x000032ce, 0x00555357, 0x00000020,
  0x00003266, 0x000054ac, 0x007ffd02, 0x00000020,
  0x00005400, 0x00007f01, 0x007ffd02, 0x00000020,
  0x00007e00, 0x00007f01, 0x007ffd02, 0x00000020,
  0x00007e00, 0x00007f01, 0xff800302, 0x00000020,
  0x00007e00, 0xffff8101, 0xff800302, 0x00000020,
  0xffff8200, 0xffff8101, 0xffaaacad, 0x00000020,
  0xffff8200, 0xffffab56, 0xffccce02, 0x00000020,
  0xffffac00, 0xffffcd34, 0xffffff82, 0x00000020,
  0xffffcd9a, 0x00000001, 0xffffff82, 0x00000020,
  0x00000000, 0x00000001, 0xffffff82, 0x00000020,
  0x00000000, 0x00000001, 0xffffff82, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000081, 0x00000002, 0x00000020,
  0x00000000, 0x00000081, 0x00000002, 0x00000020,
  0x00000000, 0x00000081, 0x00000002, 0x00000021,
  0x00000000, 0x00333201, 0x00000002, 0x00000021,
  0x000032cd, 0x00555356, 0x00000002, 0x00000021,
  0x000054ab, 0x007ffd01, 0x00000002, 0x00000021,
  0x00007f00, 0x007ffd01, 0x00000002, 0x0000001f,
  0x00007f00, 0x007ffd01, 0x00000002, 0x0000001f,
  0x00007f00, 0xff800301, 0x00000002, 0x0000001f,
  0xffff8100, 0xff800301, 0x00000002, 0x00000020,
  0xffff8100, 0xffaaacac, 0x00000002, 0x00000020,
  0xffffab55, 0xffccce01, 0x00000002, 0x00000020,
  0xffffcd33, 0xffffff81, 0x00000002, 0x00000020,
  0x00000000, 0xffffff81, 0x00000002, 0x00000020,
  0x00000000, 0xffffff81, 0x00000002, 0x00000020,
  0x00000000, 0xffffff81, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000080, 0x00000001, 0x00000002, 0x00000021,
  0x00000080, 0x00000001, 0x00000002, 0x00000021,
  0x00000080, 0x00000001, 0x00000003, 0x00000022,
  0x00333200, 0x00000001, 0x00000003, 0x00000022,
  0x00555355, 0x00000001, 0x00000003, 0x00000022,
  0x007ffd00, 0x00000001, 0x00000003, 0x0000001e,
  0x007ffd00, 0x00000001, 0x00000001, 0x0000001e,
  0x007ffd00, 0x00000001, 0x00000001, 0x0000001f,
  0xff800300, 0x00000001, 0x00000001, 0x0000001f,
  0xff800300, 0x00000001, 0x00000002, 0x00000020,
  0xffaaacab, 0x00000001, 0x00000002, 0x00000020,
  0xffccce00, 0x00000001, 0x00000002, 0x00000020,
  0xffffff80, 0x00000001, 0x00000002, 0x00000020,
  0xffffff80, 0x00000001, 0x00000002, 0x00000020,
  0xffffff80, 0x00000001, 0x00000002, 0x00000020,
  0xffffff80, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x0000002d,
  0x00000000, 0x00000001, 0x00000003, 0x00000035,
  0x00000000, 0x00000001, 0x00000003, 0x00000040,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000004, 0x00000000,
  0x00000000, 0x00000002, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x0000000b,
  0x00000000, 0x00000000, 0x00000001, 0x00000013,
  0x00000000, 0x00000000, 0x00000001, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x0000000f, 0x00000073,
  0x00000000, 0x00000002, 0x00000017, 0x0000009d,
  0x00000000, 0x00000002, 0x00000022, 0x0000009d,
  0x00000001, 0x00000003, 0x00000022, 0x0000009d,
  0x00000001, 0x00000003, 0x00000022, 0xffffffa3,
  0x00000001, 0x00000003, 0xffffffe2, 0xffffffa3,
  0x00000001, 0xffffffff, 0xffffffe2, 0xffffffcd,
  0xffffffff, 0xffffffff, 0xffffffed, 0xffffffee,
  0xffffffff, 0x00000000, 0xfffffff5, 0x00000020,
  0xffffffff, 0x00000000, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x00000034, 0x00000074,
  0x00000000, 0x0000000e, 0x00000055, 0x0000009e,
  0x00000001, 0x00000016, 0x0000007f, 0x0000009e,
  0x00000001, 0x00000021, 0x0000007f, 0x0000009e,
  0x00000002, 0x00000021, 0x0000007f, 0xffffffa2,
  0x00000002, 0x00000021, 0xffffff85, 0xffffffa2,
  0x00000002, 0xffffffe1, 0xffffff85, 0xffffffcc,
  0xfffffffe, 0xffffffe1, 0xffffffaf, 0xffffffee,
  0xfffffffe, 0xffffffec, 0xffffffd0, 0x00000020,
  0xffffffff, 0xfffffff4, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000053,
  0x00000000, 0x00000001, 0x00000034, 0x00000075,
  0x00000000, 0x00000033, 0x00000056, 0x0000009f,
  0x0000000d, 0x00000054, 0x00000080, 0x0000009f,
  0x00000015, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000020, 0x0000007e, 0x00000080, 0xffffffa1,
  0x00000020, 0x0000007e, 0xffffff84, 0xffffffa1,
  0x00000020, 0xffffff84, 0xffffff84, 0xffffffcb,
  0xffffffe0, 0xffffff84, 0xffffffae, 0xffffffed,
  0xffffffe0, 0xffffffae, 0xffffffd0, 0x00000020,
  0xffffffeb, 0xffffffcf, 0x00000002, 0x00000020,
  0xfffffff3, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00003352,
  0x00000000, 0x00000001, 0x00000035, 0x00005573,
  0x00000000, 0x00000033, 0x00000057, 0x0000801d,
  0x00000032, 0x00000055, 0x00000081, 0x0000801d,
  0x00000053, 0x0000007f, 0x00000081, 0x0000801d,
  0x0000007d, 0x0000007f, 0x00000081, 0xffff8023,
  0x0000007d, 0x0000007f, 0xffffff83, 0xffff8023,
  0x0000007d, 0xffffff83, 0xffffff83, 0xffffaacd,
  0xffffff83, 0xffffff83, 0xffffffad, 0xffffccee,
  0xffffff83, 0xffffffad, 0xffffffcf, 0x00000020,
  0xffffffad, 0xffffffcf, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00003352,
  0x00000000, 0x00000001, 0x00003334, 0x00005574,
  0x00000000, 0x00000034, 0x00005555, 0x0000801e,
  0x00000032, 0x00000056, 0x00007fff, 0x0000801e,
  0x00000054, 0x00000080, 0x00007fff, 0x0000801e,
  0x0000007e, 0x00000080, 0x00007fff, 0xffff8022,
  0x0000007e, 0x00000080, 0xffff8005, 0xffff8022,
  0x0000007e, 0xffffff82, 0xffff8005, 0xffffaacc,
  0xffffff82, 0xffffff82, 0xffffaaaf, 0xffffccee,
  0xffffff82, 0xffffffac, 0xffffccd0, 0x00000020,
  0xffffffac, 0xffffffce, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00003353,
  0x00000000, 0x00000001, 0x00003334, 0x00005575,
  0x00000000, 0x00003333, 0x00005556, 0x0000801f,
  0x00000033, 0x00005554, 0x00008000, 0x0000801f,
  0x00000055, 0x00007ffe, 0x00008000, 0x0000801f,
  0x0000007f, 0x00007ffe, 0x00008000, 0xffff8021,
  0x0000007f, 0x00007ffe, 0xffff8004, 0xffff8021,
  0x0000007f, 0xffff8004, 0xffff8004, 0xffffaacb,
  0xffffff81, 0xffff8004, 0xffffaaae, 0xffffcced,
  0xffffff81, 0xffffaaae, 0xffffccd0, 0x00000020,
  0xffffffab, 0xffffcccf, 0x00000002, 0x00000020,
  0xffffffcd, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x0000002d,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x00000002, 0x00000053,
  0x00000000, 0x00000001, 0x00000002, 0x00003352,
  0x00000000, 0x00000001, 0x00000002, 0x00003352,
  0x00000000, 0x00000001, 0x00000002, 0x00003353,
  0x00000000, 0x00000001, 0x00000002, 0x147ae168,
  0x00000000, 0x00000001, 0x00003335, 0x22222242,
  0x00000000, 0x00003333, 0x00005557, 0x33333352,
  0x00003332, 0x00005555, 0x00008001, 0x33333352,
  0x00005553, 0x00007fff, 0x00008001, 0x33333353,
  0x00007ffd, 0x00007fff, 0x00008001, 0xcccccced,
  0x00007ffd, 0x00007fff, 0xffff8003, 0xcccccced,
  0x00007ffd, 0xffff8003, 0xffff8003, 0xddddddfe,
  0xffff8003, 0xffff8003, 0xffffaaad, 0xeb851ed8,
  0xffff8003, 0xffffaaad, 0xffffcccf, 0xffffcced,
  0xffffaaad, 0xffffcccf, 0x00000002, 0xffffcced,
  0xffffccce, 0x00000001, 0x00000002, 0xffffccee,
  0x00000000, 0x00000001, 0x00000002, 0xffffccee,
  0x00000000, 0x00000001, 0x00000002, 0xffffffed,
  0x00000000, 0x00000001, 0x00000002, 0xffffffed,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0x00000002, 0x00000013,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000003, 0x00000035,
  0x00000000, 0x00000001, 0x0000000f, 0x00000073,
  0x00000000, 0x00000001, 0x00000034, 0x00000074,
  0x00000000, 0x00000001, 0x00000034, 0x00000075,
  0x00000000, 0x00000001, 0x00000035, 0x00005573,
  0x00000000, 0x00000001, 0x00003334, 0x00005574,
  0x00000000, 0x00000001, 0x00003334, 0x00005575,
  0x00000000, 0x00000001, 0x00003335, 0x22222242,
  0x00000000, 0x00000001, 0x147ae14a, 0x38e38e58,
  0x00000000, 0x00003334, 0x22222224, 0x55555573,
  0x00003332, 0x00005556, 0x33333334, 0x55555574,
  0x00005554, 0x00008000, 0x33333334, 0x55555574,
  0x00007ffe, 0x00008000, 0x33333335, 0xaaaaaacb,
  0x00007ffe, 0x00008000, 0xcccccccf, 0xaaaaaacc,
  0x00007ffe, 0xffff8002, 0xcccccccf, 0xc71c71e7,
  0xffff8002, 0xffff8002, 0xdddddde0, 0xddddddfd,
  0xffff8002, 0xffffaaac, 0xeb851eba, 0xffffaacb,
  0xffffaaac, 0xffffccce, 0xffffcccf, 0xffffaacb,
  0xffffccce, 0x00000001, 0xffffcccf, 0xffffaacc,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffaacd,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffffcb,
  0x00000000, 0x00000001, 0xffffffcf, 0xffffffcb,
  0x00000000, 0x00000001, 0xffffffcf, 0xffffffcc,
  0x00000000, 0x00000001, 0xffffffd0, 0xffffffcd,
  0x00000000, 0x00000001, 0xffffffd0, 0x0000000b,
  0x00000000, 0x00000001, 0xfffffff5, 0x0000001e,
  0x00000000, 0x00000001, 0x00000001, 0x0000001f,
  0x00000000, 0x00000001, 0x00000001, 0x0000001f,
  0x00000000, 0x00000000, 0x00000001, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000001, 0x00000003, 0x00000040,
  0x00000000, 0x00000002, 0x00000017, 0x0000009d,
  0x00000000, 0x0000000e, 0x00000055, 0x0000009e,
  0x00000000, 0x00000033, 0x00000056, 0x0000009f,
  0x00000000, 0x00000033, 0x00000057, 0x0000801d,
  0x00000000, 0x00000034, 0x00005555, 0x0000801e,
  0x00000000, 0x00003333, 0x00005556, 0x0000801f,
  0x00000000, 0x00003333, 0x00005557, 0x33333352,
  0x00000000, 0x00003334, 0x22222224, 0x55555573,
  0x00000000, 0x147ae149, 0x38e38e3a, 0x7fffffff,
  0x00003333, 0x22222223, 0x55555555, 0x7fffffff,
  0x00005555, 0x33333333, 0x55555556, 0x7fffffff,
  0x00007fff, 0x33333333, 0x55555556, 0x80000023,
  0x00007fff, 0x33333334, 0xaaaaaaad, 0x80000024,
  0x00007fff, 0xccccccce, 0xaaaaaaae, 0xaaaaaacc,
  0xffff8001, 0xccccccce, 0xc71c71c9, 0xcccccced,
  0xffff8001, 0xdddddddf, 0xdddddddf, 0xffff8020,
  0xffffaaab, 0xeb851eb9, 0xffffaaad, 0xffff8021,
  0xffffcccd, 0xffffccce, 0xffffaaad, 0xffff8022,
  0x00000000, 0xffffccce, 0xffffaaae, 0xffff8023,
  0x00000000, 0xffffcccf, 0xffffaaaf, 0xffffffa0,
  0x00000000, 0xffffcccf, 0xffffffad, 0xffffffa1,
  0x00000000, 0xffffffce, 0xffffffad, 0xffffffa2,
  0x00000000, 0xffffffce, 0xffffffae, 0xffffffa3,
  0x00000000, 0xffffffcf, 0xffffffaf, 0x00000000,
  0x00000000, 0xffffffcf, 0xffffffed, 0x0000001d,
  0x00000000, 0xfffffff4, 0x00000000, 0x0000001e,
  0x00000000, 0x00000000, 0x00000001, 0x0000001f,
  0xffffffff, 0x00000000, 0x00000001, 0x00000020,
  0xffffffff, 0x00000000, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000022, 0x0000009d,
  0x00000001, 0x00000016, 0x0000007f, 0x0000009e,
  0x0000000d, 0x00000054, 0x00000080, 0x0000009f,
  0x00000032, 0x00000055, 0x00000081, 0x0000801d,
  0x00000032, 0x00000056, 0x00007fff, 0x0000801e,
  0x00000033, 0x00005554, 0x00008000, 0x0000801f,
  0x00003332, 0x00005555, 0x00008001, 0x33333352,
  0x00003332, 0x00005556, 0x33333334, 0x55555574,
  0x00003333, 0x22222223, 0x55555555, 0x7fffffff,
  0x147ae148, 0x38e38e39, 0x7ffffffc, 0x7fffffff,
  0x22222222, 0x55555554, 0x7ffffffd, 0x7fffffff,
  0x33333332, 0x55555555, 0x7ffffffe, 0x80000022,
  0x33333332, 0x55555555, 0x80000005, 0x80000023,
  0x33333333, 0xaaaaaaac, 0x80000006, 0xaaaaaacb,
  0xcccccccd, 0xaaaaaaad, 0xaaaaaaae, 0xcccccced,
  0xcccccccd, 0xc71c71c8, 0xcccccccf, 0xffff8020,
  0xddddddde, 0xddddddde, 0xffff8002, 0xffff8021,
  0xeb851eb8, 0xffffaaac, 0xffff8003, 0xffff8022,
  0xffffcccd, 0xffffaaac, 0xffff8004, 0xffff8023,
  0xffffcccd, 0xffffaaad, 0xffff8005, 0xffffffa0,
  0xffffccce, 0xffffaaae, 0xffffff82, 0xffffffa1,
  0xffffccce, 0xffffffac, 0xffffff83, 0xffffffa2,
  0xffffffcd, 0xffffffac, 0xffffff84, 0xffffffa3,
  0xffffffcd, 0xffffffad, 0xffffff85, 0x00000000,
  0xffffffce, 0xffffffae, 0xffffffe2, 0x0000001d,
  0xffffffce, 0xffffffec, 0xffffffff, 0x0000001e,
  0xfffffff3, 0xffffffff, 0x00000000, 0x0000001f,
  0xfffffffe, 0xffffffff, 0x00000001, 0x00000020,
  0xffffffff, 0x00000000, 0x00000002, 0x00000021,
  0xffffffff, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000001, 0x00000003, 0x00000022, 0x0000009d,
  0x00000001, 0x00000021, 0x0000007f, 0x0000009e,
  0x00000015, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000053, 0x0000007f, 0x00000081, 0x0000801d,
  0x00000054, 0x00000080, 0x00007fff, 0x0000801e,
  0x00000055, 0x00007ffe, 0x00008000, 0x0000801f,
  0x00005553, 0x00007fff, 0x00008001, 0x33333353,
  0x00005554, 0x00008000, 0x33333334, 0x55555574,
  0x00005555, 0x33333333, 0x55555556, 0x7fffffff,
  0x22222222, 0x55555554, 0x7ffffffd, 0x7fffffff,
  0x38e38e38, 0x7ffffffb, 0x7ffffffe, 0x7fffffff,
  0x55555553, 0x7ffffffc, 0x7fffffff, 0x80000021,
  0x55555554, 0x7ffffffd, 0x80000004, 0x80000022,
  0x55555554, 0x80000004, 0x80000005, 0xaaaaaacb,
  0xaaaaaaab, 0x80000005, 0xaaaaaaad, 0xccccccec,
  0xaaaaaaac, 0xaaaaaaad, 0xcccccccf, 0xffff8020,
  0xc71c71c7, 0xccccccce, 0xffff8002, 0xffff8021,
  0xdddddddd, 0xffff8001, 0xffff8003, 0xffff8022,
  0xffffaaab, 0xffff8002, 0xffff8004, 0xffff8023,
  0xffffaaab, 0xffff8003, 0xffff8005, 0xffffffa0,
  0xffffaaac, 0xffff8004, 0xffffff82, 0xffffffa1,
  0xffffaaad, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffffffab, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xffffffab, 0xffffff83, 0xffffff85, 0x00000000,
  0xffffffac, 0xffffff84, 0xffffffe2, 0x0000001d,
  0xffffffad, 0xffffffe1, 0xffffffff, 0x0000001e,
  0xffffffeb, 0xfffffffe, 0x00000000, 0x0000001f,
  0xfffffffd, 0xffffffff, 0x00000001, 0x00000020,
  0xfffffffe, 0x00000000, 0x00000002, 0x0000001f,
  0xffffffff, 0x00000001, 0x00000003, 0x0000001e,
  0x00000000, 0x00000002, 0x00000004, 0x00000000,
  0x00000001, 0x00000003, 0x00000022, 0xffffffa3,
  0x00000002, 0x00000021, 0x0000007f, 0xffffffa2,
  0x00000020, 0x0000007e, 0x00000080, 0xffffffa1,
  0x0000007d, 0x0000007f, 0x00000081, 0xffff8023,
  0x0000007e, 0x00000080, 0x00007fff, 0xffff8022,
  0x0000007f, 0x00007ffe, 0x00008000, 0xffff8021,
  0x00007ffd, 0x00007fff, 0x00008001, 0xcccccced,
  0x00007ffe, 0x00008000, 0x33333335, 0xaaaaaacb,
  0x00007fff, 0x33333333, 0x55555556, 0x80000023,
  0x33333332, 0x55555555, 0x7ffffffe, 0x80000022,
  0x55555553, 0x7ffffffc, 0x7fffffff, 0x80000021,
  0x7ffffffa, 0x7ffffffd, 0x7fffffff, 0x7fffffff,
  0x7ffffffb, 0x7ffffffe, 0x80000003, 0x7fffffff,
  0x7ffffffc, 0x80000003, 0x80000004, 0x55555576,
  0x80000003, 0x80000004, 0xaaaaaaad, 0x33333354,
  0x80000004, 0xaaaaaaac, 0xccccccce, 0x00008020,
  0xaaaaaaac, 0xccccccce, 0xffff8002, 0x0000801f,
  0xcccccccd, 0xffff8001, 0xffff8003, 0x0000801e,
  0xffff8000, 0xffff8002, 0xffff8004, 0x0000801d,
  0xffff8001, 0xffff8003, 0xffff8005, 0x000000a0,
  0xffff8002, 0xffff8004, 0xffffff82, 0x0000009f,
  0xffff8003, 0xffffff81, 0xffffff83, 0x0000009e,
  0xffffff80, 0xffffff82, 0xffffff84, 0x0000009d,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000040,
  0xffffff82, 0xffffff84, 0xffffffe2, 0x00000023,
  0xffffff83, 0xffffffe1, 0xffffffff, 0x00000022,
  0xffffffe0, 0xfffffffe, 0x00000000, 0x00000021,
  0xfffffffd, 0xffffffff, 0x00000003, 0x00000020,
  0xfffffffe, 0x00000000, 0x00000002, 0x0000001f,
  0xffffffff, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000002, 0x00000000, 0x00000000,
  0x00000001, 0x00000003, 0xffffffe2, 0xffffffa3,
  0x00000002, 0x00000021, 0xffffff85, 0xffffffa2,
  0x00000020, 0x0000007e, 0xffffff84, 0xffffffa1,
  0x0000007d, 0x0000007f, 0xffffff83, 0xffff8023,
  0x0000007e, 0x00000080, 0xffff8005, 0xffff8022,
  0x0000007f, 0x00007ffe, 0xffff8004, 0xffff8021,
  0x00007ffd, 0x00007fff, 0xffff8003, 0xcccccced,
  0x00007ffe, 0x00008000, 0xcccccccf, 0xaaaaaacc,
  0x00007fff, 0x33333334, 0xaaaaaaad, 0x80000024,
  0x33333332, 0x55555555, 0x80000005, 0x80000023,
  0x55555554, 0x7ffffffd, 0x80000004, 0x80000022,
  0x7ffffffb, 0x7ffffffe, 0x80000003, 0x7fffffff,
  0x7ffffffc, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7ffffffd, 0x80000002, 0x7fffffff, 0x55555575,
  0x80000002, 0x80000003, 0x55555558, 0x33333354,
  0x80000003, 0xaaaaaaac, 0x33333336, 0x00008020,
  0xaaaaaaab, 0xcccccccd, 0x00008002, 0x0000801f,
  0xcccccccd, 0xffff8001, 0x00008001, 0x0000801e,
  0xffff8000, 0xffff8002, 0x00008000, 0x0000801d,
  0xffff8001, 0xffff8003, 0x00007fff, 0x000000a0,
  0xffff8002, 0xffff8004, 0x00000082, 0x0000009f,
  0xffff8003, 0xffffff81, 0x00000081, 0x0000009e,
  0xffffff80, 0xffffff82, 0x00000080, 0x0000009d,
  0xffffff81, 0xffffff83, 0x0000007f, 0x00000040,
  0xffffff82, 0xffffff84, 0x00000022, 0x00000023,
  0xffffff83, 0xffffffe1, 0x00000005, 0x00000022,
  0xffffffe0, 0xfffffffe, 0x00000004, 0x00000021,
  0xfffffffd, 0x00000003, 0x00000003, 0x00000020,
  0xfffffffe, 0x00000002, 0x00000002, 0x0000001f,
  0xffffffff, 0x00000001, 0x00000001, 0x0000001f,
  0x00000000, 0x00000000, 0x00000000, 0x0000000b,
  0x00000001, 0xffffffff, 0xffffffe2, 0xffffffcd,
  0x00000002, 0xffffffe1, 0xffffff85, 0xffffffcc,
  0x00000020, 0xffffff84, 0xffffff84, 0xffffffcb,
  0x0000007d, 0xffffff83, 0xffffff83, 0xffffaacd,
  0x0000007e, 0xffffff82, 0xffff8005, 0xffffaacc,
  0x0000007f, 0xffff8004, 0xffff8004, 0xffffaacb,
  0x00007ffd, 0xffff8003, 0xffff8003, 0xddddddfe,
  0x00007ffe, 0xffff8002, 0xcccccccf, 0xc71c71e7,
  0x00007fff, 0xccccccce, 0xaaaaaaae, 0xaaaaaacc,
  0x33333333, 0xaaaaaaac, 0x80000006, 0xaaaaaacb,
  0x55555554, 0x80000004, 0x80000005, 0xaaaaaacb,
  0x7ffffffc, 0x80000003, 0x80000004, 0x55555576,
  0x7ffffffd, 0x80000002, 0x7fffffff, 0x55555575,
  0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x38e38e5a,
  0x80000001, 0x7fffffff, 0x55555557, 0x22222243,
  0x80000002, 0x55555557, 0x33333336, 0x00005575,
  0xaaaaaaab, 0x33333335, 0x00008002, 0x00005575,
  0xcccccccc, 0x00008001, 0x00008001, 0x00005574,
  0xffff8000, 0x00008000, 0x00008000, 0x00005573,
  0xffff8001, 0x00007fff, 0x00007fff, 0x00000075,
  0xffff8002, 0x00007ffe, 0x00000082, 0x00000075,
  0xffff8003, 0x00000081, 0x00000081, 0x00000074,
  0xffffff80, 0x00000080, 0x00000080, 0x00000073,
  0xffffff81, 0x0000007f, 0x0000007f, 0x00000035,
  0xffffff82, 0x0000007e, 0x00000022, 0x00000022,
  0xffffff83, 0x00000021, 0x00000005, 0x00000021,
  0xffffffe0, 0x00000004, 0x00000004, 0x00000021,
  0x00000003, 0x00000003, 0x00000003, 0x00000020,
  0x00000002, 0x00000002, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000001, 0x0000001f,
  0x00000000, 0x00000000, 0x00000001, 0x00000013,
  0xffffffff, 0xffffffff, 0xffffffed, 0xffffffee,
  0xfffffffe, 0xffffffe1, 0xffffffaf, 0xffffffee,
  0xffffffe0, 0xffffff84, 0xffffffae, 0xffffffed,
  0xffffff83, 0xffffff83, 0xffffffad, 0xffffccee,
  0xffffff82, 0xffffff82, 0xffffaaaf, 0xffffccee,
  0xffffff81, 0xffff8004, 0xffffaaae, 0xffffcced,
  0xffff8003, 0xffff8003, 0xffffaaad, 0xeb851ed8,
  0xffff8002, 0xffff8002, 0xdddddde0, 0xddddddfd,
  0xffff8001, 0xccccccce, 0xc71c71c9, 0xcccccced,
  0xcccccccd, 0xaaaaaaad, 0xaaaaaaae, 0xcccccced,
  0xaaaaaaab, 0x80000005, 0xaaaaaaad, 0xccccccec,
  0x80000003, 0x80000004, 0xaaaaaaad, 0x33333354,
  0x80000002, 0x80000003, 0x55555558, 0x33333354,
  0x80000001, 0x7fffffff, 0x55555557, 0x22222243,
  0x7fffffff, 0x7fffffff, 0x38e38e3c, 0x147ae168,
  0x7fffffff, 0x55555556, 0x22222225, 0x00003353,
  0x55555556, 0x33333335, 0x00005557, 0x00003353,
  0x33333334, 0x00008001, 0x00005557, 0x00003352,
  0x00008000, 0x00008000, 0x00005556, 0x00003352,
  0x00007fff, 0x00007fff, 0x00005555, 0x00000053,
  0x00007ffe, 0x00007ffe, 0x00000057, 0x00000053,
  0x00007ffd, 0x00000081, 0x00000057, 0x00000052,
  0x00000080, 0x00000080, 0x00000056, 0x00000052,
  0x0000007f, 0x0000007f, 0x00000055, 0x0000002d,
  0x0000007e, 0x0000007e, 0x00000017, 0x00000021,
  0x0000007d, 0x00000021, 0x00000004, 0x00000021,
  0x00000020, 0x00000004, 0x00000003, 0x00000020,
  0x00000003, 0x00000002, 0x00000002, 0x00000020,
  0x00000002, 0x00000002, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000000, 0x00000001, 0x00000020,
  0xffffffff, 0x00000000, 0xfffffff5, 0x00000020,
  0xfffffffe, 0xffffffec, 0xffffffd0, 0x00000020,
  0xffffffe0, 0xffffffae, 0xffffffd0, 0x00000020,
  0xffffff83, 0xffffffad, 0xffffffcf, 0x00000020,
  0xffffff82, 0xffffffac, 0xffffccd0, 0x00000020,
  0xffffff81, 0xffffaaae, 0xffffccd0, 0x00000020,
  0xffff8003, 0xffffaaad, 0xffffcccf, 0xffffcced,
  0xffff8002, 0xffffaaac, 0xeb851eba, 0xffffaacb,
  0xffff8001, 0xdddddddf, 0xdddddddf, 0xffff8020,
  0xcccccccd, 0xc71c71c8, 0xcccccccf, 0xffff8020,
  0xaaaaaaac, 0xaaaaaaad, 0xcccccccf, 0xffff8020,
  0x80000004, 0xaaaaaaac, 0xccccccce, 0x00008020,
  0x80000003, 0xaaaaaaac, 0x33333336, 0x00008020,
  0x80000002, 0x55555557, 0x33333336, 0x00005575,
  0x7fffffff, 0x55555556, 0x22222225, 0x00003353,
  0x7ffffffe, 0x38e38e3b, 0x147ae14a, 0x00000021,
  0x55555555, 0x22222224, 0x00003335, 0x00000020,
  0x33333334, 0x00005556, 0x00003335, 0x00000020,
  0x00008000, 0x00005556, 0x00003334, 0x00000020,
  0x00007fff, 0x00005555, 0x00003334, 0x00000020,
  0x00007ffe, 0x00005554, 0x00000035, 0x00000020,
  0x00007ffd, 0x00000056, 0x00000035, 0x00000020,
  0x00000080, 0x00000056, 0x00000034, 0x00000020,
  0x0000007f, 0x00000055, 0x00000034, 0x00000020,
  0x0000007e, 0x00000054, 0x0000000f, 0x00000020,
  0x0000007d, 0x00000016, 0x00000003, 0x00000020,
  0x00000020, 0x00000003, 0x00000003, 0x00000020,
  0x00000002, 0x00000002, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffff, 0x00000000, 0x00000002, 0x00000020,
  0xffffffff, 0xfffffff4, 0x00000002, 0x00000020,
  0xffffffeb, 0xffffffcf, 0x00000002, 0x00000020,
  0xffffffad, 0xffffffcf, 0x00000002, 0x00000020,
  0xffffffac, 0xffffffce, 0x00000002, 0x00000020,
  0xffffffab, 0xffffcccf, 0x00000002, 0x00000020,
  0xffffaaad, 0xffffcccf, 0x00000002, 0xffffcced,
  0xffffaaac, 0xffffccce, 0xffffcccf, 0xffffaacb,
  0xffffaaab, 0xeb851eb9, 0xffffaaad, 0xffff8021,
  0xddddddde, 0xddddddde, 0xffff8002, 0xffff8021,
  0xc71c71c7, 0xccccccce, 0xffff8002, 0xffff8021,
  0xaaaaaaac, 0xccccccce, 0xffff8002, 0x0000801f,
  0xaaaaaaab, 0xcccccccd, 0x00008002, 0x0000801f,
  0xaaaaaaab, 0x33333335, 0x00008002, 0x00005575,
  0x55555556, 0x33333335, 0x00005557, 0x00003353,
  0x55555555, 0x22222224, 0x00003335, 0x00000020,
  0x38e38e3a, 0x147ae149, 0x00000003, 0x00000020,
  0x22222223, 0x00003334, 0x00000002, 0x00000020,
  0x00005555, 0x00003334, 0x00000002, 0x00000020,
  0x00005555, 0x00003333, 0x00000002, 0x00000020,
  0x00005554, 0x00003333, 0x00000002, 0x00000020,
  0x00005553, 0x00000034, 0x00000002, 0x00000020,
  0x00000055, 0x00000034, 0x00000002, 0x00000020,
  0x00000055, 0x00000033, 0x00000002, 0x00000020,
  0x00000054, 0x00000033, 0x00000002, 0x00000020,
  0x00000053, 0x0000000e, 0x00000002, 0x00000020,
  0x00000015, 0x00000002, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000002, 0x00000020,
  0xfffffff3, 0x00000001, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0xffffffcd, 0x00000001, 0x00000002, 0x00000020,
  0xffffccce, 0x00000001, 0x00000002, 0xffffccee,
  0xffffccce, 0x00000001, 0xffffcccf, 0xffffaacc,
  0xffffcccd, 0xffffccce, 0xffffaaad, 0xffff8022,
  0xeb851eb8, 0xffffaaac, 0xffff8003, 0xffff8022,
  0xdddddddd, 0xffff8001, 0xffff8003, 0xffff8022,
  0xcccccccd, 0xffff8001, 0xffff8003, 0x0000801e,
  0xcccccccd, 0xffff8001, 0x00008001, 0x0000801e,
  0xcccccccc, 0x00008001, 0x00008001, 0x00005574,
  0x33333334, 0x00008001, 0x00005557, 0x00003352,
  0x33333334, 0x00005556, 0x00003335, 0x00000020,
  0x22222223, 0x00003334, 0x00000002, 0x00000020,
  0x147ae148, 0x00000002, 0x00000002, 0x00000020,
  0x00003333, 0x00000001, 0x00000002, 0x00000020,
  0x00003333, 0x00000001, 0x00000002, 0x00000020,
  0x00003332, 0x00000001, 0x00000002, 0x00000020,
  0x00003332, 0x00000001, 0x00000002, 0x00000020,
  0x00000033, 0x00000001, 0x00000002, 0x00000020,
  0x00000033, 0x00000001, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x0000000d, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffccee,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffaacd,
  0x00000000, 0xffffccce, 0xffffaaae, 0xffff8023,
  0xffffcccd, 0xffffaaac, 0xffff8004, 0xffff8023,
  0xffffaaab, 0xffff8002, 0xffff8004, 0xffff8023,
  0xffff8000, 0xffff8002, 0xffff8004, 0x0000801d,
  0xffff8000, 0xffff8002, 0x00008000, 0x0000801d,
  0xffff8000, 0x00008000, 0x00008000, 0x00005573,
  0x00008000, 0x00008000, 0x00005556, 0x00003352,
  0x00008000, 0x00005556, 0x00003334, 0x00000020,
  0x00005555, 0x00003334, 0x00000002, 0x00000020,
  0x00003333, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffffed,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffffcb,
  0x00000000, 0xffffcccf, 0xffffaaaf, 0xffffffa0,
  0xffffcccd, 0xffffaaad, 0xffff8005, 0xffffffa0,
  0xffffaaab, 0xffff8003, 0xffff8005, 0xffffffa0,
  0xffff8001, 0xffff8003, 0xffff8005, 0x000000a0,
  0xffff8001, 0xffff8003, 0x00007fff, 0x000000a0,
  0xffff8001, 0x00007fff, 0x00007fff, 0x00000075,
  0x00007fff, 0x00007fff, 0x00005555, 0x00000053,
  0x00007fff, 0x00005555, 0x00003334, 0x00000020,
  0x00005555, 0x00003333, 0x00000002, 0x00000020,
  0x00003333, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffffed,
  0x00000000, 0x00000001, 0xffffffcf, 0xffffffcb,
  0x00000000, 0xffffcccf, 0xffffffad, 0xffffffa1,
  0xffffccce, 0xffffaaae, 0xffffff82, 0xffffffa1,
  0xffffaaac, 0xffff8004, 0xffffff82, 0xffffffa1,
  0xffff8002, 0xffff8004, 0xffffff82, 0x0000009f,
  0xffff8002, 0xffff8004, 0x00000082, 0x0000009f,
  0xffff8002, 0x00007ffe, 0x00000082, 0x00000075,
  0x00007ffe, 0x00007ffe, 0x00000057, 0x00000053,
  0x00007ffe, 0x00005554, 0x00000035, 0x00000020,
  0x00005554, 0x00003333, 0x00000002, 0x00000020,
  0x00003332, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0xffffffcf, 0xffffffcc,
  0x00000000, 0xffffffce, 0xffffffad, 0xffffffa2,
  0xffffccce, 0xffffffac, 0xffffff83, 0xffffffa2,
  0xffffaaad, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffff8003, 0xffffff81, 0xffffff83, 0x0000009e,
  0xffff8003, 0xffffff81, 0x00000081, 0x0000009e,
  0xffff8003, 0x00000081, 0x00000081, 0x00000074,
  0x00007ffd, 0x00000081, 0x00000057, 0x00000052,
  0x00007ffd, 0x00000056, 0x00000035, 0x00000020,
  0x00005553, 0x00000034, 0x00000002, 0x00000020,
  0x00003332, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0xffffffd0, 0xffffffcd,
  0x00000000, 0xffffffce, 0xffffffae, 0xffffffa3,
  0xffffffcd, 0xffffffac, 0xffffff84, 0xffffffa3,
  0xffffffab, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xffffff80, 0xffffff82, 0xffffff84, 0x0000009d,
  0xffffff80, 0xffffff82, 0x00000080, 0x0000009d,
  0xffffff80, 0x00000080, 0x00000080, 0x00000073,
  0x00000080, 0x00000080, 0x00000056, 0x00000052,
  0x00000080, 0x00000056, 0x00000034, 0x00000020,
  0x00000055, 0x00000034, 0x00000002, 0x00000020,
  0x00000033, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000013,
  0x00000000, 0x00000001, 0xffffffd0, 0x0000000b,
  0x00000000, 0xffffffcf, 0xffffffaf, 0x00000000,
  0xffffffcd, 0xffffffad, 0xffffff85, 0x00000000,
  0xffffffab, 0xffffff83, 0xffffff85, 0x00000000,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000040,
  0xffffff81, 0xffffff83, 0x0000007f, 0x00000040,
  0xffffff81, 0x0000007f, 0x0000007f, 0x00000035,
  0x0000007f, 0x0000007f, 0x00000055, 0x0000002d,
  0x0000007f, 0x00000055, 0x00000034, 0x00000020,
  0x00000055, 0x00000033, 0x00000002, 0x00000020,
  0x00000033, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0xfffffff5, 0x0000001e,
  0x00000000, 0xffffffcf, 0xffffffed, 0x0000001d,
  0xffffffce, 0xffffffae, 0xffffffe2, 0x0000001d,
  0xffffffac, 0xffffff84, 0xffffffe2, 0x0000001d,
  0xffffff82, 0xffffff84, 0xffffffe2, 0x00000023,
  0xffffff82, 0xffffff84, 0x00000022, 0x00000023,
  0xffffff82, 0x0000007e, 0x00000022, 0x00000022,
  0x0000007e, 0x0000007e, 0x00000017, 0x00000021,
  0x0000007e, 0x00000054, 0x0000000f, 0x00000020,
  0x00000054, 0x00000033, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000001, 0x0000001f,
  0x00000000, 0xfffffff4, 0x00000000, 0x0000001e,
  0xffffffce, 0xffffffec, 0xffffffff, 0x0000001e,
  0xffffffad, 0xffffffe1, 0xffffffff, 0x0000001e,
  0xffffff83, 0xffffffe1, 0xffffffff, 0x00000022,
  0xffffff83, 0xffffffe1, 0x00000005, 0x00000022,
  0xffffff83, 0x00000021, 0x00000005, 0x00000021,
  0x0000007d, 0x00000021, 0x00000004, 0x00000021,
  0x0000007d, 0x00000016, 0x00000003, 0x00000020,
  0x00000053, 0x0000000e, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000001, 0x0000001f,
  0x00000000, 0x00000000, 0x00000001, 0x0000001f,
  0xfffffff3, 0xffffffff, 0x00000000, 0x0000001f,
  0xffffffeb, 0xfffffffe, 0x00000000, 0x0000001f,
  0xffffffe0, 0xfffffffe, 0x00000000, 0x00000021,
  0xffffffe0, 0xfffffffe, 0x00000004, 0x00000021,
  0xffffffe0, 0x00000004, 0x00000004, 0x00000021,
  0x00000020, 0x00000004, 0x00000003, 0x00000020,
  0x00000020, 0x00000003, 0x00000003, 0x00000020,
  0x00000015, 0x00000002, 0x00000002, 0x00000020,
  0x0000000d, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
};
const unsigned kExpectedCount_NEON_sqrdmlah_4S = 961;

#endif  // VIXL_SIM_SQRDMLAH_4S_TRACE_AARCH64_H_
