/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.ConstructionObject;

public class ObjectEditDialog
extends HelpCloseDialog
implements IconBarListener {
    protected MyTextField Text;
    protected MyTextField Unit;
    protected MyTextField Equation;
    protected TextFieldAction Name;
    protected TextFieldAction Alias;
    protected ConstructionObject O;
    protected IconBar ColorIB;
    protected IconBar ThicknessIB;
    protected IconBar IB;
    protected Frame F;
    protected boolean More;
    protected ButtonAction OK;
    protected boolean SuperHide = false;
    protected boolean HideChanged = false;
    protected boolean HidingBreak = false;
    protected boolean BreakChanged = false;
    protected boolean OKControlDown = false;

    public ObjectEditDialog(Frame frame, String string, ConstructionObject constructionObject) {
        this(frame, string, constructionObject, "properties");
    }

    public ObjectEditDialog(Frame frame, String string, ConstructionObject constructionObject, String string2) {
        super(frame, string, true);
        String string3;
        this.F = frame;
        this.O = constructionObject;
        constructionObject.getConstruction().changed(true);
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new BorderLayout());
        MyPanel myPanel2 = new MyPanel();
        this.Name = new TextFieldAction(this, "Name", constructionObject.getName(), 32);
        if (this.O.canDisplayName()) {
            this.Alias = new TextFieldAction(this, "Alias", constructionObject.getAlias(), 32);
        }
        this.Text = new MyTextField(constructionObject.getText(), 32);
        this.Unit = new MyTextField(constructionObject.getUnit(), 32);
        myPanel2.setLayout(new GridLayout(0, 2));
        myPanel2.add(new MyLabel(Zirkel.name("edit.name")));
        myPanel2.add(this.Name);
        if (this.Alias != null) {
            myPanel2.add(new MyLabel(Zirkel.name("edit.alias")));
            myPanel2.add(this.Alias);
        }
        myPanel2.add(new MyLabel(Zirkel.name("edit.text")));
        myPanel2.add(this.Text);
        if (constructionObject.hasUnit()) {
            myPanel2.add(new MyLabel(Zirkel.name("edit.unit")));
            myPanel2.add(this.Unit);
        }
        if (!(string3 = constructionObject.getEquation()).equals("")) {
            myPanel2.add(new MyLabel(Zirkel.name("edit.equation")));
            this.Equation = new MyTextField(constructionObject.getName(), 32);
            this.Equation.setEditable(false);
            this.Equation.setText(string3);
            myPanel2.add(this.Equation);
        }
        this.addFirst(myPanel2);
        myPanel.add("Center", myPanel2);
        MyPanel myPanel3 = new MyPanel();
        myPanel3.setLayout(new GridLayout(0, 2));
        this.ColorIB = new IconBar(frame);
        this.ColorIB.addToggleGroupLeft("color", 6);
        this.ColorIB.toggle("color", this.O.getColorIndex(true));
        myPanel3.add(new MyLabel(""));
        myPanel3.add(this.ColorIB);
        this.ThicknessIB = new IconBar(frame);
        this.ThicknessIB.addToggleGroupLeft("thickness", 4);
        this.ThicknessIB.toggle("thickness", this.O.getColorType(true));
        if (constructionObject.maybeTransparent()) {
            this.ThicknessIB.addSeparatorLeft();
            this.ThicknessIB.addOnOffLeft("solid");
            this.ThicknessIB.setState("solid", constructionObject.isSolid(true));
            if (!constructionObject.isFilled()) {
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        myPanel3.add(new MyLabel(""));
        myPanel3.add(this.ThicknessIB);
        this.IB = new IconBar(frame);
        this.IB.setIconBarListener(this);
        this.IB.addOnOffLeft("hide");
        this.IB.setState("hide", this.O.isHidden(true));
        this.IB.addSeparatorLeft();
        if (this.O.canDisplayName()) {
            this.IB.addOnOffLeft("showname");
            this.IB.setState("showname", this.O.showName(true));
            if (this.showsValue()) {
                this.IB.addOnOffLeft("showvalue");
                this.IB.setState("showvalue", this.O.showValue(true));
            }
            this.IB.addSeparatorLeft();
            this.IB.addOnOffLeft("bold");
            this.IB.setState("bold", this.O.isBold());
            this.IB.addOnOffLeft("large");
            this.IB.setState("large", this.O.isLarge());
            this.IB.addSeparatorLeft();
        }
        this.IB.addOnOffLeft("isback");
        this.IB.setState("isback", this.O.isBack(true));
        this.IB.addOnOffLeft("setbreak");
        this.IB.setState("setbreak", this.O.isBreak());
        myPanel3.add(new MyLabel(""));
        myPanel3.add(this.IB);
        this.addSecond(myPanel3);
        myPanel.add("South", myPanel3);
        this.add("Center", new Panel3D(myPanel));
        MyPanel myPanel4 = new MyPanel();
        this.addButton(myPanel4);
        if (Global.getParameter("options.more", false)) {
            myPanel4.add(new ButtonAction(this, Zirkel.name("edit.more"), "More"));
        }
        this.OK = new ButtonAction(this, Zirkel.name("edit.ok"), "OK");
        myPanel4.add(this.OK);
        this.OK.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ObjectEditDialog.this.OKControlDown = mouseEvent.isControlDown();
            }
        });
        this.OKControlDown = false;
        ButtonAction buttonAction = new ButtonAction(this, Zirkel.name("edit.cancel"), "Close");
        myPanel4.add(buttonAction);
        this.addHelp(myPanel4, string2);
        this.add("South", new Panel3D(myPanel4));
        this.More = false;
        this.pack();
        this.center(frame);
    }

    public void doAction(String string) {
        if (string.equals("OK") || string.equals("Name") || string.equals("Alias") || string.equals("More")) {
            String string2;
            this.More = string.equals("More") || this.OKControlDown;
            this.O.setName(this.Name.getText());
            if (this.Alias != null) {
                if (!this.Alias.getText().equals("")) {
                    if (this.O.getAlias() == null || !this.O.getAlias().equals(this.Alias.getText())) {
                        this.O.setShowName(true);
                    }
                    this.O.setAlias(this.Alias.getText());
                } else {
                    this.O.setAlias(null);
                }
            }
            if (string.equals("Name")) {
                this.IB.setState("showname", true);
            }
            if ((string2 = this.Text.getText()).equals("")) {
                this.O.setText("", true);
                this.O.updateText();
            } else if (!this.O.getText().equals(string2)) {
                if (!string2.endsWith(" ")) {
                    string2 = string2 + " ";
                }
                this.O.setText(string2, true);
            }
            this.O.setUnit(this.Unit.getText());
            if (this.HideChanged) {
                this.O.setHidden(this.IB.getState("hide"));
                if (this.SuperHide && this.IB.getState("hide")) {
                    this.O.setSuperHidden(true);
                } else {
                    this.O.setSuperHidden(false);
                }
            }
            this.O.setColor(this.ColorIB.getToggleState("color"));
            this.O.setColorType(this.ThicknessIB.getToggleState("thickness"));
            this.O.setShowName(string.equals("Name") || string.equals("Alias") || this.IB.getState("showname"));
            this.O.setBold(this.IB.getState("bold"));
            this.O.setLarge(this.IB.getState("large"));
            this.O.setBack(this.IB.getState("isback"));
            if (this.showsValue()) {
                this.O.setShowValue(this.IB.getState("showvalue"));
            }
            if (this.O.maybeTransparent()) {
                this.O.setSolid(this.ThicknessIB.getState("solid"));
            }
            if (this.BreakChanged) {
                if (this.IB.getState("setbreak")) {
                    if (this.HidingBreak) {
                        this.O.setHideBreak(true);
                    } else {
                        this.O.setBreak(true);
                    }
                } else {
                    this.O.setBreak(false);
                }
            }
            this.doclose();
            this.setAction();
        } else {
            super.doAction(string);
        }
    }

    public void addFirst(Panel panel) {
    }

    public void addSecond(Panel panel) {
    }

    public void addButton(Panel panel) {
    }

    public void setAction() {
    }

    public void iconPressed(String string) {
        if (string.equals("hide")) {
            this.HideChanged = true;
            this.SuperHide = this.IB.isShiftPressed() ? this.IB.getState("hide") : false;
        } else if (string.equals("setbreak")) {
            this.BreakChanged = true;
            this.HidingBreak = this.IB.isShiftPressed() ? this.IB.getState("setbreak") : false;
        }
    }

    public void showValue() {
        if (this.showsValue()) {
            this.IB.setState("showvalue", true);
        }
    }

    public boolean showsValue() {
        return true;
    }

    public boolean wantsMore() {
        return this.More;
    }
}

