// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zksed -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV32ZKSED
// RUN: %clang_cc1 -triple riscv64 -target-feature +zksed -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV64ZKSED

#include <riscv_crypto.h>

// RV32ZKSED-LABEL: @sm4ks(
// RV32ZKSED-NEXT:  entry:
// RV32ZKSED-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm4ks(i32 [[RS1:%.*]], i32 [[RS2:%.*]], i32 0)
// RV32ZKSED-NEXT:    ret i32 [[TMP0]]
//
// RV64ZKSED-LABEL: @sm4ks(
// RV64ZKSED-NEXT:  entry:
// RV64ZKSED-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm4ks(i32 [[RS1:%.*]], i32 [[RS2:%.*]], i32 0)
// RV64ZKSED-NEXT:    ret i32 [[TMP0]]
//
uint32_t sm4ks(uint32_t rs1, uint32_t rs2) {
  return __riscv_sm4ks(rs1, rs2, 0);
}

// RV32ZKSED-LABEL: @sm4ed(
// RV32ZKSED-NEXT:  entry:
// RV32ZKSED-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm4ed(i32 [[RS1:%.*]], i32 [[RS2:%.*]], i32 0)
// RV32ZKSED-NEXT:    ret i32 [[TMP0]]
//
// RV64ZKSED-LABEL: @sm4ed(
// RV64ZKSED-NEXT:  entry:
// RV64ZKSED-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm4ed(i32 [[RS1:%.*]], i32 [[RS2:%.*]], i32 0)
// RV64ZKSED-NEXT:    ret i32 [[TMP0]]
//
uint32_t sm4ed(uint32_t rs1, uint32_t rs2) {
  return __riscv_sm4ed(rs1, rs2, 0);
}
