/*
 * Copyright (c) 2021-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(__aarch64__)

#include "arm_gemm.hpp"
#include <cstdint>

namespace arm_conv {
namespace depthwise {

void a64_s8qs_nhwc_3x3_s1_output2x2_dot_depthfirst_impl(const unsigned int n_channels, const int8_t *const *const inptrs, const int8_t *params, const int32_t *, const arm_gemm::Requantize32& qp, const int32_t *, const int32_t *, int8_t *const *const outptrs)
{
  __asm__ __volatile__(
    "lsr x15, %x[n_channels], #0x4\n"
    "add x20, %x[qp], %[offsetof_Requantize32_minval]\n"
    "ldp x14, x27, [%x[inptrs], #0x0]\n"
    "ldp x26, x25, [%x[inptrs], #0x10]\n"
    "ld1r { v27.4s }, [x20]\n"
    "add x21, %x[qp], %[offsetof_Requantize32_maxval]\n"
    "add x20, %x[qp], %[offsetof_Requantize32_c_offset]\n"
    "ldp x24, x23, [%x[inptrs], #0x20]\n"
    "ld1r { v11.4s }, [x21]\n"
    "ld1r { v13.4s }, [x20]\n"
    "mov x13, #0x0\n"
    "mov x12, #0x0\n"
    "ldp x22, x21, [%x[inptrs], #0x30]\n"
    "ldp x11, x10, [%x[outptrs], #0x0]\n"
    "ldp x9, x28, [%x[outptrs], #0x10]\n"
    "cbz x15, 3f\n"
    "ldr q12, [x14, x13]\n"
    "ldr q24, [x27, x13]\n"
    "subs x15, x15, #0x1\n"
    "ldr q10, [x26, x13]\n"
    "ldr q14, [x25, x13]\n"
    "ldr q15, [x24, x13]\n"
    "ldr q20, [x23, x13]\n"
    "ldr q16, [x22, x13]\n"
    "ldr q28, [x21, x13]\n"
    "ldr q4, [%x[params], #0x10]\n"
    "ldr q6, [%x[params], #0x20]\n"
    "zip2 v19.16b, v12.16b, v10.16b\n"
    "zip1 v12.16b, v12.16b, v10.16b\n"
    "ldr q10, [%x[params], #0x30]\n"
    "ldp x27, x26, [%x[inptrs], #0x40]\n"
    "zip1 v17.16b, v24.16b, v14.16b\n"
    "zip2 v14.16b, v24.16b, v14.16b\n"
    "ldp x25, x24, [%x[inptrs], #0x50]\n"
    "ldp x23, x22, [%x[inptrs], #0x60]\n"
    "zip2 v18.16b, v15.16b, v16.16b\n"
    "zip1 v15.16b, v15.16b, v16.16b\n"
    "ldp x21, x20, [%x[inptrs], #0x70]\n"
    "zip1 v16.16b, v20.16b, v28.16b\n"
    "zip2 v28.16b, v20.16b, v28.16b\n"
    "ldr q8, [x27, x13]\n"
    "ldr q21, [x26, x13]\n"
    "zip2 v23.16b, v12.16b, v17.16b\n"
    "zip1 v12.16b, v12.16b, v17.16b\n"
    "ldp x14, x27, [%x[inptrs], #0x0]\n"
    "ldr q17, [x25, x13]\n"
    "ldr q22, [x24, x13]\n"
    "zip1 v30.16b, v19.16b, v14.16b\n"
    "zip2 v14.16b, v19.16b, v14.16b\n"
    "ldr q9, [x23, x13]\n"
    "ldr q20, [x22, x13]\n"
    "zip2 v5.16b, v15.16b, v16.16b\n"
    "zip1 v15.16b, v15.16b, v16.16b\n"
    "ldr q16, [x21, x13]\n"
    "ldr q2, [x20, x13]\n"
    "zip1 v7.16b, v18.16b, v28.16b\n"
    "zip2 v28.16b, v18.16b, v28.16b\n"
    "ldr q3, [%x[params], #0x0]\n"
    "zip2 v19.16b, v8.16b, v17.16b\n"
    "zip1 v8.16b, v8.16b, v17.16b\n"
    "ldp x26, x25, [%x[inptrs], #0x10]\n"
    "zip1 v18.16b, v21.16b, v22.16b\n"
    "zip2 v22.16b, v21.16b, v22.16b\n"
    "ldp x24, x23, [%x[inptrs], #0x20]\n"
    "ldp x22, x21, [%x[inptrs], #0x30]\n"
    "zip2 v17.16b, v9.16b, v16.16b\n"
    "zip1 v9.16b, v9.16b, v16.16b\n"
    "add %x[params], %x[params], #0x40\n"
    "zip1 v16.16b, v20.16b, v2.16b\n"
    "zip2 v2.16b, v20.16b, v2.16b\n"
    "zip2 v21.16b, v8.16b, v18.16b\n"
    "zip1 v8.16b, v8.16b, v18.16b\n"
    "zip1 v29.16b, v19.16b, v22.16b\n"
    "zip2 v22.16b, v19.16b, v22.16b\n"
    "zip2 v1.16b, v9.16b, v16.16b\n"
    "zip1 v9.16b, v9.16b, v16.16b\n"
    "zip1 v31.16b, v17.16b, v2.16b\n"
    "zip2 v2.16b, v17.16b, v2.16b\n"
    "mov v26.16b, v3.16b\n"
    "mov v0.16b, v3.16b\n"
    "mov v18.16b, v3.16b\n"
    "beq 2f\n"
    "1:"  // Loop
    ".inst 0x4e8c9483  // sdot v3.4s, v4.16b, v12.16b\n"
    ".inst 0x4e8f9480  // sdot v0.4s, v4.16b, v15.16b\n"
    "ext v12.16b, v12.16b, v12.16b, #0x1\n"
    "add x13, x13, #0x10\n"
    "subs x15, x15, #0x1\n"
    ".inst 0x4e8c949a  // sdot v26.4s, v4.16b, v12.16b\n"
    "ldr q17, [%x[params], #0x0]\n"
    ".inst 0x4e8f94c3  // sdot v3.4s, v6.16b, v15.16b\n"
    "ext v15.16b, v15.16b, v15.16b, #0x1\n"
    ".inst 0x4e8894c0  // sdot v0.4s, v6.16b, v8.16b\n"
    ".inst 0x4e8f9492  // sdot v18.4s, v4.16b, v15.16b\n"
    ".inst 0x4e889543  // sdot v3.4s, v10.16b, v8.16b\n"
    "ext v8.16b, v8.16b, v8.16b, #0x1\n"
    ".inst 0x4e8f94da  // sdot v26.4s, v6.16b, v15.16b\n"
    "ldr q20, [%x[params], #0x10]\n"
    ".inst 0x4e8894d2  // sdot v18.4s, v6.16b, v8.16b\n"
    ".inst 0x4e899540  // sdot v0.4s, v10.16b, v9.16b\n"
    "ext v9.16b, v9.16b, v9.16b, #0x1\n"
    "sqrdmulh v3.4s, v3.4s, v17.4s\n"
    ".inst 0x4e88955a  // sdot v26.4s, v10.16b, v8.16b\n"
    ".inst 0x4e899552  // sdot v18.4s, v10.16b, v9.16b\n"
    "and v16.16b, v3.16b, v20.16b\n"
    "sqrdmulh v0.4s, v0.4s, v17.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v26.4s, v26.4s, v17.4s\n"
    "sqrdmulh v18.4s, v18.4s, v17.4s\n"
    "ldr q6, [%x[params], #0x60]\n"
    "and v19.16b, v0.16b, v20.16b\n"
    "sqadd v3.4s, v3.4s, v16.4s\n"
    "and v17.16b, v26.16b, v20.16b\n"
    "and v16.16b, v18.16b, v20.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v3.4s, v3.4s, v20.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v0.4s, v0.4s, v19.4s\n"
    "ldr q8, [%x[params], #0x50]\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "ldr q17, [%x[params], #0x40]\n"
    "add v3.4s, v3.4s, v13.4s\n"
    "sqadd v18.4s, v18.4s, v16.4s\n"
    "ldr q16, [%x[params], #0x30]\n"
    "srshl v0.4s, v0.4s, v20.4s\n"
    "srshl v26.4s, v26.4s, v20.4s\n"
    "smax v3.4s, v3.4s, v27.4s\n"
    "srshl v18.4s, v18.4s, v20.4s\n"
    "ldr q12, [%x[params], #0x70]\n"
    "add v0.4s, v0.4s, v13.4s\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "smin v3.4s, v3.4s, v11.4s\n"
    "add v18.4s, v18.4s, v13.4s\n"
    "smax v0.4s, v0.4s, v27.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smax v18.4s, v18.4s, v27.4s\n"
    "smin v0.4s, v0.4s, v11.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smin v18.4s, v18.4s, v11.4s\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "str s3, [x11, x12]\n"
    "ldr q24, [%x[params], #0x20]\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "str s26, [x10, x12]\n"
    "mov v15.16b, v24.16b\n"
    "str s0, [x9, x12]\n"
    "mov v20.16b, v24.16b\n"
    "str s18, [x28, x12]\n"
    "mov v4.16b, v24.16b\n"
    ".inst 0x4e979618  // sdot v24.4s, v16.16b, v23.16b\n"
    "add x12, x12, #0x4\n"
    ".inst 0x4e859614  // sdot v20.4s, v16.16b, v5.16b\n"
    "ext v23.16b, v23.16b, v23.16b, #0x1\n"
    ".inst 0x4e859638  // sdot v24.4s, v17.16b, v5.16b\n"
    "ext v5.16b, v5.16b, v5.16b, #0x1\n"
    ".inst 0x4e97960f  // sdot v15.4s, v16.16b, v23.16b\n"
    "ldr q3, [x27, x13]\n"
    ".inst 0x4e859604  // sdot v4.4s, v16.16b, v5.16b\n"
    ".inst 0x4e959634  // sdot v20.4s, v17.16b, v21.16b\n"
    ".inst 0x4e959518  // sdot v24.4s, v8.16b, v21.16b\n"
    "ext v21.16b, v21.16b, v21.16b, #0x1\n"
    ".inst 0x4e85962f  // sdot v15.4s, v17.16b, v5.16b\n"
    "ldr q19, [x23, x13]\n"
    ".inst 0x4e959624  // sdot v4.4s, v17.16b, v21.16b\n"
    ".inst 0x4e819514  // sdot v20.4s, v8.16b, v1.16b\n"
    "ext v1.16b, v1.16b, v1.16b, #0x1\n"
    "sqrdmulh v24.4s, v24.4s, v6.4s\n"
    ".inst 0x4e95950f  // sdot v15.4s, v8.16b, v21.16b\n"
    ".inst 0x4e819504  // sdot v4.4s, v8.16b, v1.16b\n"
    "and v16.16b, v24.16b, v12.16b\n"
    "sqrdmulh v20.4s, v20.4s, v6.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v15.4s, v15.4s, v6.4s\n"
    "sqrdmulh v4.4s, v4.4s, v6.4s\n"
    "ldr q25, [%x[params], #0xc0]\n"
    "and v18.16b, v20.16b, v12.16b\n"
    "sqadd v24.4s, v24.4s, v16.4s\n"
    "and v17.16b, v15.16b, v12.16b\n"
    "and v16.16b, v4.16b, v12.16b\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v24.4s, v24.4s, v12.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v20.4s, v20.4s, v18.4s\n"
    "ldr q18, [%x[params], #0xb0]\n"
    "sqadd v15.4s, v15.4s, v17.4s\n"
    "ldr q17, [%x[params], #0xa0]\n"
    "add v24.4s, v24.4s, v13.4s\n"
    "sqadd v4.4s, v4.4s, v16.4s\n"
    "ldr q16, [%x[params], #0x90]\n"
    "srshl v20.4s, v20.4s, v12.4s\n"
    "srshl v15.4s, v15.4s, v12.4s\n"
    "smax v24.4s, v24.4s, v27.4s\n"
    "srshl v4.4s, v4.4s, v12.4s\n"
    "ldr q8, [%x[params], #0xd0]\n"
    "add v20.4s, v20.4s, v13.4s\n"
    "add v15.4s, v15.4s, v13.4s\n"
    "smin v24.4s, v24.4s, v11.4s\n"
    "add v4.4s, v4.4s, v13.4s\n"
    "smax v20.4s, v20.4s, v27.4s\n"
    "smax v15.4s, v15.4s, v27.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "smax v4.4s, v4.4s, v27.4s\n"
    "smin v20.4s, v20.4s, v11.4s\n"
    "smin v15.4s, v15.4s, v11.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "smin v4.4s, v4.4s, v11.4s\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v15.16b, v15.16b, v15.16b\n"
    "str s24, [x11, x12]\n"
    "ldr q24, [%x[params], #0x80]\n"
    "uzp1 v4.16b, v4.16b, v4.16b\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v15.16b, v15.16b, v15.16b\n"
    "uzp1 v4.16b, v4.16b, v4.16b\n"
    "str s15, [x10, x12]\n"
    "mov v21.16b, v24.16b\n"
    "str s20, [x9, x12]\n"
    "mov v20.16b, v24.16b\n"
    "str s4, [x28, x12]\n"
    "mov v12.16b, v24.16b\n"
    ".inst 0x4e9e9618  // sdot v24.4s, v16.16b, v30.16b\n"
    "add x12, x12, #0x4\n"
    ".inst 0x4e879614  // sdot v20.4s, v16.16b, v7.16b\n"
    "ext v30.16b, v30.16b, v30.16b, #0x1\n"
    ".inst 0x4e879638  // sdot v24.4s, v17.16b, v7.16b\n"
    "ext v7.16b, v7.16b, v7.16b, #0x1\n"
    ".inst 0x4e9e9615  // sdot v21.4s, v16.16b, v30.16b\n"
    "ldr q30, [x26, x13]\n"
    ".inst 0x4e87960c  // sdot v12.4s, v16.16b, v7.16b\n"
    ".inst 0x4e9d9634  // sdot v20.4s, v17.16b, v29.16b\n"
    ".inst 0x4e9d9658  // sdot v24.4s, v18.16b, v29.16b\n"
    "ext v29.16b, v29.16b, v29.16b, #0x1\n"
    ".inst 0x4e879635  // sdot v21.4s, v17.16b, v7.16b\n"
    "ldr q1, [x22, x13]\n"
    ".inst 0x4e9d962c  // sdot v12.4s, v17.16b, v29.16b\n"
    ".inst 0x4e9f9654  // sdot v20.4s, v18.16b, v31.16b\n"
    "ext v31.16b, v31.16b, v31.16b, #0x1\n"
    "sqrdmulh v24.4s, v24.4s, v25.4s\n"
    ".inst 0x4e9d9655  // sdot v21.4s, v18.16b, v29.16b\n"
    ".inst 0x4e9f964c  // sdot v12.4s, v18.16b, v31.16b\n"
    "and v16.16b, v24.16b, v8.16b\n"
    "sqrdmulh v20.4s, v20.4s, v25.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v21.4s, v21.4s, v25.4s\n"
    "sqrdmulh v12.4s, v12.4s, v25.4s\n"
    "ldr q29, [%x[params], #0x120]\n"
    "and v18.16b, v20.16b, v8.16b\n"
    "sqadd v24.4s, v24.4s, v16.4s\n"
    "and v17.16b, v21.16b, v8.16b\n"
    "and v16.16b, v12.16b, v8.16b\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v24.4s, v24.4s, v8.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v20.4s, v20.4s, v18.4s\n"
    "ldr q18, [%x[params], #0x110]\n"
    "sqadd v21.4s, v21.4s, v17.4s\n"
    "ldr q17, [%x[params], #0x100]\n"
    "add v24.4s, v24.4s, v13.4s\n"
    "sqadd v12.4s, v12.4s, v16.4s\n"
    "ldr q16, [%x[params], #0xf0]\n"
    "srshl v20.4s, v20.4s, v8.4s\n"
    "srshl v21.4s, v21.4s, v8.4s\n"
    "smax v24.4s, v24.4s, v27.4s\n"
    "srshl v12.4s, v12.4s, v8.4s\n"
    "ldr q23, [%x[params], #0x130]\n"
    "add v20.4s, v20.4s, v13.4s\n"
    "add v21.4s, v21.4s, v13.4s\n"
    "smin v24.4s, v24.4s, v11.4s\n"
    "add v12.4s, v12.4s, v13.4s\n"
    "smax v20.4s, v20.4s, v27.4s\n"
    "smax v21.4s, v21.4s, v27.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "smax v12.4s, v12.4s, v27.4s\n"
    "smin v20.4s, v20.4s, v11.4s\n"
    "smin v21.4s, v21.4s, v11.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "smin v12.4s, v12.4s, v11.4s\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "str s24, [x11, x12]\n"
    "ldr q26, [%x[params], #0xe0]\n"
    "uzp1 v12.16b, v12.16b, v12.16b\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "uzp1 v12.16b, v12.16b, v12.16b\n"
    "str s21, [x10, x12]\n"
    "mov v5.16b, v26.16b\n"
    "str s20, [x9, x12]\n"
    "mov v21.16b, v26.16b\n"
    "str s12, [x28, x12]\n"
    "mov v0.16b, v26.16b\n"
    ".inst 0x4e8e961a  // sdot v26.4s, v16.16b, v14.16b\n"
    "add x12, x12, #0x4\n"
    ".inst 0x4e9c9615  // sdot v21.4s, v16.16b, v28.16b\n"
    "ext v14.16b, v14.16b, v14.16b, #0x1\n"
    ".inst 0x4e9c963a  // sdot v26.4s, v17.16b, v28.16b\n"
    "ext v28.16b, v28.16b, v28.16b, #0x1\n"
    ".inst 0x4e8e9605  // sdot v5.4s, v16.16b, v14.16b\n"
    "ldr q14, [x25, x13]\n"
    ".inst 0x4e9c9600  // sdot v0.4s, v16.16b, v28.16b\n"
    ".inst 0x4e969635  // sdot v21.4s, v17.16b, v22.16b\n"
    ".inst 0x4e96965a  // sdot v26.4s, v18.16b, v22.16b\n"
    "ext v22.16b, v22.16b, v22.16b, #0x1\n"
    ".inst 0x4e9c9625  // sdot v5.4s, v17.16b, v28.16b\n"
    "ldr q28, [x21, x13]\n"
    ".inst 0x4e969620  // sdot v0.4s, v17.16b, v22.16b\n"
    ".inst 0x4e829655  // sdot v21.4s, v18.16b, v2.16b\n"
    "ext v2.16b, v2.16b, v2.16b, #0x1\n"
    "sqrdmulh v26.4s, v26.4s, v29.4s\n"
    ".inst 0x4e969645  // sdot v5.4s, v18.16b, v22.16b\n"
    ".inst 0x4e829640  // sdot v0.4s, v18.16b, v2.16b\n"
    "and v16.16b, v26.16b, v23.16b\n"
    "sqrdmulh v21.4s, v21.4s, v29.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v5.4s, v5.4s, v29.4s\n"
    "sqrdmulh v0.4s, v0.4s, v29.4s\n"
    "ldr q12, [x14, x13]\n"
    "ldp x23, x22, [%x[inptrs], #0x40]\n"
    "and v20.16b, v21.16b, v23.16b\n"
    "ldp x21, x20, [%x[inptrs], #0x50]\n"
    "sqadd v26.4s, v26.4s, v16.4s\n"
    "and v17.16b, v5.16b, v23.16b\n"
    "ldr q8, [x23, x13]\n"
    "ldr q29, [x22, x13]\n"
    "and v16.16b, v0.16b, v23.16b\n"
    "sshr v20.4s, v20.4s, #0x1f\n"
    "ldr q18, [x21, x13]\n"
    "ldr q22, [x20, x13]\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v26.4s, v26.4s, v23.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v21.4s, v21.4s, v20.4s\n"
    "ldr q10, [%x[params], #0x170]\n"
    "sqadd v5.4s, v5.4s, v17.4s\n"
    "ldr q6, [%x[params], #0x160]\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "sqadd v0.4s, v0.4s, v16.4s\n"
    "ldr q4, [%x[params], #0x150]\n"
    "srshl v21.4s, v21.4s, v23.4s\n"
    "srshl v5.4s, v5.4s, v23.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "srshl v0.4s, v0.4s, v23.4s\n"
    "ldr q15, [x24, x13]\n"
    "ldp x23, x22, [%x[inptrs], #0x60]\n"
    "add v21.4s, v21.4s, v13.4s\n"
    "ldp x21, x20, [%x[inptrs], #0x70]\n"
    "ldp x14, x27, [%x[inptrs], #0x0]\n"
    "add v5.4s, v5.4s, v13.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "ldp x26, x25, [%x[inptrs], #0x10]\n"
    "ldr q9, [x23, x13]\n"
    "ldr q24, [x22, x13]\n"
    "add v0.4s, v0.4s, v13.4s\n"
    "smax v21.4s, v21.4s, v27.4s\n"
    "ldp x24, x23, [%x[inptrs], #0x20]\n"
    "ldr q25, [x21, x13]\n"
    "ldr q2, [x20, x13]\n"
    "smax v5.4s, v5.4s, v27.4s\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "ldp x22, x21, [%x[inptrs], #0x30]\n"
    "smax v0.4s, v0.4s, v27.4s\n"
    "smin v21.4s, v21.4s, v11.4s\n"
    "smin v5.4s, v5.4s, v11.4s\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "smin v0.4s, v0.4s, v11.4s\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "uzp1 v5.16b, v5.16b, v5.16b\n"
    "str s26, [x11, x12]\n"
    "zip2 v17.16b, v12.16b, v30.16b\n"
    "zip1 v12.16b, v12.16b, v30.16b\n"
    "zip1 v16.16b, v3.16b, v14.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "zip2 v14.16b, v3.16b, v14.16b\n"
    "uzp1 v5.16b, v5.16b, v5.16b\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "zip2 v23.16b, v12.16b, v16.16b\n"
    "zip1 v12.16b, v12.16b, v16.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "zip1 v30.16b, v17.16b, v14.16b\n"
    "str s5, [x10, x12]\n"
    "str s21, [x9, x12]\n"
    "zip2 v14.16b, v17.16b, v14.16b\n"
    "ldr q3, [%x[params], #0x140]\n"
    "zip2 v21.16b, v15.16b, v1.16b\n"
    "zip1 v15.16b, v15.16b, v1.16b\n"
    "zip1 v20.16b, v19.16b, v28.16b\n"
    "add %x[params], %x[params], #0x180\n"
    "str s0, [x28, x12]\n"
    "zip2 v28.16b, v19.16b, v28.16b\n"
    "zip2 v19.16b, v8.16b, v18.16b\n"
    "add x12, x12, #0x4\n"
    "zip1 v8.16b, v8.16b, v18.16b\n"
    "zip1 v18.16b, v29.16b, v22.16b\n"
    "zip2 v22.16b, v29.16b, v22.16b\n"
    "zip2 v17.16b, v9.16b, v25.16b\n"
    "zip1 v9.16b, v9.16b, v25.16b\n"
    "zip1 v16.16b, v24.16b, v2.16b\n"
    "zip2 v2.16b, v24.16b, v2.16b\n"
    "zip2 v5.16b, v15.16b, v20.16b\n"
    "zip1 v15.16b, v15.16b, v20.16b\n"
    "zip1 v7.16b, v21.16b, v28.16b\n"
    "zip2 v28.16b, v21.16b, v28.16b\n"
    "zip2 v21.16b, v8.16b, v18.16b\n"
    "zip1 v8.16b, v8.16b, v18.16b\n"
    "zip1 v29.16b, v19.16b, v22.16b\n"
    "zip2 v22.16b, v19.16b, v22.16b\n"
    "zip2 v1.16b, v9.16b, v16.16b\n"
    "zip1 v9.16b, v9.16b, v16.16b\n"
    "zip1 v31.16b, v17.16b, v2.16b\n"
    "zip2 v2.16b, v17.16b, v2.16b\n"
    "mov v26.16b, v3.16b\n"
    "mov v0.16b, v3.16b\n"
    "mov v18.16b, v3.16b\n"
    "bgt 1b\n"
    "2:"  // Detached iteration
    ".inst 0x4e8c9483  // sdot v3.4s, v4.16b, v12.16b\n"
    ".inst 0x4e8f9480  // sdot v0.4s, v4.16b, v15.16b\n"
    "ext v12.16b, v12.16b, v12.16b, #0x1\n"
    "tst %x[n_channels], #0xf\n"
    "add x13, x13, #0x10\n"
    ".inst 0x4e8c949a  // sdot v26.4s, v4.16b, v12.16b\n"
    "ldr q17, [%x[params], #0x0]\n"
    ".inst 0x4e8f94c3  // sdot v3.4s, v6.16b, v15.16b\n"
    "ext v15.16b, v15.16b, v15.16b, #0x1\n"
    ".inst 0x4e8894c0  // sdot v0.4s, v6.16b, v8.16b\n"
    ".inst 0x4e8f9492  // sdot v18.4s, v4.16b, v15.16b\n"
    ".inst 0x4e889543  // sdot v3.4s, v10.16b, v8.16b\n"
    "ext v8.16b, v8.16b, v8.16b, #0x1\n"
    ".inst 0x4e8f94da  // sdot v26.4s, v6.16b, v15.16b\n"
    "ldr q19, [%x[params], #0x10]\n"
    ".inst 0x4e8894d2  // sdot v18.4s, v6.16b, v8.16b\n"
    ".inst 0x4e899540  // sdot v0.4s, v10.16b, v9.16b\n"
    "ext v9.16b, v9.16b, v9.16b, #0x1\n"
    "sqrdmulh v3.4s, v3.4s, v17.4s\n"
    ".inst 0x4e88955a  // sdot v26.4s, v10.16b, v8.16b\n"
    ".inst 0x4e899552  // sdot v18.4s, v10.16b, v9.16b\n"
    "and v16.16b, v3.16b, v19.16b\n"
    "sqrdmulh v0.4s, v0.4s, v17.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v26.4s, v26.4s, v17.4s\n"
    "sqrdmulh v18.4s, v18.4s, v17.4s\n"
    "ldr q4, [%x[params], #0x60]\n"
    "and v20.16b, v0.16b, v19.16b\n"
    "sqadd v3.4s, v3.4s, v16.4s\n"
    "and v17.16b, v26.16b, v19.16b\n"
    "and v16.16b, v18.16b, v19.16b\n"
    "sshr v20.4s, v20.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v3.4s, v3.4s, v19.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v0.4s, v0.4s, v20.4s\n"
    "ldr q6, [%x[params], #0x50]\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "ldr q17, [%x[params], #0x40]\n"
    "add v3.4s, v3.4s, v13.4s\n"
    "sqadd v18.4s, v18.4s, v16.4s\n"
    "ldr q16, [%x[params], #0x30]\n"
    "srshl v0.4s, v0.4s, v19.4s\n"
    "srshl v26.4s, v26.4s, v19.4s\n"
    "smax v3.4s, v3.4s, v27.4s\n"
    "srshl v18.4s, v18.4s, v19.4s\n"
    "ldr q19, [%x[params], #0x70]\n"
    "add v0.4s, v0.4s, v13.4s\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "smin v3.4s, v3.4s, v11.4s\n"
    "add v18.4s, v18.4s, v13.4s\n"
    "smax v0.4s, v0.4s, v27.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smax v18.4s, v18.4s, v27.4s\n"
    "smin v0.4s, v0.4s, v11.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smin v18.4s, v18.4s, v11.4s\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "str s3, [x11, x12]\n"
    "ldr q25, [%x[params], #0x20]\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "str s26, [x10, x12]\n"
    "mov v24.16b, v25.16b\n"
    "str s0, [x9, x12]\n"
    "mov v20.16b, v25.16b\n"
    "str s18, [x28, x12]\n"
    "mov v3.16b, v25.16b\n"
    ".inst 0x4e979619  // sdot v25.4s, v16.16b, v23.16b\n"
    "add x12, x12, #0x4\n"
    ".inst 0x4e859614  // sdot v20.4s, v16.16b, v5.16b\n"
    "ext v23.16b, v23.16b, v23.16b, #0x1\n"
    ".inst 0x4e859639  // sdot v25.4s, v17.16b, v5.16b\n"
    "ext v5.16b, v5.16b, v5.16b, #0x1\n"
    ".inst 0x4e979618  // sdot v24.4s, v16.16b, v23.16b\n"
    ".inst 0x4e859603  // sdot v3.4s, v16.16b, v5.16b\n"
    ".inst 0x4e959634  // sdot v20.4s, v17.16b, v21.16b\n"
    ".inst 0x4e9594d9  // sdot v25.4s, v6.16b, v21.16b\n"
    "ext v21.16b, v21.16b, v21.16b, #0x1\n"
    ".inst 0x4e859638  // sdot v24.4s, v17.16b, v5.16b\n"
    ".inst 0x4e959623  // sdot v3.4s, v17.16b, v21.16b\n"
    ".inst 0x4e8194d4  // sdot v20.4s, v6.16b, v1.16b\n"
    "ext v1.16b, v1.16b, v1.16b, #0x1\n"
    "sqrdmulh v25.4s, v25.4s, v4.4s\n"
    ".inst 0x4e9594d8  // sdot v24.4s, v6.16b, v21.16b\n"
    ".inst 0x4e8194c3  // sdot v3.4s, v6.16b, v1.16b\n"
    "and v16.16b, v25.16b, v19.16b\n"
    "sqrdmulh v20.4s, v20.4s, v4.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v24.4s, v24.4s, v4.4s\n"
    "sqrdmulh v3.4s, v3.4s, v4.4s\n"
    "ldr q23, [%x[params], #0xc0]\n"
    "and v18.16b, v20.16b, v19.16b\n"
    "sqadd v25.4s, v25.4s, v16.4s\n"
    "and v17.16b, v24.16b, v19.16b\n"
    "and v16.16b, v3.16b, v19.16b\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v25.4s, v25.4s, v19.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v20.4s, v20.4s, v18.4s\n"
    "ldr q18, [%x[params], #0xb0]\n"
    "sqadd v24.4s, v24.4s, v17.4s\n"
    "ldr q17, [%x[params], #0xa0]\n"
    "add v25.4s, v25.4s, v13.4s\n"
    "sqadd v3.4s, v3.4s, v16.4s\n"
    "ldr q16, [%x[params], #0x90]\n"
    "srshl v20.4s, v20.4s, v19.4s\n"
    "srshl v24.4s, v24.4s, v19.4s\n"
    "smax v25.4s, v25.4s, v27.4s\n"
    "srshl v3.4s, v3.4s, v19.4s\n"
    "ldr q5, [%x[params], #0xd0]\n"
    "add v20.4s, v20.4s, v13.4s\n"
    "add v24.4s, v24.4s, v13.4s\n"
    "smin v25.4s, v25.4s, v11.4s\n"
    "add v3.4s, v3.4s, v13.4s\n"
    "smax v20.4s, v20.4s, v27.4s\n"
    "smax v24.4s, v24.4s, v27.4s\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "smax v3.4s, v3.4s, v27.4s\n"
    "smin v20.4s, v20.4s, v11.4s\n"
    "smin v24.4s, v24.4s, v11.4s\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "smin v3.4s, v3.4s, v11.4s\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "str s25, [x11, x12]\n"
    "ldr q21, [%x[params], #0x80]\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "str s24, [x10, x12]\n"
    "mov v26.16b, v21.16b\n"
    "str s20, [x9, x12]\n"
    "mov v20.16b, v21.16b\n"
    "str s3, [x28, x12]\n"
    "mov v19.16b, v21.16b\n"
    ".inst 0x4e9e9615  // sdot v21.4s, v16.16b, v30.16b\n"
    "add x12, x12, #0x4\n"
    ".inst 0x4e879614  // sdot v20.4s, v16.16b, v7.16b\n"
    "ext v30.16b, v30.16b, v30.16b, #0x1\n"
    ".inst 0x4e879635  // sdot v21.4s, v17.16b, v7.16b\n"
    "ext v7.16b, v7.16b, v7.16b, #0x1\n"
    ".inst 0x4e9e961a  // sdot v26.4s, v16.16b, v30.16b\n"
    ".inst 0x4e879613  // sdot v19.4s, v16.16b, v7.16b\n"
    ".inst 0x4e9d9634  // sdot v20.4s, v17.16b, v29.16b\n"
    ".inst 0x4e9d9655  // sdot v21.4s, v18.16b, v29.16b\n"
    "ext v29.16b, v29.16b, v29.16b, #0x1\n"
    ".inst 0x4e87963a  // sdot v26.4s, v17.16b, v7.16b\n"
    ".inst 0x4e9d9633  // sdot v19.4s, v17.16b, v29.16b\n"
    ".inst 0x4e9f9654  // sdot v20.4s, v18.16b, v31.16b\n"
    "ext v31.16b, v31.16b, v31.16b, #0x1\n"
    "sqrdmulh v21.4s, v21.4s, v23.4s\n"
    ".inst 0x4e9d965a  // sdot v26.4s, v18.16b, v29.16b\n"
    ".inst 0x4e9f9653  // sdot v19.4s, v18.16b, v31.16b\n"
    "and v16.16b, v21.16b, v5.16b\n"
    "sqrdmulh v20.4s, v20.4s, v23.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v26.4s, v26.4s, v23.4s\n"
    "sqrdmulh v19.4s, v19.4s, v23.4s\n"
    "ldr q25, [%x[params], #0x120]\n"
    "and v18.16b, v20.16b, v5.16b\n"
    "sqadd v21.4s, v21.4s, v16.4s\n"
    "and v17.16b, v26.16b, v5.16b\n"
    "and v16.16b, v19.16b, v5.16b\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v21.4s, v21.4s, v5.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v20.4s, v20.4s, v18.4s\n"
    "ldr q18, [%x[params], #0x110]\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "ldr q17, [%x[params], #0x100]\n"
    "add v21.4s, v21.4s, v13.4s\n"
    "sqadd v19.4s, v19.4s, v16.4s\n"
    "ldr q16, [%x[params], #0xf0]\n"
    "srshl v20.4s, v20.4s, v5.4s\n"
    "srshl v26.4s, v26.4s, v5.4s\n"
    "smax v21.4s, v21.4s, v27.4s\n"
    "srshl v19.4s, v19.4s, v5.4s\n"
    "ldr q24, [%x[params], #0x130]\n"
    "add v20.4s, v20.4s, v13.4s\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "smin v21.4s, v21.4s, v11.4s\n"
    "add v19.4s, v19.4s, v13.4s\n"
    "smax v20.4s, v20.4s, v27.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "smax v19.4s, v19.4s, v27.4s\n"
    "smin v20.4s, v20.4s, v11.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "smin v19.4s, v19.4s, v11.4s\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "str s21, [x11, x12]\n"
    "ldr q23, [%x[params], #0xe0]\n"
    "add %x[params], %x[params], #0x140\n"
    "uzp1 v19.16b, v19.16b, v19.16b\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v19.16b, v19.16b, v19.16b\n"
    "str s20, [x9, x12]\n"
    "mov v21.16b, v23.16b\n"
    "str s26, [x10, x12]\n"
    "mov v20.16b, v23.16b\n"
    "str s19, [x28, x12]\n"
    "mov v19.16b, v23.16b\n"
    ".inst 0x4e8e9617  // sdot v23.4s, v16.16b, v14.16b\n"
    "add x12, x12, #0x4\n"
    ".inst 0x4e9c9615  // sdot v21.4s, v16.16b, v28.16b\n"
    "ext v14.16b, v14.16b, v14.16b, #0x1\n"
    ".inst 0x4e9c9637  // sdot v23.4s, v17.16b, v28.16b\n"
    "ext v28.16b, v28.16b, v28.16b, #0x1\n"
    ".inst 0x4e8e9614  // sdot v20.4s, v16.16b, v14.16b\n"
    ".inst 0x4e9c9613  // sdot v19.4s, v16.16b, v28.16b\n"
    ".inst 0x4e969635  // sdot v21.4s, v17.16b, v22.16b\n"
    ".inst 0x4e969657  // sdot v23.4s, v18.16b, v22.16b\n"
    "ext v22.16b, v22.16b, v22.16b, #0x1\n"
    ".inst 0x4e9c9634  // sdot v20.4s, v17.16b, v28.16b\n"
    ".inst 0x4e969633  // sdot v19.4s, v17.16b, v22.16b\n"
    ".inst 0x4e829655  // sdot v21.4s, v18.16b, v2.16b\n"
    "ext v2.16b, v2.16b, v2.16b, #0x1\n"
    "sqrdmulh v23.4s, v23.4s, v25.4s\n"
    ".inst 0x4e969654  // sdot v20.4s, v18.16b, v22.16b\n"
    ".inst 0x4e829653  // sdot v19.4s, v18.16b, v2.16b\n"
    "and v16.16b, v23.16b, v24.16b\n"
    "sqrdmulh v21.4s, v21.4s, v25.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v20.4s, v20.4s, v25.4s\n"
    "sqrdmulh v19.4s, v19.4s, v25.4s\n"
    "and v18.16b, v21.16b, v24.16b\n"
    "sqadd v23.4s, v23.4s, v16.4s\n"
    "and v17.16b, v20.16b, v24.16b\n"
    "and v16.16b, v19.16b, v24.16b\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v23.4s, v23.4s, v24.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v21.4s, v21.4s, v18.4s\n"
    "sqadd v20.4s, v20.4s, v17.4s\n"
    "add v23.4s, v23.4s, v13.4s\n"
    "sqadd v19.4s, v19.4s, v16.4s\n"
    "srshl v21.4s, v21.4s, v24.4s\n"
    "srshl v20.4s, v20.4s, v24.4s\n"
    "smax v23.4s, v23.4s, v27.4s\n"
    "srshl v19.4s, v19.4s, v24.4s\n"
    "add v21.4s, v21.4s, v13.4s\n"
    "add v20.4s, v20.4s, v13.4s\n"
    "smin v23.4s, v23.4s, v11.4s\n"
    "add v19.4s, v19.4s, v13.4s\n"
    "smax v21.4s, v21.4s, v27.4s\n"
    "smax v20.4s, v20.4s, v27.4s\n"
    "uzp1 v23.16b, v23.16b, v23.16b\n"
    "smax v19.4s, v19.4s, v27.4s\n"
    "smin v21.4s, v21.4s, v11.4s\n"
    "smin v20.4s, v20.4s, v11.4s\n"
    "uzp1 v23.16b, v23.16b, v23.16b\n"
    "smin v19.4s, v19.4s, v11.4s\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "str s23, [x11, x12]\n"
    "uzp1 v19.16b, v19.16b, v19.16b\n"
    "uzp1 v21.16b, v21.16b, v21.16b\n"
    "uzp1 v20.16b, v20.16b, v20.16b\n"
    "uzp1 v19.16b, v19.16b, v19.16b\n"
    "str s20, [x10, x12]\n"
    "str s21, [x9, x12]\n"
    "str s19, [x28, x12]\n"
    "add x12, x12, #0x4\n"
    "beq 35f\n"
    "3:"  // Oddments
    "and x20, %x[n_channels], #0xf\n"
    "add x14, x14, x13\n"
    "add x27, x27, x13\n"
    "add x26, x26, x13\n"
    "add x25, x25, x13\n"
    "add x24, x24, x13\n"
    "add x23, x23, x13\n"
    "add x22, x22, x13\n"
    "add x21, x21, x13\n"
    "tbz %x[n_channels], #3, 7f\n"
    "ldr d12, [x14], #0x8\n"
    "ldr d23, [x27], #0x8\n"
    "ldr d30, [x26], #0x8\n"
    "ldr d14, [x25], #0x8\n"
    "ldr d15, [x24], #0x8\n"
    "ldr d5, [x23], #0x8\n"
    "ldr d7, [x22], #0x8\n"
    "ldr d28, [x21], #0x8\n"
    "tbz %x[n_channels], #2, 5f\n"
    "ld1 { v12.s }[2], [x14], #0x4\n"
    "ld1 { v23.s }[2], [x27], #0x4\n"
    "ld1 { v30.s }[2], [x26], #0x4\n"
    "ld1 { v14.s }[2], [x25], #0x4\n"
    "ld1 { v15.s }[2], [x24], #0x4\n"
    "ld1 { v5.s }[2], [x23], #0x4\n"
    "ld1 { v7.s }[2], [x22], #0x4\n"
    "ld1 { v28.s }[2], [x21], #0x4\n"
    "tbz %x[n_channels], #1, 4f\n"
    "ld1 { v12.h }[6], [x14], #0x2\n"
    "ld1 { v23.h }[6], [x27], #0x2\n"
    "ld1 { v30.h }[6], [x26], #0x2\n"
    "ld1 { v14.h }[6], [x25], #0x2\n"
    "ld1 { v15.h }[6], [x24], #0x2\n"
    "ld1 { v5.h }[6], [x23], #0x2\n"
    "ld1 { v7.h }[6], [x22], #0x2\n"
    "ld1 { v28.h }[6], [x21], #0x2\n"
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v12.b }[14], [x14], #0x1\n"
    "ld1 { v23.b }[14], [x27], #0x1\n"
    "ld1 { v30.b }[14], [x26], #0x1\n"
    "ld1 { v14.b }[14], [x25], #0x1\n"
    "ld1 { v15.b }[14], [x24], #0x1\n"
    "ld1 { v5.b }[14], [x23], #0x1\n"
    "ld1 { v7.b }[14], [x22], #0x1\n"
    "ld1 { v28.b }[14], [x21], #0x1\n"
    "b 11f\n"
    "4:"  // Oddments: Load (A): Bit 3: Bit 2: Bit 1: Unset
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v12.b }[12], [x14], #0x1\n"
    "ld1 { v23.b }[12], [x27], #0x1\n"
    "ld1 { v30.b }[12], [x26], #0x1\n"
    "ld1 { v14.b }[12], [x25], #0x1\n"
    "ld1 { v15.b }[12], [x24], #0x1\n"
    "ld1 { v5.b }[12], [x23], #0x1\n"
    "ld1 { v7.b }[12], [x22], #0x1\n"
    "ld1 { v28.b }[12], [x21], #0x1\n"
    "b 11f\n"
    "5:"  // Oddments: Load (A): Bit 3: Bit 2: Unset
    "tbz %x[n_channels], #1, 6f\n"
    "ld1 { v12.h }[4], [x14], #0x2\n"
    "ld1 { v23.h }[4], [x27], #0x2\n"
    "ld1 { v30.h }[4], [x26], #0x2\n"
    "ld1 { v14.h }[4], [x25], #0x2\n"
    "ld1 { v15.h }[4], [x24], #0x2\n"
    "ld1 { v5.h }[4], [x23], #0x2\n"
    "ld1 { v7.h }[4], [x22], #0x2\n"
    "ld1 { v28.h }[4], [x21], #0x2\n"
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v12.b }[10], [x14], #0x1\n"
    "ld1 { v23.b }[10], [x27], #0x1\n"
    "ld1 { v30.b }[10], [x26], #0x1\n"
    "ld1 { v14.b }[10], [x25], #0x1\n"
    "ld1 { v15.b }[10], [x24], #0x1\n"
    "ld1 { v5.b }[10], [x23], #0x1\n"
    "ld1 { v7.b }[10], [x22], #0x1\n"
    "ld1 { v28.b }[10], [x21], #0x1\n"
    "b 11f\n"
    "6:"  // Oddments: Load (A): Bit 3: Bit 2: Unset: Bit 1: Unset
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v12.b }[8], [x14], #0x1\n"
    "ld1 { v23.b }[8], [x27], #0x1\n"
    "ld1 { v30.b }[8], [x26], #0x1\n"
    "ld1 { v14.b }[8], [x25], #0x1\n"
    "ld1 { v15.b }[8], [x24], #0x1\n"
    "ld1 { v5.b }[8], [x23], #0x1\n"
    "ld1 { v7.b }[8], [x22], #0x1\n"
    "ld1 { v28.b }[8], [x21], #0x1\n"
    "b 11f\n"
    "7:"  // Oddments: Load (A): Bit 3: Unset
    "tbz %x[n_channels], #2, 9f\n"
    "ldr s12, [x14], #0x4\n"
    "ldr s23, [x27], #0x4\n"
    "ldr s30, [x26], #0x4\n"
    "ldr s14, [x25], #0x4\n"
    "ldr s15, [x24], #0x4\n"
    "ldr s5, [x23], #0x4\n"
    "ldr s7, [x22], #0x4\n"
    "ldr s28, [x21], #0x4\n"
    "tbz %x[n_channels], #1, 8f\n"
    "ld1 { v12.h }[2], [x14], #0x2\n"
    "ld1 { v23.h }[2], [x27], #0x2\n"
    "ld1 { v30.h }[2], [x26], #0x2\n"
    "ld1 { v14.h }[2], [x25], #0x2\n"
    "ld1 { v15.h }[2], [x24], #0x2\n"
    "ld1 { v5.h }[2], [x23], #0x2\n"
    "ld1 { v7.h }[2], [x22], #0x2\n"
    "ld1 { v28.h }[2], [x21], #0x2\n"
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v12.b }[6], [x14], #0x1\n"
    "ld1 { v23.b }[6], [x27], #0x1\n"
    "ld1 { v30.b }[6], [x26], #0x1\n"
    "ld1 { v14.b }[6], [x25], #0x1\n"
    "ld1 { v15.b }[6], [x24], #0x1\n"
    "ld1 { v5.b }[6], [x23], #0x1\n"
    "ld1 { v7.b }[6], [x22], #0x1\n"
    "ld1 { v28.b }[6], [x21], #0x1\n"
    "b 11f\n"
    "8:"  // Oddments: Load (A): Bit 3: Unset: Bit 2: Bit 1: Unset
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v12.b }[4], [x14], #0x1\n"
    "ld1 { v23.b }[4], [x27], #0x1\n"
    "ld1 { v30.b }[4], [x26], #0x1\n"
    "ld1 { v14.b }[4], [x25], #0x1\n"
    "ld1 { v15.b }[4], [x24], #0x1\n"
    "ld1 { v5.b }[4], [x23], #0x1\n"
    "ld1 { v7.b }[4], [x22], #0x1\n"
    "ld1 { v28.b }[4], [x21], #0x1\n"
    "b 11f\n"
    "9:"  // Oddments: Load (A): Bit 3: Unset: Bit 2: Unset
    "tbz %x[n_channels], #1, 10f\n"
    "ldr h12, [x14], #0x2\n"
    "ldr h23, [x27], #0x2\n"
    "ldr h30, [x26], #0x2\n"
    "ldr h14, [x25], #0x2\n"
    "ldr h15, [x24], #0x2\n"
    "ldr h5, [x23], #0x2\n"
    "ldr h7, [x22], #0x2\n"
    "ldr h28, [x21], #0x2\n"
    "tbz %x[n_channels], #0, 11f\n"
    "ld1 { v12.b }[2], [x14], #0x1\n"
    "ld1 { v23.b }[2], [x27], #0x1\n"
    "ld1 { v30.b }[2], [x26], #0x1\n"
    "ld1 { v14.b }[2], [x25], #0x1\n"
    "ld1 { v15.b }[2], [x24], #0x1\n"
    "ld1 { v5.b }[2], [x23], #0x1\n"
    "ld1 { v7.b }[2], [x22], #0x1\n"
    "ld1 { v28.b }[2], [x21], #0x1\n"
    "b 11f\n"
    "10:"  // Oddments: Load (A): Bit 3: Unset: Bit 2: Unset: Bit 1: Unset
    "ldr b12, [x14], #0x1\n"
    "ldr b23, [x27], #0x1\n"
    "ldr b30, [x26], #0x1\n"
    "ldr b14, [x25], #0x1\n"
    "ldr b15, [x24], #0x1\n"
    "ldr b5, [x23], #0x1\n"
    "ldr b7, [x22], #0x1\n"
    "ldr b28, [x21], #0x1\n"
    "11:"  // Oddments: Load (A): Bit 3: End
    "ldp x14, x27, [%x[inptrs], #0x40]\n"
    "ldp x26, x25, [%x[inptrs], #0x50]\n"
    "ldp x24, x23, [%x[inptrs], #0x60]\n"
    "ldp x22, x21, [%x[inptrs], #0x70]\n"
    "add x14, x14, x13\n"
    "add x27, x27, x13\n"
    "add x26, x26, x13\n"
    "add x25, x25, x13\n"
    "add x24, x24, x13\n"
    "add x23, x23, x13\n"
    "add x22, x22, x13\n"
    "add x21, x21, x13\n"
    "tbz %x[n_channels], #3, 15f\n"
    "ldr d8, [x14], #0x8\n"
    "ldr d21, [x27], #0x8\n"
    "ldr d29, [x26], #0x8\n"
    "ldr d22, [x25], #0x8\n"
    "ldr d9, [x24], #0x8\n"
    "ldr d1, [x23], #0x8\n"
    "ldr d31, [x22], #0x8\n"
    "ldr d2, [x21], #0x8\n"
    "tbz %x[n_channels], #2, 13f\n"
    "ld1 { v8.s }[2], [x14], #0x4\n"
    "ld1 { v21.s }[2], [x27], #0x4\n"
    "ld1 { v29.s }[2], [x26], #0x4\n"
    "ld1 { v22.s }[2], [x25], #0x4\n"
    "ld1 { v9.s }[2], [x24], #0x4\n"
    "ld1 { v1.s }[2], [x23], #0x4\n"
    "ld1 { v31.s }[2], [x22], #0x4\n"
    "ld1 { v2.s }[2], [x21], #0x4\n"
    "tbz %x[n_channels], #1, 12f\n"
    "ld1 { v8.h }[6], [x14], #0x2\n"
    "ld1 { v21.h }[6], [x27], #0x2\n"
    "ld1 { v29.h }[6], [x26], #0x2\n"
    "ld1 { v22.h }[6], [x25], #0x2\n"
    "ld1 { v9.h }[6], [x24], #0x2\n"
    "ld1 { v1.h }[6], [x23], #0x2\n"
    "ld1 { v31.h }[6], [x22], #0x2\n"
    "ld1 { v2.h }[6], [x21], #0x2\n"
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v8.b }[14], [x14], #0x1\n"
    "ld1 { v21.b }[14], [x27], #0x1\n"
    "ld1 { v29.b }[14], [x26], #0x1\n"
    "ld1 { v22.b }[14], [x25], #0x1\n"
    "ld1 { v9.b }[14], [x24], #0x1\n"
    "ld1 { v1.b }[14], [x23], #0x1\n"
    "ld1 { v31.b }[14], [x22], #0x1\n"
    "ld1 { v2.b }[14], [x21], #0x1\n"
    "b 19f\n"
    "12:"  // Oddments: Load (B): Bit 3: Bit 2: Bit 1: Unset
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v8.b }[12], [x14], #0x1\n"
    "ld1 { v21.b }[12], [x27], #0x1\n"
    "ld1 { v29.b }[12], [x26], #0x1\n"
    "ld1 { v22.b }[12], [x25], #0x1\n"
    "ld1 { v9.b }[12], [x24], #0x1\n"
    "ld1 { v1.b }[12], [x23], #0x1\n"
    "ld1 { v31.b }[12], [x22], #0x1\n"
    "ld1 { v2.b }[12], [x21], #0x1\n"
    "b 19f\n"
    "13:"  // Oddments: Load (B): Bit 3: Bit 2: Unset
    "tbz %x[n_channels], #1, 14f\n"
    "ld1 { v8.h }[4], [x14], #0x2\n"
    "ld1 { v21.h }[4], [x27], #0x2\n"
    "ld1 { v29.h }[4], [x26], #0x2\n"
    "ld1 { v22.h }[4], [x25], #0x2\n"
    "ld1 { v9.h }[4], [x24], #0x2\n"
    "ld1 { v1.h }[4], [x23], #0x2\n"
    "ld1 { v31.h }[4], [x22], #0x2\n"
    "ld1 { v2.h }[4], [x21], #0x2\n"
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v8.b }[10], [x14], #0x1\n"
    "ld1 { v21.b }[10], [x27], #0x1\n"
    "ld1 { v29.b }[10], [x26], #0x1\n"
    "ld1 { v22.b }[10], [x25], #0x1\n"
    "ld1 { v9.b }[10], [x24], #0x1\n"
    "ld1 { v1.b }[10], [x23], #0x1\n"
    "ld1 { v31.b }[10], [x22], #0x1\n"
    "ld1 { v2.b }[10], [x21], #0x1\n"
    "b 19f\n"
    "14:"  // Oddments: Load (B): Bit 3: Bit 2: Unset: Bit 1: Unset
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v8.b }[8], [x14], #0x1\n"
    "ld1 { v21.b }[8], [x27], #0x1\n"
    "ld1 { v29.b }[8], [x26], #0x1\n"
    "ld1 { v22.b }[8], [x25], #0x1\n"
    "ld1 { v9.b }[8], [x24], #0x1\n"
    "ld1 { v1.b }[8], [x23], #0x1\n"
    "ld1 { v31.b }[8], [x22], #0x1\n"
    "ld1 { v2.b }[8], [x21], #0x1\n"
    "b 19f\n"
    "15:"  // Oddments: Load (B): Bit 3: Unset
    "tbz %x[n_channels], #2, 17f\n"
    "ldr s8, [x14], #0x4\n"
    "ldr s21, [x27], #0x4\n"
    "ldr s29, [x26], #0x4\n"
    "ldr s22, [x25], #0x4\n"
    "ldr s9, [x24], #0x4\n"
    "ldr s1, [x23], #0x4\n"
    "ldr s31, [x22], #0x4\n"
    "ldr s2, [x21], #0x4\n"
    "tbz %x[n_channels], #1, 16f\n"
    "ld1 { v8.h }[2], [x14], #0x2\n"
    "ld1 { v21.h }[2], [x27], #0x2\n"
    "ld1 { v29.h }[2], [x26], #0x2\n"
    "ld1 { v22.h }[2], [x25], #0x2\n"
    "ld1 { v9.h }[2], [x24], #0x2\n"
    "ld1 { v1.h }[2], [x23], #0x2\n"
    "ld1 { v31.h }[2], [x22], #0x2\n"
    "ld1 { v2.h }[2], [x21], #0x2\n"
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v8.b }[6], [x14], #0x1\n"
    "ld1 { v21.b }[6], [x27], #0x1\n"
    "ld1 { v29.b }[6], [x26], #0x1\n"
    "ld1 { v22.b }[6], [x25], #0x1\n"
    "ld1 { v9.b }[6], [x24], #0x1\n"
    "ld1 { v1.b }[6], [x23], #0x1\n"
    "ld1 { v31.b }[6], [x22], #0x1\n"
    "ld1 { v2.b }[6], [x21], #0x1\n"
    "b 19f\n"
    "16:"  // Oddments: Load (B): Bit 3: Unset: Bit 2: Bit 1: Unset
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v8.b }[4], [x14], #0x1\n"
    "ld1 { v21.b }[4], [x27], #0x1\n"
    "ld1 { v29.b }[4], [x26], #0x1\n"
    "ld1 { v22.b }[4], [x25], #0x1\n"
    "ld1 { v9.b }[4], [x24], #0x1\n"
    "ld1 { v1.b }[4], [x23], #0x1\n"
    "ld1 { v31.b }[4], [x22], #0x1\n"
    "ld1 { v2.b }[4], [x21], #0x1\n"
    "b 19f\n"
    "17:"  // Oddments: Load (B): Bit 3: Unset: Bit 2: Unset
    "tbz %x[n_channels], #1, 18f\n"
    "ldr h8, [x14], #0x2\n"
    "ldr h21, [x27], #0x2\n"
    "ldr h29, [x26], #0x2\n"
    "ldr h22, [x25], #0x2\n"
    "ldr h9, [x24], #0x2\n"
    "ldr h1, [x23], #0x2\n"
    "ldr h31, [x22], #0x2\n"
    "ldr h2, [x21], #0x2\n"
    "tbz %x[n_channels], #0, 19f\n"
    "ld1 { v8.b }[2], [x14], #0x1\n"
    "ld1 { v21.b }[2], [x27], #0x1\n"
    "ld1 { v29.b }[2], [x26], #0x1\n"
    "ld1 { v22.b }[2], [x25], #0x1\n"
    "ld1 { v9.b }[2], [x24], #0x1\n"
    "ld1 { v1.b }[2], [x23], #0x1\n"
    "ld1 { v31.b }[2], [x22], #0x1\n"
    "ld1 { v2.b }[2], [x21], #0x1\n"
    "b 19f\n"
    "18:"  // Oddments: Load (B): Bit 3: Unset: Bit 2: Unset: Bit 1: Unset
    "ldr b8, [x14], #0x1\n"
    "ldr b21, [x27], #0x1\n"
    "ldr b29, [x26], #0x1\n"
    "ldr b22, [x25], #0x1\n"
    "ldr b9, [x24], #0x1\n"
    "ldr b1, [x23], #0x1\n"
    "ldr b31, [x22], #0x1\n"
    "ldr b2, [x21], #0x1\n"
    "19:"  // Oddments: Load (B): Bit 3: End
    "ldr q10, [%x[params], #0x10]\n"
    "ldr q4, [%x[params], #0x20]\n"
    "zip2 v17.16b, v12.16b, v30.16b\n"
    "zip1 v12.16b, v12.16b, v30.16b\n"
    "ldr q25, [%x[params], #0x30]\n"
    "zip1 v16.16b, v23.16b, v14.16b\n"
    "zip2 v14.16b, v23.16b, v14.16b\n"
    "cmp x20, #0x4\n"
    "zip2 v24.16b, v15.16b, v7.16b\n"
    "zip1 v15.16b, v15.16b, v7.16b\n"
    "zip1 v20.16b, v5.16b, v28.16b\n"
    "zip2 v28.16b, v5.16b, v28.16b\n"
    "zip2 v23.16b, v12.16b, v16.16b\n"
    "zip1 v12.16b, v12.16b, v16.16b\n"
    "zip1 v30.16b, v17.16b, v14.16b\n"
    "zip2 v14.16b, v17.16b, v14.16b\n"
    "ldr q3, [%x[params], #0x0]\n"
    "zip2 v19.16b, v8.16b, v29.16b\n"
    "zip1 v8.16b, v8.16b, v29.16b\n"
    "zip1 v18.16b, v21.16b, v22.16b\n"
    "zip2 v22.16b, v21.16b, v22.16b\n"
    "zip2 v17.16b, v9.16b, v31.16b\n"
    "zip1 v9.16b, v9.16b, v31.16b\n"
    "zip1 v16.16b, v1.16b, v2.16b\n"
    "zip2 v2.16b, v1.16b, v2.16b\n"
    "zip2 v5.16b, v15.16b, v20.16b\n"
    "zip1 v15.16b, v15.16b, v20.16b\n"
    "zip1 v7.16b, v24.16b, v28.16b\n"
    "zip2 v28.16b, v24.16b, v28.16b\n"
    "zip2 v21.16b, v8.16b, v18.16b\n"
    "zip1 v8.16b, v8.16b, v18.16b\n"
    "zip1 v29.16b, v19.16b, v22.16b\n"
    "zip2 v22.16b, v19.16b, v22.16b\n"
    "zip2 v1.16b, v9.16b, v16.16b\n"
    "zip1 v9.16b, v9.16b, v16.16b\n"
    "zip1 v31.16b, v17.16b, v2.16b\n"
    "zip2 v2.16b, v17.16b, v2.16b\n"
    "mov v26.16b, v3.16b\n"
    "mov v0.16b, v3.16b\n"
    "mov v18.16b, v3.16b\n"
    ".inst 0x4e8c9543  // sdot v3.4s, v10.16b, v12.16b\n"
    ".inst 0x4e8f9540  // sdot v0.4s, v10.16b, v15.16b\n"
    "ext v12.16b, v12.16b, v12.16b, #0x1\n"
    ".inst 0x4e8f9483  // sdot v3.4s, v4.16b, v15.16b\n"
    "ext v15.16b, v15.16b, v15.16b, #0x1\n"
    ".inst 0x4e8c955a  // sdot v26.4s, v10.16b, v12.16b\n"
    "ldr q17, [%x[params], #0x40]\n"
    ".inst 0x4e889480  // sdot v0.4s, v4.16b, v8.16b\n"
    ".inst 0x4e8f9552  // sdot v18.4s, v10.16b, v15.16b\n"
    ".inst 0x4e889723  // sdot v3.4s, v25.16b, v8.16b\n"
    "ext v8.16b, v8.16b, v8.16b, #0x1\n"
    ".inst 0x4e8f949a  // sdot v26.4s, v4.16b, v15.16b\n"
    "ldr q20, [%x[params], #0x50]\n"
    "add %x[params], %x[params], #0x60\n"
    ".inst 0x4e899720  // sdot v0.4s, v25.16b, v9.16b\n"
    "ext v9.16b, v9.16b, v9.16b, #0x1\n"
    ".inst 0x4e889492  // sdot v18.4s, v4.16b, v8.16b\n"
    "sqrdmulh v3.4s, v3.4s, v17.4s\n"
    ".inst 0x4e88973a  // sdot v26.4s, v25.16b, v8.16b\n"
    "sqrdmulh v0.4s, v0.4s, v17.4s\n"
    ".inst 0x4e899732  // sdot v18.4s, v25.16b, v9.16b\n"
    "and v16.16b, v3.16b, v20.16b\n"
    "sqrdmulh v26.4s, v26.4s, v17.4s\n"
    "and v19.16b, v0.16b, v20.16b\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v18.4s, v18.4s, v17.4s\n"
    "and v17.16b, v26.16b, v20.16b\n"
    "sqadd v3.4s, v3.4s, v16.4s\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "and v16.16b, v18.16b, v20.16b\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sqadd v0.4s, v0.4s, v19.4s\n"
    "srshl v3.4s, v3.4s, v20.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "srshl v0.4s, v0.4s, v20.4s\n"
    "add v3.4s, v3.4s, v13.4s\n"
    "sqadd v18.4s, v18.4s, v16.4s\n"
    "srshl v26.4s, v26.4s, v20.4s\n"
    "add v0.4s, v0.4s, v13.4s\n"
    "smax v3.4s, v3.4s, v27.4s\n"
    "srshl v18.4s, v18.4s, v20.4s\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "smax v0.4s, v0.4s, v27.4s\n"
    "smin v3.4s, v3.4s, v11.4s\n"
    "add v18.4s, v18.4s, v13.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "smin v0.4s, v0.4s, v11.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smax v18.4s, v18.4s, v27.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smin v18.4s, v18.4s, v11.4s\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "blt 20f\n"
    "str s3, [x11, x12]\n"
    "str s26, [x10, x12]\n"
    "str s0, [x9, x12]\n"
    "str s18, [x28, x12]\n"
    "b 23f\n"
    "20:"  // Oddments: Unroll 0: Oddment store
    "add x11, x11, x12\n"
    "add x10, x10, x12\n"
    "add x9, x9, x12\n"
    "add x28, x28, x12\n"
    "tbz x20, #1, 21f\n"
    "st1 { v3.h }[0], [x11], #0x2\n"
    "st1 { v26.h }[0], [x10], #0x2\n"
    "st1 { v0.h }[0], [x9], #0x2\n"
    "st1 { v18.h }[0], [x28], #0x2\n"
    "tbz x20, #0, 22f\n"
    "st1 { v3.b }[2], [x11], #0x1\n"
    "st1 { v26.b }[2], [x10], #0x1\n"
    "st1 { v0.b }[2], [x9], #0x1\n"
    "st1 { v18.b }[2], [x28], #0x1\n"
    "b 22f\n"
    "21:"  // Oddments: Unroll 0: Oddment store: Bit 1: Unset
    "st1 { v3.b }[0], [x11], #0x1\n"
    "st1 { v26.b }[0], [x10], #0x1\n"
    "st1 { v0.b }[0], [x9], #0x1\n"
    "st1 { v18.b }[0], [x28], #0x1\n"
    "22:"  // Oddments: Unroll 0: Oddment store: Bit 1: End
    "23:"  // Oddments: Unroll 0: After oddment store
    "subs x20, x20, #0x4\n"
    "add x12, x12, #0x4\n"
    "ble 35f\n"
    "ldr q3, [%x[params], #0x0]\n"
    "ldr q25, [%x[params], #0x10]\n"
    "cmp x20, #0x4\n"
    "ldr q24, [%x[params], #0x20]\n"
    "ldr q16, [%x[params], #0x30]\n"
    "ldr q17, [%x[params], #0x40]\n"
    "ldr q20, [%x[params], #0x50]\n"
    "add %x[params], %x[params], #0x60\n"
    "mov v26.16b, v3.16b\n"
    "mov v0.16b, v3.16b\n"
    "mov v18.16b, v3.16b\n"
    ".inst 0x4e979723  // sdot v3.4s, v25.16b, v23.16b\n"
    "ext v23.16b, v23.16b, v23.16b, #0x1\n"
    ".inst 0x4e859720  // sdot v0.4s, v25.16b, v5.16b\n"
    ".inst 0x4e859703  // sdot v3.4s, v24.16b, v5.16b\n"
    "ext v5.16b, v5.16b, v5.16b, #0x1\n"
    ".inst 0x4e97973a  // sdot v26.4s, v25.16b, v23.16b\n"
    ".inst 0x4e859732  // sdot v18.4s, v25.16b, v5.16b\n"
    ".inst 0x4e959700  // sdot v0.4s, v24.16b, v21.16b\n"
    ".inst 0x4e959603  // sdot v3.4s, v16.16b, v21.16b\n"
    "ext v21.16b, v21.16b, v21.16b, #0x1\n"
    ".inst 0x4e85971a  // sdot v26.4s, v24.16b, v5.16b\n"
    ".inst 0x4e959712  // sdot v18.4s, v24.16b, v21.16b\n"
    ".inst 0x4e819600  // sdot v0.4s, v16.16b, v1.16b\n"
    "ext v1.16b, v1.16b, v1.16b, #0x1\n"
    "sqrdmulh v3.4s, v3.4s, v17.4s\n"
    ".inst 0x4e95961a  // sdot v26.4s, v16.16b, v21.16b\n"
    ".inst 0x4e819612  // sdot v18.4s, v16.16b, v1.16b\n"
    "and v16.16b, v3.16b, v20.16b\n"
    "sqrdmulh v0.4s, v0.4s, v17.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v26.4s, v26.4s, v17.4s\n"
    "sqrdmulh v18.4s, v18.4s, v17.4s\n"
    "and v19.16b, v0.16b, v20.16b\n"
    "sqadd v3.4s, v3.4s, v16.4s\n"
    "and v17.16b, v26.16b, v20.16b\n"
    "and v16.16b, v18.16b, v20.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v3.4s, v3.4s, v20.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v0.4s, v0.4s, v19.4s\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "add v3.4s, v3.4s, v13.4s\n"
    "sqadd v18.4s, v18.4s, v16.4s\n"
    "srshl v0.4s, v0.4s, v20.4s\n"
    "srshl v26.4s, v26.4s, v20.4s\n"
    "smax v3.4s, v3.4s, v27.4s\n"
    "srshl v18.4s, v18.4s, v20.4s\n"
    "add v0.4s, v0.4s, v13.4s\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "smin v3.4s, v3.4s, v11.4s\n"
    "add v18.4s, v18.4s, v13.4s\n"
    "smax v0.4s, v0.4s, v27.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smax v18.4s, v18.4s, v27.4s\n"
    "smin v0.4s, v0.4s, v11.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smin v18.4s, v18.4s, v11.4s\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "blt 24f\n"
    "str s3, [x11, x12]\n"
    "str s26, [x10, x12]\n"
    "str s0, [x9, x12]\n"
    "str s18, [x28, x12]\n"
    "b 27f\n"
    "24:"  // Oddments: Unroll 1: Oddment store
    "add x11, x11, x12\n"
    "add x10, x10, x12\n"
    "add x9, x9, x12\n"
    "add x28, x28, x12\n"
    "tbz x20, #1, 25f\n"
    "st1 { v3.h }[0], [x11], #0x2\n"
    "st1 { v26.h }[0], [x10], #0x2\n"
    "st1 { v0.h }[0], [x9], #0x2\n"
    "st1 { v18.h }[0], [x28], #0x2\n"
    "tbz x20, #0, 26f\n"
    "st1 { v3.b }[2], [x11], #0x1\n"
    "st1 { v26.b }[2], [x10], #0x1\n"
    "st1 { v0.b }[2], [x9], #0x1\n"
    "st1 { v18.b }[2], [x28], #0x1\n"
    "b 26f\n"
    "25:"  // Oddments: Unroll 1: Oddment store: Bit 1: Unset
    "st1 { v3.b }[0], [x11], #0x1\n"
    "st1 { v26.b }[0], [x10], #0x1\n"
    "st1 { v0.b }[0], [x9], #0x1\n"
    "st1 { v18.b }[0], [x28], #0x1\n"
    "26:"  // Oddments: Unroll 1: Oddment store: Bit 1: End
    "27:"  // Oddments: Unroll 1: After oddment store
    "subs x20, x20, #0x4\n"
    "add x12, x12, #0x4\n"
    "ble 35f\n"
    "ldr q3, [%x[params], #0x0]\n"
    "ldr q23, [%x[params], #0x10]\n"
    "cmp x20, #0x4\n"
    "ldr q21, [%x[params], #0x20]\n"
    "ldr q16, [%x[params], #0x30]\n"
    "ldr q17, [%x[params], #0x40]\n"
    "ldr q20, [%x[params], #0x50]\n"
    "add %x[params], %x[params], #0x60\n"
    "mov v26.16b, v3.16b\n"
    "mov v0.16b, v3.16b\n"
    "mov v18.16b, v3.16b\n"
    ".inst 0x4e9e96e3  // sdot v3.4s, v23.16b, v30.16b\n"
    "ext v30.16b, v30.16b, v30.16b, #0x1\n"
    ".inst 0x4e8796e0  // sdot v0.4s, v23.16b, v7.16b\n"
    ".inst 0x4e8796a3  // sdot v3.4s, v21.16b, v7.16b\n"
    "ext v7.16b, v7.16b, v7.16b, #0x1\n"
    ".inst 0x4e9e96fa  // sdot v26.4s, v23.16b, v30.16b\n"
    ".inst 0x4e8796f2  // sdot v18.4s, v23.16b, v7.16b\n"
    ".inst 0x4e9d96a0  // sdot v0.4s, v21.16b, v29.16b\n"
    ".inst 0x4e9d9603  // sdot v3.4s, v16.16b, v29.16b\n"
    "ext v29.16b, v29.16b, v29.16b, #0x1\n"
    ".inst 0x4e8796ba  // sdot v26.4s, v21.16b, v7.16b\n"
    ".inst 0x4e9d96b2  // sdot v18.4s, v21.16b, v29.16b\n"
    ".inst 0x4e9f9600  // sdot v0.4s, v16.16b, v31.16b\n"
    "ext v31.16b, v31.16b, v31.16b, #0x1\n"
    "sqrdmulh v3.4s, v3.4s, v17.4s\n"
    ".inst 0x4e9d961a  // sdot v26.4s, v16.16b, v29.16b\n"
    ".inst 0x4e9f9612  // sdot v18.4s, v16.16b, v31.16b\n"
    "and v16.16b, v3.16b, v20.16b\n"
    "sqrdmulh v0.4s, v0.4s, v17.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v26.4s, v26.4s, v17.4s\n"
    "sqrdmulh v18.4s, v18.4s, v17.4s\n"
    "and v19.16b, v0.16b, v20.16b\n"
    "sqadd v3.4s, v3.4s, v16.4s\n"
    "and v17.16b, v26.16b, v20.16b\n"
    "and v16.16b, v18.16b, v20.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v3.4s, v3.4s, v20.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v0.4s, v0.4s, v19.4s\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "add v3.4s, v3.4s, v13.4s\n"
    "sqadd v18.4s, v18.4s, v16.4s\n"
    "srshl v0.4s, v0.4s, v20.4s\n"
    "srshl v26.4s, v26.4s, v20.4s\n"
    "smax v3.4s, v3.4s, v27.4s\n"
    "srshl v18.4s, v18.4s, v20.4s\n"
    "add v0.4s, v0.4s, v13.4s\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "smin v3.4s, v3.4s, v11.4s\n"
    "add v18.4s, v18.4s, v13.4s\n"
    "smax v0.4s, v0.4s, v27.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smax v18.4s, v18.4s, v27.4s\n"
    "smin v0.4s, v0.4s, v11.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smin v18.4s, v18.4s, v11.4s\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "blt 28f\n"
    "str s3, [x11, x12]\n"
    "str s26, [x10, x12]\n"
    "str s0, [x9, x12]\n"
    "str s18, [x28, x12]\n"
    "b 31f\n"
    "28:"  // Oddments: Unroll 2: Oddment store
    "add x11, x11, x12\n"
    "add x10, x10, x12\n"
    "add x9, x9, x12\n"
    "add x28, x28, x12\n"
    "tbz x20, #1, 29f\n"
    "st1 { v3.h }[0], [x11], #0x2\n"
    "st1 { v26.h }[0], [x10], #0x2\n"
    "st1 { v0.h }[0], [x9], #0x2\n"
    "st1 { v18.h }[0], [x28], #0x2\n"
    "tbz x20, #0, 30f\n"
    "st1 { v3.b }[2], [x11], #0x1\n"
    "st1 { v26.b }[2], [x10], #0x1\n"
    "st1 { v0.b }[2], [x9], #0x1\n"
    "st1 { v18.b }[2], [x28], #0x1\n"
    "b 30f\n"
    "29:"  // Oddments: Unroll 2: Oddment store: Bit 1: Unset
    "st1 { v3.b }[0], [x11], #0x1\n"
    "st1 { v26.b }[0], [x10], #0x1\n"
    "st1 { v0.b }[0], [x9], #0x1\n"
    "st1 { v18.b }[0], [x28], #0x1\n"
    "30:"  // Oddments: Unroll 2: Oddment store: Bit 1: End
    "31:"  // Oddments: Unroll 2: After oddment store
    "subs x20, x20, #0x4\n"
    "add x12, x12, #0x4\n"
    "ble 35f\n"
    "ldr q3, [%x[params], #0x0]\n"
    "ldr q20, [%x[params], #0x10]\n"
    "ldr q17, [%x[params], #0x20]\n"
    "ldr q16, [%x[params], #0x30]\n"
    "ldr q1, [%x[params], #0x40]\n"
    "ldr q19, [%x[params], #0x50]\n"
    "add %x[params], %x[params], #0x60\n"
    "mov v26.16b, v3.16b\n"
    "mov v0.16b, v3.16b\n"
    "mov v18.16b, v3.16b\n"
    ".inst 0x4e8e9683  // sdot v3.4s, v20.16b, v14.16b\n"
    "ext v14.16b, v14.16b, v14.16b, #0x1\n"
    ".inst 0x4e9c9680  // sdot v0.4s, v20.16b, v28.16b\n"
    ".inst 0x4e9c9623  // sdot v3.4s, v17.16b, v28.16b\n"
    "ext v28.16b, v28.16b, v28.16b, #0x1\n"
    ".inst 0x4e8e969a  // sdot v26.4s, v20.16b, v14.16b\n"
    ".inst 0x4e9c9692  // sdot v18.4s, v20.16b, v28.16b\n"
    ".inst 0x4e969620  // sdot v0.4s, v17.16b, v22.16b\n"
    ".inst 0x4e969603  // sdot v3.4s, v16.16b, v22.16b\n"
    "ext v22.16b, v22.16b, v22.16b, #0x1\n"
    ".inst 0x4e9c963a  // sdot v26.4s, v17.16b, v28.16b\n"
    ".inst 0x4e969632  // sdot v18.4s, v17.16b, v22.16b\n"
    ".inst 0x4e829600  // sdot v0.4s, v16.16b, v2.16b\n"
    "ext v2.16b, v2.16b, v2.16b, #0x1\n"
    "sqrdmulh v3.4s, v3.4s, v1.4s\n"
    ".inst 0x4e96961a  // sdot v26.4s, v16.16b, v22.16b\n"
    ".inst 0x4e829612  // sdot v18.4s, v16.16b, v2.16b\n"
    "and v16.16b, v3.16b, v19.16b\n"
    "sqrdmulh v0.4s, v0.4s, v1.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v26.4s, v26.4s, v1.4s\n"
    "sqrdmulh v18.4s, v18.4s, v1.4s\n"
    "and v29.16b, v0.16b, v19.16b\n"
    "sqadd v3.4s, v3.4s, v16.4s\n"
    "and v17.16b, v26.16b, v19.16b\n"
    "and v16.16b, v18.16b, v19.16b\n"
    "sshr v29.4s, v29.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v3.4s, v3.4s, v19.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v0.4s, v0.4s, v29.4s\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "add v3.4s, v3.4s, v13.4s\n"
    "sqadd v18.4s, v18.4s, v16.4s\n"
    "srshl v0.4s, v0.4s, v19.4s\n"
    "srshl v26.4s, v26.4s, v19.4s\n"
    "smax v3.4s, v3.4s, v27.4s\n"
    "srshl v18.4s, v18.4s, v19.4s\n"
    "add v0.4s, v0.4s, v13.4s\n"
    "add v26.4s, v26.4s, v13.4s\n"
    "smin v3.4s, v3.4s, v11.4s\n"
    "add v18.4s, v18.4s, v13.4s\n"
    "smax v0.4s, v0.4s, v27.4s\n"
    "smax v26.4s, v26.4s, v27.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smax v18.4s, v18.4s, v27.4s\n"
    "smin v0.4s, v0.4s, v11.4s\n"
    "smin v26.4s, v26.4s, v11.4s\n"
    "uzp1 v3.16b, v3.16b, v3.16b\n"
    "smin v18.4s, v18.4s, v11.4s\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "uzp1 v0.16b, v0.16b, v0.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v18.16b, v18.16b, v18.16b\n"
    "32:"  // Oddments: Unroll 3: Oddment store
    "add x11, x11, x12\n"
    "add x10, x10, x12\n"
    "add x9, x9, x12\n"
    "add x28, x28, x12\n"
    "tbz x20, #1, 33f\n"
    "st1 { v3.h }[0], [x11], #0x2\n"
    "st1 { v26.h }[0], [x10], #0x2\n"
    "st1 { v0.h }[0], [x9], #0x2\n"
    "st1 { v18.h }[0], [x28], #0x2\n"
    "tbz x20, #0, 34f\n"
    "st1 { v3.b }[2], [x11], #0x1\n"
    "st1 { v26.b }[2], [x10], #0x1\n"
    "st1 { v0.b }[2], [x9], #0x1\n"
    "st1 { v18.b }[2], [x28], #0x1\n"
    "b 34f\n"
    "33:"  // Oddments: Unroll 3: Oddment store: Bit 1: Unset
    "st1 { v3.b }[0], [x11], #0x1\n"
    "st1 { v26.b }[0], [x10], #0x1\n"
    "st1 { v0.b }[0], [x9], #0x1\n"
    "st1 { v18.b }[0], [x28], #0x1\n"
    "34:"  // Oddments: Unroll 3: Oddment store: Bit 1: End
    "35:"  // End
    : [params] "+&r" (params)
    : [inptrs] "r" (inptrs), [n_channels] "r" (n_channels), [offsetof_Requantize32_c_offset] "I" (offsetof(arm_gemm::Requantize32, c_offset)), [offsetof_Requantize32_maxval] "I" (offsetof(arm_gemm::Requantize32, maxval)), [offsetof_Requantize32_minval] "I" (offsetof(arm_gemm::Requantize32, minval)), [outptrs] "r" (outptrs), [qp] "r" (&qp)
    : "cc", "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(__aarch64__)
