/*
 * Copyright (c) 2022-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(ARM_COMPUTE_ENABLE_SME2)

#include <algorithm>
#include <cstddef>

namespace arm_conv {
namespace depthwise {

void sme2_fp32bf16fp32_planar_3x3_s2_4rows_dot_za_impl(
  const float *inptr,
  size_t ld_in_row,
  size_t ld_in_col,
  size_t ld_in_vl,
  unsigned int pad_top,
  unsigned int valid_input_rows,
  unsigned int pad_left,
  unsigned int valid_input_cols,
  const float *weights,
  const float *bias,
  float **outptrs,
  const size_t *outlds,
  const size_t *outvllds,
  unsigned int output_cols,
  unsigned int start_channel,
  unsigned int valid_channels,
  float act_min,
  float act_max
)
{
  struct Args
  {
    const float *inptr;
    size_t ld_in_vl;
    long unsigned int pad_top, pad_bottom, pad_left;
    const float *weights;
    const float *bias;
    long unsigned int input_cols, output_cols;
    float **outptrs;
    const size_t *ld_out_cols;
    const size_t *ld_out_vls;
    long unsigned int current_channel, n_channels;
    float clamp_min, clamp_max;
  };

  Args args = { inptr, ld_in_vl, pad_top, 9u - std::min(9u, pad_top + valid_input_rows), pad_left, weights, bias, valid_input_cols, output_cols, outptrs, outlds, outvllds, start_channel, valid_channels, act_min, act_max };

  __asm__ __volatile__(
    "ldr x7, [%x[args], %[offsetof_Args_pad_bottom]]\n"
    "mov x20, #0x9\n"
    ".inst 0xd503477f  // SMSTART ZA\n"
    "ldr x17, [%x[args], %[offsetof_Args_pad_top]]\n"
    "ptrue p2.b\n"
    "ldr x16, [%x[args], %[offsetof_Args_n_channels]]\n"
    "ld1rw { z24.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_min]]\n"
    "sub x20, x20, x7\n"
    "ldr x15, [%x[args], %[offsetof_Args_current_channel]]\n"
    "ld1rw { z13.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_max]]\n"
    "whilelt p1.s, XZR, x16\n"
    "whilelt p9.s, XZR, x20\n"
    "whilelt p8.s, XZR, x17\n"
    "eor p8.b, p2/Z, p8.b, p9.b\n"
    "1:"  // Channel loop
    "ldr x20, [%x[args], %[offsetof_Args_bias]]\n"
    "fmov z20.s, #0x0\n"
    "cbz x20, 2f\n"
    "ld1w { z20.s }, p1/Z, [x20, x15, LSL #2]\n"
    "2:"  // Load bias: Done
    "ldr x25, [%x[args], %[offsetof_Args_weights]]\n"
    "mov x24, #0x9\n"
    "add x20, x17, x7\n"
    "mov z21.d, z20.d\n"
    "ldr x14, [%x[args], %[offsetof_Args_input_cols]]\n"
    "lsl x23, %x[ld_in_row], #0x2\n"
    "mov z22.d, z20.d\n"
    "mov z23.d, z20.d\n"
    "ldr x13, [%x[args], %[offsetof_Args_inptr]]\n"
    "mov x8, #0x0\n"
    "sub x24, x24, x20\n"
    "mov x22, x25\n"
    "incb x25\n"
    "ldr x11, [%x[args], %[offsetof_Args_output_cols]]\n"
    "ld1w { z5.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #3\n"
    "sub x20, x14, #0x1\n"
    "ld1w { z14.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #3\n"
    "orr x21, x20, %x[ld_in_col], LSL #18\n"
    "ld1w { z29.s }, p2/Z, [x22]\n"
    "mov x20, x25\n"
    "incb x25\n"
    ".inst 0x658aa8ab  // bfcvt z11.h, p2/M, z5.s\n"
    "ld1w { z28.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #3\n"
    "orr x21, x16, x21, LSL #20\n"
    "lsl x21, x21, #0x2\n"
    "madd x23, x23, x17, x13\n"
    ".inst 0x658aaba9  // bfcvt z9.h, p2/M, z29.s\n"
    ".inst 0x658aab84  // bfcvt z4.h, p2/M, z28.s\n"
    ".inst 0x648aa9cb  // bfcvtnt z11.h, p2/M, z14.s\n"
    "ld1w { z19.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #3\n"
    "ld1w { z12.s }, p2/Z, [x20]\n"
    "mov x20, x25\n"
    "ld1w { z16.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #3\n"
    ".inst 0x648aaa64  // bfcvtnt z4.h, p2/M, z19.s\n"
    "ld1w { z3.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #3\n"
    ".inst 0x658aa985  // bfcvt z5.h, p2/M, z12.s\n"
    "ld1w { z15.s }, p2/Z, [x20]\n"
    ".inst 0x658aaa0a  // bfcvt z10.h, p2/M, z16.s\n"
    ".inst 0x658aa9e6  // bfcvt z6.h, p2/M, z15.s\n"
    ".inst 0x648aa86a  // bfcvtnt z10.h, p2/M, z3.s\n"
    "3:"  // Issue prefetches
    "subs x24, x24, #0x1\n"
    ".inst 0xf8b54afc  // rprfm pldstrm, x21, [x23]\n"
    "add x23, x23, %x[ld_in_col], LSL #2\n"
    "bgt 3b\n"
    "ldr x23, [%x[args], %[offsetof_Args_outptrs]]\n"
    "lsl x21, %x[ld_in_row], #0x2\n"
    ".inst 0xc0040e80  // mova za.d[x8, #0], { z20.d-z23.d }\n"
    "mov x22, #0x2\n"
    "ldr x20, [%x[args], %[offsetof_Args_ld_out_cols]]\n"
    "msub x13, x17, x21, x13\n"
    ".inst 0xc0040e81  // mova za.d[x8, #1], { z20.d-z23.d }\n"
    "ldr x21, [%x[args], %[offsetof_Args_pad_left]]\n"
    ".inst 0xc0040e82  // mova za.d[x8, #2], { z20.d-z23.d }\n"
    "ldp x10, x9, [x23], #0x10\n"
    "ldp x28, x27, [x20], #0x10\n"
    "ldp x26, x25, [x23], #0x10\n"
    "ldp x24, x23, [x20], #0x10\n"
    "cbz x21, 5f\n"
    "cmp x21, x22\n"
    "csel x20, x21, x22, LT\n"
    "sub x21, x21, x20\n"
    "sub x22, x22, x20\n"
    "cbz x21, 5f\n"
    ".inst 0xc0060c10  // mova { z16.d-z19.d }, za.d[x8, #0]\n"
    "and x22, x21, #0x1\n"
    "add x21, x21, #0x1\n"
    "lsr x21, x21, #0x1\n"
    "sub x11, x11, x21\n"
    ".inst 0xc1adcb10  // fclamp { z16.s-z19.s }, z24.s, z13.s\n"
    "4:"  // Left padding
    "subs x21, x21, #0x1\n"
    "st1w { z16.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z17.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z18.s }, p1, [x26]\n"
    "add x26, x26, x24, LSL #2\n"
    "st1w { z19.s }, p1, [x25]\n"
    "add x25, x25, x23, LSL #2\n"
    "bgt 4b\n"
    "5:"  // Left padding: End
    "adds XZR, x17, x7\n"
    "bne 10f\n"
    "cbz x22, 8f\n"
    "cmp x22, #0x1\n"
    "sub x14, x14, x22\n"
    "beq 7f\n"
    "6:"  // Unpadded: 2 priming loads
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    "ld1w { z25.s }, p1/Z, [x13]\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    "ld1w { z8.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z18.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z26.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab3e  // bfcvt z30.h, p2/M, z25.s\n"
    "ld1w { z16.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z3.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa5f  // bfcvt z31.h, p2/M, z18.s\n"
    "ld1w { z14.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa00  // bfcvt z0.h, p2/M, z16.s\n"
    "ld1w { z27.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa91e  // bfcvtnt z30.h, p2/M, z8.s\n"
    "ld1w { z8.s }, p1/Z, [x20]\n"
    ".inst 0x658aa9c1  // bfcvt z1.h, p2/M, z14.s\n"
    ".inst 0x648aab5f  // bfcvtnt z31.h, p2/M, z26.s\n"
    ".inst 0x648aa860  // bfcvtnt z0.h, p2/M, z3.s\n"
    ".inst 0x658aa902  // bfcvt z2.h, p2/M, z8.s\n"
    ".inst 0x648aab61  // bfcvtnt z1.h, p2/M, z27.s\n"
    ".inst 0xc13b13d0  // bfdot za.s[x8, 0], { z30.h-z1.h }, z11.h\n"
    ".inst 0xc13913f0  // bfdot za.s[x8, 0], { z31.h-z2.h }, z9.h\n"
    "7:"  // Unpadded: 1 priming loads
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    "ld1w { z31.s }, p1/Z, [x13]\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    "ld1w { z0.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z19.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z8.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabf9  // bfcvt z25.h, p2/M, z31.s\n"
    "ld1w { z29.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z3.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa7a  // bfcvt z26.h, p2/M, z19.s\n"
    "ld1w { z12.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabbb  // bfcvt z27.h, p2/M, z29.s\n"
    "ld1w { z19.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa819  // bfcvtnt z25.h, p2/M, z0.s\n"
    "ld1w { z7.s }, p1/Z, [x20]\n"
    ".inst 0x658aa99c  // bfcvt z28.h, p2/M, z12.s\n"
    ".inst 0x648aa91a  // bfcvtnt z26.h, p2/M, z8.s\n"
    ".inst 0x648aa87b  // bfcvtnt z27.h, p2/M, z3.s\n"
    ".inst 0x658aa8fd  // bfcvt z29.h, p2/M, z7.s\n"
    ".inst 0x648aaa7c  // bfcvtnt z28.h, p2/M, z19.s\n"
    ".inst 0xc1341330  // bfdot za.s[x8, 0], { z25.h-z28.h }, z4.h\n"
    ".inst 0xc1351350  // bfdot za.s[x8, 0], { z26.h-z29.h }, z5.h\n"
    "8:"  // Unpadded: 0 priming loads
    "cmp x14, #0x2\n"
    "blt 16f\n"
    "add x21, x13, %x[ld_in_row], LSL #2\n"
    "ld1w { z17.s }, p1/Z, [x13]\n"
    "sub x14, x14, #0x2\n"
    "ld1w { z18.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "sub x11, x11, #0x1\n"
    "ld1w { z16.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "lsr x20, x14, #0x1\n"
    "ld1w { z19.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa2f  // bfcvt z15.h, p2/M, z17.s\n"
    "cmp x20, x11\n"
    "ld1w { z17.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "csel x22, x20, x11, LT\n"
    "ld1w { z30.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "and x14, x14, #0x1\n"
    "ld1w { z29.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa31  // bfcvt z17.h, p2/M, z17.s\n"
    ".inst 0x648aaa4f  // bfcvtnt z15.h, p2/M, z18.s\n"
    "ld1w { z0.s }, p1/Z, [x21]\n"
    "sub x11, x11, x22\n"
    ".inst 0x658aab52  // bfcvt z18.h, p2/M, z26.s\n"
    ".inst 0x648aaa70  // bfcvtnt z16.h, p2/M, z19.s\n"
    ".inst 0x648aabd1  // bfcvtnt z17.h, p2/M, z30.s\n"
    ".inst 0x658aa813  // bfcvt z19.h, p2/M, z0.s\n"
    ".inst 0x648aabb2  // bfcvtnt z18.h, p2/M, z29.s\n"
    "cbz x22, 15f\n"
    "9:"  // Unpadded: Main loop
    "add x21, x13, %x[ld_in_row], LSL #2\n"
    "ld1w { z14.s }, p1/Z, [x13]\n"
    ".inst 0xc13a11f0  // bfdot za.s[x8, 0], { z15.h-z18.h }, z10.h\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13b11f1  // bfdot za.s[x8, 1], { z15.h-z18.h }, z11.h\n"
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    "ld1w { z25.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "subs x22, x22, #0x1\n"
    "ld1w { z27.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa9dc  // bfcvt z28.h, p2/M, z14.s\n"
    "ld1w { z2.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1361210  // bfdot za.s[x8, 0], { z16.h-z19.h }, z6.h\n"
    "ld1w { z8.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1391211  // bfdot za.s[x8, 1], { z16.h-z19.h }, z9.h\n"
    ".inst 0x658aab3d  // bfcvt z29.h, p2/M, z25.s\n"
    "ld1w { z7.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa85e  // bfcvt z30.h, p2/M, z2.s\n"
    "ld1w { z1.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab5c  // bfcvtnt z28.h, p2/M, z26.s\n"
    "ld1w { z15.s }, p1/Z, [x13]\n"
    ".inst 0xc0060c10  // mova { z16.d-z19.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    ".inst 0x658aa8ff  // bfcvt z31.h, p2/M, z7.s\n"
    ".inst 0x648aab7d  // bfcvtnt z29.h, p2/M, z27.s\n"
    "ld1w { z7.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z25.s }, p1/Z, [x21]\n"
    ".inst 0xc0040e82  // mova za.d[x8, #2], { z20.d-z23.d }\n"
    ".inst 0x648aa91e  // bfcvtnt z30.h, p2/M, z8.s\n"
    "ld1w { z2.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z26.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1adcb10  // fclamp { z16.s-z19.s }, z24.s, z13.s\n"
    ".inst 0x648aa83f  // bfcvtnt z31.h, p2/M, z1.s\n"
    "ld1w { z8.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab20  // bfcvt z0.h, p2/M, z25.s\n"
    "ld1w { z27.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z1.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z25.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "st1w { z16.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    ".inst 0xc1341390  // bfdot za.s[x8, 0], { z28.h-z31.h }, z4.h\n"
    ".inst 0x658aa9ef  // bfcvt z15.h, p2/M, z15.s\n"
    "ld1w { z12.s }, p1/Z, [x20]\n"
    "st1w { z17.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z18.s }, p1, [x26]\n"
    "add x26, x26, x24, LSL #2\n"
    "st1w { z19.s }, p1, [x25]\n"
    "add x25, x25, x23, LSL #2\n"
    ".inst 0xc13513b0  // bfdot za.s[x8, 0], { z29.h-z0.h }, z5.h\n"
    ".inst 0x658aa850  // bfcvt z16.h, p2/M, z2.s\n"
    ".inst 0x658aa911  // bfcvt z17.h, p2/M, z8.s\n"
    ".inst 0x658aa832  // bfcvt z18.h, p2/M, z1.s\n"
    ".inst 0x648aa8ef  // bfcvtnt z15.h, p2/M, z7.s\n"
    ".inst 0x658aa993  // bfcvt z19.h, p2/M, z12.s\n"
    ".inst 0x648aab50  // bfcvtnt z16.h, p2/M, z26.s\n"
    ".inst 0x648aab71  // bfcvtnt z17.h, p2/M, z27.s\n"
    ".inst 0x648aab32  // bfcvtnt z18.h, p2/M, z25.s\n"
    "bgt 9b\n"
    "b 15f\n"
    "10:"  // Padded
    "cbz x22, 13f\n"
    "cmp x22, #0x1\n"
    "sub x14, x14, x22\n"
    "beq 12f\n"
    "11:"  // Padded: 2 priming loads
    "mov x12, #0x0\n"
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z17.s }, p0/Z, [x13]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa3e  // bfcvt z30.h, p2/M, z17.s\n"
    "ld1w { z31.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa1e  // bfcvtnt z30.h, p2/M, z16.s\n"
    "ld1w { z12.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabff  // bfcvt z31.h, p2/M, z31.s\n"
    "ld1w { z29.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa99f  // bfcvtnt z31.h, p2/M, z12.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaba0  // bfcvt z0.h, p2/M, z29.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa20  // bfcvtnt z0.h, p2/M, z17.s\n"
    ".inst 0x658aaa01  // bfcvt z1.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x648aaa21  // bfcvtnt z1.h, p2/M, z17.s\n"
    ".inst 0x658aaa02  // bfcvt z2.h, p2/M, z16.s\n"
    ".inst 0xc13b13d0  // bfdot za.s[x8, 0], { z30.h-z1.h }, z11.h\n"
    ".inst 0xc13913f0  // bfdot za.s[x8, 0], { z31.h-z2.h }, z9.h\n"
    "12:"  // Padded: 1 priming loads
    "mov x12, #0x0\n"
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z16.s }, p0/Z, [x13]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    "ld1w { z12.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa30  // bfcvtnt z16.h, p2/M, z17.s\n"
    "ld1w { z3.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa991  // bfcvt z17.h, p2/M, z12.s\n"
    "ld1w { z30.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aa871  // bfcvtnt z17.h, p2/M, z3.s\n"
    ".inst 0x658aabd2  // bfcvt z18.h, p2/M, z30.s\n"
    "ld1w { z31.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z1.s }, p0/Z, [x20]\n"
    ".inst 0x648aabf2  // bfcvtnt z18.h, p2/M, z31.s\n"
    ".inst 0x658aa833  // bfcvt z19.h, p2/M, z1.s\n"
    ".inst 0xc13411f0  // bfdot za.s[x8, 0], { z15.h-z18.h }, z4.h\n"
    ".inst 0xc1351210  // bfdot za.s[x8, 0], { z16.h-z19.h }, z5.h\n"
    "13:"  // Padded: 0 priming loads
    "cmp x14, #0x2\n"
    "blt 16f\n"
    "mov x12, #0x0\n"
    "add x21, x13, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "sub x14, x14, #0x2\n"
    "sub x11, x11, #0x1\n"
    "lsr x20, x14, #0x1\n"
    "cmp x20, x11\n"
    "and x14, x14, #0x1\n"
    "ld1w { z16.s }, p0/Z, [x13]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "csel x22, x20, x11, LT\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    "sub x11, x11, x22\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    "ld1w { z18.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa30  // bfcvtnt z16.h, p2/M, z17.s\n"
    "ld1w { z19.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa51  // bfcvt z17.h, p2/M, z18.s\n"
    "ld1w { z18.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa71  // bfcvtnt z17.h, p2/M, z19.s\n"
    "ld1w { z25.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa52  // bfcvt z18.h, p2/M, z18.s\n"
    "ld1w { z19.s }, p0/Z, [x21]\n"
    ".inst 0x648aab32  // bfcvtnt z18.h, p2/M, z25.s\n"
    ".inst 0x658aaa73  // bfcvt z19.h, p2/M, z19.s\n"
    "cbz x22, 15f\n"
    "14:"  // Padded: Main loop
    "mov x12, #0x0\n"
    "add x21, x13, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13a11f0  // bfdot za.s[x8, 0], { z15.h-z18.h }, z10.h\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc13b11f1  // bfdot za.s[x8, 1], { z15.h-z18.h }, z11.h\n"
    "subs x22, x22, #0x1\n"
    "ld1w { z25.s }, p0/Z, [x13]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    ".inst 0xc1361210  // bfdot za.s[x8, 0], { z16.h-z19.h }, z6.h\n"
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1391211  // bfdot za.s[x8, 1], { z16.h-z19.h }, z9.h\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab39  // bfcvt z25.h, p2/M, z25.s\n"
    ".inst 0xc0060c00  // mova { z0.d-z3.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    ".inst 0xc0040e82  // mova za.d[x8, #2], { z20.d-z23.d }\n"
    "ld1w { z29.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa19  // bfcvtnt z25.h, p2/M, z16.s\n"
    ".inst 0xc1adcb00  // fclamp { z0.s-z3.s }, z24.s, z13.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabba  // bfcvt z26.h, p2/M, z29.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "st1w { z0.s }, p1, [x10]\n"
    ".inst 0x648aaa3a  // bfcvtnt z26.h, p2/M, z17.s\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z1.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z2.s }, p1, [x26]\n"
    "add x26, x26, x24, LSL #2\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1b  // bfcvt z27.h, p2/M, z16.s\n"
    "st1w { z3.s }, p1, [x25]\n"
    "add x25, x25, x23, LSL #2\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa3b  // bfcvtnt z27.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa1c  // bfcvt z28.h, p2/M, z16.s\n"
    "mov x12, #0x0\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0x648aaa3c  // bfcvtnt z28.h, p2/M, z17.s\n"
    "ld1w { z18.s }, p0/Z, [x13]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0x658aaa1d  // bfcvt z29.h, p2/M, z16.s\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    ".inst 0xc1341330  // bfdot za.s[x8, 0], { z25.h-z28.h }, z4.h\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa4f  // bfcvt z15.h, p2/M, z18.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1351350  // bfdot za.s[x8, 0], { z26.h-z29.h }, z5.h\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    "ld1w { z18.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa30  // bfcvtnt z16.h, p2/M, z17.s\n"
    "ld1w { z19.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa51  // bfcvt z17.h, p2/M, z18.s\n"
    "ld1w { z18.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa71  // bfcvtnt z17.h, p2/M, z19.s\n"
    "ld1w { z25.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa52  // bfcvt z18.h, p2/M, z18.s\n"
    "ld1w { z19.s }, p0/Z, [x20]\n"
    ".inst 0x648aab32  // bfcvtnt z18.h, p2/M, z25.s\n"
    ".inst 0x658aaa73  // bfcvt z19.h, p2/M, z19.s\n"
    "bgt 14b\n"
    "15:"  // Main loop tail
    "mov x12, #0x0\n"
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13a11f0  // bfdot za.s[x8, 0], { z15.h-z18.h }, z10.h\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc13b11f1  // bfdot za.s[x8, 1], { z15.h-z18.h }, z11.h\n"
    "ld1w { z25.s }, p0/Z, [x13]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc1361210  // bfdot za.s[x8, 0], { z16.h-z19.h }, z6.h\n"
    "add x13, x13, %x[ld_in_col], LSL #2\n"
    ".inst 0xc1391211  // bfdot za.s[x8, 1], { z16.h-z19.h }, z9.h\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab2f  // bfcvt z15.h, p2/M, z25.s\n"
    ".inst 0xc0060c00  // mova { z0.d-z3.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    ".inst 0xc0040e82  // mova za.d[x8, #2], { z20.d-z23.d }\n"
    "ld1w { z28.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa0f  // bfcvtnt z15.h, p2/M, z16.s\n"
    ".inst 0xc1adcb00  // fclamp { z0.s-z3.s }, z24.s, z13.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab90  // bfcvt z16.h, p2/M, z28.s\n"
    "ld1w { z18.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "st1w { z0.s }, p1, [x10]\n"
    ".inst 0x648aaa30  // bfcvtnt z16.h, p2/M, z17.s\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z1.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z2.s }, p1, [x26]\n"
    "add x26, x26, x24, LSL #2\n"
    "ld1w { z19.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa51  // bfcvt z17.h, p2/M, z18.s\n"
    "st1w { z3.s }, p1, [x25]\n"
    "add x25, x25, x23, LSL #2\n"
    "ld1w { z18.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa71  // bfcvtnt z17.h, p2/M, z19.s\n"
    ".inst 0x658aaa52  // bfcvt z18.h, p2/M, z18.s\n"
    "ld1w { z25.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z19.s }, p0/Z, [x20]\n"
    ".inst 0x648aab32  // bfcvtnt z18.h, p2/M, z25.s\n"
    ".inst 0x658aaa73  // bfcvt z19.h, p2/M, z19.s\n"
    ".inst 0xc13411f0  // bfdot za.s[x8, 0], { z15.h-z18.h }, z4.h\n"
    ".inst 0xc1351210  // bfdot za.s[x8, 0], { z16.h-z19.h }, z5.h\n"
    "16:"  // Main loop skip tail
    "cbz x14, 17f\n"  // Skip remainder inputs
    "mov x12, #0x0\n"
    "add x20, x13, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "sub x11, x11, #0x1\n"
    "ld1w { z16.s }, p0/Z, [x13]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    "ld1w { z12.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa30  // bfcvtnt z16.h, p2/M, z17.s\n"
    "ld1w { z8.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa991  // bfcvt z17.h, p2/M, z12.s\n"
    "ld1w { z0.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aa911  // bfcvtnt z17.h, p2/M, z8.s\n"
    ".inst 0x658aa812  // bfcvt z18.h, p2/M, z0.s\n"
    "ld1w { z7.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z28.s }, p0/Z, [x20]\n"
    ".inst 0x648aa8f2  // bfcvtnt z18.h, p2/M, z7.s\n"
    ".inst 0x658aab93  // bfcvt z19.h, p2/M, z28.s\n"
    ".inst 0xc13a11f0  // bfdot za.s[x8, 0], { z15.h-z18.h }, z10.h\n"
    ".inst 0xc13b11f1  // bfdot za.s[x8, 1], { z15.h-z18.h }, z11.h\n"
    ".inst 0xc1361210  // bfdot za.s[x8, 0], { z16.h-z19.h }, z6.h\n"
    ".inst 0xc1391211  // bfdot za.s[x8, 1], { z16.h-z19.h }, z9.h\n"
    ".inst 0xc0060c08  // mova { z8.d-z11.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    ".inst 0xc0040e82  // mova za.d[x8, #2], { z20.d-z23.d }\n"
    ".inst 0xc1adcb08  // fclamp { z8.s-z11.s }, z24.s, z13.s\n"
    "st1w { z8.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z9.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z10.s }, p1, [x26]\n"
    "add x26, x26, x24, LSL #2\n"
    "st1w { z11.s }, p1, [x25]\n"
    "add x25, x25, x23, LSL #2\n"
    "17:"  // Tail input: End
    "cbz x11, 19f\n"
    "18:"  // Right padding loop
    ".inst 0xc0060c08  // mova { z8.d-z11.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    "subs x11, x11, #0x1\n"
    ".inst 0xc0040e82  // mova za.d[x8, #2], { z20.d-z23.d }\n"
    ".inst 0xc1adcb08  // fclamp { z8.s-z11.s }, z24.s, z13.s\n"
    "st1w { z8.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z9.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "st1w { z10.s }, p1, [x26]\n"
    "add x26, x26, x24, LSL #2\n"
    "st1w { z11.s }, p1, [x25]\n"
    "add x25, x25, x23, LSL #2\n"
    "bgt 18b\n"
    "19:"  // End
    "ldr x20, [%x[args], %[offsetof_Args_weights]]\n"
    "incw x15\n"
    "whilelt p1.s, x15, x16\n"
    "incb x20, ALL, MUL #9\n"
    "str x20, [%x[args], %[offsetof_Args_weights]]\n"
    "ldr x21, [%x[args], %[offsetof_Args_ld_in_vl]]\n"
    "ldr x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "add x20, x20, x21, LSL #2\n"
    "str x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "ldr x25, [%x[args], %[offsetof_Args_outptrs]]\n"
    "ldr x24, [%x[args], %[offsetof_Args_ld_out_vls]]\n"
    "ldp x23, x22, [x25, #0x0]\n"
    "ldp x21, x20, [x24, #0x0]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x0]\n"
    "ldp x23, x22, [x25, #0x10]\n"
    "ldp x21, x20, [x24, #0x10]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x10]\n"
    "b.any 1b\n"
    ".inst 0xd503467f  // SMSTOP\n"
    :
    : [args] "r" (&args), [ld_in_col] "r" (ld_in_col), [ld_in_row] "r" (ld_in_row), [offsetof_Args_bias] "I" (offsetof(Args, bias)), [offsetof_Args_clamp_max] "I" (offsetof(Args, clamp_max)), [offsetof_Args_clamp_min] "I" (offsetof(Args, clamp_min)), [offsetof_Args_current_channel] "I" (offsetof(Args, current_channel)), [offsetof_Args_inptr] "I" (offsetof(Args, inptr)), [offsetof_Args_input_cols] "I" (offsetof(Args, input_cols)), [offsetof_Args_ld_in_vl] "I" (offsetof(Args, ld_in_vl)), [offsetof_Args_ld_out_cols] "I" (offsetof(Args, ld_out_cols)), [offsetof_Args_ld_out_vls] "I" (offsetof(Args, ld_out_vls)), [offsetof_Args_n_channels] "I" (offsetof(Args, n_channels)), [offsetof_Args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_Args_output_cols] "I" (offsetof(Args, output_cols)), [offsetof_Args_pad_bottom] "I" (offsetof(Args, pad_bottom)), [offsetof_Args_pad_left] "I" (offsetof(Args, pad_left)), [offsetof_Args_pad_top] "I" (offsetof(Args, pad_top)), [offsetof_Args_weights] "I" (offsetof(Args, weights))
    : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SME2)
