/*
* Copyright (c) 2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "src/core/helpers/Utils.h"

namespace arm_compute
{
bool has_holes(const ITensorInfo &info)
{
    return has_holes(info, info.num_dimensions() - 1);
}

bool has_holes(const ITensorInfo &info, size_t dimension)
{
    const auto &shape          = info.tensor_shape();
    const auto &strides        = info.strides_in_bytes();
    size_t      squashed_bytes = info.element_size();

    for (size_t dim = 0; dim <= dimension; ++dim)
    {
        if (strides[dim] != squashed_bytes)
        {
            return true;
        }
        squashed_bytes *= shape[dim];
    }
    return false;
}
} // namespace arm_compute
