#!/bin/sh

set -eux

IMAGE=test.img
RELEASE="${1:-}"

cleanup() {
	rm -f "$IMAGE"
}
trap cleanup EXIT
cleanup_abort() {
	cleanup
	echo aborted >&2
	exit 2
}
trap cleanup_abort HUP INT TERM QUIT

INSTALL_LOCATION=$(command -v debefivm-create)
if test "${INSTALL_LOCATION#/usr/}" = "$INSTALL_LOCATION"; then
	USERADDHOOK="${INSTALL_LOCATION%/*}/../useraddhook"
else
	USERADDHOOK=/usr/share/mmdebstrap/hooks/useradd
fi

set -- --
if test -z "$RELEASE"; then
	# We no longer need usrmerge in trixie and later and it does not work
	# with copy-host-apt-sources-and-preferences in the default order.
	set -- \
		--skip=usrmerge \
		"$@" \
		--hook-dir=/usr/share/mmdebstrap/hooks/copy-host-apt-sources-and-preferences \
		--hook-dir=/usr/share/mmdebstrap/hooks/file-mirror-automount \
		""
fi

debefivm-create \
	-o "$IMAGE" \
	-r "$RELEASE" \
	"$@" \
	--include=linux-image-generic,libpam-systemd,passwd,python3 \
	--hook-dir="$USERADDHOOK" \
	--customize-hook=/usr/share/autopkgtest/setup-commands/setup-testbed

autopkgtest hello -- qemu --boot=efi --show-boot --timeout-reboot=120 "$IMAGE"
