% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fImport.r
\name{fImport}
\alias{fImport}
\title{fImport}
\usage{
fImport(
  file,
  format,
  lowernames = c("not mixed", "no", "yes"),
  und. = FALSE,
  ...
)
}
\arguments{
\item{file}{name of file to import, or full URL.  \code{rio} determines the file type from the file suffix unless you override this with \code{format}}

\item{format}{format of file to import, usually not needed.  See \code{rio::import()} for details}

\item{lowernames}{defaults to changing variable names to all lower case unless the name as mixed upper and lower case, which results in keeping the original characters in the name.  Set \code{lowernames='no'} to leave variable names as they were created in the original file export, or set \code{lowernames='yes'} to set all names to lower case whether they have mixed case or not.  For all options, a check is made to see if the name conversions would result in any duplicate names.  If so, the original names are retained and a warning message issued.}

\item{und.}{set to \code{TRUE} to change all underscores in names to periods}

\item{...}{more arguments to pass to \code{rio::import()}}
}
\value{
a data frame created by \code{rio}, unless a \code{rio} option is given to use another format
}
\description{
General File Import Using \code{rio}
}
\details{
This is a front-end for the \code{rio} package's \code{import} function.  \code{fImport} includes options for setting variable names to lower case and to change underscores in names to periods.  Variables on the imported data frame that have \code{label}s are converted to Hmisc package \code{labelled} class so that subsetting the data frame will preserve the labels.
}
\examples{
\dontrun{
# Get a Stata dataset
d <- fImport('http://www.principlesofeconometrics.com/stata/alcohol.dta')
contents(d)
}
}
\seealso{
\code{upData}, especially the \code{moveUnits} option
}
\author{
Frank Harrell
}
