# ITK 5.4.4 Release Notes

We are pleased to announce the release of [ITK 5.4.4](https://docs.itk.org), a maintenance update delivering critical improvements while maintaining API stability. This is latest maintenance update for this cross-platform, open-source toolkit supporting N-dimensional scientific image analysis with spatially-aware algorithms. 🎉 🍻 🥳

🔦 Highlights
-------------

- **Bug Fixes**:
    - Fixed GDCM JPEG2000 structure cleanup to prevent crashes on malformed files
    - Corrected TIFFImageIO reuse behavior
- **Documentation**:
    - Updated documentation on Doxygen shared groups
    - Spelling corrections in the ITK Software Guide
- **Platform Support**:
    - Added GraalPy compatibility
    - Improved NumPy dtype handling for Python interoperability
    - Following CPython's deprecation schedule, ITK now provides packages for Python 3.9 or later.
- **Remote Modules**:
    - Updated `Montage`, `MorphologicalContourInterpolation` and `WebAssemblyInterface` modules


💾 Download
-----------

**Python Packages**

Install [ITK Python packages](https://docs.itk.org/en/latest/learn/python_quick_start.html) with:

```bash
pip install itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.4.4.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightSoftwareGuide-Book1-5.4.4.pdf)
- [InsightSoftwareGuide-Book2-5.4.4.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightSoftwareGuide-Book2-5.4.4.pdf)

**Library Sources**

- [InsightToolkit-5.4.4.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightToolkit-5.4.4.tar.gz)
- [InsightToolkit-5.4.4.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightToolkit-5.4.4.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.4.4.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightData-5.4.4.tar.gz)
- [InsightData-5.4.4.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightData-5.4.4.zip)

**Checksums and Signatures**

- [InsightToolkit-5.4.4.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightToolkit-5.4.4.tar.gz.asc)
- [InsightToolkit-5.4.4.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightToolkit-5.4.4.zip.asc)

- [InsightData-5.4.4.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightData-5.4.4.tar.gz.asc)
- [InsightData-5.4.4.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/InsightData-5.4.4.zip.asc)

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.4/SHA512SUMS)

### 🙏 Acknowledgments

Thank you to contributors Albert, Ariouz, Bradley Lowekamp, Dženan Zukić, Hans Johnson, Jakub Klinkovský, Matthew McCormick, Mihail Isakov, Tom Birdsong, and the ITK community for their code, testing, and documentation efforts.

---

### 🗣️ What's Next

**ITK 6.0 Beta 1 Preparation**
The community is finalizing **ITK 6.0 Beta 1**, featuring:

- Architectural upgrades for contemporary C++ development
- Enhanced template metaprogramming capabilities
- Code modernization for improved readability and maintainability

**5.4 Maintenance Commitment**

We remain dedicated to supporting current users through:

- Regular security and regression patches
- Critical bug resolution
- Platform compatibility updates

**Enjoy ITK!**

---

ITK Changes Since v5.4.3
------------------------

### Ariouz (1):

#### Enhancements

- Add Graalpy Support ([2aaa346313](https://github.com/InsightSoftwareConsortium/ITK/commit/2aaa346313))


### Bradley Lowekamp (3):

#### Enhancements

- Add test for bug related reusing TIFFImageIO ([f18535d50d](https://github.com/InsightSoftwareConsortium/ITK/commit/f18535d50d))

#### Bug Fixes

- GDCM destroy JPEG2000 structures on error ([95a64b8890](https://github.com/InsightSoftwareConsortium/ITK/commit/95a64b8890))
- Fix reusing TIFFImageIO ([231163bc50](https://github.com/InsightSoftwareConsortium/ITK/commit/231163bc50))


### Dženan Zukić (2):

#### Enhancements

- Update Montage remote module mostly to fix warnings ([6511d8f615](https://github.com/InsightSoftwareConsortium/ITK/commit/6511d8f615))
- Update MorphologicalContourInterpolation module to fix warnings ([8abb11e885](https://github.com/InsightSoftwareConsortium/ITK/commit/8abb11e885))


### Hans Johnson (2):

#### Platform Fixes

- Improve path management for python package install ([bd779399a1](https://github.com/InsightSoftwareConsortium/ITK/commit/bd779399a1))

#### Bug Fixes

- Python version mis-match during build and test ([d1867dd78f](https://github.com/InsightSoftwareConsortium/ITK/commit/d1867dd78f))


### Jakub Klinkovský (1):

#### Platform Fixes

- Include needed cstdint header ([9c87ac96d1](https://github.com/InsightSoftwareConsortium/ITK/commit/9c87ac96d1))


### Matthew McCormick (7):

#### Enhancements

- Update WebAssemblyInterface remote to 2025-05-28 ([37202e7ad9](https://github.com/InsightSoftwareConsortium/ITK/commit/37202e7ad9))
- Bump ITK version to 5.4.4 ([f98d5fac5e](https://github.com/InsightSoftwareConsortium/ITK/commit/f98d5fac5e))

#### Documentation Updates

- Add ITK 5.4.3 release notes ([03256a58a0](https://github.com/InsightSoftwareConsortium/ITK/commit/03256a58a0))
- Update download page links for ITK 5.4.3 ([b366d5e1d9](https://github.com/InsightSoftwareConsortium/ITK/commit/b366d5e1d9))

#### Platform Fixes

- Update Linux CI images to ubuntu-22.04 ([89ed425e0f](https://github.com/InsightSoftwareConsortium/ITK/commit/89ed425e0f))
- Update Azure CI ExternalDataVersion to 5.4.3 ([31085ff8cb](https://github.com/InsightSoftwareConsortium/ITK/commit/31085ff8cb))
- Identify numpy bool attr as bool instead of bool8 ([55a3a6f18f](https://github.com/InsightSoftwareConsortium/ITK/commit/55a3a6f18f))


### Mihail Isakov (1):

#### Bug Fixes

- fix GDCM crash due to malformed file ([1a241567d8](https://github.com/InsightSoftwareConsortium/ITK/commit/1a241567d8))


### Tom Birdsong (1):

#### Bug Fixes

- Use NumPy dtypes for type mapping ([bfe0e80d98](https://github.com/InsightSoftwareConsortium/ITK/commit/bfe0e80d98))


ITK Software Guide Changes Since v5.4.3
---------------------------------------

### Matthew McCormick (1):

#### Enhancements

- Bump ITK to v5.4.4 ([4a1b625](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/4a1b625))


### albert-github (2):

#### Documentation Updates

- Spelling corrections ([5849c78](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5849c78))
- Grouping shared documentation ([5ea45e3](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5ea45e3))
- Fix PDF file properties in Book 2 ([b46a83f](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/b46a83f))


Remote Module Changes Since v5.4.3
----------------------------------

## Montage:
### Dženan Zukić (4):

#### Enhancements

- Support nearest neighbor interpolator for montaging label maps ([d71031e](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/d71031e))

#### Platform Fixes

- Get ITK_USE_FLOAT_SPACE_PRECISION=ON to compile again ([3f92cee](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/3f92cee))
- Fix MacOS Python packages ([9da9118](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/9da9118))
- Use correct and consistent version numbers for all ITK components ([df0acae](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/df0acae))


### Hans Johnson (7):

#### Enhancements

- Update to support the clang-format-linter CI ([dffbbf5](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/dffbbf5))
- Use latest actions, do not pin to latest version ([2bcebff](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/2bcebff))
- Use tag v5.4.2 for the build packages tags ([07ff68f](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/07ff68f))
- Update pyproject.toml for ITK 5.4.2 ([1a079c4](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/1a079c4))

#### Style Changes

- Add itkVirtualGetNameOfClassMacro + itkOverrideGetNameOfClassMacro ([4d35307](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/4d35307))
- CoordRepType -> CoordinateType code readability ([b81b523](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/b81b523))
- Update to match clang-format-19 from ITK ([38ffd5a](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/38ffd5a))


### Matt McCormick (1):

#### Enhancements

- Upgrade CI for ITK 5.4.0 ([9027e04](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/9027e04))



## MorphologicalContourInterpolation:
### Hans Johnson (4):

#### Enhancements

- Update to support the clang-format-linter CI ([41e2c99](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/41e2c99))

#### Platform Fixes

- Use modern macro for name of class ([eb91db4](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/eb91db4))

#### Style Changes

- Update clang-format v19 style doc from ITK. ([c897df2](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/c897df2))
- Enforce ITK clang-format v19 style. ([4a552c6](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/4a552c6))


### Jon Haitz Legarreta Gorroño (2):

#### Enhancements

- Remove unused variable and commented code block ([e0267a9](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/e0267a9))
- Add `RLEImage` as an ITK module dependency to GHA workflow file ([40774af](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/40774af))


### Matt McCormick (7):

#### Enhancements

- Update setup.py to pyproject.toml ([c438c41](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/c438c41))
- Bump Python package version to 2.1.0 ([f869707](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/f869707))

#### Documentation Updates

- Fix README links for repository name change ([a0af585](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/a0af585))
- Remove README.rst ([b4b9dbb](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/b4b9dbb))
- Remove Android from pyproject.toml ([5611abe](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/5611abe))
- Add Matt McCormick to Python package authors ([093cf40](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/093cf40))

#### Style Changes

- Update to latest ITK clang-format style ([cf52e78](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/cf52e78))


### Matthew McCormick (1):

#### Platform Fixes

- Wasm updates for ITK 5.4.2 ([60c3d35](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/60c3d35))


## WebAssemblyInterface:
### Hans Johnson (7):

#### Enhancements

- Use tag v5.4.2 for the build packages tags ([bfabf216](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bfabf216))

#### Miscellaneous Changes

- style(itk-wasm): Add itkVirtualGetNameOfClassMacro + itkOverrideGetNameOfClassMacro ([626feddf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/626feddf))
- style(itk-wasm): Rename ITK_DISALLOW_COPY_AND_ASSIGN to ITK_DISALLOW_COPY_AND_MOVE ([24670844](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/24670844))
- style(itk-wasm): CoordRepType -> CoordinateType code readability ([65e76231](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/65e76231))
- style(itk-wasm): Update to match clang-format-19 from ITK ([d29e3b10](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d29e3b10))
- ci(itk-wasm): Update workflow package dependancy versions. ([e2de545b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e2de545b))
- feat: Update pyproject.toml for ITK 5.4.2 ([0aae9ba0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0aae9ba0))


### Ken Goettler (1):

#### Miscellaneous Changes

- fix(include): avoid segfault when calculating totalSize ([7fe1b185](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7fe1b185))


### Kurt McKee (1):

#### Miscellaneous Changes

- ci: Add a Dependabot config to auto-update GitHub action versions ([34417bb3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/34417bb3))


### Laurent Chauvin (1):

#### Miscellaneous Changes

- fix(image-io): use 'mnc' for minc extension ([31a5ff48](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/31a5ff48))


### Matt McCormick (725):

#### Enhancements

- Add OpenSSF Scorecard action ([03c912e5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/03c912e5))
- build: bump to dockcross 20240418-88c04a4 ([157a496d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/157a496d))
- feat(itk-wasm-cli): Update default Docker image for 20240501-4d931706 ([b9189928](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b9189928))
- chore(downsample): bump js_package.py ([eb8251f9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/eb8251f9))
- ci: remove tool-cache for documentation build ([6c70e2b5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6c70e2b5))
- chore: update downsample demo-app index.html ([70cdb194](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/70cdb194))
- build(compare-meshes): update @itk-wasm/app dep ([4c74266c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4c74266c))
- build(pnpm): bump to version 9.1.0 ([bf8f65e6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bf8f65e6))
- ci(pnpm): bump action-setup to v4 ([1a0118be](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1a0118be))
- build(commitlint): run from package.json ([d3bc1163](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d3bc1163))
- build(wasi): remove cmake_minimum_required from wasi toolchain file ([7e0d0a99](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7e0d0a99))
- feat: bump ITK to 2024-05-05 master ([305a053e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/305a053e))
- build(docker): avoid git clones ([cca6c553](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cca6c553))
- test(dicom): disable apply-presentation-state-to-image for color images ([972515d1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/972515d1))
- docs(dicom): update python wasi testing instructions ([2b4a1eb2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2b4a1eb2))
- build: update wasi and js_package.py artifacts ([2ed2dfe1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2ed2dfe1))
- feat(itk-wasm-cli): Update default Docker image for 20240516-1a13e4ae ([8add6829](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8add6829))
- test(compare-images): update total, mean difference expected ([d21f43c0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d21f43c0))
- refactor(emscripten): update ascii module APIs to UTF8 versions ([32a1ffd9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/32a1ffd9))
- feat(itk-wasm-cli): Update default Docker image for 20240517-32a1ffd9 ([c5e36acc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c5e36acc))
- docs: update logo ([8a3050e8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8a3050e8))
- ci(dicom): avoid macos-14 dicom chrome python wasm flake ([a6026789](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a6026789))
- fix(bindgen): remove packageManager version from template.package.json ([da400e3d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/da400e3d))
- chore: bump itk-wasm version to 1.0.0-b.174 ([0e11d581](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0e11d581))
- chore: bump itk-wasm version.ts for 1.0.0-b.174 ([332db54c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/332db54c))
- chore(mesh-io): bump version to 1.2.0 ([c865b4e1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c865b4e1))
- chore(image-io): bump version to 1.2.0 ([d660f566](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d660f566))
- chore(compare-images): bump version to 5.1.1 ([1bf034b9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1bf034b9))
- chore(compare-meshes): bump version to 0.3.0 ([cb0118d9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cb0118d9))
- fix(demo-app): vendor shoelace assets ([f74280d8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f74280d8))
- chore(compress-stringify): bump version to 3.2.0 ([fd8a8745](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fd8a8745))
- chore(dicom): bump version to 7.0.0 ([3c52104e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3c52104e))
- chore(downsample): bump version to 1.3.0 ([cca89ddc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cca89ddc))
- style(itk-wasm): update version.ts ([2e01e302](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2e01e302))
- build(demo-app): provide build:tsc stub ([8cadb0aa](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8cadb0aa))
- ci(itk-wasm): build demo-app for browser tests ([d4267fcc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d4267fcc))
- build(pnpm): bump version to 9.1.1 ([65710714](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/65710714))
- feat(python): support ITKWASM_CACHE_DIR for cache directory ([f05fe5db](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f05fe5db))
- feat(python): add Image bufferedRegion ([ea18da82](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ea18da82))
- style(python): run black on itkwasm ([e9672a84](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e9672a84))
- chore(python): bump itkwasm version to 1.0b175 ([dc4b8a78](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dc4b8a78))
- build(pnpm): bump version to 9.1.2 ([c94d500f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c94d500f))
- ci(python): skip flaky macos-14 chrome testing ([cc55528c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cc55528c))
- test(pyodide): bump version to 0.25.1 ([49990a3d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/49990a3d))
- build(docker): bump ITK to v5.4.0 ([17db8b0b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/17db8b0b))
- feat(itk-wasm-cli): Update default Docker image for 20240521-17db8b0b ([ef9924bf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ef9924bf))
- chore(create-itk-wasm): bump itk-wasm version to 1.0.0-b.175 ([e0fd3e6f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e0fd3e6f))
- style(create-itk-wasm): obtainedReponse -> obtainedResponse ([5b64e4ca](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5b64e4ca))
- fix(create-itk-wasm): input project description must not be empty ([dbb30c31](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dbb30c31))
- fix(create-itk-wasm): support dispatch on parameters ([44fc029f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/44fc029f))
- chore(create-itk-wasm): bump version to 1.1.0 ([e2c91963](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e2c91963))
- chore(python): update native package for ITK 5.4.0 ([f37d3218](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f37d3218))
- chore: bump pnpm to 9.1.4 ([a762797e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a762797e))
- docs: add LinkML Model to Myst toctree ([1971a4fb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1971a4fb))
- ci(python): test Python 3.12 ([04779d51](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/04779d51))
- docs(typescript): fix interface types module link ([64d8b8e2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/64d8b8e2))
- fix(run-pipeline-node): update args with mounted path on Windows ([fbb937e9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fbb937e9))
- style(run-pipeline-node): apply prettier ([8931ce94](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8931ce94))
- chore(itk-wasm): bump version to 1.0.0-b.176 ([7302aaf7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7302aaf7))
- chore(mesh-io): bump version to 1.2.1 ([1a21d301](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1a21d301))
- chore(image-io): bump version to 1.2.1 ([6bcefb34](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6bcefb34))
- chore(dicom): bump version to 7.0.1 ([8c0d7e56](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8c0d7e56))
- feat(cxx): bump C++ standard to 20 ([2f631377](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2f631377))
- feat(cxx): fetch glaze ([bf27fa7e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bf27fa7e))
- chore: bump artifacts for C++20 standard ([0b9f7a99](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0b9f7a99))
- build(CMake): reduce required version to 3.24.2 ([3926bf46](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3926bf46))
- build(cmake): add glaze to FetchContent_MakeAvailable ([0b83f08b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0b83f08b))
- feat(itk-wasm-cli): Update default Docker image for 20240605-0b83f08b ([63e3588f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/63e3588f))
- chore(wasi): update package binaries ([4edc2d9c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4edc2d9c))
- chore(pnpm): bump version to 9.2.0 ([a8b12b8d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a8b12b8d))
- chore: bump cypress, ava, start-server-and-test to latest ([e62c6246](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e62c6246))
- docs: naming consistency itk-wasm -> ITK-Wasm ([39abccc1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/39abccc1))
- chore: bump pnpm to 9.4.0 ([b8a5f944](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b8a5f944))
- ci: avoid duplicate builds on push, pull_request ([fbed11e5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fbed11e5))
- ci: use unique matrix-based name for cypress screenshots, videos ([d34b996b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d34b996b))
- feat(itk-wasm-cli): Update default Docker image for 20240624-b89bcb6c ([86b16877](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/86b16877))
- docs: add TransformList, Transform LinkML model ([9c20e491](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9c20e491))
- refactor: remove old module IO CMake code ([3469000f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3469000f))
- feat: add itk::WasmTransformIOFactory ([fdcef100](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fdcef100))
- feat: itk::WasmTransformIO initial addition ([cdd70edc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cdd70edc))
- feat(WasmTransformIO): support Composite transforms ([7c608e5e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7c608e5e))
- ci: Do not build macos-12 in CI ([a4f6b49a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a4f6b49a))
- feat(TransformJSON): specify initializers ([e3b37ef9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e3b37ef9))
- fix: use initialization with braces in itkTransformJSONTest ([0c940294](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0c940294))
- feat: bump glaze to 2.9.3 ([e18ac542](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e18ac542))
- build: use XCode 15.3 for std::hash<std::filesystem::path> ([81f3a7dd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/81f3a7dd))
- build: add itkFloatTypesJSON.h to KWStyle namespace disable ([f9c4441d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f9c4441d))
- build: do not build manylinux2014 native binary wheels ([0e819119](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0e819119))
- build(glaze): add flags required for MSVC ([757c0256](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/757c0256))
- build: check the result of glz::write in itkWasmTransformIO ([58a0303f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/58a0303f))
- ci: disable native python build workflow ([3005861d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3005861d))
- chore: bump cli11 to v2.4.2 ([e98b4453](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e98b4453))
- build: bump rang cmake_minimum_required to 3.16.3 ([41b5a62b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/41b5a62b))
- ci: bump ITK native build version to release-5.4 HEAD ([695b24d5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/695b24d5))
- feat: wasm transform interface classes ([03b5cd61](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/03b5cd61))
- feat: add itk::wasm::InputTransform ([c7d66764](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c7d66764))
- feat: add itk::wasm::OutputTransform ([669928ac](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/669928ac))
- refactor(WasmMeshToMeshFilter): use glaze ([d81379d7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d81379d7))
- refactor(mesh): rapidjson to glaze ([e0cf293f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e0cf293f))
- refactor(polydata): rapidjson to glaze ([079acfef](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/079acfef))
- refactor(SupportInputMeshTypes): rapidjson to glaze ([4fd25144](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4fd25144))
- refactor(SupportInputPolyDataTypes): rapidjson to glaze ([df7e98da](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/df7e98da))
- refactor(Image): rapidjson to glaze ([bf694dd6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bf694dd6))
- refactor(Pipeline): rapidjson to glaze ([3fc591cf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3fc591cf))
- refactor(SupportInputImageTypes): rapidjson to glaze ([ebf267a7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ebf267a7))
- refactor(WasmStringStream): rapidjson to glaze ([7b4f2455](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7b4f2455))
- fix(InterfaceTypes): consistent default name ([17bca176](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/17bca176))
- ci: update docs basePath for ITK-Wasm repo rename ([88ef85b3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/88ef85b3))
- build: use upstream glaze ([0109e809](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0109e809))
- feat(itk-wasm-cli): Update default Docker image for 20240708-0109e809 ([56778b64](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/56778b64))
- build: bump zstd to v1.5.6 ([bd6dedaf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bd6dedaf))
- style(WasmMeshIO): remove duplicate header include ([520a4ddb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/520a4ddb))
- build(WebAssemblyInterace): suppress std::wstring_convert deprecation warning ([525f9b5a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/525f9b5a))
- refactor(WasmZstdMeshIO): use WasmIOCommon openFileForReading ([7af7f33a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7af7f33a))
- style: prettify run-pipeline-emscripten.ts, run-pipeline-node-test.ts ([ea01a58a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ea01a58a))
- fix(run-pipeline-emscripten): do not stringify metadata twice ([a6e6956c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a6e6956c))
- build(apply-presentation-state-to-image): backport rapidjson getArrayJson ([c82bfba5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c82bfba5))
- feat(itk-wasm-cli): Update default Docker image for 20240709-c82bfba5 ([2a6bd85c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2a6bd85c))
- build(cmake): target compile option call ([33f05c46](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/33f05c46))
- fix(jsonFromIOComponentEnum): default to uint8 for unknown ([ebf7fa3a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ebf7fa3a))
- fix(WasmImageIO): do not read file in SetJSON ([15204ac3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/15204ac3))
- feat(itk-wasm-cli): Update default Docker image for 20240712-15204ac3 ([b48477e4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b48477e4))
- fix(ImageToWasmImageFilter): remove debug code ([daa6deea](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/daa6deea))
- feat(itk-wasm-cli): Update default Docker image for 20240712-daa6deea ([3215f037](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3215f037))
- test(read_write_mesh): update expected component type ([e25592f3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e25592f3))
- docs: update ITKContourInterpolation links for new repo name ([0e65448b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0e65448b))
- fix(jsonFromIOComponentEnum): add missing LONG and ULONG entries ([c8dabc4b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c8dabc4b))
- feat(itk-wasm-cli): Update default Docker image for 20240714-c8dabc4b ([052e0d6d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/052e0d6d))
- docs: update packages links for GitHub Org rename ([baa269db](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/baa269db))
- style(run-pipeline-node-test): prettier ([bef24c01](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bef24c01))
- chore(itk-wasm): bump typescript package to 1.0.0-b.177 ([ae06b8d4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ae06b8d4))
- fix(OutputImage): dataSize needs components per pixel ([6891d4df](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6891d4df))
- feat(itk-wasm-cli): Update default Docker image for 20240717-6891d4df ([4feee162](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4feee162))
- style: Specify ReadTheDocs custom domain name ([05cc8286](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/05cc8286))
- feat(Mesh,PolyData): add metadata member in C++ ([a8fdda06](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a8fdda06))
- feat(cxx): add bufferedRegion to ImageJSON ([46551e76](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/46551e76))
- feat(PointSet): initial C++ addition ([65ad0832](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/65ad0832))
- chore: bump pnpm to 9.6.0 ([d062945c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d062945c))
- feat(transform-io): package C++ addition ([6cc25768](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6cc25768))
- refactor: move IOBase classes to io packages ([c0452f97](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c0452f97))
- feat(itk-wasm-cli): Update default Docker image for 20240802-222f4fea ([19324540](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/19324540))
- build: address libminc wasi undefined symbols ([2cb7a687](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2cb7a687))
- feat(itk-wasm-cli): Update default Docker image for 20240803-2cb7a687 ([486f7cab](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/486f7cab))
- fix(read-transform): do not set required until after pre-parse ([922d0005](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/922d0005))
- feat(transform): add metadata and sort transform parameterizations ([4a476e47](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4a476e47))
- feat(transform): define interface type to typescript, python mapping ([d47a921c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d47a921c))
- feat(python): add Transform interface type ([29445beb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/29445beb))
- chore(python): bump package version to 1.0b177 ([d91abe65](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d91abe65))
- chore(transform-io): add build directories to .gitignore ([3f461e68](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3f461e68))
- feat(itk-wasm-cli): Update default Docker image for 20240807-3f461e68 ([f8dcb3ec](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f8dcb3ec))
- feat(InterfaceTypes): add Transform ([98208aaa](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/98208aaa))
- build(transform-io): use workspace packages in package.json ([cd9a4bb4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cd9a4bb4))
- chore(transform-io): add typescript sources ([3de893c6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3de893c6))
- feat(transform): add type to typescript inputs, outputs ([c19b0f8d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c19b0f8d))
- test(transform): disable typescript exit 1 for now ([97a29808](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/97a29808))
- feat(itk-wasm-cli): Update default Docker image for 20240808-97f8da68 ([133ac2a8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/133ac2a8))
- fix(WasmImageToImageFilter): correct totalSize computation ([00d714cf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/00d714cf))
- feat(itk-wasm-cli): Update default Docker image for 20240808-00d714cf ([d2dd7d11](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d2dd7d11))
- fix(WasmImageToImageFilter): set default bufferedRegion ([4e9a4bf0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4e9a4bf0))
- feat(itk-wasm-cli): Update default Docker image for 20240810-4e9a4bf0 ([40764f70](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/40764f70))
- fix(Python): add missing metadata members to Mesh, PointSet ([a74f506d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a74f506d))
- chore(Python): bump itkwasm version to 1.0b178 ([e5d17e29](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e5d17e29))
- build(index-worker-embedded): specify pipelineWorker type ([27191947](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/27191947))
- chore(itk-wasm): bump package version to 1.0.0-b.178 ([e2295f98](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e2295f98))
- chore: update build artifacts ([f6fe5384](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f6fe5384))
- docs(compare-images): update GitHub pages for ITK-Wasm repo name change ([c83699e4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c83699e4))
- chore(compare-images): bump version to 5.2.0 ([dff207a1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dff207a1))
- chore(compare-meshes): bump version to 0.4.0 ([6b31a5d6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6b31a5d6))
- docs(compress-stringify): update GitHub pages for ITK-Wasm repo name change ([12f42c0e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/12f42c0e))
- chore(compress-stringify): bump version to 3.3.0 ([eb07cdf9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/eb07cdf9))
- feat(create-itk-wasm): bump itk-wasm to 1.0.0-b.178 ([d03dfa8b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d03dfa8b))
- chore(create-itk-wasm): bump version to 1.2.0 ([c823a6b3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c823a6b3))
- docs(dicom): update GitHub pages for ITK-Wasm repo name change ([00fc12d2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/00fc12d2))
- chore(dicom): bump version to 7.1.0 ([abd35f8c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/abd35f8c))
- docs(downsample): update GitHub pages for ITK-Wasm repo name change ([75cd4b10](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/75cd4b10))
- chore(downsample): bump version to 1.4.0 ([4823608b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4823608b))
- docs(image-io): update GitHub pages for ITK-Wasm repo name change ([bdc61bd8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bdc61bd8))
- chore(image-io): bump version to 1.3.0 ([7a97f791](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7a97f791))
- docs(mesh-io): update GitHub pages for ITK-Wasm repo name change ([5e57a3f4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5e57a3f4))
- chore(mesh-io): bump version to 1.3.0 ([2e0cda67](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2e0cda67))
- docs(image-io): correct new names for deprecated functions ([afc54708](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/afc54708))
- docs(mesh-io): correct new names for deprecated functions ([b37fae6c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b37fae6c))
- build(pixi): native ITK build configuration ([2c15b2c1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2c15b2c1))
- build(pixi): native ITK-Wasm config ([cd7c4a7f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cd7c4a7f))
- build(pixi): dicom configuration ([8e3d5b4d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8e3d5b4d))
- build(pixi): add mesh-io native configuration ([48b40439](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/48b40439))
- docs(native): describe how to build and test with pixi ([81609472](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/81609472))
- build(pixi): extend supported platforms ([50a8c8e8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/50a8c8e8))
- feat(itk-wasm-cli): Update default Docker image for 20240822-c390b350 ([cc510036](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cc510036))
- test(mesh-io): update expected pointPixelComponentType ([26845931](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/26845931))
- fix(dicom): add missing index-node-only module contents ([8368092c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8368092c))
- test(dicom): add back read-image-dicom-file-series to demo app ([432f780e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/432f780e))
- test(dicom): disable flakey writeSegmentation assertion ([a14197e2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a14197e2))
- test(dicom): disable WASI CLI tests ([4317d21e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4317d21e))
- chore(dicom): bump package version to 7.2.0 ([eac11ce5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/eac11ce5))
- ci(python-wasm): disable dicom tests ([3f8c02e5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3f8c02e5))
- chore(native): bump ITK, DCMTK to match Docker ([d845fa15](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d845fa15))
- build(native): add patch to fix ITKTotalVariation build on Linux ([859414a1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/859414a1))
- build: re-use ITK, DCMTK source locations in native, docker builds ([90b6e672](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/90b6e672))
- ci(toolchains): pixi run export-itk-wasm-env-vars ([6d25c4a9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6d25c4a9))
- build(native): update MSVC flags ([f81d1deb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f81d1deb))
- build(docker): generate the new tag in itk_wasm_env.bash ([47208cc4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/47208cc4))
- build(debugging-example): use latest docker images ([51204e45](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/51204e45))
- test(core): use latest docker images ([3feead66](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3feead66))
- build(transform-io): fix docker image sppecification ([e57d1535](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e57d1535))
- build(pnpm-script): fetch docker image from config for bindgen scripts ([81ca381d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/81ca381d))
- build(examples): use latest docker images ([9f97bbb4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9f97bbb4))
- test(core): use latest docker images ([3e13f8ba](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3e13f8ba))
- build(ITKWebAssemblyInterface.cmake): disable find_package OpenMP ([1a89d0e6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1a89d0e6))
- feat(itk-wasm-cli): Update default Docker image for 20240825-1a89d0e6 ([45426c1e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/45426c1e))
- chore(dicom): update js_package.py ([8cfcbd65](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8cfcbd65))
- docs(docker): update release images build steps ([ca5c12dc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ca5c12dc))
- ci: disable firefox tests ([14413be0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/14413be0))
- fix(dicom): fix handling of input images in read_image_dicom_file_series ([b9ace107](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b9ace107))
- build(dicom): using QIICR dcmqi 2024-08-28 master ([6cc06ace](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6cc06ace))
- docs(dicom): add acknowledgments to package documentation ([5e7ed78c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5e7ed78c))
- chore(dicom): update wasi segmentation modules ([8c608c30](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8c608c30))
- chore(dicom): bump version to 7.2.1 ([9c7a6cfd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9c7a6cfd))
- docs(downsample): fix live API demo link ([d619fe8e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d619fe8e))
- chore(demo-app): bump dependency versions ([a3bd7f58](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a3bd7f58))
- fix(downsample): load sample input image into viewer in demo app ([87076071](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/87076071))
- chore(downsample): bump version to 1.4.1 ([56cd8230](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/56cd8230))
- chore(downsample): bump package version to 1.4.2 ([397cb7b8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/397cb7b8))
- chore(dicom): bump version to 7.2.2 ([a88b3a08](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a88b3a08))
- docs: add Acknowledgments to Python online docs ([29ecddd3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/29ecddd3))
- docs: update email to matt@mmmccormick.com ([f1159034](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f1159034))
- build(compare-images): add native pixi build-test configuration ([e520a0de](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e520a0de))
- feat(typescript): add PointSet interface type support ([2c00366a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2c00366a))
- ci(native): add CI configuration ([0269821a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0269821a))
- build(compare-meshes): add native pixi build-test configuration ([918713eb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/918713eb))
- build(compress-stringify): add native pixi build-test configuration ([a2681ec3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a2681ec3))
- feat: improve mesh-io order ([9c75e010](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9c75e010))
- feat(mesh-io): add read-point-set write-point-set pipelines ([bfbc2616](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bfbc2616))
- feat(typescript): add PointSet pipeline input output support ([5fdb454c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5fdb454c))
- test(mesh-io): add obj-point-set-test ([462f263f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/462f263f))
- docs(docker): RELEASE tweak ([b705fd46](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b705fd46))
- feat(itk-wasm-cli): Update default Docker image for 20240923-b705fd46 ([713b5330](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/713b5330))
- build(downsample): add native pixi build-test configuration ([787c8e04](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/787c8e04))
- ci(native): add ref to setup-pixi ([b4e312c8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b4e312c8))
- ci(native): add checkout step ([be650a09](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/be650a09))
- docs(itk-python): example of file format conversion via wasm io packages ([c1bff618](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c1bff618))
- ci(python-wasm): fix pyodide install-browser version ([0161812e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0161812e))
- chore: update generated ts files for refactoring ([9d53f733](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9d53f733))
- feat(itk-wasm-cli): Update default Docker image for 20240930-9d53f733 ([dec93cd3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dec93cd3))
- fix(OutputPointSetIO): use WasmPointSetIOBase ([36d38bfd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/36d38bfd))
- feat(itk-wasm-cli): Update default Docker image for 20241001-36d38bfd ([462c1aba](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/462c1aba))
- test(mesh-io): exercise node write-point-set ([4cd157a9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4cd157a9))
- test(mesh-io): add read-point-set-node-test ([4bdae4d7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4bdae4d7))
- test(mesh-io): add write-point-set-node-test ([b786dfdb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b786dfdb))
- test(mesh-io): browser readPointSet writePointSet ([06b188ee](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/06b188ee))
- docs(mesh-io): add point set functions to typescript docs ([04c79b00](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/04c79b00))
- test(mesh-io): python read and write point set wasi tests ([fd4d5feb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fd4d5feb))
- chore(typescript): bump itk-wasm package version to 1.0.0-b.179 ([69261bc1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/69261bc1))
- test(python): add pyodide-py to hatch test environment deps ([06d95050](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/06d95050))
- chore(python): bumpy itkwasm pyodide test version to 0.26.2 ([e6985795](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e6985795))
- chore(python): bump Python package version to 1.0b179 ([f74e35ef](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f74e35ef))
- chore(mesh-io): bump TypeScript package to 1.4.0 ([04c5c5dd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/04c5c5dd))
- chore(mesh-io): bump Python packages to 1.4.0 ([4061f50c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4061f50c))
- test(mesh-io): add test_read_write_point_set_async ([1e02d531](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1e02d531))
- chore(mesh-io): bump version to 1.4.1 ([c41eea9f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c41eea9f))
- build(compress-stringify): use pixi for python wasm ([5b225876](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5b225876))
- build(compress-stringify): test python with pixi ([3d6df1e4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3d6df1e4))
- ci(python-wasm): add setup-pixi step ([3639b4b4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3639b4b4))
- chore(pnpm): update lockfile ([7cd34c5f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7cd34c5f))
- build(pnpm-script): run without existing environment.yml ([38426274](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/38426274))
- build(compress-stringify): build:gen:python without micromamba ([4e30ba3f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4e30ba3f))
- build(compress-stringify): no build:python:wasi required with pixi ([4043ef5a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4043ef5a))
- build(compress-stringify): add pnpm to pixi ([4bc57341](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4bc57341))
- build(compress-stringify): extend supported pixi platforms ([8e72187a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8e72187a))
- build(compare-images): add python pixi configuration ([29e54983](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/29e54983))
- chore(compare-images): bump version to 5.2.1 ([dd47b676](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dd47b676))
- build(compare-images): add pixi publish tasks ([fe45467c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fe45467c))
- build(compare-images): remove invalid python publish scripts ([51982f26](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/51982f26))
- chore(compra-images): bump version to 5.2.2 ([1c45d5a5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1c45d5a5))
- build(compare-images): download test data before python tests ([935cb9da](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/935cb9da))
- fix(pnpm-script): always build typescript for build:gen:typescript ([c51cce22](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c51cce22))
- chore(compare-images): bump version in 5.2.3 ([d63da801](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d63da801))
- build(compress-stringify): add version-sync and publish scripts ([ee3fcafe](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ee3fcafe))
- chore(compress-stringify): bump version to 3.3.1 ([cc26adb7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cc26adb7))
- build(compress-stringify): add .npmrc ([4e7bcc26](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4e7bcc26))
- build(compare-meshes): add pixi python configuration ([649ef6b3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/649ef6b3))
- chore(compare-meshes): bump version to 0.4.1 ([dfcd4cad](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dfcd4cad))
- build(dicom): add pixi python configuration ([5b2332f7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5b2332f7))
- chore(dicom): bump version to 7.2.3 ([3752ab79](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3752ab79))
- build(downsample): add pixi configuration ([eb454254](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/eb454254))
- chore(downsample): bump version to 1.4.3 ([6b196b50](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6b196b50))
- build(image-io): add pixi configuration ([2d2a5b88](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2d2a5b88))
- chore(image-io): bump version to 1.3.1 ([516760cf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/516760cf))
- build(mesh-io): add pixi configuration ([37068a17](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/37068a17))
- chore(mesh-io): bump version to 1.4.2 ([580ec0bd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/580ec0bd))
- build(transform-io): add pixi configuration ([ea082074](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ea082074))
- chore(transform-io): bump version to 0.1.1 ([d45381bb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d45381bb))
- ci(javascript): build @itk-wasm/demo-app prior to build:gen:typescript ([6062f750](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6062f750))
- ci(cypress): build @itk-wasm/demo-app for testing itk-wasm ([899f5eed](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/899f5eed))
- build(downsample): add missing @itk-wasm/image-io-build dep ([70807ed3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/70807ed3))
- ci(node.json): build deps in build:gen:typescript step ([0a137a04](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0a137a04))
- build(dicom): add missing compare-images-build dev dep ([d094a34a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d094a34a))
- docs(development): note pixi requirement ([b1aa4507](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b1aa4507))
- build(downsample): add missing compare-images-build dev dep ([542cbeef](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/542cbeef))
- build(javascript): remove packageManager specification ([390c65ff](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/390c65ff))
- build(python): remove hatch env specifications ([0285dcc7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0285dcc7))
- feat(itk-wasm-cli): Update default Docker image for 20241030-6c93a1be ([f62fdfd8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f62fdfd8))
- chore(pixi): bump lock files for new python dep packages ([4d52a102](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4d52a102))
- test(compare-meshes): add missing cow.iwm.cbor input file ([49551511](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/49551511))
- build: add pixi build and test targets ([8a13f20b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8a13f20b))
- chore(compress-stringify): bump js_package.py ([7fc138ff](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7fc138ff))
- build(transform-io): add pixi native build and test config ([a16e5fb4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a16e5fb4))
- chore(transform-io): update pixi.lock ([d47d1e08](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d47d1e08))
- chore(transform-io): add generated python ([397634d5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/397634d5))
- fix(OutputTransformIO): must call Read() with memory-io ([4d5b0e97](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4d5b0e97))
- test(core): add transform-read-write-pipeline ([4466da60](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4466da60))
- test(core): add transform-type-test.js ([809fade1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/809fade1))
- test(core): add node transform-test.js ([d23613da](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d23613da))
- test(transform-io): add node tests ([b6810af1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b6810af1))
- chore(transform-io): update generated bindings ([53b18ede](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/53b18ede))
- feat(itk-wasm-cli): Update default Docker image for 20241107-53b18ede ([a9c32d0e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a9c32d0e))
- fix(OutputTransformIO): assign TransformListJSON for later retrieval ([02a3e579](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/02a3e579))
- test(transform-io): additional node tests ([7a80dc86](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7a80dc86))
- ci(node): test transform-io package ([c02cd856](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c02cd856))
- feat(transform-io): add read-transform-node ([ded6ed8b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ded6ed8b))
- test(transform-io): add read-transform-node-test ([9dc2cdea](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9dc2cdea))
- test(node): add format write tests ([c5438d5c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c5438d5c))
- feat(transform-io): add writeTransformNode ([d4fcf16c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d4fcf16c))
- feat(itk-wasm-cli): Update default Docker image for 20241111-d4fcf16c ([27c236e3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/27c236e3))
- test(compare-meshes): add missing cow.iwm.cbor test input ([633724de](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/633724de))
- feat(transform-io): add readTransform, writeTransform ([bd85af50](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bd85af50))
- ci(cypress): test transform-io ([b211f1e8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b211f1e8))
- chore(bindgen): bump @itk-wasm/image-io, @itk-wasm/mesh-io ([b4d6bc49](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b4d6bc49))
- feat(bindgen): add @itk-wasm/transform-io dep ([e75fff5c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e75fff5c))
- test(itk-wasm): add transform-io for test pipelines ([9fa29247](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9fa29247))
- feat(itkwasm): add Python pixi configuration ([2fb81e03](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2fb81e03))
- feat(itkwasm): add Python TransformList type ([817aac5e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/817aac5e))
- chore(itkwasm): bump version to 1.0b180 ([f5e526ba](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f5e526ba))
- build(itkwasm): clear dist/ before publish ([118b3b33](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/118b3b33))
- build(itkwasm): add more pixi platforms ([32fff017](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/32fff017))
- build(transform-io): update itkwasm dep to 1.0b180 ([6200c8ee](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6200c8ee))
- feat(create-itk-wasm): add generate pixi.toml ([581b1465](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/581b1465))
- chore(typescript): bump itk-wasm package version to 1.0.0-b.180 ([65c231ea](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/65c231ea))
- build(pnpm-script): only call build:micromamba if env file exists ([a0873b00](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a0873b00))
- feat(create-itk-wasm): from environment.yml to pixi.toml ([753f760b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/753f760b))
- fix(itkwasm): dask is only a testing dependency ([d630f1ce](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d630f1ce))
- chore(itkwasm): bump version to 1.0b183 ([db91709f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/db91709f))
- feat(itkwasm): pyodide support for Transform ([4d20cc8f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4d20cc8f))
- chore(itkwasm): bump version to 1.0b185 ([b2ad9225](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b2ad9225))
- feat(transform-io): emscripten read_transform_async, write_transform_async ([395beb72](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/395beb72))
- feat(transform-io): dispatch read and write functions ([0d7641c4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0d7641c4))
- ci(python-wasm): add transform-io ([f9be4008](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f9be4008))
- build(transform-io): update pyproject.toml from license to license-expression ([cbe3dc07](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cbe3dc07))
- build(transform-io): add dist/ folders to .gitignore ([e72fc662](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e72fc662))
- chore(create-itk-wasm): bump itkwasm dep to 1.0b185 ([9857f85a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9857f85a))
- chore(create-itk-wasm): bump version to 2.0.0 ([04e9f8de](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/04e9f8de))
- build(create-itk-wasm): add native/ to .gitignore ([56a8689e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/56a8689e))
- build(pyproject.toml): replace license with license-expression ([b5f09f14](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b5f09f14))
- docs(hacking-itk-wasm): run pull.sh script in quickstart ([23b0c54b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/23b0c54b))
- build(docker): use fully qualified images for monorepo package builds ([2bf07695](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2bf07695))
- build(pixi): fix transform-io test data reference path ([00b24ef0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/00b24ef0))
- ci(cypress): pull development docker containers ([4767f6f7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4767f6f7))
- ci(cxx-python): fix commit reference ([a3638d71](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a3638d71))
- feat(bindgen): support string choices ([d1e44267](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d1e44267))
- chore(itk-wasm): bump version to 1.0.0-b.183 ([ce5fa5d4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ce5fa5d4))
- chore(bindgen): bump itk-wasm to 1.0.0-b.183 ([1aff94ee](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1aff94ee))
- fix(bindgen): ident level for wasi string choice param check ([92d15c7d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/92d15c7d))
- chore: bump itk-wasm to 1.0.0-b.184 ([d2e739f6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d2e739f6))
- ci(python-wasm): bump pyodide-actions/install-browser to latest ([d6d78c3f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d6d78c3f))
- ci(python-wasm): test pyodide with python > 3.11 ([de8f11bf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/de8f11bf))
- ci(python-wasm): only test pyodide on ubuntu-22.04 ([81090e0f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/81090e0f))
- feat(pull.sh): tag images as localhost after pulling ([53b191ee](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/53b191ee))
- ci(examples): bump node-version to 22 ([1d78755e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1d78755e))
- ci(examples): pull docker images ([a5f6e6ab](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a5f6e6ab))
- build(docker): use quay.io as repository name ([40d6095a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/40d6095a))
- ci(python-wasm): bump pyodide-version to 0.26.3 ([edf1efd0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/edf1efd0))
- ci(python-wasm): bump node-version to 22 ([a85fd772](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a85fd772))
- feat(mesh-filters): geogram conversion test pipeline ([1e274d79](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1e274d79))
- feat(WasmMeshToMeshFilter): add QuadEdgeMesh specialization ([11db76c5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/11db76c5))
- feat(MeshToWasmMeshFilter): add QuadEdgeMesh specialization ([04c33be0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/04c33be0))
- feat(mesh-filters): start meshtoGeogramMesh ([855a6ea5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/855a6ea5))
- feat(meshToGeogramMesh): transfer point data, cell data ([b734fa89](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b734fa89))
- feat(mesh-filters): geogramMeshToMesh ([40b286fb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/40b286fb))
- feat(mesh-filters): add repair pipeline ([09227284](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/09227284))
- feat(mesh-filters): add smooth-remesh ([47e1ca5f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/47e1ca5f))
- fix(WasmMeshToMeshFilter): add PolyLine cell support ([f5a2063e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f5a2063e))
- feat(mesh-filters): add slice-mesh pipeline ([6c1da13e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6c1da13e))
- feat(mesh-filters): add keep-largest-component ([20ee7ecf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/20ee7ecf))
- test(mesh-filters): update test data ([910a0d94](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/910a0d94))
- docs(options-module): indicate unexpected parameter type error source ([8b1a4b74](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8b1a4b74))
- fix(pnpm-script): quote packageDescription ([dcf1f0fb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dcf1f0fb))
- build(mesh-filters): contrain geogram build ([4ecff1bf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4ecff1bf))
- build(mesh-filters): fix wasi OFF module dependency ([15ca8ca1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/15ca8ca1))
- fix(mesh-filters): update geogram-conversion pipeline name ([e1473679](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e1473679))
- build(mesh-filters): wasi patches for pmp, geogram ([5ece2ed5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5ece2ed5))
- fix(mesh-filters): use add_flag in repair for boolean option ([46d84891](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/46d84891))
- WIP: test(mesh-filters): add node tests ([a1c7e49c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a1c7e49c))
- test(mesh-filters): add node tests ([80d13dde](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/80d13dde))
- feat(compare-meshes): support more pixel types ([93abe226](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/93abe226))
- chore(compare-meshes): bump version to 0.5.0 ([645a1ea7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/645a1ea7))
- chore(compare-meshes): update pixi.lock ([a010c8d5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a010c8d5))
- feat(mesh-filters): support more pixel types ([5eae02f0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5eae02f0))
- test(mesh-filters): update test data ([163a1f91](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/163a1f91))
- chore(mesh-filters): bump version to 0.2.0 ([53eb1933](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/53eb1933))
- build(docker): enable the IOMeshMZ3 remote module ([94c52207](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/94c52207))
- feat(itk-wasm-cli): Update default Docker image for 20241203-bb28d61f ([2c4e3f93](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2c4e3f93))
- feat(mesh-io): Add C++ MZ3 IO and tests ([b5c57616](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b5c57616))
- chore(mesh-io): add mz3 typescript generated bindings ([f40f11e1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f40f11e1))
- feat(mesh-io): node MZ3 support ([11fcdf82](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/11fcdf82))
- feat(mesh-io): mz3 browser support ([968322e2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/968322e2))
- feat(mesh-io): python wasi mz3 support ([a4d3866d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a4d3866d))
- chore(mesh-io): bump package version to 1.5.0 ([47e00524](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/47e00524))
- feat(mesh-io): python mz3 emscripten support ([53dd7fa2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/53dd7fa2))
- feat(mesh-io): python dispatch mz3 support ([19db749e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/19db749e))
- chore(mesh-io): add generated python tests ([1207acf5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1207acf5))
- docs(mesh-io): update supported python versions ([cc9b25c1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cc9b25c1))
- chore(mesh-io): add generated python emscripten tests ([1e5e9f46](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1e5e9f46))
- docs(mesh-io): fix publish task description ([e8114221](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e8114221))
- docs(python): upgrade package development status from Alpha to Beta ([73af34c4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/73af34c4))
- feat(itk-wasm-cli): Update default Docker image ([2d90f494](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2d90f494))
- test(mesh-io): add input .mz3 test datasets ([a8246ab1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a8246ab1))
- ci(python-wasm): build python wasi for all packages ([a7958f39](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a7958f39))
- build(dicom): ensure dcmqi finds pixi's Python ([533ec463](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/533ec463))
- test(mesh-io): add baseline mz3 meshes ([e257991f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e257991f))
- fix(bindgen): fix indentation for wasi choice check ([41c7775c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/41c7775c))
- build(docker): bump dockcross to 20241227-d0e5a43 ([7eff9fbd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7eff9fbd))
- feat(itk-wasm-cli): Update default Docker image for 20241227-7eff9fbd ([33cfa7ee](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/33cfa7ee))
- chore: update build artifacts ([8c1164cf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8c1164cf))
- test(image-io): add generated python tests ([b1792fbf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b1792fbf))
- chore(pixi): bump pnpm version ([986ed91a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/986ed91a))
- chore: add python tests/ generated dirs to .gitignore ([3176de7e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3176de7e))
- build(docker): pre-touch symbol_lists.lock ([3e17f46c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3e17f46c))
- build(docker): support native host multi-arch builds ([e70e05da](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e70e05da))
- feat(itk-wasm-cli): Update default Docker image for 20241230-e70e05da ([80c0d1b0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/80c0d1b0))
- build(docker): fix emscripten detection ([52997e55](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/52997e55))
- docs(docker): push with --push-manifest ([0a6d4584](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0a6d4584))
- build(docker): remove images of the same name before creating manifests ([76748372](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/76748372))
- feat(itk-wasm-cli): Update default Docker image for 20250102-76748372 ([640fe3be](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/640fe3be))
- build(docker): fix manifest generation ([64aed84f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/64aed84f))
- ci(wasi): build sequencially ([e0dd0f1d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e0dd0f1d))
- ci(wasi): bump node version to 22 ([3214b49a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3214b49a))
- ci(wasi): bump runner to ubuntu-24.04 ([dc82fa29](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dc82fa29))
- ci(wasi): do not explicitly pull docker images ([709ec1dd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/709ec1dd))
- build(docker): use manifest-tool with docker ([5540a61d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5540a61d))
- feat(itk-wasm-cli): Update default Docker image for 20250102-709ec1dd ([0d5dc250](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0d5dc250))
- feat(itk-wasm-cli): Update default Docker image for 20250102-0d5dc250 ([cb036a64](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cb036a64))
- chore(wasi): update package modules ([dac1dc86](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dac1dc86))
- chore(itk-wasm): bump version to 1.0.0-b.185 ([27835139](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/27835139))
- chore(create-itk-wasm): bump itk-wasm version to 1.0.0-b.185 ([cab05145](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cab05145))
- chore(create-itk-wasm): bump version to 2.1.0 ([c3fea2a4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c3fea2a4))
- chore(compare-images): bump version to 5.3.0 ([663f9ff0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/663f9ff0))
- chore(compare-images): bump version to 5.3.1 ([c63b859f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c63b859f))
- chore(compress-stringify): bump version to 3.4.0 ([7f6923f8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7f6923f8))
- chore(io-packages): bump versions ([d26e2bc2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d26e2bc2))
- chore(dicom): bump version to 7.3.0 ([09107405](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/09107405))
- chore(downsample): bump version to 1.5.0 ([a4d1dd0c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a4d1dd0c))
- chore(hello-pipeline-example): bump itk-wasm to 1.0.0-b.185 ([6d93443e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6d93443e))
- chore(different-input-types-example): bump itk-wasm to 1.0.0-b.185 ([1039a24b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1039a24b))
- fix(examples): fix itk-wasm run argument passing ([f0791e6f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f0791e6f))
- ci(wasi): remove custom run shell ([e859e67e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e859e67e))
- ci(wasi): do not use debug builds ([17e850e8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/17e850e8))
- ci(wasi): remove --sequential from build and test steps ([9652f6ac](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9652f6ac))
- build(native): install make ([d5c2fbef](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d5c2fbef))
- build(native): move cmake and cxx-compiler to the default environment ([77e1ab37](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/77e1ab37))
- test(pixi): exclude create-itk-wasm from top level ([d0f42fed](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d0f42fed))
- test(cypress): bump to 13.17.0 to address firefox connection issues ([f8740714](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f8740714))
- docs(hacking-itk-wasm): update getting started requirements ([612dfb4c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/612dfb4c))
- build(docker): use dockcross/web-wasi-threads as base for itkwasm/wasi ([d8f4fb0b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d8f4fb0b))
- feat(itk-wasm-cli): Update default Docker image for 20250107-d8f4fb0b ([4269a3ba](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4269a3ba))
- chore(mesh-io): bump version to 1.6.1 ([1621a8c6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1621a8c6))
- build(bindgen): specify env for wasi ([22168c03](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/22168c03))
- build(wasi): add pthread_atfork, pthread_attr_setscope shims ([5631c7f6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5631c7f6))
- feat(itk-wasm-cli): Update default Docker image for 20250107-5631c7f6 ([86b95fa4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/86b95fa4))
- build(different-input-types-example): use fully qualified wasi image ([ceebded3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ceebded3))
- fix(docker): posixShim.c -> pthreadShim.c ([e5ebcad9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e5ebcad9))
- feat(itk-wasm-cli): Update default Docker image for 20250108-e5ebcad9 ([4dd73c77](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4dd73c77))
- build(docker): copy *.c into the ITKWebAssemblyInterface dir ([171dcd01](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/171dcd01))
- feat(itk-wasm-cli): Update default Docker image for 20250108-171dcd01 ([7484b79d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7484b79d))
- build(wasi): compile pthreadShim in cxx ([5a978ee5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5a978ee5))
- feat(itk-wasm-cli): Update default Docker image for 20250108-5a978ee5 ([4ccb4c90](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4ccb4c90))
- chore(hello-world-example): bump itk-wasm, use full image identifier ([cc3b208f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cc3b208f))
- feat(itk-wasm-cli): Update default Docker image for 20250108-cc3b208f ([6b19476f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6b19476f))
- build(pthreadShim): return values ([e1e50d38](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e1e50d38))
- build(wasi): specify initial, max memory ([b6c6122e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b6c6122e))
- chore(itkwasm): bump wasmtime dep to 28.0.0 ([e4058d74](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e4058d74))
- feat(itk-wasm-cli): Update default Docker image for 20250109-e4058d74 ([31d33fb3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/31d33fb3))
- feat(interface-json-node-wasi): support modules that use threads ([1085b92f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1085b92f))
- feat(itk-wasm): cli run with wasmtime supports threads ([3f48cb9c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3f48cb9c))
- test(itk-wasm): add pthreads and cxx-threads test pipelines ([1f6a9784](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1f6a9784))
- build(wasi): add __cxa_init_primary_exception shim ([abc26740](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/abc26740))
- test(itkwasm): add test wasi threads pipeline modules ([c890071a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c890071a))
- build(docker): use emulated pthreads ([ff70bd3b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ff70bd3b))
- feat(itk-wasm-cli): Update default Docker image for 20250123-ff70bd3b ([22285a5e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/22285a5e))
- build(dicom): flags for wasi-emulated-threads ([d0332e25](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d0332e25))
- chore(pnpm): bump to 9.15.3 ([629d0384](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/629d0384))
- docs: add SciPy article citation ([0cd94b6e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0cd94b6e))
- chore(mesh-io): bump version to 1.6.2 ([2e1048e6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2e1048e6))
- test(image-io): add native configure-build-test configuration ([d7a1ee3e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d7a1ee3e))
- feat(image-io): read and write the metadata dictionary ([1992b6cb](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1992b6cb))
- feat(itk-wasm-cli): Update default Docker image for 20250120-1992b6cb ([473523f1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/473523f1))
- test(image-io): add gdcm-test.js ([a6e18027](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a6e18027))
- fix(itkwasm): convert metadata dict to json array ([15d32900](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/15d32900))
- chore(itkwasm): bump version to 1.0b186 ([a15043ad](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a15043ad))
- test(image-io): add python test for DICOM metadata ([ccf3d51e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ccf3d51e))
- build(MetaDataDictionaryCBOR): address MSVC build errors ([f6cc4c62](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f6cc4c62))
- feat(itk-wasm-cli): Update default Docker image for 20250121-f6cc4c62 ([edade886](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/edade886))
- chore(image-io): bump version from image-io ([e0d7b11e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e0d7b11e))
- feat(itk-wasm-cli): Update default Docker image for 20250124-b579b6d4 ([bd526ab8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bd526ab8))
- build(wasi): compile itkObjectFactoryBase.cxx with -fno-lto ([c6588545](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c6588545))
- build(wasi): add -fno-lto for __cxa_init_primary_exception ([363b6f4b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/363b6f4b))
- feat(itk-wasm-cli): Update default Docker image for 20250125-363b6f4b ([7ec81a28](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7ec81a28))
- build(wasi): change __cxa_init_primary_exception shim return ([c7560245](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c7560245))
- build(dcmtk): update for dcmjpeg support ([7881ebc0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7881ebc0))
- build(wasi): return value for __cxa_init_primary_exception shim ([6af1dbec](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6af1dbec))
- feat(itk-wasm-cli): Update default Docker image for 20250126-6af1dbec ([b9ae96ba](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b9ae96ba))
- feat(itk-wasm-cli): Update default Docker image for 20250126-b9ae96ba ([4b631241](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4b631241))
- build(ITKWebAssemblyInterface): set all required flags ([cb6510fe](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cb6510fe))
- feat(itk-wasm-cli): Update default Docker image for 20250127-cb6510fe ([aae9550e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/aae9550e))
- build(ITKWebAssemblyInterface): do not pass emscripten flags with wasi ([ed899a98](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ed899a98))
- feat(itk-wasm-cli): Update default Docker image for 20250127-ed899a98 ([874ed371](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/874ed371))
- build(different-input-types): use workspace itk-wasm ([fc7c3ca6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fc7c3ca6))
- ci: temporarily disable hello-world cypress test ([b96cb717](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b96cb717))
- ci(different-input-types): use pnpm ([2e469d7c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2e469d7c))
- ci(wasi): download test data ([e46c0f7f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e46c0f7f))
- build(hello-world): use pnpm workspace. ([d75b942c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d75b942c))
- feat(itk-wasm-cli): Update default Docker image for 20250128-80554789 ([ba25b2e8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ba25b2e8))
- docs(docker): update docker image update process ([3236bdec](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3236bdec))
- build(mesh-filters): bypass geogram-related warnings ([aac71be9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/aac71be9))
- build(MeshToPolyData): pass toolchain flags ([c0f467b8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c0f467b8))
- build(glaze): bypass static_assert warnings ([ad7e8041](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ad7e8041))
- docs(hacking): fix ITK-Wasm capitalization ([6ed75e4e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6ed75e4e))
- docs(packages): point to create-itk-wasm ([a7b83082](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a7b83082))
- build(itk-wasm): generate index-wasm-worker-embedded.js ([2f6b68b5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2f6b68b5))
- ci(examples): use pnpm for hello-world ([89bf9e1c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/89bf9e1c))
- feat(itk-wasm-cli): Update default Docker image for 20250128-660258ac ([74c373d6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/74c373d6))
- build(mesh-filters): bump geogram to latest ([e081756f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e081756f))
- build(mesh-filters): address wasi build ([ee3adcb7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ee3adcb7))
- build(mesh-filters): add pixi configuration ([8170a0c0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8170a0c0))
- chore(mesh-filters): add typescript generated files ([91e3eb90](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/91e3eb90))
- chore(mesh-filters): add pixi.lock ([7d55516a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7d55516a))
- test(mesh-filters): define test_repair.py ([60f054a6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/60f054a6))
- test(mesh-filters): keep_largest_component wasi test ([285d9707](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/285d9707))
- test(mesh-filters): define test_smooth_remesh ([aa820ea4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/aa820ea4))
- test(mesh-filters): add test_slice_mesh.py ([32419778](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/32419778))
- chore(mesh-filters): add test data to .gitignore ([bd466184](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bd466184))
- chore(mesh-filters): bump version to 1.6.0 ([109eb0a0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/109eb0a0))
- test(image-io): exclude wasi gdcm write tests ([06e63d40](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/06e63d40))
- build(mesh-filters): add wasi emulated process clocks flags ([9b2765f6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9b2765f6))
- build(mesh-filters): add -msimd128, -flto ([aed93481](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/aed93481))
- build(docker): ensure WASI CMake variable is set ([c2821335](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c2821335))
- build(mesh-filters): add geogram WASI flags via VORPALINE_PLATFORM ([c78034a5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c78034a5))
- build(docker): overwrite dockcross wasi CMake toolchain file with our flags ([1cafe9f3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1cafe9f3))
- build(docker): pass CMAKE_TOOLCHAIN_FILE in web-build ([11f6cb11](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/11f6cb11))
- feat(itk-wasm-cli): Update default Docker image for 20250130-11f6cb11 ([5b470fe4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5b470fe4))
- test(mesh-filters): use off for slice-mesh outputs ([d9af7c19](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d9af7c19))
- chore(dicom): python module content updates ([1a879bdd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1a879bdd))
- WIP: COMP: Build plastimatch ([5925d0c1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5925d0c1))
- WIP: RT-study ([21b738ab](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/21b738ab))
- feat(dicom): basic write-rt-struct pipeline ([94ffb4d0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/94ffb4d0))
- feat(write-rt-struct): remove reference series input ([a68ce19a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a68ce19a))
- build(dicom): use ITK-Wasm's ITK ([b50700ea](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b50700ea))
- build(dicom): work-around plastimatch wasm CheckTypeSize ([d38d8879](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d38d8879))
- build(dicom): address plastimatch emscripten build ([ef32a19f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ef32a19f))
- test(dicom): exclude plastimatch tests with wasi ([71d39c62](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/71d39c62))
- feat(itk-wasm-cli): Update default Docker image for 20250130 ([1ba076a7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1ba076a7))
- feat(dicom): use custom itk_wasm_rt_study in write-rt-struct ([1e0d400a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1e0d400a))
- docs(dicom): acknowledge Plastimatch in typescript README ([67ccfb1a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/67ccfb1a))
- fix(dicom): do not output to stdout with write-rt-struct ([362bb136](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/362bb136))
- test(dicom): typescript test write-rt-struct with custom metadata ([1d1e0aab](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1d1e0aab))
- test(dicom): add write_rt_struct dicom tests ([66f5c2f1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/66f5c2f1))
- docs(dicom): add Plastimatch to python package acknowledgements ([76308a0b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/76308a0b))
- style(dicom): explictly use quiet with rt_study.save_rtss ([7064b512](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7064b512))
- test(dicom): update testing data hash ([58430c69](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/58430c69))
- chore(dicom): bump version to 7.4.0 ([558e212f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/558e212f))
- fix(dicom): improve write-rt-struct uid initialization ([9ca8a8d8](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9ca8a8d8))
- feat(dicom): specify StructureSetLabel, Name, SoftwareVersion in write-rt-struct ([d3df13e2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d3df13e2))
- chore(dicom): bump version to 7.5.0 ([ce851e8e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ce851e8e))
- chore(dicom): bump package version to 7.5.1 ([6b3f1453](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6b3f1453))
- chore(dicom): update wasi modules ([3043fb97](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3043fb97))
- chore(dicom): update pyodide to 0.27.2 ([2e24856f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2e24856f))
- feat(load-emscripten-module-node): load zstd compressed wasm ([31f6f47f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/31f6f47f))
- refactor(typescript-bindings): only copy compressed wasm binary ([88ed98e1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/88ed98e1))
- chore(itk-wasm): bump version to 1.0.0-b.186 ([e3610a43](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e3610a43))
- chore(dicom): bump version to 7.5.2 ([893d5ce1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/893d5ce1))
- test(dicom): use copy_files_to_pyodide ([93ee4f70](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/93ee4f70))
- test(dicom): update testing data ([bca39dcd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bca39dcd))
- fix(load-emscripten-module-main-thread): load compressed wasm ([9e815d80](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9e815d80))
- ci(examples): retry docker pulls ([00d9fa9e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/00d9fa9e))
- test(compare-images): use copy_files_to_pyodide ([22371024](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/22371024))
- perf(wasi): strip debug content with wasm-tools ([df693e08](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/df693e08))
- feat(itk-wasm-cli): Update default Docker image for 20250214-df693e08 ([48136937](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/48136937))
- chore(compare-images): update wasi modules ([863926a4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/863926a4))
- chore(compress-stringify): update wasi modules ([1978fb92](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1978fb92))
- chore(dicom): update wasi modules ([c2c58b62](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c2c58b62))
- chore(transform-io): update wasi-modules ([bee019c2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bee019c2))
- docs(gh-pages): build and upload mesh-filters and transform-io ([4351fc15](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4351fc15))
- chore(deps): bump cypress to 14.0.3 ([780f21d4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/780f21d4))
- chore(deps): bump pnpm to 10.4.0 ([1ee7fcce](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1ee7fcce))
- style(itk-wasm): linter fixes ([8de1f88d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/8de1f88d))
- ci(browser-tests): bump to ubuntu-24.04 ([d8a87c68](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d8a87c68))
- ci(cypress): re-order node install for cypress binary availability ([4147e8bc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4147e8bc))
- build(itk-wasm): use bundled worker for creating bundle ([02fb8cd4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/02fb8cd4))
- chore(itk-wasm): bump version to 1.0.0-b.187 ([a2d00ea5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a2d00ea5))
- docs(hello-world-example): use itk::wasm::Pipeline ([5cde5777](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5cde5777))
- fix(hello-world-example): update browser use for 1.0.0-b.187 ([3a1eb238](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3a1eb238))
- ci(examples): pull debug images for debug example ([0742394e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0742394e))
- build(docker): bump ITK to release-5.4 branch HEAD ([ec5e3e5e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ec5e3e5e))
- feat(itk-wasm-cli): Update default Docker image for 20250221-ec5e3e5e ([d114ddf9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d114ddf9))
- chore(itk-wasm): bump version to 1.0.0-b.188 ([3ff71c54](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3ff71c54))
- chore(compare-images): bump version to 5.4.0 ([c8d200b5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c8d200b5))
- chore(compare-meshes): bump version to 0.6.0 ([360e800d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/360e800d))
- chore(compress-stringify): bump version to 3.5.0 ([9169837c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9169837c))
- chore(dicom): bump package version to 7.6.0 ([f249ed9b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f249ed9b))
- build(dicom): add tests/data/ to .gitignore ([b9723e88](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b9723e88))
- build: add tests/data/ to packages .gitignore ([e14346bc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e14346bc))
- chore(downsample): bump version to 1.6.0 ([50b67295](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/50b67295))
- chore(image-io): bump version to 1.6.0 ([adf7c915](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/adf7c915))
- chore(mesh-filters): bump version to 1.7.0 ([80461ade](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/80461ade))
- chore(mesh-io): bump version to 1.7.0 ([f4d10ab4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f4d10ab4))
- chore(transform-io): bump version to 1.1.0 ([71cc6f37](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/71cc6f37))
- docs(mesh-io): fix app link ([7967e814](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7967e814))
- docs(mesh-filters): add typescript app, docs link ([fb4d2007](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fb4d2007))
- docs(itk-wasm): add mesh-filters to packages page ([9ebce350](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9ebce350))
- docs(compare-meshes): add README demo, docs links ([1db4a12c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1db4a12c))
- docs(transform-io): add README demo, docs links ([b1d55549](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b1d55549))
- build(docker): enable corepack for pnpm availability ([5e4b1568](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5e4b1568))
- feat(itk-wasm-cli): Update default Docker image for 20250225-5e4b1568 ([0e458243](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0e458243))
- feat(itk-wasm-cli): Update default Docker image for 20250227-0e458243 ([3921519a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3921519a))
- ci(python-wasm): bump to ubuntu-24.04 ([46ae64c9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/46ae64c9))
- ci(toolchains): bump to ubuntu-24.04 and use docker pull retry ([133da36a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/133da36a))
- build: bump pnpm to 10.5.2 ([0fb6c942](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0fb6c942))
- chore(deps): bump cypress to 14.1.0 ([2f74b517](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2f74b517))
- ci(python-wasm): pull docker images with retry ([17c64467](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/17c64467))
- perf(itkwasm): additional wasmtime config options ([2d8e64da](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2d8e64da))
- fix(polydata): add missing metadata in python dataclass ([288bd965](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/288bd965))
- build(compress-stringify): remove -build ts build dep ([33285853](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/33285853))
- docs(dicom): note RT Struct support ([07cc0fbd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/07cc0fbd))
- docs(docker): fix commit message template capitalization ([12938442](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/12938442))
- fix(itk-wasm): add metadata to PolyData typescript interface ([0fe1496b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0fe1496b))
- docs(transform): document Typescript interface types, supported file formats ([b0c154f3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b0c154f3))
- chore(deps): bump cypress to 14.2.0 ([0b10d3ac](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0b10d3ac))
- docs(parts): grammar fixes ([e80168cf](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e80168cf))
- feat(itk-wasm): add pthreadSupportAvailable ([195553e9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/195553e9))
- test(itk-wasm): pthreadSupportAvailable browser test ([5462d6bd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5462d6bd))
- test(itk-wasm): enable cross origin isolation in browser tests ([e286c86e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e286c86e))
- docs: move Interface Type Model toc location and set title ([33ea0a0c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/33ea0a0c))
- build(model): add pixi model-docs target ([80134116](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/80134116))
- docs(model): add generated transform docs ([cc1a8ab7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cc1a8ab7))
- docs(typescript): link to model ([ebe279b2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ebe279b2))
- docs(typescript): remove old function API docs ([f1b0919e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f1b0919e))
- chore(deps): bump cypress to 14.3.0 ([cec4e4b7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cec4e4b7))
- chore(deps): bump pnpm 10.8.0 ([2a594d58](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2a594d58))
- docs(typescript): improve intro grammar ([c342a81d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c342a81d))
- docs(index): add GitHub Star badge ([2afbafea](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2afbafea))
- feat: esm example ([154846d0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/154846d0))
- docs: add esm module documentation ([a52d632f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a52d632f))
- feat: add itk::wasm::SupportInputTransformTypes ([346b7f5e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/346b7f5e))
- chore: update vite example ([ba7b2d3b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ba7b2d3b))
- ci: migrate vite example to playwright ([319a45af](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/319a45af))
- docs: remove umd example ([f2900c77](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f2900c77))
- docs: add vite.webm example video ([c9772eba](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c9772eba))
- test: use http instead of http-get with start-server-and-test ([73058701](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/73058701))
- test(vite-example): us start and port 8085 ([3b452bfd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/3b452bfd))
- test(vite-example): add missing test dataset ([e88e3196](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e88e3196))
- feat(create-itk-wasm): generate itk-wasm-env.bash ([87bbb4c6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/87bbb4c6))
- docs(create-itk-wasm): document driving with pixi ([6dd8fe8a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/6dd8fe8a))
- feat(bindgen): emscripten python test output dir -> "tests" ([e1a7cece](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e1a7cece))
- feat(bindgen): generate dispatch package test scaffold ([545966bc](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/545966bc))
- chore(itk-wasm): bump version to 1.0.0-b.181 ([9fe97a95](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/9fe97a95))
- feat(create-itk-wasm): bump itk-wasm version to 1.0.0-b.181 ([783df44b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/783df44b))
- fix(itk-wasm): underscore to identify emscripten wheel ([06aa0d97](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/06aa0d97))
- feat(create-itk-wasm): bump itk-wasm version to 1.0.0-b.182 ([2dbc2ce6](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2dbc2ce6))
- ci(cxx-python): update to latest for libtiff symbol Windows build issues ([e020a4b0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e020a4b0))
- build(cxx): add missing mesh dependency includes ([f3e224e2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f3e224e2))
- fix(itkwasm): interface type is TransformList instead of Transform ([dcf4098f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dcf4098f))
- chore(itkwasm): bump version to 1.0b181 ([bdbbc2f0](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bdbbc2f0))
- test(transform-io): wasi format tests ([4120317b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4120317b))
- test(itkwasm): bump pyodide to 0.26.4 ([78d13955](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/78d13955))
- fix(itkwasm): add WasiConfig args for wasmtime 27.0.0 ([95f60876](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/95f60876))
- chore(itkwasm): bump version to 1.0b182 ([94adbbef](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/94adbbef))
- feat(itkwasm): add pipeline TransformList support ([a4516fda](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a4516fda))
- build(itkwasm): bump wasmtime dep to 27.0.1 ([781430e9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/781430e9))
- chore(itkwasm): bump version to 1.0b184 ([5f7da327](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5f7da327))
- test(transform-io): wasi format tests ([83ca16bd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/83ca16bd))
- chore(bindgen): bump itkwasm to 1.0.b184, Python to 3.9-3.13 ([7ca5ca75](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/7ca5ca75))
- feat(transform-io): add wasi read_transform, write_transform ([c0d76059](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c0d76059))
- test(transform-io): emscripten hdf5 read write tests ([2ffc2ca3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2ffc2ca3))
- chore(itkwasm): bump Python package to 1.0b188 ([cd5e8718](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cd5e8718))
- test(itkwasm): use pyodide copy_files_to_pyodide ([ce235bd1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ce235bd1))
- feat(docker): add emscripten-threads-base image build config ([73cae14d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/73cae14d))
- build(docker): add emscripten-threads build commands ([911fddc5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/911fddc5))
- refactor(docker): make threads imaging naming use tag ([f83ec6ba](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f83ec6ba))
- build(docker): set .threads.wasm target suffix ([d9dacd7c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d9dacd7c))
- build(docker): fix specification of the threads build ([f36e27e1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f36e27e1))
- build(docker): add threads tags to push.sh ([dc8e64ae](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/dc8e64ae))
- build(docker): add threads tag to pull.sh ([f4baed59](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f4baed59))
- feat(itk-wasm-cli): Update default Docker image for 20250306-f4baed59 ([5bee239f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5bee239f))
- chore: bump pnpm to 10.5.2 ([c5b80947](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c5b80947))
- feat(itk-wasm-cli): Update default Docker image for 20250306-c5b80947 ([504834cd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/504834cd))
- build(docker): drop wasi threads workaround patches ([f4c27be3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f4c27be3))
- feat(itk-wasm-cli): Update default Docker image for 20250311-f4c27be3 ([941cf190](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/941cf190))
- chore: update wasm artifacts ([2dfbcfa7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2dfbcfa7))
- ci(browser): use docker pull retry ([5145d43e](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5145d43e))
- ci: add clang-format linter Action ([69010461](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/69010461))
- ci: relax checkout action version to v4 ([73f83d1c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/73f83d1c))
- ci(clang-format-linter): use ITK master branch ([f52907c3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f52907c3))
- ci(cxx-python): update cxx versions ([984f7d91](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/984f7d91))
- style: update clang-format configuration file to ITK 19.1.7 ([682b3f34](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/682b3f34))
- ci: build ITK with C++20 ([60b47508](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/60b47508))
- style(itkPipeline): tparam Iteratorable to TIterableable ([bd538a68](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bd538a68))
- docs(parts): update, note TypeScript, Python core tooling ([18bf8874](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/18bf8874))
- docs(parts): add wasmtime-py link ([0985ac7b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0985ac7b))
- ci(scorecard): update config for sarif upload error ([fed3c72b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/fed3c72b))
- build(itk-wasm): add test:buildTestPipelines:emscriptenThreads target ([f0891eb7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f0891eb7))
- build(docker): add VERSION build arg for emscripten-threads ([f6552026](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f6552026))
- build: bump ITK to v5.4.3 ([964fe20b](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/964fe20b))
- feat(itk-wasm-cli): update default Docker image for 20250319-964fe20b ([4552658c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4552658c))
- docs(debugging): itk-wasm -> ITK-Wasm ([76746859](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/76746859))
- ci(cxx): disable macos-13 build ([2c34dae9](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2c34dae9))
- ci(python-wasm): fix retry step os identifier ([022d86ee](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/022d86ee))
- docs(typescript): fix interface-type links ([76c1192a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/76c1192a))
- chore(deps): bump cypress to 14.2.1 ([13a692dd](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/13a692dd))
- docs: add SciPy 2024 video ([2a40da09](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/2a40da09))
- chore(deps): bump pnpm to 10.7.1 ([244f9c9c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/244f9c9c))
- build: upgrade vite to 6.2.3 and shx to 0.4.0 ([ad620e3a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/ad620e3a))
- style(pthread-support-available): use === operator ([0f7079f4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/0f7079f4))
- ci(wasi): add docker pull retry ([1e678920](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/1e678920))
- chore: bump cypress to 14.4.0, start-server-and-test to 2.0.12 ([e34dc5c5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/e34dc5c5))
- ci: set playwright working directory to examples/esm ([d006969d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d006969d))
- docs: update vite example docs ([527f3118](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/527f3118))


### Michael Onken (1):

#### Miscellaneous Changes

- build(apply-presentation-to-image): update get iccprofile ([4d931706](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4d931706))


### Paul Elliott (1):

#### Miscellaneous Changes

- build(demo-app): bump version so slice view shows thin axis ([992419e2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/992419e2))


### Shreeraj Jadhav (19):

#### Miscellaneous Changes

- fix(WebAssemblyInterface): support vector/multi-component images ([f9f28057](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/f9f28057))
- fix(WebAssemblyInterface): update affected binaries ([b89bcb6c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b89bcb6c))
- fix(itkPipeline): parameters parsing crash when no space in line ([4e833dd1](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/4e833dd1))
- build(msvc): add cmake flag to enable msvc static runtime debug library ([c3c39b7a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c3c39b7a))
- feat(compare-images): add spatial tolerance ([75f2db4f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/75f2db4f))
- build: add quay prefix to default image containers ([43a0fc01](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/43a0fc01))
- fix(runPipelineNode): unmounting overlapping paths ([566bff2a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/566bff2a))
- fix(OutputImage): computation of buffer size ([236a49f7](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/236a49f7))
- docs: update docs and add scripts for native build ([a9b4631a](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/a9b4631a))
- build: fix cmake warning on packages/gdcm for CMP0135 ([922238f5](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/922238f5))
- build: Add dcmqi as dependency for read/write DICOM seg objects ([b24426b4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/b24426b4))
- feat(read-seg): add dicom/dcmtk pipeline to read segmentation ([372d80e4](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/372d80e4))
- fix: read/write dicom segmentations fixes ([c463b36d](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c463b36d))
- test(dcmqi-node-js): add new test file for dcmqi functions ([d827f9ac](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/d827f9ac))
- test(dcmqi-python): add python tests ([796707d3](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/796707d3))
- test(dcmqi-browser): add e2e browser tests ([cc6836c2](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/cc6836c2))
- docs(Dockerfile): specify DCMTK branch name in comments ([bcce1f59](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/bcce1f59))
- test(write-overlapping-segmentation): soft-disable browser test ([c0b7442c](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/c0b7442c))
- test(dicom): Add IDC test data and cases ([5cf9780f](https://github.com/InsightSoftwareConsortium/ITK-Wasm/commit/5cf9780f))
