/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.io;

import com.mysql.cj.api.io.ValueFactory;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.DataConversionException;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class DefaultValueFactory<T>
implements ValueFactory<T> {
    private T unsupported(String sourceType) {
        throw new DataConversionException(Messages.getString("ResultSet.UnsupportedConversion", new Object[]{sourceType, this.getTargetTypeName()}));
    }

    @Override
    public T createFromDate(int year, int month, int day) {
        return this.unsupported("DATE");
    }

    @Override
    public T createFromTime(int hours, int minutes, int seconds, int nanos) {
        return this.unsupported("TIME");
    }

    @Override
    public T createFromTimestamp(int year, int month, int day, int hours, int minutes, int seconds, int nanos) {
        return this.unsupported("TIMESTAMP");
    }

    @Override
    public T createFromLong(long l2) {
        return this.unsupported("LONG");
    }

    @Override
    public T createFromBigInteger(BigInteger i2) {
        return this.unsupported("BIGINT");
    }

    @Override
    public T createFromDouble(double d2) {
        return this.unsupported("DOUBLE");
    }

    @Override
    public T createFromBigDecimal(BigDecimal d2) {
        return this.unsupported("DECIMAL");
    }

    @Override
    public T createFromBytes(byte[] bytes, int offset, int length) {
        return this.unsupported("VARCHAR/TEXT/BLOB");
    }

    @Override
    public T createFromNull() {
        return null;
    }
}

