/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.postgresql.PGProperty;
import org.postgresql.copy.CopyOperation;
import org.postgresql.core.Field;
import org.postgresql.core.Logger;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.Notification;
import org.postgresql.core.PGBindException;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.CompositeQuery;
import org.postgresql.core.v3.CopyInImpl;
import org.postgresql.core.v3.CopyOperationImpl;
import org.postgresql.core.v3.CopyOutImpl;
import org.postgresql.core.v3.DescribeRequest;
import org.postgresql.core.v3.ExecuteRequest;
import org.postgresql.core.v3.Portal;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.SimpleQuery;
import org.postgresql.core.v3.V3ParameterList;
import org.postgresql.core.v3.V3Query;
import org.postgresql.jdbc.BatchResultHandler;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.PSQLWarning;
import org.postgresql.util.ServerErrorMessage;

public class QueryExecutorImpl
implements QueryExecutor {
    private Object lockedFor = null;
    private static final int MAX_BUFFERED_RECV_BYTES = 64000;
    private static final int NODATA_QUERY_RESPONSE_SIZE_BYTES = 250;
    private final HashMap<PhantomReference<SimpleQuery>, String> parsedQueryMap = new HashMap();
    private final ReferenceQueue<SimpleQuery> parsedQueryCleanupQueue = new ReferenceQueue();
    private final HashMap<PhantomReference<Portal>, String> openPortalMap = new HashMap();
    private final ReferenceQueue<Portal> openPortalCleanupQueue = new ReferenceQueue();
    private static final Portal UNNAMED_PORTAL = new Portal(null, "unnamed");
    private final Deque<SimpleQuery> pendingParseQueue = new ArrayDeque<SimpleQuery>();
    private final Deque<Portal> pendingBindQueue = new ArrayDeque<Portal>();
    private final Deque<ExecuteRequest> pendingExecuteQueue = new ArrayDeque<ExecuteRequest>();
    private final Deque<DescribeRequest> pendingDescribeStatementQueue = new ArrayDeque<DescribeRequest>();
    private final Deque<SimpleQuery> pendingDescribePortalQueue = new ArrayDeque<SimpleQuery>();
    private long nextUniqueID = 1L;
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;
    private final Logger logger;
    private final boolean allowEncodingChanges;
    private int estimatedReceiveBufferBytes = 0;
    private final SimpleQuery beginTransactionQuery = new SimpleQuery(new NativeQuery("BEGIN", new int[0]), null);
    private final SimpleQuery EMPTY_QUERY = new SimpleQuery(new NativeQuery("", new int[0]), null);

    public QueryExecutorImpl(ProtocolConnectionImpl protoConnection, PGStream pgStream, Properties info, Logger logger) {
        this.protoConnection = protoConnection;
        this.pgStream = pgStream;
        this.logger = logger;
        this.allowEncodingChanges = PGProperty.ALLOW_ENCODING_CHANGES.getBoolean(info);
    }

    private void lock(Object obtainer) throws PSQLException {
        if (this.lockedFor == obtainer) {
            throw new PSQLException(GT.tr("Tried to obtain lock while already holding it"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this.waitOnLock();
        this.lockedFor = obtainer;
    }

    private void unlock(Object holder) throws PSQLException {
        if (this.lockedFor != holder) {
            throw new PSQLException(GT.tr("Tried to break lock on database connection"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this.lockedFor = null;
        this.notify();
    }

    private void waitOnLock() throws PSQLException {
        while (this.lockedFor != null) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new PSQLException(GT.tr("Interrupted while waiting to obtain lock on database connection"), PSQLState.OBJECT_NOT_IN_STATE, (Throwable)ie);
            }
        }
    }

    boolean hasLock(Object holder) {
        return this.lockedFor == holder;
    }

    public Query createSimpleQuery(String sql) {
        return this.parseQuery(sql, false);
    }

    public Query createParameterizedQuery(String sql) {
        return this.parseQuery(sql, true);
    }

    private Query parseQuery(String query, boolean withParameters) {
        List<NativeQuery> queries = Parser.parseJdbcSql(query, this.protoConnection.getStandardConformingStrings(), withParameters, true);
        if (queries.isEmpty()) {
            return this.EMPTY_QUERY;
        }
        if (queries.size() == 1) {
            return new SimpleQuery(queries.get(0), this.protoConnection);
        }
        SimpleQuery[] subqueries = new SimpleQuery[queries.size()];
        int[] offsets = new int[subqueries.length];
        int offset = 0;
        for (int i2 = 0; i2 < queries.size(); ++i2) {
            NativeQuery nativeQuery = queries.get(i2);
            offsets[i2] = offset;
            subqueries[i2] = new SimpleQuery(nativeQuery, this.protoConnection);
            offset += nativeQuery.bindPositions.length;
        }
        return new CompositeQuery(subqueries, offsets);
    }

    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        this.waitOnLock();
        if (this.logger.logDebug()) {
            this.logger.debug("simple execute, handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        if (parameters == null) {
            parameters = SimpleQuery.NO_PARAMETERS;
        }
        boolean describeOnly = (0x20 & flags) != 0;
        ((V3ParameterList)parameters).convertFunctionOutParameters();
        if (!describeOnly) {
            ((V3ParameterList)parameters).checkAllParametersSet();
        }
        try {
            try {
                handler = this.sendQueryPreamble(handler, flags);
                ErrorTrackingResultHandler trackingHandler = new ErrorTrackingResultHandler(handler);
                this.sendQuery((V3Query)query, (V3ParameterList)parameters, maxRows, fetchSize, flags, trackingHandler, null);
                this.sendSync();
                this.processResults(handler, flags);
                this.estimatedReceiveBufferBytes = 0;
            }
            catch (PGBindException se) {
                this.sendSync();
                this.processResults(handler, flags);
                this.estimatedReceiveBufferBytes = 0;
                handler.handleError(new PSQLException(GT.tr("Unable to bind parameter values for statement."), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)se.getIOException()));
            }
        }
        catch (IOException e2) {
            this.protoConnection.abort();
            handler.handleError(new PSQLException(GT.tr("An I/O error occurred while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e2));
        }
        handler.handleCompletion();
    }

    public synchronized void execute(Query[] queries, ParameterList[] parameterLists, BatchResultHandler batchHandler, int maxRows, int fetchSize, int flags) throws SQLException {
        boolean describeOnly;
        this.waitOnLock();
        if (this.logger.logDebug()) {
            this.logger.debug("batch execute " + queries.length + " queries, handler=" + batchHandler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        boolean bl = describeOnly = (0x20 & flags) != 0;
        if (!describeOnly) {
            for (ParameterList parameterList : parameterLists) {
                if (parameterList == null) continue;
                ((V3ParameterList)parameterList).checkAllParametersSet();
            }
        }
        ResultHandler handler = batchHandler;
        try {
            handler = this.sendQueryPreamble(batchHandler, flags);
            ErrorTrackingResultHandler trackingHandler = new ErrorTrackingResultHandler(handler);
            this.estimatedReceiveBufferBytes = 0;
            for (int i2 = 0; i2 < queries.length; ++i2) {
                V3Query query = (V3Query)queries[i2];
                V3ParameterList parameters = (V3ParameterList)parameterLists[i2];
                if (parameters == null) {
                    parameters = SimpleQuery.NO_PARAMETERS;
                }
                this.sendQuery(query, parameters, maxRows, fetchSize, flags, trackingHandler, batchHandler);
                if (trackingHandler.hasErrors()) break;
            }
            if (!trackingHandler.hasErrors()) {
                this.sendSync();
                this.processResults(handler, flags);
                this.estimatedReceiveBufferBytes = 0;
            }
        }
        catch (IOException e2) {
            this.protoConnection.abort();
            handler.handleError(new PSQLException(GT.tr("An I/O error occurred while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e2));
        }
        handler.handleCompletion();
    }

    private ResultHandler sendQueryPreamble(final ResultHandler delegateHandler, int flags) throws IOException {
        this.processDeadParsedQueries();
        this.processDeadPortals();
        if ((flags & 0x10) != 0 || this.protoConnection.getTransactionState() != 0) {
            return delegateHandler;
        }
        int beginFlags = 2;
        if ((flags & 1) != 0) {
            beginFlags |= 1;
        }
        this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, beginFlags);
        return new ResultHandler(){
            private boolean sawBegin = false;

            @Override
            public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
                if (this.sawBegin) {
                    delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
                }
            }

            @Override
            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                if (!this.sawBegin) {
                    this.sawBegin = true;
                    if (!status.equals("BEGIN")) {
                        this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                } else {
                    delegateHandler.handleCommandStatus(status, updateCount, insertOID);
                }
            }

            @Override
            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            @Override
            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            @Override
            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
    }

    public synchronized byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        this.waitOnLock();
        if (!suppressBegin) {
            this.doSubprotocolBegin();
        }
        try {
            this.sendFastpathCall(fnid, (SimpleParameterList)parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioe) {
            this.protoConnection.abort();
            throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public void doSubprotocolBegin() throws SQLException {
        if (this.protoConnection.getTransactionState() == 0) {
            if (this.logger.logDebug()) {
                this.logger.debug("Issuing BEGIN before fastpath or copy call.");
            }
            ResultHandler handler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                @Override
                public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
                }

                @Override
                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                @Override
                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }

                @Override
                public void handleError(SQLException error) {
                    if (this.sqle == null) {
                        this.sqle = error;
                    } else {
                        this.sqle.setNextException(error);
                    }
                }

                @Override
                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
                this.sendSync();
                this.processResults(handler, 0);
                this.estimatedReceiveBufferBytes = 0;
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    public ParameterList createFastpathParameters(int count) {
        return new SimpleParameterList(count, this.protoConnection);
    }

    private void sendFastpathCall(int fnid, SimpleParameterList params) throws SQLException, IOException {
        int i2;
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> FunctionCall(" + fnid + ", " + params.getParameterCount() + " params)");
        }
        int paramCount = params.getParameterCount();
        int encodedSize = 0;
        for (i2 = 1; i2 <= paramCount; ++i2) {
            if (params.isNull(i2)) {
                encodedSize += 4;
                continue;
            }
            encodedSize += 4 + params.getV3Length(i2);
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendInteger4(10 + 2 * paramCount + 2 + encodedSize + 2);
        this.pgStream.SendInteger4(fnid);
        this.pgStream.SendInteger2(paramCount);
        for (i2 = 1; i2 <= paramCount; ++i2) {
            this.pgStream.SendInteger2(params.isBinary(i2) ? 1 : 0);
        }
        this.pgStream.SendInteger2(paramCount);
        for (i2 = 1; i2 <= paramCount; ++i2) {
            if (params.isNull(i2)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            this.pgStream.SendInteger4(params.getV3Length(i2));
            params.writeV3Value(i2, this.pgStream);
        }
        this.pgStream.SendInteger2(1);
        this.pgStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void processNotifies() throws SQLException {
        this.waitOnLock();
        if (this.protoConnection.getTransactionState() != 0) {
            return;
        }
        try {
            int c2;
            block7: while (this.pgStream.hasMessagePending()) {
                c2 = this.pgStream.ReceiveChar();
                switch (c2) {
                    case 65: {
                        this.receiveAsyncNotify();
                        continue block7;
                    }
                    case 69: {
                        throw this.receiveErrorResponse();
                    }
                    case 78: {
                        SQLWarning warning = this.receiveNoticeResponse();
                        this.protoConnection.addWarning(warning);
                        continue block7;
                    }
                }
            }
            return;
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", Character.valueOf((char)c2)), PSQLState.CONNECTION_FAILURE);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        boolean endQuery = false;
        SQLException error = null;
        byte[] returnValue = null;
        block7: while (!endQuery) {
            int c2 = this.pgStream.ReceiveChar();
            switch (c2) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block7;
                }
                case 69: {
                    SQLException newError = this.receiveErrorResponse();
                    if (error == null) {
                        error = newError;
                        continue block7;
                    }
                    error.setNextException(newError);
                    continue block7;
                }
                case 78: {
                    SQLWarning warning = this.receiveNoticeResponse();
                    this.protoConnection.addWarning(warning);
                    continue block7;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    continue block7;
                }
                case 86: {
                    int msgLen = this.pgStream.ReceiveInteger4();
                    int valueLen = this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE FunctionCallResponse(" + valueLen + " bytes)");
                    }
                    if (valueLen == -1) continue block7;
                    byte[] buf = new byte[valueLen];
                    this.pgStream.Receive(buf, 0, valueLen);
                    returnValue = buf;
                    continue block7;
                }
            }
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", Character.valueOf((char)c2)), PSQLState.CONNECTION_FAILURE);
        }
        if (error != null) {
            throw error;
        }
        return returnValue;
    }

    public synchronized CopyOperation startCopy(String sql, boolean suppressBegin) throws SQLException {
        this.waitOnLock();
        if (!suppressBegin) {
            this.doSubprotocolBegin();
        }
        byte[] buf = Utils.encodeUTF8(sql);
        try {
            if (this.logger.logDebug()) {
                this.logger.debug(" FE=> Query(CopyStart)");
            }
            this.pgStream.SendChar(81);
            this.pgStream.SendInteger4(buf.length + 4 + 1);
            this.pgStream.Send(buf);
            this.pgStream.SendChar(0);
            this.pgStream.flush();
            return this.processCopyResults(null, true);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when starting copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    private synchronized void initCopy(CopyOperationImpl op) throws SQLException, IOException {
        this.pgStream.ReceiveInteger4();
        int rowFormat = this.pgStream.ReceiveChar();
        int numFields = this.pgStream.ReceiveInteger2();
        int[] fieldFormats = new int[numFields];
        for (int i2 = 0; i2 < numFields; ++i2) {
            fieldFormats[i2] = this.pgStream.ReceiveInteger2();
        }
        this.lock(op);
        op.init(this, rowFormat, fieldFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCopy(CopyOperationImpl op) throws SQLException {
        int errors;
        SQLException error;
        block27: {
            if (!this.hasLock(op)) {
                throw new PSQLException(GT.tr("Tried to cancel an inactive copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
            }
            error = null;
            errors = 0;
            try {
                if (op instanceof CopyInImpl) {
                    QueryExecutorImpl queryExecutorImpl = this;
                    synchronized (queryExecutorImpl) {
                        if (this.logger.logDebug()) {
                            this.logger.debug("FE => CopyFail");
                        }
                        byte[] msg = Utils.encodeUTF8("Copy cancel requested");
                        this.pgStream.SendChar(102);
                        this.pgStream.SendInteger4(5 + msg.length);
                        this.pgStream.Send(msg);
                        this.pgStream.SendChar(0);
                        this.pgStream.flush();
                        do {
                            try {
                                this.processCopyResults(op, true);
                            }
                            catch (SQLException se) {
                                ++errors;
                                if (error != null) {
                                    SQLException next;
                                    SQLException e2 = se;
                                    while ((next = e2.getNextException()) != null) {
                                        e2 = next;
                                    }
                                    e2.setNextException(error);
                                }
                                error = se;
                            }
                        } while (this.hasLock(op));
                        break block27;
                    }
                }
                if (op instanceof CopyOutImpl) {
                    this.protoConnection.sendQueryCancel();
                }
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("Database connection failed when canceling copy operation"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
            finally {
                QueryExecutorImpl queryExecutorImpl = this;
                synchronized (queryExecutorImpl) {
                    if (this.hasLock(op)) {
                        this.unlock(op);
                    }
                }
            }
        }
        if (op instanceof CopyInImpl) {
            if (errors < 1) {
                throw new PSQLException(GT.tr("Missing expected error response to copy cancel request"), PSQLState.COMMUNICATION_ERROR);
            }
            if (errors > 1) {
                throw new PSQLException(GT.tr("Got {0} error responses to single copy cancel request", String.valueOf(errors)), PSQLState.COMMUNICATION_ERROR, error);
            }
        }
    }

    public synchronized long endCopy(CopyInImpl op) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to end inactive copy"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            if (this.logger.logDebug()) {
                this.logger.debug(" FE=> CopyDone");
            }
            this.pgStream.SendChar(99);
            this.pgStream.SendInteger4(4);
            this.pgStream.flush();
            this.processCopyResults(op, true);
            return op.getHandledRowCount();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when ending copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public synchronized void writeToCopy(CopyInImpl op, byte[] data, int off, int siz) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to write to an inactive copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> CopyData(" + siz + ")");
        }
        try {
            this.pgStream.SendChar(100);
            this.pgStream.SendInteger4(siz + 4);
            this.pgStream.Send(data, off, siz);
            this.processCopyResults(op, false);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when writing to copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public synchronized void flushCopy(CopyInImpl op) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to write to an inactive copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            this.pgStream.flush();
            this.processCopyResults(op, false);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when writing to copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    synchronized void readFromCopy(CopyOutImpl op) throws SQLException {
        if (!this.hasLock(op)) {
            throw new PSQLException(GT.tr("Tried to read from inactive copy"), PSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            this.processCopyResults(op, true);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Database connection failed when reading from copy"), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    CopyOperationImpl processCopyResults(CopyOperationImpl op, boolean block) throws SQLException, IOException {
        boolean endReceiving = false;
        SQLException error = null;
        SQLException errors = null;
        while (!endReceiving && (block || this.pgStream.hasMessagePending())) {
            int c2;
            if (!block && (c2 = this.pgStream.PeekChar()) == 67) {
                if (!this.logger.logDebug()) break;
                this.logger.debug(" <=BE CommandStatus, Ignored until CopyDone");
                break;
            }
            c2 = this.pgStream.ReceiveChar();
            switch (c2) {
                case 65: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE Asynchronous Notification while copying");
                    }
                    this.receiveAsyncNotify();
                    break;
                }
                case 78: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE Notification while copying");
                    }
                    this.protoConnection.addWarning(this.receiveNoticeResponse());
                    break;
                }
                case 67: {
                    String status = this.receiveCommandStatus();
                    try {
                        if (op == null) {
                            throw new PSQLException(GT.tr("Received CommandComplete ''{0}'' without an active copy operation", status), PSQLState.OBJECT_NOT_IN_STATE);
                        }
                        op.handleCommandStatus(status);
                    }
                    catch (SQLException se) {
                        error = se;
                    }
                    block = true;
                    break;
                }
                case 69: {
                    error = this.receiveErrorResponse();
                    block = true;
                    break;
                }
                case 71: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyInResponse");
                    }
                    if (op != null) {
                        error = new PSQLException(GT.tr("Got CopyInResponse from server during an active {0}", op.getClass().getName()), PSQLState.OBJECT_NOT_IN_STATE);
                    }
                    op = new CopyInImpl();
                    this.initCopy(op);
                    endReceiving = true;
                    break;
                }
                case 72: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyOutResponse");
                    }
                    if (op != null) {
                        error = new PSQLException(GT.tr("Got CopyOutResponse from server during an active {0}", op.getClass().getName()), PSQLState.OBJECT_NOT_IN_STATE);
                    }
                    op = new CopyOutImpl();
                    this.initCopy(op);
                    endReceiving = true;
                    break;
                }
                case 100: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyData");
                    }
                    int len = this.pgStream.ReceiveInteger4() - 4;
                    byte[] buf = this.pgStream.Receive(len);
                    if (op == null) {
                        error = new PSQLException(GT.tr("Got CopyData without an active copy operation"), PSQLState.OBJECT_NOT_IN_STATE);
                    } else if (!(op instanceof CopyOutImpl)) {
                        error = new PSQLException(GT.tr("Unexpected copydata from server for {0}", op.getClass().getName()), PSQLState.COMMUNICATION_ERROR);
                    } else {
                        ((CopyOutImpl)op).handleCopydata(buf);
                    }
                    endReceiving = true;
                    break;
                }
                case 99: {
                    int len;
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyDone");
                    }
                    if ((len = this.pgStream.ReceiveInteger4() - 4) > 0) {
                        this.pgStream.Receive(len);
                    }
                    if (!(op instanceof CopyOutImpl)) {
                        error = new PSQLException("Got CopyDone while not copying from server", PSQLState.OBJECT_NOT_IN_STATE);
                    }
                    block = true;
                    break;
                }
                case 83: {
                    int l_len = this.pgStream.ReceiveInteger4();
                    String name = this.pgStream.ReceiveString();
                    String value = this.pgStream.ReceiveString();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("client_encoding") && !value.equalsIgnoreCase("UTF8") && !this.allowEncodingChanges) {
                        this.protoConnection.close();
                        error = new PSQLException(GT.tr("The server''s client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UTF8 for correct operation.", value), PSQLState.CONNECTION_FAILURE);
                        endReceiving = true;
                    }
                    if (name.equals("DateStyle") && !value.startsWith("ISO,")) {
                        this.protoConnection.close();
                        error = new PSQLException(GT.tr("The server''s DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", value), PSQLState.CONNECTION_FAILURE);
                        endReceiving = true;
                    }
                    if (!name.equals("standard_conforming_strings")) break;
                    if (value.equals("on")) {
                        this.protoConnection.setStandardConformingStrings(true);
                        break;
                    }
                    if (value.equals("off")) {
                        this.protoConnection.setStandardConformingStrings(false);
                        break;
                    }
                    this.protoConnection.close();
                    error = new PSQLException(GT.tr("The server''s standard_conforming_strings parameter was reported as {0}. The JDBC driver expected on or off.", value), PSQLState.CONNECTION_FAILURE);
                    endReceiving = true;
                    break;
                }
                case 90: {
                    this.receiveRFQ();
                    if (this.hasLock(op)) {
                        this.unlock(op);
                    }
                    op = null;
                    endReceiving = true;
                    break;
                }
                case 84: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE RowDescription (during copy ignored)");
                    }
                    this.skipMessage();
                    break;
                }
                case 68: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE DataRow (during copy ignored)");
                    }
                    this.skipMessage();
                    break;
                }
                default: {
                    throw new IOException(GT.tr("Unexpected packet type during copy: {0}", Integer.toString(c2)));
                }
            }
            if (error == null) continue;
            if (errors != null) {
                error.setNextException(errors);
            }
            errors = error;
            error = null;
        }
        if (errors != null) {
            throw errors;
        }
        return op;
    }

    private void flushIfDeadlockRisk(Query query, boolean disallowBatching, ErrorTrackingResultHandler trackingHandler, BatchResultHandler batchHandler, int flags) throws IOException {
        this.estimatedReceiveBufferBytes += 250;
        SimpleQuery sq = (SimpleQuery)query;
        if (sq.isStatementDescribed()) {
            int maxResultRowSize = sq.getMaxResultRowSize();
            if (maxResultRowSize >= 0) {
                this.estimatedReceiveBufferBytes += maxResultRowSize;
            } else {
                this.logger.debug("Couldn't estimate result size or result size unbounded, disabling batching for this query.");
                disallowBatching = true;
            }
        }
        if (disallowBatching || this.estimatedReceiveBufferBytes >= 64000) {
            this.logger.debug("Forcing Sync, receive buffer full or batching disallowed");
            this.sendSync();
            this.processResults(trackingHandler, flags);
            this.estimatedReceiveBufferBytes = 0;
            if (batchHandler != null) {
                batchHandler.secureProgress();
            }
        }
    }

    private void sendQuery(V3Query query, V3ParameterList parameters, int maxRows, int fetchSize, int flags, ErrorTrackingResultHandler trackingHandler, BatchResultHandler batchHandler) throws IOException, SQLException {
        boolean disallowBatching;
        SimpleQuery[] subqueries = query.getSubqueries();
        SimpleParameterList[] subparams = parameters.getSubparams();
        boolean bl = disallowBatching = (flags & 0x80) != 0;
        if (subqueries == null) {
            this.flushIfDeadlockRisk(query, disallowBatching, trackingHandler, batchHandler, flags);
            if (!trackingHandler.hasErrors()) {
                this.sendOneQuery((SimpleQuery)query, (SimpleParameterList)parameters, maxRows, fetchSize, flags);
            }
        } else {
            for (int i2 = 0; i2 < subqueries.length; ++i2) {
                SimpleQuery subquery = subqueries[i2];
                this.flushIfDeadlockRisk(subquery, disallowBatching, trackingHandler, batchHandler, flags);
                if (trackingHandler.hasErrors()) break;
                SimpleParameterList subparam = SimpleQuery.NO_PARAMETERS;
                if (subparams != null) {
                    subparam = subparams[i2];
                }
                this.sendOneQuery(subquery, subparam, maxRows, fetchSize, flags);
            }
        }
    }

    private void sendSync() throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Sync");
        }
        this.pgStream.SendChar(83);
        this.pgStream.SendInteger4(4);
        this.pgStream.flush();
    }

    private void sendParse(SimpleQuery query, SimpleParameterList params, boolean oneShot) throws IOException {
        int[] typeOIDs = params.getTypeOIDs();
        if (query.isPreparedFor(typeOIDs)) {
            return;
        }
        query.unprepare();
        this.processDeadParsedQueries();
        query.setFields(null);
        String statementName = null;
        if (!oneShot) {
            statementName = "S_" + this.nextUniqueID++;
            query.setStatementName(statementName);
            query.setStatementTypes((int[])typeOIDs.clone());
            this.registerParsedQuery(query, statementName);
        }
        byte[] encodedStatementName = query.getEncodedStatementName();
        String nativeSql = query.getNativeSql();
        if (this.logger.logDebug()) {
            StringBuilder sbuf = new StringBuilder(" FE=> Parse(stmt=" + statementName + ",query=\"");
            sbuf.append(nativeSql);
            sbuf.append("\",oids={");
            for (int i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                if (i2 != 1) {
                    sbuf.append(",");
                }
                sbuf.append(params.getTypeOID(i2));
            }
            sbuf.append("})");
            this.logger.debug(sbuf.toString());
        }
        byte[] queryUtf8 = Utils.encodeUTF8(nativeSql);
        int encodedSize = 4 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + queryUtf8.length + 1 + 2 + 4 * params.getParameterCount();
        this.pgStream.SendChar(80);
        this.pgStream.SendInteger4(encodedSize);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.Send(queryUtf8);
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        for (int i3 = 1; i3 <= params.getParameterCount(); ++i3) {
            this.pgStream.SendInteger4(params.getTypeOID(i3));
        }
        this.pendingParseQueue.add(query);
    }

    private void sendBind(SimpleQuery query, SimpleParameterList params, Portal portal, boolean noBinaryTransfer) throws IOException {
        int i2;
        byte[] encodedPortalName;
        String statementName = query.getStatementName();
        byte[] encodedStatementName = query.getEncodedStatementName();
        byte[] byArray = encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        if (this.logger.logDebug()) {
            StringBuilder sbuf = new StringBuilder(" FE=> Bind(stmt=" + statementName + ",portal=" + portal);
            for (int i3 = 1; i3 <= params.getParameterCount(); ++i3) {
                sbuf.append(",$").append(i3).append("=<").append(params.toString(i3)).append(">");
            }
            sbuf.append(")");
            this.logger.debug(sbuf.toString());
        }
        long encodedSize = 0L;
        for (int i4 = 1; i4 <= params.getParameterCount(); ++i4) {
            if (params.isNull(i4)) {
                encodedSize += 4L;
                continue;
            }
            encodedSize += 4L + (long)params.getV3Length(i4);
        }
        Field[] fields = query.getFields();
        if (!noBinaryTransfer && query.needUpdateFieldFormats()) {
            for (Field field : fields) {
                if (!this.useBinary(field)) continue;
                field.setFormat(1);
                query.setHasBinaryFields(true);
            }
        }
        int numBinaryFields = !noBinaryTransfer && query.hasBinaryFields() ? fields.length : 0;
        encodedSize = (long)(4 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + 2 + params.getParameterCount() * 2 + 2) + encodedSize + 2L + (long)(numBinaryFields * 2);
        if (encodedSize > 0x3FFFFFFFL) {
            throw new PGBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream parameters.", encodedSize)));
        }
        this.pgStream.SendChar(66);
        this.pgStream.SendInteger4((int)encodedSize);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        for (int i5 = 1; i5 <= params.getParameterCount(); ++i5) {
            this.pgStream.SendInteger2(params.isBinary(i5) ? 1 : 0);
        }
        this.pgStream.SendInteger2(params.getParameterCount());
        PGBindException bindException = null;
        for (i2 = 1; i2 <= params.getParameterCount(); ++i2) {
            if (params.isNull(i2)) {
                this.pgStream.SendInteger4(-1);
                continue;
            }
            this.pgStream.SendInteger4(params.getV3Length(i2));
            try {
                params.writeV3Value(i2, this.pgStream);
                continue;
            }
            catch (PGBindException be) {
                bindException = be;
            }
        }
        this.pgStream.SendInteger2(numBinaryFields);
        for (i2 = 0; i2 < numBinaryFields; ++i2) {
            this.pgStream.SendInteger2(fields[i2].getFormat());
        }
        this.pendingBindQueue.add(portal == null ? UNNAMED_PORTAL : portal);
        if (bindException != null) {
            throw bindException;
        }
    }

    private boolean useBinary(Field field) {
        int oid = field.getOID();
        return this.protoConnection.useBinaryForReceive(oid);
    }

    private void sendDescribePortal(SimpleQuery query, Portal portal) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(portal=" + portal + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = 5 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        this.pendingDescribePortalQueue.add(query);
        query.setPortalDescribed(true);
    }

    private void sendDescribeStatement(SimpleQuery query, SimpleParameterList params, boolean describeOnly) throws IOException {
        byte[] encodedStatementName;
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(statement=" + query.getStatementName() + ")");
        }
        int encodedSize = 5 + ((encodedStatementName = query.getEncodedStatementName()) == null ? 0 : encodedStatementName.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(83);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pendingDescribeStatementQueue.add(new DescribeRequest(query, params, describeOnly));
        this.pendingDescribePortalQueue.add(query);
        query.setStatementDescribed(true);
        query.setPortalDescribed(true);
    }

    private void sendExecute(SimpleQuery query, Portal portal, int limit) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Execute(portal=" + portal + ",limit=" + limit + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(69);
        this.pgStream.SendInteger4(5 + encodedSize + 4);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(limit);
        this.pendingExecuteQueue.add(new ExecuteRequest(query, portal));
    }

    private void sendClosePortal(String portalName) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> ClosePortal(" + portalName + ")");
        }
        byte[] encodedPortalName = portalName == null ? null : Utils.encodeUTF8(portalName);
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(6 + encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
    }

    private void sendCloseStatement(String statementName) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> CloseStatement(" + statementName + ")");
        }
        byte[] encodedStatementName = Utils.encodeUTF8(statementName);
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(5 + encodedStatementName.length + 1);
        this.pgStream.SendChar(83);
        this.pgStream.Send(encodedStatementName);
        this.pgStream.SendChar(0);
    }

    private void sendOneQuery(SimpleQuery query, SimpleParameterList params, int maxRows, int fetchSize, int flags) throws IOException {
        boolean describeStatement;
        boolean forceDescribePortal;
        boolean noResults = (flags & 4) != 0;
        boolean noMeta = (flags & 2) != 0;
        boolean describeOnly = (flags & 0x20) != 0;
        boolean usePortal = (flags & 8) != 0 && !noResults && !noMeta && fetchSize > 0 && !describeOnly;
        boolean oneShot = (flags & 1) != 0 && !usePortal;
        boolean noBinaryTransfer = (flags & 0x100) != 0;
        boolean bl = forceDescribePortal = (flags & 0x200) != 0;
        int rows = noResults ? 1 : (!usePortal ? maxRows : (maxRows != 0 && fetchSize > maxRows ? maxRows : fetchSize));
        this.sendParse(query, params, oneShot);
        boolean queryHasUnknown = query.hasUnresolvedTypes();
        boolean paramsHasUnknown = params.hasUnresolvedTypes();
        boolean bl2 = describeStatement = describeOnly || !oneShot && paramsHasUnknown && queryHasUnknown && !query.isStatementDescribed();
        if (!describeStatement && paramsHasUnknown && !queryHasUnknown) {
            int[] queryOIDs = query.getStatementTypes();
            int[] paramOIDs = params.getTypeOIDs();
            for (int i2 = 0; i2 < paramOIDs.length; ++i2) {
                if (paramOIDs[i2] != 0) continue;
                params.setResolvedType(i2 + 1, queryOIDs[i2]);
            }
        }
        if (describeStatement) {
            this.sendDescribeStatement(query, params, describeOnly);
            if (describeOnly) {
                return;
            }
        }
        Portal portal = null;
        if (usePortal) {
            String portalName = "C_" + this.nextUniqueID++;
            portal = new Portal(query, portalName);
        }
        this.sendBind(query, params, portal, noBinaryTransfer);
        if (!(noMeta || describeStatement || query.getFields() != null && !forceDescribePortal)) {
            this.sendDescribePortal(query, portal);
        }
        this.sendExecute(query, portal, rows);
    }

    private void registerParsedQuery(SimpleQuery query, String statementName) {
        if (statementName == null) {
            return;
        }
        PhantomReference<SimpleQuery> cleanupRef = new PhantomReference<SimpleQuery>(query, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(cleanupRef, statementName);
        query.setCleanupRef(cleanupRef);
    }

    private void processDeadParsedQueries() throws IOException {
        Reference<SimpleQuery> deadQuery;
        while ((deadQuery = this.parsedQueryCleanupQueue.poll()) != null) {
            String statementName = this.parsedQueryMap.remove(deadQuery);
            this.sendCloseStatement(statementName);
            deadQuery.clear();
        }
    }

    private void registerOpenPortal(Portal portal) {
        if (portal == UNNAMED_PORTAL) {
            return;
        }
        String portalName = portal.getPortalName();
        PhantomReference<Portal> cleanupRef = new PhantomReference<Portal>(portal, this.openPortalCleanupQueue);
        this.openPortalMap.put(cleanupRef, portalName);
        portal.setCleanupRef(cleanupRef);
    }

    private void processDeadPortals() throws IOException {
        Reference<Portal> deadPortal;
        while ((deadPortal = this.openPortalCleanupQueue.poll()) != null) {
            String portalName = this.openPortalMap.remove(deadPortal);
            this.sendClosePortal(portalName);
            deadPortal.clear();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void processResults(ResultHandler handler, int flags) throws IOException {
        noResults = (flags & 4) != 0;
        bothRowsAndStatus = (flags & 64) != 0;
        tuples /* !! */  = null;
        endQuery = false;
        doneAfterRowDescNoData = false;
        block23: while (!endQuery) {
            c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block23;
                }
                case 49: {
                    this.pgStream.ReceiveInteger4();
                    parsedQuery = this.pendingParseQueue.removeFirst();
                    parsedStatementName = parsedQuery.getStatementName();
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE ParseComplete [" + parsedStatementName + "]");
                    continue block23;
                }
                case 116: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterDescription");
                    }
                    describeData = this.pendingDescribeStatementQueue.getFirst();
                    query = describeData.query;
                    params = describeData.parameterList;
                    describeOnly = describeData.describeOnly;
                    origStatementName = query.getStatementName();
                    numParams = this.pgStream.ReceiveInteger2();
                    for (i = 1; i <= numParams; ++i) {
                        typeOid = this.pgStream.ReceiveInteger4();
                        params.setResolvedType(i, typeOid);
                    }
                    if (origStatementName == null && query.getStatementName() == null || origStatementName != null && origStatementName.equals(query.getStatementName())) {
                        query.setStatementTypes((int[])params.getTypeOIDs().clone());
                    }
                    if (describeOnly) {
                        doneAfterRowDescNoData = true;
                        continue block23;
                    }
                    this.pendingDescribeStatementQueue.removeFirst();
                    continue block23;
                }
                case 50: {
                    this.pgStream.ReceiveInteger4();
                    boundPortal = this.pendingBindQueue.removeFirst();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE BindComplete [" + boundPortal + "]");
                    }
                    this.registerOpenPortal(boundPortal);
                    continue block23;
                }
                case 51: {
                    this.pgStream.ReceiveInteger4();
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE CloseComplete");
                    continue block23;
                }
                case 110: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE NoData");
                    }
                    this.pendingDescribePortalQueue.removeFirst();
                    if (!doneAfterRowDescNoData) continue block23;
                    describeData = this.pendingDescribeStatementQueue.removeFirst();
                    currentQuery = describeData.query;
                    fields = currentQuery.getFields();
                    if (fields == null) continue block23;
                    tuples /* !! */  = new ArrayList<E>();
                    handler.handleResultRows(currentQuery, fields, tuples /* !! */ , null);
                    tuples /* !! */  = null;
                    continue block23;
                }
                case 115: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE PortalSuspended");
                    }
                    executeData = this.pendingExecuteQueue.removeFirst();
                    currentQuery = executeData.query;
                    currentPortal = executeData.portal;
                    fields = currentQuery.getFields();
                    if (fields != null && !noResults && tuples /* !! */  == null) {
                        tuples /* !! */  = new ArrayList<E>();
                    }
                    handler.handleResultRows(currentQuery, fields, tuples /* !! */ , currentPortal);
                    tuples /* !! */  = null;
                    continue block23;
                }
                case 67: {
                    status = this.receiveCommandStatus();
                    doneAfterRowDescNoData = false;
                    executeData = this.pendingExecuteQueue.removeFirst();
                    currentQuery = executeData.query;
                    currentPortal = executeData.portal;
                    fields = currentQuery.getFields();
                    if (fields != null && !noResults && tuples /* !! */  == null) {
                        tuples /* !! */  = new ArrayList<E>();
                    }
                    if (fields == null && tuples /* !! */  != null) {
                        throw new IllegalStateException("Received resultset tuples, but no field structure for them");
                    }
                    if (fields != null || tuples /* !! */  != null) {
                        handler.handleResultRows(currentQuery, fields, tuples /* !! */ , null);
                        tuples /* !! */  = null;
                        if (bothRowsAndStatus) {
                            this.interpretCommandStatus(status, handler);
                        }
                    } else {
                        this.interpretCommandStatus(status, handler);
                    }
                    if (currentPortal == null) continue block23;
                    currentPortal.close();
                    continue block23;
                }
                case 68: {
                    tuple = null;
                    try {
                        tuple = this.pgStream.ReceiveTupleV3();
                    }
                    catch (OutOfMemoryError oome) {
                        if (noResults) ** GOTO lbl116
                        handler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl116:
                    // 3 sources

                    if (!noResults) {
                        if (tuples /* !! */  == null) {
                            tuples /* !! */  = new ArrayList<E>();
                        }
                        tuples /* !! */ .add(tuple);
                    }
                    if (!this.logger.logDebug()) continue block23;
                    if (tuple == null) {
                        length = -1;
                    } else {
                        length = 0;
                        for (Object aTuple : (Portal)tuple) {
                            if (aTuple == null) continue;
                            length += ((Object)aTuple).length;
                        }
                    }
                    this.logger.debug(" <=BE DataRow(len=" + length + ")");
                    continue block23;
                }
                case 69: {
                    error = this.receiveErrorResponse();
                    handler.handleError(error);
                    continue block23;
                }
                case 73: {
                    this.pgStream.ReceiveInteger4();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE EmptyQuery");
                    }
                    executeData = this.pendingExecuteQueue.removeFirst();
                    currentQuery = executeData.query;
                    currentPortal = executeData.portal;
                    handler.handleCommandStatus("EMPTY", 0, 0L);
                    if (currentPortal == null) continue block23;
                    currentPortal.close();
                    continue block23;
                }
                case 78: {
                    warning = this.receiveNoticeResponse();
                    handler.handleWarning(warning);
                    continue block23;
                }
                case 83: {
                    l_len = this.pgStream.ReceiveInteger4();
                    name = this.pgStream.ReceiveString();
                    value = this.pgStream.ReceiveString();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("client_encoding") && !value.equalsIgnoreCase("UTF8") && !this.allowEncodingChanges) {
                        this.protoConnection.close();
                        handler.handleError(new PSQLException(GT.tr("The server''s client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UTF8 for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                        endQuery = true;
                    }
                    if (name.equals("DateStyle") && !value.startsWith("ISO,")) {
                        this.protoConnection.close();
                        handler.handleError(new PSQLException(GT.tr("The server''s DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                        endQuery = true;
                    }
                    if (!name.equals("standard_conforming_strings")) continue block23;
                    if (value.equals("on")) {
                        this.protoConnection.setStandardConformingStrings(true);
                        continue block23;
                    }
                    if (value.equals("off")) {
                        this.protoConnection.setStandardConformingStrings(false);
                        continue block23;
                    }
                    this.protoConnection.close();
                    handler.handleError(new PSQLException(GT.tr("The server''s standard_conforming_strings parameter was reported as {0}. The JDBC driver expected on or off.", value), PSQLState.CONNECTION_FAILURE));
                    endQuery = true;
                    continue block23;
                }
                case 84: {
                    fields = this.receiveFields();
                    tuples /* !! */  = new ArrayList<byte[][]>();
                    query = this.pendingDescribePortalQueue.removeFirst();
                    query.setFields(fields);
                    if (!doneAfterRowDescNoData) continue block23;
                    describeData = this.pendingDescribeStatementQueue.removeFirst();
                    currentQuery = describeData.query;
                    currentQuery.setFields(fields);
                    handler.handleResultRows(currentQuery, fields, tuples /* !! */ , null);
                    tuples /* !! */  = null;
                    continue block23;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    while (!this.pendingParseQueue.isEmpty()) {
                        failedQuery = this.pendingParseQueue.removeFirst();
                        failedQuery.unprepare();
                    }
                    this.pendingParseQueue.clear();
                    this.pendingDescribeStatementQueue.clear();
                    this.pendingDescribePortalQueue.clear();
                    this.pendingBindQueue.clear();
                    this.pendingExecuteQueue.clear();
                    continue block23;
                }
                case 71: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyInResponse");
                        this.logger.debug(" FE=> CopyFail");
                    }
                    buf = Utils.encodeUTF8("The JDBC driver currently does not support COPY operations.");
                    this.pgStream.SendChar(102);
                    this.pgStream.SendInteger4(buf.length + 4 + 1);
                    this.pgStream.Send(buf);
                    this.pgStream.SendChar(0);
                    this.pgStream.flush();
                    this.sendSync();
                    this.skipMessage();
                    continue block23;
                }
                case 72: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CopyOutResponse");
                    }
                    this.skipMessage();
                    handler.handleError(new PSQLException(GT.tr("The driver currently does not support COPY operations."), PSQLState.NOT_IMPLEMENTED));
                    continue block23;
                }
                case 99: {
                    this.skipMessage();
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE CopyDone");
                    continue block23;
                }
                case 100: {
                    this.skipMessage();
                    if (!this.logger.logDebug()) continue block23;
                    this.logger.debug(" <=BE CopyData");
                    continue block23;
                }
            }
            throw new IOException("Unexpected packet type: " + c);
        }
    }

    private void skipMessage() throws IOException {
        int l_len = this.pgStream.ReceiveInteger4();
        this.pgStream.Skip(l_len - 4);
    }

    public synchronized void fetch(ResultCursor cursor, ResultHandler handler, int fetchSize) throws SQLException {
        this.waitOnLock();
        final Portal portal = (Portal)cursor;
        final ResultHandler delegateHandler = handler;
        handler = new ResultHandler(){

            @Override
            public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
                delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
            }

            @Override
            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                this.handleResultRows(portal.getQuery(), null, new ArrayList<byte[][]>(), null);
            }

            @Override
            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            @Override
            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            @Override
            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
        try {
            this.processDeadParsedQueries();
            this.processDeadPortals();
            this.sendExecute(portal.getQuery(), portal, fetchSize);
            this.sendSync();
            this.processResults(handler, 0);
            this.estimatedReceiveBufferBytes = 0;
        }
        catch (IOException e2) {
            this.protoConnection.abort();
            handler.handleError(new PSQLException(GT.tr("An I/O error occurred while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e2));
        }
        handler.handleCompletion();
    }

    private Field[] receiveFields() throws IOException {
        int l_msgSize = this.pgStream.ReceiveInteger4();
        int size = this.pgStream.ReceiveInteger2();
        Field[] fields = new Field[size];
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE RowDescription(" + size + ")");
        }
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String columnLabel = this.pgStream.ReceiveString();
            int tableOid = this.pgStream.ReceiveInteger4();
            short positionInTable = (short)this.pgStream.ReceiveInteger2();
            int typeOid = this.pgStream.ReceiveInteger4();
            int typeLength = this.pgStream.ReceiveInteger2();
            int typeModifier = this.pgStream.ReceiveInteger4();
            int formatType = this.pgStream.ReceiveInteger2();
            fields[i2] = new Field(columnLabel, "", typeOid, typeLength, typeModifier, tableOid, positionInTable);
            fields[i2].setFormat(formatType);
            if (!this.logger.logDebug()) continue;
            this.logger.debug("        " + fields[i2]);
        }
        return fields;
    }

    private void receiveAsyncNotify() throws IOException {
        int msglen = this.pgStream.ReceiveInteger4();
        int pid = this.pgStream.ReceiveInteger4();
        String msg = this.pgStream.ReceiveString();
        String param = this.pgStream.ReceiveString();
        this.protoConnection.addNotification(new Notification(msg, pid, param));
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE AsyncNotify(" + pid + "," + msg + "," + param + ")");
        }
    }

    private SQLException receiveErrorResponse() throws IOException {
        int elen = this.pgStream.ReceiveInteger4();
        String totalMessage = this.pgStream.ReceiveString(elen - 4);
        ServerErrorMessage errorMsg = new ServerErrorMessage(totalMessage, this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ErrorMessage(" + errorMsg.toString() + ")");
        }
        return new PSQLException(errorMsg);
    }

    private SQLWarning receiveNoticeResponse() throws IOException {
        int nlen = this.pgStream.ReceiveInteger4();
        ServerErrorMessage warnMsg = new ServerErrorMessage(this.pgStream.ReceiveString(nlen - 4), this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE NoticeResponse(" + warnMsg.toString() + ")");
        }
        return new PSQLWarning(warnMsg);
    }

    private String receiveCommandStatus() throws IOException {
        int l_len = this.pgStream.ReceiveInteger4();
        String status = this.pgStream.ReceiveString(l_len - 5);
        this.pgStream.ReceiveChar();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE CommandStatus(" + status + ")");
        }
        return status;
    }

    private void interpretCommandStatus(String status, ResultHandler handler) {
        int update_count = 0;
        long insert_oid = 0L;
        if (status.startsWith("INSERT") || status.startsWith("UPDATE") || status.startsWith("DELETE") || status.startsWith("MOVE")) {
            try {
                long updates = Long.parseLong(status.substring(1 + status.lastIndexOf(32)));
                update_count = updates > Integer.MAX_VALUE ? -2 : (int)updates;
                if (status.startsWith("INSERT")) {
                    insert_oid = Long.parseLong(status.substring(1 + status.indexOf(32), status.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException nfe) {
                handler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        handler.handleCommandStatus(status, update_count, insert_oid);
    }

    private void receiveRFQ() throws IOException {
        if (this.pgStream.ReceiveInteger4() != 5) {
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char tStatus = (char)this.pgStream.ReceiveChar();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ReadyForQuery(" + tStatus + ")");
        }
        switch (tStatus) {
            case 'I': {
                this.protoConnection.setTransactionState(0);
                break;
            }
            case 'T': {
                this.protoConnection.setTransactionState(1);
                break;
            }
            case 'E': {
                this.protoConnection.setTransactionState(2);
                break;
            }
            default: {
                throw new IOException("unexpected transaction state in ReadyForQuery message: " + tStatus);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorTrackingResultHandler
    implements ResultHandler {
        private final ResultHandler delegateHandler;
        private boolean sawError = false;

        ErrorTrackingResultHandler(ResultHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
            this.delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.delegateHandler.handleCommandStatus(status, updateCount, insertOID);
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            this.delegateHandler.handleWarning(warning);
        }

        @Override
        public void handleError(SQLException error) {
            this.sawError = true;
            this.delegateHandler.handleError(error);
        }

        @Override
        public void handleCompletion() throws SQLException {
            this.delegateHandler.handleCompletion();
        }

        boolean hasErrors() {
            return this.sawError;
        }
    }
}

