// Mgmt
// Copyright (C) 2013-2024+ James Shubin and the project contributors
// Written by James Shubin <james@shubin.ca> and the project contributors
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.
//
// Additional permission under GNU GPL version 3 section 7
//
// If you modify this program, or any covered work, by linking or combining it
// with embedded mcl code and modules (and that the embedded mcl code and
// modules which link with this program, contain a copy of their source code in
// the authoritative form) containing parts covered by the terms of any other
// license, the licensors of this program grant you additional permission to
// convey the resulting work. Furthermore, the licensors of this program grant
// the original author, James Shubin, additional permission to update this
// additional permission if he deems it necessary to achieve the goals of this
// additional permission.

package coresys

import (
	"context"

	"github.com/purpleidea/mgmt/lang/funcs/facts"
	"github.com/purpleidea/mgmt/lang/types"
)

const (
	// HostnameFuncName is the name this fact is registered as. It's still a
	// Func Name because this is the name space the fact is actually using.
	HostnameFuncName = "hostname"
)

func init() {
	facts.ModuleRegister(ModuleName, HostnameFuncName, func() facts.Fact { return &HostnameFact{} }) // must register the fact and name
}

// HostnameFact is a function that returns the hostname.
// TODO: support hostnames that change in the future.
type HostnameFact struct {
	init *facts.Init
}

// String returns a simple name for this fact. This is needed so this struct can
// satisfy the pgraph.Vertex interface.
func (obj *HostnameFact) String() string {
	return HostnameFuncName
}

// Validate makes sure we've built our struct properly. It is usually unused for
// normal facts that users can use directly.
//func (obj *HostnameFact) Validate() error {
//	return nil
//}

// Info returns some static info about itself.
func (obj *HostnameFact) Info() *facts.Info {
	return &facts.Info{
		Output: types.NewType("str"),
	}
}

// Init runs some startup code for this fact.
func (obj *HostnameFact) Init(init *facts.Init) error {
	obj.init = init
	return nil
}

// Stream returns the single value that this fact has, and then closes.
func (obj *HostnameFact) Stream(ctx context.Context) error {
	select {
	case obj.init.Output <- &types.StrValue{
		V: obj.init.Hostname,
	}:
		// pass
	case <-ctx.Done():
		return nil
	}
	close(obj.init.Output) // signal that we're done sending
	return nil
}
