#!/usr/bin/env bash

cd "${BASH_SOURCE%/*}/.." &&
Utilities/GitSetup/setup-user && echo &&
Utilities/GitSetup/setup-hooks && echo &&
Utilities/GitSetup/setup-lfs && echo &&
(Utilities/GitSetup/setup-upstream ||
 echo 'Failed to setup origin.  Run this again to retry.') && echo &&
(Utilities/GitSetup/setup-gitlab ||
 echo 'Failed to setup GitLab.  Run this again to retry.') && echo &&
Utilities/GitSetup/tips


echo "Setting up useful Git aliases..." &&

# Rebase master by default
git config rebase.stat true
git config branch.master.rebase true

# General aliases that could be global
git config alias.pullall '!bash -c "git pull && git submodule update --init"' &&
git config alias.prepush 'log --graph --stat origin/master..' &&
git config alias.pull-master 'fetch origin master:master' &&

# Alias to push the current topic branch to GitLab
git config alias.gitlab-push '!bash Utilities/GitSetup/git-gitlab-push' &&
echo "Set up git gitlab-push" &&
git config alias.gitlab-sync '!bash Utilities/GitSetup/git-gitlab-sync' &&
echo "Set up git gitlab-sync" &&
true

SetupForDevelopment=1
git config hooks.SetupForDevelopment ${SetupForDevelopment_VERSION}

# Setup VTK-m-specifc LFS config
#
# Disable lfsurl if our origin points to the main repo
OriginURL=$(git remote get-url origin)
if [[ "$OriginURL" =~ ^(https://|git@)gitlab\.kitware\.com(/|:)vtk/vtk-m\.git$ ]]
then
  # Disable this setting which overrides every remote/url lfs setting
  git config --local lfs.url "${OriginURL}"

  # Those settings are only available for newer git-lfs releases
  git config --local remote.lfspushdefault gitlab
  git config --local remote.lfsdefault origin
fi
