#!/bin/bash

_glxExeStr="$(command -v glxinfo)";
_primeExeStr="$(command -v prime-select)";

if [ -x "${_glxExeStr}" ]; then
  _statusStr="$( 
    ${_glxExeStr} \
    | grep 'OpenGL renderer string' \
    | awk -F ': ' '{print $2}'
  )";
elif [ -x "${_primeExeStr}" ]; then
  _statusStr="$( "${_primeExeStr}" query | tr '[:lower:]' '[:upper:]' )"
  _statusStr="${_statusStr} GPU is in use.";
else
  _statusStr='Unknown GPU is in use';
fi

echo "${_statusStr}";

