/* $Cambridge: hermes/src/prayer/cmd/cmd_abook_take.c,v 1.4 2008/09/17 17:20:25 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

static void generate_form(struct session *session, struct assoc *h)
{
    struct template_vals *tvals = session->template_vals;
    struct abook *abook = session->options->abook;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;
    char *alias = assoc_lookup(h, "alias");

    /* Check for existing alias */
    if (alias && abook_lookup(abook, alias))
        session_message(session,
                        "Email address matches addressbook entry: \"%s\"",
                        alias);

    template_vals_string(tvals, "alias", alias);
    template_vals_string(tvals, "name", assoc_lookup(h, "name"));
    template_vals_string(tvals, "comment", assoc_lookup(h, "comment"));
    template_vals_string(tvals, "email", assoc_lookup(h, "email"));

    session_seed_template(session, tvals);
    template_expand("abook_take", tvals, b);
    response_html(request, 200);        /* Success */
}

void cmd_abook_take(struct session *session)
{
    struct request *request = session->request;
    struct options *options = session->options;
    struct assoc *h = NIL;

    if (request->method != POST) {
        if (request->get_suffix) {
            request_decode_form(request);
            h = request->form;
        }
        generate_form(session, h);
        return;
    }

    request_decode_form(request);
    h = request->form;

    if (assoc_lookup(h, "sub_cancel")) {
        session_redirect(session, request, session->take_parent_cmd);
        return;
    }

    if (assoc_lookup(h, "sub_add")) {
        char *alias = assoc_lookup(h, "alias");
        char *name = assoc_lookup(h, "name");
        char *fcc = pool_strdup(request->pool, "");     /* Not yet */
        char *comment = assoc_lookup(h, "comment");
        char *email = assoc_lookup(h, "email");

        if (alias)
            alias = string_trim_whitespace(alias);
        else
            alias = "";

        if (!alias[0]) {
            session_alert(session, "No alias provided");
            generate_form(session, h);
            return;
        }

        if (strchr(alias, ' ') || strchr(alias, '\t')) {
            session_alert(session, "Alias cannot contain spaces");
            generate_form(session, h);
            return;
        }

        if (!(name && comment && email)) {
            session_alert(session, "Missing form entries");
            generate_form(session, h);
            return;
        }

        name = string_trim_whitespace(name);
        fcc = string_trim_whitespace(fcc);
        comment = string_trim_whitespace(comment);
        email = string_trim_whitespace(email);

        if (email[0] == '\0') {
            session_alert(session, "No email address supplied");
            generate_form(session, h);
            return;
        }

        abook_replace(options->abook, alias, name, fcc, comment, email);

        if (!addr_check_valid(request->pool, email)) {
            session_alert(session, "%s", ml_errmsg());
            generate_form(session, h);
            return;
        }

        if (!abook_check_loop(request->pool, options->abook, alias, T)) {
            session_alert(session,
                          "Addressbook loop involving alias \"%s\"",
                          assoc_lookup(h, "alias"));
            generate_form(session, h);
            return;
        }

        session_message(session, "Updated address book entry: \"%s\"",
                        alias);
        session->options->save = T;
    }

    session_redirect(session, request, session->take_parent_cmd);
}
