require 'spec_helper'

describe 'collectd::plugin::hddtemp', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end

      options = os_specific_options(facts)
      context ':ensure => present' do
        let :params do
          {
            port: 6666,
            ensure: 'present'
          }
        end

        it { is_expected.to contain_collectd__plugin('hddtemp') }
        it { is_expected.to contain_file('old_hddtemp.load').with_ensure('absent') }
        it { is_expected.to contain_file('older_hddtemp.load').with_ensure('absent') }
        it 'Will create 10-hddtemp.conf' do
          is_expected.to contain_file('hddtemp.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-hddtemp.conf",
            content: "#\ Generated by Puppet\n<LoadPlugin hddtemp>\n  Globals false\n</LoadPlugin>\n\n<Plugin \"hddtemp\">\n  Host \"127.0.0.1\"\n  Port 6666\n</Plugin>\n\n"
          )
        end
      end

      context ':ensure => absent' do
        let :params do
          { ensure: 'absent' }
        end

        it 'Will not create 10-hddtemp.conf' do
          is_expected.to contain_file('hddtemp.load').with(
            ensure: 'absent',
            path: "#{options[:plugin_conf_dir]}/10-hddtemp.conf"
          )
        end
      end
    end
  end
end
