# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class BatchLoggingLevel(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Log verbosity for batch inferencing.
    Increasing verbosity order for logging is : Warning, Info and Debug.
    The default value is Info.
    """

    INFO = "Info"
    WARNING = "Warning"
    DEBUG = "Debug"

class BatchOutputAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine how batch inferencing will handle output
    """

    SUMMARY_ONLY = "SummaryOnly"
    APPEND_ROW = "AppendRow"

class ConnectionAuthType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Authentication type of the connection target
    """

    PAT = "PAT"
    MANAGED_IDENTITY = "ManagedIdentity"
    USERNAME_PASSWORD = "UsernamePassword"
    NONE = "None"
    SAS = "SAS"
    SERVICE_PRINCIPAL = "ServicePrincipal"
    ACCESS_KEY = "AccessKey"
    API_KEY = "ApiKey"
    CUSTOM_KEYS = "CustomKeys"

class ConnectionCategory(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Category of the connection
    """

    PYTHON_FEED = "PythonFeed"
    CONTAINER_REGISTRY = "ContainerRegistry"
    GIT = "Git"
    S3 = "S3"
    SNOWFLAKE = "Snowflake"
    AZURE_SQL_DB = "AzureSqlDb"
    AZURE_SYNAPSE_ANALYTICS = "AzureSynapseAnalytics"
    AZURE_MY_SQL_DB = "AzureMySqlDb"
    AZURE_POSTGRES_DB = "AzurePostgresDb"
    ADLS_GEN2 = "ADLSGen2"
    REDIS = "Redis"
    API_KEY = "ApiKey"
    AZURE_OPEN_AI = "AzureOpenAI"
    COGNITIVE_SEARCH = "CognitiveSearch"
    COGNITIVE_SERVICE = "CognitiveService"
    CUSTOM_KEYS = "CustomKeys"

class ContainerType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    STORAGE_INITIALIZER = "StorageInitializer"
    INFERENCE_SERVER = "InferenceServer"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class CredentialsType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the datastore credentials type.
    """

    ACCOUNT_KEY = "AccountKey"
    CERTIFICATE = "Certificate"
    NONE = "None"
    SAS = "Sas"
    SERVICE_PRINCIPAL = "ServicePrincipal"

class DatastoreType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the datastore contents type.
    """

    AZURE_BLOB = "AzureBlob"
    AZURE_DATA_LAKE_GEN1 = "AzureDataLakeGen1"
    AZURE_DATA_LAKE_GEN2 = "AzureDataLakeGen2"
    AZURE_FILE = "AzureFile"

class DataType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the type of data.
    """

    URI_FILE = "uri_file"
    URI_FOLDER = "uri_folder"
    MLTABLE = "mltable"

class DeploymentProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Possible values for DeploymentProvisioningState.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    SCALING = "Scaling"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class DiagnoseResultLevel(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    WARNING = "Warning"
    ERROR = "Error"
    INFORMATION = "Information"

class DistributionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the job distribution type.
    """

    PY_TORCH = "PyTorch"
    TENSOR_FLOW = "TensorFlow"
    MPI = "Mpi"

class EarlyTerminationPolicyType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    BANDIT = "Bandit"
    MEDIAN_STOPPING = "MedianStopping"
    TRUNCATION_SELECTION = "TruncationSelection"

class EncryptionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EndpointAuthMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine endpoint authentication mode.
    """

    AML_TOKEN = "AMLToken"
    KEY = "Key"
    AAD_TOKEN = "AADToken"

class EndpointComputeType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine endpoint compute type.
    """

    MANAGED = "Managed"
    KUBERNETES = "Kubernetes"
    AZURE_ML_COMPUTE = "AzureMLCompute"

class EndpointProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """State of endpoint provisioning.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    CANCELED = "Canceled"

class EndpointServiceConnectionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Connection status of the service consumer with the service provider
    Possible state transitions
    Pending -> Approved (Service provider approves the connection request)
    Pending -> Rejected (Service provider rejects the connection request)
    Pending -> Disconnected (Service provider deletes the connection)
    Approved -> Rejected (Service provider rejects the approved connection)
    Approved -> Disconnected (Service provider deletes the connection)
    Rejected -> Pending (Service consumer re-initiates the connection request that was rejected)
    Rejected -> Disconnected (Service provider deletes the connection)
    """

    APPROVED = "Approved"
    PENDING = "Pending"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class EnvironmentType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Environment type is either user created or curated by Azure ML service
    """

    CURATED = "Curated"
    USER_CREATED = "UserCreated"

class Goal(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines supported metric goals for hyperparameter tuning
    """

    MINIMIZE = "Minimize"
    MAXIMIZE = "Maximize"

class IdentityConfigurationType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine identity framework.
    """

    MANAGED = "Managed"
    AML_TOKEN = "AMLToken"
    USER_IDENTITY = "UserIdentity"

class InputDeliveryMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the input data delivery mode.
    """

    READ_ONLY_MOUNT = "ReadOnlyMount"
    READ_WRITE_MOUNT = "ReadWriteMount"
    DOWNLOAD = "Download"
    DIRECT = "Direct"
    EVAL_MOUNT = "EvalMount"
    EVAL_DOWNLOAD = "EvalDownload"

class JobInputType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the Job Input Type.
    """

    LITERAL = "literal"
    URI_FILE = "uri_file"
    URI_FOLDER = "uri_folder"
    MLTABLE = "mltable"
    CUSTOM_MODEL = "custom_model"
    MLFLOW_MODEL = "mlflow_model"
    TRITON_MODEL = "triton_model"

class JobLimitsType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    COMMAND = "Command"
    SWEEP = "Sweep"

class JobOutputType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the Job Output Type.
    """

    URI_FILE = "uri_file"
    URI_FOLDER = "uri_folder"
    MLTABLE = "mltable"
    CUSTOM_MODEL = "custom_model"
    MLFLOW_MODEL = "mlflow_model"
    TRITON_MODEL = "triton_model"

class JobStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The status of a job.
    """

    #: Run hasn't started yet.
    NOT_STARTED = "NotStarted"
    #: Run has started. The user has a run ID.
    STARTING = "Starting"
    #: (Not used currently) It will be used if ES is creating the compute target.
    PROVISIONING = "Provisioning"
    #: The run environment is being prepared.
    PREPARING = "Preparing"
    #: The job is queued in the compute target. For example, in BatchAI the job is in queued state,
    #: while waiting for all required nodes to be ready.
    QUEUED = "Queued"
    #: The job started to run in the compute target.
    RUNNING = "Running"
    #: Job is completed in the target. It is in output collection state now.
    FINALIZING = "Finalizing"
    #: Cancellation has been requested for the job.
    CANCEL_REQUESTED = "CancelRequested"
    #: Job completed successfully. This reflects that both the job itself and output collection states
    #: completed successfully.
    COMPLETED = "Completed"
    #: Job failed.
    FAILED = "Failed"
    #: Following cancellation request, the job is now successfully canceled.
    CANCELED = "Canceled"
    #: When heartbeat is enabled, if the run isn't updating any information to RunHistory then the run
    #: goes to NotResponding state.
    #: NotResponding is the only state that is exempt from strict transition orders. A run can go from
    #: NotResponding to any of the previous states.
    NOT_RESPONDING = "NotResponding"
    #: The job is paused by users. Some adjustment to labeling jobs can be made only in paused state.
    PAUSED = "Paused"
    #: Default job status if not mapped to all other statuses.
    UNKNOWN = "Unknown"

class JobType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the type of job.
    """

    COMMAND = "Command"
    SWEEP = "Sweep"
    PIPELINE = "Pipeline"

class KeyType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    PRIMARY = "Primary"
    SECONDARY = "Secondary"

class ListViewType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ACTIVE_ONLY = "ActiveOnly"
    ARCHIVED_ONLY = "ArchivedOnly"
    ALL = "All"

class ManagedNetworkStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    INACTIVE = "Inactive"
    ACTIVE = "Active"

class ManagedServiceIdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"

class OperatingSystemType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of operating system.
    """

    LINUX = "Linux"
    WINDOWS = "Windows"

class OrderString(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    CREATED_AT_DESC = "CreatedAtDesc"
    CREATED_AT_ASC = "CreatedAtAsc"
    UPDATED_AT_DESC = "UpdatedAtDesc"
    UPDATED_AT_ASC = "UpdatedAtAsc"

class OutputDeliveryMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Output data delivery mode enums.
    """

    READ_WRITE_MOUNT = "ReadWriteMount"
    UPLOAD = "Upload"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    UNKNOWN = "Unknown"
    UPDATING = "Updating"
    CREATING = "Creating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class PublicNetworkAccessType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class RandomSamplingAlgorithmRule(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The specific type of random algorithm
    """

    RANDOM = "Random"
    SOBOL = "Sobol"

class ReferenceType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine which reference method to use for an asset.
    """

    ID = "Id"
    DATA_PATH = "DataPath"
    OUTPUT_PATH = "OutputPath"

class RuleAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ALLOW = "Allow"
    DENY = "Deny"

class RuleCategory(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    REQUIRED = "Required"
    RECOMMENDED = "Recommended"
    USER_DEFINED = "UserDefined"

class RuleStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    INACTIVE = "Inactive"
    ACTIVE = "Active"

class RuleType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    FQDN = "FQDN"
    PRIVATE_ENDPOINT = "PrivateEndpoint"
    SERVICE_TAG = "ServiceTag"

class SamplingAlgorithmType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    GRID = "Grid"
    RANDOM = "Random"
    BAYESIAN = "Bayesian"

class ScaleType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "Default"
    TARGET_UTILIZATION = "TargetUtilization"

class SecretsType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum to determine the datastore secrets type.
    """

    ACCOUNT_KEY = "AccountKey"
    CERTIFICATE = "Certificate"
    SAS = "Sas"
    SERVICE_PRINCIPAL = "ServicePrincipal"

class ServiceDataAccessAuthIdentity(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    #: Do not use any identity for service data access.
    NONE = "None"
    #: Use the system assigned managed identity of the Workspace to authenticate service data access.
    WORKSPACE_SYSTEM_ASSIGNED_IDENTITY = "WorkspaceSystemAssignedIdentity"
    #: Use the user assigned managed identity of the Workspace to authenticate service data access.
    WORKSPACE_USER_ASSIGNED_IDENTITY = "WorkspaceUserAssignedIdentity"

class SkuScaleType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """TODO - SKU scale type
    """

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
    NONE = "None"

class SkuTier(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
