# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AuthorizationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines the authorization status of requests."""

    AUTHORIZED = "Authorized"
    """Requests authorized successfully"""
    NOT_FOUND = "NotFound"
    """Requests returned NotFound response"""
    ERROR = "Error"
    """Requests returned other error response"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DockerfileGenerationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode of generation to be used for generating Dockerfiles."""

    ENABLED = "enabled"
    """Dockerfiles will be generated"""
    DISABLED = "disabled"
    """Dockerfiles will not be generated"""


class GenerationLanguage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The programming language used."""

    CLOJURE = "clojure"
    """clojure language"""
    CSHARP = "csharp"
    """csharp language"""
    ERLANG = "erlang"
    """erlang language"""
    GO = "go"
    """go language"""
    GOMODULE = "gomodule"
    """gomodule language"""
    GRADLE = "gradle"
    """gradle language"""
    JAVA = "java"
    """java language"""
    JAVASCRIPT = "javascript"
    """javascript language"""
    PHP = "php"
    """php language"""
    PYTHON = "python"
    """python language"""
    RUBY = "ruby"
    """ruby language"""
    RUST = "rust"
    """rust language"""
    SWIFT = "swift"
    """swift language"""


class GenerationManifestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines the type of manifests to be generated."""

    HELM = "helm"
    """Helm manifests"""
    KUBE = "kube"
    """Kubernetes manifests"""


class ManifestGenerationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode of generation to be used for generating Manifest."""

    ENABLED = "enabled"
    """Manifests will be generated"""
    DISABLED = "disabled"
    """Manifests will not be generated"""


class ManifestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines the type of manifests within the repository."""

    HELM = "helm"
    """Repositories using helm"""
    KUBE = "kube"
    """Repositories using kubernetes manifests"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PullRequestStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the Pull Request submitted against the users repository."""

    UNKNOWN = "unknown"
    """Pull Request state unknown."""
    SUBMITTED = "submitted"
    """Pull Request submitted to repository."""
    MERGED = "merged"
    """Pull Request merged into repository."""
    REMOVED = "removed"
    """Workflow no longer found within repository."""


class WorkflowRunStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the status of the workflow run."""

    QUEUED = "queued"
    """Workflow run is queued"""
    INPROGRESS = "inprogress"
    """Workflow run is inprogress"""
    COMPLETED = "completed"
    """Workflow run is completed"""
