# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AvailableOperations(_serialization.Model):
    """Available operations of the service.

    :ivar value: Collection of available operation details.
    :vartype value: list[~azure.mgmt.healthbot.models.OperationDetail]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDetail]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationDetail"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Collection of available operation details.
        :paramtype value: list[~azure.mgmt.healthbot.models.OperationDetail]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BotResponseList(_serialization.Model):
    """The list of Azure Health Bot operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of bot service resources.
    :vartype next_link: str
    :ivar value: Gets the list of Azure Health Bot results and their properties.
    :vartype value: list[~azure.mgmt.healthbot.models.HealthBot]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[HealthBot]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class Error(_serialization.Model):
    """The resource management error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.healthbot.models.ErrorError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorError"},
    }

    def __init__(self, *, error: Optional["_models.ErrorError"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.healthbot.models.ErrorError
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorError(_serialization.Model):
    """The error object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.healthbot.models.Error]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.healthbot.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Resource(_serialization.Model):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthbot.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthbot.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class HealthBot(TrackedResource):
    """Azure Health Bot resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthbot.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: SKU of the Azure Health Bot. Required.
    :vartype sku: ~azure.mgmt.healthbot.models.Sku
    :ivar identity: The identity of the Azure Health Bot.
    :vartype identity: ~azure.mgmt.healthbot.models.Identity
    :ivar properties: The set of properties specific to Azure Health Bot resource.
    :vartype properties: ~azure.mgmt.healthbot.models.HealthBotProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "properties": {"key": "properties", "type": "HealthBotProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        properties: Optional["_models.HealthBotProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: SKU of the Azure Health Bot. Required.
        :paramtype sku: ~azure.mgmt.healthbot.models.Sku
        :keyword identity: The identity of the Azure Health Bot.
        :paramtype identity: ~azure.mgmt.healthbot.models.Identity
        :keyword properties: The set of properties specific to Azure Health Bot resource.
        :paramtype properties: ~azure.mgmt.healthbot.models.HealthBotProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.identity = identity
        self.properties = properties


class HealthBotKey(_serialization.Model):
    """An entry of HealthBotKeysResponse.

    :ivar key_name: The name of the key.
    :vartype key_name: str
    :ivar value: The value of the key.
    :vartype value: str
    """

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key_name: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword key_name: The name of the key.
        :paramtype key_name: str
        :keyword value: The value of the key.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.value = value


class HealthBotKeysResponse(_serialization.Model):
    """Health Bot Keys Response.

    :ivar secrets: Array of Azure Health Bot Secrets.
    :vartype secrets: list[~azure.mgmt.healthbot.models.HealthBotKey]
    """

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[HealthBotKey]"},
    }

    def __init__(self, *, secrets: Optional[List["_models.HealthBotKey"]] = None, **kwargs):
        """
        :keyword secrets: Array of Azure Health Bot Secrets.
        :paramtype secrets: list[~azure.mgmt.healthbot.models.HealthBotKey]
        """
        super().__init__(**kwargs)
        self.secrets = secrets


class HealthBotProperties(_serialization.Model):
    """The properties of a Azure Health Bot. The Health Bot Service is a cloud platform that empowers developers in Healthcare organizations to build and deploy their compliant, AI-powered virtual health assistants and health bots, that help them improve processes and reduce costs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state of the Azure Health Bot resource.
    :vartype provisioning_state: str
    :ivar bot_management_portal_link: The link.
    :vartype bot_management_portal_link: str
    :ivar key_vault_properties: KeyVault properties for the resource encryption.
    :vartype key_vault_properties: ~azure.mgmt.healthbot.models.KeyVaultProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "bot_management_portal_link": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "bot_management_portal_link": {"key": "botManagementPortalLink", "type": "str"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "KeyVaultProperties"},
    }

    def __init__(self, *, key_vault_properties: Optional["_models.KeyVaultProperties"] = None, **kwargs):
        """
        :keyword key_vault_properties: KeyVault properties for the resource encryption.
        :paramtype key_vault_properties: ~azure.mgmt.healthbot.models.KeyVaultProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.bot_management_portal_link = None
        self.key_vault_properties = key_vault_properties


class HealthBotUpdateParameters(_serialization.Model):
    """Parameters for updating a Azure Health Bot.

    :ivar properties: Properties of Azure Health Bot.
    :vartype properties: ~azure.mgmt.healthbot.models.HealthBotProperties
    :ivar tags: Tags for a Azure Health Bot.
    :vartype tags: dict[str, str]
    :ivar sku: SKU of the Azure Health Bot.
    :vartype sku: ~azure.mgmt.healthbot.models.Sku
    :ivar identity: The identity of the Azure Health Bot.
    :vartype identity: ~azure.mgmt.healthbot.models.Identity
    :ivar location:
    :vartype location: str
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "HealthBotProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.HealthBotProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Azure Health Bot.
        :paramtype properties: ~azure.mgmt.healthbot.models.HealthBotProperties
        :keyword tags: Tags for a Azure Health Bot.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU of the Azure Health Bot.
        :paramtype sku: ~azure.mgmt.healthbot.models.Sku
        :keyword identity: The identity of the Azure Health Bot.
        :paramtype identity: ~azure.mgmt.healthbot.models.Identity
        :keyword location:
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags
        self.sku = sku
        self.identity = identity
        self.location = location


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity. This property will only be provided
     for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource. This property will only be provided for a system
     assigned identity.
    :vartype tenant_id: str
    :ivar type: The identity type. The type 'SystemAssigned, UserAssigned' includes both an
     implicitly created identity and a set of user assigned identities. The type 'None' will remove
     any identities from the Azure Health Bot. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.healthbot.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.healthbot.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. The type 'SystemAssigned, UserAssigned' includes both an
         implicitly created identity and a set of user assigned identities. The type 'None' will remove
         any identities from the Azure Health Bot. Known values are: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.healthbot.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.healthbot.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class KeyVaultProperties(_serialization.Model):
    """Properties of the key vault.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: The name of the key vault key. Required.
    :vartype key_name: str
    :ivar key_version: The version of the key vault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of the key vault. Required.
    :vartype key_vault_uri: str
    :ivar user_identity: The user assigned identity (ARM resource id) that has access to the key.
    :vartype user_identity: str
    """

    _validation = {
        "key_name": {"required": True},
        "key_vault_uri": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "user_identity": {"key": "userIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_name: str,
        key_vault_uri: str,
        key_version: Optional[str] = None,
        user_identity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: The name of the key vault key. Required.
        :paramtype key_name: str
        :keyword key_version: The version of the key vault key.
        :paramtype key_version: str
        :keyword key_vault_uri: The Uri of the key vault. Required.
        :paramtype key_vault_uri: str
        :keyword user_identity: The user assigned identity (ARM resource id) that has access to the
         key.
        :paramtype user_identity: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri
        self.user_identity = user_identity


class OperationDetail(_serialization.Model):
    """Operation detail payload.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.healthbot.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Additional properties.
    :vartype properties: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~azure.mgmt.healthbot.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Additional properties.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """Operation display payload.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Resource provider of the operation.
        :paramtype provider: str
        :keyword resource: Resource of the operation.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation.
        :paramtype operation: str
        :keyword description: Localized friendly description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Sku(_serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the Azure Health Bot SKU. Required. Known values are: "F0", "S1", and
     "C0".
    :vartype name: str or ~azure.mgmt.healthbot.models.SkuName
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.SkuName"], **kwargs):
        """
        :keyword name: The name of the Azure Health Bot SKU. Required. Known values are: "F0", "S1",
         and "C0".
        :paramtype name: str or ~azure.mgmt.healthbot.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name


class SystemData(_serialization.Model):
    """Read only system data.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.healthbot.models.IdentityType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.healthbot.models.IdentityType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.healthbot.models.IdentityType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.healthbot.models.IdentityType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """The details of the user assigned managed identity used by the Video Analyzer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ValidationResult(_serialization.Model):
    """The response returned from validation process.

    :ivar status: The status code of the response validation.
    :vartype status: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, **kwargs):
        """
        :keyword status: The status code of the response validation.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.status = status
