# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgentVMSizeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created.
    This list is non exhaustive; refer to
    https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM
    sizes.
    """

    STANDARD_A0 = "Standard_A0"
    STANDARD_A1 = "Standard_A1"
    STANDARD_A2 = "Standard_A2"
    STANDARD_A3 = "Standard_A3"
    STANDARD_A4 = "Standard_A4"
    STANDARD_A5 = "Standard_A5"
    STANDARD_A6 = "Standard_A6"
    STANDARD_A7 = "Standard_A7"
    STANDARD_A8 = "Standard_A8"
    STANDARD_A9 = "Standard_A9"
    STANDARD_A10 = "Standard_A10"
    STANDARD_A11 = "Standard_A11"
    STANDARD_D1 = "Standard_D1"
    STANDARD_D2 = "Standard_D2"
    STANDARD_D3 = "Standard_D3"
    STANDARD_D4 = "Standard_D4"
    STANDARD_D11 = "Standard_D11"
    STANDARD_D12 = "Standard_D12"
    STANDARD_D13 = "Standard_D13"
    STANDARD_D14 = "Standard_D14"
    STANDARD_D1_V2 = "Standard_D1_v2"
    STANDARD_D2_V2 = "Standard_D2_v2"
    STANDARD_D3_V2 = "Standard_D3_v2"
    STANDARD_D4_V2 = "Standard_D4_v2"
    STANDARD_D5_V2 = "Standard_D5_v2"
    STANDARD_D11_V2 = "Standard_D11_v2"
    STANDARD_D12_V2 = "Standard_D12_v2"
    STANDARD_D13_V2 = "Standard_D13_v2"
    STANDARD_D14_V2 = "Standard_D14_v2"
    STANDARD_G1 = "Standard_G1"
    STANDARD_G2 = "Standard_G2"
    STANDARD_G3 = "Standard_G3"
    STANDARD_G4 = "Standard_G4"
    STANDARD_G5 = "Standard_G5"
    STANDARD_DS1 = "Standard_DS1"
    STANDARD_DS2 = "Standard_DS2"
    STANDARD_DS3 = "Standard_DS3"
    STANDARD_DS4 = "Standard_DS4"
    STANDARD_DS11 = "Standard_DS11"
    STANDARD_DS12 = "Standard_DS12"
    STANDARD_DS13 = "Standard_DS13"
    STANDARD_DS14 = "Standard_DS14"
    STANDARD_GS1 = "Standard_GS1"
    STANDARD_GS2 = "Standard_GS2"
    STANDARD_GS3 = "Standard_GS3"
    STANDARD_GS4 = "Standard_GS4"
    STANDARD_GS5 = "Standard_GS5"


class ClusterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The cluster type."""

    ACS = "ACS"
    LOCAL = "Local"


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provision state of the cluster. Valid values are Unknown, Updating, Provisioning,
    Succeeded, and Failed.
    """

    UNKNOWN = "Unknown"
    UPDATING = "Updating"
    CREATING = "Creating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class OrchestratorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of orchestrator. It cannot be changed once the cluster is created."""

    KUBERNETES = "Kubernetes"
    NONE = "None"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SSL status. Allowed values are Enabled and Disabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SystemServiceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The system service type."""

    NONE = "None"
    SCORING_FRONT_END = "ScoringFrontEnd"
    BATCH_FRONT_END = "BatchFrontEnd"


class UpdatesAvailable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Yes if updates are available for the system services, No if not."""

    YES = "Yes"
    NO = "No"
