# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._recovery_services_data_replication_mgmt_client_operations import (
    build_check_name_availability_request,
    build_deployment_preflight_request,
)
from .._vendor import RecoveryServicesDataReplicationMgmtClientMixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class RecoveryServicesDataReplicationMgmtClientOperationsMixin(RecoveryServicesDataReplicationMgmtClientMixinABC):
    @overload
    async def check_name_availability(
        self,
        location: str,
        body: Optional[_models.CheckNameAvailabilityModel] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CheckNameAvailabilityResponseModel:
        """Performs the resource name availability check.

        Checks the resource name availability.

        :param location: The name of the Azure region. Required.
        :type location: str
        :param body: Resource details. Default value is None.
        :type body: ~azure.mgmt.recoveryservicesdatareplication.models.CheckNameAvailabilityModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckNameAvailabilityResponseModel or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicesdatareplication.models.CheckNameAvailabilityResponseModel
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_name_availability(
        self, location: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckNameAvailabilityResponseModel:
        """Performs the resource name availability check.

        Checks the resource name availability.

        :param location: The name of the Azure region. Required.
        :type location: str
        :param body: Resource details. Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckNameAvailabilityResponseModel or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicesdatareplication.models.CheckNameAvailabilityResponseModel
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_name_availability(
        self, location: str, body: Optional[Union[_models.CheckNameAvailabilityModel, IO]] = None, **kwargs: Any
    ) -> _models.CheckNameAvailabilityResponseModel:
        """Performs the resource name availability check.

        Checks the resource name availability.

        :param location: The name of the Azure region. Required.
        :type location: str
        :param body: Resource details. Is either a CheckNameAvailabilityModel type or a IO type.
         Default value is None.
        :type body: ~azure.mgmt.recoveryservicesdatareplication.models.CheckNameAvailabilityModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckNameAvailabilityResponseModel or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicesdatareplication.models.CheckNameAvailabilityResponseModel
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CheckNameAvailabilityResponseModel] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CheckNameAvailabilityModel")
            else:
                _json = None

        request = build_check_name_availability_request(
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_name_availability.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CheckNameAvailabilityResponseModel", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_name_availability.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.DataReplication/locations/{location}/checkNameAvailability"
    }

    @overload
    async def deployment_preflight(
        self,
        resource_group_name: str,
        deployment_id: str,
        body: Optional[_models.DeploymentPreflightModel] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DeploymentPreflightModel:
        """Performs resource deployment validation.

        Performs resource deployment validation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_id: Deployment Id. Required.
        :type deployment_id: str
        :param body: Deployment preflight model. Default value is None.
        :type body: ~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentPreflightModel or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightModel
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def deployment_preflight(
        self,
        resource_group_name: str,
        deployment_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DeploymentPreflightModel:
        """Performs resource deployment validation.

        Performs resource deployment validation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_id: Deployment Id. Required.
        :type deployment_id: str
        :param body: Deployment preflight model. Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentPreflightModel or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightModel
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def deployment_preflight(
        self,
        resource_group_name: str,
        deployment_id: str,
        body: Optional[Union[_models.DeploymentPreflightModel, IO]] = None,
        **kwargs: Any
    ) -> _models.DeploymentPreflightModel:
        """Performs resource deployment validation.

        Performs resource deployment validation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_id: Deployment Id. Required.
        :type deployment_id: str
        :param body: Deployment preflight model. Is either a DeploymentPreflightModel type or a IO
         type. Default value is None.
        :type body: ~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentPreflightModel or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicesdatareplication.models.DeploymentPreflightModel
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeploymentPreflightModel] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "DeploymentPreflightModel")
            else:
                _json = None

        request = build_deployment_preflight_request(
            resource_group_name=resource_group_name,
            deployment_id=deployment_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.deployment_preflight.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentPreflightModel", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    deployment_preflight.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/deployments/{deploymentId}/preflight"
    }
