# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementSignUpSettingsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sign_up_settings_get_entity_tag(self, resource_group):
        response = self.client.sign_up_settings.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sign_up_settings_get(self, resource_group):
        response = self.client.sign_up_settings.get(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sign_up_settings_update(self, resource_group):
        response = self.client.sign_up_settings.update(
            resource_group_name=resource_group.name,
            service_name="str",
            if_match="str",
            parameters={
                "enabled": bool,
                "id": "str",
                "name": "str",
                "termsOfService": {"consentRequired": bool, "enabled": bool, "text": "str"},
                "type": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sign_up_settings_create_or_update(self, resource_group):
        response = self.client.sign_up_settings.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            parameters={
                "enabled": bool,
                "id": "str",
                "name": "str",
                "termsOfService": {"consentRequired": bool, "enabled": bool, "text": "str"},
                "type": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
