---
page_type: sample
languages:
- python
products:
- azure
- azure-iot
name: Azure.IoT.DeviceUpdate samples for Python
description: Samples for the azure-iot-deviceupdate client library
---

# Device Update for IoT Hub client SDK samples

These are code samples that show common scenario operations with the Device Update for IoT Hub client library.

## Prerequisites

* Python 3.6 or later is required to use this package
* You need an [Azure subscription][https://azure.microsoft.com/free/], and a [Device Update for IoT Hub][https://learn.microsoft.com/azure/iot-hub-device-update/understand-device-update] 
account and instance to use this package.

## Setup

1. Install the Device Update for IoT Hub client library for Python with [pip](https://pypi.org/project/pip/):

```bash
pip install azure-iot-deviceupdate
```

2. Clone or download this sample repository
3. Open the sample folder in Visual Studio Code or your IDE of choice.

## Running the samples

1. Open a terminal window and `cd` to the directory that the samples are saved in.
2. Set the environment variables specified in the sample file you wish to run.
3. Follow the usage described in the file, e.g. `python sample_list_updates.py`

## Samples

 - [Enumerate updates](https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/deviceupdate/azure-iot-deviceupdate/samples/ListUpdates/Readme.md)
 - [Get device update metadata and device update files metadata](https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/deviceupdate/azure-iot-deviceupdate/samples/GetUpdate/Readme.md)
 - [Import update](https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/deviceupdate/azure-iot-deviceupdate/samples/ImportUpdate/Readme.md)
 - [Delete update](https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/deviceupdate/azure-iot-deviceupdate/samples/DeleteUpdate/Readme.md)
 - [Get device information](https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/deviceupdate/azure-iot-deviceupdate/samples/GetDevice/Readme.md)
 - [Deploy update](https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/deviceupdate/azure-iot-deviceupdate/samples/DeployUpdate/Readme.md)
