# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementPrivateEndpointConnectionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connections_get(self, resource_group):
        response = self.client.private_endpoint_connections.get(
            resource_group_name=resource_group.name,
            parent_type="str",
            parent_name="str",
            private_endpoint_connection_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connections_begin_update(self, resource_group):
        response = self.client.private_endpoint_connections.begin_update(
            resource_group_name=resource_group.name,
            parent_type="str",
            parent_name="str",
            private_endpoint_connection_name="str",
            private_endpoint_connection={
                "groupIds": ["str"],
                "id": "str",
                "name": "str",
                "privateEndpoint": {"id": "str"},
                "privateLinkServiceConnectionState": {"actionsRequired": "str", "description": "str", "status": "str"},
                "provisioningState": "str",
                "type": "str",
            },
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connections_begin_delete(self, resource_group):
        response = self.client.private_endpoint_connections.begin_delete(
            resource_group_name=resource_group.name,
            parent_type="str",
            parent_name="str",
            private_endpoint_connection_name="str",
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connections_list_by_resource(self, resource_group):
        response = self.client.private_endpoint_connections.list_by_resource(
            resource_group_name=resource_group.name,
            parent_type="str",
            parent_name="str",
            api_version="2025-02-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
