# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AadConnectivityStateEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The connectivity state of the external AAD solution."""

    DISCOVERED = "Discovered"
    NOT_LICENSED = "NotLicensed"
    CONNECTED = "Connected"


class AdaptiveApplicationControlIssue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An alert that machines within a group can have."""

    VIOLATIONS_AUDITED = "ViolationsAudited"
    VIOLATIONS_BLOCKED = "ViolationsBlocked"
    MSI_AND_SCRIPT_VIOLATIONS_AUDITED = "MsiAndScriptViolationsAudited"
    MSI_AND_SCRIPT_VIOLATIONS_BLOCKED = "MsiAndScriptViolationsBlocked"
    EXECUTABLE_VIOLATIONS_AUDITED = "ExecutableViolationsAudited"
    RULES_VIOLATED_MANUALLY = "RulesViolatedManually"


class AssessmentStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Programmatic code for the status of the assessment."""

    HEALTHY = "Healthy"
    """The resource is healthy"""
    UNHEALTHY = "Unhealthy"
    """The resource has a security issue that needs to be addressed"""
    NOT_APPLICABLE = "NotApplicable"
    """Assessment for this resource did not happen"""


class AssessmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment
    based on custom Azure Policy definition.
    """

    BUILT_IN = "BuiltIn"
    """Microsoft Defender for Cloud managed assessments"""
    CUSTOM_POLICY = "CustomPolicy"
    """User defined policies that are automatically ingested from Azure Policy to Microsoft Defender
    for Cloud"""
    CUSTOMER_MANAGED = "CustomerManaged"
    """User assessments pushed directly by the user or other third party to Microsoft Defender for
    Cloud"""
    VERIFIED_PARTNER = "VerifiedPartner"
    """An assessment that was created by a verified 3rd party if the user connected it to ASC"""


class Categories(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The categories of resource that is at risk when the assessment is unhealthy."""

    COMPUTE = "Compute"
    NETWORKING = "Networking"
    DATA = "Data"
    IDENTITY_AND_ACCESS = "IdentityAndAccess"
    IO_T = "IoT"


class ConfigurationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The configuration status of the machines group or machine or rule."""

    CONFIGURED = "Configured"
    NOT_CONFIGURED = "NotConfigured"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    NO_STATUS = "NoStatus"


class ConnectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ConnectionType."""

    INTERNAL = "Internal"
    EXTERNAL = "External"


class ControlType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of security control (for example, BuiltIn)."""

    BUILT_IN = "BuiltIn"
    """Microsoft Defender for Cloud managed assessments"""
    CUSTOM = "Custom"
    """Non Microsoft Defender for Cloud managed assessments"""


class Direction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule's direction."""

    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class EnforcementMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The application control policy enforcement/protection mode of the machine group."""

    AUDIT = "Audit"
    ENFORCE = "Enforce"
    NONE = "None"


class EnforcementSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The machine supportability of Enforce feature."""

    SUPPORTED = "Supported"
    NOT_SUPPORTED = "NotSupported"
    UNKNOWN = "Unknown"


class ExpandControlsEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandControlsEnum."""

    DEFINITION = "definition"
    """Add definition object for each control"""


class ExpandEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandEnum."""

    LINKS = "links"
    """All links associated with an assessment"""
    METADATA = "metadata"
    """Assessment metadata"""


class ExternalSecuritySolutionKindEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the external solution."""

    CEF = "CEF"
    ATA = "ATA"
    AAD = "AAD"


class FileType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the file (for Linux files - Executable is used)."""

    EXE = "Exe"
    DLL = "Dll"
    MSI = "Msi"
    SCRIPT = "Script"
    EXECUTABLE = "Executable"
    UNKNOWN = "Unknown"


class ImplementationEffort(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The implementation effort required to remediate this assessment."""

    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"


class ProtocolEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ProtocolEnum."""

    TCP = "TCP"
    UDP = "UDP"
    ALL = "*"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The security family provisioning State."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"


class RecommendationAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recommendation action of the machine or rule."""

    RECOMMENDED = "Recommended"
    ADD = "Add"
    REMOVE = "Remove"


class RecommendationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The initial recommendation status of the machine group or machine."""

    RECOMMENDED = "Recommended"
    NOT_RECOMMENDED = "NotRecommended"
    NOT_AVAILABLE = "NotAvailable"
    NO_STATUS = "NoStatus"


class RecommendationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the rule to be allowed."""

    FILE = "File"
    FILE_HASH = "FileHash"
    PUBLISHER_SIGNATURE = "PublisherSignature"
    PRODUCT_SIGNATURE = "ProductSignature"
    BINARY_SIGNATURE = "BinarySignature"
    VERSION_AND_ABOVE_SIGNATURE = "VersionAndAboveSignature"


class SecurityFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The security family of the discovered solution."""

    WAF = "Waf"
    NGFW = "Ngfw"
    SAAS_WAF = "SaasWaf"
    VA = "Va"


class ServerVulnerabilityAssessmentPropertiesProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioningState of the vulnerability assessment capability on the VM."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    DEPROVISIONING = "Deprovisioning"


class Severity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity level of the assessment."""

    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class Source(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The platform where the assessed resource resides."""

    AZURE = "Azure"
    """Resource is in Azure"""
    ON_PREMISE = "OnPremise"
    """Resource in an on premise machine connected to Azure cloud"""
    ON_PREMISE_SQL = "OnPremiseSql"
    """SQL Resource in an on premise machine connected to Azure cloud"""


class SourceSystem(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The source type of the machine group."""

    AZURE_APP_LOCKER = "Azure_AppLocker"
    AZURE_AUDIT_D = "Azure_AuditD"
    NON_AZURE_APP_LOCKER = "NonAzure_AppLocker"
    NON_AZURE_AUDIT_D = "NonAzure_AuditD"
    NONE = "None"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the port."""

    REVOKED = "Revoked"
    INITIATED = "Initiated"


class StatusReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A description of why the ``status`` has its value."""

    EXPIRED = "Expired"
    USER_REQUESTED = "UserRequested"
    NEWER_REQUEST_INITIATED = "NewerRequestInitiated"


class Threats(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Threats impact of the assessment."""

    ACCOUNT_BREACH = "accountBreach"
    DATA_EXFILTRATION = "dataExfiltration"
    DATA_SPILLAGE = "dataSpillage"
    MALICIOUS_INSIDER = "maliciousInsider"
    ELEVATION_OF_PRIVILEGE = "elevationOfPrivilege"
    THREAT_RESISTANCE = "threatResistance"
    MISSING_COVERAGE = "missingCoverage"
    DENIAL_OF_SERVICE = "denialOfService"


class TransportProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TransportProtocol."""

    TCP = "TCP"
    UDP = "UDP"


class UserImpact(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The user impact of the assessment."""

    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"
