/* For Unicode version 12.1.0 */

#include "_regex_unicode.h"

#define RE_BLANK_MASK ((1 << RE_PROP_ZL) | (1 << RE_PROP_ZP))
#define RE_GRAPH_MASK ((1 << RE_PROP_CC) | (1 << RE_PROP_CS) | (1 << RE_PROP_CN))
#define RE_WORD_MASK (RE_PROP_M_MASK | (1 << RE_PROP_ND) | (1 << RE_PROP_PC))

typedef struct RE_ScriptExt {
    RE_UINT8 scripts[RE_MAX_SCX];
} RE_ScriptExt;

typedef struct RE_AllCases {
    RE_INT32 diffs[RE_MAX_CASES - 1];
} RE_AllCases;

typedef struct RE_FullCaseFolding {
    RE_INT32 diff;
    RE_UINT16 codepoints[RE_MAX_FOLDED - 1];
} RE_FullCaseFolding;

/* strings. */

char* re_strings[] = {
    "-1/2",
    "0",
    "1",
    "1/10",
    "1/12",
    "1/16",
    "1/160",
    "1/2",
    "1/20",
    "1/3",
    "1/32",
    "1/320",
    "1/4",
    "1/40",
    "1/5",
    "1/6",
    "1/64",
    "1/7",
    "1/8",
    "1/80",
    "1/9",
    "10",
    "100",
    "1000",
    "10000",
    "100000",
    "1000000",
    "10000000",
    "100000000",
    "10000000000",
    "1000000000000",
    "103",
    "107",
    "11",
    "11/12",
    "11/2",
    "118",
    "12",
    "122",
    "129",
    "13",
    "13/2",
    "130",
    "132",
    "133",
    "14",
    "15",
    "15/2",
    "16",
    "17",
    "17/2",
    "18",
    "19",
    "2",
    "2/3",
    "2/5",
    "20",
    "200",
    "2000",
    "20000",
    "200000",
    "20000000",
    "202",
    "21",
    "214",
    "216",
    "216000",
    "218",
    "22",
    "220",
    "222",
    "224",
    "226",
    "228",
    "23",
    "230",
    "232",
    "233",
    "234",
    "24",
    "240",
    "25",
    "26",
    "27",
    "28",
    "29",
    "3",
    "3/16",
    "3/2",
    "3/20",
    "3/4",
    "3/5",
    "3/64",
    "3/8",
    "3/80",
    "30",
    "300",
    "3000",
    "30000",
    "300000",
    "31",
    "32",
    "33",
    "34",
    "35",
    "36",
    "37",
    "38",
    "39",
    "4",
    "4/5",
    "40",
    "400",
    "4000",
    "40000",
    "400000",
    "41",
    "42",
    "43",
    "432000",
    "44",
    "45",
    "46",
    "47",
    "48",
    "49",
    "5",
    "5/12",
    "5/2",
    "5/6",
    "5/8",
    "50",
    "500",
    "5000",
    "50000",
    "500000",
    "6",
    "60",
    "600",
    "6000",
    "60000",
    "600000",
    "7",
    "7/12",
    "7/2",
    "7/8",
    "70",
    "700",
    "7000",
    "70000",
    "700000",
    "8",
    "80",
    "800",
    "8000",
    "80000",
    "800000",
    "84",
    "9",
    "9/2",
    "90",
    "900",
    "9000",
    "90000",
    "900000",
    "91",
    "A",
    "ABOVE",
    "ABOVELEFT",
    "ABOVERIGHT",
    "ADLAM",
    "ADLM",
    "AEGEANNUMBERS",
    "AFRICANFEH",
    "AFRICANNOON",
    "AFRICANQAF",
    "AGHB",
    "AHEX",
    "AHOM",
    "AI",
    "AIN",
    "AL",
    "ALAPH",
    "ALCHEMICAL",
    "ALCHEMICALSYMBOLS",
    "ALEF",
    "ALETTER",
    "ALNUM",
    "ALPHA",
    "ALPHABETIC",
    "ALPHABETICPF",
    "ALPHABETICPRESENTATIONFORMS",
    "ALPHANUMERIC",
    "AMBIGUOUS",
    "AN",
    "ANATOLIANHIEROGLYPHS",
    "ANCIENTGREEKMUSIC",
    "ANCIENTGREEKMUSICALNOTATION",
    "ANCIENTGREEKNUMBERS",
    "ANCIENTSYMBOLS",
    "ANY",
    "AR",
    "ARAB",
    "ARABIC",
    "ARABICEXTA",
    "ARABICEXTENDEDA",
    "ARABICLETTER",
    "ARABICMATH",
    "ARABICMATHEMATICALALPHABETICSYMBOLS",
    "ARABICNUMBER",
    "ARABICPFA",
    "ARABICPFB",
    "ARABICPRESENTATIONFORMSA",
    "ARABICPRESENTATIONFORMSB",
    "ARABICSUP",
    "ARABICSUPPLEMENT",
    "ARMENIAN",
    "ARMI",
    "ARMN",
    "ARROWS",
    "ASCII",
    "ASCIIHEXDIGIT",
    "ASSIGNED",
    "AT",
    "ATA",
    "ATAR",
    "ATB",
    "ATBL",
    "ATERM",
    "ATTACHEDABOVE",
    "ATTACHEDABOVERIGHT",
    "ATTACHEDBELOW",
    "ATTACHEDBELOWLEFT",
    "AVAGRAHA",
    "AVESTAN",
    "AVST",
    "B",
    "B2",
    "BA",
    "BALI",
    "BALINESE",
    "BAMU",
    "BAMUM",
    "BAMUMSUP",
    "BAMUMSUPPLEMENT",
    "BASICLATIN",
    "BASS",
    "BASSAVAH",
    "BATAK",
    "BATK",
    "BB",
    "BC",
    "BEH",
    "BELOW",
    "BELOWLEFT",
    "BELOWRIGHT",
    "BENG",
    "BENGALI",
    "BETH",
    "BHAIKSUKI",
    "BHKS",
    "BIDIC",
    "BIDICLASS",
    "BIDICONTROL",
    "BIDIM",
    "BIDIMIRRORED",
    "BINDU",
    "BK",
    "BL",
    "BLANK",
    "BLK",
    "BLOCK",
    "BLOCKELEMENTS",
    "BN",
    "BOPO",
    "BOPOMOFO",
    "BOPOMOFOEXT",
    "BOPOMOFOEXTENDED",
    "BOTTOM",
    "BOTTOMANDLEFT",
    "BOTTOMANDRIGHT",
    "BOUNDARYNEUTRAL",
    "BOXDRAWING",
    "BR",
    "BRAH",
    "BRAHMI",
    "BRAHMIJOININGNUMBER",
    "BRAI",
    "BRAILLE",
    "BRAILLEPATTERNS",
    "BREAKAFTER",
    "BREAKBEFORE",
    "BREAKBOTH",
    "BREAKSYMBOLS",
    "BUGI",
    "BUGINESE",
    "BUHD",
    "BUHID",
    "BURUSHASKIYEHBARREE",
    "BYZANTINEMUSIC",
    "BYZANTINEMUSICALSYMBOLS",
    "C",
    "C&",
    "CAKM",
    "CAN",
    "CANADIANABORIGINAL",
    "CANADIANSYLLABICS",
    "CANONICAL",
    "CANONICALCOMBININGCLASS",
    "CANS",
    "CANTILLATIONMARK",
    "CARI",
    "CARIAN",
    "CARRIAGERETURN",
    "CASED",
    "CASEDLETTER",
    "CASEIGNORABLE",
    "CAUCASIANALBANIAN",
    "CB",
    "CC",
    "CCC",
    "CCC10",
    "CCC103",
    "CCC107",
    "CCC11",
    "CCC118",
    "CCC12",
    "CCC122",
    "CCC129",
    "CCC13",
    "CCC130",
    "CCC132",
    "CCC133",
    "CCC14",
    "CCC15",
    "CCC16",
    "CCC17",
    "CCC18",
    "CCC19",
    "CCC20",
    "CCC21",
    "CCC22",
    "CCC23",
    "CCC24",
    "CCC25",
    "CCC26",
    "CCC27",
    "CCC28",
    "CCC29",
    "CCC30",
    "CCC31",
    "CCC32",
    "CCC33",
    "CCC34",
    "CCC35",
    "CCC36",
    "CCC84",
    "CCC91",
    "CF",
    "CHAKMA",
    "CHAM",
    "CHANGESWHENCASEFOLDED",
    "CHANGESWHENCASEMAPPED",
    "CHANGESWHENLOWERCASED",
    "CHANGESWHENTITLECASED",
    "CHANGESWHENUPPERCASED",
    "CHER",
    "CHEROKEE",
    "CHEROKEESUP",
    "CHEROKEESUPPLEMENT",
    "CHESSSYMBOLS",
    "CI",
    "CIRCLE",
    "CJ",
    "CJK",
    "CJKCOMPAT",
    "CJKCOMPATFORMS",
    "CJKCOMPATIBILITY",
    "CJKCOMPATIBILITYFORMS",
    "CJKCOMPATIBILITYIDEOGRAPHS",
    "CJKCOMPATIBILITYIDEOGRAPHSSUPPLEMENT",
    "CJKCOMPATIDEOGRAPHS",
    "CJKCOMPATIDEOGRAPHSSUP",
    "CJKEXTA",
    "CJKEXTB",
    "CJKEXTC",
    "CJKEXTD",
    "CJKEXTE",
    "CJKEXTF",
    "CJKRADICALSSUP",
    "CJKRADICALSSUPPLEMENT",
    "CJKSTROKES",
    "CJKSYMBOLS",
    "CJKSYMBOLSANDPUNCTUATION",
    "CJKUNIFIEDIDEOGRAPHS",
    "CJKUNIFIEDIDEOGRAPHSEXTENSIONA",
    "CJKUNIFIEDIDEOGRAPHSEXTENSIONB",
    "CJKUNIFIEDIDEOGRAPHSEXTENSIONC",
    "CJKUNIFIEDIDEOGRAPHSEXTENSIOND",
    "CJKUNIFIEDIDEOGRAPHSEXTENSIONE",
    "CJKUNIFIEDIDEOGRAPHSEXTENSIONF",
    "CL",
    "CLOSE",
    "CLOSEPARENTHESIS",
    "CLOSEPUNCTUATION",
    "CM",
    "CN",
    "CNTRL",
    "CO",
    "COM",
    "COMBININGDIACRITICALMARKS",
    "COMBININGDIACRITICALMARKSEXTENDED",
    "COMBININGDIACRITICALMARKSFORSYMBOLS",
    "COMBININGDIACRITICALMARKSSUPPLEMENT",
    "COMBININGHALFMARKS",
    "COMBININGMARK",
    "COMBININGMARKSFORSYMBOLS",
    "COMMON",
    "COMMONINDICNUMBERFORMS",
    "COMMONSEPARATOR",
    "COMPAT",
    "COMPATJAMO",
    "COMPLEXCONTEXT",
    "CONDITIONALJAPANESESTARTER",
    "CONNECTORPUNCTUATION",
    "CONSONANT",
    "CONSONANTDEAD",
    "CONSONANTFINAL",
    "CONSONANTHEADLETTER",
    "CONSONANTINITIALPOSTFIXED",
    "CONSONANTKILLER",
    "CONSONANTMEDIAL",
    "CONSONANTPLACEHOLDER",
    "CONSONANTPRECEDINGREPHA",
    "CONSONANTPREFIXED",
    "CONSONANTSUBJOINED",
    "CONSONANTSUCCEEDINGREPHA",
    "CONSONANTWITHSTACKER",
    "CONTINGENTBREAK",
    "CONTROL",
    "CONTROLPICTURES",
    "COPT",
    "COPTIC",
    "COPTICEPACTNUMBERS",
    "COUNTINGROD",
    "COUNTINGRODNUMERALS",
    "CP",
    "CPRT",
    "CR",
    "CS",
    "CUNEIFORM",
    "CUNEIFORMNUMBERS",
    "CUNEIFORMNUMBERSANDPUNCTUATION",
    "CURRENCYSYMBOL",
    "CURRENCYSYMBOLS",
    "CWCF",
    "CWCM",
    "CWL",
    "CWT",
    "CWU",
    "CYPRIOT",
    "CYPRIOTSYLLABARY",
    "CYRILLIC",
    "CYRILLICEXTA",
    "CYRILLICEXTB",
    "CYRILLICEXTC",
    "CYRILLICEXTENDEDA",
    "CYRILLICEXTENDEDB",
    "CYRILLICEXTENDEDC",
    "CYRILLICSUP",
    "CYRILLICSUPPLEMENT",
    "CYRILLICSUPPLEMENTARY",
    "CYRL",
    "D",
    "DA",
    "DAL",
    "DALATHRISH",
    "DASH",
    "DASHPUNCTUATION",
    "DB",
    "DE",
    "DECIMAL",
    "DECIMALNUMBER",
    "DECOMPOSITIONTYPE",
    "DEFAULTIGNORABLECODEPOINT",
    "DEP",
    "DEPRECATED",
    "DESERET",
    "DEVA",
    "DEVANAGARI",
    "DEVANAGARIEXT",
    "DEVANAGARIEXTENDED",
    "DI",
    "DIA",
    "DIACRITIC",
    "DIACRITICALS",
    "DIACRITICALSEXT",
    "DIACRITICALSFORSYMBOLS",
    "DIACRITICALSSUP",
    "DIGIT",
    "DINGBATS",
    "DOGR",
    "DOGRA",
    "DOMINO",
    "DOMINOTILES",
    "DOUBLEABOVE",
    "DOUBLEBELOW",
    "DOUBLEQUOTE",
    "DQ",
    "DSRT",
    "DT",
    "DUALJOINING",
    "DUPL",
    "DUPLOYAN",
    "E",
    "EA",
    "EARLYDYNASTICCUNEIFORM",
    "EASTASIANWIDTH",
    "EB",
    "EBASE",
    "EBASEGAZ",
    "EBG",
    "EGYP",
    "EGYPTIANHIEROGLYPHFORMATCONTROLS",
    "EGYPTIANHIEROGLYPHS",
    "ELBA",
    "ELBASAN",
    "ELYM",
    "ELYMAIC",
    "EM",
    "EMODIFIER",
    "EMOJI",
    "EMOJICOMPONENT",
    "EMOJIMODIFIER",
    "EMOJIMODIFIERBASE",
    "EMOJIPRESENTATION",
    "EMOTICONS",
    "EN",
    "ENC",
    "ENCLOSEDALPHANUM",
    "ENCLOSEDALPHANUMERICS",
    "ENCLOSEDALPHANUMERICSUPPLEMENT",
    "ENCLOSEDALPHANUMSUP",
    "ENCLOSEDCJK",
    "ENCLOSEDCJKLETTERSANDMONTHS",
    "ENCLOSEDIDEOGRAPHICSUP",
    "ENCLOSEDIDEOGRAPHICSUPPLEMENT",
    "ENCLOSINGMARK",
    "ES",
    "ET",
    "ETHI",
    "ETHIOPIC",
    "ETHIOPICEXT",
    "ETHIOPICEXTA",
    "ETHIOPICEXTENDED",
    "ETHIOPICEXTENDEDA",
    "ETHIOPICSUP",
    "ETHIOPICSUPPLEMENT",
    "EUROPEANNUMBER",
    "EUROPEANSEPARATOR",
    "EUROPEANTERMINATOR",
    "EX",
    "EXCLAMATION",
    "EXT",
    "EXTEND",
    "EXTENDEDPICTOGRAPHIC",
    "EXTENDER",
    "EXTENDNUMLET",
    "F",
    "FALSE",
    "FARSIYEH",
    "FE",
    "FEH",
    "FIN",
    "FINAL",
    "FINALPUNCTUATION",
    "FINALSEMKATH",
    "FIRSTSTRONGISOLATE",
    "FO",
    "FONT",
    "FORMAT",
    "FRA",
    "FRACTION",
    "FSI",
    "FULLWIDTH",
    "GAF",
    "GAMAL",
    "GAZ",
    "GC",
    "GCB",
    "GEMINATIONMARK",
    "GENERALCATEGORY",
    "GENERALPUNCTUATION",
    "GEOMETRICSHAPES",
    "GEOMETRICSHAPESEXT",
    "GEOMETRICSHAPESEXTENDED",
    "GEOR",
    "GEORGIAN",
    "GEORGIANEXT",
    "GEORGIANEXTENDED",
    "GEORGIANSUP",
    "GEORGIANSUPPLEMENT",
    "GL",
    "GLAG",
    "GLAGOLITIC",
    "GLAGOLITICSUP",
    "GLAGOLITICSUPPLEMENT",
    "GLUE",
    "GLUEAFTERZWJ",
    "GONG",
    "GONM",
    "GOTH",
    "GOTHIC",
    "GRAN",
    "GRANTHA",
    "GRAPH",
    "GRAPHEMEBASE",
    "GRAPHEMECLUSTERBREAK",
    "GRAPHEMEEXTEND",
    "GRAPHEMELINK",
    "GRBASE",
    "GREEK",
    "GREEKANDCOPTIC",
    "GREEKEXT",
    "GREEKEXTENDED",
    "GREK",
    "GREXT",
    "GRLINK",
    "GUJARATI",
    "GUJR",
    "GUNJALAGONDI",
    "GURMUKHI",
    "GURU",
    "H",
    "H2",
    "H3",
    "HAH",
    "HALFANDFULLFORMS",
    "HALFMARKS",
    "HALFWIDTH",
    "HALFWIDTHANDFULLWIDTHFORMS",
    "HAMZAONHEHGOAL",
    "HAN",
    "HANG",
    "HANGUL",
    "HANGULCOMPATIBILITYJAMO",
    "HANGULJAMO",
    "HANGULJAMOEXTENDEDA",
    "HANGULJAMOEXTENDEDB",
    "HANGULSYLLABLES",
    "HANGULSYLLABLETYPE",
    "HANI",
    "HANIFIROHINGYA",
    "HANIFIROHINGYAKINNAYA",
    "HANIFIROHINGYAPA",
    "HANO",
    "HANUNOO",
    "HATR",
    "HATRAN",
    "HE",
    "HEBR",
    "HEBREW",
    "HEBREWLETTER",
    "HEH",
    "HEHGOAL",
    "HETH",
    "HEX",
    "HEXDIGIT",
    "HIGHPRIVATEUSESURROGATES",
    "HIGHPUSURROGATES",
    "HIGHSURROGATES",
    "HIRA",
    "HIRAGANA",
    "HL",
    "HLUW",
    "HMNG",
    "HMNP",
    "HRKT",
    "HST",
    "HUNG",
    "HY",
    "HYPHEN",
    "ID",
    "IDC",
    "IDCONTINUE",
    "IDEO",
    "IDEOGRAPHIC",
    "IDEOGRAPHICDESCRIPTIONCHARACTERS",
    "IDEOGRAPHICSYMBOLS",
    "IDEOGRAPHICSYMBOLSANDPUNCTUATION",
    "IDS",
    "IDSB",
    "IDSBINARYOPERATOR",
    "IDST",
    "IDSTART",
    "IDSTRINARYOPERATOR",
    "IMPERIALARAMAIC",
    "IN",
    "INDICNUMBERFORMS",
    "INDICPOSITIONALCATEGORY",
    "INDICSIYAQNUMBERS",
    "INDICSYLLABICCATEGORY",
    "INFIXNUMERIC",
    "INHERITED",
    "INIT",
    "INITIAL",
    "INITIALPUNCTUATION",
    "INPC",
    "INSC",
    "INSCRIPTIONALPAHLAVI",
    "INSCRIPTIONALPARTHIAN",
    "INSEPARABLE",
    "INSEPERABLE",
    "INVISIBLESTACKER",
    "IOTASUBSCRIPT",
    "IPAEXT",
    "IPAEXTENSIONS",
    "IS",
    "ISO",
    "ISOLATED",
    "ITAL",
    "JAMO",
    "JAMOEXTA",
    "JAMOEXTB",
    "JAVA",
    "JAVANESE",
    "JG",
    "JL",
    "JOINC",
    "JOINCAUSING",
    "JOINCONTROL",
    "JOINER",
    "JOININGGROUP",
    "JOININGTYPE",
    "JT",
    "JV",
    "KA",
    "KAF",
    "KAITHI",
    "KALI",
    "KANA",
    "KANAEXTA",
    "KANAEXTENDEDA",
    "KANASUP",
    "KANASUPPLEMENT",
    "KANAVOICING",
    "KANBUN",
    "KANGXI",
    "KANGXIRADICALS",
    "KANNADA",
    "KAPH",
    "KATAKANA",
    "KATAKANAEXT",
    "KATAKANAORHIRAGANA",
    "KATAKANAPHONETICEXTENSIONS",
    "KAYAHLI",
    "KHAPH",
    "KHAR",
    "KHAROSHTHI",
    "KHMER",
    "KHMERSYMBOLS",
    "KHMR",
    "KHOJ",
    "KHOJKI",
    "KHUDAWADI",
    "KNDA",
    "KNOTTEDHEH",
    "KTHI",
    "KV",
    "L",
    "L&",
    "LAM",
    "LAMADH",
    "LANA",
    "LAO",
    "LAOO",
    "LATIN",
    "LATIN1",
    "LATIN1SUP",
    "LATIN1SUPPLEMENT",
    "LATINEXTA",
    "LATINEXTADDITIONAL",
    "LATINEXTB",
    "LATINEXTC",
    "LATINEXTD",
    "LATINEXTE",
    "LATINEXTENDEDA",
    "LATINEXTENDEDADDITIONAL",
    "LATINEXTENDEDB",
    "LATINEXTENDEDC",
    "LATINEXTENDEDD",
    "LATINEXTENDEDE",
    "LATN",
    "LB",
    "LC",
    "LE",
    "LEADINGJAMO",
    "LEFT",
    "LEFTANDRIGHT",
    "LEFTJOINING",
    "LEFTTORIGHT",
    "LEFTTORIGHTEMBEDDING",
    "LEFTTORIGHTISOLATE",
    "LEFTTORIGHTOVERRIDE",
    "LEPC",
    "LEPCHA",
    "LETTER",
    "LETTERLIKESYMBOLS",
    "LETTERNUMBER",
    "LF",
    "LIMB",
    "LIMBU",
    "LINA",
    "LINB",
    "LINEARA",
    "LINEARB",
    "LINEARBIDEOGRAMS",
    "LINEARBSYLLABARY",
    "LINEBREAK",
    "LINEFEED",
    "LINESEPARATOR",
    "LISU",
    "LL",
    "LM",
    "LO",
    "LOE",
    "LOGICALORDEREXCEPTION",
    "LOWER",
    "LOWERCASE",
    "LOWERCASELETTER",
    "LOWSURROGATES",
    "LRE",
    "LRI",
    "LRO",
    "LT",
    "LU",
    "LV",
    "LVSYLLABLE",
    "LVT",
    "LVTSYLLABLE",
    "LYCI",
    "LYCIAN",
    "LYDI",
    "LYDIAN",
    "M",
    "M&",
    "MAHAJANI",
    "MAHJ",
    "MAHJONG",
    "MAHJONGTILES",
    "MAKA",
    "MAKASAR",
    "MALAYALAM",
    "MALAYALAMBHA",
    "MALAYALAMJA",
    "MALAYALAMLLA",
    "MALAYALAMLLLA",
    "MALAYALAMNGA",
    "MALAYALAMNNA",
    "MALAYALAMNNNA",
    "MALAYALAMNYA",
    "MALAYALAMRA",
    "MALAYALAMSSA",
    "MALAYALAMTTA",
    "MAND",
    "MANDAIC",
    "MANDATORYBREAK",
    "MANI",
    "MANICHAEAN",
    "MANICHAEANALEPH",
    "MANICHAEANAYIN",
    "MANICHAEANBETH",
    "MANICHAEANDALETH",
    "MANICHAEANDHAMEDH",
    "MANICHAEANFIVE",
    "MANICHAEANGIMEL",
    "MANICHAEANHETH",
    "MANICHAEANHUNDRED",
    "MANICHAEANKAPH",
    "MANICHAEANLAMEDH",
    "MANICHAEANMEM",
    "MANICHAEANNUN",
    "MANICHAEANONE",
    "MANICHAEANPE",
    "MANICHAEANQOPH",
    "MANICHAEANRESH",
    "MANICHAEANSADHE",
    "MANICHAEANSAMEKH",
    "MANICHAEANTAW",
    "MANICHAEANTEN",
    "MANICHAEANTETH",
    "MANICHAEANTHAMEDH",
    "MANICHAEANTWENTY",
    "MANICHAEANWAW",
    "MANICHAEANYODH",
    "MANICHAEANZAYIN",
    "MARC",
    "MARCHEN",
    "MARK",
    "MASARAMGONDI",
    "MATH",
    "MATHALPHANUM",
    "MATHEMATICALALPHANUMERICSYMBOLS",
    "MATHEMATICALOPERATORS",
    "MATHOPERATORS",
    "MATHSYMBOL",
    "MAYANNUMERALS",
    "MAYBE",
    "MB",
    "MC",
    "ME",
    "MED",
    "MEDEFAIDRIN",
    "MEDF",
    "MEDIAL",
    "MEEM",
    "MEETEIMAYEK",
    "MEETEIMAYEKEXT",
    "MEETEIMAYEKEXTENSIONS",
    "MEND",
    "MENDEKIKAKUI",
    "MERC",
    "MERO",
    "MEROITICCURSIVE",
    "MEROITICHIEROGLYPHS",
    "MIAO",
    "MIDLETTER",
    "MIDNUM",
    "MIDNUMLET",
    "MIM",
    "MISCARROWS",
    "MISCELLANEOUSMATHEMATICALSYMBOLSA",
    "MISCELLANEOUSMATHEMATICALSYMBOLSB",
    "MISCELLANEOUSSYMBOLS",
    "MISCELLANEOUSSYMBOLSANDARROWS",
    "MISCELLANEOUSSYMBOLSANDPICTOGRAPHS",
    "MISCELLANEOUSTECHNICAL",
    "MISCMATHSYMBOLSA",
    "MISCMATHSYMBOLSB",
    "MISCPICTOGRAPHS",
    "MISCSYMBOLS",
    "MISCTECHNICAL",
    "ML",
    "MLYM",
    "MN",
    "MODI",
    "MODIFIERLETTER",
    "MODIFIERLETTERS",
    "MODIFIERSYMBOL",
    "MODIFIERTONELETTERS",
    "MODIFYINGLETTER",
    "MONG",
    "MONGOLIAN",
    "MONGOLIANSUP",
    "MONGOLIANSUPPLEMENT",
    "MRO",
    "MROO",
    "MTEI",
    "MULT",
    "MULTANI",
    "MUSIC",
    "MUSICALSYMBOLS",
    "MYANMAR",
    "MYANMAREXTA",
    "MYANMAREXTB",
    "MYANMAREXTENDEDA",
    "MYANMAREXTENDEDB",
    "MYMR",
    "N",
    "N&",
    "NA",
    "NABATAEAN",
    "NAN",
    "NAND",
    "NANDINAGARI",
    "NAR",
    "NARB",
    "NARROW",
    "NB",
    "NBAT",
    "NCHAR",
    "ND",
    "NEUTRAL",
    "NEWA",
    "NEWLINE",
    "NEWTAILUE",
    "NEXTLINE",
    "NFCQC",
    "NFCQUICKCHECK",
    "NFDQC",
    "NFDQUICKCHECK",
    "NFKCQC",
    "NFKCQUICKCHECK",
    "NFKDQC",
    "NFKDQUICKCHECK",
    "NK",
    "NKO",
    "NKOO",
    "NL",
    "NO",
    "NOBLOCK",
    "NOBREAK",
    "NOJOININGGROUP",
    "NONCHARACTERCODEPOINT",
    "NONE",
    "NONJOINER",
    "NONJOINING",
    "NONSPACINGMARK",
    "NONSTARTER",
    "NOON",
    "NOTAPPLICABLE",
    "NOTREORDERED",
    "NR",
    "NS",
    "NSHU",
    "NSM",
    "NT",
    "NU",
    "NUKTA",
    "NUMBER",
    "NUMBERFORMS",
    "NUMBERJOINER",
    "NUMERIC",
    "NUMERICTYPE",
    "NUMERICVALUE",
    "NUN",
    "NUSHU",
    "NV",
    "NYA",
    "NYIAKENGPUACHUEHMONG",
    "OALPHA",
    "OCR",
    "ODI",
    "OGAM",
    "OGHAM",
    "OGREXT",
    "OIDC",
    "OIDS",
    "OLCHIKI",
    "OLCK",
    "OLDHUNGARIAN",
    "OLDITALIC",
    "OLDNORTHARABIAN",
    "OLDPERMIC",
    "OLDPERSIAN",
    "OLDSOGDIAN",
    "OLDSOUTHARABIAN",
    "OLDTURKIC",
    "OLETTER",
    "OLOWER",
    "OMATH",
    "ON",
    "OP",
    "OPENPUNCTUATION",
    "OPTICALCHARACTERRECOGNITION",
    "ORIYA",
    "ORKH",
    "ORNAMENTALDINGBATS",
    "ORYA",
    "OSAGE",
    "OSGE",
    "OSMA",
    "OSMANYA",
    "OTHER",
    "OTHERALPHABETIC",
    "OTHERDEFAULTIGNORABLECODEPOINT",
    "OTHERGRAPHEMEEXTEND",
    "OTHERIDCONTINUE",
    "OTHERIDSTART",
    "OTHERLETTER",
    "OTHERLOWERCASE",
    "OTHERMATH",
    "OTHERNEUTRAL",
    "OTHERNUMBER",
    "OTHERPUNCTUATION",
    "OTHERSYMBOL",
    "OTHERUPPERCASE",
    "OTTOMANSIYAQNUMBERS",
    "OUPPER",
    "OV",
    "OVERLAY",
    "OVERSTRUCK",
    "P",
    "P&",
    "PAHAWHHMONG",
    "PALM",
    "PALMYRENE",
    "PARAGRAPHSEPARATOR",
    "PATSYN",
    "PATTERNSYNTAX",
    "PATTERNWHITESPACE",
    "PATWS",
    "PAUC",
    "PAUCINHAU",
    "PC",
    "PCM",
    "PD",
    "PDF",
    "PDI",
    "PE",
    "PERM",
    "PF",
    "PHAG",
    "PHAGSPA",
    "PHAISTOS",
    "PHAISTOSDISC",
    "PHLI",
    "PHLP",
    "PHNX",
    "PHOENICIAN",
    "PHONETICEXT",
    "PHONETICEXTENSIONS",
    "PHONETICEXTENSIONSSUPPLEMENT",
    "PHONETICEXTSUP",
    "PI",
    "PLAYINGCARDS",
    "PLRD",
    "PO",
    "POPDIRECTIONALFORMAT",
    "POPDIRECTIONALISOLATE",
    "POSIXALNUM",
    "POSIXDIGIT",
    "POSIXPUNCT",
    "POSIXXDIGIT",
    "POSTFIXNUMERIC",
    "PP",
    "PR",
    "PREFIXNUMERIC",
    "PREPEND",
    "PREPENDEDCONCATENATIONMARK",
    "PRINT",
    "PRIVATEUSE",
    "PRIVATEUSEAREA",
    "PRTI",
    "PS",
    "PSALTERPAHLAVI",
    "PUA",
    "PUNCT",
    "PUNCTUATION",
    "PUREKILLER",
    "QAAC",
    "QAAI",
    "QAF",
    "QAPH",
    "QMARK",
    "QU",
    "QUOTATION",
    "QUOTATIONMARK",
    "R",
    "RADICAL",
    "REGIONALINDICATOR",
    "REGISTERSHIFTER",
    "REH",
    "REJANG",
    "REVERSEDPE",
    "RI",
    "RIGHT",
    "RIGHTJOINING",
    "RIGHTTOLEFT",
    "RIGHTTOLEFTEMBEDDING",
    "RIGHTTOLEFTISOLATE",
    "RIGHTTOLEFTOVERRIDE",
    "RJNG",
    "RLE",
    "RLI",
    "RLO",
    "ROHG",
    "ROHINGYAYEH",
    "RUMI",
    "RUMINUMERALSYMBOLS",
    "RUNIC",
    "RUNR",
    "S",
    "S&",
    "SA",
    "SAD",
    "SADHE",
    "SAMARITAN",
    "SAMR",
    "SARB",
    "SAUR",
    "SAURASHTRA",
    "SB",
    "SC",
    "SCONTINUE",
    "SCRIPT",
    "SCRIPTEXTENSIONS",
    "SCX",
    "SD",
    "SE",
    "SEEN",
    "SEGMENTSEPARATOR",
    "SEMKATH",
    "SENTENCEBREAK",
    "SENTENCETERMINAL",
    "SEP",
    "SEPARATOR",
    "SG",
    "SGNW",
    "SHARADA",
    "SHAVIAN",
    "SHAW",
    "SHIN",
    "SHORTHANDFORMATCONTROLS",
    "SHRD",
    "SIDD",
    "SIDDHAM",
    "SIGNWRITING",
    "SIND",
    "SINGLEQUOTE",
    "SINH",
    "SINHALA",
    "SINHALAARCHAICNUMBERS",
    "SK",
    "SM",
    "SMALL",
    "SMALLFORMS",
    "SMALLFORMVARIANTS",
    "SMALLKANAEXT",
    "SMALLKANAEXTENSION",
    "SML",
    "SO",
    "SOFTDOTTED",
    "SOGD",
    "SOGDIAN",
    "SOGO",
    "SORA",
    "SORASOMPENG",
    "SOYO",
    "SOYOMBO",
    "SP",
    "SPACE",
    "SPACESEPARATOR",
    "SPACINGMARK",
    "SPACINGMODIFIERLETTERS",
    "SPECIALS",
    "SQ",
    "SQR",
    "SQUARE",
    "ST",
    "STERM",
    "STRAIGHTWAW",
    "SUB",
    "SUND",
    "SUNDANESE",
    "SUNDANESESUP",
    "SUNDANESESUPPLEMENT",
    "SUP",
    "SUPARROWSA",
    "SUPARROWSB",
    "SUPARROWSC",
    "SUPER",
    "SUPERANDSUB",
    "SUPERSCRIPTSANDSUBSCRIPTS",
    "SUPMATHOPERATORS",
    "SUPPLEMENTALARROWSA",
    "SUPPLEMENTALARROWSB",
    "SUPPLEMENTALARROWSC",
    "SUPPLEMENTALMATHEMATICALOPERATORS",
    "SUPPLEMENTALPUNCTUATION",
    "SUPPLEMENTALSYMBOLSANDPICTOGRAPHS",
    "SUPPLEMENTARYPRIVATEUSEAREAA",
    "SUPPLEMENTARYPRIVATEUSEAREAB",
    "SUPPUAA",
    "SUPPUAB",
    "SUPPUNCTUATION",
    "SUPSYMBOLSANDPICTOGRAPHS",
    "SURROGATE",
    "SUTTONSIGNWRITING",
    "SWASHKAF",
    "SY",
    "SYLLABLEMODIFIER",
    "SYLO",
    "SYLOTINAGRI",
    "SYMBOL",
    "SYMBOLSANDPICTOGRAPHSEXTA",
    "SYMBOLSANDPICTOGRAPHSEXTENDEDA",
    "SYRC",
    "SYRIAC",
    "SYRIACSUP",
    "SYRIACSUPPLEMENT",
    "SYRIACWAW",
    "T",
    "TAGALOG",
    "TAGB",
    "TAGBANWA",
    "TAGS",
    "TAH",
    "TAILE",
    "TAITHAM",
    "TAIVIET",
    "TAIXUANJING",
    "TAIXUANJINGSYMBOLS",
    "TAKR",
    "TAKRI",
    "TALE",
    "TALU",
    "TAMIL",
    "TAMILSUP",
    "TAMILSUPPLEMENT",
    "TAML",
    "TANG",
    "TANGUT",
    "TANGUTCOMPONENTS",
    "TAVT",
    "TAW",
    "TEHMARBUTA",
    "TEHMARBUTAGOAL",
    "TELU",
    "TELUGU",
    "TERM",
    "TERMINALPUNCTUATION",
    "TETH",
    "TFNG",
    "TGLG",
    "THAA",
    "THAANA",
    "THAI",
    "TIBETAN",
    "TIBT",
    "TIFINAGH",
    "TIRH",
    "TIRHUTA",
    "TITLECASELETTER",
    "TONELETTER",
    "TONEMARK",
    "TOP",
    "TOPANDBOTTOM",
    "TOPANDBOTTOMANDRIGHT",
    "TOPANDLEFT",
    "TOPANDLEFTANDRIGHT",
    "TOPANDRIGHT",
    "TRAILINGJAMO",
    "TRANSPARENT",
    "TRANSPORTANDMAP",
    "TRANSPORTANDMAPSYMBOLS",
    "TRUE",
    "U",
    "UCAS",
    "UCASEXT",
    "UGAR",
    "UGARITIC",
    "UIDEO",
    "UNASSIGNED",
    "UNIFIEDCANADIANABORIGINALSYLLABICS",
    "UNIFIEDCANADIANABORIGINALSYLLABICSEXTENDED",
    "UNIFIEDIDEOGRAPH",
    "UNKNOWN",
    "UP",
    "UPPER",
    "UPPERCASE",
    "UPPERCASELETTER",
    "V",
    "VAI",
    "VAII",
    "VARIATIONSELECTOR",
    "VARIATIONSELECTORS",
    "VARIATIONSELECTORSSUPPLEMENT",
    "VEDICEXT",
    "VEDICEXTENSIONS",
    "VERT",
    "VERTICAL",
    "VERTICALFORMS",
    "VIRAMA",
    "VISARGA",
    "VISUALORDERLEFT",
    "VOWEL",
    "VOWELDEPENDENT",
    "VOWELINDEPENDENT",
    "VOWELJAMO",
    "VR",
    "VS",
    "VSSUP",
    "W",
    "WANCHO",
    "WARA",
    "WARANGCITI",
    "WAW",
    "WB",
    "WCHO",
    "WHITESPACE",
    "WIDE",
    "WJ",
    "WORD",
    "WORDBREAK",
    "WORDJOINER",
    "WS",
    "WSEGSPACE",
    "WSPACE",
    "XDIGIT",
    "XIDC",
    "XIDCONTINUE",
    "XIDS",
    "XIDSTART",
    "XPEO",
    "XSUX",
    "XX",
    "Y",
    "YEH",
    "YEHBARREE",
    "YEHWITHTAIL",
    "YES",
    "YI",
    "YIII",
    "YIJING",
    "YIJINGHEXAGRAMSYMBOLS",
    "YIRADICALS",
    "YISYLLABLES",
    "YUDH",
    "YUDHHE",
    "Z",
    "Z&",
    "ZAIN",
    "ZANABAZARSQUARE",
    "ZANB",
    "ZHAIN",
    "ZINH",
    "ZL",
    "ZP",
    "ZS",
    "ZW",
    "ZWJ",
    "ZWSPACE",
    "ZYYY",
    "ZZZZ",
};

/* strings: 13687 bytes. */

/* properties. */

RE_Property re_properties[] = {
    { 591,  0,  0},
    { 588,  0,  0},
    { 271,  1,  1},
    { 270,  1,  1},
    {1185,  2,  2},
    {1183,  2,  2},
    {1186,  3,  2},
    {1187,  3,  2},
    {1384,  4,  3},
    {1378,  4,  3},
    { 617,  5,  4},
    { 589,  5,  4},
    {1193,  6,  5},
    {1182,  6,  5},
    { 900,  7,  6},
    { 189,  8,  6},
    { 188,  8,  6},
    { 828,  9,  6},
    { 827,  9,  6},
    {1350, 10,  6},
    {1349, 10,  6},
    { 314, 11,  6},
    { 316, 12,  6},
    { 371, 12,  6},
    { 363, 13,  6},
    { 457, 13,  6},
    { 365, 14,  6},
    { 459, 14,  6},
    { 364, 15,  6},
    { 458, 15,  6},
    { 361, 16,  6},
    { 455, 16,  6},
    { 362, 17,  6},
    { 456, 17,  6},
    { 694, 18,  6},
    { 690, 18,  6},
    { 684, 19,  6},
    { 683, 19,  6},
    {1393, 20,  6},
    {1392, 20,  6},
    {1391, 21,  6},
    {1390, 21,  6},
    { 484, 22,  6},
    { 492, 22,  6},
    { 618, 23,  6},
    { 626, 23,  6},
    { 616, 24,  6},
    { 620, 24,  6},
    { 619, 25,  6},
    { 627, 25,  6},
    {1380, 26,  6},
    {1388, 26,  6},
    {1231, 26,  6},
    { 263, 27,  6},
    { 261, 27,  6},
    { 730, 28,  6},
    { 728, 28,  6},
    { 477, 29,  6},
    { 681, 30,  6},
    {1147, 31,  6},
    {1144, 31,  6},
    {1311, 32,  6},
    {1310, 32,  6},
    {1071, 33,  6},
    {1050, 33,  6},
    { 667, 34,  6},
    { 666, 34,  6},
    { 221, 35,  6},
    { 177, 35,  6},
    {1064, 36,  6},
    {1030, 36,  6},
    { 686, 37,  6},
    { 685, 37,  6},
    { 494, 38,  6},
    { 493, 38,  6},
    { 566, 39,  6},
    { 563, 39,  6},
    {1070, 40,  6},
    {1049, 40,  6},
    {1076, 41,  6},
    {1078, 41,  6},
    {1003, 42,  6},
    { 980, 42,  6},
    {1066, 43,  6},
    {1035, 43,  6},
    { 692, 44,  6},
    { 691, 44,  6},
    { 695, 45,  6},
    { 693, 45,  6},
    {1149, 46,  6},
    {1346, 47,  6},
    {1342, 47,  6},
    {1065, 48,  6},
    {1032, 48,  6},
    { 486, 49,  6},
    { 485, 49,  6},
    {1222, 50,  6},
    {1188, 50,  6},
    { 826, 51,  6},
    { 825, 51,  6},
    {1068, 52,  6},
    {1037, 52,  6},
    {1067, 53,  6},
    {1036, 53,  6},
    {1194, 54,  6},
    {1240, 54,  6},
    {1355, 55,  6},
    {1371, 55,  6},
    {1090, 56,  6},
    {1091, 56,  6},
    {1089, 57,  6},
    {1088, 57,  6},
    {1129, 58,  6},
    {1095, 58,  6},
    {1150, 59,  6},
    {1155, 59,  6},
    { 650, 60,  7},
    { 678, 60,  7},
    { 262, 61,  8},
    { 251, 61,  8},
    { 308, 62,  9},
    { 320, 62,  9},
    { 483, 63, 10},
    { 510, 63, 10},
    { 517, 64, 11},
    { 515, 64, 11},
    { 732, 65, 12},
    { 726, 65, 12},
    { 733, 66, 13},
    { 734, 66, 13},
    { 818, 67, 14},
    { 793, 67, 14},
    {1023, 68, 15},
    {1016, 68, 15},
    {1024, 69, 16},
    {1027, 69, 16},
    { 265, 70,  6},
    { 264, 70,  6},
    { 699, 71, 17},
    { 707, 71, 17},
    { 701, 72, 18},
    { 708, 72, 18},
    { 531, 73, 19},
    { 535, 74, 19},
    { 533, 75, 19},
    { 534, 76, 19},
    { 532, 77, 19},
    { 565, 78, 19},
    { 990, 79, 20},
    { 989, 79, 20},
    { 988, 80, 21},
    { 987, 80, 21},
    { 994, 81, 20},
    { 993, 81, 20},
    { 992, 82, 21},
    { 991, 82, 21},
    { 192, 83,  6},
    { 187, 83,  6},
    { 200, 84,  6},
    { 269, 85,  6},
    { 615, 86,  6},
    {1130, 87,  6},
    {1383, 88,  6},
    {1389, 89,  6},
    {1121, 90,  6},
    {1120, 91,  6},
    {1122, 92,  6},
    {1123, 93,  6},
};

/* properties: 672 bytes. */

/* property values. */

RE_PropertyValue re_property_values[] = {
    {1343,  0,   0},
    { 406,  0,   0},
    {1351,  0,   1},
    { 835,  0,   1},
    { 829,  0,   2},
    { 822,  0,   2},
    {1323,  0,   3},
    { 834,  0,   3},
    { 946,  0,   4},
    { 823,  0,   4},
    {1069,  0,   5},
    { 824,  0,   5},
    {1007,  0,   6},
    { 944,  0,   6},
    { 547,  0,   7},
    { 910,  0,   7},
    {1233,  0,   8},
    { 909,  0,   8},
    { 482,  0,   9},
    { 981,  0,   9},
    { 499,  0,   9},
    { 808,  0,  10},
    { 998,  0,  10},
    {1073,  0,  11},
    { 999,  0,  11},
    {1232,  0,  12},
    {1419,  0,  12},
    { 820,  0,  13},
    {1417,  0,  13},
    {1087,  0,  14},
    {1418,  0,  14},
    { 439,  0,  15},
    { 319,  0,  15},
    { 407,  0,  15},
    { 580,  0,  16},
    { 358,  0,  16},
    {1131,  0,  17},
    { 408,  0,  17},
    {1267,  0,  18},
    { 449,  0,  18},
    { 478,  0,  19},
    {1096,  0,  19},
    {1053,  0,  20},
    {1134,  0,  20},
    { 404,  0,  21},
    {1099,  0,  21},
    { 424,  0,  22},
    {1094,  0,  22},
    {1074,  0,  23},
    {1117,  0,  23},
    { 905,  0,  24},
    {1214,  0,  24},
    { 453,  0,  25},
    {1183,  0,  25},
    { 948,  0,  26},
    {1213,  0,  26},
    {1075,  0,  27},
    {1221,  0,  27},
    { 706,  0,  28},
    {1114,  0,  28},
    { 575,  0,  29},
    {1101,  0,  29},
    {1063,  0,  30},
    { 301,  0,  30},
    { 302,  0,  30},
    { 806,  0,  31},
    { 769,  0,  31},
    { 770,  0,  31},
    { 898,  0,  32},
    { 844,  0,  32},
    { 415,  0,  32},
    { 845,  0,  32},
    {1019,  0,  33},
    { 968,  0,  33},
    { 969,  0,  33},
    {1138,  0,  34},
    {1082,  0,  34},
    {1137,  0,  34},
    {1083,  0,  34},
    {1274,  0,  35},
    {1172,  0,  35},
    {1173,  0,  35},
    {1196,  0,  36},
    {1410,  0,  36},
    {1411,  0,  36},
    { 315,  0,  37},
    { 794,  0,  37},
    { 222,  0,  38},
    {1000,  1,   0},
    { 978,  1,   0},
    { 245,  1,   1},
    { 220,  1,   1},
    { 779,  1,   2},
    { 778,  1,   2},
    { 777,  1,   2},
    { 786,  1,   3},
    { 780,  1,   3},
    { 788,  1,   4},
    { 782,  1,   4},
    { 716,  1,   5},
    { 715,  1,   5},
    {1234,  1,   6},
    { 947,  1,   6},
    { 410,  1,   7},
    { 495,  1,   7},
    { 622,  1,   8},
    { 621,  1,   8},
    { 462,  1,   9},
    { 470,  1,  10},
    { 469,  1,  10},
    { 471,  1,  10},
    { 216,  1,  11},
    { 661,  1,  12},
    { 203,  1,  13},
    {1278,  1,  14},
    { 215,  1,  15},
    { 214,  1,  15},
    {1316,  1,  16},
    { 996,  1,  17},
    {1177,  1,  18},
    { 865,  1,  19},
    {1280,  1,  20},
    {1279,  1,  20},
    { 205,  1,  21},
    { 204,  1,  21},
    { 489,  1,  22},
    { 257,  1,  23},
    { 631,  1,  24},
    { 628,  1,  25},
    {1055,  1,  26},
    {1297,  1,  27},
    {1309,  1,  28},
    { 749,  1,  29},
    { 852,  1,  30},
    {1211,  1,  31},
    {1317,  1,  32},
    { 774,  1,  33},
    {1318,  1,  34},
    { 962,  1,  35},
    { 597,  1,  36},
    { 646,  1,  37},
    { 721,  1,  37},
    { 551,  1,  38},
    { 557,  1,  39},
    { 556,  1,  39},
    { 367,  1,  40},
    {1344,  1,  41},
    {1338,  1,  41},
    { 306,  1,  41},
    {1034,  1,  42},
    {1170,  1,  43},
    {1283,  1,  44},
    { 656,  1,  45},
    { 297,  1,  46},
    {1285,  1,  47},
    { 759,  1,  48},
    { 952,  1,  49},
    {1345,  1,  50},
    {1339,  1,  50},
    { 811,  1,  51},
    {1288,  1,  52},
    { 985,  1,  53},
    { 760,  1,  54},
    { 295,  1,  55},
    {1289,  1,  56},
    { 411,  1,  57},
    { 496,  1,  57},
    { 240,  1,  58},
    {1244,  1,  59},
    { 248,  1,  60},
    { 805,  1,  61},
    {1038,  1,  62},
    { 468,  1,  63},
    { 465,  1,  63},
    { 599,  1,  64},
    { 598,  1,  64},
    {1246,  1,  65},
    {1245,  1,  65},
    {1359,  1,  66},
    {1358,  1,  66},
    {1111,  1,  67},
    {1110,  1,  67},
    {1112,  1,  68},
    {1113,  1,  68},
    { 413,  1,  69},
    { 498,  1,  69},
    { 787,  1,  70},
    { 781,  1,  70},
    { 624,  1,  71},
    { 623,  1,  71},
    { 592,  1,  72},
    {1138,  1,  72},
    {1253,  1,  73},
    {1252,  1,  73},
    { 454,  1,  74},
    { 412,  1,  75},
    { 497,  1,  75},
    { 416,  1,  75},
    { 807,  1,  76},
    {1020,  1,  77},
    { 219,  1,  78},
    { 903,  1,  79},
    { 904,  1,  79},
    { 936,  1,  80},
    { 941,  1,  80},
    { 440,  1,  81},
    {1054,  1,  82},
    {1031,  1,  82},
    { 540,  1,  83},
    { 539,  1,  83},
    { 282,  1,  84},
    { 272,  1,  85},
    { 593,  1,  86},
    { 933,  1,  87},
    { 940,  1,  87},
    { 500,  1,  88},
    { 931,  1,  89},
    { 937,  1,  89},
    {1255,  1,  90},
    {1248,  1,  90},
    { 289,  1,  91},
    { 288,  1,  91},
    {1256,  1,  92},
    {1249,  1,  92},
    { 932,  1,  93},
    { 938,  1,  93},
    {1258,  1,  94},
    {1254,  1,  94},
    { 934,  1,  95},
    { 930,  1,  95},
    { 604,  1,  96},
    { 789,  1,  97},
    { 783,  1,  97},
    { 442,  1,  98},
    { 601,  1,  99},
    { 600,  1,  99},
    {1320,  1, 100},
    { 554,  1, 101},
    { 552,  1, 101},
    { 466,  1, 102},
    { 463,  1, 102},
    {1259,  1, 103},
    {1265,  1, 103},
    { 390,  1, 104},
    { 389,  1, 104},
    { 748,  1, 105},
    { 747,  1, 105},
    { 687,  1, 106},
    { 683,  1, 106},
    { 393,  1, 107},
    { 392,  1, 107},
    { 672,  1, 108},
    { 751,  1, 109},
    { 275,  1, 110},
    { 645,  1, 111},
    { 421,  1, 111},
    { 746,  1, 112},
    { 277,  1, 113},
    { 276,  1, 113},
    { 391,  1, 114},
    { 754,  1, 115},
    { 752,  1, 115},
    { 544,  1, 116},
    { 543,  1, 116},
    { 377,  1, 117},
    { 375,  1, 117},
    { 395,  1, 118},
    { 383,  1, 118},
    {1405,  1, 119},
    {1404,  1, 119},
    { 394,  1, 120},
    { 374,  1, 120},
    {1407,  1, 121},
    {1406,  1, 122},
    { 821,  1, 123},
    {1353,  1, 124},
    { 467,  1, 125},
    { 464,  1, 125},
    { 242,  1, 126},
    { 949,  1, 127},
    { 790,  1, 128},
    { 784,  1, 128},
    {1273,  1, 129},
    { 418,  1, 130},
    { 698,  1, 130},
    {1103,  1, 131},
    {1181,  1, 132},
    { 491,  1, 133},
    { 490,  1, 133},
    { 755,  1, 134},
    {1153,  1, 135},
    { 647,  1, 136},
    { 722,  1, 136},
    { 725,  1, 137},
    { 966,  1, 138},
    { 964,  1, 138},
    { 360,  1, 139},
    { 965,  1, 140},
    { 963,  1, 140},
    {1290,  1, 141},
    { 918,  1, 142},
    { 917,  1, 142},
    { 555,  1, 143},
    { 553,  1, 143},
    { 791,  1, 144},
    { 785,  1, 144},
    { 369,  1, 145},
    { 368,  1, 145},
    { 916,  1, 146},
    { 649,  1, 147},
    { 644,  1, 147},
    { 648,  1, 148},
    { 723,  1, 148},
    { 670,  1, 149},
    { 668,  1, 150},
    { 669,  1, 150},
    { 830,  1, 151},
    {1132,  1, 152},
    {1136,  1, 152},
    {1131,  1, 152},
    { 379,  1, 153},
    { 381,  1, 153},
    { 191,  1, 154},
    { 190,  1, 154},
    { 212,  1, 155},
    { 210,  1, 155},
    {1356,  1, 156},
    {1371,  1, 156},
    {1362,  1, 157},
    { 414,  1, 158},
    { 638,  1, 158},
    { 378,  1, 159},
    { 376,  1, 159},
    {1217,  1, 160},
    {1216,  1, 160},
    { 213,  1, 161},
    { 211,  1, 161},
    { 640,  1, 162},
    { 637,  1, 162},
    {1235,  1, 163},
    { 817,  1, 164},
    { 816,  1, 165},
    { 172,  1, 166},
    { 198,  1, 167},
    { 199,  1, 168},
    {1105,  1, 169},
    {1104,  1, 169},
    { 841,  1, 170},
    { 312,  1, 171},
    { 443,  1, 172},
    {1041,  1, 173},
    { 612,  1, 174},
    {1043,  1, 175},
    {1341,  1, 176},
    {1044,  1, 177},
    { 487,  1, 178},
    {1200,  1, 179},
    {1062,  1, 180},
    {1059,  1, 181},
    { 526,  1, 182},
    { 317,  1, 183},
    { 814,  1, 184},
    { 461,  1, 185},
    { 696,  1, 186},
    {1086,  1, 187},
    { 971,  1, 188},
    { 658,  1, 189},
    {1109,  1, 190},
    { 843,  1, 191},
    { 924,  1, 192},
    { 923,  1, 193},
    { 758,  1, 194},
    {1046,  1, 195},
    {1042,  1, 196},
    { 868,  1, 197},
    { 234,  1, 198},
    { 710,  1, 199},
    { 709,  1, 200},
    {1135,  1, 201},
    {1047,  1, 202},
    {1040,  1, 203},
    { 652,  1, 204},
    {1169,  1, 205},
    {1168,  1, 205},
    {1045,  1, 206},
    {1224,  1, 207},
    { 528,  1, 208},
    { 285,  1, 209},
    { 738,  1, 210},
    {1227,  1, 211},
    { 359,  1, 212},
    { 846,  1, 213},
    {1199,  1, 214},
    {1212,  1, 215},
    { 763,  1, 216},
    { 959,  1, 217},
    { 764,  1, 218},
    { 614,  1, 219},
    { 983,  1, 220},
    {1322,  1, 221},
    {1206,  1, 222},
    { 945,  1, 223},
    { 954,  1, 224},
    { 953,  1, 224},
    {1294,  1, 225},
    { 178,  1, 226},
    { 502,  1, 227},
    {1376,  1, 228},
    { 974,  1, 229},
    {1413,  1, 230},
    {1229,  1, 231},
    {1093,  1, 232},
    { 259,  1, 233},
    { 897,  1, 234},
    { 899,  1, 235},
    { 630,  1, 236},
    { 851,  1, 237},
    {1299,  1, 238},
    {1298,  1, 238},
    { 450,  1, 239},
    { 452,  1, 240},
    { 451,  1, 240},
    { 516,  1, 241},
    { 524,  1, 242},
    { 523,  1, 243},
    { 195,  1, 244},
    { 244,  1, 245},
    { 243,  1, 245},
    { 955,  1, 246},
    { 247,  1, 247},
    {1084,  1, 248},
    { 912,  1, 249},
    { 925,  1, 250},
    { 689,  1, 251},
    { 688,  1, 251},
    {1302,  1, 252},
    {1303,  1, 253},
    { 744,  1, 254},
    { 743,  1, 254},
    { 742,  1, 255},
    { 741,  1, 255},
    {1219,  1, 256},
    {1218,  1, 256},
    {1026,  1, 257},
    { 513,  1, 258},
    {1203,  1, 259},
    { 300,  1, 260},
    { 299,  1, 260},
    { 961,  1, 261},
    { 960,  1, 261},
    { 197,  1, 262},
    { 196,  1, 262},
    { 906,  1, 263},
    {1292,  1, 264},
    {1291,  1, 264},
    { 445,  1, 265},
    { 444,  1, 265},
    { 902,  1, 266},
    { 901,  1, 266},
    {1268,  1, 267},
    { 606,  1, 268},
    { 605,  1, 268},
    {1029,  1, 269},
    {1374,  1, 270},
    { 920,  1, 271},
    { 170,  1, 272},
    { 700,  1, 273},
    {1077,  1, 274},
    { 208,  1, 275},
    { 207,  1, 275},
    { 849,  1, 276},
    { 848,  1, 276},
    { 504,  1, 277},
    { 503,  1, 277},
    {1115,  1, 278},
    { 541,  1, 279},
    { 542,  1, 279},
    { 546,  1, 280},
    { 545,  1, 280},
    { 935,  1, 281},
    { 939,  1, 281},
    { 536,  1, 282},
    {1057,  1, 283},
    {1335,  1, 284},
    {1334,  1, 284},
    { 184,  1, 285},
    { 183,  1, 285},
    { 595,  1, 286},
    { 594,  1, 286},
    {1257,  1, 287},
    {1250,  1, 287},
    {1260,  1, 288},
    {1266,  1, 288},
    { 370,  1, 289},
    {1276,  1, 290},
    {1275,  1, 290},
    { 396,  1, 291},
    { 384,  1, 291},
    { 397,  1, 292},
    { 385,  1, 292},
    { 398,  1, 293},
    { 386,  1, 293},
    { 399,  1, 294},
    { 387,  1, 294},
    { 400,  1, 295},
    { 388,  1, 295},
    { 380,  1, 296},
    { 382,  1, 296},
    {1286,  1, 297},
    {1357,  1, 298},
    {1372,  1, 298},
    {1261,  1, 299},
    {1263,  1, 299},
    {1262,  1, 300},
    {1264,  1, 300},
    {1347,  2,   0},
    {1424,  2,   0},
    { 417,  2,   1},
    {1423,  2,   1},
    { 776,  2,   2},
    { 792,  2,   2},
    { 621,  2,   3},
    { 625,  2,   3},
    { 462,  2,   4},
    { 472,  2,   4},
    { 216,  2,   5},
    { 218,  2,   5},
    { 661,  2,   6},
    { 660,  2,   6},
    { 203,  2,   7},
    { 202,  2,   7},
    {1278,  2,   8},
    {1277,  2,   8},
    {1316,  2,   9},
    {1315,  2,   9},
    { 489,  2,  10},
    { 488,  2,  10},
    { 257,  2,  11},
    { 256,  2,  11},
    { 631,  2,  12},
    { 632,  2,  12},
    { 628,  2,  13},
    { 629,  2,  13},
    {1055,  2,  14},
    {1058,  2,  14},
    {1297,  2,  15},
    {1300,  2,  15},
    {1309,  2,  16},
    {1308,  2,  16},
    { 749,  2,  17},
    { 765,  2,  17},
    { 852,  2,  18},
    { 943,  2,  18},
    {1211,  2,  19},
    {1210,  2,  19},
    {1317,  2,  20},
    { 774,  2,  21},
    { 775,  2,  21},
    {1318,  2,  22},
    {1319,  2,  22},
    { 962,  2,  23},
    { 967,  2,  23},
    { 597,  2,  24},
    { 596,  2,  24},
    { 644,  2,  25},
    { 643,  2,  25},
    { 551,  2,  26},
    { 550,  2,  26},
    { 367,  2,  27},
    { 366,  2,  27},
    { 305,  2,  28},
    { 309,  2,  28},
    {1034,  2,  29},
    {1033,  2,  29},
    {1170,  2,  30},
    {1171,  2,  30},
    { 759,  2,  31},
    { 761,  2,  31},
    { 952,  2,  32},
    { 951,  2,  32},
    { 672,  2,  33},
    { 671,  2,  33},
    { 751,  2,  34},
    { 740,  2,  34},
    { 275,  2,  35},
    { 274,  2,  35},
    { 642,  2,  36},
    { 651,  2,  36},
    {1402,  2,  37},
    {1403,  2,  37},
    {1041,  2,  38},
    { 720,  2,  38},
    { 612,  2,  39},
    { 611,  2,  39},
    { 487,  2,  40},
    { 509,  2,  40},
    { 703,  2,  41},
    {1416,  2,  41},
    {1141,  2,  41},
    {1283,  2,  42},
    {1314,  2,  42},
    { 656,  2,  43},
    { 655,  2,  43},
    { 297,  2,  44},
    { 296,  2,  44},
    {1285,  2,  45},
    {1284,  2,  45},
    { 811,  2,  46},
    { 810,  2,  46},
    {1288,  2,  47},
    {1295,  2,  47},
    { 815,  2,  48},
    { 813,  2,  48},
    {1341,  2,  49},
    {1340,  2,  49},
    {1200,  2,  50},
    {1201,  2,  50},
    {1062,  2,  51},
    {1061,  2,  51},
    { 460,  2,  52},
    { 447,  2,  52},
    { 288,  2,  53},
    { 287,  2,  53},
    { 295,  2,  54},
    { 294,  2,  54},
    { 442,  2,  55},
    { 441,  2,  55},
    {1140,  2,  55},
    { 985,  2,  56},
    {1296,  2,  56},
    { 604,  2,  57},
    { 603,  2,  57},
    {1320,  2,  58},
    {1313,  2,  58},
    {1273,  2,  59},
    {1272,  2,  59},
    {1044,  2,  60},
    {1394,  2,  60},
    { 758,  2,  61},
    { 757,  2,  61},
    { 240,  2,  62},
    { 239,  2,  62},
    { 450,  2,  63},
    {1395,  2,  63},
    {1109,  2,  64},
    {1108,  2,  64},
    {1103,  2,  65},
    {1102,  2,  65},
    { 996,  2,  66},
    { 997,  2,  66},
    {1244,  2,  67},
    {1243,  2,  67},
    { 805,  2,  68},
    { 804,  2,  68},
    {1038,  2,  69},
    {1039,  2,  69},
    {1353,  2,  70},
    {1354,  2,  70},
    {1181,  2,  71},
    {1180,  2,  71},
    { 755,  2,  72},
    { 739,  2,  72},
    {1153,  2,  73},
    {1162,  2,  73},
    { 841,  2,  74},
    { 840,  2,  74},
    { 312,  2,  75},
    { 311,  2,  75},
    { 843,  2,  76},
    { 842,  2,  76},
    { 360,  2,  77},
    {1289,  2,  78},
    { 773,  2,  78},
    {1290,  2,  79},
    {1304,  2,  79},
    { 234,  2,  80},
    { 235,  2,  80},
    { 524,  2,  81},
    { 522,  2,  81},
    {1177,  2,  82},
    {1178,  2,  82},
    { 821,  2,  83},
    { 242,  2,  84},
    { 241,  2,  84},
    { 725,  2,  85},
    { 724,  2,  85},
    { 916,  2,  86},
    { 957,  2,  86},
    { 696,  2,  87},
    { 217,  2,  87},
    {1046,  2,  88},
    {1179,  2,  88},
    { 710,  2,  89},
    {1133,  2,  89},
    { 709,  2,  90},
    {1106,  2,  90},
    {1047,  2,  91},
    {1056,  2,  91},
    { 738,  2,  92},
    { 767,  2,  92},
    { 248,  2,  93},
    { 249,  2,  93},
    { 285,  2,  94},
    { 284,  2,  94},
    { 865,  2,  95},
    { 864,  2,  95},
    { 359,  2,  96},
    { 303,  2,  96},
    { 923,  2,  97},
    { 921,  2,  97},
    { 924,  2,  98},
    { 922,  2,  98},
    { 925,  2,  99},
    {1116,  2,  99},
    {1199,  2, 100},
    {1204,  2, 100},
    {1227,  2, 101},
    {1226,  2, 101},
    {1294,  2, 102},
    {1293,  2, 102},
    { 317,  2, 103},
    { 176,  2, 103},
    { 247,  2, 104},
    { 246,  2, 104},
    { 513,  2, 105},
    { 512,  2, 105},
    { 526,  2, 106},
    { 525,  2, 106},
    { 614,  2, 107},
    { 613,  2, 107},
    {1084,  2, 108},
    { 675,  2, 108},
    { 763,  2, 109},
    { 762,  2, 109},
    { 814,  2, 110},
    { 812,  2, 110},
    { 846,  2, 111},
    { 847,  2, 111},
    { 868,  2, 112},
    { 867,  2, 112},
    { 920,  2, 113},
    { 919,  2, 113},
    { 945,  2, 114},
    { 955,  2, 115},
    { 956,  2, 115},
    {1042,  2, 116},
    { 976,  2, 116},
    { 971,  2, 117},
    { 979,  2, 117},
    {1086,  2, 118},
    {1085,  2, 118},
    {1093,  2, 119},
    {1092,  2, 119},
    {1043,  2, 120},
    {1100,  2, 120},
    {1135,  2, 121},
    {1107,  2, 121},
    {1206,  2, 122},
    {1205,  2, 122},
    { 764,  2, 123},
    {1208,  2, 123},
    {1322,  2, 124},
    {1321,  2, 124},
    {1376,  2, 125},
    {1375,  2, 125},
    { 178,  2, 126},
    { 195,  2, 127},
    { 674,  2, 127},
    { 658,  2, 128},
    { 657,  2, 128},
    { 959,  2, 129},
    { 958,  2, 129},
    {1040,  2, 130},
    { 679,  2, 130},
    {1207,  2, 131},
    {1198,  2, 131},
    { 170,  2, 132},
    { 171,  2, 132},
    { 259,  2, 133},
    { 260,  2, 133},
    { 897,  2, 134},
    { 896,  2, 134},
    { 983,  2, 135},
    {1059,  2, 136},
    {1060,  2, 136},
    {1302,  2, 137},
    {1301,  2, 137},
    { 899,  2, 138},
    { 610,  2, 138},
    {1026,  2, 139},
    {1014,  2, 139},
    {1229,  2, 140},
    {1228,  2, 140},
    {1413,  2, 141},
    {1414,  2, 141},
    { 502,  2, 142},
    { 501,  2, 142},
    { 630,  2, 143},
    { 609,  2, 143},
    { 851,  2, 144},
    { 850,  2, 144},
    { 912,  2, 145},
    { 913,  2, 145},
    { 652,  2, 146},
    {1166,  2, 146},
    {1224,  2, 147},
    {1223,  2, 147},
    {1045,  2, 148},
    {1225,  2, 148},
    { 528,  2, 149},
    { 527,  2, 149},
    { 974,  2, 150},
    { 973,  2, 150},
    {1029,  2, 151},
    { 676,  2, 151},
    {1374,  2, 152},
    {1379,  2, 152},
    { 753,  2, 153},
    { 677,  2, 153},
    {1063,  3,   0},
    {1396,  3,   0},
    { 507,  3,   1},
    { 508,  3,   1},
    {1209,  3,   2},
    {1236,  3,   2},
    { 662,  3,   3},
    { 673,  3,   3},
    { 448,  3,   4},
    { 809,  3,   5},
    { 984,  3,   6},
    { 998,  3,   6},
    { 564,  3,   7},
    {1150,  3,   8},
    {1155,  3,   8},
    { 580,  3,   9},
    { 578,  3,   9},
    { 751,  3,  10},
    { 736,  3,  10},
    { 186,  3,  11},
    { 795,  3,  11},
    { 926,  3,  12},
    { 942,  3,  12},
    { 927,  3,  13},
    { 944,  3,  13},
    { 928,  3,  14},
    { 908,  3,  14},
    {1022,  3,  15},
    {1017,  3,  15},
    { 567,  3,  16},
    { 561,  3,  16},
    {1421,  3,  17},
    {1387,  3,  18},
    { 519,  3,  19},
    { 518,  3,  19},
    { 520,  3,  20},
    { 521,  3,  20},
    { 530,  3,  21},
    { 529,  3,  21},
    { 608,  3,  22},
    { 587,  3,  22},
    {1063,  4,   0},
    {1396,  4,   0},
    {1128,  4,   1},
    {1125,  4,   1},
    { 448,  4,   2},
    { 809,  4,   3},
    { 439,  4,   4},
    { 406,  4,   4},
    { 564,  4,   5},
    { 561,  4,   5},
    {1150,  4,   6},
    {1155,  4,   6},
    {1233,  4,   7},
    {1214,  4,   7},
    { 769,  4,   8},
    {1352,  4,   9},
    {1282,  4,  10},
    { 836,  4,  11},
    { 838,  4,  12},
    {1421,  4,  13},
    { 519,  4,  14},
    { 518,  4,  14},
    { 520,  4,  15},
    { 521,  4,  15},
    { 530,  4,  16},
    { 529,  4,  16},
    { 608,  4,  17},
    { 587,  4,  17},
    {1063,  5,   0},
    {1396,  5,   0},
    { 448,  5,   1},
    { 809,  5,   2},
    { 564,  5,   3},
    { 561,  5,   3},
    {1195,  5,   4},
    {1189,  5,   4},
    { 580,  5,   5},
    { 578,  5,   5},
    {1230,  5,   6},
    { 827,  5,   7},
    { 824,  5,   7},
    {1349,  5,   8},
    {1348,  5,   8},
    {1048,  5,   9},
    { 795,  5,   9},
    {1022,  5,  10},
    {1017,  5,  10},
    { 228,  5,  11},
    { 223,  5,  11},
    {1240,  5,  12},
    {1239,  5,  12},
    { 402,  5,  13},
    { 401,  5,  13},
    {1184,  5,  14},
    {1183,  5,  14},
    { 999,  6,   0},
    { 968,  6,   0},
    { 568,  6,   0},
    { 569,  6,   0},
    {1401,  6,   1},
    {1397,  6,   1},
    {1282,  6,   1},
    {1336,  6,   1},
    {1010,  7,   0},
    { 970,  7,   0},
    { 796,  7,   1},
    { 769,  7,   1},
    {1369,  7,   2},
    {1352,  7,   2},
    {1332,  7,   3},
    {1282,  7,   3},
    { 837,  7,   4},
    { 836,  7,   4},
    { 839,  7,   5},
    { 838,  7,   5},
    { 800,  8,   0},
    { 769,  8,   0},
    {1158,  8,   1},
    {1148,  8,   1},
    { 558,  8,   2},
    { 537,  8,   2},
    { 559,  8,   3},
    { 548,  8,   3},
    { 560,  8,   4},
    { 549,  8,   4},
    { 209,  8,   5},
    { 194,  8,   5},
    { 419,  8,   6},
    { 449,  8,   6},
    {1087,  8,   7},
    { 236,  8,   7},
    {1191,  8,   8},
    {1172,  8,   8},
    {1380,  8,   9},
    {1386,  8,   9},
    {1072,  8,  10},
    {1051,  8,  10},
    { 281,  8,  11},
    { 273,  8,  11},
    {1007,  8,  12},
    {1015,  8,  12},
    { 206,  8,  13},
    { 181,  8,  13},
    { 803,  8,  14},
    { 833,  8,  14},
    {1161,  8,  15},
    {1165,  8,  15},
    { 801,  8,  16},
    { 831,  8,  16},
    {1159,  8,  17},
    {1163,  8,  17},
    {1118,  8,  18},
    {1097,  8,  18},
    { 802,  8,  19},
    { 832,  8,  19},
    {1160,  8,  20},
    {1164,  8,  20},
    { 577,  8,  21},
    { 583,  8,  21},
    {1119,  8,  22},
    {1098,  8,  22},
    {1011,  9,   0},
    {   1,  9,   0},
    {1012,  9,   0},
    {1080,  9,   1},
    {   2,  9,   1},
    {1079,  9,   1},
    {1018,  9,   2},
    { 142,  9,   2},
    { 995,  9,   2},
    { 745,  9,   3},
    { 151,  9,   3},
    { 768,  9,   3},
    {1363,  9,   4},
    { 158,  9,   4},
    {1370,  9,   4},
    { 321,  9,   5},
    {  21,  9,   5},
    { 324,  9,   6},
    {  33,  9,   6},
    { 326,  9,   7},
    {  37,  9,   7},
    { 329,  9,   8},
    {  40,  9,   8},
    { 333,  9,   9},
    {  45,  9,   9},
    { 334,  9,  10},
    {  46,  9,  10},
    { 335,  9,  11},
    {  48,  9,  11},
    { 336,  9,  12},
    {  49,  9,  12},
    { 337,  9,  13},
    {  51,  9,  13},
    { 338,  9,  14},
    {  52,  9,  14},
    { 339,  9,  15},
    {  56,  9,  15},
    { 340,  9,  16},
    {  63,  9,  16},
    { 341,  9,  17},
    {  68,  9,  17},
    { 342,  9,  18},
    {  74,  9,  18},
    { 343,  9,  19},
    {  79,  9,  19},
    { 344,  9,  20},
    {  81,  9,  20},
    { 345,  9,  21},
    {  82,  9,  21},
    { 346,  9,  22},
    {  83,  9,  22},
    { 347,  9,  23},
    {  84,  9,  23},
    { 348,  9,  24},
    {  85,  9,  24},
    { 349,  9,  25},
    {  95,  9,  25},
    { 350,  9,  26},
    { 100,  9,  26},
    { 351,  9,  27},
    { 101,  9,  27},
    { 352,  9,  28},
    { 102,  9,  28},
    { 353,  9,  29},
    { 103,  9,  29},
    { 354,  9,  30},
    { 104,  9,  30},
    { 355,  9,  31},
    { 105,  9,  31},
    { 356,  9,  32},
    { 157,  9,  32},
    { 357,  9,  33},
    { 165,  9,  33},
    { 322,  9,  34},
    {  31,  9,  34},
    { 323,  9,  35},
    {  32,  9,  35},
    { 325,  9,  36},
    {  36,  9,  36},
    { 327,  9,  37},
    {  38,  9,  37},
    { 328,  9,  38},
    {  39,  9,  38},
    { 330,  9,  39},
    {  42,  9,  39},
    { 331,  9,  40},
    {  43,  9,  40},
    { 231,  9,  41},
    {  62,  9,  41},
    { 226,  9,  41},
    { 229,  9,  42},
    {  64,  9,  42},
    { 224,  9,  42},
    { 230,  9,  43},
    {  65,  9,  43},
    { 225,  9,  43},
    { 254,  9,  44},
    {  67,  9,  44},
    { 268,  9,  44},
    { 253,  9,  45},
    {  69,  9,  45},
    { 236,  9,  45},
    { 255,  9,  46},
    {  70,  9,  46},
    { 283,  9,  46},
    { 797,  9,  47},
    {  71,  9,  47},
    { 769,  9,  47},
    {1156,  9,  48},
    {  72,  9,  48},
    {1148,  9,  48},
    { 168,  9,  49},
    {  73,  9,  49},
    { 181,  9,  49},
    { 167,  9,  50},
    {  75,  9,  50},
    { 166,  9,  50},
    { 169,  9,  51},
    {  76,  9,  51},
    { 201,  9,  51},
    { 506,  9,  52},
    {  77,  9,  52},
    { 479,  9,  52},
    { 505,  9,  53},
    {  78,  9,  53},
    { 474,  9,  53},
    { 714,  9,  54},
    {  80,  9,  54},
    { 717,  9,  54},
    { 332,  9,  55},
    {  44,  9,  55},
    { 232,  9,  56},
    {  57,  9,  56},
    { 227,  9,  56},
    {1004, 10,   0},
    { 307, 10,   1},
    { 304, 10,   1},
    { 420, 10,   2},
    { 409, 10,   2},
    { 579, 10,   3},
    {1001, 10,   4},
    { 978, 10,   4},
    { 705, 10,   5},
    { 704, 10,   5},
    { 914, 10,   6},
    { 911, 10,   6},
    { 574, 10,   7},
    { 573, 10,   7},
    { 719, 10,   8},
    { 718, 10,   8},
    { 372, 10,   9},
    { 538, 10,   9},
    {1251, 10,  10},
    {1247, 10,  10},
    {1242, 10,  11},
    {1361, 10,  12},
    {1360, 10,  12},
    {1381, 10,  13},
    { 977, 10,  14},
    { 975, 10,  14},
    {1215, 10,  15},
    {1220, 10,  15},
    {1238, 10,  16},
    {1237, 10,  16},
    { 582, 10,  17},
    { 581, 10,  17},
    { 982, 11,   0},
    { 968, 11,   0},
    { 193, 11,   1},
    { 166, 11,   1},
    { 639, 11,   2},
    { 633, 11,   2},
    {1381, 11,   3},
    {1373, 11,   3},
    { 584, 11,   4},
    { 568, 11,   4},
    { 977, 11,   5},
    { 970, 11,   5},
    {1002, 12,   0},
    { 180, 12,   1},
    { 182, 12,   2},
    { 185, 12,   3},
    { 252, 12,   4},
    { 258, 12,   5},
    { 475, 12,   6},
    { 476, 12,   7},
    { 514, 12,   8},
    { 572, 12,   9},
    { 576, 12,  10},
    { 585, 12,  11},
    { 586, 12,  12},
    { 636, 12,  13},
    { 641, 12,  14},
    {1307, 12,  14},
    { 659, 12,  15},
    { 663, 12,  16},
    { 664, 12,  17},
    { 665, 12,  18},
    { 737, 12,  19},
    { 750, 12,  20},
    { 766, 12,  21},
    { 771, 12,  22},
    { 772, 12,  23},
    { 915, 12,  24},
    { 929, 12,  25},
    {1009, 12,  26},
    {1025, 12,  27},
    {1099, 12,  28},
    {1142, 12,  29},
    {1143, 12,  30},
    {1152, 12,  31},
    {1154, 12,  32},
    {1175, 12,  33},
    {1176, 12,  34},
    {1190, 12,  35},
    {1192, 12,  36},
    {1202, 12,  37},
    {1269, 12,  38},
    {1287, 12,  39},
    {1305, 12,  40},
    {1306, 12,  41},
    {1312, 12,  42},
    {1377, 12,  43},
    {1281, 12,  44},
    {1398, 12,  45},
    {1399, 12,  46},
    {1400, 12,  47},
    {1408, 12,  48},
    {1409, 12,  49},
    {1412, 12,  50},
    {1415, 12,  51},
    { 756, 12,  52},
    { 571, 12,  53},
    { 298, 12,  54},
    { 570, 12,  55},
    {1028, 12,  56},
    {1167, 12,  57},
    {1241, 12,  58},
    { 869, 12,  59},
    { 870, 12,  60},
    { 871, 12,  61},
    { 872, 12,  62},
    { 873, 12,  63},
    { 874, 12,  64},
    { 875, 12,  65},
    { 876, 12,  66},
    { 877, 12,  67},
    { 878, 12,  68},
    { 879, 12,  69},
    { 880, 12,  70},
    { 881, 12,  71},
    { 882, 12,  72},
    { 883, 12,  73},
    { 884, 12,  74},
    { 885, 12,  75},
    { 886, 12,  76},
    { 887, 12,  77},
    { 888, 12,  78},
    { 889, 12,  79},
    { 890, 12,  80},
    { 891, 12,  81},
    { 892, 12,  82},
    { 893, 12,  83},
    { 894, 12,  84},
    { 895, 12,  85},
    { 173, 12,  86},
    { 175, 12,  87},
    { 174, 12,  88},
    { 857, 12,  89},
    { 854, 12,  90},
    { 860, 12,  91},
    { 863, 12,  92},
    { 858, 12,  93},
    { 859, 12,  94},
    { 853, 12,  95},
    { 861, 12,  96},
    { 855, 12,  97},
    { 856, 12,  98},
    { 862, 12,  99},
    { 654, 12, 100},
    { 653, 12, 101},
    {1006, 13,   0},
    {1337, 13,   0},
    { 729, 13,   1},
    { 301, 13,   1},
    { 511, 13,   2},
    { 473, 13,   2},
    {1157, 13,   3},
    {1148, 13,   3},
    { 799, 13,   4},
    { 769, 13,   4},
    {1333, 13,   5},
    {1282, 13,   5},
    {1347, 14,   0},
    {1396, 14,   0},
    {1053, 14,   1},
    {1052, 14,   1},
    { 404, 14,   2},
    { 401, 14,   2},
    {1146, 14,   3},
    {1145, 14,   3},
    { 607, 14,   4},
    { 602, 14,   4},
    {1008, 14,   5},
    {1013, 14,   5},
    { 562, 14,   6},
    { 561, 14,   6},
    { 293, 14,   7},
    {1270, 14,   7},
    { 702, 14,   8},
    { 717, 14,   8},
    {1127, 14,   9},
    {1126, 14,   9},
    {1124, 14,  10},
    {1117, 14,  10},
    {1022, 14,  11},
    {1017, 14,  11},
    { 189, 14,  12},
    { 181, 14,  12},
    { 686, 14,  13},
    { 682, 14,  13},
    { 711, 14,  14},
    { 697, 14,  14},
    { 712, 14,  14},
    { 681, 14,  15},
    { 680, 14,  15},
    { 415, 14,  16},
    { 405, 14,  16},
    { 291, 14,  17},
    { 250, 14,  17},
    { 290, 14,  18},
    { 238, 14,  18},
    {1231, 14,  19},
    {1230, 14,  19},
    { 866, 14,  20},
    { 267, 14,  20},
    { 313, 14,  21},
    { 448, 14,  21},
    { 819, 14,  22},
    { 809, 14,  22},
    { 438, 14,  23},
    { 318, 14,  23},
    { 422, 14,  24},
    {1174, 14,  24},
    { 193, 14,  25},
    { 179, 14,  25},
    { 292, 14,  26},
    { 237, 14,  26},
    {1267, 14,  27},
    {1197, 14,  27},
    {1422, 14,  28},
    {1420, 14,  28},
    { 986, 14,  29},
    { 998, 14,  29},
    {1385, 14,  30},
    {1382, 14,  30},
    { 727, 14,  31},
    { 735, 14,  32},
    { 734, 14,  33},
    { 634, 14,  34},
    { 635, 14,  35},
    { 403, 14,  36},
    { 446, 14,  36},
    { 662, 14,  37},
    { 673, 14,  37},
    { 423, 14,  38},
    { 373, 14,  38},
    {1150, 14,  39},
    {1155, 14,  39},
    { 519, 14,  40},
    { 518, 14,  40},
    { 530, 14,  41},
    { 529, 14,  41},
    {1421, 14,  42},
    {1004, 15,   0},
    {1022, 15,   1},
    {1017, 15,   1},
    { 499, 15,   2},
    { 492, 15,   2},
    { 481, 15,   3},
    { 480, 15,   3},
    { 972, 16,   0},
    {   0, 16,   1},
    {   1, 16,   2},
    {  11, 16,   3},
    {   6, 16,   4},
    {  19, 16,   5},
    {  16, 16,   6},
    {  13, 16,   7},
    {  10, 16,   8},
    {  94, 16,   9},
    {  92, 16,  10},
    {   8, 16,  11},
    {   5, 16,  12},
    {   4, 16,  13},
    {   3, 16,  14},
    {  20, 16,  15},
    {  18, 16,  16},
    {  17, 16,  17},
    {  89, 16,  18},
    {  15, 16,  19},
    {  87, 16,  20},
    {  14, 16,  21},
    {  12, 16,  22},
    {   9, 16,  23},
    {  93, 16,  24},
    {  55, 16,  25},
    { 127, 16,  26},
    {   7, 16,  27},
    { 143, 16,  28},
    {  91, 16,  29},
    { 130, 16,  30},
    {  54, 16,  31},
    {  90, 16,  32},
    { 110, 16,  33},
    { 129, 16,  34},
    { 145, 16,  35},
    {  34, 16,  36},
    {   2, 16,  37},
    {  88, 16,  38},
    {  53, 16,  39},
    { 128, 16,  40},
    {  86, 16,  41},
    { 144, 16,  42},
    { 109, 16,  43},
    { 159, 16,  44},
    { 126, 16,  45},
    {  35, 16,  46},
    { 136, 16,  47},
    {  41, 16,  48},
    { 142, 16,  49},
    {  47, 16,  50},
    { 151, 16,  51},
    {  50, 16,  52},
    { 158, 16,  53},
    {  21, 16,  54},
    {  33, 16,  55},
    {  37, 16,  56},
    {  40, 16,  57},
    {  45, 16,  58},
    {  46, 16,  59},
    {  48, 16,  60},
    {  49, 16,  61},
    {  51, 16,  62},
    {  52, 16,  63},
    {  56, 16,  64},
    {  63, 16,  65},
    {  68, 16,  66},
    {  74, 16,  67},
    {  79, 16,  68},
    {  81, 16,  69},
    {  82, 16,  70},
    {  83, 16,  71},
    {  84, 16,  72},
    {  85, 16,  73},
    {  95, 16,  74},
    { 100, 16,  75},
    { 101, 16,  76},
    { 102, 16,  77},
    { 103, 16,  78},
    { 104, 16,  79},
    { 105, 16,  80},
    { 106, 16,  81},
    { 107, 16,  82},
    { 108, 16,  83},
    { 111, 16,  84},
    { 116, 16,  85},
    { 117, 16,  86},
    { 118, 16,  87},
    { 120, 16,  88},
    { 121, 16,  89},
    { 122, 16,  90},
    { 123, 16,  91},
    { 124, 16,  92},
    { 125, 16,  93},
    { 131, 16,  94},
    { 137, 16,  95},
    { 146, 16,  96},
    { 152, 16,  97},
    { 160, 16,  98},
    {  22, 16,  99},
    {  57, 16, 100},
    {  96, 16, 101},
    { 112, 16, 102},
    { 132, 16, 103},
    { 138, 16, 104},
    { 147, 16, 105},
    { 153, 16, 106},
    { 161, 16, 107},
    {  23, 16, 108},
    {  58, 16, 109},
    {  97, 16, 110},
    { 113, 16, 111},
    { 133, 16, 112},
    { 139, 16, 113},
    { 148, 16, 114},
    { 154, 16, 115},
    { 162, 16, 116},
    {  24, 16, 117},
    {  59, 16, 118},
    {  98, 16, 119},
    { 114, 16, 120},
    { 134, 16, 121},
    { 140, 16, 122},
    { 149, 16, 123},
    { 155, 16, 124},
    { 163, 16, 125},
    {  25, 16, 126},
    {  60, 16, 127},
    {  66, 16, 128},
    {  99, 16, 129},
    { 115, 16, 130},
    { 119, 16, 131},
    { 135, 16, 132},
    { 141, 16, 133},
    { 150, 16, 134},
    { 156, 16, 135},
    { 164, 16, 136},
    {  26, 16, 137},
    {  27, 16, 138},
    {  61, 16, 139},
    {  28, 16, 140},
    {  29, 16, 141},
    {  30, 16, 142},
    { 970, 17,   0},
    {1156, 17,   1},
    { 797, 17,   2},
    {1365, 17,   3},
    { 798, 17,   4},
    {1326, 17,   5},
    { 278, 17,   6},
    {1327, 17,   7},
    {1331, 17,   8},
    {1329, 17,   9},
    {1330, 17,  10},
    { 280, 17,  11},
    { 279, 17,  12},
    {1328, 17,  13},
    {1081, 17,  14},
    {1063, 18,   0},
    { 266, 18,   1},
    {1364, 18,   2},
    { 233, 18,   3},
    {1018, 18,   4},
    {1363, 18,   5},
    {1139, 18,   6},
    { 713, 18,   7},
    {1368, 18,   8},
    {1367, 18,   9},
    {1366, 18,  10},
    { 432, 18,  11},
    { 425, 18,  12},
    { 426, 18,  13},
    { 437, 18,  14},
    { 434, 18,  15},
    { 433, 18,  16},
    { 429, 18,  17},
    { 436, 18,  18},
    { 435, 18,  19},
    { 431, 18,  20},
    { 427, 18,  21},
    { 428, 18,  22},
    { 950, 18,  23},
    {1324, 18,  24},
    {1325, 18,  25},
    { 590, 18,  26},
    { 310, 18,  27},
    {1151, 18,  28},
    {1271, 18,  29},
    { 430, 18,  30},
    {1005, 18,  31},
    { 731, 18,  32},
    {1021, 18,  33},
    {1019, 18,  34},
    { 286, 18,  35},
    { 999, 19,   0},
    {1401, 19,   1},
    {1401, 20,   0},
    {1397, 20,   0},
    { 999, 20,   1},
    { 968, 20,   1},
    {1401, 21,   0},
    {1397, 21,   0},
    { 999, 21,   1},
    { 968, 21,   1},
    { 907, 21,   2},
    { 844, 21,   2},
};

/* property values: 6272 bytes. */

/* Codepoints which expand on full case-folding. */

RE_UINT16 re_expand_on_folding[] = {
      223,   304,   329,   496,   912,   944,  1415,  7830,
     7831,  7832,  7833,  7834,  7838,  8016,  8018,  8020,
     8022,  8064,  8065,  8066,  8067,  8068,  8069,  8070,
     8071,  8072,  8073,  8074,  8075,  8076,  8077,  8078,
     8079,  8080,  8081,  8082,  8083,  8084,  8085,  8086,
     8087,  8088,  8089,  8090,  8091,  8092,  8093,  8094,
     8095,  8096,  8097,  8098,  8099,  8100,  8101,  8102,
     8103,  8104,  8105,  8106,  8107,  8108,  8109,  8110,
     8111,  8114,  8115,  8116,  8118,  8119,  8124,  8130,
     8131,  8132,  8134,  8135,  8140,  8146,  8147,  8150,
     8151,  8162,  8163,  8164,  8166,  8167,  8178,  8179,
     8180,  8182,  8183,  8188, 64256, 64257, 64258, 64259,
    64260, 64261, 64262, 64275, 64276, 64277, 64278, 64279,
};

/* expand_on_folding: 208 bytes. */

/* General_Category. */

static RE_UINT8 re_general_category_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 27, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 28,
    29, 26, 30, 31, 32, 33, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 34, 35, 35, 35, 35,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 37, 38, 39, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
    26, 57, 58, 59, 59, 59, 59, 59, 26, 26, 60, 59, 59, 59, 59, 59,
    59, 59, 26, 61, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 26, 62, 59, 63, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 64, 26, 65, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 66, 67, 59, 59, 59, 59, 68, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 69, 70, 71, 72, 73, 74, 59, 59,
    75, 76, 59, 59, 77, 59, 78, 79, 80, 81, 73, 82, 83, 84, 59, 59,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 85, 26, 26, 26, 26, 26, 26, 26, 86, 87, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 88, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 89, 59, 59, 59, 59, 59, 59, 26, 90, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    91, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 92,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 92,
};

static RE_UINT16 re_general_category_stage_2[] = {
      0,   0,   1,   2,   3,   4,   5,   6,   0,   0,   7,   8,   9,  10,  11,  12,
     13,  13,  13,  14,  15,  13,  13,  16,  17,  18,  19,  20,  21,  22,  13,  23,
     13,  13,  13,  24,  25,  11,  11,  11,  11,  26,  11,  27,  28,  29,  30,  31,
     32,  32,  32,  32,  32,  32,  32,  33,  34,  35,  36,  11,  37,  38,  13,  39,
      9,   9,   9,  11,  11,  11,  13,  13,  40,  13,  13,  13,  41,  13,  13,  13,
     13,  13,  13,  42,   9,  43,  11,  11,  44,  45,  32,  46,  47,  48,  49,  50,
     51,  52,  48,  48,  53,  32,  54,  55,  48,  48,  48,  48,  48,  56,  57,  58,
     59,  60,  48,  32,  61,  48,  48,  48,  48,  48,  62,  63,  64,  48,  65,  66,
     48,  67,  68,  69,  48,  70,  71,  72,  72,  72,  48,  73,  72,  74,  75,  32,
     76,  48,  48,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
     90,  83,  84,  91,  92,  93,  94,  95,  96,  97,  84,  98,  99, 100,  88, 101,
    102,  83,  84, 103, 104, 105,  88, 106, 107, 108, 109, 110, 111, 112,  94, 113,
    114, 115,  84, 116, 117, 118,  88, 119, 120, 115,  84, 121, 122, 123,  88, 124,
    125, 115,  48, 126, 127, 128,  88, 129, 130, 131,  48, 132, 133, 134,  94, 135,
    136,  48,  48, 137, 138, 139,  72,  72, 140,  48, 141, 142, 143, 144,  72,  72,
    145, 146, 147, 148, 149,  48, 150, 151, 152, 153,  32, 154, 155, 156,  72,  72,
     48,  48, 157, 158, 159, 160, 161, 162, 163, 164,   9,   9, 165,  11,  11, 166,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48, 167, 168,  48,  48, 167,  48,  48, 169, 170, 171,  48,  48,
     48, 170,  48,  48,  48, 172, 173, 174,  48, 175,   9,   9,   9,   9,   9, 176,
    177,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48, 178,  48, 179, 180,  48,  48,  48,  48, 181, 182,
    183, 184,  48, 185,  48, 186, 183, 187,  48,  48,  48, 188, 189, 190, 191, 192,
    193, 191,  48,  48, 194,  48,  48, 195, 196,  48, 197,  48,  48,  48,  48, 198,
     48, 199, 200, 201, 202,  48, 203, 204,  48,  48, 205,  48, 206, 207, 208, 208,
     48, 209,  48,  48,  48, 210, 211, 212, 191, 191, 213, 214,  72,  72,  72,  72,
    215,  48,  48, 216, 217, 159, 218, 219, 220,  48, 221,  64,  48,  48, 222, 223,
     48,  48, 224, 225, 226,  64,  48, 227, 228,   9,   9, 229, 230, 231, 232, 233,
     11,  11, 234,  27,  27,  27, 235, 236,  11, 237,  27,  27,  32,  32,  32, 238,
     13,  13,  13,  13,  13,  13,  13,  13,  13, 239,  13,  13,  13,  13,  13,  13,
    240, 241, 240, 240, 241, 242, 240, 243, 244, 244, 244, 245, 246, 247, 248, 249,
    250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 260,  72, 261, 262, 263,
    264, 265, 266, 267, 268, 269, 270, 270, 271, 272, 273, 208, 274, 275, 208, 276,
    277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277,
    278, 208, 279, 208, 208, 208, 208, 280, 208, 281, 277, 282, 208, 283, 284, 208,
    208, 208, 285,  72, 286,  72, 269, 269, 269, 287, 208, 208, 208, 208, 288, 269,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 289, 290, 208, 208, 291,
    208, 208, 208, 208, 208, 208, 292, 208, 208, 208, 208, 208, 208, 208, 208, 208,
    208, 208, 208, 208, 208, 208, 293, 294, 269, 295, 208, 208, 296, 277, 297, 277,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208,
    277, 277, 277, 277, 277, 277, 277, 277, 298, 299, 277, 277, 277, 300, 277, 301,
    277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277,
    208, 208, 208, 277, 302, 208, 208, 303, 208, 304, 208, 208, 208, 208, 208, 208,
      9,   9, 305,  11,  11, 306, 307, 308,  13,  13,  13,  13,  13,  13, 309, 310,
     11,  11, 311,  48,  48,  48, 312, 313,  48, 314, 315, 315, 315, 315,  32,  32,
    316, 317, 318, 319, 320,  72,  72,  72, 208, 321, 208, 208, 208, 208, 208, 322,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 323,  72, 324,
    325, 326, 327, 328, 136,  48,  48,  48,  48, 329, 177,  48,  48,  48,  48, 330,
    331,  48,  48, 136,  48,  48,  48,  48, 199, 332,  48,  71, 208, 208, 322,  48,
    208, 333, 334, 208, 335, 336, 208, 208, 334, 208, 208, 336, 208, 208, 208, 208,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 198, 208, 208, 208, 208,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  72,
     48, 337,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48, 150, 208, 208, 208, 285,  48,  48, 227,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
    338,  48, 339,  72,  13,  13, 340, 341,  13, 342,  48,  48,  48,  48, 343, 344,
     31, 345, 346, 347,  13,  13,  13, 348, 349, 350, 351, 352, 353,  72,  72, 354,
    355,  48, 356, 357,  48,  48,  48, 358, 359,  48,  48, 360, 361, 191,  32, 362,
     64,  48, 363,  48, 364, 365,  48, 150,  76,  48,  48, 366, 367, 368, 369, 370,
     48,  48, 371, 372, 373, 374,  48, 375,  48,  48,  48, 376, 377, 378, 379, 380,
    381, 382, 315,  11,  11, 383, 384,  11,  11,  11,  11,  11,  48,  48, 385, 191,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 386,  48, 387,  48,  48, 205,
    388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388,
    388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388, 388,
    389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389,
    389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389,
    389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48, 203,  48,  48,  48,  48,  48,  48, 206,  72,  72,
    390, 391, 392, 393, 394,  48,  48,  48,  48,  48,  48, 395, 396, 397,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48, 398,  72,  48,  48,  48,  48, 399,  48,  48, 400,  72,  72, 401,
     32, 402,  32, 403, 404, 405, 406, 407,  48,  48,  48,  48,  48,  48,  48, 408,
    409,   2,   3,   4,   5, 410, 411, 412,  48, 413,  48, 199, 414, 415, 416, 417,
    418,  48, 171, 419, 203, 203,  72,  72,  48,  48,  48,  48,  48,  48,  48,  71,
    420, 269, 269, 421, 270, 270, 270, 422, 423, 324, 424,  72,  72, 208, 208, 425,
     72,  72,  72,  72,  72,  72,  72,  72,  48, 150,  48,  48,  48, 100, 426, 427,
     48,  48, 428,  48, 429,  48,  48, 430,  48, 431,  48,  48, 432, 433,  72,  72,
      9,   9, 434,  11,  11,  48,  48,  48,  48, 203, 191,   9,   9, 435,  11, 436,
     48,  48, 400,  48,  48,  48, 437,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48, 314,  48, 198, 400,  72,  72,  72,  72,  72,  72,  72,  72,  72,
    438,  48,  48, 439,  48, 440,  48, 441,  48, 199, 442,  72,  72,  72,  48, 443,
     48, 444,  48, 445,  72,  72,  72,  72,  48,  48,  48, 446, 269, 447, 269, 269,
    448, 449,  48, 450, 451, 452,  48, 453,  48, 454,  72,  72, 455,  48, 456, 457,
     48,  48,  48, 458,  48, 459,  48, 460,  48, 461, 462,  72,  72,  72,  72,  72,
     48,  48,  48,  48, 195,  72,  72,  72,   9,   9,   9, 463,  11,  11,  11, 464,
     48,  48, 465, 191,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72, 269, 466,  72,  72,  72,  72,  72,  72,  72,  72,
     48, 454, 467,  48,  62, 468,  72,  72,  72,  72,  72,  72,  72,  72,  48, 314,
    469,  48,  48, 470, 471, 447, 472, 473, 220,  48,  48, 474, 475,  48, 195, 191,
    476,  48, 477, 478, 479,  48,  48, 480, 220,  48,  48, 481, 482, 483, 484, 485,
     48,  97, 486, 487,  72,  72,  72,  72, 488, 489, 490,  48,  48, 491, 492, 191,
    493,  83,  84, 494, 495, 496, 497, 498,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48, 499, 500, 501,  72,  72,  48,  48,  48, 502, 503, 191,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  48,  48, 504, 505, 506, 507,  72,  72,
     48,  48,  48, 508, 509, 191, 510,  72,  48,  48, 511, 512, 191,  72,  72,  72,
     48, 172, 513, 514,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48, 486, 515,  72,  72,  72,  72,  72,  72,   9,   9,  11,  11, 147, 516,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72, 517,  48,  48, 518, 519,  72,
    520,  48,  48, 521, 522, 523,  48,  48, 524, 525, 526,  72,  48,  48,  48, 195,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     84,  48, 504, 527, 528, 147, 174, 529,  48, 530, 531, 532,  72,  72,  72,  72,
    533,  48,  48, 534, 535, 191, 536,  48, 537, 538, 191,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  48, 539,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72, 269, 540, 541, 542,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48, 206,  72,  72,  72,  72,  72,  72,
    270, 270, 270, 270, 270, 270, 543, 544,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48, 386,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48, 199, 545,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48,  48, 314,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48, 195,  48, 199, 368,  72,  72,  72,  72,  72,  72,  48, 203, 546,
     48,  48,  48, 547, 548, 549, 550, 551,  48,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,   9,   9,  11,  11, 269, 552,  72,  72,  72,  72,  72,  72,
     48,  48,  48,  48, 553, 554, 555, 555, 556, 557,  72,  72,  72,  72, 558,  72,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 400,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 559,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48, 199,  72,  72,  72, 559, 560,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 205,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48,  48,  48,  48,  71, 150, 195, 561, 562,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 323,
    208, 208, 563, 208, 208, 208, 564, 565, 566, 208, 567, 208, 208, 208, 568,  72,
    208, 208, 208, 208, 569,  72,  72,  72,  72,  72,  72,  72,  72,  72, 269, 570,
    208, 208, 208, 208, 208, 285, 269, 451,  72,  72,  72,  72,  72,  72,  72,  72,
      9, 571,  11, 572, 573, 574, 240,   9, 575, 576, 577, 578, 579,   9, 571,  11,
    580, 581,  11, 582, 583, 584, 585,   9, 586,  11,   9, 571,  11, 572, 573,  11,
    240,   9, 575, 585,   9, 586,  11,   9, 571,  11, 587,   9, 588, 589, 590, 591,
     11, 592,   9, 593, 594, 595, 596,  11, 597,   9, 598,  11, 599, 600, 600, 600,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208,
     32,  32,  32, 601,  32,  32, 602, 603, 604, 605,  45,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
    606, 607, 608,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48, 150, 609, 610,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  48,  48, 611, 612,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 613, 614,  72,  72,
      9,   9, 575,  11, 615, 368,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72, 484, 269, 269, 616, 617,  72,  72,  72,  72,
    484, 269, 618, 619,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
    620,  48, 621, 622, 623, 624, 625, 626, 627, 205, 628, 205,  72,  72,  72, 629,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
    208, 208, 324, 208, 208, 208, 208, 208, 208, 322, 333, 630, 630, 630, 208, 323,
    174, 208, 208, 208, 208, 208, 631, 208, 208, 208, 631,  72,  72,  72, 632, 208,
    633, 208, 208, 324, 568, 634, 323,  72,  72,  72,  72,  72,  72,  72,  72,  72,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 635,
    208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 323, 631, 286,
    208, 208, 208, 208, 208, 208, 208, 322, 208, 208, 208, 208, 208, 568, 324,  72,
    324, 208, 208, 208, 636, 175, 208, 208, 636, 208, 637,  72,  72,  72,  72,  72,
    638, 208, 208, 208, 208, 208, 208, 639, 208, 208, 640, 208, 641, 208, 208, 208,
    208, 208, 208, 208, 208, 322, 637, 642, 633, 323,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 314,  72,  72,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48, 204,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48, 203,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 643,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48, 100,  72,
     48, 203,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,
    644,  72, 645, 645, 645, 645, 645, 645,  72,  72,  72,  72,  72,  72,  72,  72,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  72,
    389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389,
    389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 389, 646,
};

static RE_UINT8 re_general_category_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   3,   2,   4,   5,   6,   2,
      7,   7,   7,   7,   7,   2,   8,   9,  10,  11,  11,  11,  11,  11,  11,  11,
     11,  11,  11,  11,  11,  12,  13,  14,  15,  16,  16,  16,  16,  16,  16,  16,
     16,  16,  16,  16,  16,  17,  18,  19,   1,  20,  20,  21,  22,  23,  24,  25,
     26,  27,  15,   2,  28,  29,  27,  30,  11,  11,  11,  11,  11,  11,  11,  11,
     11,  11,  11,  31,  11,  11,  11,  32,  16,  16,  16,  16,  16,  16,  16,  16,
     16,  16,  16,  33,  16,  16,  16,  16,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  34,  34,  34,  34,  34,  34,  34,  34,  16,  32,  32,  32,
     32,  32,  32,  32,  11,  34,  34,  16,  34,  32,  32,  11,  34,  11,  16,  11,
     11,  34,  32,  11,  32,  16,  11,  34,  32,  32,  32,  11,  34,  16,  32,  11,
     34,  11,  34,  34,  32,  35,  32,  16,  36,  36,  37,  34,  38,  37,  34,  34,
     34,  34,  34,  34,  34,  34,  16,  32,  34,  38,  32,  11,  32,  32,  32,  32,
     32,  32,  16,  16,  16,  11,  34,  32,  34,  34,  11,  32,  32,  32,  32,  32,
     16,  16,  39,  16,  16,  16,  16,  16,  40,  40,  40,  40,  40,  40,  40,  40,
     40,  41,  41,  40,  40,  40,  40,  40,  40,  41,  41,  41,  41,  41,  41,  41,
     40,  40,  42,  41,  41,  41,  42,  42,  41,  41,  41,  41,  41,  41,  41,  41,
     43,  43,  43,  43,  43,  43,  43,  43,  32,  32,  42,  32,  44,  45,  16,  10,
     44,  44,  41,  46,  11,  47,  47,  11,  34,  11,  11,  11,  11,  11,  11,  11,
     11,  48,  11,  11,  11,  11,  16,  16,  16,  16,  16,  16,  16,  16,  16,  34,
     16,  11,  32,  16,  32,  32,  32,  32,  16,  16,  32,  49,  34,  32,  34,  11,
     32,  50,  43,  43,  51,  32,  32,  32,  11,  34,  34,  34,  34,  34,  34,  16,
     48,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  47,  52,   2,   2,   2,
     16,  16,  16,  16,  53,  54,  55,  56,  57,  43,  43,  43,  43,  43,  43,  43,
     43,  43,  43,  43,  43,  43,  43,  58,  59,  60,  43,  59,  44,  44,  44,  44,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,  44,  62,
     36,  63,  64,  44,  44,  44,  44,  44,  65,  65,  65,   8,   9,  66,   2,  67,
     43,  43,  43,  43,  43,  60,  68,   2,  69,  36,  36,  36,  36,  70,  43,  43,
      7,   7,   7,   7,   7,   2,   2,  36,  71,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  72,  43,  43,  43,  73,  50,  43,  43,  74,  75,  76,  43,  43,  36,
      7,   7,   7,   7,   7,  36,  77,  78,   2,   2,   2,   2,   2,   2,   2,  79,
     70,  36,  36,  36,  36,  36,  36,  36,  43,  43,  43,  43,  43,  80,  62,  36,
     36,  36,  36,  43,  43,  43,  43,  43,  71,  44,  44,  44,  44,  44,  44,  44,
      7,   7,   7,   7,   7,  36,  36,  36,  36,  36,  36,  36,  36,  70,  43,  43,
     43,  43,  40,  21,   2,  81,  57,  20,  36,  36,  36,  43,  43,  75,  43,  43,
     43,  43,  75,  43,  75,  43,  43,  44,   2,   2,   2,   2,   2,   2,   2,  64,
     36,  36,  36,  36,  70,  43,  44,  64,  36,  36,  36,  36,  36,  61,  44,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  36,  36,  61,  36,  36,  36,  36,  44,
     44,  57,  43,  43,  43,  43,  43,  43,  43,  82,  43,  43,  43,  43,  43,  43,
     43,  83,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  83,  71,  84,
     85,  43,  43,  43,  83,  84,  85,  84,  70,  43,  43,  43,  36,  36,  36,  36,
     36,  43,   2,   7,   7,   7,   7,   7,  86,  36,  36,  36,  36,  36,  36,  36,
     70,  84,  62,  36,  36,  36,  61,  62,  61,  62,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  61,  36,  36,  36,  61,  61,  44,  36,  36,  44,  71,  84,
     85,  43,  80,  87,  88,  87,  85,  61,  44,  44,  44,  87,  44,  44,  36,  62,
     36,  43,  44,   7,   7,   7,   7,   7,  36,  20,  27,  27,  27,  56,  63,  80,
     57,  83,  62,  36,  36,  61,  44,  62,  61,  36,  62,  61,  36,  44,  80,  84,
     85,  80,  44,  57,  80,  57,  43,  44,  57,  44,  44,  44,  62,  36,  61,  61,
     44,  44,  44,   7,   7,   7,   7,   7,  43,  36,  70,  64,  44,  44,  44,  44,
     57,  83,  62,  36,  36,  36,  36,  62,  36,  62,  36,  36,  36,  36,  36,  36,
     61,  36,  62,  36,  36,  44,  71,  84,  85,  43,  43,  57,  83,  87,  85,  44,
     61,  44,  44,  44,  44,  44,  44,  44,  66,  44,  44,  44,  62,  43,  43,  43,
     57,  84,  62,  36,  36,  36,  61,  62,  61,  36,  62,  36,  36,  44,  71,  85,
     85,  43,  80,  87,  88,  87,  85,  44,  44,  44,  44,  83,  44,  44,  36,  62,
     78,  27,  27,  27,  44,  44,  44,  44,  44,  71,  62,  36,  36,  61,  44,  36,
     61,  36,  36,  44,  62,  61,  61,  36,  44,  62,  61,  44,  36,  61,  44,  36,
     36,  36,  36,  36,  36,  44,  44,  84,  83,  88,  44,  84,  88,  84,  85,  44,
     61,  44,  44,  87,  44,  44,  44,  44,  27,  89,  67,  67,  56,  90,  44,  44,
     83,  84,  71,  36,  36,  36,  61,  36,  61,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  44,  62,  43,  83,  84,  88,  43,  80,  43,  43,  44,
     44,  44,  57,  80,  36,  61,  44,  44,  44,  44,  44,  91,  27,  27,  27,  89,
     70,  84,  72,  36,  36,  36,  61,  36,  36,  36,  62,  36,  36,  44,  71,  85,
     84,  84,  88,  83,  88,  84,  43,  44,  44,  44,  87,  88,  44,  44,  44,  61,
     62,  61,  44,  44,  44,  44,  44,  44,  43,  84,  62,  36,  36,  36,  61,  36,
     36,  36,  36,  36,  36,  70,  71,  84,  85,  43,  80,  84,  88,  84,  85,  77,
     44,  44,  36,  92,  27,  27,  27,  93,  27,  27,  27,  27,  89,  36,  36,  36,
     44,  84,  62,  36,  36,  36,  36,  36,  36,  36,  36,  61,  44,  36,  36,  36,
     36,  62,  36,  36,  36,  36,  62,  44,  36,  36,  36,  61,  44,  80,  44,  87,
     84,  43,  80,  80,  84,  84,  84,  84,  44,  84,  64,  44,  44,  44,  44,  44,
     62,  36,  36,  36,  36,  36,  36,  36,  70,  36,  43,  43,  43,  80,  44,  94,
     36,  36,  36,  75,  43,  43,  43,  60,   7,   7,   7,   7,   7,   2,  44,  44,
     62,  61,  61,  36,  36,  61,  36,  36,  36,  36,  62,  62,  36,  36,  36,  36,
     70,  36,  43,  43,  43,  43,  71,  44,  36,  36,  61,  81,  43,  43,  43,  44,
      7,   7,   7,   7,   7,  44,  36,  36,  77,  67,   2,   2,   2,   2,   2,   2,
      2,  95,  95,  67,  43,  67,  67,  67,   7,   7,   7,   7,   7,  27,  27,  27,
     27,  27,  50,  50,  50,   4,   4,  84,  36,  36,  36,  36,  62,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  61,  44,  57,  43,  43,  43,  43,  43,  43,  83,
     43,  43,  60,  43,  36,  36,  70,  43,  43,  43,  43,  43,  57,  43,  43,  43,
     43,  43,  43,  43,  43,  43,  80,  67,  67,  67,  67,  76,  67,  67,  90,  67,
      2,   2,  95,  67,  21,  64,  44,  44,  36,  36,  36,  36,  36,  92,  85,  43,
     83,  43,  43,  43,  85,  83,  85,  71,   7,   7,   7,   7,   7,   2,   2,   2,
     36,  36,  36,  84,  43,  36,  36,  43,  71,  84,  96,  92,  84,  84,  84,  36,
     70,  43,  71,  36,  36,  36,  36,  36,  36,  83,  85,  83,  84,  84,  85,  92,
      7,   7,   7,   7,   7,  84,  85,  67,  11,  11,  11,  48,  44,  44,  48,  44,
     16,  16,  16,  16,  16,  53,  45,  16,  36,  36,  36,  36,  61,  36,  36,  44,
     36,  36,  36,  61,  61,  36,  36,  44,  61,  36,  36,  44,  36,  36,  36,  61,
     61,  36,  36,  44,  36,  36,  36,  36,  36,  36,  36,  61,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  61,  57,  43,   2,   2,   2,   2,  97,  27,  27,  27,
     27,  27,  27,  27,  27,  27,  98,  44,  67,  67,  67,  67,  67,  44,  44,  44,
     11,  11,  11,  44,  16,  16,  16,  44,  99,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  77,  72, 100,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36, 101, 102,  44,  36,  36,  36,  36,  36,  63,   2, 103,
    104,  36,  36,  36,  61,  44,  44,  44,  36,  36,  36,  36,  36,  36,  61,  36,
     36,  43,  80,  44,  44,  44,  44,  44,  36,  43,  60,  64,  44,  44,  44,  44,
     36,  43,  44,  44,  44,  44,  44,  44,  61,  43,  44,  44,  44,  44,  44,  44,
     36,  36,  43,  85,  43,  43,  43,  84,  84,  84,  84,  83,  85,  43,  43,  43,
     43,  43,   2,  86,   2,  66,  70,  44,   7,   7,   7,   7,   7,  44,  44,  44,
     27,  27,  27,  27,  27,  44,  44,  44,   2,   2,   2, 105,   2,  59,  43,  68,
     36, 106,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,  44,  44,  44,
     36,  36,  70,  71,  36,  36,  36,  36,  36,  36,  36,  36,  70,  61,  44,  44,
     36,  36,  36,  44,  44,  44,  44,  44,  36,  36,  36,  36,  36,  36,  36,  61,
     43,  83,  84,  85,  83,  84,  44,  44,  84,  83,  84,  84,  85,  43,  44,  44,
     90,  44,   2,   7,   7,   7,   7,   7,  36,  36,  36,  36,  36,  36,  36,  44,
     36,  36,  61,  44,  44,  44,  44,  44,  36,  36,  36,  36,  36,  36,  44,  44,
     36,  36,  36,  36,  36,  44,  44,  44,   7,   7,   7,   7,   7,  98,  44,  67,
     67,  67,  67,  67,  67,  67,  67,  67,  36,  36,  36,  70,  83,  85,  44,   2,
     36,  36,  92,  83,  43,  43,  43,  80,  83,  83,  85,  43,  43,  43,  83,  84,
     84,  85,  43,  43,  43,  43,  80,  57,   2,   2,   2,  86,   2,   2,   2,  44,
     43,  43,  43,  43,  43,  43,  43, 107,  43,  43,  96,  36,  36,  36,  36,  36,
     36,  36,  83,  43,  43,  83,  83,  84,  84,  83,  96,  36,  36,  36,  44,  44,
     95,  67,  67,  67,  67,  50,  43,  43,  43,  43,  67,  67,  67,  67,  90,  44,
     43,  96,  36,  36,  36,  36,  36,  36,  92,  43,  43,  84,  43,  85,  43,  36,
     36,  36,  36,  83,  43,  84,  85,  85,  43,  84,  44,  44,  44,  44,   2,   2,
     36,  36,  84,  84,  84,  84,  43,  43,  43,  43,  84,  43,  44,  91,   2,   2,
      7,   7,   7,   7,   7,  44,  62,  36,  36,  36,  36,  36,  40,  40,  40,   2,
     16,  16,  16,  16, 108,  44,  44,  44,  11,  11,  11,  11,  11,  47,  48,  11,
      2,   2,   2,   2,  44,  44,  44,  44,  43,  60,  43,  43,  43,  43,  43,  43,
     83,  43,  43,  43,  71,  36,  70,  36,  36,  36,  71,  92,  43,  61,  44,  44,
     16,  16,  16,  16,  16,  16,  40,  40,  40,  40,  40,  40,  40,  45,  16,  16,
     16,  16,  16,  16,  45,  16,  16,  16,  16,  16,  16,  16,  16, 109,  40,  40,
     43,  43,  43,  43,  43,  57,  43,  43,  32,  32,  32,  16,  16,  16,  16,  32,
     16,  16,  16,  16,  11,  11,  11,  11,  16,  16,  16,  44,  11,  11,  11,  44,
     16,  16,  16,  16,  48,  48,  48,  48,  16,  16,  16,  16,  16,  16,  16,  44,
     16,  16,  16,  16, 110, 110, 110, 110,  16,  16, 108,  16,  11,  11, 111, 112,
     41,  16, 108,  16,  11,  11, 111,  41,  16,  16,  44,  16,  11,  11, 113,  41,
     16,  16,  16,  16,  11,  11, 114,  41,  44,  16, 108,  16,  11,  11, 111, 115,
    116, 116, 116, 116, 116, 117,  65,  65, 118, 118, 118,   2, 119, 120, 119, 120,
      2,   2,   2,   2, 121,  65,  65, 122,   2,   2,   2,   2, 123, 124,   2, 125,
    126,   2, 127, 128,   2,   2,   2,   2,   2,   9, 126,   2,   2,   2,   2, 129,
     65,  65,  68,  65,  65,  65,  65,  65, 130,  44,  27,  27,  27,   8, 127, 131,
     27,  27,  27,  27,  27,   8, 127, 102,  40,  40,  40,  40,  40,  40,  81,  44,
     20,  20,  20,  20,  20,  20,  20,  20,  43,  43,  43,  43,  43,  43, 132,  51,
    133,  51, 133,  43,  43,  43,  43,  43,  80,  44,  44,  44,  44,  44,  44,  44,
     67, 134,  67, 135,  67,  34,  11,  16,  11,  32, 135,  67,  49,  11,  11,  67,
     67,  67, 134, 134, 134,  11,  11, 136,  11,  11,  35,  36,  39,  67,  16,  11,
      8,   8,  49,  16,  16,  26,  67, 137,  27,  27,  27,  27,  27,  27,  27,  27,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 138, 139, 103, 140,  67,  44,  44,
      8,   8, 141,  67,  67,   8,  67,  67, 141,  26,  67, 141,  67,  67,  67, 141,
     67,  67,  67,  67,  67,  67,  67,   8,  67, 141, 141,  67,  67,  67,  67,  67,
     67,  67,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,
     67,  67,  67,  67,   4,   4,  67,  67,   8,  67,  67,  67, 142, 143,  67,  67,
     67,  67,  67,  67,  67,  67, 141,  67,  67,  67,  67,  67,  67,  26,   8,   8,
      8,   8,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,   8,   8,
      8,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  90,  44,  44,  44,  44,
     67,  67,  67,  67,  67,  90,  44,  44,  27,  27,  27,  27,  27,  27,  67,  67,
     67,  67,  67,  67,  67,  27,  27,  27,  67,  67,  67,  26,  67,  67,  67,  67,
     26,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,   8,   8,   8,   8,
     67,  67,  67,  67,  67,  67,  67,  26,  67,  67,  67,  67,   4,   4,   4,   4,
      4,   4,   4,  27,  27,  27,  27,  27,  27,  27,  67,  67,  67,  67,  67,  67,
      8,   8, 127, 144,   8,   8,   8,   8,   8,   8,   8,   4,   4,   4,   4,   4,
      8, 127, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 144,   8,   8,   8,
      8,   8,   8,   8,   4,   4,   8,   8,   8,   8,   8,   8,   8,   8,   4,   8,
      8,   8, 141,  26,   8,   8, 141,  67,  67,  67,  44,  67,  67,  67,  67,  67,
     67,  67,  67,  44,  67,  67,  67,  67,  11,  11,  11,  11,  11,  11,  11,  47,
     16,  16,  16,  16,  16,  16,  16, 108,  32,  11,  32,  34,  34,  34,  34,  11,
     32,  32,  34,  16,  16,  16,  40,  11,  32,  32, 137,  67,  67, 135,  34, 146,
     43,  32,  44,  44,  91,   2,  97,   2,  16,  16,  16, 147,  44,  44, 147,  44,
     36,  36,  36,  36,  44,  44,  44,  52,  64,  44,  44,  44,  44,  44,  44,  57,
     36,  36,  36,  61,  44,  44,  44,  44,  36,  36,  36,  61,  36,  36,  36,  61,
      2, 119, 119,   2, 123, 124, 119,   2,   2,   2,   2,   6,   2, 105, 119,   2,
    119,   4,   4,   4,   4,   2,   2,  86,   2,   2,   2,   2,   2, 118,   2,   2,
    105, 148,   2,   2,   2,   2,   2,   2,  67,  67,  67,  67,  67,  55,  67,  67,
     67,  67,  44,  44,  44,  44,  44,  44,  67,  67,  67,  44,  44,  44,  44,  44,
     67,  67,  67,  67,  67,  67,  44,  44,   1,   2, 149, 150,   4,   4,   4,   4,
      4,  67,   4,   4,   4,   4, 151, 152, 153, 103, 103, 103, 103,  43,  43,  84,
    154,  40,  40,  67, 103, 155,  63,  67,  36,  36,  36,  61,  57, 156, 157,  69,
     36,  36,  36,  36,  36,  63,  40,  69,  44,  44,  62,  36,  36,  36,  36,  36,
     67,  27,  27,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  90,
     27,  27,  27,  27,  27,  67,  67,  67,  67,  67,  67,  67,  27,  27,  27,  27,
    158,  27,  27,  27,  27,  27,  27,  27,  36,  36, 106,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36, 159,   2,   7,   7,   7,   7,   7,  36,  44,  44,
     32,  32,  32,  32,  32,  32,  32,  70,  51, 160,  43,  43,  43,  43,  43,  86,
     32,  32,  32,  32,  32,  32,  40,  43,  36,  36,  36, 103, 103, 103, 103, 103,
     43,   2,   2,   2,  44,  44,  44,  44,  41,  41,  41, 157,  40,  40,  40,  40,
     41,  32,  32,  32,  32,  32,  32,  32,  16,  32,  32,  32,  32,  32,  32,  32,
     45,  16,  16,  16,  34,  34,  34,  32,  32,  32,  32,  32,  42, 161,  34,  35,
     32,  32,  16,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  11,  11,  32,
     11,  11,  32,  32,  32,  32,  32,  32,  44,  32,  11,  47,  44,  44,  44,  44,
     44,  44,  44,  62,  40,  35,  36,  36,  36,  71,  36,  71,  36,  70,  36,  36,
     36,  92,  85,  83,  67,  67,  44,  44,  27,  27,  27,  67, 162,  44,  44,  44,
     36,  36,   2,   2,  44,  44,  44,  44,  84,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  84,  84,  84,  84,  84,  84,  84,  84,  43,  44,  44,  44,  44,   2,
     43,  36,  36,  36,   2,  72,  72,  70,  36,  36,  36,  43,  43,  43,  43,   2,
     36,  36,  36,  70,  43,  43,  43,  43,  43,  84,  44,  44,  44,  44,  44,  91,
     36,  70,  84,  43,  43,  84,  43,  84, 163,   2,   2,   2,   2,   2,   2,  52,
      7,   7,   7,   7,   7,  44,  44,   2,  36,  36,  70,  69,  36,  36,  36,  36,
      7,   7,   7,   7,   7,  36,  36,  61,  36,  36,  36,  36,  70,  43,  43,  83,
     85,  83,  85,  80,  44,  44,  44,  44,  36,  70,  36,  36,  36,  36,  83,  44,
      7,   7,   7,   7,   7,  44,   2,   2,  69,  36,  36,  77,  67,  92,  83,  36,
     71,  43,  71,  70,  71,  36,  36,  43,  70,  61,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,  44,  62, 106,   2,  36,  36,  36,  36,  36,  92,  43,  84,
      2, 106, 164,  80,  44,  44,  44,  44,  62,  36,  36,  61,  62,  36,  36,  61,
     62,  36,  36,  61,  44,  44,  44,  44,  16,  16,  16,  16,  16, 112,  40,  40,
     16,  16,  16,  16,  44,  44,  44,  44,  36,  92,  85,  84,  83, 163,  85,  44,
     36,  36,  44,  44,  44,  44,  44,  44,  36,  36,  36,  61,  44,  62,  36,  36,
    165, 165, 165, 165, 165, 165, 165, 165, 166, 166, 166, 166, 166, 166, 166, 166,
     16,  16,  16, 108,  44,  44,  44,  44,  44, 147,  16,  16,  44,  44,  62,  71,
     36,  36,  36,  36, 167,  36,  36,  36,  36,  36,  36,  61,  36,  36,  61,  61,
     36,  62,  61,  36,  36,  36,  36,  36,  36,  41,  41,  41,  41,  41,  41,  41,
     41,  44,  44,  44,  44,  44,  44,  44,  44,  62,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36, 145,  44,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  44,  44,  44,  44,  36,  36,  36,  36,  36,  36, 162,  44,
      2,   2,   2, 168, 128,  44,  44,  44,   6, 169, 170, 145, 145, 145, 145, 145,
    145, 145, 128, 168, 128,   2, 125, 171,   2,  64,   2,   2, 151, 145, 145, 128,
      2, 172,   8, 173,  66,   2,  44,  44,  36,  36,  61,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  61,  79,  91,   2,   3,   2,   4,   5,   6,   2,
     16,  16,  16,  16,  16,  17,  18, 127, 128,   4,   2,  36,  36,  36,  36,  36,
     69,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  40,
     44,  36,  36,  36,  44,  36,  36,  36,  44,  36,  36,  36,  44,  36,  61,  44,
     20, 174,  56, 175,  26,   8, 141,  90,  44,  44,  44,  44,  79,  65,  67,  44,
     36,  36,  36,  36,  36,  36,  62,  36,  36,  36,  36,  36,  36,  61,  36,  62,
      2,  64,  44, 176,  27,  27,  27,  27,  27,  27,  44,  55,  67,  67,  67,  67,
    103, 103, 140,  27,  89,  67,  67,  67,  67,  67,  67,  67,  67,  27,  67,  90,
     90,  44,  44,  44,  44,  44,  44,  44,  67,  67,  67,  67,  67,  67,  50,  44,
    177,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  44,  44,
     27,  27,  44,  44,  44,  44,  62,  36, 150,  36,  36,  36,  36, 178,  44,  44,
     36,  36,  36,  43,  43,  80,  44,  44,  36,  36,  36,  36,  36,  36,  36,  91,
     36,  36,  44,  44,  36,  36,  36,  36, 179, 103, 103,  44,  44,  44,  44,  44,
     11,  11,  11,  11,  16,  16,  16,  16,  11,  11,  44,  44,  16,  16,  16,  16,
     16,  16,  16,  16,  16,  16,  44,  44,  36,  36,  44,  44,  44,  44,  44,  91,
     36,  36,  36,  44,  61,  36,  36,  36,  36,  36,  36,  62,  61,  44,  61,  62,
     36,  36,  36,  91,  27,  27,  27,  27,  36,  36,  36,  77, 158,  27,  27,  27,
     44,  44,  44, 176,  27,  27,  27,  27,  36,  61,  36,  44,  44, 176,  27,  27,
     36,  36,  36,  27,  27,  27,  44,  91,  36,  36,  36,  36,  36,  44,  44,  91,
     36,  36,  36,  36,  44,  44,  27,  36,  44,  27,  27,  27,  27,  27,  27,  27,
     70,  43,  57,  80,  44,  44,  43,  43,  36,  36,  62,  36,  62,  36,  36,  36,
     36,  36,  36,  44,  43,  80,  44,  57,  27,  27,  27,  27,  98,  44,  44,  44,
      2,   2,   2,   2,  64,  44,  44,  44,  36,  36,  36,  36,  36,  36, 180,  30,
     36,  36,  36,  36,  36,  36, 180,  27,  36,  36,  36,  36,  78,  36,  36,  36,
     36,  36,  70,  80,  44, 176,  27,  27,   2,   2,   2,  64,  44,  44,  44,  44,
     36,  36,  36,  44,  91,   2,   2,   2,  36,  36,  36,  44,  27,  27,  27,  27,
     36,  61,  44,  44,  27,  27,  27,  27,  36,  44,  44,  44,  91,   2,  64,  44,
     44,  44,  44,  44, 176,  27,  27,  27,  11,  47,  44,  44,  44,  44,  44,  44,
     16, 108,  44,  44,  44,  27,  27,  27,  36,  36,  43,  43,  44,  44,  44,  44,
     27,  27,  27,  27,  27,  27,  27,  98,  27,  27,  27,  93,  44,  44,  44,  44,
    177,  27,  30,   2,   2,  44,  44,  44,  85,  96,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  43,  43,  43,  43,  43,  43,  43,  60,   2,   2,   2,  44,
     27,  27,  27,   7,   7,   7,   7,   7,  44,  44,  44,  44,  44,  44,  44,  57,
     84,  85,  43,  83,  85,  60, 181,   2,   2,  44,  44,  44,  44,  44,  79,  44,
     43,  71,  36,  36,  36,  36,  36,  36,  36,  36,  36,  70,  43,  43,  85,  43,
     43,  43,  80,   7,   7,   7,   7,   7,   2,   2,  92,  88,  44,  44,  44,  44,
     36,  70,   2,  61,  44,  44,  44,  44,  36,  92,  84,  43,  43,  43,  43,  83,
     96,  36,  63,   2,  59,  43,  60,  44,   7,   7,   7,   7,   7,  63,  63,   2,
    176,  27,  27,  27,  27,  27,  27,  27,  27,  27,  98,  44,  44,  44,  44,  44,
     36,  36,  36,  36,  36,  36,  84,  85,  43,  84,  83,  43,   2,   2,   2,  80,
     36,  36,  36,  61,  61,  36,  36,  62,  36,  36,  36,  36,  36,  36,  36,  62,
     36,  36,  36,  36,  63,  44,  44,  44,  36,  36,  36,  36,  36,  36,  36,  70,
     84,  85,  43,  43,  43,  80,  44,  44,  43,  84,  62,  36,  36,  36,  61,  62,
     61,  36,  62,  36,  36,  57,  71,  84,  83,  84,  88,  87,  88,  87,  84,  44,
     61,  44,  44,  87,  44,  44,  62,  36,  36,  84,  44,  43,  43,  43,  80,  44,
     43,  43,  80,  44,  44,  44,  44,  44,  36,  36,  92,  84,  43,  43,  43,  43,
     84,  43,  83,  71,  36,  63,   2,   2,   7,   7,   7,   7,   7,  91,  91,  71,
     84,  85,  43,  43,  83,  83,  84,  85,  83,  43,  36,  72,  44,  44,  44,  44,
     36,  36,  36,  36,  36,  36,  36,  92,  84,  43,  43,  44,  84,  84,  43,  85,
     60,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  36,  36,  43,  44,
     84,  85,  43,  43,  43,  83,  85,  85,  60,   2,  61,  44,  44,  44,  44,  44,
      2,   2,   2,   2,   2,   2,  64,  44,  36,  36,  36,  36,  36,  70,  85,  84,
     43,  43,  43,  85,  61,  44,  44,  44,  84,  43,  43,  85,  43,  43,  44,  44,
      7,   7,   7,   7,   7,  27,   2,  95,  43,  43,  43,  43,  85,  60,  44,  44,
     27,  98,  44,  44,  44,  44,  44,  62,  36,  36,  36,  36,  44,  36,  36,  36,
     92,  84,  43,  43,  44,  43,  84,  84,  71,  72,  88,  44,  44,  44,  44,  44,
     70,  43,  43,  43,  43,  71,  36,  36,  36,  70,  43,  43,  83,  70,  43,  60,
      2,   2,   2,  59,  44,  44,  44,  44,  70,  43,  43,  83,  85,  43,  36,  36,
     36,  36,  36,  36,  36,  43,  43,  43,  43,  43,  43,  83,  43,   2,  72,   2,
      2,  64,  44,  44,  44,  44,  44,  44,  43,  43,  43,  80,  43,  43,  43,  85,
     63,   2,   2,  44,  44,  44,  44,  44,   2,  36,  36,  36,  36,  36,  36,  36,
     44,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  43,  87,  43,  43,  43,
     83,  43,  85,  80,  44,  44,  44,  44,  36,  36,  36,  61,  36,  62,  36,  36,
     70,  43,  43,  80,  44,  80,  43,  57,  43,  43,  43,  70,  44,  44,  44,  44,
     36,  36,  36,  62,  61,  36,  36,  36,  36,  36,  36,  36,  36,  84,  84,  88,
     43,  87,  85,  85,  61,  44,  44,  44,  36,  70,  83, 163,  64,  44,  44,  44,
     27,  27,  89,  67,  67,  67,  56,  20, 162,  67,  67,  67,  67,  67,  67,  67,
     67,  44,  44,  44,  44,  44,  44,  91, 103, 103, 103, 103, 103, 103, 103, 178,
      2,   2,  64,  44,  44,  44,  44,  44,  65,  65,  65,  65,  68,  44,  44,  44,
     43,  43,  60,  44,  44,  44,  44,  44,  43,  43,  43,  60,   2,   2,  67,  67,
     40,  40,  95,  44,  44,  44,  44,  44,   7,   7,   7,   7,   7, 176,  27,  27,
     27,  62,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  62,  36,
     27,  27,  27,  30,   2,  64,  44,  44,  36,  36,  36,  36,  36,  61,  44,  57,
     92,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84,
     84,  84,  84,  84,  44,  44,  44,  57,  43,  74,  40,  40,  40,  40,  40,  40,
     40,  86,  44,  44,  44,  44,  44,  44,  36,  61,  44,  44,  44,  44,  44,  44,
     44,  44,  36,  36,  44,  44,  44,  44,  36,  36,  36,  36,  36,  44,  50,  60,
     65,  65,  44,  44,  44,  44,  44,  44,  67,  67,  67,  90,  55,  67,  67,  67,
     67,  67, 182,  85,  43,  67, 182,  84,  84, 183,  65,  65,  65,  82,  43,  43,
     43,  76,  50,  43,  43,  43,  67,  67,  67,  67,  67,  67,  67,  43,  43,  67,
     67,  67,  67,  67,  90,  44,  44,  44,  67,  43,  76,  44,  44,  44,  44,  44,
     27,  27,  44,  44,  44,  44,  44,  44,  11,  11,  11,  11,  11,  16,  16,  16,
     16,  16,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  16,
     16,  16, 108,  16,  16,  16,  16,  16,  11,  16,  16,  16,  16,  16,  16,  16,
     16,  16,  16,  16,  16,  16,  47,  11,  44,  47,  48,  47,  48,  11,  47,  11,
     11,  11,  11,  16,  16, 147, 147,  16,  16,  16, 147,  16,  16,  16,  16,  16,
     16,  16,  11,  48,  11,  47,  48,  11,  11,  11,  47,  11,  11,  11,  47,  16,
     16,  16,  16,  16,  11,  48,  11,  47,  11,  11,  47,  47,  44,  11,  11,  11,
     47,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  11,  11,
     11,  11,  11,  16,  16,  16,  16,  16,  16,  16,  16,  44,  11,  11,  11,  11,
     31,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  33,  16,  16,
     16,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  31,  16,  16,
     16,  16,  33,  16,  16,  16,  11,  11,  11,  11,  31,  16,  16,  16,  16,  16,
     16,  16,  16,  16,  16,  16,  16,  33,  16,  16,  16,  11,  11,  11,  11,  11,
     11,  11,  11,  11,  11,  11,  11,  31,  16,  16,  16,  16,  33,  16,  16,  16,
     11,  11,  11,  11,  31,  16,  16,  16,  16,  33,  16,  16,  16,  32,  44,   7,
      7,   7,   7,   7,   7,   7,   7,   7,  43,  43,  43,  76,  67,  50,  43,  43,
     43,  43,  43,  43,  43,  43,  76,  67,  67,  67,  50,  67,  67,  67,  67,  67,
     67,  67,  76,  21,   2,   2,  44,  44,  44,  44,  44,  44,  44,  57,  43,  43,
     43,  43,  43,  80,  43,  43,  43,  43,  43,  43,  43,  43,  80,  57,  43,  43,
     43,  57,  80,  43,  43,  80,  44,  44,  43,  43,  43,  74,  40,  40,  40,  44,
      7,   7,   7,   7,   7,  44,  44,  77,  36,  36,  36,  36,  36,  36,  43,  43,
      7,   7,   7,   7,   7,  44,  44,  94,  36,  36,  61, 176,  27,  27,  27,  27,
     43,  43,  43,  80,  44,  44,  44,  44,  16,  16,  43,  43,  43,  74,  44,  44,
     27,  27,  27,  27,  27,  27, 158,  27, 184,  27,  98,  44,  44,  44,  44,  44,
     27,  27,  27,  27,  27,  27,  27, 158,  27,  27,  27,  27,  27,  27,  27,  44,
     36,  36,  62,  36,  36,  36,  36,  36,  62,  61,  61,  62,  62,  36,  36,  36,
     36,  61,  36,  36,  62,  62,  44,  44,  44,  61,  44,  62,  62,  62,  62,  36,
     62,  61,  61,  62,  62,  62,  62,  62,  62,  61,  61,  62,  36,  61,  36,  36,
     36,  61,  36,  36,  62,  36,  61,  61,  36,  36,  36,  36,  36,  62,  36,  36,
     62,  36,  62,  36,  36,  62,  36,  36,   8,  44,  44,  44,  44,  44,  44,  44,
     55,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  67,  90,  44,
     44,  44,  44,  67,  67,  67,  67,  67,  67,  90,  44,  44,  44,  44,  44,  44,
     67,  44,  44,  44,  44,  44,  44,  44,  67,  67,  67,  67,  67,  25,  41,  41,
     67,  67,  67,  67,  44,  44,  44,  44,  67,  67,  67,  67,  67,  67,  67,  44,
     67,  67,  67,  67,  67,  67,  55,  67,  67,  55,  67,  90,  44,  67,  67,  67,
     67,  90,  55,  67,  67,  90,  44,  67,  67,  67,  67,  67,  67,  90,  55,  67,
     67,  67,  44,  44,  67,  90,  44,  44,  36,  44,  44,  44,  44,  44,  44,  44,
     79,  44,  44,  44,  44,  44,  44,  44,  65,  65,  65,  65,  65,  65,  65,  65,
    166, 166, 166, 166, 166, 166, 166,  44,
};

static RE_UINT8 re_general_category_stage_4[] = {
    15, 15, 12, 23, 23, 23, 25, 23, 20, 21, 23, 24, 23, 19,  9,  9,
    24, 24, 24, 23, 23,  1,  1,  1,  1, 20, 23, 21, 26, 22, 26,  2,
     2,  2,  2, 20, 24, 21, 24, 15, 25, 25, 27, 23, 26, 27,  5, 28,
    24, 16, 27, 26, 27, 24, 11, 11, 26, 11,  5, 29, 11, 23,  1, 24,
     1,  2,  2, 24,  2,  1,  2,  5,  5,  5,  1,  3,  3,  2,  5,  2,
     4,  4, 26, 26,  4, 26,  6,  6,  0,  0,  4,  2,  1, 23,  1,  0,
     0,  1, 24,  1, 27,  6,  7,  7,  0,  4,  2, 23, 19,  0,  0, 27,
    27, 25,  0,  6, 19,  6, 23,  6,  6, 23,  5,  0,  0,  5,  5, 23,
    23,  0, 16, 16, 23, 25, 27, 27, 16,  0,  4,  5,  5,  6,  6,  5,
    23,  5,  6, 16,  6,  4,  4,  6,  6, 27,  5, 27, 27,  5,  0, 16,
     6,  0,  4,  0, 16,  6,  6,  8,  8,  8,  8,  6, 23,  4,  0,  8,
     8,  0, 11, 27, 27,  0,  0, 23,  5,  8, 11,  5,  0, 25, 23, 27,
     8,  5, 23, 11, 11,  0, 19,  5, 12,  5,  5, 20, 21,  0, 10, 10,
    10,  5, 19, 23,  5,  4,  7,  0,  2,  0,  2,  4,  3,  3,  3, 26,
     2, 26,  0, 26,  1, 26, 26,  0, 12, 12, 12, 16, 19, 19, 28, 29,
    20, 28, 13, 14, 16, 12, 23, 28, 29, 23, 23, 22, 22, 23, 24, 20,
    21, 23, 23, 12, 11,  4, 21,  4,  6,  7,  7,  6,  1, 27, 27,  1,
    27,  2,  2, 27, 10,  1,  2, 10, 10, 11, 24, 27, 27, 20, 21, 27,
    21, 24, 21, 20,  2,  6,  0,  2, 20, 23, 27,  4,  5, 10, 19, 20,
    21, 21, 27, 10, 19,  4, 10,  4,  6, 26, 26,  4, 27, 11,  4, 23,
     7, 23, 26,  1, 25, 27,  8, 23,  4,  8, 18, 18, 17, 17,  5, 24,
    23, 20, 19, 22, 22, 20, 22, 22, 24, 19, 24,  0, 24, 26, 25,  0,
     0, 11,  6, 11, 10,  0, 23, 10,  5, 11, 23, 16, 27,  8,  8, 16,
    25, 11,
};

/* General_Category: 13674 bytes. */

RE_UINT32 re_get_general_category(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 9;
    code = ch ^ (f << 9);
    pos = (RE_UINT32)re_general_category_stage_1[f] << 5;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_general_category_stage_2[pos + f] << 3;
    f = code >> 1;
    code ^= f << 1;
    pos = (RE_UINT32)re_general_category_stage_3[pos + f] << 1;
    value = re_general_category_stage_4[pos + code];

    return value;
}

/* Block. */

static RE_UINT8 re_block_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 13, 13,
    13, 13, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 16, 17, 18, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 20, 21, 22, 23, 23, 23, 23, 23, 23, 24, 25,
    26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 37, 38, 36, 36,
    36, 39, 36, 36, 36, 36, 36, 36, 36, 36, 40, 41, 42, 42, 42, 42,
    42, 42, 43, 36, 36, 36, 36, 36, 36, 36, 36, 36, 44, 36, 36, 45,
    36, 36, 36, 36, 46, 47, 48, 36, 49, 36, 50, 51, 52, 53, 54, 36,
    55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
    55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
    55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 57, 57, 57, 58, 59, 60,
    60, 60, 60, 61, 62, 62, 62, 62, 62, 62, 63, 36, 36, 36, 64, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    65, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
    66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
    66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
    66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
    67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
    67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
    67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
    67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
};

static RE_UINT16 re_block_stage_2[] = {
      0,   0,   0,   0,   1,   1,   1,   1,   2,   2,   2,   2,   3,   3,   3,   3,
      3,   3,   4,   5,   5,   6,   7,   7,   8,   8,   8,   9,  10,  10,  10,  10,
     11,  11,  11,  11,  11,  11,  11,  11,  12,  13,  14,  14,  15,  16,  16,  16,
     17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  19,  20,  21,  21,  22,  22,
     23,  23,  24,  25,  26,  27,  27,  27,  28,  28,  28,  28,  29,  29,  29,  29,
     30,  30,  30,  30,  31,  31,  31,  31,  32,  32,  32,  32,  33,  33,  33,  33,
     34,  34,  34,  34,  35,  35,  35,  35,  36,  36,  36,  36,  37,  37,  37,  37,
     38,  38,  38,  38,  39,  39,  39,  39,  40,  40,  40,  40,  40,  40,  40,  40,
     41,  41,  41,  41,  41,  42,  42,  42,  43,  43,  43,  43,  43,  43,  43,  43,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  45,  46,  46,  46,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,  48,  49,  49,  49,  50,  51,  52,  53,  54,  54,  54,  54,
     55,  55,  55,  55,  55,  56,  57,  57,  58,  58,  59,  60,  61,  61,  61,  62,
     63,  64,  64,  64,  64,  65,  66,  66,  67,  67,  67,  67,  68,  68,  69,  69,
     70,  70,  71,  72,  73,  74,  75,  76,  77,  77,  77,  77,  78,  78,  79,  79,
     80,  80,  80,  80,  80,  80,  80,  80,  81,  81,  81,  81,  81,  81,  81,  81,
     82,  82,  82,  83,  84,  85,  86,  87,  88,  88,  89,  90,  91,  92,  92,  92,
     93,  93,  93,  93,  93,  93,  93,  93,  94,  94,  94,  94,  94,  94,  94,  94,
     95,  95,  96,  97,  97,  97,  97,  97,  98,  98,  98,  98,  99, 100, 100, 100,
    101, 101, 101, 101, 101, 101, 101, 101, 102, 102, 102, 102, 102, 102, 103, 104,
    105, 105, 105, 105, 105, 105, 105, 105, 106, 106, 106, 106, 107, 107, 107, 107,
    108, 108, 108, 108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 109, 109, 109,
    110, 110, 110, 111, 112, 112, 112, 112, 113, 114, 115, 115, 116, 116, 116, 117,
    118, 118, 118, 118, 119, 119, 119, 119, 120, 120, 120, 120, 120, 120, 120, 121,
    122, 122, 123, 123, 123, 124, 124, 124, 125, 126, 127, 127, 128, 129, 130, 131,
    132, 132, 132, 132, 132, 132, 132, 132, 133, 133, 133, 133, 133, 133, 133, 133,
    134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134,
    134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134,
    134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 135, 135,
    136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136,
    136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136,
    136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136,
    137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137,
    137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137,
    137, 137, 137, 137, 138, 139, 140, 141, 142, 142, 142, 142, 142, 142, 142, 142,
    142, 142, 143, 143, 143, 144, 144, 144, 145, 146, 146, 146, 146, 146, 146, 146,
    147, 148, 149, 149, 150, 150, 150, 151, 152, 153, 154, 155, 156, 156, 156, 157,
    158, 158, 158, 159, 160, 160, 160, 161, 162, 163, 164, 165, 166, 166, 167, 167,
    168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168,
    168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168,
    168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168,
    168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 169, 170, 170,
    171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171,
    171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 172, 172, 172, 172,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173, 173,
    174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174,
    174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174,
    174, 174, 174, 174, 174, 174, 174, 174, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 176, 176, 177, 178, 178, 178, 178, 178,
    178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178,
    179, 180, 181, 182, 183, 183, 183, 183, 184, 184, 184, 184, 184, 184, 184, 185,
    186, 186, 186, 186, 187, 187, 187, 187, 188, 188, 189, 189, 190, 191, 192, 193,
     26,  26,  26,  26, 194, 195, 195, 196, 197, 198, 199, 200, 201, 202, 202,  26,
    203, 203, 204, 205, 206, 207, 208, 208, 209, 210, 211, 212,  26,  26,  26,  26,
    213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,  26,  26,  26,  26,
    214, 214, 215, 216, 217, 218,  26, 219, 220, 221,  26,  26, 222, 223, 223, 223,
    224, 224, 224, 225, 226,  26, 227, 227, 228, 228, 229, 230, 231, 232,  26,  26,
    233, 233, 234,  26, 235, 235, 235, 235, 236, 236,  26,  26,  26,  26,  26,  26,
     26,  26,  26, 237,  26,  26,  26,  26, 238, 239, 240, 241,  26,  26,  26, 242,
    243, 243, 243, 243, 244, 244, 245, 246, 247, 247, 248, 249, 250, 250, 250, 251,
    252, 252, 253,  26, 254, 255, 256, 256, 257, 257, 257, 257,  26,  26,  26,  26,
    258, 258, 258, 258, 259, 259, 259,  26,  26,  26,  26,  26, 260, 260, 260, 260,
    261, 261, 261, 262, 263, 263, 264,  26, 265, 265,  26,  26,  26,  26,  26,  26,
    266, 266, 267,  26,  26, 268, 268, 268,  26,  26,  26,  26,  26, 269, 269, 269,
    270, 270, 271, 272, 272, 273, 274, 274,  26,  26,  26,  26,  26,  26,  26,  26,
    275, 275, 275, 276, 277, 277,  26,  26, 278, 278, 278, 279, 279, 280,  26,  26,
     26,  26,  26,  26,  26,  26,  26, 281,  26,  26,  26,  26,  26,  26, 282, 282,
    283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283,
    283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283,
    284, 284, 284, 284, 285, 285, 285, 285, 285, 285, 286,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287,
    287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287,
    287, 288,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289,
    289, 289, 289, 289,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290,
    290, 290, 291, 292,  26,  26, 293, 294, 295, 295, 295, 295, 296,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26, 297, 297, 297,  26,  26,  26, 298, 298, 298, 298, 298,  26,  26, 299,
    300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300,
    300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300,
    301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 301,
    301, 301, 301, 301, 301, 301, 301, 301,  26,  26,  26,  26,  26,  26,  26,  26,
    302, 302, 302, 302, 302, 302, 302, 302, 303, 304, 305, 306, 307, 307, 307, 307,
    307, 307, 307, 307, 307, 307, 307, 307,  26,  26,  26,  26,  26,  26,  26,  26,
    308, 308, 308, 308, 308, 309,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    310, 310, 310, 310, 310, 310, 310, 310, 311, 311, 311, 311, 311, 311, 311, 311,
    312, 312, 313,  26,  26,  26,  26, 314, 315, 315, 315, 316,  26,  26,  26,  26,
    317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317,
    317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317, 317,
    318, 318, 318, 318, 318, 318, 318, 318, 318, 318, 318, 318, 318, 318, 318, 318,
    318, 318, 318, 318, 318, 319,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    320, 321,  26,  26,  26,  26,  26,  26, 322, 322, 323,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26, 324, 324,  26,  26,  26,  26,  26,  26,  26,  26,
    325, 325, 325, 325, 325, 325, 325,  26, 326, 326, 326,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26, 327, 328, 328,  26,  26, 329, 329, 330,  26,  26,  26,  26,  26,
    331, 331, 331, 331, 331, 331, 331, 331,  26,  26,  26,  26,  26,  26,  26,  26,
    332, 333, 334, 334, 334, 335, 335, 335, 336, 336, 336, 336, 336, 336, 336, 336,
    337, 337, 337, 337, 337, 337, 337, 337, 338, 338, 338, 338, 338, 338, 338, 338,
    338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338, 338,
    339, 339, 340, 341, 342, 342, 342, 342, 343, 343, 343, 343, 344, 344, 344, 344,
    345, 345, 345, 345, 345, 345, 345, 345, 346, 346, 346, 346, 346, 346, 346, 346,
    347, 347, 347, 348, 349, 349, 349, 349,  26,  26,  26,  26,  26,  26,  26,  26,
    350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350,
    350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350,
    350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350,
    350, 350, 350, 350, 350, 350, 350,  26, 351, 351, 351, 351, 351, 351, 351, 351,
    351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351,
    351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351,
    351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 351,
    351, 351, 351, 351, 351, 351, 351, 351, 351, 351, 352, 352, 352, 352, 352, 352,
    352, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
    353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
    353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
    353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
    353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353, 353,
    353, 353, 353, 353, 353, 354, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355,
    355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355,
    355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355,
    355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355,
    355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 355, 356,
    357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357,
    357,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    358, 358, 358, 358,  26,  26,  26,  26, 359, 359, 359, 359, 359, 359, 359, 360,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361,
    361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361, 361,
    362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362,
    362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362,
};

static RE_UINT16 re_block_stage_3[] = {
      0,   0,   0,   0,   1,   1,   1,   1,   2,   2,   2,   2,   3,   3,   3,   3,
      3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   5,   5,   5,   5,   5,   5,
      6,   6,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,   8,   8,   8,   8,
      9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,
     11,  11,  11,  11,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  14,  14,
     14,  14,  14,  14,  15,  15,  15,  15,  16,  16,  16,  16,  17,  17,  17,  17,
     18,  18,  18,  18,  19,  19,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,
     22,  22,  22,  22,  23,  23,  23,  23,  24,  24,  24,  24,  25,  25,  25,  25,
     26,  26,  26,  26,  27,  27,  27,  27,  28,  28,  28,  28,  29,  29,  29,  29,
     30,  30,  30,  30,  31,  31,  31,  31,  32,  32,  32,  32,  33,  33,  33,  33,
     34,  34,  34,  34,  35,  35,  35,  35,  36,  36,  36,  36,  37,  37,  37,  37,
     38,  38,  38,  38,  39,  39,  39,  39,  40,  40,  40,  40,  41,  41,  41,  41,
     42,  42,  42,  42,  43,  43,  43,  43,  44,  44,  44,  44,  45,  45,  45,  45,
     46,  46,  46,  46,  47,  47,  47,  47,  48,  48,  48,  48,  49,  49,  49,  49,
     49,  49,  50,  50,  50,  50,  50,  50,  51,  51,  51,  51,  51,  51,  52,  52,
     52,  52,  52,  52,  53,  53,  53,  53,  54,  54,  54,  54,  55,  55,  55,  55,
     56,  56,  56,  56,  56,  56,  57,  57,  57,  57,  57,  57,  58,  58,  58,  58,
     59,  59,  59,  59,  60,  60,  60,  60,  61,  61,  61,  61,  61,  61,  62,  62,
     62,  62,  62,  62,  63,  63,  64,  64,  64,  64,  64,  64,  65,  65,  66,  66,
     66,  66,  66,  66,  67,  67,  67,  67,  68,  68,  68,  68,  69,  69,  69,  69,
     70,  70,  70,  70,  71,  71,  71,  71,  72,  72,  72,  72,  72,  72,  73,  73,
     73,  73,  73,  73,  74,  74,  74,  74,  74,  74,  75,  75,  75,  75,  75,  75,
     76,  76,  76,  76,  76,  76,  77,  77,  77,  77,  77,  77,  77,  77,  78,  78,
     78,  78,  78,  78,  79,  79,  79,  79,  80,  80,  80,  80,  81,  81,  81,  81,
     82,  82,  82,  82,  83,  83,  83,  83,  84,  84,  84,  84,  85,  85,  85,  85,
     86,  86,  86,  86,  87,  87,  87,  87,  88,  88,  88,  88,  89,  89,  89,  89,
     89,  89,  90,  90,  91,  91,  91,  91,  92,  92,  92,  92,  93,  93,  93,  93,
     94,  94,  94,  94,  95,  95,  95,  95,  96,  96,  96,  96,  97,  97,  97,  97,
     98,  98,  98,  98,  99,  99,  99,  99,  99,  99, 100, 100, 100, 100, 100, 100,
    101, 101, 101, 101, 102, 102, 102, 102, 103, 103, 103, 103, 104, 104, 104, 104,
    105, 105, 105, 105,  20,  20, 106, 106, 107, 107, 107, 107, 108, 108, 108, 108,
    109, 109, 109, 109, 110, 110, 110, 110, 110, 110, 111, 111, 111, 111, 111, 111,
    111, 111, 112, 112, 113, 113, 113, 113, 114, 114, 114, 114, 114, 114, 115, 115,
    116, 116, 116, 116, 117, 117, 117, 117, 118, 118, 118, 118, 119, 119, 119, 119,
    120, 120, 120, 120, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122,
    122, 122, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 125, 125, 125, 125,
    126, 126, 126, 126, 127, 127, 127, 127, 128, 128, 128, 128, 129, 129, 129, 129,
    129, 129, 130, 130, 131, 131, 131, 131, 132, 132, 132, 132, 133, 133, 133, 133,
    134, 134, 134, 134, 134, 134, 135, 135, 135, 135, 135, 135, 136, 136, 136, 136,
    137, 137, 137, 137, 138, 138, 138, 138, 139, 139, 139, 139, 140, 140, 140, 140,
    141, 141, 141, 141, 142, 142, 142, 142, 143, 143, 143, 143, 143, 143, 144, 144,
    144, 144, 144, 144, 144, 144, 145, 145, 145, 145, 145, 145, 146, 146, 146, 146,
    147, 147, 147, 147, 147, 147, 148, 148, 148, 148, 148, 148, 149, 149, 149, 149,
    150, 150, 150, 150, 151, 151, 151, 151, 152, 152, 152, 152, 153, 153, 153, 153,
    154, 154, 154, 154, 154, 154, 155, 155, 155, 155, 155, 155, 156, 156, 157, 157,
    158, 158, 159, 159, 159, 159, 160, 160, 160, 160, 161, 161, 161, 161, 161, 161,
    162, 162, 162, 162, 162, 162, 163, 163, 164, 164, 164, 164, 165, 165, 165, 165,
    166, 166, 166, 166, 167, 167, 167, 167, 167, 167, 168, 168, 168, 168, 168, 168,
    168, 168, 169, 169, 169, 169, 169, 169, 170, 170, 170, 170, 171, 171, 171, 171,
    172, 172, 172, 172, 173, 173, 173, 173, 173, 173, 174, 174, 174, 174, 175, 175,
    175, 175, 175, 175, 176, 176, 176, 176, 177, 177, 177, 177, 178, 178, 178, 178,
    178, 178, 179, 179, 179, 179, 179, 179, 180, 180, 180, 180, 180, 180, 181, 181,
    181, 181, 181, 181, 182, 182, 182, 182, 182, 182, 183, 183, 183, 183, 183, 183,
    183, 183,  20,  20, 184, 184, 184, 184, 185, 185, 185, 185, 186, 186, 186, 186,
    187, 187, 187, 187, 188, 188, 188, 188, 188, 188,  20,  20, 189, 189, 189, 189,
    190, 190, 190, 190, 191, 191, 191, 191, 192, 192, 192, 192, 193, 193, 193, 193,
    194, 194, 194, 194, 195, 195, 195, 195, 196, 196, 196, 196, 197, 197, 197, 197,
    198, 198, 198, 198, 199, 199, 199, 199, 200, 200, 200, 200, 201, 201, 201, 201,
    201, 201,  20,  20, 202, 202, 202, 202, 202, 202,  20,  20, 203, 203, 203, 203,
    204, 204, 204, 204, 205, 205, 205, 205, 206, 206, 206, 206, 206, 206, 207, 207,
    207, 207, 207, 207, 207, 207,  20,  20, 208, 208, 208, 208, 209, 209, 209, 209,
    210, 210, 210, 210, 210, 210, 211, 211, 211, 211, 211, 211, 212, 212, 212, 212,
    212, 212, 213, 213, 213, 213, 213, 213, 214, 214, 214, 214, 215, 215, 215, 215,
    216, 216, 216, 216, 216, 216,  20,  20, 217, 217, 217, 217, 217, 217, 218, 218,
    218, 218, 218, 218, 219, 219, 219, 219, 220, 220, 220, 220, 221, 221, 221, 221,
    222, 222, 222, 222, 223, 223, 223, 223, 224, 224, 224, 224, 225, 225, 225, 225,
    225, 225,  20,  20, 226, 226, 226, 226, 227, 227, 227, 227, 227, 227,  20,  20,
    228, 228, 228, 228, 229, 229, 229, 229, 230, 230, 230, 230, 230, 230, 231, 231,
    231, 231, 231, 231, 231, 231,  20,  20, 232, 232, 232, 232, 233, 233, 233, 233,
    233, 233, 234, 234, 234, 234, 234, 234, 235, 235, 235, 235, 236, 236, 236, 236,
    236, 236,  20,  20, 237, 237, 237, 237, 238, 238, 238, 238, 239, 239, 239, 239,
    240, 240, 240, 240, 241, 241, 241, 241, 241, 241,  20,  20, 242, 242, 242, 242,
    242, 242, 243, 243, 244, 244, 244, 244, 245, 245, 245, 245, 246, 246, 246, 246,
    246, 246,  20,  20,  20,  20, 247, 247, 247, 247, 247, 247, 248, 248, 248, 248,
    248, 248,  20,  20, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251,
    252, 252, 252, 252, 253, 253, 253, 253, 254, 254, 254, 254, 255, 255, 255, 255,
    255, 255, 256, 256, 256, 256, 256, 256, 256, 256, 257, 257, 257, 257, 257, 257,
    258, 258, 258, 258, 259, 259,  20,  20, 260, 260, 260, 260, 261, 261, 261, 261,
    262, 262, 262, 262, 262, 262,  20,  20, 263, 263, 263, 263, 264, 264, 264, 264,
    265, 265, 265, 265, 266, 266, 266, 266, 267, 267, 267, 267, 267, 267,  20,  20,
    268, 268, 268, 268, 268, 268,  20,  20, 269, 269, 269, 269, 269, 269,  20,  20,
    270, 270, 270, 270, 271, 271, 271, 271, 272, 272, 272, 272,  20,  20, 273, 273,
    273, 273, 273, 273, 274, 274, 274, 274, 274, 274,  20,  20, 275, 275, 275, 275,
    276, 276, 276, 276, 276, 276, 277, 277, 277, 277, 277, 277, 278, 278, 278, 278,
    279, 279, 279, 279, 280, 280, 280, 280, 281, 281, 281, 281, 282, 282, 282, 282,
    282, 282, 283, 283, 283, 283, 283, 283, 284, 284, 284, 284, 285, 285, 285, 285,
    286, 286, 286, 286, 287, 287, 287, 287, 288, 288, 288, 288, 289, 289, 289, 289,
    289, 289, 290, 290, 290, 290, 290, 290, 291, 291, 291, 291, 292, 292, 292, 292,
    293, 293, 293, 293, 294, 294, 294, 294, 294, 294, 295, 295, 295, 295, 295, 295,
    295, 295,  20,  20, 296, 296, 296, 296, 297, 297, 297, 297, 298, 298, 298, 298,
    298, 298,  20,  20, 299, 299, 299, 299, 300, 300, 300, 300,
};

static RE_UINT16 re_block_stage_4[] = {
      1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,
      3,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,
      5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6,   6,
      7,   7,   7,   7,   7,   7,   7,   7,   8,   8,   8,   8,   8,   8,   8,   8,
      9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  10,  10,  10,
     11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,
     13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,
     15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,
     17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,
     19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,
      0,   0,   0,   0,   0,   0,   0,   0,  21,  21,  21,  21,  21,  21,  21,  21,
     22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,
     24,  24,  24,  24,  24,  24,  24,  24,  25,  25,  25,  25,  25,  25,  25,  25,
     26,  26,  26,  26,  26,  26,  26,  26,  27,  27,  27,  27,  27,  27,  27,  27,
     28,  28,  28,  28,  28,  28,  28,  28,  29,  29,  29,  29,  29,  29,  29,  29,
     30,  30,  30,  30,  30,  30,  30,  30,  31,  31,  31,  31,  31,  31,  31,  31,
     32,  32,  32,  32,  32,  32,  32,  32,  33,  33,  33,  33,  33,  33,  33,  33,
     34,  34,  34,  34,  34,  34,  34,  34,  35,  35,  35,  35,  35,  35,  35,  35,
     36,  36,  36,  36,  36,  36,  36,  36,  37,  37,  37,  37,  37,  37,  37,  37,
     38,  38,  38,  38,  38,  38,  38,  38,  39,  39,  39,  39,  39,  39,  39,  39,
     40,  40,  40,  40,  40,  40,  40,  40,  41,  41,  41,  41,  41,  41,  41,  41,
     42,  42,  42,  42,  42,  42,  42,  42,  43,  43,  43,  43,  43,  43,  43,  43,
     44,  44,  44,  44,  44,  44,  44,  44,  45,  45,  45,  45,  45,  45,  45,  45,
     46,  46,  46,  46,  46,  46,  46,  46,  47,  47,  47,  47,  47,  47,  47,  47,
     48,  48,  48,  48,  48,  48,  48,  48,  49,  49,  49,  49,  49,  49,  49,  49,
     50,  50,  50,  50,  50,  50,  50,  50,  51,  51,  51,  51,  51,  51,  51,  51,
     52,  52,  52,  52,  52,  52,  52,  52,  53,  53,  53,  53,  53,  53,  53,  53,
     54,  54,  54,  54,  54,  54,  54,  54,  55,  55,  55,  55,  55,  55,  55,  55,
     56,  56,  56,  56,  56,  56,  56,  56,  57,  57,  57,  57,  57,  57,  57,  57,
     58,  58,  58,  58,  58,  58,  58,  58,  59,  59,  59,  59,  59,  59,  59,  59,
     60,  60,  60,  60,  60,  60,  60,  60,  61,  61,  61,  61,  61,  61,  61,  61,
     62,  62,  62,  62,  62,  62,  62,  62,  63,  63,  63,  63,  63,  63,  63,  63,
     64,  64,  64,  64,  64,  64,  64,  64,  65,  65,  65,  65,  65,  65,  65,  65,
     66,  66,  66,  66,  66,  66,  66,  66,  67,  67,  67,  67,  67,  67,  67,  67,
     68,  68,  68,  68,  68,  68,  68,  68,  69,  69,  69,  69,  69,  69,  69,  69,
     70,  70,  70,  70,  70,  70,  70,  70,  71,  71,  71,  71,  71,  71,  71,  71,
     72,  72,  72,  72,  72,  72,  72,  72,  73,  73,  73,  73,  73,  73,  73,  73,
     74,  74,  74,  74,  74,  74,  74,  74,  75,  75,  75,  75,  75,  75,  75,  75,
     76,  76,  76,  76,  76,  76,  76,  76,  77,  77,  77,  77,  77,  77,  77,  77,
     78,  78,  78,  78,  78,  78,  78,  78,  79,  79,  79,  79,  79,  79,  79,  79,
     80,  80,  80,  80,  80,  80,  80,  80,  81,  81,  81,  81,  81,  81,  81,  81,
     82,  82,  82,  82,  82,  82,  82,  82,  83,  83,  83,  83,  83,  83,  83,  83,
     84,  84,  84,  84,  84,  84,  84,  84,  85,  85,  85,  85,  85,  85,  85,  85,
     86,  86,  86,  86,  86,  86,  86,  86,  87,  87,  87,  87,  87,  87,  87,  87,
     88,  88,  88,  88,  88,  88,  88,  88,  89,  89,  89,  89,  89,  89,  89,  89,
     90,  90,  90,  90,  90,  90,  90,  90,  91,  91,  91,  91,  91,  91,  91,  91,
     92,  92,  92,  92,  92,  92,  92,  92,  93,  93,  93,  93,  93,  93,  93,  93,
     94,  94,  94,  94,  94,  94,  94,  94,  95,  95,  95,  95,  95,  95,  95,  95,
     96,  96,  96,  96,  96,  96,  96,  96,  97,  97,  97,  97,  97,  97,  97,  97,
     98,  98,  98,  98,  98,  98,  98,  98,  99,  99,  99,  99,  99,  99,  99,  99,
    100, 100, 100, 100, 100, 100, 100, 100, 101, 101, 101, 101, 101, 101, 101, 101,
    102, 102, 102, 102, 102, 102, 102, 102, 103, 103, 103, 103, 103, 103, 103, 103,
    104, 104, 104, 104, 104, 104, 104, 104, 105, 105, 105, 105, 105, 105, 105, 105,
    106, 106, 106, 106, 106, 106, 106, 106, 107, 107, 107, 107, 107, 107, 107, 107,
    108, 108, 108, 108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 109, 109, 109,
    110, 110, 110, 110, 110, 110, 110, 110, 111, 111, 111, 111, 111, 111, 111, 111,
    112, 112, 112, 112, 112, 112, 112, 112, 113, 113, 113, 113, 113, 113, 113, 113,
    114, 114, 114, 114, 114, 114, 114, 114, 115, 115, 115, 115, 115, 115, 115, 115,
    116, 116, 116, 116, 116, 116, 116, 116, 117, 117, 117, 117, 117, 117, 117, 117,
    118, 118, 118, 118, 118, 118, 118, 118, 119, 119, 119, 119, 119, 119, 119, 119,
    120, 120, 120, 120, 120, 120, 120, 120, 121, 121, 121, 121, 121, 121, 121, 121,
    122, 122, 122, 122, 122, 122, 122, 122, 123, 123, 123, 123, 123, 123, 123, 123,
    124, 124, 124, 124, 124, 124, 124, 124, 125, 125, 125, 125, 125, 125, 125, 125,
    126, 126, 126, 126, 126, 126, 126, 126, 127, 127, 127, 127, 127, 127, 127, 127,
    128, 128, 128, 128, 128, 128, 128, 128, 129, 129, 129, 129, 129, 129, 129, 129,
    130, 130, 130, 130, 130, 130, 130, 130, 131, 131, 131, 131, 131, 131, 131, 131,
    132, 132, 132, 132, 132, 132, 132, 132, 133, 133, 133, 133, 133, 133, 133, 133,
    134, 134, 134, 134, 134, 134, 134, 134, 135, 135, 135, 135, 135, 135, 135, 135,
    136, 136, 136, 136, 136, 136, 136, 136, 137, 137, 137, 137, 137, 137, 137, 137,
    138, 138, 138, 138, 138, 138, 138, 138, 139, 139, 139, 139, 139, 139, 139, 139,
    140, 140, 140, 140, 140, 140, 140, 140, 141, 141, 141, 141, 141, 141, 141, 141,
    142, 142, 142, 142, 142, 142, 142, 142, 143, 143, 143, 143, 143, 143, 143, 143,
    144, 144, 144, 144, 144, 144, 144, 144, 145, 145, 145, 145, 145, 145, 145, 145,
    146, 146, 146, 146, 146, 146, 146, 146, 147, 147, 147, 147, 147, 147, 147, 147,
    148, 148, 148, 148, 148, 148, 148, 148, 149, 149, 149, 149, 149, 149, 149, 149,
    150, 150, 150, 150, 150, 150, 150, 150, 151, 151, 151, 151, 151, 151, 151, 151,
    152, 152, 152, 152, 152, 152, 152, 152, 153, 153, 153, 153, 153, 153, 153, 153,
    154, 154, 154, 154, 154, 154, 154, 154, 155, 155, 155, 155, 155, 155, 155, 155,
    156, 156, 156, 156, 156, 156, 156, 156, 157, 157, 157, 157, 157, 157, 157, 157,
    158, 158, 158, 158, 158, 158, 158, 158, 159, 159, 159, 159, 159, 159, 159, 159,
    160, 160, 160, 160, 160, 160, 160, 160, 161, 161, 161, 161, 161, 161, 161, 161,
    162, 162, 162, 162, 162, 162, 162, 162, 163, 163, 163, 163, 163, 163, 163, 163,
    164, 164, 164, 164, 164, 164, 164, 164, 165, 165, 165, 165, 165, 165, 165, 165,
    166, 166, 166, 166, 166, 166, 166, 166, 167, 167, 167, 167, 167, 167, 167, 167,
    168, 168, 168, 168, 168, 168, 168, 168, 169, 169, 169, 169, 169, 169, 169, 169,
    170, 170, 170, 170, 170, 170, 170, 170, 171, 171, 171, 171, 171, 171, 171, 171,
    172, 172, 172, 172, 172, 172, 172, 172, 173, 173, 173, 173, 173, 173, 173, 173,
    174, 174, 174, 174, 174, 174, 174, 174, 175, 175, 175, 175, 175, 175, 175, 175,
    176, 176, 176, 176, 176, 176, 176, 176, 177, 177, 177, 177, 177, 177, 177, 177,
    178, 178, 178, 178, 178, 178, 178, 178, 179, 179, 179, 179, 179, 179, 179, 179,
    180, 180, 180, 180, 180, 180, 180, 180, 181, 181, 181, 181, 181, 181, 181, 181,
    182, 182, 182, 182, 182, 182, 182, 182, 183, 183, 183, 183, 183, 183, 183, 183,
    184, 184, 184, 184, 184, 184, 184, 184, 185, 185, 185, 185, 185, 185, 185, 185,
    186, 186, 186, 186, 186, 186, 186, 186, 187, 187, 187, 187, 187, 187, 187, 187,
    188, 188, 188, 188, 188, 188, 188, 188, 189, 189, 189, 189, 189, 189, 189, 189,
    190, 190, 190, 190, 190, 190, 190, 190, 191, 191, 191, 191, 191, 191, 191, 191,
    192, 192, 192, 192, 192, 192, 192, 192, 193, 193, 193, 193, 193, 193, 193, 193,
    194, 194, 194, 194, 194, 194, 194, 194, 195, 195, 195, 195, 195, 195, 195, 195,
    196, 196, 196, 196, 196, 196, 196, 196, 197, 197, 197, 197, 197, 197, 197, 197,
    198, 198, 198, 198, 198, 198, 198, 198, 199, 199, 199, 199, 199, 199, 199, 199,
    200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 201, 201, 201, 201, 201, 201,
    202, 202, 202, 202, 202, 202, 202, 202, 203, 203, 203, 203, 203, 203, 203, 203,
    204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 205, 205, 205, 205, 205,
    206, 206, 206, 206, 206, 206, 206, 206, 207, 207, 207, 207, 207, 207, 207, 207,
    208, 208, 208, 208, 208, 208, 208, 208, 209, 209, 209, 209, 209, 209, 209, 209,
    210, 210, 210, 210, 210, 210, 210, 210, 211, 211, 211, 211, 211, 211, 211, 211,
    212, 212, 212, 212, 212, 212, 212, 212, 213, 213, 213, 213, 213, 213, 213, 213,
    214, 214, 214, 214, 214, 214, 214, 214, 215, 215, 215, 215, 215, 215, 215, 215,
    216, 216, 216, 216, 216, 216, 216, 216, 217, 217, 217, 217, 217, 217, 217, 217,
    218, 218, 218, 218, 218, 218, 218, 218, 219, 219, 219, 219, 219, 219, 219, 219,
    220, 220, 220, 220, 220, 220, 220, 220, 221, 221, 221, 221, 221, 221, 221, 221,
    222, 222, 222, 222, 222, 222, 222, 222, 223, 223, 223, 223, 223, 223, 223, 223,
    224, 224, 224, 224, 224, 224, 224, 224, 225, 225, 225, 225, 225, 225, 225, 225,
    226, 226, 226, 226, 226, 226, 226, 226, 227, 227, 227, 227, 227, 227, 227, 227,
    228, 228, 228, 228, 228, 228, 228, 228, 229, 229, 229, 229, 229, 229, 229, 229,
    230, 230, 230, 230, 230, 230, 230, 230, 231, 231, 231, 231, 231, 231, 231, 231,
    232, 232, 232, 232, 232, 232, 232, 232, 233, 233, 233, 233, 233, 233, 233, 233,
    234, 234, 234, 234, 234, 234, 234, 234, 235, 235, 235, 235, 235, 235, 235, 235,
    236, 236, 236, 236, 236, 236, 236, 236, 237, 237, 237, 237, 237, 237, 237, 237,
    238, 238, 238, 238, 238, 238, 238, 238, 239, 239, 239, 239, 239, 239, 239, 239,
    240, 240, 240, 240, 240, 240, 240, 240, 241, 241, 241, 241, 241, 241, 241, 241,
    242, 242, 242, 242, 242, 242, 242, 242, 243, 243, 243, 243, 243, 243, 243, 243,
    244, 244, 244, 244, 244, 244, 244, 244, 245, 245, 245, 245, 245, 245, 245, 245,
    246, 246, 246, 246, 246, 246, 246, 246, 247, 247, 247, 247, 247, 247, 247, 247,
    248, 248, 248, 248, 248, 248, 248, 248, 249, 249, 249, 249, 249, 249, 249, 249,
    250, 250, 250, 250, 250, 250, 250, 250, 251, 251, 251, 251, 251, 251, 251, 251,
    252, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253,
    254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255,
    256, 256, 256, 256, 256, 256, 256, 256, 257, 257, 257, 257, 257, 257, 257, 257,
    258, 258, 258, 258, 258, 258, 258, 258, 259, 259, 259, 259, 259, 259, 259, 259,
    260, 260, 260, 260, 260, 260, 260, 260, 261, 261, 261, 261, 261, 261, 261, 261,
    262, 262, 262, 262, 262, 262, 262, 262, 263, 263, 263, 263, 263, 263, 263, 263,
    264, 264, 264, 264, 264, 264, 264, 264, 265, 265, 265, 265, 265, 265, 265, 265,
    266, 266, 266, 266, 266, 266, 266, 266, 267, 267, 267, 267, 267, 267, 267, 267,
    268, 268, 268, 268, 268, 268, 268, 268, 269, 269, 269, 269, 269, 269, 269, 269,
    270, 270, 270, 270, 270, 270, 270, 270, 271, 271, 271, 271, 271, 271, 271, 271,
    272, 272, 272, 272, 272, 272, 272, 272, 273, 273, 273, 273, 273, 273, 273, 273,
    274, 274, 274, 274, 274, 274, 274, 274, 275, 275, 275, 275, 275, 275, 275, 275,
    276, 276, 276, 276, 276, 276, 276, 276, 277, 277, 277, 277, 277, 277, 277, 277,
    278, 278, 278, 278, 278, 278, 278, 278, 279, 279, 279, 279, 279, 279, 279, 279,
    280, 280, 280, 280, 280, 280, 280, 280, 281, 281, 281, 281, 281, 281, 281, 281,
    282, 282, 282, 282, 282, 282, 282, 282, 283, 283, 283, 283, 283, 283, 283, 283,
    284, 284, 284, 284, 284, 284, 284, 284, 285, 285, 285, 285, 285, 285, 285, 285,
    286, 286, 286, 286, 286, 286, 286, 286, 287, 287, 287, 287, 287, 287, 287, 287,
    288, 288, 288, 288, 288, 288, 288, 288, 289, 289, 289, 289, 289, 289, 289, 289,
    290, 290, 290, 290, 290, 290, 290, 290, 291, 291, 291, 291, 291, 291, 291, 291,
    292, 292, 292, 292, 292, 292, 292, 292, 293, 293, 293, 293, 293, 293, 293, 293,
    294, 294, 294, 294, 294, 294, 294, 294, 295, 295, 295, 295, 295, 295, 295, 295,
    296, 296, 296, 296, 296, 296, 296, 296, 297, 297, 297, 297, 297, 297, 297, 297,
    298, 298, 298, 298, 298, 298, 298, 298, 299, 299, 299, 299, 299, 299, 299, 299,
    300, 300, 300, 300, 300, 300, 300, 300,
};

/* Block: 13160 bytes. */

RE_UINT32 re_get_block(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 10;
    code = ch ^ (f << 10);
    pos = (RE_UINT32)re_block_stage_1[f] << 5;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_block_stage_2[pos + f] << 2;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_block_stage_3[pos + f] << 3;
    value = re_block_stage_4[pos + code];

    return value;
}

/* Script. */

static RE_UINT8 re_script_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  7,  8,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  9, 10, 11, 12, 12, 12, 12, 13, 14, 14, 14, 14, 15,
    16, 17, 18, 19, 20, 14, 21, 14, 22, 14, 14, 14, 14, 23, 24, 24,
    25, 26, 14, 14, 14, 14, 27, 28, 14, 14, 29, 30, 31, 32, 33, 34,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 35,  7, 36, 37,  7, 38,  7,  7,  7, 39, 14, 40,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    41, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
};

static RE_UINT8 re_script_stage_2[] = {
      0,   1,   2,   2,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,
     14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  32,  33,  34,  35,  36,  37,  37,  37,  37,  37,  38,  39,  40,
     41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,   2,   2,  53,  54,
     55,  56,  57,  58,  59,  59,  59,  59,  60,  59,  59,  59,  59,  59,  59,  59,
     61,  61,  59,  59,  59,  59,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,
     72,  73,  74,  75,  76,  77,  78,  59,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  79,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  80,
     81,  81,  81,  81,  81,  81,  81,  81,  81,  82,  83,  83,  84,  85,  86,  87,
     88,  89,  90,  91,  92,  93,  94,  95,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  96,
     97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
     97,  97,  70,  70,  98,  99, 100, 101, 102, 102, 103, 104, 105, 106, 107, 108,
    109, 110, 111, 112,  97, 113, 114, 115, 116, 117, 118,  97, 119, 119, 120,  97,
    121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131,  97, 132,  97, 133, 134,
    135, 136, 137, 138, 139, 140, 141,  97, 142, 143,  97, 144, 145, 146, 147,  97,
    148, 149,  97, 150, 151, 152,  97,  97, 153, 154, 155, 156,  97, 157,  97, 158,
    159, 159, 159, 159, 159, 159, 159, 160, 161, 159, 162,  97,  97,  97,  97,  97,
    163, 163, 163, 163, 163, 163, 163, 163, 164,  97,  97,  97,  97,  97,  97,  97,
     97,  97,  97,  97,  97,  97,  97,  97, 165, 165, 165, 165, 166,  97,  97,  97,
    167, 167, 167, 167, 168, 169, 170, 171,  97,  97,  97,  97, 172, 173, 174, 175,
    176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176,
    176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 177,
    176, 176, 176, 176, 176, 178,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
    179, 180, 181, 182, 182, 183,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
     97,  97,  97,  97,  97,  97,  97,  97, 184, 185,  97,  97,  97,  97,  97,  97,
     59, 186, 187, 188, 189, 190, 191,  97, 192, 193, 194,  59,  59, 195,  59, 196,
    197, 197, 197, 197, 197, 198,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
    199,  97, 200,  97,  97, 201,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
    202, 203, 204,  97,  97,  97,  97,  97, 205, 206, 207,  97, 208, 209,  97,  97,
    210, 211, 212, 213, 214,  97,  59,  59,  59,  59,  59,  59,  59, 215, 216, 217,
    218, 219, 220, 221, 222, 223,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70, 224,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70, 225,  70,
    226,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70, 227,  70,  70,
     70,  70,  70,  70,  70,  70,  70, 228,  97,  97,  97,  97,  97,  97,  97,  97,
     70,  70,  70,  70, 229,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
    230,  97, 231, 232,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,  97,
};

static RE_UINT16 re_script_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   2,   3,   1,   2,   2,   3,
      0,   0,   0,   0,   0,   4,   0,   4,   2,   2,   5,   2,   2,   2,   5,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   6,   0,   0,   0,   0,   7,   8,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  11,
     12,  13,  14,  14,  15,  14,  14,  14,  14,  14,  14,  14,  16,  17,  14,  14,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     19,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  20,  21,  21,  21,  22,  20,  21,  21,  21,  21,
     21,  23,  24,  25,  25,  25,  25,  25,  25,  26,  25,  25,  25,  27,  28,  26,
     29,  30,  31,  32,  31,  31,  31,  31,  33,  34,  35,  31,  31,  31,  36,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  29,  31,  31,  31,  31,
     37,  38,  37,  37,  37,  37,  37,  37,  37,  39,  31,  31,  31,  31,  31,  31,
     40,  40,  40,  40,  40,  40,  41,  26,  42,  42,  42,  42,  42,  42,  42,  43,
     44,  44,  44,  44,  44,  45,  44,  46,  47,  47,  47,  48,  37,  49,  26,  26,
     26,  26,  26,  26,  31,  31,  50,  51,  26,  26,  52,  31,  53,  31,  31,  31,
     54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  55,  54,  56,  54,  54,  54,
     57,  58,  59,  60,  60,  61,  62,  63,  58,  64,  65,  66,  67,  60,  60,  68,
     69,  70,  71,  72,  72,  73,  74,  75,  70,  76,  77,  78,  79,  72,  80,  26,
     81,  82,  83,  84,  84,  85,  86,  87,  82,  88,  89,  26,  90,  84,  91,  92,
     93,  94,  95,  96,  96,  97,  98,  99,  94, 100, 101, 102, 103,  96,  96,  26,
    104, 105, 106, 107, 108, 105, 109, 110, 105, 106, 111,  26, 112, 109, 109, 113,
    114, 115, 116, 114, 114, 116, 114, 117, 115, 118, 119, 120, 121, 114, 122, 114,
    123, 124, 125, 123, 123, 125, 126, 127, 124, 128, 129, 130, 131, 123, 132,  26,
    133, 134, 135, 136, 136, 136, 136, 136, 134, 135, 137, 136, 138, 136, 136, 136,
    139, 140, 141, 142, 140, 140, 143, 144, 141, 145, 146, 140, 147, 140, 148,  26,
    149, 150, 150, 150, 150, 150, 150, 151, 150, 150, 150, 152,  26,  26,  26,  26,
    153, 154, 155, 155, 156, 155, 155, 157, 158, 157, 155, 159,  26,  26,  26,  26,
    160, 160, 160, 160, 160, 160, 160, 160, 160, 161, 160, 160, 160, 162, 161, 160,
    160, 160, 160, 161, 160, 160, 160, 163, 160, 163, 164, 165,  26,  26,  26,  26,
    166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 166,
    166, 166, 166, 166, 167, 167, 167, 167, 168, 169, 167, 167, 167, 167, 167, 170,
    171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171,
    172, 172, 172, 172, 172, 172, 172, 172, 172, 173, 174, 173, 172, 172, 172, 172,
    172, 173, 172, 172, 172, 172, 173, 174, 173, 172, 174, 172, 172, 172, 172, 172,
    172, 172, 173, 172, 172, 172, 172, 172, 172, 172, 172, 175, 172, 172, 172, 176,
    172, 172, 172, 177, 178, 178, 178, 178, 178, 178, 178, 178, 178, 178, 179, 179,
    180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180,
    181, 181, 181, 182, 183, 183, 183, 183, 183, 183, 183, 183, 183, 184, 183, 185,
    186, 187, 188,  26, 189, 189, 190,  26, 191, 191, 192,  26, 193, 194, 195,  26,
    196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 197, 196, 198, 196, 198,
    199, 200, 201, 202, 201, 201, 201, 201, 201, 201, 201, 201, 201, 201, 201, 203,
    201, 201, 201, 201, 201, 204, 180, 180, 180, 180, 180, 180, 180, 180, 205,  26,
    206, 206, 206, 207, 206, 208, 206, 208, 209, 206, 210, 210, 210, 211, 212,  26,
    213, 213, 213, 213, 213, 214, 213, 213, 213, 215, 213, 216, 196, 196, 196, 196,
    217, 217, 217, 218, 219, 219, 219, 219, 219, 219, 219, 220, 219, 219, 219, 221,
    219, 222, 219, 222, 219, 223,   9, 224,  26,  26,  26,  26,  26,  26,  26,  26,
    225, 225, 225, 225, 225, 225, 225, 225, 225, 226, 225, 225, 225, 225, 225, 227,
    228, 228, 228, 228, 228, 228, 228, 228, 229, 229, 229, 229, 229, 229, 230, 231,
    232, 232, 232, 232, 232, 232, 232, 233, 232, 234, 235, 235, 235, 235, 235, 235,
     18, 236, 167, 167, 167, 167, 167, 237, 228,  26, 238,   9, 239, 240, 241, 242,
      2,   2,   2,   2, 243, 244,   2,   2,   2,   2,   2, 245, 246, 247,   2, 248,
      2,   2,   2,   2,   2,   2,   2, 249,   9,   9,   9,   9,   9,   9,   9, 250,
     14,  14, 251, 251,  14,  14,  14,  14, 251, 251,  14, 252,  14,  14,  14, 251,
     14,  14,  14,  14,  14,  14, 253,  14, 253,  14, 254, 255,  14,  14, 256, 257,
      0, 258,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 259,   0, 260, 261,
      0, 262,   2, 263,   0,   0,   0,   0,  26,  26,   9,   9,   9,   9, 264,  26,
      0,   0,   0,   0, 265, 266,   4,   0,   0, 267,   0,   0,   2,   2,   2,   2,
      2, 268,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 262,  26,  26,  26,   0, 269,  26,  26,   0,   0,   0,   0,
    270, 270, 270, 270, 270, 270, 270, 270, 270, 270, 270, 270, 270, 270, 270, 270,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 271,   0,
      0,   0, 272,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    273, 273, 273, 273, 273, 274, 273, 273, 273, 273, 273, 274,   2,   2,   2,   2,
     17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17, 275, 276,
    167, 167, 167, 167, 168, 169, 277, 277, 277, 277, 277, 277, 277, 278, 279, 278,
    172, 172, 174,  26, 174, 174, 174, 174, 174, 174, 174, 174,  18,  18,  18,  18,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  26,  26,  26,  26,  26,  26,
    280, 280, 280, 281, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 282,  26,
    280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,
    280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 283,  26,  26,  26,   0, 284,
    285,   0,   0,   0, 286, 287,   0, 288, 289, 290, 290, 290, 290, 290, 290, 290,
    290, 290, 291, 292, 293, 294, 294, 294, 294, 294, 294, 294, 294, 294, 294, 295,
    296, 297, 297, 297, 297, 297, 298, 171, 171, 171, 171, 171, 171, 171, 171, 171,
    171, 299,   0,   0, 297, 297, 297, 300,   0,   0,   0,   0, 284,  26, 294, 294,
    171, 171, 171, 299,   0,   0,   0,   0,   0,   0,   0,   0, 171, 171, 171, 301,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 294, 294, 294, 294, 294, 302,
    294, 294, 294, 294, 294, 294, 294, 294, 294, 294, 294,   0,   0,   0,   0,   0,
    280, 280, 280, 280, 280, 280, 283,  26,   0,   0,   0,   0,   0,   0,   0,   0,
    280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,  26,  26,
    303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303,
    303, 304, 303, 303, 303, 303, 303, 303, 305,  26, 306, 306, 306, 306, 306, 306,
    307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307,
    307, 307, 307, 307, 307, 308,  26,  26,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309,  26,
      0,   0,   0,   0, 310,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2, 311,   2,   2,   2,   2,   2,   2, 312,  26,  26,  26,  26,  26, 313,   2,
    314, 314, 314, 314, 314, 315,   0, 316, 317, 317, 317, 317, 317, 317, 317,  26,
    318, 318, 318, 318, 318, 318, 318, 318, 319, 320, 318, 321,  54,  54,  54,  54,
    322, 322, 322, 322, 322, 323, 324, 324, 324, 324, 325, 326, 171, 171, 171, 327,
    328, 328, 328, 328, 328, 328, 328, 328, 328, 329, 328, 330, 166, 166, 166, 331,
    332, 332, 332, 332, 332, 332, 333,  26, 332, 334, 332, 335, 166, 166, 166, 166,
    336, 336, 336, 336, 336, 336, 336, 336, 337,  26,  26, 338, 339, 339, 340,  26,
    341, 341, 341,  26, 174, 174,   2,   2,   2,   2,   2, 342, 343,  26, 178, 178,
    178, 178, 178, 178, 178, 178, 178, 178, 339, 339, 339, 339, 339, 344, 339, 345,
    171, 171, 171, 171, 346,  26, 171, 171, 299, 347, 171, 171, 171, 171, 171, 346,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 283, 280, 280,
    280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 348,  26,  26,  26,  26,
    349,  26, 350, 351,  25,  25, 352, 353, 354,  25,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31, 355,  26,  52,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31, 356,  26,  26,  31,  31,  31,  31,  31,  31,
     31,  31, 357,  31,  31,  31,  31,  31,  31,  26,  26,  26,  26,  26,  31,  51,
      9,   9,   0, 316,   9, 358,   0,   0,   0,   0, 359,   0, 262, 284,  50,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31, 360,
    361,   0,   0,   0,   1,   2,   2,   3,   1,   2,   2,   3, 362, 294, 293, 294,
    294, 294, 294, 363, 171, 171, 171, 299, 364, 364, 364, 365, 262, 262,  26, 366,
    367, 368, 367, 367, 369, 367, 367, 370, 367, 371, 367, 371,  26,  26,  26,  26,
    367, 367, 367, 367, 367, 367, 367, 367, 367, 367, 367, 367, 367, 367, 367, 372,
    373,   0,   0,   0,   0,   0, 374,   0,  14,  14,  14,  14,  14,  14,  14,  14,
     14, 257,   0, 284, 375,  26,  26,  26,  26,  26,   0,   0,   0,   0,   0, 376,
    377, 377, 377, 378, 379, 379, 379, 379, 379, 379, 380,  26, 381,   0,   0, 284,
    382, 382, 382, 382, 383, 384, 385, 385, 385, 386, 387, 387, 387, 387, 387, 388,
    389, 389, 389, 390, 391, 391, 391, 391, 392, 391, 393,  26,  26,  26,  26,  26,
    394, 394, 394, 394, 394, 394, 394, 394, 394, 394, 395, 395, 395, 395, 395, 395,
    396, 396, 396, 397, 396, 398, 399, 399, 399, 399, 400, 399, 399, 399, 399, 400,
    401, 401, 401, 401, 401,  26, 402, 402, 402, 402, 402, 402, 403, 404,  26,  26,
    405, 405, 405, 405, 405, 405, 405, 405, 405, 405, 405, 405, 405, 405, 405, 405,
    405, 405, 405, 405, 405, 405, 406,  26, 405, 405, 407,  26, 405,  26,  26,  26,
    408, 409, 410, 410, 410, 410, 411, 412, 413, 413, 414, 413, 415, 415, 415, 415,
    416, 416, 416, 417, 418, 416,  26,  26,  26,  26,  26,  26, 419, 419, 420, 421,
    422, 422, 422, 423, 424, 424, 424, 425,  26,  26,  26,  26,  26,  26,  26,  26,
    426, 426, 426, 426, 427, 427, 427, 428, 427, 427, 429, 427, 427, 427, 427, 427,
    430, 431, 432, 433, 434, 434, 435, 436, 434, 437, 434, 437, 438, 438, 438, 438,
    439, 439, 439, 439,  26,  26,  26,  26, 440, 440, 440, 440, 441, 442, 441,  26,
    443, 443, 443, 443, 443, 443, 444, 445, 446, 446, 447, 446, 448, 448, 449, 448,
    450, 450, 451, 452,  26, 453,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    454, 454, 454, 454, 454, 454, 454, 454, 454, 455,  26,  26,  26,  26,  26,  26,
    456, 456, 456, 456, 456, 456, 457,  26, 456, 456, 456, 456, 456, 456, 457, 458,
    459, 459, 459, 459, 459,  26, 459, 460,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  31,  31,  31, 461,
    462, 462, 462, 462, 462,  26, 463, 463, 463, 463, 463, 464,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 465, 465, 466,  26,
    467, 467, 467, 467, 467, 467, 467, 467, 467, 468, 469, 467, 467, 467,  26, 470,
    471, 471, 471, 471, 471, 471, 471, 471, 472, 473, 474, 474, 474, 475, 474, 476,
    477, 477, 477, 477, 477, 477, 478, 477, 479,  26, 480, 480, 480, 480, 481,  26,
    482, 482, 482, 482, 482, 482, 482, 482, 482, 483, 482, 482, 484, 140, 485,  26,
    486, 486, 487, 486, 486, 486, 486, 488,  26,  26,  26,  26,  26,  26,  26,  26,
    489, 490, 491, 492, 491, 493, 494, 494, 494, 494, 494, 494, 494, 495, 494, 496,
    497, 498, 499, 500, 500, 501, 502, 503, 498, 504, 505, 506, 507, 508, 508,  26,
    509, 509, 509, 509, 509, 509, 509, 509, 509, 509, 509, 510,  26,  26,  26,  26,
    511, 511, 511, 511, 511, 511, 511, 511, 511,  26, 511, 512,  26,  26,  26,  26,
    513, 513, 513, 513, 513, 513, 514, 513, 513, 513, 513, 514,  26,  26,  26,  26,
    515, 515, 515, 515, 515, 515, 515, 515, 516,  26, 515, 517, 201, 518,  26,  26,
    519, 519, 519, 519, 519, 519, 519, 520, 519, 521,  26,  26,  26,  26,  26,  26,
    522, 522, 522, 523, 522, 524, 522, 522,  26,  26,  26,  26,  26,  26,  26,  26,
    525, 525, 525, 525, 525, 525, 525, 526,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26, 527, 527, 527, 527, 527, 527, 527, 527, 527, 527, 528, 529,
     26,  26,  26,  26, 530, 531, 530, 530, 530, 530, 530, 531, 532,  26,  26,  26,
    533, 533, 533, 533, 533, 533, 533, 533, 533,  26, 534, 534, 534, 534, 534, 534,
    534, 534, 534, 534, 535,  26,  26,  26, 536, 536, 536, 536, 536, 536, 536, 537,
    538, 539, 538, 538, 538, 538, 540, 538, 541,  26, 538, 538, 538, 542, 543, 543,
    543, 543, 544, 543, 543, 545, 546,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    547, 548, 549, 549, 549, 549, 547, 550, 549,  26, 549, 551, 552, 553, 554, 554,
    554, 555, 556, 557, 554, 558,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 559, 559, 559, 560,
     26,  26,  26,  26,  26,  26,  26,  26, 109, 109, 109, 109, 109, 109, 561, 562,
    563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563,
    563, 563, 563, 564,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 565, 566,  26,
    563, 563, 563, 563, 563, 563, 563, 563, 567,  26,  26,  26,  26,  26,  26,  26,
    568, 568, 568, 568, 568, 568, 568, 568, 568, 568, 568, 568, 568, 568, 568, 568,
    568, 568, 568, 568, 568, 569, 568, 570,  26,  26,  26,  26,  26,  26,  26,  26,
    571, 571, 571, 571, 571, 571, 571, 571, 571, 571, 571, 571, 571, 571, 571, 571,
    571, 571, 571, 571, 571, 571, 571, 571, 572,  26,  26,  26,  26,  26,  26,  26,
    309, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309, 309,
    309, 309, 309, 309, 309, 309, 309, 573, 574, 574, 574, 575, 574, 576,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 577, 577, 577, 578, 578,  26,
    579, 579, 579, 579, 579, 579, 579, 579, 580,  26, 579, 581, 581, 579, 579, 582,
    579, 579,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26, 583, 583, 583, 583, 583, 583, 583, 583,
    583, 583, 583, 584,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    585, 585, 585, 585, 585, 585, 585, 585, 585, 586, 585, 585, 585, 585, 585, 585,
    585, 587, 585, 585,  26,  26,  26,  26,  26,  26,  26,  26, 588,  26,  26,  26,
    589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589,
    589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589,  26,
    589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 589, 590,  26,
    591, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290,
    290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290,
    290, 290, 290, 291,  26,  26,  26,  26,  26,  26, 592,  26, 593,  26, 594, 594,
    594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594,
    594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 594, 595,
    596, 596, 596, 596, 596, 596, 596, 596, 596, 596, 596, 596, 596, 597, 596, 598,
    596, 599, 596, 600, 284,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 272,  26,
      0,   0,   0,   0, 262, 361,   0,   0,   0,   0,   0,   0, 601, 602,   0, 603,
    604, 605,   0,   0,   0, 606,   0,   0,   0,   0,   0,   0,   0, 607,  26,  26,
     14,  14,  14,  14,  14,  14,  14,  14, 251,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,   0,   0, 284,  26,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 262,  26,   0,   0,   0, 607,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 259,   0,   0,   0,   0,   0,
      0,   0,   0, 259, 608, 609,   0, 610, 611,   0,   0,   0,   0,   0,   0,   0,
    612, 613, 259, 259,   0,   0,   0, 614, 615, 616, 617,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 272,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0, 271,   0,   0,   0,   0,   0,   0,
    618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618, 618,
    618, 619,  26, 620, 621, 618,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    274, 273, 273, 622, 623, 624,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    625, 625, 625, 625, 625, 626, 625, 627, 625, 628,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26, 629, 629, 629, 629, 629, 629, 629, 630,
    631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631, 632, 631, 633,  26,  26,  26,  26,  26,
    634, 634, 634, 634, 634, 634, 634, 634, 634, 635, 634, 636,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 361,   0,
      0,   0,   0,   0,   0,   0, 637,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    361,   0,   0,   0,   0,   0,   0, 272,  26,  26,  26,  26,  26,  26,  26,  26,
    638,  31,  31,  31, 639, 640, 641, 642, 643, 644, 639, 645, 639, 641, 641, 646,
     31, 647,  31, 648, 649, 647,  31, 648,  26,  26,  26,  26,  26,  26, 355,  26,
      0,   0,   0,   0,   0, 284,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0, 284,  26,   0, 262, 361,   0, 361,   0, 361,   0,   0,   0, 272,  26,
      0, 637,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 637,   0,   0,
      0,   0,   0,   0,   0, 637,  26,  26,  26,  26,  26,  26, 650,   0,   0,   0,
    651,  26,   0,   0,   0,   0,   0, 284,   0, 607, 316,  26, 272,  26,  26,  26,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 272,  26,   0, 637,   0, 269,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 284,  26,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 607,   0, 284,  26,  26,
      0, 284,   0,   0,   0,   0,   0,   0,   0,  26,   0, 316,   0,   0,   0,   0,
      0,  26,   0,   0,   0, 272,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
      0, 611,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 614, 616,
      0,   0,   0,   0, 613, 652,   0,   0,   0, 613,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 284,  26,   0, 272, 284, 269,
    269,  26, 272,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 653,  26,  26,  26,  26,  26,
    280, 280, 280, 280, 280, 280, 654,  26, 280, 280, 280, 280, 280, 280, 280, 280,
    280, 280, 280, 283, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,
    280, 280, 280, 280, 348,  26, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280,
    280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 655,  26,  26,  26,
    280, 280, 280, 283,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
    656,  26,  26,  26,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  26,  26,
};

static RE_UINT8 re_script_stage_4[] = {
      1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,
      1,   1,   2,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   1,
      2,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   1,   1,   1,
      1,   1,  35,  35,   1,   1,   1,   1,  41,  41,  41,  41,  41,  41,  41,  41,
      3,   3,   3,   3,   1,   3,   3,   3,   0,   0,   3,   3,   3,   3,   1,   3,
      0,   0,   0,   0,   3,   1,   3,   1,   3,   3,   3,   0,   3,   0,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,   3,   3,   3,   3,   3,
      3,   3,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,  41,  41,   4,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   1,   5,   0,   0,   5,   5,   5,
      0,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      0,   0,   0,   0,   0,   0,   0,   0,   6,   6,   6,   0,   0,   0,   0,   6,
      6,   6,   6,   6,   6,   0,   0,   0,   7,   7,   7,   7,   7,   1,   7,   7,
      7,   7,   7,   7,   1,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   1,   7,   0,   7,   1,   1,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,  41,   7,   7,
     41,   7,   7,   7,   7,   7,   7,   7,   8,   8,   8,   8,   8,   8,   8,   8,
      8,   8,   8,   8,   8,   8,   0,   8,   8,   8,   8,   0,   0,   8,   8,   8,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,   0,   0,   0,   0,   0,
     66,  66,  66,  66,  66,  66,  66,  66,  66,  66,  66,   0,   0,  66,  66,  66,
     82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  82,   0,   0,
     82,  82,  82,  82,  82,  82,  82,   0,  95,  95,  95,  95,  95,  95,  95,  95,
     95,  95,  95,  95,   0,   0,  95,   0,   8,   8,   8,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   0,   7,   7,   7,   7,   7,   7,   7,   7,   0,   0,
      0,   0,   0,   7,   7,   7,   7,   7,   7,   7,   1,   7,   7,   7,   7,   7,
     10,  10,  10,  10,  10,  10,  10,  10,  10,  41,  41,  41,  41,  10,  10,  10,
     10,  10,  10,  10,   1,   1,  10,  10,  11,  11,  11,  11,   0,  11,  11,  11,
     11,  11,  11,  11,  11,   0,   0,  11,  11,   0,   0,  11,  11,  11,  11,  11,
     11,  11,  11,  11,  11,  11,  11,  11,  11,   0,  11,  11,  11,  11,  11,  11,
     11,   0,  11,   0,   0,   0,  11,  11,  11,  11,   0,   0,  11,  11,  11,  11,
     11,   0,   0,  11,  11,  11,  11,   0,   0,   0,   0,   0,   0,   0,   0,  11,
      0,   0,   0,   0,  11,  11,   0,  11,  11,  11,  11,  11,   0,   0,  11,  11,
     11,  11,  11,  11,  11,  11,  11,   0,   0,  12,  12,  12,   0,  12,  12,  12,
     12,  12,  12,   0,   0,   0,   0,  12,  12,   0,   0,  12,  12,  12,  12,  12,
     12,  12,  12,  12,  12,  12,  12,  12,  12,   0,  12,  12,  12,  12,  12,  12,
     12,   0,  12,  12,   0,  12,  12,   0,  12,  12,   0,   0,  12,   0,  12,  12,
     12,   0,   0,  12,  12,  12,   0,   0,   0,  12,   0,   0,   0,   0,   0,   0,
      0,  12,  12,  12,  12,   0,  12,   0,   0,   0,   0,   0,   0,   0,  12,  12,
     12,  12,  12,  12,  12,  12,  12,   0,   0,  13,  13,  13,   0,  13,  13,  13,
     13,  13,  13,  13,  13,  13,   0,  13,  13,  13,   0,  13,  13,  13,  13,  13,
     13,  13,  13,  13,  13,  13,  13,  13,  13,   0,  13,  13,  13,  13,  13,  13,
     13,   0,  13,  13,   0,  13,  13,  13,  13,  13,   0,   0,  13,  13,  13,  13,
     13,  13,   0,  13,  13,  13,   0,   0,  13,   0,   0,   0,   0,   0,   0,   0,
     13,  13,  13,  13,   0,   0,  13,  13,  13,  13,   0,   0,   0,   0,   0,   0,
      0,  13,  13,  13,  13,  13,  13,  13,   0,  14,  14,  14,   0,  14,  14,  14,
     14,  14,  14,  14,  14,   0,   0,  14,  14,   0,   0,  14,  14,  14,  14,  14,
     14,  14,  14,  14,  14,  14,  14,  14,  14,   0,  14,  14,  14,  14,  14,  14,
     14,   0,  14,  14,   0,  14,  14,  14,  14,  14,   0,   0,  14,  14,  14,  14,
     14,   0,   0,  14,  14,  14,   0,   0,   0,   0,   0,   0,   0,   0,  14,  14,
      0,   0,   0,   0,  14,  14,   0,  14,  14,  14,  14,  14,   0,   0,  14,  14,
      0,   0,  15,  15,   0,  15,  15,  15,  15,  15,  15,   0,   0,   0,  15,  15,
     15,   0,  15,  15,  15,  15,   0,   0,   0,  15,  15,   0,  15,   0,  15,  15,
      0,   0,   0,  15,  15,   0,   0,   0,  15,  15,  15,  15,  15,  15,  15,  15,
     15,  15,   0,   0,   0,   0,  15,  15,  15,   0,   0,   0,   0,   0,   0,  15,
      0,   0,   0,   0,   0,   0,  15,  15,  15,  15,  15,   0,   0,   0,   0,   0,
     16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,   0,  16,  16,
     16,   0,  16,  16,  16,  16,  16,  16,  16,  16,   0,   0,   0,  16,  16,  16,
     16,   0,  16,  16,  16,  16,   0,   0,   0,   0,   0,   0,   0,  16,  16,   0,
     16,  16,  16,   0,   0,   0,   0,   0,  16,  16,  16,  16,   0,   0,  16,  16,
      0,   0,   0,   0,   0,   0,   0,  16,  17,  17,  17,  17,  17,  17,  17,  17,
     17,  17,  17,  17,  17,   0,  17,  17,  17,   0,  17,  17,  17,  17,  17,  17,
     17,  17,  17,  17,   0,  17,  17,  17,  17,  17,   0,   0,  17,  17,  17,  17,
     17,   0,  17,  17,  17,  17,   0,   0,   0,   0,   0,   0,   0,  17,  17,   0,
      0,   0,   0,   0,   0,   0,  17,   0,  17,  17,  17,  17,   0,   0,  17,  17,
      0,  17,  17,   0,   0,   0,   0,   0,  18,  18,  18,  18,   0,  18,  18,  18,
     18,  18,  18,  18,  18,   0,  18,  18,  18,   0,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,   0,   0,   0,   0,  18,  18,  18,  18,
     18,  18,  18,  18,   0,   0,  18,  18,   0,   0,  19,  19,   0,  19,  19,  19,
     19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,   0,
      0,   0,  19,  19,  19,  19,  19,  19,  19,  19,   0,  19,  19,  19,  19,  19,
     19,  19,  19,  19,   0,  19,   0,   0,   0,   0,  19,   0,   0,   0,   0,  19,
     19,  19,  19,  19,  19,   0,  19,   0,   0,   0,   0,   0,   0,   0,  19,  19,
      0,   0,  19,  19,  19,   0,   0,   0,   0,  20,  20,  20,  20,  20,  20,  20,
     20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,   0,   0,   0,   0,   1,
     20,  20,  20,  20,   0,   0,   0,   0,   0,  21,  21,   0,  21,   0,  21,  21,
     21,  21,  21,   0,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,
     21,  21,  21,  21,   0,  21,   0,  21,  21,  21,  21,  21,  21,  21,   0,   0,
     21,  21,  21,  21,  21,   0,  21,   0,  21,  21,   0,   0,  21,  21,  21,  21,
     22,  22,  22,  22,  22,  22,  22,  22,   0,  22,  22,  22,  22,  22,  22,  22,
     22,  22,  22,  22,  22,   0,   0,   0,  22,  22,  22,  22,  22,   0,  22,  22,
     22,  22,  22,  22,  22,   1,   1,   1,   1,  22,  22,   0,   0,   0,   0,   0,
     23,  23,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,
     24,  24,  24,  24,  24,  24,   0,  24,   0,   0,   0,   0,   0,  24,   0,   0,
     24,  24,  24,   1,  24,  24,  24,  24,  25,  25,  25,  25,  25,  25,  25,  25,
     26,  26,  26,  26,  26,  26,  26,  26,  26,   0,  26,  26,  26,  26,   0,   0,
     26,  26,  26,  26,  26,  26,  26,   0,  26,  26,  26,   0,   0,  26,  26,  26,
     26,  26,  26,  26,  26,   0,   0,   0,  26,  26,   0,   0,   0,   0,   0,   0,
     27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,   0,   0,
     28,  28,  28,  28,  28,  28,  28,  28,  29,  29,  29,  29,  29,  29,  29,  29,
     29,  29,  29,  29,  29,   0,   0,   0,  30,  30,  30,  30,  30,  30,  30,  30,
     30,  30,  30,   1,   1,   1,  30,  30,  30,   0,   0,   0,   0,   0,   0,   0,
     42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,   0,  42,  42,
     42,  42,  42,  42,  42,   0,   0,   0,  43,  43,  43,  43,  43,  43,  43,  43,
     43,  43,  43,  43,  43,   1,   1,   0,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,   0,   0,   0,   0,  45,  45,  45,  45,  45,  45,  45,  45,
     45,  45,  45,  45,  45,   0,  45,  45,  45,   0,  45,  45,   0,   0,   0,   0,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,   0,   0,
     31,  31,   0,   0,   0,   0,   0,   0,  32,  32,   1,   1,  32,   1,  32,  32,
     32,  32,  32,  32,  32,  32,  32,   0,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,   0,   0,   0,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,
     32,  32,  32,   0,   0,   0,   0,   0,  28,  28,  28,  28,  28,  28,   0,   0,
     46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,   0,
     46,  46,  46,  46,   0,   0,   0,   0,  46,   0,   0,   0,  46,  46,  46,  46,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,   0,   0,
     47,  47,  47,  47,  47,   0,   0,   0,  56,  56,  56,  56,  56,  56,  56,  56,
     56,  56,  56,  56,   0,   0,   0,   0,  56,  56,   0,   0,   0,   0,   0,   0,
     56,  56,  56,   0,   0,   0,  56,  56,  54,  54,  54,  54,  54,  54,  54,  54,
     54,  54,  54,  54,   0,   0,  54,  54,  78,  78,  78,  78,  78,  78,  78,  78,
     78,  78,  78,  78,  78,  78,  78,   0,  78,  78,  78,  78,  78,   0,   0,  78,
     78,  78,   0,   0,   0,   0,   0,   0,  78,  78,  78,  78,  78,  78,   0,   0,
     41,  41,  41,  41,  41,  41,  41,   0,  62,  62,  62,  62,  62,  62,  62,  62,
     62,  62,  62,  62,   0,   0,   0,   0,  62,  62,  62,  62,  62,   0,   0,   0,
     67,  67,  67,  67,  67,  67,  67,  67,  93,  93,  93,  93,  93,  93,  93,  93,
     93,  93,  93,  93,   0,   0,   0,   0,   0,   0,   0,   0,  93,  93,  93,  93,
     68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,  68,  68,  68,  68,  68,
     68,  68,   0,   0,   0,  68,  68,  68,  69,  69,  69,  69,  69,  69,  69,  69,
      4,   0,   0,   0,   0,   0,   0,   0,  24,  24,  24,   0,   0,  24,  24,  24,
     41,  41,  41,   1,  41,  41,  41,  41,  41,   1,  41,  41,  41,  41,  41,  41,
     41,   1,   1,   1,   1,  41,   1,   1,   1,   1,   1,   1,  41,   1,   1,   1,
     41,  41,   1,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   3,   3,
      3,   3,   3,   4,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,
      3,   3,   2,   2,   2,   2,   3,   3,   3,   3,   3,   2,   2,   2,   2,   2,
      4,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,
     41,  41,   0,  41,  41,  41,  41,  41,   3,   3,   3,   3,   3,   3,   0,   0,
      0,   3,   0,   3,   0,   3,   0,   3,   3,   3,   3,   3,   3,   0,   3,   3,
      3,   3,   3,   3,   0,   0,   3,   3,   3,   3,   3,   3,   0,   3,   3,   3,
      0,   0,   3,   3,   3,   0,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,
      1,   1,   1,   1,  41,  41,   1,   1,   1,   1,   1,   1,   1,   0,   1,   1,
      1,   2,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,
      1,   1,   1,   1,   1,   1,   1,   0,   2,   2,   2,   2,   2,   0,   0,   0,
     41,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   3,   1,
      1,   1,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   1,
      2,   1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   0,   0,   0,   0,   0,
     53,  53,  53,  53,  53,  53,  53,  53,   1,   1,   1,   1,   0,   0,   1,   1,
      1,   1,   1,   1,   1,   1,   0,   0,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,   0,  55,  55,  55,  55,   0,   0,   0,   0,
      0,  55,  55,  55,  55,  55,  55,  55,  58,  58,  58,  58,  58,  58,  58,  58,
      0,   0,   0,   0,   0,   0,   0,  58,  58,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,  36,  36,  36,  36,  36,
     36,  36,  36,  36,   0,   0,   0,   0,  36,  36,  36,  36,  36,  36,   0,   0,
      1,   1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,   1,  36,   1,  36,
      1,  36,  36,  36,  36,  36,  36,  36,  36,  36,  41,  41,  41,  41,  25,  25,
     36,  36,  36,  36,   1,   1,   1,   1,   0,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   0,
      0,  41,  41,   1,   1,  33,  33,  33,   1,  34,  34,  34,  34,  34,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,   1,   1,  34,  34,  34,
      0,   0,   0,   0,   0,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,
      0,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,   0,
     35,  35,  35,   0,   0,   0,   0,   0,  25,  25,  25,  25,  25,  25,  25,   1,
     34,  34,  34,  34,  34,  34,  34,   1,  37,  37,  37,  37,  37,  37,  37,  37,
     37,  37,  37,  37,  37,   0,   0,   0,  37,  37,  37,  37,  37,  37,  37,   0,
     83,  83,  83,  83,  83,  83,  83,  83,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,   0,   0,   0,   0,  84,  84,  84,  84,  84,  84,  84,  84,
      1,   1,   2,   2,   2,   2,   2,   2,   1,   1,   1,   2,   2,   2,   2,   2,
      0,   0,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   2,
     59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,   0,   0,   0,   0,
      1,   1,   0,   0,   0,   0,   0,   0,  65,  65,  65,  65,  65,  65,  65,  65,
     71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,   0,   0,
      0,   0,   0,   0,   0,   0,  71,  71,  71,  71,   0,   0,   0,   0,   0,   0,
     72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,  72,   1,  72,
     73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  73,  25,  25,  25,  25,  25,   0,   0,   0,
     85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,   0,   1,
     85,  85,   0,   0,   0,   0,  85,  85,  23,  23,  23,  23,  23,  23,  23,   0,
     77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,  77,   0,
     77,  77,  77,  77,  77,  77,   0,   0,  77,  77,   0,   0,  77,  77,  77,  77,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,   0,   0,   0,   0,   0,
      0,   0,   0,  79,  79,  79,  79,  79,  86,  86,  86,  86,  86,  86,  86,  86,
     86,  86,  86,  86,  86,  86,  86,   0,   0,  26,  26,  26,  26,  26,  26,   0,
      2,   2,   2,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   2,   2,
     86,  86,  86,  86,  86,  86,   0,   0,  86,  86,   0,   0,   0,   0,   0,   0,
     25,  25,  25,  25,   0,   0,   0,   0,   0,   0,   0,  25,  25,  25,  25,  25,
     36,  36,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   0,
      0,   0,   0,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   0,   6,   6,   6,   6,   6,   0,   6,   0,
      6,   6,   0,   6,   6,   0,   6,   6,   7,   7,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,   1,   1,   0,   0,   7,   7,   7,   7,   7,   7,
     41,  41,  41,  41,  41,  41,   4,   4,   1,   1,   1,   0,   1,   1,   1,   1,
      7,   7,   7,   7,   7,   0,   0,   1,   0,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,  34,  34,  34,  34,  34,  34,  34,  34,   1,   1,
      0,   0,  25,  25,  25,  25,  25,  25,   0,   0,  25,  25,  25,   0,   0,   0,
      0,   1,   1,   1,   1,   1,   0,   0,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,   0,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,   0,
     48,  48,  48,   0,  48,  48,   0,  48,  48,  48,  48,  48,  48,  48,   0,   0,
     48,  48,  48,   0,   0,   0,   0,   0,   1,   1,   1,   0,   0,   0,   0,   1,
      1,   1,   1,   1,   0,   0,   0,   1,   3,   0,   0,   0,   0,   0,   0,   0,
      1,   1,   1,   1,   1,  41,   0,   0,  74,  74,  74,  74,  74,  74,  74,  74,
     74,  74,  74,  74,  74,   0,   0,   0,  75,  75,  75,  75,  75,  75,  75,  75,
     75,   0,   0,   0,   0,   0,   0,   0,  41,   1,   1,   1,   1,   1,   1,   1,
     38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  38,  38,  38,  39,  39,  39,  39,  39,  39,  39,  39,
     39,  39,  39,   0,   0,   0,   0,   0, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120,   0,   0,   0,   0,   0,  49,  49,  49,  49,  49,  49,  49,  49,
     49,  49,  49,  49,  49,  49,   0,  49,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,   0,   0,   0,   0,  60,  60,  60,  60,  60,  60,   0,   0,
     40,  40,  40,  40,  40,  40,  40,  40,  50,  50,  50,  50,  50,  50,  50,  50,
     51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,   0,   0,
     51,  51,   0,   0,   0,   0,   0,   0, 136, 136, 136, 136, 136, 136, 136, 136,
    136, 136, 136, 136,   0,   0,   0,   0, 106, 106, 106, 106, 106, 106, 106, 106,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 103, 110, 110, 110, 110, 110, 110, 110, 110,
    110, 110, 110, 110, 110, 110, 110,   0, 110, 110, 110, 110, 110, 110,   0,   0,
     52,  52,  52,  52,  52,  52,   0,   0,  52,   0,  52,  52,  52,  52,  52,  52,
     52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,   0,  52,
     52,   0,   0,   0,  52,   0,   0,  52,  87,  87,  87,  87,  87,  87,  87,  87,
     87,  87,  87,  87,  87,  87,   0,  87, 118, 118, 118, 118, 118, 118, 118, 118,
    117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117,   0,
      0,   0,   0,   0,   0,   0,   0, 117, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128,   0, 128, 128,   0,   0,   0,   0,   0, 128, 128, 128, 128, 128,
     64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,   0,   0,   0,  64,
     76,  76,  76,  76,  76,  76,  76,  76,  76,  76,   0,   0,   0,   0,   0,  76,
     98,  98,  98,  98,  98,  98,  98,  98,  97,  97,  97,  97,  97,  97,  97,  97,
      0,   0,   0,   0,  97,  97,  97,  97,   0,   0,  97,  97,  97,  97,  97,  97,
     61,  61,  61,  61,   0,  61,  61,   0,   0,   0,   0,   0,  61,  61,  61,  61,
     61,  61,  61,  61,   0,  61,  61,  61,   0,  61,  61,  61,  61,  61,  61,  61,
     61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,   0,   0,
     61,  61,  61,   0,   0,   0,   0,  61,  61,   0,   0,   0,   0,   0,   0,   0,
     88,  88,  88,  88,  88,  88,  88,  88, 116, 116, 116, 116, 116, 116, 116, 116,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,   0,
      0,   0,   0, 112, 112, 112, 112, 112,  80,  80,  80,  80,  80,  80,  80,  80,
     80,  80,  80,  80,  80,  80,   0,   0,   0,  80,  80,  80,  80,  80,  80,  80,
     89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,   0,   0,
     90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,   0,   0,   0,   0,   0,
    121, 121, 121, 121, 121, 121, 121, 121, 121, 121,   0,   0,   0,   0,   0,   0,
      0, 121, 121, 121, 121,   0,   0,   0,   0, 121, 121, 121, 121, 121, 121, 121,
     91,  91,  91,  91,  91,  91,  91,  91,  91,   0,   0,   0,   0,   0,   0,   0,
    130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,   0,   0,   0,   0,   0,
      0,   0, 130, 130, 130, 130, 130, 130, 146, 146, 146, 146, 146, 146, 146, 146,
    146, 146,   0,   0,   0,   0,   0,   0,   7,   7,   7,   7,   7,   7,   7,   0,
    148, 148, 148, 148, 148, 148, 148, 148, 147, 147, 147, 147, 147, 147, 147, 147,
    147, 147,   0,   0,   0,   0,   0,   0, 149, 149, 149, 149, 149, 149, 149, 149,
    149, 149, 149, 149, 149, 149, 149,   0,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,   0,   0,   0,   0,  94,  94,  94,  94,  94,  94,
      0,   0,   0,   0,   0,   0,   0,  94,  92,  92,  92,  92,  92,  92,  92,  92,
     92,  92,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  92,   0,   0,
    101, 101, 101, 101, 101, 101, 101, 101, 101,   0,   0,   0,   0,   0,   0,   0,
    101, 101,   0,   0,   0,   0,   0,   0,  96,  96,  96,  96,  96,  96,  96,  96,
     96,  96,  96,  96,  96,   0,  96,  96,  96,  96,  96,  96,  96,  96,  96,   0,
    111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,   0,
    100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,   0,   0,
      0,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,   0,   0,   0,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109,   0, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109,   0, 129, 129, 129, 129, 129, 129, 129,   0,
    129,   0, 129, 129, 129, 129,   0, 129, 129, 129, 129, 129, 129, 129, 129, 129,
    129, 129, 129, 129, 129, 129,   0, 129, 129, 129,   0,   0,   0,   0,   0,   0,
    123, 123, 123, 123, 123, 123, 123, 123, 123, 123, 123,   0,   0,   0,   0,   0,
    123, 123,   0,   0,   0,   0,   0,   0, 107, 107, 107, 107,   0, 107, 107, 107,
    107, 107, 107, 107, 107,   0,   0, 107, 107,   0,   0, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107,   0, 107, 107, 107, 107, 107, 107,
    107,   0, 107, 107,   0, 107, 107, 107, 107, 107,   0,  41, 107, 107, 107, 107,
    107,   0,   0, 107, 107, 107,   0,   0, 107,   0,   0,   0,   0,   0,   0, 107,
      0,   0,   0,   0,   0, 107, 107, 107, 107, 107, 107, 107,   0,   0, 107, 107,
    107, 107, 107, 107, 107,   0,   0,   0, 135, 135, 135, 135, 135, 135, 135, 135,
    135, 135,   0, 135,   0, 135, 135, 135, 124, 124, 124, 124, 124, 124, 124, 124,
    124, 124,   0,   0,   0,   0,   0,   0, 122, 122, 122, 122, 122, 122, 122, 122,
    122, 122, 122, 122, 122, 122,   0,   0, 114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114,   0,   0,   0, 114, 114,   0,   0,   0,   0,   0,   0,
     32,  32,  32,  32,  32,   0,   0,   0, 102, 102, 102, 102, 102, 102, 102, 102,
    102,   0,   0,   0,   0,   0,   0,   0, 102, 102,   0,   0,   0,   0,   0,   0,
    126, 126, 126, 126, 126, 126, 126, 126, 126, 126, 126,   0,   0, 126, 126, 126,
    126, 126, 126, 126,   0,   0,   0,   0, 142, 142, 142, 142, 142, 142, 142, 142,
    142, 142, 142, 142,   0,   0,   0,   0, 125, 125, 125, 125, 125, 125, 125, 125,
    125, 125, 125,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 125,
    150, 150, 150, 150, 150, 150, 150, 150,   0,   0, 150, 150, 150, 150, 150, 150,
    150, 150, 150, 150, 150,   0,   0,   0, 141, 141, 141, 141, 141, 141, 141, 141,
    140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,   0,   0,   0,   0,   0,
    119, 119, 119, 119, 119, 119, 119, 119, 119,   0,   0,   0,   0,   0,   0,   0,
    133, 133, 133, 133, 133, 133, 133, 133, 133,   0, 133, 133, 133, 133, 133, 133,
    133, 133, 133, 133, 133, 133, 133,   0, 133, 133, 133, 133, 133, 133,   0,   0,
    133, 133, 133, 133, 133,   0,   0,   0, 134, 134, 134, 134, 134, 134, 134, 134,
      0,   0, 134, 134, 134, 134, 134, 134,   0, 134, 134, 134, 134, 134, 134, 134,
    134, 134, 134, 134, 134, 134, 134,   0, 138, 138, 138, 138, 138, 138, 138,   0,
    138, 138,   0, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138,
      0,   0, 138,   0, 138, 138,   0, 138, 138, 138,   0,   0,   0,   0,   0,   0,
    143, 143, 143, 143, 143, 143,   0, 143, 143,   0, 143, 143, 143, 143, 143, 143,
    143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,   0,
    143, 143,   0, 143, 143, 143, 143, 143, 143,   0,   0,   0,   0,   0,   0,   0,
    143, 143,   0,   0,   0,   0,   0,   0, 144, 144, 144, 144, 144, 144, 144, 144,
    144,   0,   0,   0,   0,   0,   0,   0,  15,  15,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  15,  63,  63,  63,  63,  63,  63,  63,  63,
     63,  63,   0,   0,   0,   0,   0,   0,  63,  63,  63,  63,  63,  63,  63,   0,
     63,  63,  63,  63,  63,   0,   0,   0,  63,  63,  63,  63,   0,   0,   0,   0,
     81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,   0,
     81,   0,   0,   0,   0,   0,   0,   0, 127, 127, 127, 127, 127, 127, 127, 127,
    127, 127, 127, 127, 127, 127, 127,   0,  84,   0,   0,   0,   0,   0,   0,   0,
    115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115,   0,
    115, 115,   0,   0,   0,   0, 115, 115, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104,   0,   0, 108, 108, 108, 108, 108, 108, 108, 108,
    108, 108, 108, 108, 108, 108,   0,   0, 108, 108,   0, 108, 108, 108, 108, 108,
      0,   0,   0,   0,   0, 108, 108, 108, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145,   0,   0,   0,   0,   0,  99,  99,  99,  99,  99,  99,  99,  99,
     99,  99,  99,   0,   0,   0,   0,  99,   0,   0,   0,   0,   0,   0,   0,  99,
    137, 139,   1,   1,   0,   0,   0,   0, 137, 137, 137, 137, 137, 137, 137, 137,
    137, 137, 137,   0,   0,   0,   0,   0,  34,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,   0,   0,   0,   0,   0,   0,   0,   0,   0,  34,  34,  34,  34,
    139, 139, 139, 139, 139, 139, 139, 139, 139, 139, 139, 139,   0,   0,   0,   0,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,   0,   0,   0,   0,   0,
    105, 105, 105, 105, 105,   0,   0,   0, 105,   0,   0,   0,   0,   0,   0,   0,
    105, 105,   0,   0, 105, 105, 105, 105,   1,   1,   1,   1,   1,   1,   1,  41,
     41,  41,   1,   1,   1,   1,   1,   1,   1,   1,   1,  41,  41,  41,  41,  41,
     41,  41,  41,   1,   1,  41,  41,  41,  41,  41,  41,  41,   1,   1,   1,   1,
      1,   1,  41,  41,  41,  41,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   1,   0,   0,   1,   1,   0,   0,   1,   1,   1,   1,   0,   1,   1,
      1,   1,   0,   1,   0,   1,   1,   1,   1,   1,   1,   1,   0,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,   0,   0,   1,   1,   1,
      1,   1,   0,   1,   1,   1,   1,   0,   1,   1,   1,   1,   1,   0,   1,   0,
      0,   0,   1,   1,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,   1,   1,
    131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,   0,   0,   0,   0,
      0,   0,   0, 131, 131, 131, 131, 131,   0, 131, 131, 131, 131, 131, 131, 131,
     57,   0,   0,  57,  57,  57,  57,  57,  57,  57,   0,  57,  57,   0,  57,  57,
     57,  57,  57,   0,   0,   0,   0,   0, 151, 151, 151, 151, 151, 151, 151, 151,
    151, 151, 151, 151, 151,   0,   0,   0, 151, 151, 151, 151, 151, 151,   0,   0,
    151, 151,   0,   0,   0,   0, 151, 151, 152, 152, 152, 152, 152, 152, 152, 152,
    152, 152,   0,   0,   0,   0,   0, 152, 113, 113, 113, 113, 113, 113, 113, 113,
    113, 113, 113, 113, 113,   0,   0, 113, 113, 113, 113, 113, 113, 113, 113,   0,
    132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132,   0,   0,   0,   0,
    132, 132,   0,   0,   0,   0, 132, 132,   1,   1,   1,   1,   1,   0,   0,   0,
      7,   7,   7,   7,   0,   7,   7,   7,   0,   7,   7,   0,   7,   0,   0,   7,
      0,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   0,   7,   7,   7,   7,
      0,   7,   0,   7,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   7,
      0,   7,   0,   7,   0,   7,   7,   7,   0,   7,   0,   7,   0,   7,   0,   7,
      0,   7,   7,   7,   7,   0,   7,   0,   7,   7,   0,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   0,   0,   0,   0,   0,   7,   7,   7,   0,   7,   7,   7,
      0,   0,   0,   0,   0,   0,   1,   1,  33,   1,   1,   0,   0,   0,   0,   0,
      1,   1,   1,   0,   0,   0,   1,   1,  36,  36,  36,  36,  36,  36,  36,   0,
     36,  36,  36,  36,  36,   0,   0,   0,  36,   0,   0,   0,   0,   0,   0,   0,
      0,   1,   0,   0,   0,   0,   0,   0,
};

/* Script: 13928 bytes. */

RE_UINT32 re_get_script(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_script_stage_1[f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_script_stage_2[pos + f] << 4;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_script_stage_3[pos + f] << 3;
    value = re_script_stage_4[pos + code];

    return value;
}

/* Script_Extensions. */

static RE_UINT8 re_script_extensions_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  7,  8,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  9, 10, 11, 12, 12, 12, 12, 13, 14, 14, 14, 14, 15,
    16, 17, 18, 19, 20, 14, 21, 14, 22, 14, 14, 14, 14, 23, 24, 24,
    25, 26, 14, 14, 14, 14, 27, 28, 14, 14, 29, 30, 31, 32, 33, 34,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 35,  7, 36, 37,  7, 38,  7,  7,  7, 39, 14, 40,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    41, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
};

static RE_UINT8 re_script_extensions_stage_2[] = {
      0,   1,   2,   2,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,
     14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  32,  33,  34,  35,  36,  37,  37,  37,  37,  37,  38,  39,  40,
     41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,   2,   2,  53,  54,
     55,  56,  57,  58,  59,  59,  59,  59,  60,  59,  59,  59,  59,  59,  59,  59,
     61,  61,  59,  59,  59,  59,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,
     72,  73,  74,  75,  76,  77,  78,  79,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  80,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  81,
     82,  82,  82,  82,  82,  82,  82,  82,  82,  83,  84,  84,  85,  86,  87,  88,
     89,  90,  91,  92,  93,  94,  95,  96,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  97,
     98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
     98,  98,  70,  70,  99, 100, 101, 102, 103, 103, 104, 105, 106, 107, 108, 109,
    110, 111, 112, 113,  98, 114, 115, 116, 117, 118, 119,  98, 120, 120, 121,  98,
    122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,  98, 133,  98, 134, 135,
    136, 137, 138, 139, 140, 141, 142,  98, 143, 144,  98, 145, 146, 147, 148,  98,
    149, 150,  98, 151, 152, 153,  98,  98, 154, 155, 156, 157,  98, 158,  98, 159,
    160, 160, 160, 160, 160, 160, 160, 161, 162, 160, 163,  98,  98,  98,  98,  98,
    164, 164, 164, 164, 164, 164, 164, 164, 165,  98,  98,  98,  98,  98,  98,  98,
     98,  98,  98,  98,  98,  98,  98,  98, 166, 166, 166, 166, 167,  98,  98,  98,
    168, 168, 168, 168, 169, 170, 171, 172,  98,  98,  98,  98, 173, 174, 175, 176,
    177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177,
    177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 178,
    177, 177, 177, 177, 177, 179,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
    180, 181, 182, 183, 183, 184,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
     98,  98,  98,  98,  98,  98,  98,  98, 185, 186,  98,  98,  98,  98,  98,  98,
     59, 187, 188, 189, 190, 191, 192,  98, 193, 194, 195,  59,  59, 196,  59, 197,
    198, 198, 198, 198, 198, 199,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
    200,  98, 201,  98,  98, 202,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
    203, 204, 205,  98,  98,  98,  98,  98, 206, 207, 208,  98, 209, 210,  98,  98,
    211, 212, 213, 214, 215,  98,  59,  59,  59,  59,  59,  59,  59, 216, 217, 218,
    219, 220, 221, 222, 223, 224,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70, 225,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70, 226,  70,
    227,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70,  70, 228,  70,  70,
     70,  70,  70,  70,  70,  70,  70, 229,  98,  98,  98,  98,  98,  98,  98,  98,
     70,  70,  70,  70, 230,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
    231,  98, 232, 233,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
};

static RE_UINT16 re_script_extensions_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   2,   3,   1,   2,   2,   3,
      0,   0,   0,   0,   0,   4,   0,   4,   2,   2,   5,   2,   2,   2,   5,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   6,   0,   0,   0,   0,   7,   8,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,  10,   9,   9,   9,  11,   2,  12,  13,
     14,  15,  16,  16,  17,  16,  16,  16,  16,  16,  16,  16,  18,  19,  16,  16,
     20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,
     21,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,
     20,  20,  20,  20,  20,  20,  22,  23,  23,  23,  24,  22,  23,  23,  23,  23,
     23,  25,  26,  27,  27,  27,  27,  27,  27,  28,  27,  27,  27,  29,  30,  28,
     31,  32,  33,  34,  33,  33,  33,  33,  35,  36,  37,  33,  38,  39,  40,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  41,  31,  33,  33,  33,  33,
     42,  43,  42,  42,  42,  42,  42,  42,  42,  44,  33,  33,  33,  33,  33,  33,
     45,  45,  45,  45,  45,  45,  46,  28,  47,  47,  47,  47,  47,  47,  47,  48,
     49,  49,  49,  49,  49,  50,  49,  51,  52,  52,  52,  53,  42,  54,  28,  28,
     28,  28,  28,  28,  33,  33,  55,  56,  28,  28,  57,  33,  58,  33,  33,  33,
     59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  60,  59,  61,  62,  59,  59,
     63,  64,  65,  66,  66,  67,  68,  69,  64,  70,  71,  72,  73,  74,  66,  75,
     76,  77,  78,  79,  79,  80,  81,  82,  77,  83,  84,  85,  86,  87,  88,  28,
     89,  90,  91,  92,  92,  93,  94,  95,  90,  96,  97,  28,  98,  99, 100, 101,
    102, 103, 104, 105, 105, 106, 107, 108, 103, 109, 110, 111, 112, 105, 105,  28,
    113, 114, 115, 116, 117, 114, 118, 119, 114, 115, 120,  28, 121, 122, 123, 124,
    125, 126, 127, 125, 125, 127, 125, 128, 126, 129, 130, 131, 132, 125, 133, 125,
    134, 135, 136, 134, 134, 136, 137, 138, 135, 139, 140, 141, 142, 143, 144,  28,
    145, 146, 147, 148, 148, 148, 148, 148, 146, 147, 149, 148, 150, 148, 148, 148,
    151, 152, 153, 154, 152, 152, 155, 156, 153, 157, 158, 152, 159, 152, 160,  28,
    161, 162, 162, 162, 162, 162, 162, 163, 162, 162, 162, 164,  28,  28,  28,  28,
    165, 166, 167, 167, 168, 167, 167, 169, 170, 169, 167, 171,  28,  28,  28,  28,
    172, 172, 172, 172, 172, 172, 172, 172, 172, 173, 172, 172, 172, 174, 173, 172,
    172, 172, 172, 173, 172, 172, 172, 175, 172, 175, 176, 177,  28,  28,  28,  28,
    178, 178, 178, 178, 178, 178, 178, 178, 179, 180, 178, 178, 178, 178, 178, 178,
    178, 178, 178, 178, 181, 181, 181, 181, 182, 183, 181, 181, 181, 181, 181, 184,
    185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185, 185,
    186, 186, 186, 186, 186, 186, 186, 186, 186, 187, 188, 187, 186, 186, 186, 186,
    186, 187, 186, 186, 186, 186, 187, 188, 187, 186, 188, 186, 186, 186, 186, 186,
    186, 186, 187, 186, 186, 186, 186, 186, 186, 186, 186, 189, 186, 186, 186, 190,
    186, 186, 186, 191, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 193,
    194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194,
    195, 195, 195, 196, 197, 197, 197, 197, 197, 197, 197, 197, 197, 198, 197, 199,
    200, 201, 202,  28, 203, 203, 204,  28, 205, 205, 206,  28, 207, 208, 209,  28,
    210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 211, 210, 212, 210, 212,
    213, 214, 215, 216, 215, 215, 215, 215, 215, 215, 215, 215, 215, 215, 215, 217,
    215, 215, 215, 215, 215, 218, 194, 194, 194, 194, 194, 194, 194, 194, 219,  28,
    220, 220, 220, 221, 220, 222, 220, 222, 223, 220, 224, 224, 224, 225, 226,  28,
    227, 227, 227, 227, 227, 228, 227, 227, 227, 229, 227, 230, 210, 210, 210, 210,
    231, 231, 231, 232, 233, 233, 233, 233, 233, 233, 233, 234, 233, 233, 233, 235,
    233, 236, 233, 236, 233, 237,   9, 238,  28,  28,  28,  28,  28,  28,  28,  28,
    239, 239, 239, 239, 239, 239, 239, 239, 239, 240, 239, 239, 239, 239, 239, 241,
    242, 242, 242, 242, 242, 242, 242, 242, 243, 243, 243, 243, 243, 243, 244, 245,
    246, 246, 246, 246, 246, 246, 246, 247, 246, 248, 249, 249, 249, 249, 249, 249,
     20, 250, 181, 181, 181, 181, 181, 251, 242,  28, 252, 253, 254, 255, 256, 257,
      2,   2,   2,   2, 258, 259,   2,   2,   2,   2,   2, 260, 261, 262,   2, 263,
      2,   2,   2,   2,   2,   2,   2, 264, 265,   9,   9,   9,   9,   9,   9, 266,
     16,  16, 267, 267,  16,  16,  16,  16, 267, 267,  16, 268,  16,  16,  16, 267,
     16,  16,  16,  16,  16,  16, 269,  16, 269,  16, 270, 271,  16,  16, 272, 273,
      0, 274,   0,   0,   0, 275,   0,   0,   0,   0,   0,   0, 276,   0, 277, 278,
      0, 279,   2, 280,   0,   0,   0,   0,  28,  28,   9,   9,   9,   9, 281,  28,
      0,   0,   0,   0, 282, 283,   4,   0,   0, 284,   0,   0,   2,   2,   2,   2,
      2, 285,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 279,  28,  28,  28,   0, 286,  28,  28,   0,   0,   0,   0,
    287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 288,   0,
      0,   0, 289,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    290, 290, 290, 290, 290, 291, 290, 290, 290, 290, 290, 291,   2,   2,   2,   2,
     19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19, 292, 293,
    181, 181, 181, 181, 182, 183, 294, 294, 294, 294, 294, 294, 294, 295, 296, 295,
    186, 186, 188,  28, 188, 188, 188, 188, 188, 188, 188, 188,  20,  20,  20,  20,
      0,   0,   0,   0,   0,   0,   0,   0, 297,   0,  28,  28,  28,  28,  28,  28,
    298, 298, 298, 299, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 300,  28,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 301,  28,  28,  28,   0, 302,
    303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 312, 312, 312, 312, 312, 312,
    312, 312, 313, 314, 315, 316, 316, 316, 316, 316, 316, 316, 316, 316, 316, 317,
    318, 319, 319, 319, 319, 319, 320, 185, 185, 185, 185, 185, 185, 185, 185, 185,
    185, 321, 298, 298, 319, 319, 319, 322, 298, 298, 298, 298, 300,  28, 316, 316,
    185, 185, 185, 321, 298, 298, 298, 298, 298,   0,   0,   0, 185, 185, 185, 323,
    298, 298, 298, 298, 298, 298, 324,   0, 298, 325, 316, 316, 316, 316, 316, 326,
    316, 316, 316, 316, 316, 316, 316, 316, 316, 316, 316, 298, 298, 298, 324, 327,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 298, 298, 298, 328,
    298, 298, 298, 298, 298, 298, 301,  28,   0,   0,   0,   0,   0,   0,   0,   0,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298,  28,  28,
    329, 329, 329, 329, 329, 329, 329, 329, 329, 329, 329, 329, 329, 329, 329, 329,
    329, 330, 329, 329, 329, 329, 329, 329, 331,  28, 332, 332, 332, 332, 332, 332,
    333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333,
    333, 333, 333, 333, 333, 334,  28,  28,  20,  20,  20,  20,  20, 335,  20,  20,
     20,  20,  20,  20, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336,  28,
      0,   0,   0,   0, 337,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2, 338,   2,   2,   2,   2,   2,   2, 339,  28,  28,  28,  28,  28, 340,   2,
    341, 341, 341, 341, 341, 342, 343, 344, 345, 345, 345, 345, 345, 345, 345,  28,
    346, 346, 346, 346, 346, 346, 346, 346, 347, 348, 346, 349,  59,  59, 350,  59,
    351, 351, 351, 351, 351, 352, 353, 353, 353, 353, 354, 355, 185, 185, 185, 356,
    357, 357, 357, 357, 357, 357, 357, 357, 357, 358, 357, 359, 178, 178, 178, 360,
    361, 361, 361, 361, 361, 361, 362,  28, 361, 363, 361, 364, 178, 178, 178, 178,
    365, 365, 365, 365, 365, 365, 365, 365, 366,  28,  28, 367, 368, 368, 369,  28,
    370, 370, 370,  28, 188, 188,   2,   2,   2,   2,   2, 371, 372,  28, 192, 192,
    192, 192, 192, 192, 192, 192, 192, 192, 368, 368, 368, 368, 368, 373, 368, 374,
    185, 185, 185, 185, 375,  28, 185, 185, 321, 376, 185, 185, 185, 185, 185, 375,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 301, 298, 298,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 377,  28,  28,  28,  28,
    378,  28, 379, 380,  27,  27, 381, 382, 383,  27,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33, 384,  28,  57,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33, 385,  28,  28,  33,  33,  33,  33,  33,  33,
     33,  33, 386,  33,  33,  33,  33,  33,  33,  28,  28,  28,  28,  28, 387, 388,
      9,   9,   0, 389,   9, 390,   0,   0, 391,   0, 392,   0, 279, 302,  55,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33, 393,
    394,   0,   0,   0,   1,   2,   2,   3,   1,   2,   2,   3, 395, 316, 315, 316,
    316, 316, 316, 396, 185, 185, 185, 321, 397, 397, 397, 398, 279, 279,  28, 399,
    400, 401, 400, 400, 402, 400, 400, 403, 400, 404, 400, 404,  28,  28,  28,  28,
    400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 405,
    406, 407, 407, 407, 407, 407, 408, 409,  16,  16,  16,  16,  16,  16,  16,  16,
     16, 273,   0, 302, 410,  28,  28,  28,  28,  28,   0,   0,   0,   0,   0, 411,
    412, 412, 412, 413, 414, 414, 414, 414, 414, 414, 415,  28, 416, 416, 416, 417,
    418, 418, 418, 418, 419, 420, 421, 421, 421, 422, 423, 423, 423, 423, 423, 424,
    425, 425, 425, 426, 427, 427, 427, 427, 428, 427, 429,  28,  28,  28,  28,  28,
    430, 430, 430, 430, 430, 430, 430, 430, 430, 430, 431, 431, 431, 431, 431, 431,
    432, 432, 432, 433, 432, 434, 435, 435, 435, 435, 436, 435, 435, 435, 435, 436,
    437, 437, 437, 437, 437,  28, 438, 438, 438, 438, 438, 438, 439, 440,  28,  28,
    441, 441, 441, 441, 441, 441, 441, 441, 441, 441, 441, 441, 441, 441, 441, 441,
    441, 441, 441, 441, 441, 441, 442,  28, 441, 441, 443,  28, 441,  28,  28,  28,
    444, 445, 446, 446, 446, 446, 447, 448, 449, 449, 450, 449, 451, 451, 451, 451,
    452, 452, 452, 453, 454, 452,  28,  28,  28,  28,  28,  28, 455, 455, 456, 457,
    458, 458, 458, 459, 460, 460, 460, 461,  28,  28,  28,  28,  28,  28,  28,  28,
    462, 462, 462, 462, 463, 463, 463, 464, 463, 463, 465, 463, 463, 463, 463, 463,
    466, 467, 468, 469, 470, 470, 471, 472, 470, 473, 470, 473, 474, 474, 474, 474,
    475, 475, 475, 475,  28,  28,  28,  28, 476, 476, 476, 476, 477, 478, 477,  28,
    479, 479, 479, 479, 479, 479, 480, 481, 482, 482, 483, 482, 484, 484, 485, 484,
    486, 486, 487, 488,  28, 489,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    490, 490, 490, 490, 490, 490, 490, 490, 490, 491,  28,  28,  28,  28,  28,  28,
    492, 492, 492, 492, 492, 492, 493,  28, 492, 492, 492, 492, 492, 492, 493, 494,
    495, 495, 495, 495, 495,  28, 495, 496,  28,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  33,  33,  33, 497,
    498, 498, 498, 498, 498,  28, 499, 499, 499, 499, 499, 500,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28, 501, 501, 502,  28,
    503, 503, 503, 503, 503, 503, 503, 503, 503, 504, 505, 503, 503, 503,  28, 506,
    507, 507, 507, 507, 507, 507, 507, 507, 508, 509, 510, 510, 510, 511, 510, 512,
    513, 513, 513, 513, 513, 513, 514, 513, 515,  28, 516, 516, 516, 516, 517,  28,
    518, 518, 518, 518, 518, 518, 518, 518, 518, 519, 518, 518, 520, 152, 521,  28,
    522, 522, 523, 522, 522, 522, 522, 524,  28,  28,  28,  28,  28,  28,  28,  28,
    525, 526, 527, 528, 527, 529, 530, 530, 530, 530, 530, 530, 530, 531, 530, 532,
    533, 534, 535, 536, 536, 537, 538, 539, 534, 540, 541, 542, 543, 544, 544,  28,
    545, 545, 545, 545, 545, 545, 545, 545, 545, 545, 545, 546,  28,  28,  28,  28,
    547, 547, 547, 547, 547, 547, 547, 547, 547,  28, 547, 548,  28,  28,  28,  28,
    549, 549, 549, 549, 549, 549, 550, 549, 549, 549, 549, 550,  28,  28,  28,  28,
    551, 551, 551, 551, 551, 551, 551, 551, 552,  28, 551, 553, 215, 554,  28,  28,
    555, 555, 555, 555, 555, 555, 555, 556, 555, 557,  28,  28,  28,  28,  28,  28,
    558, 558, 558, 559, 558, 560, 558, 558,  28,  28,  28,  28,  28,  28,  28,  28,
    561, 561, 561, 561, 561, 561, 561, 562,  28,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  28, 563, 563, 563, 563, 563, 563, 563, 563, 563, 563, 564, 565,
     28,  28,  28,  28, 566, 567, 566, 566, 566, 566, 566, 567, 568,  28,  28,  28,
    569, 569, 569, 569, 569, 569, 569, 569, 569,  28, 570, 570, 570, 570, 570, 570,
    570, 570, 570, 570, 571,  28,  28,  28, 572, 572, 572, 572, 572, 572, 572, 573,
    574, 575, 574, 574, 574, 574, 576, 574, 577,  28, 574, 574, 574, 578, 579, 579,
    579, 579, 580, 579, 579, 581, 582,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    583, 584, 585, 585, 585, 585, 583, 586, 585,  28, 585, 587, 588, 589, 590, 590,
    590, 591, 592, 593, 590, 594,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28, 595, 595, 595, 596,
     28,  28,  28,  28,  28,  28,  28,  28, 118, 118, 597, 118, 118, 118, 598, 599,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 601,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 602, 603,  28,
    600, 600, 600, 600, 600, 600, 600, 600, 604,  28,  28,  28,  28,  28,  28,  28,
    605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605, 605,
    605, 605, 605, 605, 605, 606, 605, 607,  28,  28,  28,  28,  28,  28,  28,  28,
    608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608, 608,
    608, 608, 608, 608, 608, 608, 608, 608, 609,  28,  28,  28,  28,  28,  28,  28,
    336, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336, 336,
    336, 336, 336, 336, 336, 336, 336, 610, 611, 611, 611, 612, 611, 613,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28, 614, 614, 614, 615, 615,  28,
    616, 616, 616, 616, 616, 616, 616, 616, 617,  28, 616, 618, 618, 616, 616, 619,
    616, 616,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28, 620, 620, 620, 620, 620, 620, 620, 620,
    620, 620, 620, 621,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    622, 622, 622, 622, 622, 622, 622, 622, 622, 623, 622, 622, 622, 622, 622, 622,
    622, 624, 622, 622,  28,  28,  28,  28,  28,  28,  28,  28, 625,  28,  28,  28,
    626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626,
    626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626,  28,
    626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 626, 627,  28,
    628, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312,
    312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312, 312,
    312, 312, 312, 313,  28,  28,  28,  28,  28,  28, 629,  28, 630,  28, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 631, 632,
    633, 633, 633, 633, 633, 633, 633, 633, 633, 633, 633, 633, 633, 634, 633, 635,
    633, 636, 633, 637, 638,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 289,  28,
      0,   0,   0,   0, 279, 394,   0,   0,   0,   0,   0,   0, 639, 640,   0, 641,
    642, 643,   0,   0,   0, 644,   0,   0,   0,   0,   0,   0,   0, 645,  28,  28,
     16,  16,  16,  16,  16,  16,  16,  16, 267,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,   0,   0, 302,  28,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 279,  28, 298, 298, 646, 645,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 276,   0,   0,   0,   0,   0,
      0,   0,   0, 276, 647, 648,   0, 649, 650,   0,   0,   0,   0,   0,   0,   0,
    651, 652, 276, 276,   0,   0,   0, 653, 654, 655, 656,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 289,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0, 288,   0,   0,   0,   0,   0,   0,
    657, 657, 657, 657, 657, 657, 657, 657, 657, 657, 657, 657, 657, 657, 657, 657,
    657, 658,  28, 659, 660, 657,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    291, 290, 290, 661, 662, 663,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    664, 664, 664, 664, 664, 665, 664, 666, 664, 667,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28, 668, 668, 668, 668, 668, 668, 668, 669,
    670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670, 670,
    670, 670, 670, 670, 670, 670, 670, 670, 671, 670, 672,  28,  28,  28,  28,  28,
    673, 673, 673, 673, 673, 673, 673, 673, 673, 674, 673, 675,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28, 394,   0,
      0,   0,   0,   0,   0,   0, 676,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    394,   0,   0,   0,   0,   0,   0, 289,  28,  28,  28,  28,  28,  28,  28,  28,
    677,  33,  33,  33, 678, 679, 680, 681, 682, 683, 678, 684, 678, 680, 680, 685,
     33, 686,  33, 687, 688, 686,  33, 687,  28,  28,  28,  28,  28,  28, 384,  28,
      0,   0,   0,   0,   0, 302,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0, 302,  28,   0, 279, 394,   0, 394,   0, 394,   0,   0,   0, 289,  28,
      0, 676,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 676,   0,   0,
      0,   0,   0,   0,   0, 676,  28,  28,  28,  28,  28,  28, 689,   0,   0,   0,
    690,  28,   0,   0,   0,   0,   0, 302,   0, 645, 377,  28, 289,  28,  28,  28,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 289,  28,   0, 676,   0, 286,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 302,  28,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 645,   0, 302,  28,  28,
      0, 302,   0,   0,   0,   0,   0,   0,   0,  28,   0, 389,   0,   0,   0,   0,
      0,  28,   0,   0,   0, 289,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
      0, 650,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 653, 655,
      0,   0,   0,   0, 652, 691,   0,   0,   0, 652,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 302,  28,   0, 289, 302, 286,
    286,  28, 289,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 692,  28,  28,  28,  28,  28,
    298, 298, 298, 298, 298, 298, 693,  28, 298, 298, 298, 298, 298, 298, 298, 298,
    298, 298, 298, 301, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298,
    298, 298, 298, 298, 377,  28, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298,
    298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 694,  28,  28,  28,
    298, 298, 298, 301,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
    695,  28,  28,  28,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  28,  28,
};

static RE_UINT8 re_script_extensions_stage_4[] = {
      1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,
      1,   1,   2,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   1,
      2,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   1,   1,   1,
      1,   1,  35,  35,   1,   1,   1,   1,  41,  41,  41,  41,  41,  41,  41,  41,
     41,  41,   3,  41,  41,   3,  41,  41,  41,  41,  41,   2,   2,   2,   2,   2,
      3,   3,   3,   3,   1,   3,   3,   3,   0,   0,   3,   3,   3,   3,   1,   3,
      0,   0,   0,   0,   3,   1,   3,   1,   3,   3,   3,   0,   3,   0,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,   3,   3,   3,   3,   3,
      3,   3,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 164, 162, 163, 163, 162,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5, 157,   5,   0,   0,   5,   5,   5,
      0,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      0,   0,   0,   0,   0,   0,   0,   0,   6,   6,   6,   0,   0,   0,   0,   6,
      6,   6,   6,   6,   6,   0,   0,   0,   7,   7,   7,   7,   7,   1,   7,   7,
      7,   7,   7,   7, 185,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7, 185, 177,   0,   7, 185, 192,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7, 155, 155, 155, 155, 155, 155, 155, 155, 155, 155, 155,   7,   7,
    156, 156, 156, 156, 156, 156, 156, 156, 156, 156,   7,   7,   7,   7,   7,   7,
    155,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 154,   7,   7,   7,
      8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   0,   8,
      8,   8,   8,   0,   0,   8,   8,   8,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   0,   0,   0,   0,   0,   0,  66,  66,  66,  66,  66,  66,  66,  66,
     66,  66,  66,   0,   0,  66,  66,  66,  82,  82,  82,  82,  82,  82,  82,  82,
     82,  82,  82,  82,  82,  82,   0,   0,  82,  82,  82,  82,  82,  82,  82,   0,
     95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,   0,   0,  95,   0,
      8,   8,   8,   0,   0,   0,   0,   0,   7,   7,   7,   7,   7,   0,   7,   7,
      7,   7,   7,   7,   7,   7,   0,   0,   0,   0,   0,   7,   7,   7,   7,   7,
      7,   7,   1,   7,   7,   7,   7,   7,  10,  10,  10,  10,  10,  10,  10,  10,
     10, 196, 195,  41,  41,  10,  10,  10,  10,  10,  10,  10, 199, 200, 188, 188,
    188, 188, 188, 188, 188, 188, 188, 188,  11,  11,  11,  11,   0,  11,  11,  11,
     11,  11,  11,  11,  11,   0,   0,  11,  11,   0,   0,  11,  11,  11,  11,  11,
     11,  11,  11,  11,  11,  11,  11,  11,  11,   0,  11,  11,  11,  11,  11,  11,
     11,   0,  11,   0,   0,   0,  11,  11,  11,  11,   0,   0,  11,  11,  11,  11,
     11,   0,   0,  11,  11,  11,  11,   0,   0,   0,   0,   0,   0,   0,   0,  11,
      0,   0,   0,   0,  11,  11,   0,  11,  11,  11,  11,  11,   0,   0, 178, 178,
    178, 178, 178, 178, 178, 178, 178, 178,  11,  11,  11,  11,  11,  11,  11,   0,
      0,  12,  12,  12,   0,  12,  12,  12,  12,  12,  12,   0,   0,   0,   0,  12,
     12,   0,   0,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,
     12,   0,  12,  12,  12,  12,  12,  12,  12,   0,  12,  12,   0,  12,  12,   0,
     12,  12,   0,   0,  12,   0,  12,  12,  12,   0,   0,  12,  12,  12,   0,   0,
      0,  12,   0,   0,   0,   0,   0,   0,   0,  12,  12,  12,  12,   0,  12,   0,
      0,   0,   0,   0,   0,   0, 172, 172, 172, 172, 172, 172, 172, 172, 172, 172,
     12,  12,  12,  12,  12,  12,  12,   0,   0,  13,  13,  13,   0,  13,  13,  13,
     13,  13,  13,  13,  13,  13,   0,  13,  13,  13,   0,  13,  13,  13,  13,  13,
     13,  13,  13,  13,  13,  13,  13,  13,  13,   0,  13,  13,  13,  13,  13,  13,
     13,   0,  13,  13,   0,  13,  13,  13,  13,  13,   0,   0,  13,  13,  13,  13,
     13,  13,   0,  13,  13,  13,   0,   0,  13,   0,   0,   0,   0,   0,   0,   0,
     13,  13,  13,  13,   0,   0, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171,
     13,  13,   0,   0,   0,   0,   0,   0,   0,  13,  13,  13,  13,  13,  13,  13,
      0,  14,  14,  14,   0,  14,  14,  14,  14,  14,  14,  14,  14,   0,   0,  14,
     14,   0,   0,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,
     14,   0,  14,  14,  14,  14,  14,  14,  14,   0,  14,  14,   0,  14,  14,  14,
     14,  14,   0,   0,  14,  14,  14,  14,  14,   0,   0,  14,  14,  14,   0,   0,
      0,   0,   0,   0,   0,   0,  14,  14,   0,   0,   0,   0,  14,  14,   0,  14,
     14,  14,  14,  14,   0,   0,  14,  14,   0,   0,  15,  15,   0,  15,  15,  15,
     15,  15,  15,   0,   0,   0,  15,  15,  15,   0,  15,  15,  15,  15,   0,   0,
      0,  15,  15,   0,  15,   0,  15,  15,   0,   0,   0,  15,  15,   0,   0,   0,
     15,  15,  15,  15,  15,  15,  15,  15,  15,  15,   0,   0,   0,   0,  15,  15,
     15,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0, 170, 170,
    170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170,  15,  15,  15,  15,
     15,  15,  15,   0,   0,   0,   0,   0,  16,  16,  16,  16,  16,  16,  16,  16,
     16,  16,  16,  16,  16,   0,  16,  16,  16,   0,  16,  16,  16,  16,  16,  16,
     16,  16,   0,   0,   0,  16,  16,  16,  16,   0,  16,  16,  16,  16,   0,   0,
      0,   0,   0,   0,   0,  16,  16,   0,  16,  16,  16,   0,   0,   0,   0,   0,
     16,  16,  16,  16,   0,   0,  16,  16,   0,   0,   0,   0,   0,   0,   0,  16,
     17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,   0,  17,  17,
     17,   0,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,   0,  17,  17,  17,
     17,  17,   0,   0,  17,  17,  17,  17,  17,   0,  17,  17,  17,  17,   0,   0,
      0,   0,   0,   0,   0,  17,  17,   0,   0,   0,   0,   0,   0,   0,  17,   0,
     17,  17,  17,  17,   0,   0, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174,
      0,  17,  17,   0,   0,   0,   0,   0,  18,  18,  18,  18,   0,  18,  18,  18,
     18,  18,  18,  18,  18,   0,  18,  18,  18,   0,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,   0,   0,   0,   0,  18,  18,  18,  18,
     18,  18,  18,  18,   0,   0,  18,  18,   0,   0,  19,  19,   0,  19,  19,  19,
     19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,   0,
      0,   0,  19,  19,  19,  19,  19,  19,  19,  19,   0,  19,  19,  19,  19,  19,
     19,  19,  19,  19,   0,  19,   0,   0,   0,   0,  19,   0,   0,   0,   0,  19,
     19,  19,  19,  19,  19,   0,  19,   0,   0,   0,   0,   0,   0,   0,  19,  19,
      0,   0,  19,  19,  19,   0,   0,   0,   0,  20,  20,  20,  20,  20,  20,  20,
     20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,   0,   0,   0,   0,   1,
     20,  20,  20,  20,   0,   0,   0,   0,   0,  21,  21,   0,  21,   0,  21,  21,
     21,  21,  21,   0,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,
     21,  21,  21,  21,   0,  21,   0,  21,  21,  21,  21,  21,  21,  21,   0,   0,
     21,  21,  21,  21,  21,   0,  21,   0,  21,  21,   0,   0,  21,  21,  21,  21,
     22,  22,  22,  22,  22,  22,  22,  22,   0,  22,  22,  22,  22,  22,  22,  22,
     22,  22,  22,  22,  22,   0,   0,   0,  22,  22,  22,  22,  22,   0,  22,  22,
     22,  22,  22,  22,  22,   1,   1,   1,   1,  22,  22,   0,   0,   0,   0,   0,
     23,  23,  23,  23,  23,  23,  23,  23, 179, 179, 179, 179, 179, 179, 179, 179,
    179, 179,  23,  23,  23,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,
     24,  24,  24,  24,  24,  24,   0,  24,   0,   0,   0,   0,   0,  24,   0,   0,
     24,  24,  24, 169,  24,  24,  24,  24,  25,  25,  25,  25,  25,  25,  25,  25,
     26,  26,  26,  26,  26,  26,  26,  26,  26,   0,  26,  26,  26,  26,   0,   0,
     26,  26,  26,  26,  26,  26,  26,   0,  26,  26,  26,   0,   0,  26,  26,  26,
     26,  26,  26,  26,  26,   0,   0,   0,  26,  26,   0,   0,   0,   0,   0,   0,
     27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,   0,   0,
     28,  28,  28,  28,  28,  28,  28,  28,  29,  29,  29,  29,  29,  29,  29,  29,
     29,  29,  29,  29,  29,   0,   0,   0,  30,  30,  30,  30,  30,  30,  30,  30,
     30,  30,  30,   1,   1,   1,  30,  30,  30,   0,   0,   0,   0,   0,   0,   0,
     42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,   0,  42,  42,
     42,  42,  42,  42,  42,   0,   0,   0,  43,  43,  43,  43,  43,  43,  43,  43,
     43,  43,  43,  43,  43, 187, 187,   0,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,   0,   0,   0,   0,  45,  45,  45,  45,  45,  45,  45,  45,
     45,  45,  45,  45,  45,   0,  45,  45,  45,   0,  45,  45,   0,   0,   0,   0,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,   0,   0,
     31,  31,   0,   0,   0,   0,   0,   0,  32,  32, 176, 176,  32, 176,  32,  32,
     32,  32,  32,  32,  32,  32,  32,   0,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,   0,   0,   0,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,
     32,  32,  32,   0,   0,   0,   0,   0,  28,  28,  28,  28,  28,  28,   0,   0,
     46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,   0,
     46,  46,  46,  46,   0,   0,   0,   0,  46,   0,   0,   0,  46,  46,  46,  46,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,   0,   0,
     47,  47,  47,  47,  47,   0,   0,   0,  56,  56,  56,  56,  56,  56,  56,  56,
     56,  56,  56,  56,   0,   0,   0,   0,  56,  56,   0,   0,   0,   0,   0,   0,
     56,  56,  56,   0,   0,   0,  56,  56,  54,  54,  54,  54,  54,  54,  54,  54,
     54,  54,  54,  54,   0,   0,  54,  54,  78,  78,  78,  78,  78,  78,  78,  78,
     78,  78,  78,  78,  78,  78,  78,   0,  78,  78,  78,  78,  78,   0,   0,  78,
     78,  78,   0,   0,   0,   0,   0,   0,  78,  78,  78,  78,  78,  78,   0,   0,
     41,  41,  41,  41,  41,  41,  41,   0,  62,  62,  62,  62,  62,  62,  62,  62,
     62,  62,  62,  62,   0,   0,   0,   0,  62,  62,  62,  62,  62,   0,   0,   0,
     67,  67,  67,  67,  67,  67,  67,  67,  93,  93,  93,  93,  93,  93,  93,  93,
     93,  93,  93,  93,   0,   0,   0,   0,   0,   0,   0,   0,  93,  93,  93,  93,
     68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,  68,  68,  68,  68,  68,
     68,  68,   0,   0,   0,  68,  68,  68,  69,  69,  69,  69,  69,  69,  69,  69,
      4,   0,   0,   0,   0,   0,   0,   0,  24,  24,  24,   0,   0,  24,  24,  24,
    186,  10, 186, 165,  10, 158, 158, 167, 158, 167, 191,  10, 167, 167,  10,  10,
    167, 158,  10,  10,  10,  10,  10,  10,  10, 166, 158,  10,  10, 158,  10,  10,
     10,  10, 193, 165, 181, 158, 158,  11, 165, 165, 150,   0,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   4,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   2,   2,   2,   2,   3,   3,
      3,   3,   3,   2,   2,   2,   2,   2,   4,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   3,   3,   3,  41,  41,  41,  41,  41,  41,
     41,  41,   0,  41,  41,  41,  41,  41,   3,   3,   3,   3,   3,   3,   0,   0,
      0,   3,   0,   3,   0,   3,   0,   3,   3,   3,   3,   3,   3,   0,   3,   3,
      3,   3,   3,   3,   0,   0,   3,   3,   3,   3,   3,   3,   0,   3,   3,   3,
      0,   0,   3,   3,   3,   0,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,
      1,   1,   1,   1,  41,  41,   1,   1,   1,   1,   1,   1,   1,   1,   1, 175,
      1,   1,   1,   1,   1,   0,   1,   1,   1,   2,   0,   0,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   2,   1,   1,   1,   1,   1,   1,   1,   0,
      2,   2,   2,   2,   2,   0,   0,   0, 182,   0,   0,   0,   0,   0,   0,   0,
      1,   1,   1,   1,   1,   1,   3,   1,   1,   1,   2,   2,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   2,   1,   2,   1,   1,   1,   0,   0,   0,   0,
      1,   1,   1,   0,   0,   0,   0,   0,  53,  53,  53,  53,  53,  53,  53,  53,
      1,   1,   1,   1,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,   0,
     55,  55,  55,  55,   0,   0,   0,   0,   0,  55,  55,  55,  55,  55,  55,  55,
     58,  58,  58,  58,  58,  58,  58,  58,   0,   0,   0,   0,   0,   0,   0,  58,
     58,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1, 162,   1,   1,   1,   1,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,  36,  36,  36,  36,  36,
     36,  36,  36,  36,   0,   0,   0,   0,  36,  36,  36,  36,  36,  36,   0,   0,
      1,   1,   1,   1,   0,   0,   0,   0,   1, 190, 190, 189,   1,  36,  36,  36,
    190, 190, 190, 190, 190, 190, 190, 190, 190, 190,   1, 189, 190, 190, 190, 190,
    190, 190, 190, 190, 189, 189, 189, 189,   1,  36,  36,  36,  36,  36,  36,  36,
     36,  36, 159, 159, 159, 159,  25,  25, 189, 173, 173, 173, 173, 173,   1, 189,
     36,  36,  36,  36, 183, 183,  36,  36,   0,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   0,
      0, 173, 173, 173, 173,  33,  33,  33, 173,  34,  34,  34,  34,  34,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34, 190, 173,  34,  34,  34,
      0,   0,   0,   0,   0,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,
      0,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,   0,
     35,  35,  35,   0,   0,   0,   0,   0,  25,  25,  25,  25,  25,  25,  25,   1,
     36,   1,   1,   1,   1,   1,   1,   1,  36,  36,  36,  36,   1,   1,   1,   1,
     34,  34,  34,  34,  34,  34,  34,  36,   1,   1,   1,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,   1,  37,  37,  37,  37,  37,  37,  37,  37,
     37,  37,  37,  37,  37,   0,   0,   0,  37,  37,  37,  37,  37,  37,  37,   0,
     83,  83,  83,  83,  83,  83,  83,  83,  70,  70,  70,  70,  70,  70,  70,  70,
     70,  70,  70,  70,   0,   0,   0,   0,   4,   4,   4,   4,   4,   4,   4, 162,
     84,  84,  84,  84,  84,  84,  84,  84,   1,   1,   2,   2,   2,   2,   2,   2,
      1,   1,   1,   2,   2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   2,   0,
      0,   0,   0,   0,   0,   0,   0,   2,  59,  59,  59,  59,  59,  59,  59,  59,
     59,  59,  59,  59,   0,   0,   0,   0, 198, 198, 198, 197, 197, 197, 194, 194,
    194, 194,   0,   0,   0,   0,   0,   0,  65,  65,  65,  65,  65,  65,  65,  65,
     71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,  71,   0,   0,
      0,   0,   0,   0,   0,   0,  71,  71,  71,  71,   0,   0,   0,   0,   0,   0,
     10, 158,  10, 168,  10,  10,  10,  10,  72,  72,  72,  72,  72,  72,  72,  72,
     72,  72,  72,  72,  72,  72, 184,  72,  73,  73,  73,  73,  73,  73,  73,  73,
     73,  73,  73,  73,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  73,
     25,  25,  25,  25,  25,   0,   0,   0,  85,  85,  85,  85,  85,  85,  85,  85,
     85,  85,  85,  85,  85,  85,   0, 160,  85,  85,   0,   0,   0,   0,  85,  85,
     23,  23,  23,  23,  23,  23,  23,   0,  77,  77,  77,  77,  77,  77,  77,  77,
     77,  77,  77,  77,  77,  77,  77,   0,  77,  77,  77,  77,  77,  77,   0,   0,
     77,  77,   0,   0,  77,  77,  77,  77,  79,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,   0,   0,   0,   0,   0,   0,   0,   0,  79,  79,  79,  79,  79,
     86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86,   0,
      0,  26,  26,  26,  26,  26,  26,   0,   2,   2,   2,   1,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   3,   2,   2,  86,  86,  86,  86,  86,  86,   0,   0,
     86,  86,   0,   0,   0,   0,   0,   0,  25,  25,  25,  25,   0,   0,   0,   0,
      0,   0,   0,  25,  25,  25,  25,  25,  36,  36,   0,   0,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   5,   5,   5,   5,   5,
      0,   0,   0,   0,   0,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   0,
      6,   6,   6,   6,   6,   0,   6,   0,   6,   6,   0,   6,   6,   0,   6,   6,
      7,   7,   0,   0,   0,   0,   0,   0,   7,   7,   7,   7,   7,   7,   1,   1,
      0,   0,   7,   7,   7,   7,   7,   7,   7,   7, 156,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7, 156,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,
     41,  41,  41,  41,  41,  41,   4,   4,   1,   1,   1,   1,   1, 189, 189,   1,
      1,   1,   1,   0,   1,   1,   1,   1,   7,   7,   7,   7,   7,   0,   0,   1,
      0,   1,   1,   1,   1,   1,   1,   1,   1, 190, 190, 190, 190, 190,  34,  34,
     34,  34,  34,  34,  34,  34, 173, 173,   0,   0,  25,  25,  25,  25,  25,  25,
      0,   0,  25,  25,  25,   0,   0,   0,   0,   1,   1,   1,   1,   1,   0,   0,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,   0,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,   0,  48,  48,  48,   0,  48,  48,   0,  48,
     48,  48,  48,  48,  48,  48,   0,   0,  48,  48,  48,   0,   0,   0,   0,   0,
    161, 161, 161,   0,   0,   0,   0, 180, 180, 180, 180, 180, 180, 180, 180, 180,
    180, 180, 180, 180,   0,   0,   0, 161, 161, 161, 161, 161, 161, 161, 161, 161,
      3,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,  41,   0,   0,
     74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,   0,   0,   0,
     75,  75,  75,  75,  75,  75,  75,  75,  75,   0,   0,   0,   0,   0,   0,   0,
    153, 153, 153, 153, 153, 153, 153, 153, 153, 153, 153, 153,   0,   0,   0,   0,
     38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  38,  38,  38,  39,  39,  39,  39,  39,  39,  39,  39,
     39,  39,  39,   0,   0,   0,   0,   0, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120,   0,   0,   0,   0,   0,  49,  49,  49,  49,  49,  49,  49,  49,
     49,  49,  49,  49,  49,  49,   0,  49,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,   0,   0,   0,   0,  60,  60,  60,  60,  60,  60,   0,   0,
     40,  40,  40,  40,  40,  40,  40,  40,  50,  50,  50,  50,  50,  50,  50,  50,
     51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,  51,   0,   0,
     51,  51,   0,   0,   0,   0,   0,   0, 136, 136, 136, 136, 136, 136, 136, 136,
    136, 136, 136, 136,   0,   0,   0,   0, 106, 106, 106, 106, 106, 106, 106, 106,
    103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 103, 110, 110, 110, 110, 110, 110, 110, 110,
    110, 110, 110, 110, 110, 110, 110,   0, 110, 110, 110, 110, 110, 110,   0,   0,
     52,  52,  52,  52,  52,  52,   0,   0,  52,   0,  52,  52,  52,  52,  52,  52,
     52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,   0,  52,
     52,   0,   0,   0,  52,   0,   0,  52,  87,  87,  87,  87,  87,  87,  87,  87,
     87,  87,  87,  87,  87,  87,   0,  87, 118, 118, 118, 118, 118, 118, 118, 118,
    117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117,   0,
      0,   0,   0,   0,   0,   0,   0, 117, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128,   0, 128, 128,   0,   0,   0,   0,   0, 128, 128, 128, 128, 128,
     64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,   0,   0,   0,  64,
     76,  76,  76,  76,  76,  76,  76,  76,  76,  76,   0,   0,   0,   0,   0,  76,
     98,  98,  98,  98,  98,  98,  98,  98,  97,  97,  97,  97,  97,  97,  97,  97,
      0,   0,   0,   0,  97,  97,  97,  97,   0,   0,  97,  97,  97,  97,  97,  97,
     61,  61,  61,  61,   0,  61,  61,   0,   0,   0,   0,   0,  61,  61,  61,  61,
     61,  61,  61,  61,   0,  61,  61,  61,   0,  61,  61,  61,  61,  61,  61,  61,
     61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,   0,   0,
     61,  61,  61,   0,   0,   0,   0,  61,  61,   0,   0,   0,   0,   0,   0,   0,
     88,  88,  88,  88,  88,  88,  88,  88, 116, 116, 116, 116, 116, 116, 116, 116,
    112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,   0,
      0,   0,   0, 112, 112, 112, 112, 112,  80,  80,  80,  80,  80,  80,  80,  80,
     80,  80,  80,  80,  80,  80,   0,   0,   0,  80,  80,  80,  80,  80,  80,  80,
     89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,  89,   0,   0,
     90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  90,   0,   0,   0,   0,   0,
    121, 121, 121, 121, 121, 121, 121, 121, 121, 121,   0,   0,   0,   0,   0,   0,
      0, 121, 121, 121, 121,   0,   0,   0,   0, 121, 121, 121, 121, 121, 121, 121,
     91,  91,  91,  91,  91,  91,  91,  91,  91,   0,   0,   0,   0,   0,   0,   0,
    130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,   0,   0,   0,   0,   0,
      0,   0, 130, 130, 130, 130, 130, 130, 146, 146, 146, 146, 146, 146, 146, 146,
    146, 146,   0,   0,   0,   0,   0,   0,   7,   7,   7,   7,   7,   7,   7,   0,
    148, 148, 148, 148, 148, 148, 148, 148, 147, 147, 147, 147, 147, 147, 147, 147,
    147, 147,   0,   0,   0,   0,   0,   0, 149, 149, 149, 149, 149, 149, 149, 149,
    149, 149, 149, 149, 149, 149, 149,   0,  94,  94,  94,  94,  94,  94,  94,  94,
     94,  94,  94,  94,  94,  94,   0,   0,   0,   0,  94,  94,  94,  94,  94,  94,
      0,   0,   0,   0,   0,   0,   0,  94,  92,  92,  92,  92,  92,  92,  92,  92,
     92,  92,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  92,   0,   0,
    101, 101, 101, 101, 101, 101, 101, 101, 101,   0,   0,   0,   0,   0,   0,   0,
    101, 101,   0,   0,   0,   0,   0,   0,  96,  96,  96,  96,  96,  96,  96,  96,
     96,  96,  96,  96,  96,   0,  96,  96,  96,  96,  96,  96,  96,  96,  96,   0,
    111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,   0,
    100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,   0,   0,
      0,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,   0,   0,   0,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109,   0, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109,   0, 129, 129, 129, 129, 129, 129, 129,   0,
    129,   0, 129, 129, 129, 129,   0, 129, 129, 129, 129, 129, 129, 129, 129, 129,
    129, 129, 129, 129, 129, 129,   0, 129, 129, 129,   0,   0,   0,   0,   0,   0,
    123, 123, 123, 123, 123, 123, 123, 123, 123, 123, 123,   0,   0,   0,   0,   0,
    123, 123,   0,   0,   0,   0,   0,   0, 107, 170, 107, 170,   0, 107, 107, 107,
    107, 107, 107, 107, 107,   0,   0, 107, 107,   0,   0, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107,   0, 107, 107, 107, 107, 107, 107,
    107,   0, 107, 107,   0, 107, 107, 107, 107, 107,   0, 170, 170, 107, 107, 107,
    107,   0,   0, 107, 107, 107,   0,   0, 107,   0,   0,   0,   0,   0,   0, 107,
      0,   0,   0,   0,   0, 107, 107, 107, 107, 107, 107, 107,   0,   0, 107, 107,
    107, 107, 107, 107, 107,   0,   0,   0, 135, 135, 135, 135, 135, 135, 135, 135,
    135, 135,   0, 135,   0, 135, 135, 135, 124, 124, 124, 124, 124, 124, 124, 124,
    124, 124,   0,   0,   0,   0,   0,   0, 122, 122, 122, 122, 122, 122, 122, 122,
    122, 122, 122, 122, 122, 122,   0,   0, 114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114,   0,   0,   0, 114, 114,   0,   0,   0,   0,   0,   0,
     32,  32,  32,  32,  32,   0,   0,   0, 102, 102, 102, 102, 102, 102, 102, 102,
    102,   0,   0,   0,   0,   0,   0,   0, 102, 102,   0,   0,   0,   0,   0,   0,
    126, 126, 126, 126, 126, 126, 126, 126, 126, 126, 126,   0,   0, 126, 126, 126,
    126, 126, 126, 126,   0,   0,   0,   0, 142, 142, 142, 142, 142, 142, 142, 142,
    142, 142, 142, 142,   0,   0,   0,   0, 125, 125, 125, 125, 125, 125, 125, 125,
    125, 125, 125,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 125,
    150, 150, 150, 150, 150, 150, 150, 150,   0,   0, 150, 150, 150, 150, 150, 150,
    150, 150, 150, 150, 150,   0,   0,   0, 141, 141, 141, 141, 141, 141, 141, 141,
    140, 140, 140, 140, 140, 140, 140, 140, 140, 140, 140,   0,   0,   0,   0,   0,
    119, 119, 119, 119, 119, 119, 119, 119, 119,   0,   0,   0,   0,   0,   0,   0,
    133, 133, 133, 133, 133, 133, 133, 133, 133,   0, 133, 133, 133, 133, 133, 133,
    133, 133, 133, 133, 133, 133, 133,   0, 133, 133, 133, 133, 133, 133,   0,   0,
    133, 133, 133, 133, 133,   0,   0,   0, 134, 134, 134, 134, 134, 134, 134, 134,
      0,   0, 134, 134, 134, 134, 134, 134,   0, 134, 134, 134, 134, 134, 134, 134,
    134, 134, 134, 134, 134, 134, 134,   0, 138, 138, 138, 138, 138, 138, 138,   0,
    138, 138,   0, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 138,
      0,   0, 138,   0, 138, 138,   0, 138, 138, 138,   0,   0,   0,   0,   0,   0,
    143, 143, 143, 143, 143, 143,   0, 143, 143,   0, 143, 143, 143, 143, 143, 143,
    143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,   0,
    143, 143,   0, 143, 143, 143, 143, 143, 143,   0,   0,   0,   0,   0,   0,   0,
    143, 143,   0,   0,   0,   0,   0,   0, 144, 144, 144, 144, 144, 144, 144, 144,
    144,   0,   0,   0,   0,   0,   0,   0, 170, 170,  15, 170,  15,  15,  15,  15,
     15,  15,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  15,
     63,  63,  63,  63,  63,  63,  63,  63,  63,  63,   0,   0,   0,   0,   0,   0,
     63,  63,  63,  63,  63,  63,  63,   0,  63,  63,  63,  63,  63,   0,   0,   0,
     63,  63,  63,  63,   0,   0,   0,   0,  81,  81,  81,  81,  81,  81,  81,  81,
     81,  81,  81,  81,  81,  81,  81,   0,  81,   0,   0,   0,   0,   0,   0,   0,
    127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,   0,
     84,   0,   0,   0,   0,   0,   0,   0, 115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115,   0, 115, 115,   0,   0,   0,   0, 115, 115,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,   0,   0,
    108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,   0,   0,
    108, 108,   0, 108, 108, 108, 108, 108,   0,   0,   0,   0,   0, 108, 108, 108,
    145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,   0,   0,   0,   0,   0,
     99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99,   0,   0,   0,   0,  99,
      0,   0,   0,   0,   0,   0,   0,  99, 137, 139,   1,   1,   0,   0,   0,   0,
    137, 137, 137, 137, 137, 137, 137, 137, 137, 137, 137,   0,   0,   0,   0,   0,
     34,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  34,  34,  34,  34, 139, 139, 139, 139, 139, 139, 139, 139,
    139, 139, 139, 139,   0,   0,   0,   0, 105, 105, 105, 105, 105, 105, 105, 105,
    105, 105, 105,   0,   0,   0,   0,   0, 105, 105, 105, 105, 105,   0,   0,   0,
    105,   0,   0,   0,   0,   0,   0,   0, 105, 105,   0,   0, 105, 105, 105, 105,
    105, 105, 105, 105,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,  41,
     41,  41,   1,   1,   1,   1,   1,   1,   1,   1,   1,  41,  41,  41,  41,  41,
     41,  41,  41,   1,   1,  41,  41,  41,  41,  41,  41,  41,   1,   1,   1,   1,
      1,   1,  41,  41,  41,  41,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,
     36,  36,   1,   1,   1,   1,   1,   1,   0,   0,   1,   0,   0,   1,   1,   0,
      0,   1,   1,   1,   1,   0,   1,   1,   1,   1,   0,   1,   0,   1,   1,   1,
      1,   1,   1,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   1,
      1,   1,   1,   0,   0,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,   0,
      1,   1,   1,   1,   1,   0,   1,   0,   0,   0,   1,   1,   1,   1,   1,   1,
      1,   0,   1,   1,   1,   1,   1,   1, 131, 131, 131, 131, 131, 131, 131, 131,
    131, 131, 131, 131,   0,   0,   0,   0,   0,   0,   0, 131, 131, 131, 131, 131,
      0, 131, 131, 131, 131, 131, 131, 131,  57,   0,   0,  57,  57,  57,  57,  57,
     57,  57,   0,  57,  57,   0,  57,  57,  57,  57,  57,   0,   0,   0,   0,   0,
    151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151,   0,   0,   0,
    151, 151, 151, 151, 151, 151,   0,   0, 151, 151,   0,   0,   0,   0, 151, 151,
    152, 152, 152, 152, 152, 152, 152, 152, 152, 152,   0,   0,   0,   0,   0, 152,
    113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113,   0,   0, 113,
    113, 113, 113, 113, 113, 113, 113,   0, 132, 132, 132, 132, 132, 132, 132, 132,
    132, 132, 132, 132,   0,   0,   0,   0, 132, 132,   0,   0,   0,   0, 132, 132,
      1,   1,   1,   1,   1,   0,   0,   0,   7,   7,   7,   7,   0,   7,   7,   7,
      0,   7,   7,   0,   7,   0,   0,   7,   0,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   0,   7,   7,   7,   7,   0,   7,   0,   7,   0,   0,   0,   0,
      0,   0,   7,   0,   0,   0,   0,   7,   0,   7,   0,   7,   0,   7,   7,   7,
      0,   7,   0,   7,   0,   7,   0,   7,   0,   7,   7,   7,   7,   0,   7,   0,
      7,   7,   0,   7,   7,   7,   7,   7,   7,   7,   7,   7,   0,   0,   0,   0,
      0,   7,   7,   7,   0,   7,   7,   7,   0,   0,   0,   0,   0,   0,   1,   1,
     33,   1,   1,   0,   0,   0,   0,   0,   1,   1,   1,   0,   0,   0,   1,   1,
     36,  36,  36,  36,  36,  36,  36,   0,  36,  36,  36,  36,  36,   0,   0,   0,
     36,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
};

/* Script_Extensions: 14272 bytes. */

static RE_ScriptExt re_scripts_extensions_table[] = {
    {{  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 11,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 13,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 14,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 15,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 17,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 18,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 19,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 20,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 21,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 22,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 23,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 25,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 26,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 27,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 28,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 29,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 30,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 31,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 33,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 34,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 35,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 36,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 37,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 38,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 39,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 40,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 41,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 42,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 43,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 44,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 46,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 47,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 48,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 50,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 51,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 52,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 53,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 54,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 55,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 56,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 57,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 58,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 59,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 60,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 61,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 62,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 63,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 65,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 66,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 67,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 69,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 70,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 71,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 72,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 73,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 74,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 75,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 76,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 77,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 78,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 79,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 80,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 81,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 82,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 83,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 84,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 85,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 86,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 87,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 88,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 89,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 90,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 91,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 92,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 93,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 94,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 95,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 96,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 97,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 98,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 99,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{100,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{102,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{103,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{104,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{105,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{106,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{107,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{109,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{110,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{111,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{112,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{113,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{114,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{115,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{117,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{118,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{119,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{120,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{121,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{122,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{123,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{124,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{125,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{126,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{127,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{129,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{130,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{131,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{132,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{133,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{134,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{136,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{137,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{138,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{139,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{140,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{141,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{142,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{143,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{144,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{145,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{146,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{147,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{148,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{149,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{150,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{151,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{152,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7,  55,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7, 146,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7,   8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7,   9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  5,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  11,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 35,  36,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 54,  85,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 48,  52,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  4,  57,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  4, 120,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10, 107,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10, 150,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10, 100,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  15,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 15, 107,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 13, 109,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 12, 129,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 33,  34,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 17, 150,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 32,  65,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7,   8,   9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 11,  59,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 23,  47,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 48,  52, 110,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  17, 107,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,  10, 107,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 33,  34,  36,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,  23,  72,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7,   8,   9, 146,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  11,  17, 107,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 42,  43,  44,  45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  92, 111, 142,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 25,  33,  34,  35,  36,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 25,  33,  34,  35,  36,  37,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  14,  15,  16,  17,  18,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  7,   8,  95, 112, 121, 132, 146, 147,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  11,  14,  16,  17, 107, 124, 150,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  12,  13,  92, 102, 109, 111, 114, 123, 124, 142,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,  10,  11,  12,  13,  14,  15,  16,  17,  18, 107, 124,   0,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{  2,  10,  11,  12,  13,  14,  15,  16,  17,  18, 100, 107, 124,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  12,  13,  17,  92, 102, 109, 111, 114, 123, 124, 142, 150,   0,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  12,  13,  17,  18,  92, 102, 109, 111, 114, 123, 124, 142, 150,   0,   0,   0,   0,   0,   0,   0}},
    {{ 10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  59, 102, 107, 111, 123, 124, 138, 142, 143, 150,   0}},
    {{ 10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  46,  59, 102, 107, 111, 123, 124, 138, 142, 143, 150}}
};

int re_get_script_extensions(RE_UINT32 ch, RE_UINT8* scripts) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;
    RE_UINT8* scr;
    int count;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_script_extensions_stage_1[f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_script_extensions_stage_2[pos + f] << 4;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_script_extensions_stage_3[pos + f] << 3;
    value = re_script_extensions_stage_4[pos + code];

    scr = re_scripts_extensions_table[value].scripts;
    scripts[0] = scr[0];
    count = 1;

    if (scr[0] != 0) {
        while (count < RE_MAX_SCX && scr[count] != 0) {
            scripts[count] = scr[count];
            ++count;
        }
    }

    return count;
}

/* Word_Break. */

static RE_UINT8 re_word_break_stage_1[] = {
     0,  1,  2,  3,  4,  4,  4,  4,  4,  4,  5,  6,  6,  7,  4,  8,
     9, 10, 11, 12, 13,  4, 14,  4,  4,  4,  4, 15,  4, 16, 17, 18,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
    19,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
};

static RE_UINT8 re_word_break_stage_2[] = {
      0,   1,   2,   2,   2,   3,   4,   5,   2,   6,   7,   8,   9,  10,  11,  12,
     13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,
     29,  30,   2,   2,  31,  32,  33,  34,  35,   2,   2,   2,  36,  37,  38,  39,
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49,   2,  50,   2,   2,  51,  52,
     53,  54,  55,  56,  57,  57,  57,  57,  57,  58,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  59,  60,  61,  62,  63,  57,  57,  57,
     64,  65,  66,  67,  57,  68,  69,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
      2,   2,   2,   2,   2,   2,   2,   2,   2,  70,   2,   2,  71,  72,  73,  74,
     75,  76,  77,  78,  79,  80,  81,  82,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  83,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  84,  85,   2,   2,  86,  87,  88,  89,  90,  91,
     92,  93,  94,  95,  57,  96,  97,  98,   2,  99, 100,  57,   2,   2, 101,  57,
    102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,  57,  57,  57, 113, 114,
    115, 116, 117, 118, 119, 120, 121,  57, 122, 123,  57, 124, 125, 126, 127,  57,
    128, 129,  57, 130, 131, 132,  57,  57, 133, 134, 135, 136,  57, 137,  57,  57,
      2,   2,   2,   2,   2,   2,   2, 138, 139,   2, 140,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
      2,   2,   2,   2,   2,   2,   2,   2, 141,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,   2,   2,   2,   2, 142,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
      2,   2,   2,   2, 143, 144, 145, 146,  57,  57,  57,  57, 147,  57, 148, 149,
    150,  57, 151,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57, 152, 153,  57,  57,  57,  57,  57,  57,
     57,  57, 154, 155, 156,  57,  57,  57, 157, 158, 159,   2,   2, 160, 161, 162,
     57,  57,  57,  57, 163, 164,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
    165,  57, 166,  57,  57, 167,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
      2, 168, 169,  57,  57,  57,  57,  57,  57,  57,  57,  57, 170, 171,  57,  57,
     57,  57, 172, 173,  57,  57,  57, 174,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
    175,  57, 176, 177,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
     57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
};

static RE_UINT8 re_word_break_stage_3[] = {
      0,   0,   1,   2,   0,   0,   0,   0,   3,   4,   0,   5,   6,   6,   7,   0,
      8,   9,   9,   9,   9,   9,  10,  11,   8,   9,   9,   9,   9,   9,  10,   0,
      0,  12,   0,   0,   0,   0,   0,   0,   0,   0,  13,  14,   0,  15,  13,   0,
      9,   9,   9,   9,   9,  10,   9,   9,   9,   9,   9,   9,   9,  10,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   0,  16,   9,  17,   0,   9,   9,   9,   9,   9,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,   9,  19,  16,  20,
      0,  21,  10,  19,   9,   9,   9,   9,  22,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  22,   9,   9,
     23,  18,  24,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   8,   9,   9,   9,
      9,   9,   9,   9,   9,  10,  25,  26,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  27,   0,  28,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  29,
     30,  29,   0,   0,  31,  31,  31,  31,  31,  31,  32,  33,  34,  35,   0,   0,
     36,  37,   0,  38,  18,  18,  39,  40,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  41,  18,  18,  18,  18,  18,   6,   6,  42,  43,  44,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,  45,  18,  46,  18,  47,  48,  24,   6,   6,  49,  50,
      0,   0,   0,  51,  52,   9,   9,   9,   9,   9,   9,   9,  18,  18,  18,  18,
     18,  18,  39,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,  53,  18,  18,  54,   0,   0,   0,
      6,   6,  49,   9,   9,   9,   9,   9,   9,   9,  41,  18,  18,  55,  56,  57,
      9,   9,   9,   9,   9,  53,  58,  18,  18,  59,  59,  60,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,  59,   0,   9,   9,  10,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   9,   9,  19,   9,  55,
      0,   0,   0,   0,  61,  18,  18,  18,  62,  18,  18,  18,  18,  18,  18,  18,
     18,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  53,  63,
     18,  18,  18,  18,  59,  18,   9,   9,  53,  64,   6,   6,   8,   9,   9,   9,
     59,   8,   9,  50,  50,   9,   9,   9,   9,   9,  19,   9,  26,  16,  55,  63,
     18,  65,  65,  66,   0,  61,   0,  22,  53,  64,   6,   6,  55,   0,   0,  67,
     28,   8,  10,  68,  50,   9,   9,   9,   9,   9,  19,   9,  19,  69,  55,  48,
     39,  61,  65,  60,  57,   0,   8,  26,   0,  64,   6,   6,  24,  70,   0,   0,
     28,   8,   9,  22,  22,   9,   9,   9,   9,   9,  19,   9,  19,   8,  55,  63,
     18,  29,  29,  60,  17,   0,   0,   0,  53,  64,   6,   6,   0,   0,  45,  18,
     28,   8,   9,  50,  50,   9,   9,   9,   9,   9,  19,   9,  19,   8,  55,  63,
     18,  65,  65,  60,   0,  71,   0,  22,  53,  64,   6,   6,  72,   0,   0,   0,
     73,   8,  10,  16,  19,  55,  69,  19,  68,  17,  10,  16,   9,   9,  55,  71,
     39,  71,  48,  60,  17,  61,   0,   0,   0,  64,   6,   6,   0,   0,   0,   0,
     18,  44,   9,  19,  19,   9,   9,   9,   9,   9,  19,   9,   9,   9,  55,  45,
     18,  48,  48,  60,   0,  30,  10,   0,  53,  64,   6,   6,   0,   0,   0,   0,
     59,   8,   9,  19,  19,   9,   9,   9,   9,   9,  19,   9,   9,   8,  55,  63,
     18,  48,  48,  60,   0,  30,   0,  13,  53,  64,   6,   6,  69,   0,   0,   0,
     18,   8,   9,  19,  19,   9,   9,   9,   9,   9,   9,   9,   9,   9,  41,  63,
     18,  48,  48,  66,   0,  41,   0,  68,  53,  64,   6,   6,   0,   0,  16,   9,
     71,   8,   9,   9,   9,  10,  16,   9,   9,   9,   9,   9,  22,   9,   9,  72,
      9,  10,  74,  61,  18,  75,  18,  18,   0,  64,   6,   6,  71,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  57,  18,  39,   0,
      0,  61,  18,  39,   6,   6,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  57,  18,  18,  77,
      0,   0,  18,  60,   6,   6,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     17,   0,   0,   0,   0,   0,  60,   0,   6,   6,  76,   0,   0,  78,  57,  71,
      9,   9,   8,   9,   9,   9,   9,   9,   9,   9,   9,  17,  28,  18,  18,  18,
     18,  48,   9,  59,  18,  18,  28,  18,  18,  18,  18,  18,  18,  18,  18,  77,
      0,  74,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  61,  18,  18,  18,  18,  39,
      6,   6,  76,   0,   0,  71,  60,  71,  48,  65,  18,  60,  28,  77,   0,   0,
     71,  18,  18,  29,   6,   6,  79,  60,   9,   9,   9,   9,   9,   9,   9,   9,
      9,  22,   0,  72,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  19,  55,   9,  10,  19,  55,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  19,  55,   9,   9,   9,   9,   9,   9,   9,   9,  19,  55,   9,  10,
     19,  55,   9,   9,   9,  10,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,  19,  55,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,  10,  28,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   0,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  55,   9,  55,
      8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  50,   9,   9,   9,   9,
     80,   9,   9,   9,   9,   9,  10,   0,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  16,   9,   9,  17,   0,
      9,   9,   9,  19,  53,  77,   0,   0,   9,   9,   9,   9,  53,  77,   0,   0,
      9,   9,   9,   9,  53,   0,   0,   0,   9,   9,   9,  19,  81,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  18,  18,  18,
     18,  18,  18,  18,  18,   0,   0,  57,   6,   6,  76,   0,   0,   0,   0,   0,
      0,   0,  61,  82,   6,   6,  76,   0,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  17,   0,
      9,  83,   9,   9,   9,   9,   9,   9,   9,   9,  84,   0,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  55,   0,   0,
      9,   9,   9,   9,   9,   9,   9,  10,  18,  18,  18,   0,  18,  18,  18,   0,
      0,  64,   6,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   6,   6,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,  41,  18,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  28,  18,  39,  18,  18,  18,  18,  18,  18,  18,  65,
      6,   6,  76,   0,   6,   6,  76,   0,   0,   0,   0,   0,  18,  18,  18,  39,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     18,  44,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,  18,
     18,  44,   9,   0,   6,   6,  76,   0,   0,   0,  61,  18,  18,   0,   0,   0,
     85,   9,   9,   9,   9,   9,   9,   9,  59,  18,  18,  24,   6,   6,  49,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,  53,  18,  18,  18,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,  18,  18,  18,   0,   0,
      6,   6,  76,   8,   6,   6,  49,   9,   9,   9,   9,   9,   9,   9,   9,  55,
      9,   9,  17,   0,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   8,
      0,   0,   0,   0,  39,  18,  18,  18,  18,  18,  44,  52,   9,  47,  66,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  29,  18,
      9,   9,   9,   9,   9,  55,   9,  55,   9,   9,   9,   9,   9,   9,   9,   9,
      9,  55,   9,  55,   9,   9,  25,  25,   9,   9,   9,   9,   9,   9,   9,  55,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  19,   9,  26,
     16,  19,   9,  17,   9,  16,   9,   0,   9,   9,   9,  17,  16,  19,   9,  17,
     86,  87,  87,  88,   0,   0,  89,   0,   0,  90,  91,  92,   0,   0,   0,  11,
     93,  94,   0,   0,   0,  93,   0,  95,  36,  96,  36,  36,  72,   0,   0,  68,
      0,   0,   0,   0,   9,   9,   9,  17,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  18,  18,  18,  18,  18,  18,  18,  18,  77,   0,   0,   0,
     13,  68,  16,   9,   9,  72,   8,  55,   0,  26,  19,  22,   9,   9,  55,   9,
      0,   8,  55,  13,   0,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  17,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  55,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,  10,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,  17,  68,  41,  24,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,  22,   0,  72,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,  68,   0,   0,   0,  61,
      9,   9,   9,   9,   9,  10,   0,   0,   9,  10,   9,  10,   9,  10,   9,  10,
      9,  10,   9,  10,   9,  10,   9,  10,  18,  18,  18,  18,  18,  18,  18,  18,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  68,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     97,  72,   0,   0,   0,   0,   0,   0,   0,   0,  71,  18,  98,  99,  68,  17,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 100, 101, 102, 102, 102, 102, 102, 102, 102, 102,
    102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 103, 102,
      0,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   8,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,  10,   0,   0,   0,   0,   9,   9,   9,   9,   9,   9,  10,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 102, 102, 102, 102,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 103,
    102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,
    102, 102, 102, 102, 102, 102,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,  17,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  55,
      9,   9,   9,  17,   9,   9,   9,   9,   6,   6,  49,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  41,  39,  18,  18, 104,
      9,   9,   9,   9,   9,   9,   9,  53,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  60,   0,   0,   0,
      0,   0,   0,   0,   0,  68,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
     16,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  68,   9,   9,
    105, 105,  41,   9,   9,   9,   9,   9,  41,  18,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,   0,   0,
     24,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,  18,
     18,  60,   0,   0,   6,   6,  76,   0,  18,  18,  18,  18,  24,   9,  68, 106,
      6,   6,  49,   9,   9,   9,   9,   9,   9,  53,  18,  60,   9,   9,   9,   9,
      9,  41,  18,  18,  18,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,  17,
     18,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  18,  18,
     77,   0,   0,  68,   6,   6,  76,   0,   0,  57,   0,   0,   6,   6,  76,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  59,  18,  18,  39,   0,   0,
     41,   9,   9,  60,   6,   6,  76,   0,   0,   0,   0,   0,   0,   0,  61,  60,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  48,  65,  77,  71,
     57,   0,   0,   0,   0,   0,   0,   0,   9,   9,  41,  18,  16, 107,   0,   0,
      8,  10,   8,  10,   8,  10,   0,   0,   9,  10,   9,  10,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,   0,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  39,  60,   6,   6,  76,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   0,   0,   0,   9,   9,   9,   9,
      9,  10,  68,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,
      9,  10,   0,   0,  68,   9,   0, 108,  31,  31, 109,  31,  31,  32,  31, 110,
    111, 109,  31,  31,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  55,   0,   0,   0,
      0,   0,   0,   0,  68,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  55,
      0,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,  16,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   0,
     18,  18,  18,  18, 112,  94,   0,   0,  18,  18,  18,  18,  11,  93,   0,   0,
      0,   0,   0, 113,   5, 114,   0,   0,   0,   0,   0,   0,   9,  19,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9, 115,
      0, 116,   0,   5,   6,   6,   7,   0,   8,   9,   9,   9,   9,   9,  10,  11,
      8,   9,   9,   9,   9,   9,  10,   0,   0, 117, 102, 102, 102, 102, 102, 102,
    102, 102, 102, 102, 102, 102, 102, 118,   9,   9,   9,   9,   9,   9,   9,  10,
     16,   9,  16,   9,  16,   9,  16,  17,   0,   0,   0,   0,   0,   0, 119,   0,
      9,   9,   9,   8,   9,   9,   9,   9,   9,  10,   9,   9,   9,   9,  10,  22,
      9,   9,   9,  55,   9,   9,   9,  55,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  17,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  57,
      9,   9,   9,   9,   9,   9,   9,  17,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,  17,   0,   0,   0,  77,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   0,   0,   0,   8,   9,   9,   9,   9,
      9,   9,  10,   0,   9,   9,   9,   9,   9,   9,   9,   9,   9,  53,  39,   0,
      9,   9,   9,   9,   9,   9,   9,  55,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   0,   9,   9,   8,  55,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,  55,   6,   6,  76,   0,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   0,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,   0,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   0,   0,
      9,   9,   9,   9,   9,  55,   0,   0,   9,   9,   0,   0,   0,   0,   0,   0,
      9,  55,  19,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  22,  17,  50,
      9,   9,   9,   9,   9,  55,   0,   0,   9,   9,   9,   9,   9,  10,   0,   0,
      9,   9,   9,   9,   9,   9,   9,  10,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   9,  10,  55,   0,   0,
      9,   9,   9,   9,   9,  55,   0,   0,   9,   9,   9,   9,   9,   9,  55,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   0,  16,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     59,  30,   0,  18,   9,   8,   8,   9,   9,   9,   9,   9,   9,  55,  39,  61,
      0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,  17,
      9,   9,   9,   9,   9,   9,   9,  17,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   8,   9,   9,   9,   9,   9,   9, 107,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  55,   0,   0,
      9,   9,   9,   9,   9,  55,   0,   0,   9,   9,   9,   9,  10,   0,   0,   0,
      9,   9,   9,   9,  55,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  17,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,  18,   0,   0,   6,   6,  76,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,  17,   0,  68,   0,   0,   9,   9,   9,   9,
      9,  53,  18,  18,  77,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   9,   9,  10,   0,   0,
     85,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,
     18,  39,   0,   0,   0,   0,   0,   0,   0,  64,   6,   6,   0,   0,   0,  61,
     85,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,  39,  14,
      0,   0,   0,  14,   9,   9,   9,   9,   9,   9,  17,   0,   6,   6,  76,   0,
     85,   9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  18,  18, 120,   6,   6,
      0, 107,   0,   0,   9,   9,   9,   9,   9,   9,   9,   9,  41,  13,   0,   0,
     85,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  18,  18,
     44,  17,  28,  77,   6,   6, 121,  17,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,  22,   9,   9,   9,   9,   9,   9,  18,  18,  18,   0,  74,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,  10,  19,  22,   9,   9,   9,  22,   9,   9,  17,   0,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,  41,  18,  18,  39,   0,   6,   6,  76,   0,
     18,   8,   9,  50,  50,   9,   9,   9,   9,   9,  19,   9,  19,   8,  23,  63,
     18,  65,  65,  60,  17,  61,   0,   8,  53,  71,  18,  77,  18,  77,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  59,  18,  18,
     18,  85,  10,   0,   6,   6,  76,  73,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,  18,  18,
     18,  22,   0,   0,   6,   6,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  60,  18,  18,
     77,   0,   0,   0,   0,   0,   9,  60,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,  18,  18,
     77,  17,   0,   0,   6,   6,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  18,  18,  17,   0,
      6,   6,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  28,  18,  18,  18,   0,   6,   6,  76,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  18,  18,  39,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   6,   6,  76,   0,   0,   0,   0,  68,
      0,   0,   0,   0,   0,   0,   0,   0,   9,   9,  16,   9,   9,   9,   9,   9,
      9,   9,   9,   9,  59,  18,  71,  18, 122,  77,   0,   0,   0,   0,   0,   0,
     59,  18,  85,   9,   9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  58,  39,
      0,  61,   0,   0,  59,  18,  18,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  53,  18,  18,  18,  60,  72,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  17,   0,
      9,   9,  19,   9,   9,   9,   9,   9,   9,   9,   9,  41,  18,  39,  18,  18,
     17,   0,   0,   0,   6,   6,  76,   0,   0,   0,   0,   0,  16,   9,   9,   9,
      9,   9,   9,   9,  71,  18,  18,  18,  18,  18,  28,  18,  18,  39,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,  10,  22,   9,   9,   9,   9,   9,   9,   9,   9,   9,  59,  39,  74,  29,
     18,  58,   0,   0,   6,   6,  76,   0,   9,  22,  19,   9,   9,   9,   9,   9,
      9,   9,  53,  39,  29,  18,  17,   0,   6,   6,  76,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   9,  41,  39,   0,   0,
      9,   9,   9,   9,   9,   9,  55,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  36,  36,  40,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,  10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  17,   0,
      9,   9,   9,   9,   9,   9,   9,  10,   6,   6,  76,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   9,   9,   9,   9,   9,   9,   9,  55,  18,  77,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,  39,   0,   0,
      9,   0,   0,   0,   6,   6,  76,   0,  68,   9,   9,   9,   9,   9,   0,   8,
      9,   9,   9,   9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,  10,  61,  59,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,   0,  61,  85,   9,   9,   9,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  22,   0,   0,   0,   0,   0,   0,   0,
    101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0, 102,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,   0,   9,   9,   9,  17,
      9,   9,  17,   0,   9,   9,  55,  30,  36,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  28,  60,  28, 123,  36, 124,  18,
     39,  28,  18,   0,   0,   0,   0,   0,   0,   0,  71,  60,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     71,  77,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,  19,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,  19,  13,  69,   8,  19,   9,   9,  22,   8,
      9,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,  22,  10,   8,   9,  19,   9,  19,   9,   9,   9,   9,   9,   9,  22,  10,
      9,  26,  16,   9,  19,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,   9,   9,   9,   9,   9,   9,   9,   9,  55,   9,   9,   9,   9,   9,   9,
     19,   9,   9,   9,   9,   9,  10,   9,   9,   9,   9,   9,   9,   9,  10,   9,
      9,   9,   9,   9,   9,  19,   9,   9,   9,   9,   9,   9,   9,  19,   9,   9,
      9,   9,   9,  10,   9,   9,   9,   9,   9,   9,   9,  10,   9,   9,   9,   9,
      9,   9,  19,   9,   9,   9,   9,   9,   9,   9,  19,   9,   9,   9,   9,   9,
     10,   9,   9,  64,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  39,  61,  18,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  77,   0,  57,   0,   0,
      0,  77,   0,   0,   0,   0,  61,  18,  28,  18,  18,  18,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     18,  39,  18,  18,  18,  18,  65,  18,  29,  48,  39,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  17,  18,  85,   9,  55,
      6,   6,  76,  13,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  18,   6,   6,  76,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,  17,   0,   0,  18,  39,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
      9,  18,  85,   0,   6,   6,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      9,   8,   9,   9,   9,   9,   9,   9,  69,  50,   8,   9,  10,   9,  25,   0,
     13,  68,  25,   8,  69,  50,  25,  25,  69,  50,  10,   9,  10,   9,   8,  26,
      9,   9,  22,   9,   9,   9,   9,   0,   8,   8,  22,   9,   9,   9,   9,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   9,   9,   9,
      9,   9,  55,   0,   9,   9,   9,   9,   9,   9,  55,   0,   9,   9,   9,   9,
      9,   9,  55,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0, 125, 126, 126, 126, 126, 126, 126,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  61,  18,
     14,   0,   0,   0,   0,   0,   0,   0,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,   0,   0,   0,   0,
};

static RE_UINT8 re_word_break_stage_4[] = {
     0,  0,  0,  0,  0,  0,  5,  6,  6,  4,  0,  0, 18,  0,  1,  0,
     0,  0,  0,  2, 13,  0, 14,  0, 15, 15, 15, 15, 15, 15, 12, 13,
     0, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  0,  0,  0,  0, 16,
     0,  6,  0,  0,  0,  0, 11,  0,  0,  9,  0,  0,  0, 11,  0, 12,
     0,  0, 11, 11, 11,  0,  0,  0,  7,  7,  7,  7, 11,  0, 11, 11,
    11, 11, 13, 11,  0,  0, 11, 12, 11, 11,  0, 11, 11, 11,  0,  7,
     7,  7, 11, 11,  0, 11,  0, 11, 11,  0, 11,  0, 11, 13,  0,  0,
     0,  7,  7,  7,  7,  7,  0,  7,  0,  7,  7,  0,  3,  3,  3,  3,
     3,  3,  3,  0,  0,  0,  0,  3,  3,  3,  3, 11, 12,  0,  0,  0,
     9,  9,  9,  9,  9,  9,  0,  0, 13, 13,  0,  0,  7,  7,  7,  0,
     9,  0,  0,  0, 11, 11, 11,  7, 15, 15,  0, 15, 13,  0, 11, 11,
     7, 11, 11, 11,  0, 11,  7,  7,  7,  9,  0,  7,  7, 11, 11,  7,
     7,  0,  7,  7, 15, 15, 11, 11, 11,  0,  0, 11,  0,  0,  0,  9,
    11,  7, 11, 11, 11, 11,  7,  7,  7, 11,  0,  0, 11, 11,  0,  0,
    13,  0, 11,  0,  0,  7,  0,  0,  7,  7, 11,  7, 11,  7,  7,  7,
     7,  7,  0,  0,  0,  0,  0,  7,  7,  7,  9,  7,  7, 11,  7,  7,
     0,  0, 15, 15,  7,  0,  0,  7,  7,  7, 11,  0, 11,  0,  7,  0,
     0,  0,  0, 11,  0, 11, 11,  0, 11,  7,  0,  0,  0,  0,  7,  7,
     0, 11,  0,  0,  0,  0,  7, 11,  0,  0,  7,  0,  7,  0,  7,  0,
    15, 15,  0,  0,  7,  0,  0,  0,  0,  7,  0,  7, 15, 15,  7,  7,
    18, 11, 11, 11, 11,  0,  7,  7,  7,  7,  9,  0, 11,  7,  7, 11,
    11,  7, 11,  0,  7,  7,  7, 11, 18, 18, 18, 18, 18, 18, 18,  0,
     7, 17,  9,  9, 14, 14,  0,  0, 14,  0,  0, 12,  6,  6,  9,  9,
     9,  9,  9, 16, 16,  0,  0,  0, 13,  0,  0,  0,  0,  0,  0, 18,
     9,  0,  9,  9, 18,  0,  0,  0,  0, 10, 10, 10, 10, 10,  0,  0,
     0,  7,  7, 10, 10,  0,  0,  0, 10, 10, 10, 10, 10, 10, 10,  0,
     7,  7,  0, 11, 11, 11,  7, 11,  0, 11, 11,  7, 11,  7,  7,  0,
     0,  3,  7,  3,  3,  0,  3,  3,  3,  0,  3,  0,  3,  3,  0,  3,
    13,  0,  0, 12,  0, 16, 16, 16, 13, 12,  0,  0, 11,  0,  0,  9,
     0,  0,  0, 14,  0,  0, 10, 10, 10, 10,  7,  7,  0,  9,  9,  9,
     7,  0, 15, 15, 15, 15, 11,  0,  7, 11,  0, 11,  7,  7,  7,  9,
     9,  9,  9,  7,  0,  0,  8,  8,  8,  8,  8,  8,
};

/* Word_Break: 7116 bytes. */

RE_UINT32 re_get_word_break(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_word_break_stage_1[f] << 5;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_word_break_stage_2[pos + f] << 5;
    f = code >> 2;
    code ^= f << 2;
    pos = (RE_UINT32)re_word_break_stage_3[pos + f] << 2;
    value = re_word_break_stage_4[pos + code];

    return value;
}

/* Grapheme_Cluster_Break. */

static RE_UINT8 re_grapheme_cluster_break_stage_1[] = {
     0,  1,  2,  3,  4,  4,  4,  4,  4,  4,  5,  6,  7,  8,  4,  9,
    10, 11,  4, 12,  4,  4, 13,  4,  4,  4,  4, 14,  4, 15, 16, 17,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
    18,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
};

static RE_UINT8 re_grapheme_cluster_break_stage_2[] = {
      0,   1,   2,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   5,   3,   3,
      3,   3,   6,   3,   3,   3,   7,   8,   9,  10,   3,  11,  12,  13,  14,  15,
     16,  17,   3,  18,  19,  20,  21,  22,  23,  24,  23,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,
     46,  47,  48,   3,  49,  50,  51,  52,   3,   3,   3,   3,   3,  53,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,  54,  55,  56,  57,
     58,   3,  59,   3,  60,   3,   3,   3,  61,  62,  63,   3,  64,  65,  66,  67,
     68,   3,   3,  69,   3,   3,   3,  70,   3,   3,   3,   3,   3,   3,   3,   3,
     71,  72,   3,  73,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,  74,   3,  75,   3,  76,   3,   3,   3,   3,   3,   3,   3,   3,
     77,   3,  78,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,  79,  80,  81,   3,   3,   3,   3,
     82,   3,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,   3,   3,   3,  93,
     94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,
     96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,
     98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99,
    100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,
     95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,
     97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,
     99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,
     94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,
     96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,
     98,  99, 100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99,
    100,  94,  95,  96,  97,  98,  99, 100,  94,  95,  96,  97,  98,  99, 101, 102,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3, 103,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3, 104,   3,   3,   1,   3,   3,  80, 105,
      3,   3,   3,   3,   3,   3,   3, 106,   3,   3,   3, 107,   3, 108,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3, 109,   3,   3, 110,   3,   3,   3,   3,
      3,   3,   3,   3, 111,   3,   3,   3,   3,   3,   3,   3,   3, 112,   3,   3,
    113, 114, 115, 116, 117, 118, 119, 120, 121,   3,   3, 122,  34, 123,   3,   3,
    124, 125, 126, 127,   3,   3, 128, 129, 130, 131, 132,   3, 133,   3,   3,   3,
    134,   3,   3,   3,   3,   3,   3, 135, 136, 137, 138,   3,   3,   3,   3,   3,
    139,   3, 140,   3, 141, 142, 143,   3,   3,   3,   3, 144,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
    145,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3, 146, 147,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3, 148, 149,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3, 150,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3, 151, 152,   3,   3, 153,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3, 154, 155, 156,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
    157,   3,   3,   3, 147,   3,   3,   3,   3,   3,   3, 158,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3, 159,   3, 160,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3, 161,   3,   3,   3,   3,   3,   3,   3, 162,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
    163,   4, 164, 164,   4,   4,   4, 165, 164, 164, 164, 164, 164, 164, 164, 164,
    164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164,
    164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164,
    164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164,
};

static RE_UINT8 re_grapheme_cluster_break_stage_3[] = {
      0,   1,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,
      0,   0,   0,   0,   2,   4,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,
      6,   7,   2,   2,   2,   2,   2,   2,   2,   2,   8,   5,   5,   5,   5,   9,
     10,   2,   2,   2,   2,   2,   2,   2,  11,   2,   5,  12,   2,   2,   2,   2,
      2,   6,   5,   5,   2,   2,  13,   2,   2,   2,  14,  15,  16,  17,   2,   2,
      2,  18,  19,   2,   2,   2,   5,   5,   5,  20,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,  14,   5,  13,   2,   2,   2,   2,   2,   2,   6,  21,  22,
      2,   2,  14,  23,  24,  25,   2,   2,   2,   2,   2,  26,   2,   2,   2,   2,
      2,   2,   6,   5,  27,   5,   5,   5,  28,   2,   2,   2,   2,   2,   2,  29,
     30,  31,   8,   2,  32,   2,   2,   2,  33,   2,   2,   2,   2,   2,   2,  34,
     35,  36,  37,   2,  32,   2,   2,  38,  39,   2,   2,   2,   2,   2,   2,  40,
     41,  42,  19,   2,   2,   2,  43,   2,  44,  45,   2,   2,  32,   2,   2,  46,
     33,   2,   2,   2,   2,   2,   2,  47,  35,  36,  14,   2,  32,   2,   2,   2,
     48,   2,   2,   2,   2,   2,   2,  49,  50,  51,  37,   2,   2,   2,   2,   2,
     52,   2,   2,   2,   2,   2,   2,  14,  53,  17,  54,   2,  32,   2,   2,   2,
     33,   2,   2,   2,   2,   2,   2,  55,  56,  57,  54,   2,  32,   2,   2,   2,
     58,   2,   2,   2,   2,   2,   2,  59,  60,  61,  37,   2,  32,   2,   2,   2,
     62,   2,   2,   2,   2,   2,   2,   2,   2,  63,  64,  65,   2,   2,  62,   2,
      2,   2,   2,   2,   2,   2,  66,  20,  37,  67,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,  66,  68,   2,  69,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   7,   2,   2,  70,  71,   2,   2,   2,   2,   2,   2,   8,  72,
     73,  74,   5,   8,   5,   5,   5,  68,  38,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,  74,  75,  76,   2,   2,  77,  78,  13,   2,  79,   2,
     80,  22,   2,  22,   2,   2,   2,   2,  81,  81,  81,  81,  81,  81,  81,  81,
     81,  81,  81,  81,  82,  82,  82,  82,  82,  82,  82,  82,  82,  83,  83,  83,
     83,  83,  83,  83,  83,  83,  83,  83,   2,   2,   2,  74,   2,   2,   2,   2,
      2,   2,  84,   2,   2,   2,  84,   2,   2,   2,  32,   2,   2,   2,  32,   2,
      2,   2,   2,   2,   2,   2,  85,  86,  87,  30,  21,  22,   2,   2,   2,   2,
      2,  88,   2,   2,   2,   2,   2,   2,  54,   2,   2,   2,   2,  19,   2,   2,
      2,   2,   2,   2,  89,  90,  91,  92,   2,   2,  37,  93,   2,   2,   2,   2,
      2,   2,  94,  67,  95,  96,  97,  16,   2,   2,   2,   2,   2,   2,   5,  67,
     98,   2,   2,   2,   2,   2,  99, 100, 101,   2,   2,   2,   2,   6,  21,   2,
    102,   2,   2,   2, 103, 104,   2,   2,   2,   2,   2,   2,  49, 105,  58,   2,
      2,   2,   2,   2, 106, 107, 108,   2,   2,   2, 109,   5,  75, 110, 111,   7,
      5,   5,   5,   5,   5,   5,   5,  23,   2, 112,   2,   2,   2, 113,   2,   2,
      2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   5,   5,   5,   5,  13,   2,
      2,   2,   2,   2,   2,  37,   7,   2,   2,   2,   2,   2,   2,   2,   2,  37,
      2,   2,   2,   2,   5,   5,   5,   5,   2,   2,   2,   2,   2,  46,   2,   2,
      2,   2,   2, 114,   2,   2,   2,   2,   2,   2,   2,   2,   2,  37, 109,  69,
      2,   2,   2,  14,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   7,   2,
    115, 116,   2,   2, 117,   2,   2,   2, 118,   2,   2,   2,   2,   2, 106, 119,
    120,   2,   2,   2,   5,   5,   7,  37,   2,   2,   2,   2,  14,  69,   2,   2,
     37,   5,  58,   2,  81,  81,  81, 121,  28,   2,   2,   2,   2,   2, 122, 123,
    124,   2,   2,   2,  22,   2,   2,   2,   2,   2,   2,   2,   2, 125, 126,   2,
    116, 127,   2,   2,   2,   2,   2, 128,   2,   2,   2,   2,   2,   2, 129, 130,
     19,   2,   2,   2,   2, 131, 132,   2,   2,   2,   2,   2, 133, 134,   2,   2,
    135, 136, 136, 137, 136, 136, 136, 135, 136, 136, 137, 136, 136, 136, 135, 136,
    136, 137, 136, 136, 136, 135, 136, 136, 137, 136, 136, 136, 135, 136, 136, 137,
    136, 136, 136, 135, 136, 136, 137, 136, 136, 136, 135, 136, 136, 137, 136, 136,
    136, 135, 136, 136, 137, 136, 136, 136, 136, 135, 136, 136, 138,   2,  82,  82,
    139, 140,  83,  83,  83,  83,  83, 141,   2,   2,   2,  38,   2,   2,   2,   2,
      5,   5,   2,   2,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   0, 142,
      2,   2,   2,   2,   2,   2,   2,  22,   2,   2,   2,   2,  13,   2,   2,   2,
      2,   2,   2,   2,   2,   2,  14,  20, 143,  99,   2,   2,   2,   2,   2, 144,
      2,   2,   2,   2,  54,   2,   2,   2,   2,   2,   2,   2,  99,   2,   2,   2,
     14,   5,  13,   2,   2,   2,   2,   2, 145,   2,   2,   2,   2,   2,   2,   5,
     67,   2,   2,   2,   2,   2,   2,  37, 102,   2,   2,   2,   2,   2, 146, 147,
      2, 148,   2,   2,   2,   2,   2,   2,  20,   2,   2,   2,  37, 149,  68,   2,
    150,   2,   2,   2,   2,   2, 116,   2, 102,   2,   2,   2,   2,   2, 151,  72,
    152,  79,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, 153, 154,  38,
      2,   2,   2,  37,  97,  20,   2,   2, 155, 156,  37,   2, 157,  68,  68,   2,
      2,   2,   2,   2,   2,   2, 158,   5, 159,   2,   2,  38,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2, 160, 161, 162,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,  37, 163, 164,  13,   2,   2, 165,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,  97, 166,  13,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2, 167, 168,   2,   2,   2,   2,  74, 169,  21,   2,   2,
      2,   2,   2,   2,   2, 153,   5, 170,   2,   2, 171, 172, 173,   2,   2,   2,
      8,  20,   2,   2,   2,   2,   6, 174,  37,   2, 125,  92,   2,   2,   2,   2,
    175, 176,  72,   7,   2,   2,   2,   2,   2,   2,   2,   2,   2, 177,  67, 168,
      2,   2,  46,   5,   5, 178, 179,   2,   2,   2,   2,   2,   2,   2, 180, 181,
    182,   2,   2,   2,   2,   2,   2,   2,   2, 183, 184,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2, 185,   2,   2,   2,   2,   2,   2,   2,   0, 186,
      2,   2,   2,   2,   2,   2,  68,   2,   2,   2,   2,   2,   2,   2,  67,   2,
      2,  37, 187, 119, 119, 119, 119, 119, 119,  37,  20,   2,   2,   2,   2,   2,
      2,   2,   2,  54, 142,   2,   2,   2,   2,   2,   2,   2, 188, 189, 190, 191,
    192,  21,   2,   2,   2, 193,   2,   2,  84,   2,   2,   2,   2,   2,   2,   2,
      5,   5,   5,   5,   5,   5,  67,   6,   5,   5,   5,   5,   5,  68,  22,   2,
    128,   2,   2,   6,   8,   5,   2,   2,  67,   5,   5, 194, 195,  20,   2,   2,
      2,   2,   2,   2,   2,  99,   2,   2,   2,   2,  67,   2,   2,   2,   2,   2,
     99,  20,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, 196, 197, 197, 197,
      2,   2,   2,   2,   2,   2,   2,   6,   0,   0,   0,   0,   5,   5,   5,   5,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   0,   0,
};

static RE_UINT8 re_grapheme_cluster_break_stage_4[] = {
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  3,  4,  4,  2,  4,  4,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,
     0,  0,  0,  0,  0,  4,  0,  0,  5,  5,  5,  5,  5,  5,  5,  5,
     0,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,
     0,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,  5,
     0,  5,  5,  0,  5,  5,  0,  5,  1,  1,  1,  1,  1,  1,  0,  0,
     5,  5,  5,  0,  4,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  5,  5,  5,  5,  5,  5,  5,  1,  0,  5,
     5,  5,  5,  5,  5,  0,  0,  5,  5,  0,  5,  5,  5,  5,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  1,  0,  5,  0,  0,  0,  0,  0,  0,
     5,  5,  5,  0,  0,  0,  0,  0,  5,  5,  5,  5,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  5,  0,  0,  5,  5,  0,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  0,  5,  5,  5,  0,  5,  5,  5,  5,  5,  0,  0,
     0,  5,  5,  5,  0,  0,  0,  0,  5,  5,  1,  5,  5,  5,  5,  5,
     5,  5,  5,  7,  0,  0,  0,  0,  0,  0,  5,  7,  5,  0,  7,  7,
     7,  5,  5,  5,  5,  5,  5,  5,  5,  7,  7,  7,  7,  5,  7,  7,
     0,  0,  5,  5,  0,  0,  0,  0,  0,  5,  7,  7,  0,  0,  0,  0,
     0,  0,  0,  0,  5,  0,  5,  7,  7,  5,  5,  5,  5,  0,  0,  7,
     7,  0,  0,  7,  7,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,
     0,  0,  0,  0,  0,  0,  5,  0,  0,  5,  5,  7,  0,  0,  0,  0,
     0,  0,  0,  0,  5,  0,  7,  7,  7,  5,  5,  0,  0,  0,  0,  5,
     5,  0,  0,  5,  5,  5,  0,  0,  5,  5,  0,  0,  0,  5,  0,  0,
     7,  5,  5,  5,  5,  5,  0,  5,  5,  7,  0,  7,  7,  5,  0,  0,
     0,  0,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  5,  0,  5,  5,
     0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  7,
     5,  7,  7,  0,  0,  0,  7,  7,  7,  0,  7,  7,  7,  5,  0,  0,
     5,  7,  7,  7,  5,  0,  0,  0,  5,  7,  7,  7,  7,  0,  5,  5,
     0,  0,  0,  0,  0,  5,  5,  0,  0,  0,  0,  0,  5,  0,  7,  5,
     7,  7,  5,  7,  7,  0,  5,  7,  7,  0,  7,  7,  5,  5,  0,  0,
     5,  5,  7,  7,  0,  0,  0,  0,  0,  0,  0,  5,  5,  0,  5,  7,
     7,  5,  5,  5,  5,  0,  7,  7,  7,  0,  7,  7,  7,  5,  1,  0,
     0,  0,  7,  7,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  5,
     7,  7,  5,  5,  5,  0,  5,  0,  7,  7,  7,  7,  7,  7,  7,  5,
     0,  5,  0,  7,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  0,
     5,  5,  5,  5,  5,  0,  0,  0,  5,  5,  5,  5,  5,  5,  0,  0,
     0,  0,  0,  0,  0,  5,  0,  5,  0,  5,  0,  0,  0,  0,  7,  7,
     5,  5,  5,  5,  5,  5,  5,  7,  5,  5,  5,  5,  5,  0,  5,  5,
     0,  0,  0,  0,  0,  5,  5,  5,  5,  7,  5,  5,  5,  5,  5,  5,
     0,  5,  5,  7,  7,  5,  5,  0,  0,  0,  0,  0,  0,  0,  7,  7,
     5,  5,  0,  0,  0,  0,  5,  5,  0,  5,  5,  5,  5,  0,  0,  0,
     0,  0,  5,  0,  7,  5,  5,  0,  8,  8,  8,  8,  8,  8,  8,  8,
     9,  9,  9,  9,  9,  9,  9,  9, 10, 10, 10, 10, 10, 10, 10, 10,
     0,  0,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  5,  5,  7,  5,
     5,  5,  5,  5,  5,  5,  7,  7,  7,  7,  7,  7,  7,  7,  5,  7,
     0,  0,  0,  5,  5,  5,  4,  0,  5,  5,  5,  7,  7,  7,  7,  5,
     5,  7,  7,  7,  0,  0,  0,  0,  7,  7,  5,  7,  7,  7,  7,  7,
     7,  5,  5,  5,  0,  0,  0,  0,  5,  7,  7,  5,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  7,  5,  7,  5,  0,  5,  0,  0,  5,  5,  5,
     5,  5,  5,  5,  5,  7,  7,  7,  7,  7,  7,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  7,  0,  0,  0,  0,  0,  0,  0,  5,  5,  5,  5,
     5,  5,  5,  7,  5,  7,  7,  7,  7,  7,  5,  7,  7,  0,  0,  0,
     5,  5,  7,  0,  0,  0,  0,  0,  0,  7,  5,  5,  5,  5,  7,  7,
     5,  5,  7,  5,  5,  5,  0,  0,  5,  5,  7,  7,  7,  5,  7,  5,
     0,  0,  0,  0,  7,  7,  7,  7,  7,  7,  7,  7,  5,  5,  5,  5,
     5,  5,  5,  5,  7,  7,  5,  5,  5,  5,  5,  0,  5,  5,  5,  5,
     5,  0,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  5,  0,  0,  7,
     0,  0,  0,  4,  5, 13,  4,  4,  4,  4,  4,  4,  4,  4,  4,  0,
     0,  5,  5,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  5,  0,
     0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  7,  7,  5,  5,  7,
     7,  7,  0,  0,  0,  0,  0,  0,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  5,  5,  0,  0,  8,  8,  8,  8,  8,  0,  0,  0,
     0,  0,  0,  5,  7,  7,  5,  5,  5,  5,  7,  7,  5,  5,  7,  7,
     7,  0,  0,  0,  0,  0,  0,  0,  0,  5,  5,  5,  5,  5,  5,  7,
     7,  5,  5,  7,  7,  5,  5,  0,  0,  0,  0,  0,  5,  7,  0,  0,
     0,  0,  0,  0,  5,  0,  0,  0,  5,  0,  5,  5,  5,  0,  0,  5,
     5,  0,  0,  0,  0,  0,  5,  5,  0,  0,  0,  7,  5,  5,  7,  7,
     0,  0,  0,  0,  0,  7,  5,  0,  0,  0,  0,  7,  7,  5,  7,  7,
     5,  7,  7,  0,  7,  5,  0,  0, 11, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 12, 12, 12,
    12, 12, 12, 12,  0,  0,  0,  0,  9,  9,  9,  9,  9,  9,  9,  0,
     0,  0,  0, 10, 10, 10, 10, 10, 10, 10, 10, 10,  0,  0,  0,  0,
     4,  4,  4,  4,  0,  0,  0,  0,  0,  5,  5,  5,  0,  5,  5,  0,
     5,  5,  5,  0,  0,  0,  0,  5,  7,  5,  7,  0,  0,  0,  0,  0,
     7,  7,  7,  5,  5,  5,  5,  7,  7,  5,  5,  0,  0,  1,  0,  0,
     0,  0,  0,  0,  0,  1,  0,  0,  5,  5,  5,  5,  7,  5,  5,  5,
     0,  0,  0,  0,  0,  7,  7,  0,  0,  0,  0,  7,  7,  7,  5,  5,
     7,  0,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  7,  7,  7,  5,
     5,  5,  7,  7,  5,  7,  5,  5,  5,  7,  7,  7,  7,  0,  0,  7,
     7,  0,  0,  7,  7,  7,  0,  0,  0,  0,  7,  7,  0,  0,  5,  5,
     0,  0,  0,  0,  0,  7,  7,  7,  7,  7,  5,  5,  5,  7,  5,  0,
     5,  7,  7,  5,  5,  5,  5,  5,  5,  7,  5,  7,  7,  5,  7,  5,
     5,  7,  5,  5,  0,  0,  0,  0,  7,  7,  5,  5,  5,  5,  0,  0,
     7,  7,  7,  7,  5,  5,  7,  5,  0,  0,  0,  0,  5,  5,  0,  0,
     5,  5,  5,  7,  7,  5,  7,  5,  0,  0,  0,  5,  7,  5,  7,  7,
     5,  5,  5,  5,  5,  5,  7,  5,  7,  7,  5,  5,  5,  5,  7,  5,
     7,  5,  5,  0,  0,  0,  0,  0,  0,  7,  7,  7,  5,  5,  5,  5,
     0,  0,  5,  5,  7,  7,  7,  7,  5,  0,  0,  0,  7,  0,  0,  0,
     5,  7,  1,  5,  5,  5,  5,  0,  0,  0,  0,  0,  1,  1,  1,  1,
     1,  1,  5,  5,  5,  5,  5,  5,  0,  0,  0,  0,  0,  0,  0,  7,
     0,  7,  5,  5,  5,  5,  5,  5,  5,  7,  5,  5,  7,  5,  5,  0,
     0,  5,  5,  5,  5,  5,  5,  0,  0,  0,  5,  0,  5,  5,  0,  5,
     5,  5,  5,  5,  5,  5,  1,  5,  0,  0,  7,  7,  7,  7,  7,  0,
     5,  5,  0,  7,  7,  5,  7,  5,  0,  0,  0,  5,  5,  7,  7,  0,
     4,  0,  0,  0,  0,  0,  0,  0,  0,  7,  7,  7,  7,  7,  7,  7,
     0,  0,  0,  0,  0,  5,  7,  5,  5,  5,  0,  0,  0,  7,  5,  5,
     5,  5,  5,  4,  4,  4,  4,  4,  4,  4,  4,  5,  5,  5,  5,  5,
     5,  5,  5,  0,  0,  5,  5,  5,  0,  0,  5,  5,  5,  5,  0,  0,
     5,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0,  5,  5,  0,  5,  5,
     0,  0,  0,  0,  0,  0,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
};

/* Grapheme_Cluster_Break: 4400 bytes. */

RE_UINT32 re_get_grapheme_cluster_break(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_grapheme_cluster_break_stage_1[f] << 6;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_grapheme_cluster_break_stage_2[pos + f] << 3;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_grapheme_cluster_break_stage_3[pos + f] << 3;
    value = re_grapheme_cluster_break_stage_4[pos + code];

    return value;
}

/* Sentence_Break. */

static RE_UINT8 re_sentence_break_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  7,  8,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  9, 10, 11,  7,  7,  7,  7, 12, 13, 13, 13, 13, 14,
    15, 16, 17, 18, 19, 13, 20, 13, 21, 13, 13, 13, 13, 22,  7,  7,
    23, 24, 13, 13, 13, 13, 25, 26, 13, 13, 27, 28, 29, 30, 31, 13,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 32,  7, 33, 34,  7, 35,  7,  7,  7, 36, 13, 37,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    38, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
};

static RE_UINT8 re_sentence_break_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
     32,  33,  34,  34,  35,  36,  37,  38,  39,  34,  34,  34,  40,  41,  42,  43,
     44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
     60,  61,  62,  63,  64,  64,  65,  64,  64,  66,  64,  64,  64,  64,  67,  68,
     64,  64,  64,  69,  64,  64,  64,  64,  70,  71,  72,  73,  74,  64,  64,  64,
     75,  76,  77,  78,  64,  64,  64,  64,  34,  34,  34,  34,  34,  34,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  79,  34,  34,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  80,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  81,  34,  34,  82,  83,  84,  85,
     86,  87,  88,  89,  90,  91,  92,  93,  34,  34,  34,  34,  34,  34,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  94,
     64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
     64,  64,  34,  34,  95,  96,  97,  98,  34,  34,  99, 100, 101, 102, 103, 104,
    105, 106, 107, 108,  64, 109, 110, 111, 112, 113, 114,  64,  34,  34, 115,  64,
    116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126,  64,  64,  64, 127, 128,
    129, 130, 131, 132, 133, 134, 135,  64, 136, 137,  64, 138, 139, 140, 141,  64,
    142, 143,  64, 144, 145, 146,  64,  64, 147, 148, 149, 150,  64, 151,  64,  64,
     34,  34,  34,  34,  34,  34,  34, 152, 153,  34, 154,  64,  64,  64,  64,  64,
     34,  34,  34,  34,  34,  34,  34,  34, 155,  64,  64,  64,  64,  64,  64,  64,
     64,  64,  64,  64,  64,  64,  64,  64,  34,  34,  34,  34, 156,  64,  64,  64,
     34,  34,  34,  34, 157, 158, 159, 160,  64,  64,  64,  64, 161, 162, 163, 164,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34, 165,
     34,  34,  34,  34,  34, 166,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
     34,  34, 167,  34,  34, 168,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
     64,  64,  64,  64,  64,  64,  64,  64, 169, 170,  64,  64,  64,  64,  64,  64,
     64,  64, 171, 172, 173,  64,  64,  64, 174, 175, 176, 177, 178, 179, 180, 181,
     64,  64,  64,  64, 182, 183,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    184,  64, 185,  64,  64, 186,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
     34, 187, 188,  64,  64,  64,  64,  64,  64,  64,  64,  64, 189, 190,  64,  64,
     64,  64, 191, 192,  64,  64,  64,  64,  64,  64,  64,  64, 193,  64,  64,  64,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34, 194,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34, 195,  34,
    196,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,
     34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34, 197,  34,  34,
     34,  34,  34,  34,  34,  34,  34, 198,  64,  64,  64,  64,  64,  64,  64,  64,
     34,  34,  34,  34, 199,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
    200,  64, 201, 202,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,  64,
};

static RE_UINT8 re_sentence_break_stage_3[] = {
      0,   0,   1,   2,   0,   0,   0,   0,   3,   4,   5,   6,   7,   7,   8,   9,
     10,  11,  11,  11,  11,  11,  12,  13,  14,  15,  15,  15,  15,  15,  16,  13,
      0,  17,   0,   0,   0,   0,   0,   0,  18,   0,  19,  20,   0,  21,  19,   0,
     11,  11,  11,  11,  11,  22,  11,  23,  15,  15,  15,  15,  15,  24,  15,  15,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  26,  26,
     26,  26,  27,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  28,  29,
     30,  31,  32,  33,  28,  31,  34,  28,  25,  31,  29,  31,  32,  26,  35,  34,
     36,  28,  31,  26,  26,  26,  26,  27,  25,  25,  25,  25,  30,  31,  25,  25,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  15,  33,  30,
     26,  23,  25,  25,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
     15,  15,  15,  15,  15,  37,  15,  15,  15,  15,  15,  15,  15,  15,  38,  36,
     39,  40,  36,  36,  41,   0,   0,   0,  15,  42,   0,  43,   0,   0,   0,   0,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  25,  45,  46,  47,
      0,  48,  22,  49,  32,  11,  11,  11,  50,  11,  11,  15,  15,  15,  15,  15,
     15,  15,  15,  51,  33,  34,  25,  25,  25,  25,  25,  25,  15,  52,  30,  32,
     11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  15,  15,  15,  15,
     15,  15,  15,  15,  15,  15,  15,  15,  25,  25,  25,  25,  25,  25,  25,  25,
     53,  44,  54,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,
     28,  26,  26,  29,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  10,  11,  11,  11,
     11,  11,  11,  11,  11,  22,  55,  56,  15,  15,  15,  15,  15,  15,  15,  15,
     15,  15,  57,   0,  58,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  59,
     60,  59,   0,   0,  36,  36,  36,  36,  36,  36,  61,  62,  36,   0,   0,   0,
     63,  64,   0,  65,  44,  44,  66,  67,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  68,  44,  44,  44,  44,  44,   7,   7,  69,  70,  71,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  72,  44,  73,  44,  74,  75,  76,   7,   7,  77,  78,
     79,   0,   0,  80,  81,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,  44,
     44,  44,  66,  82,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  83,  44,  44,  84,   0,   0,   0,
      7,   7,  77,  36,  36,  36,  36,  36,  36,  36,  68,  44,  44,  41,  85,  86,
     36,  36,  36,  36,  36,  83,  87,  44,  44,  88,  88,  89,   0,   9,  90,  91,
     36,  36,  36,  36,  36,  36,  88,   0,  36,  36,  61,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  36,  36,  36,  36,  36,  92,  36,  41,
      0,   0,   0,   0,  93,  44,  44,  44,  94,  44,  44,  44,  44,  44,  44,  44,
     44,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  83,  95,
     44,  44,  44,  44,  88,  44,  36,  36,  83,  96,   7,   7,  82,  36,  36,  36,
     88,  82,  36,  78,  78,  36,  36,  36,  36,  36,  92,  36,  43,  40,  41,  95,
     44,  97,  97,  98,   0,  93,   0,  99,  83, 100,   7,   7,  41,   0,   0, 101,
     58,  82,  61,  62,  78,  36,  36,  36,  36,  36,  92,  36,  92, 102,  41,  75,
     66,  93,  97,  89,  86,   0,  82,  43,   0, 100,   7,   7,  76, 103,   0,   0,
     58,  82,  36,  99,  99,  36,  36,  36,  36,  36,  92,  36,  92,  82,  41,  95,
     44,  59,  59,  89, 104,   0,   0,   0,  83, 100,   7,   7,   0,   0, 105,  44,
     58,  82,  36,  78,  78,  36,  36,  36,  36,  36,  92,  36,  92,  82,  41,  95,
     44,  97,  97,  89,   0, 106,   0,  99,  83, 100,   7,   7,  55,   0,   0,   0,
    107,  82,  61,  40,  92,  41, 102,  92,  62, 104,  61,  40,  36,  36,  41, 106,
     66, 106,  75,  89, 104,  93,   0,   0,   0, 100,   7,   7,   0,   0,   0,   0,
     44,  71,  36,  92,  92,  36,  36,  36,  36,  36,  92,  36,  36,  36,  41, 105,
     44,  75,  75,  89,   0,  60,  61,   0,  83, 100,   7,   7,   0,   0,   0,   0,
     88,  82,  36,  92,  92,  36,  36,  36,  36,  36,  92,  36,  36,  82,  41,  95,
     44,  75,  75,  89,   0,  60,   0, 108,  83, 100,   7,   7, 102,   0,   0,   0,
     44,  82,  36,  92,  92,  36,  36,  36,  36,  36,  36,  36,  36,  36,  68,  95,
     44,  75,  75,  98,   0,  68,   0,  62,  83, 100,   7,   7,   0,   0,  40,  36,
    106,  82,  36,  36,  36,  61,  40,  36,  36,  36,  36,  36,  99,  36,  36,  55,
     36,  61, 109,  93,  44, 110,  44,  44,   0, 100,   7,   7, 106,   0,   0,   0,
     82,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  81,  44,  66,   0,
     36,  68,  44,  66,   7,   7, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    102,  92,  61,  36,  36,  36,  36,  36,  36, 112,  36,  36,  81,  44,  44,  84,
     36,  43,  44,  89,   7,   7, 111,  36,   0,   0,   0,   0,   0,   0,   0,   0,
    104,   0,   0,   0,   0,   0,  89,   0,   7,   7, 111,   0,   0, 113, 114, 115,
     36,  36,  82,  36,  36,  36,  36,  36,  36,  36,  36, 104,  58,  44,  44,  44,
     44,  75,  36,  88,  44,  44,  58,  44,  44,  44,  44,  44,  44,  44,  44, 116,
      0, 109,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  44,  44,  44, 117,
      7,   7, 118,   0,  36,  83,  76,  83,  95,  74,  44,  76,  88,  71,  36,  36,
     83,  44,  44,  87,   7,   7, 119,  89,  11,  11,  11,  11,  11,  11,  11,  11,
     11,  50,   0, 120,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  92,  41,  36,  61,  92,  41,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  92,  41,  36,  36,  36,  36,  36,  36,  36,  36,  92,  41,  36,  61,
     92,  41,  36,  36,  36,  61,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  92,  41,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  61,  58, 121,   9, 122,   0,   0,   0,   0,   0,
     36,  36,  36,  36,   0,   0,   0,   0,  11,  11,  11,  11,  11,  11,  11,  11,
     11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11, 123,  15,  39,
     82,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 124,  36,  36,  36,  36,
    125,  36,  36,  36,  36,  36, 126, 127,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,  40,  36,  36, 104,   0,
     36,  36,  36,  92,  83, 116,   0,   0,  36,  36,  36,  36,  83, 128,   0,   0,
     36,  36,  36,  36,  83,   0,   0,   0,  36,  36,  36,  92, 129,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,
     44,  44,  44,  44,  44,  62,   0, 103,   7,   7, 111,   0,   0,   0,   0,   0,
    130,   0, 131, 132,   7,   7, 111,   0,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 104,   0,
     36, 133,  36,  36,  36,  36,  36,  36,  36,  36, 134,   0,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  41,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  61,  44,  44,  44,   0,  44,  44,  44,   0,
      0,  96,   7,   7,  36,  36,  36,  36,  36,  36,  36,  41,  36, 104,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,  36,  36,  36,  36,
     36,  36,  41,   0,   7,   7, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  68,  44,   0,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  88,  44,  66,  44,  44,  44,  44,  44,  44,  44,  97,
      7,   7, 111,   0,   7,   7, 111,   0,   0,  62, 135,   0,  44,  44,  44,  66,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     44,  71,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,
     44,  71,  36,   0,   7,   7, 118, 136,   0,   0,  93,  44,  44,   0,   0,   0,
    117,  36,  36,  36,  36,  36,  36,  36,  88,  44,  44,  76,   7,   7,  77,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  83,  44,  44,  44,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,  44,  44,   9, 122,
      7,   7, 111,  82,   7,   7,  77,  36,  36,  36,  36,  36,  36,  36,  36, 137,
     15,  15,  42,   0,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,  82,
      0,   0,   0,   0,  66,  44,  44,  44,  44,  44,  71,  81,  36,  74,  98,   0,
     15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
     15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
     15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  59,  44,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,
     25,  25,  25,  25,  25,  34,  15,  27,  25,  25,  25,  25,  25,  25,  25,  25,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,
     15,  15,  11,  11,  15,  39,  11, 123,  15,  15,  11,  11,  15,  15,  11,  11,
     15,  39,  11, 123,  15,  15, 138, 138,  15,  15,  11,  11,  15,  15,  15,  39,
     15,  15,  11,  11,  15,  15,  11,  11,  15,  15,  11,  11,  15, 139,  11, 140,
     46, 139,  11, 141,  15,  46,  11,   0,  15,  15,  11, 141,  46, 139,  11, 141,
    142, 142, 143, 144, 145, 146, 147, 147,   0, 148, 149, 150,   0,   0, 151, 152,
      0, 153, 152,   0,   0,   0,   0, 154,  63, 155,  63,  63,  21,   0,   0, 156,
      0,   0,   0, 151,  15,  15,  15,  42,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  44,  44,  44,  44,  44,  44,  44,  44, 116,   0,   0,   0,
     48, 157, 158, 159,  23, 120,  10, 123,   0, 160,  49, 161,  11,  38, 162,  33,
      0, 163,  39, 164,   0,   0,   0,   0,  11,  11,  11,  11,  15,  15,  15,  15,
    165,  38, 104,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0, 147,   0,   0,   0,   0,   0,   0,   0, 151,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 166,  11,  11,
     11,  11,  11,  11,  15,  15,  15,  15,  15,  15,  39,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   4, 147, 127,   0, 147, 147, 147,   5,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0, 151,   0,   0,   0,   0,   0,   0,   0, 167, 147, 147,   0,   0,   0,   0,
      4, 147, 147, 147, 147, 147, 127,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 147,   0,   0,   0,   0,   0,   0,   0,   0,   5,
     11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  22,  15,  15,  15,  15,
     15,  15,  15,  15,  15,  15,  15,  24,  31, 168,  26,  32,  25,  29,  15,  33,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  42, 157, 169,  54,   0,   0,   0,
     15,  15,  15,  15,  15,  15,  15,  15,  15, 170,   0,  21,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,  62,   0,   0,   0,  93,
     36,  36,  36,  36,  36,  61,   0,   0,  36,  61,  36,  61,  36,  61,  36,  61,
     36,  61,  36,  61,  36,  61,  36,  61,  44,  44,  44,  44,  44,  44,  44,  44,
    147, 147, 147,   5,   0,   0,   0,   5, 147, 147,   5, 171,   0,   0,   0, 122,
    172,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    173,  82, 147, 147,   5, 147, 147, 174,  82,  36,  83,  44,  82,  41,  36, 104,
     82,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  61,  60,  82,  82,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,  36,
      0,  82,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  82,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  61,   0,   0,   0,   0,  36,  36,  36,  36,  36,  36,  61,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  41,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,   0,   0,   0,
     36,  36,  36, 104,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 175,
     36,  36,  36, 176,  36,  36,  36,  36,   7,   7,  77,   0,   0,   0,   0,   0,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25, 177,  66,  44,  44, 178,
     25,  25,  25,  25,  25,  25,  25, 179,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 180,   9,   0,   0,
      0,   0,   0,   0,   0,  62,  36,  36, 181,  25,  25,  25,  27,  25,  25,  25,
     25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  15,  15,  26,  30,
     25,  25, 182, 183,  25,  27,  25,  25,  25,  25,  31,  23,  11,  25,  25,  25,
    181,  22,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  62, 184,  36,
    185, 185,  68,  36,  36,  36,  36,  36,  68,  44,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 136,   0,   0,
     76,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,
     44,  89,   0, 136,   7,   7, 111,   0,  44,  44,  44,  44,  76,  36,  62, 186,
      7,   7,  77,  36,  36,  36,  36,  36,  36,  83,  44, 180,  36,  36,  36,  36,
     36,  68,  44,  44,  44,   0,   0,   0,  36,  36,  36,  36,  36,  36,  36, 104,
     44,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  44,  44,
    116,   0, 152,  62,   7,   7, 111,   0,  36,  81,  36,  36,   7,   7,  77,  61,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  88,  44,  44,  66,   0,   0,
     68,  36,  36,  89,   7,   7, 111, 187,  36,  36,  36,  36,  36,  61, 188,  76,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  95,  74,  71,  83,
    134,   0,   0,   0,   0,   0,  62,  41,  36,  36,  68,  44, 189, 190,   0,   0,
     82,  61,  82,  61,  82,  61,   0,   0,  36,  61,  36,  61,  15,  15,  15,  15,
     15,  15,  15,  15,  15,  15,  24,  15,  15,  15,   0,   0,  15,  15,  15,  15,
     15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
     36,  36,  36,  36,  36,  36,  36,  36,  68,  44, 191,  89,   7,   7, 111,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,   0,   0,   0,  36,  36,  36,  36,
     36,  61,  62,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  41,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  41,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     15,  24,   0,   0, 192,  15,   0, 193,  36,  36,  92,  36,  36,  61,  36,  43,
     99,  92,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  41,   0,   0,   0,
      0,   0,   0,   0,  62,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 194,
      0,   0,   0,   0,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  40,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36,  36,  36,   0,
     44,  44,  44,  44, 195,   4, 127,   0,  44,  44,  44,  44, 196, 174, 147, 147,
    147, 197, 127,   0,   6, 198, 199, 200, 145,   0,   0,   0,  36,  92,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 201,
     90,   0,   5,   6,   7,   7,   8,   9,  10,  11,  11,  11,  11,  11,  12,  13,
     14,  15,  15,  15,  15,  15,  16, 202, 203, 204,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  83,  36,  36,  36,  36,  36,  36,  36,  61,
     40,  36,  40,  36,  40,  36,  40, 104,   0,   0,   0,   0,   0,   0, 205,   0,
     36,  36,  36,  82,  36,  36,  36,  36,  36,  61,  36,  36,  36,  36,  61,  99,
     36,  36,  36,  41,  36,  36,  36,  41,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 104,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  86,
     36,  36,  36,  36,  36,  36,  36, 104,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36, 104,   0,   0,   0, 116,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,   0,   0,   0,  82,  36,  36,  36,  36,
     36,  36,  61,   0,  36,  36,  36,  36,  36,  36,  36,  36,  36,  83,  66,   0,
     36,  36,  36,  36,  36,  36,  36,  41,  36,  36,  36,  36,  36,  36,  36,  36,
     36,   0,  36,  36,  82,  41,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  15,  15,  15,  15,  15,  15,
     15,  15,  15,  15,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  41,   7,   7, 111,   0,  11,  11,  11,  11,
     11,  11,  11,  11,  11,   0,  15,  15,  15,  15,  15,  15,  15,  15,  15,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,   0,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,   0,   0,
     36,  36,  36,  36,  36,  41,   0,   0,  36,  36,   0,   0,   0,   0,   0,   0,
     36,  41,  92,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  99, 104,  78,
     36,  36,  36,  36,  36,  41,   0,   0,  36,  36,  36,  36,  36,  61,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  61,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  36,  36,  36,  36,  61,  41,   0,   0,
     36,  36,  36,  36,  36,  41,   0,   0,  36,  36,  36,  36,  36,  36,  41,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,  40,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     88,  60,   0,  44,  36,  82,  82,  36,  36,  36,  36,  36,  36,  41,  66,  93,
      0,   0,   0,   0,   0, 136,   0,   0,  36,  36,  36,  36,  36,  36,  36, 104,
     36,  36,  36,  36,  36,  36,  36, 104,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  82,  36,  36,  36,  36,  36,  36, 190,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  41,   0,   0,
     36,  36,  36,  36,  36,  41,   0,   0,  36,  36,  36,  36,  61,   0,   0,   0,
     36,  36,  36,  36,  41,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36, 104,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  22,   0,   0,   0,
     15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  24,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  44,   0,   0,   7,   7, 111,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36, 104,   0,  62,   0,   0,  36,  36,  36,  36,
     36,  83,  44,  44, 116, 187, 152,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  36,  36,  36,  36,  36,  61,   0,   0,
    117,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,
     44, 191, 122,   0,   0,   0,   0,   0,   0, 100,   7,   7,   0,   0,   0,  93,
    117,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  66, 206,
    152,   0,   0,  20,  36,  36,  36,  36,  36,  36, 104,   0,   7,   7, 111,   0,
    117,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  44,  44, 207,   7,   7,
    187, 190,   0,   0,  36,  36,  36,  36,  36,  36,  36,  36,  68, 108,   0,   0,
    117,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  44,  44,
     71, 208,  58, 209,   7,   7, 210, 176,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  99,  36,  36,  36,  36,  36,  36,  44,  44,  44, 211, 212,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  61,  92,  99,  36,  36,  36,  99,  36,  36, 213,   0,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  68,  44,  44,  66,   0,   7,   7, 111,   0,
     44,  82,  36,  78,  78,  36,  36,  36,  36,  36,  92,  36,  92,  82, 214,  95,
     44,  97,  97,  89, 104,  93,   0,  82,  83, 106,  44, 116,  44, 116,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  88,  44,  44,
     44, 117, 215, 122,   7,   7, 111, 107,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,  44,
     44,  99,   0,   0,   7,   7, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  89,  44,  44,
    216,   0, 187, 135, 135, 135,  36,  89,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,  44,
    128, 104,   0,   0,   7,   7, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  44,  44, 104,   0,
      7,   7, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  61,  58,  44,  44,  44,   0,   7,   7, 111,  79,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,  44,  44,  66,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  11,  11,  11,  11,  11,  11,  11,  11,
     15,  15,  15,  15,  15,  15,  15,  15,   7,   7, 111,   0,   0,   0,   0,  62,
      0,   0,   0,   0,   0,   0,   0,   0,  36,  36,  40,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  88,  44, 106,  44, 217, 116,   0,   0,   0,   0,   0,   0,
     88,  44, 117,  36,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  87,  66,
    136,  93,   0,   0,  88,  44,  44,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  83,  44,  44,  44, 180, 218,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 104,   0,
     36,  36,  92,  36,  36,  36,  36,  36,  36,  36,  36,  68,  44,  66,  44,  44,
    208,   0,   0,   0,   7,   7, 111,   0,   0,   0,   0,   0,  40,  36,  36,  36,
     36,  36,  36,  36, 106,  44,  44,  44,  44,  44,  58,  44,  44,  66,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  61,  99,  36,  36,  36,  36,  36,  36,  36,  36,  36,  88,  66, 109,  59,
     44,  87,   0,   0,   7,   7, 111,   0,  36,  99,  92,  36,  36,  36,  36,  36,
     36,  36,  83,  66,  59,  44, 104,   0,   7,   7, 111,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  36,  36,  36,  36,  68, 191, 122,   0,
     36,  36,  36,  36,  36,  36,  41,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,  63,  63, 219,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  61,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 104,   0,
     36,  36,  36,  36,  36,  36,  36,  61,   7,   7, 111, 136,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  36,  36,  36,  36,  36,  36,  36,  41,  44, 209,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44, 191, 122,   0,
     36, 122,   0,   0,   7,   7, 111,   0,  62,  36,  36,  36,  36,  36,   0,  82,
     36,  36,  36,  36,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     11,  11,  11,  11,  11,  11,  11,  11,  15,  15,  15,  15,  15,  15,  15,  15,
      0,   0,   0,   0,   0,   0, 122,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  61,  93,  88,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,   0,  93, 117,  36,  36,  36,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  99,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  61,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  61,   0,   0,   0,   0,  36,   0,   0,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  61,   0,  36,  36,  36, 104,
     36,  36, 104,   0,  36,  36,  41, 220,  63,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  58,  89,  58, 221,  63, 222,  44,
     66,  58,  44,   0,   0,   0,   0,   0,   0,   0, 106,  89,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    106, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     11,  11,  11,  11,  11,  11, 159,  15,  15,  15,  15,  15,  15,  11,  11,  11,
     11,  11,  11, 159,  15, 139,  15,  15,  15,  15,  11,  11,  11,  11,  11,  11,
    159,  15,  15,  15,  15,  15,  15,  49,  48, 223,  10,  49,  11, 159, 170,  14,
     15,  14,  15,  15,  11,  11,  11,  11,  11,  11, 159,  15,  15,  15,  15,  15,
     15,  50,  22,  10,  11,  49,  11, 224,  15,  15,  15,  15,  15,  15,  50,  22,
     11, 160, 166,  11, 224,  15,  15,  15,  15,  15,  15,  11,  11,  11,  11,  11,
     11, 159,  15,  15,  15,  15,  15,  15,  11,  11,  11,  11,  11,  11, 159,  15,
     15,  15,  15,  15,  15,  11,  11,  11,  11,  11,  11, 159,  15,  15,  15,  15,
     15,  15,  11,  11,  11,  11,  11,  11, 159,  15,  15,  15,  15,  15,  15,  11,
     11,  11,  11,  11,  11, 159,  15,  15,  15,  15,  15,  15,  11,  11,  11,  11,
     11,  11, 159,  15,  15,  15,  15,  15,  15,  39,  11,  11,  11,  11,  11,  11,
    224,  15,  15,  15,  15,  15,  24,  15,  33,  11,  11,  11,  11,  11,  22,  15,
     15,  15,  15,  15,  15, 139,  15,  11,  11,  11,  11,  11,  11, 224,  15,  15,
     15,  15,  15,  24,  15,  33,  11,  11,  11,  11,  11,  22,  15,  15,  15,  15,
     15,  15, 139,  15,  11,  11,  11,  11,  11,  11, 224,  15,  15,  15,  15,  15,
     24,  15,  27, 100,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  66,  93,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44, 116,   0,  86,   0,   0,
      0, 116, 122,   0,   0,   0,  93,  44,  58,  44,  44,  44,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     44,  66,  44,  44,  44,  44,  97,  44,  59,  75,  66,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 104,  44, 117,  36,  41,
      7,   7, 111, 108,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  44,   7,   7, 111,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36, 104,   0,   0,  44,  66,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     11,  11,  11,  11,  11,  11,  11,  11, 159,  15,  15,  15,  15,  15,  15,  15,
     15,  44, 117,   0,   7,   7, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  82,  36,  36,  36,  36,  36,  36, 102,  78,  82,  36,  61,  36, 112,   0,
    108,  62, 112,  82, 102,  78, 112, 112, 102,  78,  61,  36,  61,  36,  82,  43,
     36,  36,  99,  36,  36,  36,  36,   0,  82,  82,  99,  36,  36,  36,  36,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  11,  11,  11,  11,
     11,  11, 123,   0,  11,  11,  11,  11,  11,  11, 123,   0,  11,  11,  11,  11,
     11,  11, 123,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 167, 127,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  61,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 104,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  41,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  41,   0,   0,   0,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  36,  36,  36,  36, 104,   0,   0,   0,   0,   0,   0,   0,
     36,  36,  36,  36,  36,  36,  36,  41,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     20,   0,   0,   0,   0,   0,   0,   0,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,
     44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,  44,   0,   0,   0,   0,
};

static RE_UINT8 re_sentence_break_stage_4[] = {
     0,  0,  0,  0,  0,  6,  2,  6,  6,  1,  0,  0,  6, 12, 13,  0,
     0,  0,  0, 13, 13, 13,  0,  0, 14, 14, 11,  0, 10, 10, 10, 10,
    10, 10, 14,  0,  0,  0,  0, 12,  0,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8, 13,  0, 13,  0,  0,  0,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7, 13,  0,  4,  0,  0,  6,  0,  0,  0,  0,  0,  7, 13,
     0,  5,  0,  0,  0,  7,  0,  0,  8,  8,  8,  0,  8,  8,  8,  7,
     7,  7,  7,  0,  8,  7,  8,  7,  7,  8,  7,  8,  7,  7,  8,  7,
     8,  8,  7,  8,  7,  8,  7,  7,  7,  8,  8,  7,  8,  7,  8,  8,
     7,  8,  8,  8,  7,  7,  8,  8,  8,  7,  7,  7,  8,  7,  7,  9,
     9,  9,  9,  9,  9,  7,  7,  7,  7,  9,  9,  9,  7,  7,  0,  0,
     0,  0,  9,  9,  9,  9,  0,  0,  7,  0,  0,  0,  9,  0,  9,  0,
     3,  3,  3,  3,  9,  0,  8,  7,  0,  0,  7,  7,  7,  7,  0,  8,
     0,  0,  8,  0,  8,  0,  8,  8,  8,  8,  0,  8,  7,  7,  7,  8,
     8,  7,  0,  8,  8,  7,  0,  3,  3,  3,  8,  7,  0,  9,  0,  0,
     0, 14,  0,  0,  7, 12,  0,  0,  0,  3,  3,  3,  3,  3,  0,  3,
     0,  3,  3,  0,  9,  9,  9,  0,  0,  0,  0,  9,  5,  5,  5,  5,
     5,  5,  0,  0, 14, 14,  0,  0,  3,  3,  3,  0,  5,  0, 12, 12,
     9,  9,  9,  3, 10, 10,  0, 10, 10,  0,  9,  9,  3,  9,  9,  9,
    12,  9,  3,  3,  3,  5,  0,  3,  3,  9,  9,  3,  3,  0,  3,  3,
     3,  3,  9,  9, 10, 10,  9,  9,  9,  0,  0,  9, 12, 12, 12,  0,
     0,  0,  0,  5,  9,  3,  9,  9,  0,  9,  9,  9,  9,  9,  3,  3,
     3,  9,  0,  0, 14, 12,  9,  0,  0,  3,  0,  0,  3,  3,  9,  3,
     9,  3,  3,  3,  3,  3,  0,  0,  0, 12,  0,  0,  0, 12, 12,  0,
     9,  0,  9,  9,  0,  0,  0,  3,  3,  3,  5,  3,  3,  9,  3,  3,
    12, 12, 10, 10,  3,  0,  0,  3,  3,  3,  9,  0,  9,  9,  0,  9,
     0,  0, 10, 10,  9,  0,  3,  0,  0,  9,  9,  0,  9,  3,  0,  0,
     9,  0,  0,  0,  0,  9,  3,  3,  0,  0,  3,  3,  0,  0,  3,  9,
     0,  0,  9,  0,  0,  0,  3,  0,  3,  0,  3,  0, 10, 10,  0,  0,
     0,  9,  0,  9,  0,  3,  0,  3,  0,  3, 13, 13, 13, 13,  3,  3,
     3,  0,  0,  0,  3,  3,  3,  9, 10, 10, 12, 12, 10, 10,  3,  3,
     0,  8,  0,  0,  0,  0, 12,  0, 12,  0,  0,  0,  8,  8,  0,  0,
     9,  0, 12,  9,  6,  9,  9,  9,  9,  9,  9, 13, 13,  0,  0,  0,
     3, 12, 12,  0,  9,  0,  3,  3,  0,  0, 14, 12, 14, 12,  0,  3,
     3,  3,  5,  0,  9,  3,  3,  9,  9,  3,  9,  0, 12, 12, 12, 12,
     0,  0, 12, 12,  9,  9, 12, 12,  0,  8,  0,  8,  7,  0,  7,  7,
     8,  0,  7,  0,  8,  0,  0,  0,  6,  6,  6,  6,  6,  6,  6,  5,
     3,  3,  5,  5,  0,  0,  0, 14, 14,  0,  0,  0, 13, 13, 13, 13,
    11,  0,  0,  0,  4,  4,  5,  5,  5,  5,  5,  6,  0, 13, 13,  0,
    12, 12,  0,  0,  0, 13, 13, 12,  0,  0,  0,  6,  5,  0,  5,  5,
     0, 13, 13,  7,  0,  0,  0,  8,  0,  0,  7,  8,  8,  8,  7,  7,
     8,  0,  8,  0,  8,  8,  0,  7,  9,  7,  0,  0,  0,  8,  7,  7,
     0,  0,  7,  0,  9,  9,  9,  8,  0,  0,  8,  8,  0,  0, 13, 13,
     8,  7,  7,  8,  7,  8,  7,  3,  7,  7,  0,  7,  0,  0, 12,  9,
     0,  0, 13,  0,  6, 14, 12,  0,  0, 13, 13, 13,  9,  9,  0, 12,
     9,  0, 12, 12,  8,  7,  9,  3,  3,  3,  0,  9,  7,  7,  3,  3,
     3,  3,  0, 12,  0,  0,  8,  7,  9,  0,  0,  8,  7,  8,  7,  9,
     7,  7,  7,  9,  9,  9,  3,  9,  0,  9,  9,  3,  0, 12, 12, 12,
     0,  0,  9,  3, 12, 12,  9,  9,  9,  3,  3,  0,  3,  3,  3, 12,
     0,  0,  0,  7,  0,  9,  3,  9,  9,  9, 13, 13, 14, 14,  0, 14,
     0, 14, 14,  0, 13,  0,  0, 13,  0, 14, 12, 12, 14, 13, 13, 13,
    13, 13, 13,  0,  9,  0,  0,  5,  0, 13,  0, 13, 13, 12, 13, 13,
    14,  0,  9,  9,  0,  5,  5,  5,  0,  5, 12, 12,  3,  0, 10, 10,
     9, 12, 12,  0,  3, 12,  0,  0, 10, 10,  9,  0, 12, 12,  0, 12,
    12,  0,  3,  0,  9, 12,  0,  0,  9,  9,  0,  3,  9,  9,  9, 12,
     3,  0, 12, 12,  3,  9,  0,  9, 12,  9,  0,  0,  5,  0,  0,  0,
     0,  3,  3, 12,  3,  3,  3,  5,  5,  5,  5,  3,  0,  8,  8,  0,
     8,  0,  7,  7,
};

/* Sentence_Break: 8564 bytes. */

RE_UINT32 re_get_sentence_break(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_sentence_break_stage_1[f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_sentence_break_stage_2[pos + f] << 5;
    f = code >> 2;
    code ^= f << 2;
    pos = (RE_UINT32)re_sentence_break_stage_3[pos + f] << 2;
    value = re_sentence_break_stage_4[pos + code];

    return value;
}

/* Math. */

static RE_UINT8 re_math_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_math_stage_2[] = {
    0, 1, 2, 2, 2, 2, 2, 2, 3, 4, 5, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, 7,
    2, 2, 2, 2, 2, 8, 2, 2, 2, 2, 2, 9, 2, 2, 2, 2,
};

static RE_UINT8 re_math_stage_3[] = {
     0,  1,  2,  3,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  5,
     4,  4,  4,  4,  4,  4,  4,  4,  6,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     7,  8,  9, 10, 11, 12, 13, 14, 15, 15, 15, 15, 16, 17, 18, 19,
     4,  4,  4,  4,  4,  4, 20, 21, 22, 23,  4,  4,  4,  4,  4, 15,
     4,  4,  4,  4, 15, 15, 15, 15, 15, 15, 15, 15, 24, 25,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4, 26,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4, 27,  4,  4, 28, 29,  4, 30,
    15, 31, 32, 33, 34, 35, 15, 15, 15, 15, 36, 15, 15, 15, 15, 37,
     4,  4,  4,  4,  4,  4,  4,  4, 38, 39, 40, 41,  4,  4,  4,  4,
};

static RE_UINT8 re_math_stage_4[] = {
      0,   0,   0,   0,   0,   8,   0, 112,   0,   0,   0,  64,   0,   0,   0,  80,
      0,   0,   0,   0,   0,  16,   2,   0,   0,   0, 128,   0,   0,   0, 128,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  39,   0,   0,   0, 115,   0,
    192,   1,   0,   0,   0,   0,   0,   0,   0,   0,  64,   0,   0,   0,  28,   0,
     17,   0,   4,   0,  30,   0,   0, 124,   0, 124,   0,   0,   0,   0,   0,   0,
      0,   0, 255,  31,  98, 248,   0,   0, 132, 252,  47,  63,  16, 179, 251, 241,
    255,  11,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 126, 195, 240,
    255, 255, 255,  47,  48,   0, 240, 255, 255, 255, 255, 255, 255, 255, 255, 255,
      0,  15,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,
      0,   0,   0, 248, 255, 255, 191,   0,   0,   0,   1, 240,   7,   0,   0,   0,
      0,   0,   0,   0,   3, 192, 255, 240, 195, 140,  15,   0, 148,  31,   0, 255,
     96,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,  15, 224,   0,   0,
      0,   0,   0,   0,   0,   0, 255, 255, 159,  31,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0, 126,   1,   0,   0,
      0,   8,   0, 112,   0,   0,   0,  80,   0,   0,   0,  80,   0,   0,   0,   0,
      0,   0,   0,   0,   4,  30,   0,   0, 255, 255, 223, 255, 255, 255, 255, 255,
    255, 255, 255, 223, 100, 222, 255, 235, 239, 255, 255, 255, 255, 255, 255, 255,
    191, 231, 223, 223, 255, 255, 255, 123,  95, 252, 253, 255, 255, 255, 255, 255,
    255, 255, 255, 255,  63, 255, 255, 255, 255, 207, 255, 255, 255, 255, 255, 255,
    239, 255, 255, 255, 150, 254, 247,  10, 132, 234, 150, 170, 150, 247, 247,  94,
    255, 251, 255,  15, 238, 251, 255,  15,   0,   0,   0,   0,   0,   0,   3,   0,
};

/* Math: 628 bytes. */

RE_UINT32 re_get_math(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_math_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_math_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_math_stage_3[pos + f] << 6;
    pos += code;
    value = (re_math_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Alphabetic. */

static RE_UINT8 re_alphabetic_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20, 21,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 22, 23, 24,  5, 25, 26,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_alphabetic_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  32,  31,  31,  31,  31,  31,  31,  31,  33,  34,  35,  31,
     36,  37,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  38,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  39,
      1,   1,   1,   1,  40,   1,  41,  42,  43,  44,  45,  46,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  47,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  48,  49,   1,  50,  51,  52,
     53,  54,  55,  56,  57,  58,   1,  59,  60,  61,  62,  63,  64,  65,  31,  66,
     67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  31,  78,  79,  80,  31,
      1,   1,   1,  81,  82,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  84,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  85,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  86,  87,  31,  31,  88,  89,
      1,   1,   1,   1,   1,   1,   1,  90,   1,   1,  91,  31,  31,  31,  31,  31,
      1,  92,  93,  31,  31,  31,  31,  31,  31,  31,  31,  31,  94,  31,  31,  31,
     31,  31,  31,  31,  95,  96,  97,  98,  31,  31,  31,  31,  31,  31,  31,  31,
     99, 100, 101,  31,  31,  31,  31,  31, 102, 103,  31,  31,  31,  31, 104,  31,
     31, 105,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,   1,   1, 106,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 107, 108,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 109,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 110,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 111,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_alphabetic_stage_3[] = {
      0,   0,   1,   1,   0,   2,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   5,   6,   0,   0,   7,   8,   9,  10,   4,  11,
      4,   4,   4,   4,  12,   4,   4,   4,   4,  13,  14,   4,  15,  16,  17,  18,
     19,   4,  20,  21,   4,   4,  22,  23,  24,   4,  25,   4,   4,  26,  27,  28,
     29,  30,  31,  32,   0,  33,  34,  35,   4,  36,  37,  38,  39,  40,  41,  42,
     43,  44,  45,  46,  47,  48,  49,  50,  51,  48,  52,  53,  54,  55,  56,   0,
     57,  58,  59,  60,  57,  61,  62,  63,  57,  64,  65,  66,  67,  68,  69,  70,
     71,  72,  73,   0,  74,  75,  76,   0,  77,   0,  78,  79,  80,  81,   0,   0,
      4,  82,  24,   4,  83,   4,  84,  85,   4,   4,  86,   4,  87,  88,  89,   4,
     90,   4,  72,   0,  91,   4,   4,  92,  71,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,  93,   1,   4,   4,  94,  95,  96,  96,  97,   4,  98,  99,   0,
      0,   4,   4,  31,   4, 100,   4, 101, 102, 103,  24, 104,   4, 105, 106,   0,
    107,   4, 102, 108,   0, 109,   0,   0,   4, 110, 111,   0,   4, 112,   4, 113,
      4, 114, 115, 116, 117,  64,   0, 118,   4,   4,   4,   4,   4,   4,   0, 119,
     92,   4, 120, 116,   4, 121, 122, 123,   0,   0,   0, 124, 125,   0,   0,   0,
    126, 127, 128,   4,  15,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 129,   4, 106,   4, 130, 102,   4,   4,   4,   4, 131,
      4,  84,   4, 132, 114, 133, 133,   4,   0, 134,   0,   0,   0,   0,   0,   0,
    135, 136,  71,   4, 137,  71,   4,  85, 138,  13,   4,   4, 139,  72,   0,  24,
      4,   4,   4,   4,   4, 101,   0,   0,   4,   4,   4,   4,   4,   4,   4,  91,
      4,   4,   4,   4,  30,   0,  24, 116, 140, 141,   4, 142,   4,   4,   4,  91,
    143, 144,   4,   4, 145,   4, 146, 143, 147, 148,   4,  96,   4,   4, 149, 150,
     27, 100, 151,  81,   4, 152, 134, 153,   4, 114, 154, 155,   4, 102, 156, 157,
    158, 159,  85, 160,   4,   4,   4,  32,   4,   4,   4,   4,   4, 161, 162, 107,
      4,   4,   4, 163,   4,   4, 164,   0, 165, 166, 167,   4,   4,  26, 168,   4,
      4, 116,  24,   4, 169,   4, 148, 170,   0,   0,   0, 171,   4,   4,   4,  81,
      0,   1,   1, 172,   4, 102, 173,   0, 174, 175, 176,   0,   4,   4,   4,  72,
      0,   0,   4, 177,   0,   0,   0,   0,   0,   0,   0,   0,  81,   4, 178,   0,
      4,  25, 100,  72, 116,   4, 179,   0,   4,   4,   4,   4, 116,  24, 180, 107,
      4, 160,   4,  60,   0,   0,   0,   0,   4, 114, 101, 148,   0,   0,   0,   0,
    181, 182, 101, 114, 102,   0,   0, 183, 101, 164,   0,   0,   4, 184,   0,   0,
    185, 101,   0,  81,  81,   0,  78, 186,   4, 101, 101, 151,  26,   0,   0,   0,
      4,   4,  15,   0,   4, 151,   4, 151,   4, 148,   0,   0,   0,   0,   0,   0,
     81, 187, 188,   0,   0,   0,   0, 114,   4,   4, 188,   0, 144,  31,  24,  15,
      4, 151, 189, 190,   4,   4, 191,   0, 192, 193,   0,   0, 194, 117,   4,  15,
     39,  48, 195,  60,   0,   0,   0,   0,   4,   4, 196,   0,   4,   4, 197,   0,
      0,   0,   0,   0,   4, 198, 199,   0,   4, 102, 200,   0,   4, 201,   0,   0,
     64,  32,   0,   0,   0,   0,   0,   0,   4,  31,   0,   0,   0,   4,   4, 202,
      0,   0,   0,   0,   0, 203,  29, 204,   4, 205,  24,   4, 206,   0,   4,  31,
    207, 208,  77, 209, 169, 210,   0,   0, 211, 212, 213, 214, 215,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 114,   4,   4,   4,   4, 164,   0,   0,   0,
      4,   4,   4, 139,   4,   4,   4,   4,   4,   4,  60,   0,   0,   0,   0,   0,
      4, 139,   0,   0,   0,   0,   0,   0,   4,   4, 216,   0,   0,   0,   0,   0,
      4,  31, 102,   0,   0,   0,  24, 154,   4,  91,  60, 217,  91,   0,   0,   0,
      0,   0,   4,   4,   0,   0,   0,   0,   4,   4, 218,   4, 219,   0,   0, 220,
      4,   4,   4,   4,   4,   4,   4, 221,   4,   4,   4,   4,   4,   4,   4, 151,
    102,   0, 222, 223,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 107,
      4,   4,   4, 224, 225,   0,   0,   0,   4,   4, 226,   4, 227, 228, 229,   4,
    230, 231, 232,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 233, 234,  85,
    226, 226, 130, 130, 207, 207, 235,   0, 236, 237,   0,   0,   0,   0,   0,   0,
      4, 238, 239,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4, 240,
      4,   4,   4,   4,   4,   4, 186,   0,   4,   4, 241,   0,   0,   0,   0,   0,
    229, 242, 243, 244, 245, 246,   0,   0,   0,  24, 247, 247, 106,   0,   0,   0,
      4,   4,   4,   4,   4,   4, 114,   0,   4, 177,   4,   4,   4,   4,   4,   4,
    116,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 248,   4,   4,
      4,   4,   4,   4,   4,   4,   4,  77, 116,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_alphabetic_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   4,  32,   4, 255, 255, 127, 255,
    255, 255, 255, 255, 195, 255,   3,   0,  31,  80,   0,   0,  32,   0,   0,   0,
      0,   0, 223, 188,  64, 215, 255, 255, 251, 255, 255, 255, 255, 255, 191, 255,
      3, 252, 255, 255, 255, 255, 254, 255, 255, 255, 127,   2, 255,   1,   0,   0,
      0,   0, 255, 191, 182,   0, 255, 255, 255, 135,   7,   0,   0,   0, 255,   7,
    255, 255, 255, 254,   0, 192, 255, 255, 255, 255, 239,  31, 254, 225,   0, 156,
      0,   0, 255, 255,   0, 224, 255, 255, 255, 255,   3,   0,   0, 252, 255, 255,
    255,   7,  48,   4, 255, 255, 255, 252, 255,  31,   0,   0, 255, 255, 255,   1,
    255,   7,   0,   0, 255, 255, 223,  63,   0,   0, 240, 255, 248,   3, 255, 255,
    255, 255, 255, 239, 255, 223, 225, 255,  15,   0, 254, 255, 239, 159, 249, 255,
    255, 253, 197, 227, 159,  89, 128, 176,  15,   0,   3,  16, 238, 135, 249, 255,
    255, 253, 109, 195, 135,  25,   2,  94,   0,   0,  63,   0, 238, 191, 251, 255,
    255, 253, 237, 227, 191,  27,   1,   0,  15,   0,   0,  30, 238, 159, 249, 255,
    159,  25, 192, 176,  15,   0,   2,   0, 236, 199,  61, 214,  24, 199, 255, 195,
    199,  29, 129,   0, 239, 223, 253, 255, 255, 253, 255, 227, 223,  29,  96,   7,
     15,   0,   0,   0, 255, 253, 239, 227, 223,  29,  96,  64,  15,   0,   6,   0,
    255, 255, 255, 231, 223,  93, 240, 128,  15,   0,   0, 252, 236, 255, 127, 252,
    255, 255, 251,  47, 127, 128,  95, 255,   0,   0,  12,   0, 254, 255, 255, 255,
    255, 255, 255,   7, 127,  32,   0,   0, 214, 247, 255, 255, 175, 255, 255,  59,
     95,  32,   0, 240,   1,   0,   0,   0, 255, 254, 255, 255, 255,  31, 254, 255,
      3, 255, 255, 254, 255, 255, 255,  31, 255, 255, 127, 249, 255, 255,   0,  60,
    191,  32, 255, 255, 255, 255, 255, 247, 255,  61, 127,  61, 255,  61, 255, 255,
    255, 255,  61, 127,  61, 255, 127, 255, 255, 255,  61, 255, 255, 255,   0,   0,
    255, 255,  63,  63, 255, 159, 255, 255, 255, 199, 255,   1, 255, 223,  15,   0,
    255, 255,  15,   0, 255, 223,  13,   0, 255, 255, 207, 255, 255,   1, 128,  16,
    255,   7, 255, 255, 255, 255,  63,   0, 255, 255, 255, 127, 255,  15, 255,   1,
    255,  63,  31,   0, 255,  15, 255, 255, 255,   3,   0,   0, 255, 255, 255,  15,
    254, 255,  31,   0, 128,   0,   0,   0, 255, 255, 239, 255, 239,  15,   0,   0,
    255, 243,   0, 252, 191, 255,   3,   0, 255, 255, 127,   0,   0, 224,   0, 252,
    255, 255, 255,  63, 255,   1, 255, 255,   0, 222, 111,   4, 128, 255,  31,   0,
     63,  63, 255, 170, 255, 255, 223,  95, 220,  31, 207,  15, 255,  31, 220,  31,
      0,   0,   2, 128,   0,   0, 255,  31, 132, 252,  47,  62,  80, 189, 255, 243,
    224,  67,   0,   0,   0,   0, 192, 255, 255, 127, 255, 255,  31, 120,  12,   0,
    255, 128,   0,   0, 127, 127, 127, 127,   0, 128,   0,   0, 224,   0,   0,   0,
    254,   3,  62,  31, 255, 255, 127, 224, 224, 255, 255, 255, 255, 127,   0,   0,
    255,  31, 255, 255,   0,  12,   0,   0, 255, 127, 240, 143,   0,   0, 128, 255,
    252, 255, 255, 255, 255, 249, 255, 255, 124,   0,   0,   0, 191, 255, 255, 255,
    255,   0,   0,   0,  47,   0,   0,   0,   0,   0, 252, 232, 255, 255,   7,   0,
    255, 255, 247, 255, 255, 255,   0, 124, 255,  63,   0,   0, 255, 255, 127, 252,
      5,   0,   0,  56, 255, 255,  60,   0, 126, 126, 126,   0, 127, 127, 255, 255,
    255,   0, 255, 255,  15,   0, 255, 255, 127, 248, 255, 255, 255,  63, 255, 255,
    255, 255, 255,   3, 127,   0, 248, 224, 255, 253, 127,  95, 219, 255, 255, 255,
      0,   0, 248, 255, 255, 255, 252, 255,   0,   0, 255,  15,   0,   0, 223, 255,
    192, 255, 255, 255, 252, 252, 252,  28, 255, 239, 255, 255, 127, 255, 255, 183,
    255,  63, 255,  63, 255, 255,  31,   0, 255, 255,   1,   0,  15, 255,  62,   0,
    255, 255,  15, 255,  63, 253, 255, 255, 255, 255, 191, 145, 255, 255,  55,   0,
    255, 255, 255, 192, 111, 240, 239, 254,  31,   0,   0,   0, 128,   0, 255, 255,
     63,   0,   0,   0, 112,   0, 255, 255, 255, 255,  71,   0,  30,   0,   0,  20,
    255, 255, 251, 255, 255, 255, 159,  64, 127, 189, 255, 191, 159,  25, 129, 224,
    187,   7,   0, 128, 179,   0,   0,   0, 255, 255,  63, 127,   0,   0,   0,  63,
     17,   0,   0,   0, 255, 255,  63,   1,   0,   0,   0, 128, 255, 252, 255, 255,
     26,   0,   0,   0, 255, 255, 231, 127, 255, 255, 255,  32, 255, 253, 255, 255,
    255, 255, 127, 127,   0,   0, 252, 255, 255, 254, 127,   0, 127, 251, 255, 255,
    255, 255, 127, 180, 203,   0,   0,   0, 191, 253, 255, 255, 255, 127, 123,   1,
    127,   0,   0,   0, 248, 255, 255, 224, 255, 135, 255, 255, 255, 128, 255, 255,
     11,   0,   0,   0, 255, 255, 255,   0,   0,   0,   7,   0, 240,   0, 255, 255,
    255,   7, 255,  31, 255,   1, 255,  67, 255, 255, 223, 255, 255, 255, 255, 223,
    100, 222, 255, 235, 239, 255, 255, 255, 191, 231, 223, 223, 255, 255, 255, 123,
     95, 252, 253, 255,  63, 255, 255, 255, 253, 255, 255, 247, 247,  15,   0,   0,
    127, 255, 255, 249, 219,   7,   0,   0, 255,  31, 128,  63,   0,  64,   0,   0,
    255,  15,   0,   0, 143,   8,   0,   0, 150, 254, 247,  10, 132, 234, 150, 170,
    150, 247, 247,  94, 255, 251, 255,  15, 238, 251, 255,  15, 255,   3, 255, 255,
      3,   0, 255, 255,
};

/* Alphabetic: 2596 bytes. */

RE_UINT32 re_get_alphabetic(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_alphabetic_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_alphabetic_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_alphabetic_stage_3[pos + f] << 5;
    pos += code;
    value = (re_alphabetic_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Lowercase. */

static RE_UINT8 re_lowercase_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 7, 8,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_lowercase_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  4,  5,  3,  3,  3,  3,  6,  7,
     8,  3,  9,  3,  3,  3, 10,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 11,  3, 12,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 13,  3, 14,
     3,  3, 15,  3,  3,  3, 16,  3,  3,  3,  3,  3, 17,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 18,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 19, 20,  3,  3,  3,  3,
     3,  3,  3,  3, 21,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_lowercase_stage_3[] = {
     0,  0,  0,  1,  0,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12,
     5, 13, 14, 15, 16, 17, 18, 19,  0,  0, 20, 21, 22, 23, 24, 25,
     0, 26, 15,  5, 27,  5, 28,  5,  5, 29,  0, 15, 30,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 26, 31,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,
     0,  0,  0,  0, 30,  0,  0,  0, 15, 15, 15, 15, 15, 15,  0,  0,
     5,  5,  5,  5, 33,  5,  5,  5, 34, 35, 36, 37, 35, 38, 39, 40,
     0,  0,  0, 41, 42,  0,  0,  0, 43, 44, 45, 26, 46,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 26, 47,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 26, 48, 49,  5,  5,  5, 50, 15, 51,  0,  0,  0,  0,  0,  0,
     0,  0,  5, 52, 53,  0,  0,  0,  0, 54,  5, 55, 56, 57, 58, 59,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 26, 60, 61, 15, 15,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
     0, 63, 64,  0,  0,  0, 65, 66,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 15, 67,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 68, 69, 81,
    71, 72, 82, 64, 75, 83, 84, 85, 86, 82, 87, 26, 88, 75, 89,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 90, 91,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_lowercase_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   4,  32,   4,   0,   0,   0, 128,
    255, 255, 127, 255, 170, 170, 170, 170, 170, 170, 170,  85,  85, 171, 170, 170,
    170, 170, 170, 212,  41,  49,  36,  78,  42,  45,  81, 230,  64,  82,  85, 181,
    170, 170,  41, 170, 170, 170, 250, 147, 133, 170, 255, 255, 255, 255, 255, 255,
    255, 255, 239, 255, 255, 255, 255,   1,   3,   0,   0,   0,  31,   0,   0,   0,
     32,   0,   0,   0,   0,   0, 138,  60,   0,   0,   1,   0,   0, 240, 255, 255,
    255, 127, 227, 170, 170, 170,  47,  25,   0,   0, 255, 255,   2, 168, 170, 170,
     84, 213, 170, 170, 170, 170,   0,   0, 255,   1,   0,   0, 255, 255, 255, 231,
      0,   0,   0,  63, 170, 170, 234, 191, 255,   0,  63,   0, 255,   0, 255,   0,
     63,   0, 255,   0, 255,   0, 255,  63, 255,   0, 223,  64, 220,   0, 207,   0,
    255,   0, 220,   0,   0,   0,   2, 128,   0,   0, 255,  31,   0, 196,   8,   0,
      0, 128,  16,  50, 192,  67,   0,   0,  16,   0,   0,   0, 255,   3,   0,   0,
    255, 255, 255, 127,  98,  21, 218,  63,  26,  80,   8,   0, 191,  32,   0,   0,
    170,  42,   0,   0, 170, 170, 170,  58, 168, 170, 171, 170, 170, 170, 255, 149,
    170,  80, 186, 170, 170, 130, 160, 170,   8,   0,   0,   0,   0,   0,   0,   7,
    255, 255, 255, 247, 255,   0, 255, 255, 127,   0, 248,   0,   0, 255, 255, 255,
    255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255,  15, 255, 255,   7,   0,
      0,   0,   0, 252, 255, 255,  15,   0,   0, 192, 223, 255, 255,   0,   0,   0,
    252, 255, 255,  15,   0,   0, 192, 235, 239, 255,   0,   0,   0, 252, 255, 255,
     15,   0,   0, 192, 255, 255, 255,   0,   0,   0, 252, 255, 255,  15,   0,   0,
    192, 255, 255, 255,   0, 192, 255, 255,   0,   0, 192, 255,  63,   0,   0,   0,
    252, 255, 255, 247,   3,   0,   0, 240, 255, 255, 223,  15, 255, 127,  63,   0,
    255, 253,   0,   0, 247,  11,   0,   0, 252, 255, 255, 255,  15,   0,   0,   0,
};

/* Lowercase: 1000 bytes. */

RE_UINT32 re_get_lowercase(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_lowercase_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_lowercase_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_lowercase_stage_3[pos + f] << 5;
    pos += code;
    value = (re_lowercase_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Uppercase. */

static RE_UINT8 re_uppercase_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 7, 8,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_uppercase_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  4,  5,  3,  3,  3,  3,  6,  7,
     8,  3,  9,  3,  3,  3, 10,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 11,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 12,
     3,  3, 13,  3,  3,  3, 14,  3,  3,  3,  3,  3, 15,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 16,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 17, 18,  3,  3,  3,  3,
     3,  3,  3,  3, 19,  3,  3,  3, 20,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_uppercase_stage_3[] = {
     0,  0,  1,  0,  0,  0,  2,  0,  3,  4,  5,  6,  7,  8,  9, 10,
     3, 11, 12,  0,  0,  0,  0,  0,  0,  0,  0, 13, 14, 15, 16, 17,
    18, 19,  0,  3, 20,  3, 21,  3,  3, 22, 23,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 18, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 18, 18, 25,
     0,  0,  0,  0, 26, 27,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3, 28,  3,  3,  3, 29, 30, 31, 32,  0, 33, 34, 35,
     0,  0,  0,  0,  0,  0,  0,  0, 36, 37, 38, 19, 39,  0,  0,  0,
     0,  0,  0,  0,  0, 40, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    18, 41,  0, 42,  3,  3,  3, 43,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  3, 44, 45,  0,  0,  0,  0, 46,  3, 47, 48, 49, 50,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    18, 51,  0,  0,  0, 26, 52,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 18, 53,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    54, 55, 56, 57, 58, 59, 26, 60, 61, 62, 63, 64, 65, 54, 55, 56,
    57, 66, 25, 26, 60, 57, 67, 68, 69, 70, 40, 41, 26, 71, 72,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 18, 73,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 26, 74, 74, 60,  0,  0,  0,
};

static RE_UINT8 re_uppercase_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7, 255, 255, 127, 127,  85,  85,  85,  85,
     85,  85,  85, 170, 170,  84,  85,  85,  85,  85,  85,  43, 214, 206, 219, 177,
    213, 210, 174,  17, 144, 164, 170,  74,  85,  85, 210,  85,  85,  85,   5, 108,
    122,  85,   0,   0,   0,   0,  69, 128,  64, 215, 254, 255, 251,  15,   0,   0,
      0, 128,  28,  85,  85,  85, 144, 230, 255, 255, 255, 255, 255, 255,   0,   0,
      1,  84,  85,  85, 171,  42,  85,  85,  85,  85, 254, 255, 255, 255, 127,   0,
    191,  32,   0,   0, 255, 255,  63,   0,   0,   0, 255, 255, 255, 255, 255, 231,
     85,  85,  21,  64,   0, 255,   0,  63,   0, 255,   0, 255,   0,  63,   0, 170,
      0, 255,   0,   0,   0,   0,   0,  15,   0,  15,   0,  15,   0,  31,   0,  15,
    132,  56,  39,  62,  80,  61,  15, 192,  32,   0,   0,   0,   8,   0,   0,   0,
      0,   0, 192, 255, 255, 127,   0,   0, 157, 234,  37, 192,   5,  40,   4,   0,
     85,  21,   0,   0,  85,  85,  85,   5,  84,  85,  84,  85,  85,  85,   0, 106,
     85,  40,  69,  85,  85, 125,  95,  85, 116,   0,   0,   0, 255,   0,   0,   0,
    255, 255,  15,   0, 255, 255,   7,   0, 255, 255, 255,   3,   0,   0, 240, 255,
    255,  63,   0,   0,   0, 255, 255, 255,   3,   0,   0, 208, 100, 222,  63,   0,
    255,   3,   0,   0, 176, 231, 223,  31,   0,   0,   0, 123,  95, 252,   1,   0,
      0, 240, 255, 255,  63,   0,   0,   0,   3,   0,   0, 240,   1,   0,   0,   0,
    252, 255, 255,   7,   0,   0,   0, 240, 255, 255,  31,   0, 255,   1,   0,   0,
      0,   4,   0,   0,   3,   0,   0,   0, 255,   3, 255, 255,
};

/* Uppercase: 916 bytes. */

RE_UINT32 re_get_uppercase(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_uppercase_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_uppercase_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_uppercase_stage_3[pos + f] << 5;
    pos += code;
    value = (re_uppercase_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Cased. */

static RE_UINT8 re_cased_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 7, 8,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_cased_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  4,  5,  3,  3,  3,  3,  6,  7,
     8,  3,  9,  3,  3,  3, 10,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 11,  3, 12,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 13,  3, 14,
     3,  3, 15,  3,  3,  3, 16,  3,  3,  3,  3,  3, 17,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 18,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 19, 20,  3,  3,  3,  3,
     3,  3,  3,  3, 21,  3,  3,  3, 22,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_cased_stage_3[] = {
     0,  0,  1,  1,  0,  2,  3,  3,  4,  4,  4,  4,  4,  5,  6,  4,
     4,  4,  4,  4,  7,  8,  9, 10,  0,  0, 11, 12, 13, 14,  4, 15,
     4,  4,  4,  4, 16,  4,  4,  4,  4, 17, 18,  4, 19,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  4, 20, 21,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  4, 22,
     0,  0,  0,  0, 23, 21,  0,  0,  4,  4,  4,  4,  4,  4,  0,  0,
     4,  4,  4,  4,  4,  4,  4,  4, 22,  4, 24, 25,  4, 26, 27, 28,
     0,  0,  0, 29, 30,  0,  0,  0, 31, 32, 33,  4, 34,  0,  0,  0,
     0,  0,  0,  0,  0, 35,  4, 36,  0,  0,  0,  0,  0,  0,  0,  0,
     4, 37, 38,  4,  4,  4,  4, 39,  4, 40,  0,  0,  0,  0,  0,  0,
     0,  0,  4, 41, 25,  0,  0,  0,  0, 42,  4,  4, 43,  4, 44, 45,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  5, 47,  4,  4,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
     4,  4, 49,  0,  0, 46, 50, 51,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  4, 52,  4, 52,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  4,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  4,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     4,  4, 53,  4, 54, 55, 56,  4, 57, 58, 59,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4, 60, 61,  5, 53, 53, 37, 37, 62, 62, 63,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  4,  4, 64,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 46, 65, 65, 36,  0,  0,  0,
};

static RE_UINT8 re_cased_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   4,  32,   4, 255, 255, 127, 255,
    255, 255, 255, 255, 255, 255, 255, 247, 240, 255, 255, 255, 255, 255, 239, 255,
    255, 255, 255,   1,   3,   0,   0,   0,  31,   0,   0,   0,  32,   0,   0,   0,
      0,   0, 207, 188,  64, 215, 255, 255, 251, 255, 255, 255, 255, 255, 191, 255,
      3, 252, 255, 255, 255, 255, 254, 255, 255, 255, 127,   0, 255,   1,   0,   0,
    191,  32, 255, 255, 255, 255, 255, 231, 255, 255,  63,  63, 255,   1, 255, 255,
     63,  63, 255, 170, 255, 255, 255,  63, 255, 255, 223,  95, 220,  31, 207,  15,
    255,  31, 220,  31,   0,   0,   2, 128,   0,   0, 255,  31, 132, 252,  47,  62,
     80, 189,  31, 242, 224,  67,   0,   0,  24,   0,   0,   0,   0,   0, 192, 255,
    255,   3,   0,   0, 255, 127, 255, 255, 255, 255, 255, 127,  31, 120,  12,   0,
    191,  32,   0,   0, 255,  63,   0,   0, 252, 255, 255, 255, 255, 120, 255, 255,
    124,   0,   0,   0,   0,   0,   0,   7,   0,   0, 255, 255, 255,   0, 255, 255,
    127,   0, 248,   0, 255, 255,   0,   0, 255, 255,  15, 255, 255, 255, 255,  15,
    255, 255,   7,   0, 255, 255, 223, 255, 255, 255, 255, 223, 100, 222, 255, 235,
    239, 255, 255, 255, 191, 231, 223, 223, 255, 255, 255, 123,  95, 252, 253, 255,
     63, 255, 255, 255, 253, 255, 255, 247, 255, 253, 255, 255, 247,  15,   0,   0,
     15,   0,   0,   0, 255,   3, 255, 255,
};

/* Cased: 912 bytes. */

RE_UINT32 re_get_cased(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_cased_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_cased_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_cased_stage_3[pos + f] << 5;
    pos += code;
    value = (re_cased_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Case_Ignorable. */

static RE_UINT8 re_case_ignorable_stage_1[] = {
     0,  1,  2,  2,  2,  3,  2,  4,  5,  6,  2,  7,  2,  8,  9, 10,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    11,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,
};

static RE_UINT8 re_case_ignorable_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
    16,  1,  1, 17,  1,  1,  1, 18, 19, 20, 21, 22, 23, 24,  1, 25,
    26,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27, 28, 29,  1,
    30,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    31,  1,  1,  1, 32,  1, 33, 34, 35, 36, 37, 38,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 39,  1,  1, 40, 41,
     1, 42, 43, 44,  1,  1,  1,  1,  1,  1, 45,  1,  1, 46,  1, 47,
    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,  1, 59, 60, 61,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 62,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 63, 64,  1,  1,  1, 65,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 66,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, 67, 68,  1,  1,  1,  1,  1,  1,  1, 69,  1,  1,  1,  1,  1,
    70, 71, 72,  1,  1,  1,  1,  1, 73, 74,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 75,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    76, 77,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_case_ignorable_stage_3[] = {
      0,   1,   2,   3,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   5,   6,   6,   6,   6,   6,   7,   8,   0,   0,   0,
      0,   0,   0,   0,   9,   0,   0,   0,   0,   0,  10,   0,  11,  12,  13,  14,
     15,   0,  16,  17,   0,   0,  18,  19,  20,   5,  21,   0,   0,  22,   0,  23,
     24,  25,  26,   0,   0,   0,  27,   6,  28,  29,  30,  31,  32,  33,  34,  35,
     36,  33,  37,  38,  36,  33,  39,  40,  32,  41,  42,  43,  44,   0,  45,   0,
     46,  47,  48,  43,  32,  41,  49,  43,  50,  51,  34,  43,   0,   0,  52,   0,
      0,  53,  54,   0,   0,  55,  56,   0,  57,  58,   0,  59,  60,  61,  62,   0,
      0,  63,  64,  65,  66,   0,   0,  33,   0,   0,  67,   0,   0,   0,   0,   0,
     68,  68,  69,  69,   0,  70,  71,   0,  72,   0,  73,   0,  74,  75,   0,   0,
      0,  76,   0,   0,   0,   0,   0,   0,  77,   0,  78,  79,   0,  80,   0,   0,
     81,  82,  44,  83,  50,  84,   0,  85,   0,  86,   0,  87,   0,   0,  88,  89,
      0,  90,   6,  91,  92,   6,   6,  93,   0,   0,   0,   0,   0,  94,  95,  96,
     97,  98,   0,  99, 100,   0,   5, 101,   0,   0,   0, 102,   0,   0,   0, 103,
      0,   0,   0, 104,   0,   0,   0,   6,   0, 105,   0,   0,   0,   0,   0,   0,
    106, 107,   0,   0, 108,   0,   0, 109, 110,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  87, 111,   0,   0, 112, 113,   0,   0, 114,
      6,  50,   0,  17, 115,   0,   0,  57, 116,  74,   0,   0,   0,   0, 117, 118,
      0, 119, 120,   0,  28, 121, 105,  74,   0, 122, 123, 124,   0, 125, 126, 127,
      0,   0,  92,   0,   0,   0,   0, 128,   2,   0,   0,   0,   0, 129,  50,   0,
    130, 131, 132,   0,   0,   0,   0, 133,   1,   2,   3,  17,  47,   0,   0, 134,
      0,   0,   0,   0,   0,   0,   0, 135,   0,   0,   0,   0,   0,   0,   0,   3,
      0,   0,   0, 136,   0,   0,   0,   0, 137, 138,   0,   0,   0,   0,   0,  74,
      0, 139,   0,   0,   0,   0,   0,   0,   0,   0,  22,   0,   0,   0,   0,   0,
     32, 140, 141, 133,  50, 142, 143,   0,  28, 144,   0, 145,  50, 146, 147,   0,
      0, 148,   0,   0,   0,   0, 133, 149,  50,  51,   3, 150,   0,   0,   0,   0,
      0, 140, 151,   0,   0, 152, 153,   0,   0,   0,   0,   0,   0, 154, 155,   0,
      0, 156,   3,   0,   0, 157,   0,   0,  67, 158,   0,   0,   0,   0,   0,   0,
      0, 159,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 160,   3,
    161, 162, 163,   0, 164,   0,   0,   0,   0, 165,   0,   0, 129, 166,   0,   0,
      0, 167, 168,   0, 169,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 170,
      0, 171,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 172,
      0, 173,  81,   0,   0,   0,   0,   0,   0,   0, 105,   0, 174,   0,   0, 175,
      0,   0,   0,   0, 176,  81,   0,   0,   0,   0,   0, 177, 178, 179,   0,   0,
      0,   0, 180,   0,   0,   0,   0,   0,   6, 181,   6, 182, 183, 184,   0,   0,
    185, 186,   0,   0,   0,   0,   0,   0,   0, 187,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 188,   0,   0,   0,   0,   0,   0, 173,   0,
      0,   0, 189,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  92,
     32,   6,   6,   6,   0,   0,   0,   0,   6,   6,   6,   6,   6,   6,   6, 131,
};

static RE_UINT8 re_case_ignorable_stage_4[] = {
      0,   0,   0,   0, 128,  64,   0,   4,   0,   0,   0,  64,   1,   0,   0,   0,
      0, 161, 144,   1,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,  48,   4,
    176,   0,   0,   0, 248,   3,   0,   0,   0,   0,   0,   2,   0,   0, 254, 255,
    255, 255, 255, 191, 182,   0,   0,   0,   0,   0,  16,   0,  63,   0, 255,  23,
      1, 248, 255, 255,   0,   0,   1,   0,   0,   0, 192, 191, 255,  61,   0,   0,
      0, 128,   2,   0, 255,   7,   0,   0, 192, 255,   1,   0,   0, 248,  63,  36,
      0,   0, 192, 255, 255,  63,   0,   0,   0,   0,   0,  14,   0,   0, 248, 255,
      7,   0,   0,   0,   0,   0,   0,  20, 254,  33, 254,   0,  12,   0,   2,   0,
      2,   0,   0,   0,   0,   0,   0,  16,  30,  32,   0,   0,  12,   0,   0,  64,
      6,   0,   0,   0, 134,  57,   2,   0,   0,   0,  35,   0, 190,  33,   0,   0,
     12,   0,   0, 252,   0,   0,   0, 144,  30,  32,  64,   0,  12,   0,   0,   0,
      4,   0,   0,   0,   1,  32,   0,   0,  17,   0,   0,   0,   0,   0,   0, 192,
    193,  61,  96,   0,  64,  48,   0,   0,   3,   0,   0,   0,   0,   0,   0,  24,
      0,   4,  92,   0,   0,   0, 242,   7, 192, 127,   0,   0,   0,   0, 242,  31,
     64,  63,   0,   0,   0,   0,   0,   3,   0,   0, 160,   2,   0,   0, 254, 127,
    223, 224, 255, 254, 255, 255, 255,  31,  64,   0,   0,   0,   0, 224, 253, 102,
      0,   0,   0, 195,   1,   0,  30,   0, 100,  32,   0,  32,   0,   0,   0, 224,
      0,   0,  28,   0,   0,   0,  12,   0,   0,   0, 176,  63,  64, 254, 143,  32,
      0, 120,   0,   0,   8,   0,   0,   0,  96,   0,   0,   0,   0,   2,   0,   0,
    135,   1,   4,  14,   0,   0, 128,   9,   0,   0,  64, 127, 229,  31, 248, 159,
    128,   0, 255, 127,  15,   0,   0,   0,   0,   0, 208,  23,   0, 248,  15,   0,
     60,  59,   0,   0,  64, 163,   3,   0,   0, 240, 207,   0,   0,   0,   0,  63,
      0,   0, 247, 255, 253,  33,  16,   3,   0, 240, 255, 255, 255,   7,   0,   1,
      0,   0,   0, 248, 255, 255, 255, 251,   0,   0,   0, 160,   3, 224,   0, 224,
      0, 224,   0,  96,   0, 248,   0,   3, 144, 124,   0,   0, 223, 255,   2, 128,
      0,   0, 255,  31, 255, 255,   1,   0,   0,   0,   0,  48,   0, 128,   3,   0,
      0, 128,   0, 128,   0, 128,   0,   0,  32,   0,   0,   0,   0,  60,  62,   8,
      0,   0,   0, 126,   0,   0,   0, 112,   0,   0,  32,   0,   0,  16,   0,   0,
      0, 128, 247, 191,   0,   0,   0, 240,   0,   0,   3,   0,   0,   7,   0,   0,
     68,   8,   0,   0,  48,   0,   0,   0, 255, 255,   3, 128, 192,  63,   0,   0,
    128, 255,   3,   0,   0,   0, 200,  51,   0, 126, 102,   0,   8,  16,   0,   0,
      0,   0,   1,  16,   0,   0, 157, 193,   2,   0,   0,  32,   0,  48,  88,   0,
     32,  33,   0,   0,   0,   0, 252, 255, 255, 255,   8,   0, 255, 255,   0,   0,
      0,   0,  36,   0,   0,   0,   0, 128,   8,   0,   0,  14,   0,   0,   0,  32,
      0,   0, 192,   7, 110, 240,   0,   0,   0,   0,   0, 135, 240,   0,   0,   0,
      0,   0,   0, 255, 127,   0,   0,   0,   0,   0, 120,  38,   0,  32,   0,   0,
    128, 239,  31,   0,   0,   0,   8,   0,   0,   0, 192, 127,   0,  30,   0,   0,
      0, 128, 211,  64, 248,   7,   0,   0, 192,  31,  31,   0,  92,   0,   0,  64,
      0,   0, 248, 133,  13,   0,   0,   0,   0,   0,  60, 176,   1,   0,   0,  48,
      0,   0, 248, 167,   0,  40, 191,   0, 188,  15,   0,   0,   0, 128, 255,   6,
      0,   0, 240,  12, 254,   7,   0,   0,   0,   0, 248, 121, 128,   0, 126,  14,
      0, 252, 127,   3,   0,   0, 127, 191, 255, 252, 109,   0,   0,   0, 126, 180,
    191,   0,   0,   0,   0,   0, 163,   0,   0,   0,  24,   0,   0,   0, 255,   1,
      0,   0,  31,   0,   0,   0, 127,   0,   0, 128, 255, 255,  11,   0,   0,   0,
      0,   0,   0,  96, 128,   3, 248, 255, 231,  15,   0,   0,   0,  60,   0,   0,
     28,   0,   0,   0, 255, 255, 127, 248, 255,  31,  32,   0,  16,   0,   0, 248,
    254, 255,   0,   0, 127, 255, 255, 249, 219,   7,   0,   0,   0,   0, 255,  63,
      0, 240,   0,   0, 240,  15,   0,   0,
};

/* Case_Ignorable: 1904 bytes. */

RE_UINT32 re_get_case_ignorable(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_case_ignorable_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_case_ignorable_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_case_ignorable_stage_3[pos + f] << 5;
    pos += code;
    value = (re_case_ignorable_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Changes_When_Lowercased. */

static RE_UINT8 re_changes_when_lowercased_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 2, 7,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_changes_when_lowercased_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  4,  5,  3,  3,  3,  3,  6,  7,
     8,  3,  9,  3,  3,  3, 10,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 11,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 12,
     3,  3, 13,  3,  3,  3, 14,  3,  3,  3,  3,  3, 15,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 16,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, 17,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_changes_when_lowercased_stage_3[] = {
     0,  0,  1,  0,  0,  0,  2,  0,  3,  4,  5,  6,  7,  8,  9, 10,
     3, 11, 12,  0,  0,  0,  0,  0,  0,  0,  0, 13, 14, 15, 16, 17,
    18, 19,  0,  3, 20,  3, 21,  3,  3, 22, 23,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 18, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 18, 18, 25,
     0,  0,  0,  0, 26, 27,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3, 28,  3,  3,  3, 29, 30, 31, 32, 30, 33, 34, 35,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 36,  0, 19, 37,  0,  0,  0,
     0,  0,  0,  0,  0, 38, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    18, 39,  0, 40,  3,  3,  3, 41,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  3, 42, 43,  0,  0,  0,  0, 44,  3, 45, 46, 47, 48,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    18, 49,  0,  0,  0, 26, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 18, 51,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 18, 52,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_changes_when_lowercased_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7, 255, 255, 127, 127,  85,  85,  85,  85,
     85,  85,  85, 170, 170,  84,  85,  85,  85,  85,  85,  43, 214, 206, 219, 177,
    213, 210, 174,  17, 176, 173, 170,  74,  85,  85, 214,  85,  85,  85,   5, 108,
    122,  85,   0,   0,   0,   0,  69, 128,  64, 215, 254, 255, 251,  15,   0,   0,
      0, 128,   0,  85,  85,  85, 144, 230, 255, 255, 255, 255, 255, 255,   0,   0,
      1,  84,  85,  85, 171,  42,  85,  85,  85,  85, 254, 255, 255, 255, 127,   0,
    191,  32,   0,   0, 255, 255,  63,   0,   0,   0, 255, 255, 255, 255, 255, 231,
     85,  85,  21,  64,   0, 255,   0,  63,   0, 255,   0, 255,   0,  63,   0, 170,
      0, 255,   0,   0,   0, 255,   0,  31,   0,  31,   0,  15,   0,  31,   0,  31,
     64,  12,   4,   0,   8,   0,   0,   0,   0,   0, 192, 255, 255, 127,   0,   0,
    157, 234,  37, 192,   5,  40,   4,   0,  85,  21,   0,   0,  85,  85,  85,   5,
     84,  85,  84,  85,  85,  85,   0, 106,  85,  40,  69,  85,  85, 125,  95,  85,
    116,   0,   0,   0, 255,   0,   0,   0, 255, 255,  15,   0, 255, 255,   7,   0,
      3,   0,   0,   0,
};

/* Changes_When_Lowercased: 764 bytes. */

RE_UINT32 re_get_changes_when_lowercased(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_changes_when_lowercased_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_changes_when_lowercased_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_changes_when_lowercased_stage_3[pos + f] << 5;
    pos += code;
    value = (re_changes_when_lowercased_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Changes_When_Uppercased. */

static RE_UINT8 re_changes_when_uppercased_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 2, 7,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_changes_when_uppercased_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  4,  5,  3,  3,  3,  3,  6,  7,
     8,  3,  9,  3,  3,  3, 10,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 11,  3, 12,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 13,  3, 14,
     3,  3, 15,  3,  3,  3, 16,  3,  3,  3,  3,  3, 17,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 18,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, 19,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_changes_when_uppercased_stage_3[] = {
     0,  0,  0,  1,  0,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12,
     5, 13, 14, 15, 16,  0,  0,  0,  0,  0, 17, 18, 19, 20, 21, 22,
     0, 23, 24,  5, 25,  5, 26,  5,  5, 27,  0, 28, 29,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 23, 30,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31,
     0,  0,  0,  0, 32,  0,  0,  0,  0,  0,  0, 33, 34,  0,  0,  0,
     5,  5,  5,  5, 35,  5,  5,  5, 36, 37, 38, 39, 24, 40, 41, 42,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 34, 23, 43,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 23, 44,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 23, 45, 46,  5,  5,  5, 47, 24, 48,  0,  0,  0,  0,  0,  0,
     0,  0,  5, 49, 50,  0,  0,  0,  0, 51,  5, 52, 53, 54, 55,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56, 23, 24, 24,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
     0, 58, 59,  0,  0,  0, 60, 61,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 24, 62,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 63, 64,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_changes_when_uppercased_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   0,  32,   0,   0,   0,   0, 128,
    255, 255, 127, 255, 170, 170, 170, 170, 170, 170, 170,  84,  85, 171, 170, 170,
    170, 170, 170, 212,  41,  17,  36,  70,  42,  33,  81, 162,  96,  91,  85, 181,
    170, 170,  45, 170, 168, 170,  10, 144, 133, 170, 223,  26, 107, 159,  38,  32,
    141,  31,   4,  96,  32,   0,   0,   0,   0,   0, 138,  56,   0,   0,   1,   0,
      0, 240, 255, 255, 255, 127, 227, 170, 170, 170,  47,   9,   0,   0, 255, 255,
    255, 255, 255, 255,   2, 168, 170, 170,  84, 213, 170, 170, 170, 170,   0,   0,
    254, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 231,   0,   0,   0,  63,
    255,   1,   0,   0,   0,   0,   0,  34,   0,  64,   0,   0, 170, 170, 234,  15,
    255,   0,  63,   0, 255,   0, 255,   0,  63,   0, 255,   0, 255,   0, 255,  63,
    255, 255, 223,  80, 220,  16, 207,   0, 255,   0, 220,  16,  16,   0,   0,   0,
    255,   3,   0,   0, 255, 255, 255, 127,  98,  21,  72,   0,  10,  80,   8,   0,
    191,  32,   0,   0, 170,  42,   0,   0, 170, 170, 170,  10, 168, 170, 168, 170,
    170, 170,   0, 148, 170,  16, 154, 170, 170,   2, 160, 170,   8,   0,   0,   0,
      0,   0,   8,   0, 127,   0, 248,   0,   0, 255, 255, 255, 255, 255,   0,   0,
      0,   0,   0, 255, 255, 255, 255,  15, 255, 255,   7,   0, 252, 255, 255, 255,
     15,   0,   0,   0,
};

/* Changes_When_Uppercased: 844 bytes. */

RE_UINT32 re_get_changes_when_uppercased(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_changes_when_uppercased_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_changes_when_uppercased_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_changes_when_uppercased_stage_3[pos + f] << 5;
    pos += code;
    value = (re_changes_when_uppercased_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Changes_When_Titlecased. */

static RE_UINT8 re_changes_when_titlecased_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 2, 7,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_changes_when_titlecased_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  3,  4,  3,  3,  3,  3,  5,  6,
     7,  3,  8,  3,  3,  3,  9,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 10,  3, 11,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 12,  3, 13,
     3,  3, 14,  3,  3,  3, 15,  3,  3,  3,  3,  3, 16,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 17,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, 18,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_changes_when_titlecased_stage_3[] = {
     0,  0,  0,  1,  0,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12,
     5, 13, 14, 15, 16,  0,  0,  0,  0,  0, 17, 18, 19, 20, 21, 22,
     0, 23, 24,  5, 25,  5, 26,  5,  5, 27,  0, 28, 29,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30,
     0,  0,  0,  0, 31,  0,  0,  0,  0,  0,  0, 32, 33,  0,  0,  0,
     5,  5,  5,  5, 34,  5,  5,  5, 35, 36, 37, 38, 36, 39, 40, 41,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 33, 23, 42,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 23, 43,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 23, 44, 45,  5,  5,  5, 46, 24, 47,  0,  0,  0,  0,  0,  0,
     0,  0,  5, 48, 49,  0,  0,  0,  0, 50,  5, 51, 52, 53, 54,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 55, 23, 24, 24,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 56,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
     0, 57, 58,  0,  0,  0, 59, 60,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 24, 61,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 62, 63,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_changes_when_titlecased_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   0,  32,   0,   0,   0,   0, 128,
    255, 255, 127, 255, 170, 170, 170, 170, 170, 170, 170,  84,  85, 171, 170, 170,
    170, 170, 170, 212,  41,  17,  36,  70,  42,  33,  81, 162, 208,  86,  85, 181,
    170, 170,  43, 170, 168, 170,  10, 144, 133, 170, 223,  26, 107, 159,  38,  32,
    141,  31,   4,  96,  32,   0,   0,   0,   0,   0, 138,  56,   0,   0,   1,   0,
      0, 240, 255, 255, 255, 127, 227, 170, 170, 170,  47,   9,   0,   0, 255, 255,
    255, 255, 255, 255,   2, 168, 170, 170,  84, 213, 170, 170, 170, 170,   0,   0,
    254, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,  63, 255,   1,   0,   0,
      0,   0,   0,  34,   0,  64,   0,   0, 170, 170, 234,  15, 255,   0,  63,   0,
    255,   0, 255,   0,  63,   0, 255,   0, 255,   0, 255,  63, 255,   0, 223,  64,
    220,   0, 207,   0, 255,   0, 220,   0,  16,   0,   0,   0, 255,   3,   0,   0,
    255, 255, 255, 127,  98,  21,  72,   0,  10,  80,   8,   0, 191,  32,   0,   0,
    170,  42,   0,   0, 170, 170, 170,  10, 168, 170, 168, 170, 170, 170,   0, 148,
    170,  16, 154, 170, 170,   2, 160, 170,   8,   0,   0,   0,   0,   0,   8,   0,
    127,   0, 248,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255,
    255, 255, 255,  15, 255, 255,   7,   0, 252, 255, 255, 255,  15,   0,   0,   0,
};

/* Changes_When_Titlecased: 824 bytes. */

RE_UINT32 re_get_changes_when_titlecased(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_changes_when_titlecased_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_changes_when_titlecased_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_changes_when_titlecased_stage_3[pos + f] << 5;
    pos += code;
    value = (re_changes_when_titlecased_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Changes_When_Casefolded. */

static RE_UINT8 re_changes_when_casefolded_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 2, 7,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_changes_when_casefolded_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  4,  5,  3,  3,  3,  3,  6,  7,
     8,  3,  9,  3,  3,  3, 10,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 11,  3, 12,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 13,  3, 14,
     3,  3, 15,  3,  3,  3, 16,  3,  3,  3,  3,  3, 17,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 18,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, 19,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_changes_when_casefolded_stage_3[] = {
     0,  0,  1,  0,  0,  2,  3,  0,  4,  5,  6,  7,  8,  9, 10, 11,
     4, 12, 13,  0,  0,  0,  0,  0,  0,  0, 14, 15, 16, 17, 18, 19,
    20, 21,  0,  4, 22,  4, 23,  4,  4, 24, 25,  0, 26,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 20, 27,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,
     0,  0,  0,  0, 29, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     4,  4,  4,  4, 31,  4,  4,  4, 32, 33, 34, 35, 20, 36, 37, 38,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 39,  0, 21, 40,  0,  0,  0,
     0,  0,  0,  0,  0, 41, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    20, 42,  0, 43,  4,  4,  4, 44,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  4, 45, 46,  0,  0,  0,  0, 47,  4, 48, 49, 50, 51,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 52, 20, 20,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 53,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,
    20, 54,  0,  0,  0, 52, 55,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 20, 56,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 20, 57,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_changes_when_casefolded_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   0,  32,   0, 255, 255, 127, 255,
     85,  85,  85,  85,  85,  85,  85, 170, 170,  86,  85,  85,  85,  85,  85, 171,
    214, 206, 219, 177, 213, 210, 174,  17, 176, 173, 170,  74,  85,  85, 214,  85,
     85,  85,   5, 108, 122,  85,   0,   0,  32,   0,   0,   0,   0,   0,  69, 128,
     64, 215, 254, 255, 251,  15,   0,   0,   4, 128,  99,  85,  85,  85, 179, 230,
    255, 255, 255, 255, 255, 255,   0,   0,   1,  84,  85,  85, 171,  42,  85,  85,
     85,  85, 254, 255, 255, 255, 127,   0, 128,   0,   0,   0, 191,  32,   0,   0,
      0,   0,   0,  63, 255,   1, 255, 255, 255, 255, 255, 231,  85,  85,  21,  76,
      0, 255,   0,  63,   0, 255,   0, 255,   0,  63,   0, 170,   0, 255,   0,   0,
    255, 255, 156,  31, 156,  31,   0,  15,   0,  31, 156,  31,  64,  12,   4,   0,
      8,   0,   0,   0,   0,   0, 192, 255, 255, 127,   0,   0, 157, 234,  37, 192,
      5,  40,   4,   0,  85,  21,   0,   0,  85,  85,  85,   5,  84,  85,  84,  85,
     85,  85,   0, 106,  85,  40,  69,  85,  85, 125,  95,  85, 116,   0,   0,   0,
      0,   0, 255, 255, 127,   0, 248,   0, 255,   0,   0,   0, 255, 255,  15,   0,
    255, 255,   7,   0,   3,   0,   0,   0,
};

/* Changes_When_Casefolded: 816 bytes. */

RE_UINT32 re_get_changes_when_casefolded(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_changes_when_casefolded_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_changes_when_casefolded_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_changes_when_casefolded_stage_3[pos + f] << 5;
    pos += code;
    value = (re_changes_when_casefolded_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Changes_When_Casemapped. */

static RE_UINT8 re_changes_when_casemapped_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 2, 7,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_changes_when_casemapped_stage_2[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  4,  5,  3,  3,  3,  3,  6,  7,
     8,  3,  9,  3,  3,  3, 10,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3, 11,  3, 12,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 13,  3, 14,
     3,  3, 15,  3,  3,  3, 16,  3,  3,  3,  3,  3, 17,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3, 18,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3, 19,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_changes_when_casemapped_stage_3[] = {
     0,  0,  1,  1,  0,  2,  3,  3,  4,  5,  4,  4,  6,  7,  8,  4,
     4,  9, 10, 11, 12,  0,  0,  0,  0,  0, 13, 14, 15, 16, 17, 18,
     4,  4,  4,  4, 19,  4,  4,  4,  4, 20, 21, 22, 23,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  4, 24, 25,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  4, 26,
     0,  0,  0,  0, 27, 25,  0,  0,  0,  0,  0, 28, 29,  0,  0,  0,
     4,  4,  4,  4, 30,  4,  4,  4, 26,  4, 31, 32,  4, 33, 34, 35,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 36, 29,  4, 37,  0,  0,  0,
     0,  0,  0,  0,  0, 38,  4, 39,  0,  0,  0,  0,  0,  0,  0,  0,
     4, 40, 41, 42,  4,  4,  4, 43,  4, 44,  0,  0,  0,  0,  0,  0,
     0,  0,  4, 45, 46,  0,  0,  0,  0, 47,  4, 48, 49, 40, 50,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51, 52,  4,  4,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 53,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,  0,  0,
     4,  4, 54,  0,  0, 52, 55, 46,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  4, 56,  4, 56,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  4,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  4,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  4,  4, 57,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_changes_when_casemapped_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   0,  32,   0, 255, 255, 127, 255,
    255, 255, 255, 255, 255, 255, 255, 254, 255, 223, 255, 247, 255, 243, 255, 179,
    240, 255, 255, 255, 253, 255,  15, 252, 255, 255, 223,  26, 107, 159,  38,  32,
    141,  31,   4,  96,  32,   0,   0,   0,   0,   0, 207, 184,  64, 215, 255, 255,
    251, 255, 255, 255, 255, 255, 227, 255, 255, 255, 191, 239,   3, 252, 255, 255,
    255, 255, 254, 255, 255, 255, 127,   0, 254, 255, 255, 255, 255,   0,   0,   0,
    191,  32, 255, 255, 255, 255, 255, 231, 255, 255,  63,  63, 255,   1, 255, 255,
      0,   0,   0,  34,   0,  64,   0,   0, 255, 255, 255,  79,  63,  63, 255, 170,
    255, 255, 255,  63, 255, 255, 223,  95, 220,  31, 207,  15, 255,  31, 220,  31,
     64,  12,   4,   0,  24,   0,   0,   0,   0,   0, 192, 255, 255,   3,   0,   0,
    255, 127, 255, 255, 255, 255, 255, 127, 255, 255, 109, 192,  15, 120,  12,   0,
    191,  32,   0,   0, 255,  63,   0,   0, 255, 255, 255,  15, 252, 255, 252, 255,
    255, 255,   0, 254, 255,  56, 223, 255, 124,   0,   0,   0,   0,   0,   8,   0,
      0,   0, 255, 255, 127,   0, 248,   0, 255, 255,   0,   0, 255, 255,  15, 255,
    255, 255,   7,   0,  15,   0,   0,   0,
};

/* Changes_When_Casemapped: 816 bytes. */

RE_UINT32 re_get_changes_when_casemapped(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_changes_when_casemapped_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_changes_when_casemapped_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_changes_when_casemapped_stage_3[pos + f] << 5;
    pos += code;
    value = (re_changes_when_casemapped_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* ID_Start. */

static RE_UINT8 re_id_start_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20,  9,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 21, 22, 23,  5, 24, 25,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_id_start_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  33,  31,  31,
     34,  35,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  36,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  37,
      1,   1,   1,   1,  38,   1,  39,  40,  41,  42,  43,  44,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  45,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  46,  47,   1,  48,  49,  50,
     51,  52,  53,  54,  55,  56,   1,  57,  58,  59,  60,  61,  62,  63,  31,  64,
     65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  31,  76,  77,  78,  31,
      1,   1,   1,  79,  80,  81,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  82,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  84,  85,  31,  31,  86,  87,
      1,   1,   1,   1,   1,   1,   1,  88,   1,   1,  89,  31,  31,  31,  31,  31,
      1,  90,  91,  31,  31,  31,  31,  31,  31,  31,  31,  31,  92,  31,  31,  31,
     31,  31,  31,  31,  93,  94,  95,  96,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  97,  98,  31,  31,  31,  31,  31,  99, 100,  31,  31,  31,  31, 101,  31,
      1,   1,   1,   1,   1,   1, 102,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 103, 104,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 105,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 106,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 107,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_id_start_stage_3[] = {
      0,   0,   1,   1,   0,   2,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   5,   6,   0,   0,   0,   7,   8,   9,   4,  10,
      4,   4,   4,   4,  11,   4,   4,   4,   4,  12,  13,   4,  14,   0,  15,  16,
      0,   4,  17,  18,   4,   4,  19,  20,  21,  22,  23,   4,   4,  24,  25,  26,
     27,  28,  29,  17,   0,  30,   0,   0,  31,  32,  33,  34,  35,  36,  37,  38,
     39,  40,  41,  42,  43,  44,  45,  46,  47,  44,  48,  49,  50,  51,  45,   0,
     52,  53,  54,  55,  56,  57,  58,  59,  52,  60,  61,  62,  63,  64,  65,   0,
     66,  67,  65,   0,  68,  69,  70,   0,  71,   0,  72,  73,  74,   0,   0,   0,
      4,  75,  76,  77,  78,   4,  79,  80,   4,   4,  81,   4,  82,  83,  84,   4,
     85,   4,  86,   0,  22,   4,   4,  87,  66,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,  88,   1,   4,   4,  89,  90,  91,  91,  92,   4,  93,  94,   0,
      0,   4,   4,  29,   4,  95,   4,  96,  97,   0,  15,  98,   4,  99, 100,   0,
    101,   4, 102,   0,   0, 103,   0,   0, 104,  93, 105,   0, 106, 107,   4, 108,
      4, 109, 110, 111, 112, 113,   0, 114,   4,   4,   4,   4,   4,   4,   0,   0,
     87,   4, 115, 111,   4, 116, 117, 118,   0,   0,   0, 119, 120,   0,   0,   0,
    121, 122, 123,   4,  14,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      4, 124,  97,   4,   4,   4,   4, 125,   4,  79,   4, 126, 101, 127, 127,   0,
    128, 129,  66,   4, 130,  66,   4,  80, 104,  12,   4,   4, 131,  86,   0,  15,
      4,   4,   4,   4,   4,  96,   0,   0,   4,   4,   4,   4,   4,   4,   4,  22,
      4,   4,   4,   4,  73,   0,  15, 111, 132, 133,   4, 134, 111,   4,   4,  22,
    135, 136,   4,   4, 137,   4, 138, 135, 139, 140,   4,  93, 136,  93,   0, 141,
     25, 142,  65, 143,  31, 144, 145, 146,   4,  14, 147, 148,   4, 149, 150, 151,
    152, 153,  80, 154,   4,   4,   4, 140,   4,   4,   4,   4,   4, 155, 156, 157,
      4,   4,   4, 158,   4,   4, 159,   0, 160, 161, 162,   4,   4,  91, 163,   4,
      4, 111,  15,   4, 164,   4, 165, 166,   0,   0,   0, 167,   4,   4,   4, 143,
      0,   1,   1, 168,   4,  97, 169,   0, 170, 171, 172,   0,   4,   4,   4,  86,
      0,   0,   4, 102,   0,   0,   0,   0,   0,   0,   0,   0, 143,   4, 173,   0,
      4,  23, 174,  96, 111,   4, 175,   0,   4,   4,   4,   4, 111,  15, 176, 157,
      4, 154,   4, 109,   0,   0,   0,   0,   4, 101,  96, 165,   0,   0,   0,   0,
    177, 178,  96, 101,  97,   0,   0, 179,  96, 159,   0,   0,   4, 180,   0,   0,
    181,  96,   0, 143, 143,   0,  72, 182,   4,  96,  96, 144,  91,   0,   0,   0,
      4,   4,  14,   0,   4, 144,   4, 144,   4, 109,   0,   0,   0,   0,   0,   0,
    143, 183, 108,   0,   0,   0,   0, 101, 106, 184,   0,   0, 106,  22,  15,  14,
    106,  65, 185, 186, 106, 144, 187,   0, 188, 189,   0,   0, 190, 112,  97,   0,
     47,  44, 191,  55,   0,   0,   0,   0,   4, 102, 192,   0,   4,  22, 193,   0,
      0,   0,   0,   0,   4, 131, 194,   0,   4,  22, 195,   0,   4, 196,   0,   0,
     86,   0,   0,   0,   0,   0,   0,   0,   4, 189,   0,   0,   0,   4,   4, 197,
      0,   0,   0,   0,   0, 198, 173, 199, 200, 201, 202,   4, 203,   0,   4,  29,
    204, 131,  71, 205,  22,   0,   0,   0, 206, 173, 207, 208, 209,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 144,   4,   4,   4,   4, 159,   0,   0,   0,
      4,   4,   4, 131,   4,   4,   4,   4,   4,   4, 109,   0,   0,   0,   0,   0,
      4, 131,   0,   0,   0,   0,   0,   0,   4,   4,  65,   0,   0,   0,   0,   0,
      4,  29,  97,   0,   0,   0,  15, 210,   4,  22, 109, 211,  22,   0,   0,   0,
      0,   0,   4,   4,   0,   0,   0,   0,   4,   4, 212,   0, 163,   0,   0, 213,
      4,   4,   4,   4,   4,   4,   4, 184,   4,   4,   4,   4,   4,   4,   4, 144,
     97,   0, 214, 215,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 157,
      4,   4,   4, 216, 217,   0,   0,   0,   4,   4, 218,   4, 219, 220, 221,   4,
    222, 223, 224,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 225, 226,  80,
    218, 218, 124, 124, 204, 204, 147,   0,   4, 227, 228,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   4, 189,   4,   4,   4,   4,   4,   4, 182,   0,
      4,   4, 229,   0,   0,   0,   0,   0, 221, 230, 231, 232, 233, 234,   0,   0,
      4,   4,   4,   4,   4,   4, 101,   0,   4, 102,   4,   4,   4,   4,   4,   4,
    111,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 235,   4,   4,
      4,   4,   4,   4,   4,   4,   4,  71, 111,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_id_start_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   4,  32,   4, 255, 255, 127, 255,
    255, 255, 255, 255, 195, 255,   3,   0,  31,  80,   0,   0,   0,   0, 223, 188,
     64, 215, 255, 255, 251, 255, 255, 255, 255, 255, 191, 255,   3, 252, 255, 255,
    255, 255, 254, 255, 255, 255, 127,   2, 255,   1,   0,   0,   0,   0, 255, 255,
    255, 135,   7,   0, 255,   7,   0,   0,   0, 192, 254, 255, 255, 255,  47,   0,
     96, 192,   0, 156,   0,   0, 253, 255, 255, 255,   0,   0,   0, 224, 255, 255,
     63,   0,   2,   0,   0, 252, 255, 255, 255,   7,  48,   4, 255, 255,  63,   4,
     16,   1,   0,   0, 255, 255, 255,   1, 255, 255, 223,  63, 240, 255, 255, 255,
    255, 255, 255,  35,   0,   0,   1, 255,   3,   0, 254, 255, 225, 159, 249, 255,
    255, 253, 197,  35,   0,  64,   0, 176,   3,   0,   3,  16, 224, 135, 249, 255,
    255, 253, 109,   3,   0,   0,   0,  94,   0,   0,  28,   0, 224, 191, 251, 255,
    255, 253, 237,  35,   0,   0,   1,   0,   3,   0,   0,   2, 224, 159, 249, 255,
      0,   0,   0, 176,   3,   0,   2,   0, 232, 199,  61, 214,  24, 199, 255,   3,
    224, 223, 253, 255, 255, 253, 255,  35,   0,   0,   0,   7,   3,   0,   0,   0,
    225, 223, 253, 255, 255, 253, 239,  35,   0,   0,   0,  64,   3,   0,   6,   0,
    255, 255, 255,  39,   0,  64, 112, 128,   3,   0,   0, 252, 224, 255, 127, 252,
    255, 255, 251,  47, 127,   0,   0,   0, 254, 255, 255, 255, 255, 255,  13,   0,
    214, 247, 255, 255, 175, 255,  13,  32,  95,   0,   0, 240,   1,   0,   0,   0,
    255, 254, 255, 255, 255,  31,   0,   0,   0,  31,   0,   0, 255,   7,   0, 128,
      0,   0,  63,  60,  98, 192, 225, 255,   3,  64,   0,   0, 191,  32, 255, 255,
    255, 255, 255, 247, 255,  61, 127,  61, 255,  61, 255, 255, 255, 255,  61, 127,
     61, 255, 127, 255, 255, 255,  61, 255, 255, 255, 255,   7, 255, 255,  63,  63,
    255, 159, 255, 255, 255, 199, 255,   1, 255, 223,   3,   0, 255, 255,   3,   0,
    255, 223,   1,   0, 255, 255,  15,   0,   0,   0, 128,  16, 255,   5, 255, 255,
    255, 255,  63,   0, 255, 255, 255, 127, 255,  63,  31,   0, 255,  15, 255, 255,
    255,   3,   0,   0, 255, 255, 127,   0, 255, 255,  31,   0, 128,   0,   0,   0,
    224, 255, 255, 255, 224,  15,   0,   0, 248, 255, 255, 255,   1, 192,   0, 252,
     63,   0,   0,   0,  15,   0,   0,   0,   0, 224,   0, 252, 255, 255, 255,  63,
    255,   1, 255, 255, 255, 255, 255, 231,   0, 222, 111,   4,  63,  63, 255, 170,
    255, 255, 223,  95, 220,  31, 207,  15, 255,  31, 220,  31,   0,   0,   2, 128,
      0,   0, 255,  31, 132, 252,  47,  63,  80, 253, 255, 243, 224,  67,   0,   0,
    255, 127, 255, 255,  31, 120,  12,   0, 255, 128,   0,   0, 127, 127, 127, 127,
    224,   0,   0,   0, 254,   3,  62,  31, 255, 255, 127, 248, 255, 127,   0,   0,
    255,  31, 255, 255,   0,  12,   0,   0, 255, 127,   0, 128,   0,   0, 128, 255,
    252, 255, 255, 255, 255, 249, 255, 255, 124,   0,   0,   0, 187, 247, 255, 255,
      7,   0,   0,   0,   0,   0, 252, 104,  63,   0, 255, 255, 255, 255, 255,  31,
    255, 255,   7,   0,   0, 128,   0,   0, 223, 255,   0, 124, 247,  15,   0,   0,
    255, 255, 127, 196, 255, 255,  98,  62,   5,   0,   0,  56, 255,   7,  28,   0,
    126, 126, 126,   0, 127, 127, 255, 255, 255,   0, 255, 255,  15,   0, 255, 255,
    127, 248, 255, 255, 255, 255, 255,  15, 255,  63, 255, 255, 255, 255, 255,   3,
    127,   0, 248, 160, 255, 253, 127,  95, 219, 255, 255, 255,   0,   0, 248, 255,
    255, 255, 252, 255, 255,   0,   0,   0,   0,   0, 255,  15,   0,   0, 223, 255,
    192, 255, 255, 255, 252, 252, 252,  28, 255, 239, 255, 255, 127, 255, 255, 183,
    255,  63, 255,  63, 255, 255,   1,   0, 255,   7, 255, 255,  15, 255,  62,   0,
    255, 255,  15, 255,  63, 253, 255, 255, 255, 255, 191, 145, 255, 255,  55,   0,
    255, 255, 255, 192,   1,   0, 239, 254,  31,   0,   0,   0, 128,   0, 255, 255,
    255, 255, 255,   0,  16,   0, 255, 255, 255, 255,  71,   0,  30,   0,   0,  20,
    255, 255, 251, 255, 255,  15,   0,   0, 127, 189, 255, 191,   0,   0,   1, 224,
    128,   7,   0, 128, 176,   0,   0,   0,   0,   0,   0,  15,  16,   0,   0,   0,
    255,   7,   0,   1,   0,   0,   0, 128, 255, 252, 255, 255,  10,   0,   0,   0,
      1, 248, 255, 255, 255, 255,   7,   4,   0,   0,   1, 240, 255,   3,   0,  32,
    255, 253, 255, 255,   0,   0, 252, 255, 127, 251, 255, 255,  64,   0,   0,   0,
    191, 253, 255, 255, 255,   3,   0,   1, 255,  63,   0,   0, 248, 255, 255, 224,
    255,   7,   1,   0,  11,   0,   0,   0,   0,   0,   7,   0, 240,   0, 255, 255,
    255,   7, 255,  31, 255,   1, 255,   3, 255, 255, 223, 255, 255, 255, 255, 223,
    100, 222, 255, 235, 239, 255, 255, 255, 191, 231, 223, 223, 255, 255, 255, 123,
     95, 252, 253, 255,  63, 255, 255, 255, 253, 255, 255, 247, 255,  31, 128,  63,
      0,  64,   0,   0,  15,   8,   0,   0, 150, 254, 247,  10, 132, 234, 150, 170,
    150, 247, 247,  94, 255, 251, 255,  15, 238, 251, 255,  15,   3,   0, 255, 255,
};

/* ID_Start: 2496 bytes. */

RE_UINT32 re_get_id_start(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_id_start_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_id_start_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_id_start_stage_3[pos + f] << 5;
    pos += code;
    value = (re_id_start_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* ID_Continue. */

static RE_UINT8 re_id_continue_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20,  9,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 21, 22, 23,  5, 24, 25,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    26,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_id_continue_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  33,  31,  31,
     34,  35,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  36,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  37,
      1,   1,   1,   1,  38,   1,  39,  40,  41,  42,  43,  44,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  45,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  46,  47,   1,  48,  49,  50,
     51,  52,  53,  54,  55,  56,   1,  57,  58,  59,  60,  61,  62,  63,  31,  64,
     65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  31,  76,  77,  78,  31,
      1,   1,   1,  79,  80,  81,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  82,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  84,  85,  31,  31,  86,  87,
      1,   1,   1,   1,   1,   1,   1,  88,   1,   1,  89,  31,  31,  31,  31,  31,
      1,  90,  91,  31,  31,  31,  31,  31,  31,  31,  31,  31,  92,  31,  31,  31,
     31,  93,  94,  31,  95,  96,  97,  98,  31,  31,  99,  31,  31,  31,  31,  31,
    100, 101, 102,  31,  31,  31,  31,  31, 103, 104,  31,  31,  31,  31, 105,  31,
      1,   1,   1,   1,   1,   1, 106,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 107, 108,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 109,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 110,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 111,  31,  31,  31,  31,  31,
     31,  37,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_id_continue_stage_3[] = {
      0,   0,   0,   1,   2,   3,   2,   4,   0,   0,   5,   6,   7,   8,   7,   8,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   9,  10,  11,   0,
      7,   7,   7,   7,   7,   7,   7,  12,  13,   7,  14,   7,   7,   7,   7,  15,
      7,   7,   7,   7,   7,   7,   7,   7,  16,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   2,   7,  17,   7,   7,  18,   2,   7,  19,  20,   7,   3,  21,
      0,   4,   7,   7,   7,   7,  22,   7,   7,   7,   7,   7,   7,  23,  24,  25,
      0,   7,   7,   7,  26,   7,   7,   7,   7,   7,   7,  10,   7,   7,   7,  27,
      7,   7,  28,   0,   7,  29,   4,   0,   0,   0,   7,  30,   0,  31,  14,   7,
      7,   7,   7,   7,   7,   7,  32,   2,  23,  33,  24,  34,  35,  36,  32,  37,
     38,  33,  24,  39,  40,  41,  42,  43,  44,  14,  24,  45,  46,  47,  32,  48,
     49,  33,  24,  45,  50,  51,  32,  52,  53,  54,  55,  22,  56,  57,  42,   0,
     58,  59,  24,  60,  61,  62,  32,   0,  63,  59,  24,  64,  61,  65,  32,  66,
     63,  59,   7,   7,  67,  68,  32,  69,  70,  71,   7,  72,  73,  74,  42,  75,
      2,   7,   7,   4,  76,   1,   0,   0,  77,   7,  78,  28,  79,  80,   0,   0,
     47,  81,   1,  82,  83,   7,  84,   2,  85,  83,   7,  84,  86,   0,   0,   0,
      7,   7,   7,   7,   1,   7,   7,   7,   7,  28,   7,   7,  87,   7,   7,  88,
      7,   7,   7,   7,  89,  90,   7,   7,  89,   7,   7,  91,  92,   8,   7,   7,
      7,  92,   7,   7,   7,  26,  48,  10,   7,   0,   7,   7,   7,   7,   7,  93,
      2,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,  25,   7,   2,   4,   7,   7,   7,   7,  94,  18,
     58,  95,   7,  95,   7,  96,  58,  97,   7,   7,   7,   7,   7,  98,   1,   0,
     99,   1,   7,   7,   7,   7,   7,  18,   7,   7,   4,   7,   7,   7,   7,  43,
      7,  76,  29,  29,  42,   7,  28,  95,   7,   7,  29,   7,   1,   4,   0,   0,
      7,  29,   7,   7,   7,  76,   7,  25,   1,   1, 100,  28,   0,   0,   0,   0,
      7,   7,   7,   7,  29,   1, 101,  96,   7,   7,   7,   7,   7,   7,   7,  96,
      7,   7,   7, 102,  60,   7,   7,  28,  18,   7,   7,  26,   0, 103,   7,   4,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 104,
      7,  93,   7,   7,  93, 105,   7,  28,   7,   7,   7, 106, 107, 108,  84, 107,
      0,   0,   0, 109,  47, 110,   0, 111,   0,  84,   0,   0,   0,  84, 112,  47,
    113, 114, 115,  80, 116,   0,   7,   7,  18,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  76,   7,   7,  76,   7,   7,   7,   7,   7,   7,   7,   7, 117,  96,
      7,   7,  87,   7,   7,   7, 118, 109,   7, 119, 120, 120, 120, 120,   7,   7,
    121,   0,   2, 122,   2,   7,   7,   7,   7, 123,   2,   7,   7,   7,   7,  88,
    124,   7,   7,   2,   7,   7,   7,   7,  76,   0,   7,   4,   0,   0,   0,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  43,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   0,
      7,   7,   7,   7,   7,   7,   7,   7,  84,   0,   0,   0,   0,   7,   7,  28,
     84,   7,  29,   0,   7,   7,   7, 125,   7,   7,   7,   7,   7,   7,   7,  10,
      0, 126, 127,   7,   7,   7,   7,   7, 128,   7,   7,   7, 129,   0,   0, 126,
      7,   7, 102,   0,   7,   7,   7,  96,   7,   7,   7,   7,  43,   1,   7, 130,
      7,   7,  28,   7,   7,  96,   7,  84,   7,   7,   7,   7, 131,   1,   7,  76,
      7,   7,   7, 119,  28,   1,   7,  71,   7,   7,   7,   7,  21,  99,   7, 129,
    132, 133, 120,   7,   7,  88, 102,   7,   7,   7,   7,   7,   7,   7, 134,   1,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  96,   7, 135,   7,   7,  29,
      7,   7,   7,   7,   7,   7,  28,   7,   7,   7,   7,   7,   7,   1,   0,   0,
    119, 136,  24, 137, 138,   7,   7,   7,   7,   7,   7,  10,   0,  31,   7,   7,
      7,   7,   7,  28,   0,   7,   7,   7,   7, 127,   7,   7, 102,   0,   0,  29,
      7,   0,   7, 139, 140,   0,   0,  85,   7,   7,   7,   7,   7,   7,   7,  84,
      0,   1,   2,   3,   2,   4,  42,   7,   7,   7,   7,  76, 141, 142,   0,   0,
    143,   7,   8, 144,  28,  28,   0,   0,   7,   7,   7,   7,   7,   7,   7,   4,
      0,   0,   0,   0,   7,   7,   7,  95,   0,   0,   0,   0,   0,   0,   0, 145,
      0,   0,   0,   0,   0,   0,   0,   0,   7,  84,   7,   7,   7,  47,  47,   0,
      7,   7, 140,   7,   4,   7,   7,   4,   7,  28,   7,   7, 146, 147,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,  28,   1,   7,   7, 146,   7,  29,
      7,   7, 102,   7,   7,   7,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7, 119,   7,  43, 102,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    148,   7,   7, 149,   7,  43,   7, 119,   7,  76,   0,   0,   0,   0,   7, 150,
      7,  43,   7,   1,   0,   0,   0,   0,   7,   7,   7, 151,   0,   0,   0,   0,
    152, 153,   7, 154,   0,   0,   7,  84,   7,  84,   0,   0,  83,   7, 119,   0,
      7,   7,   7,  43,   7,  43,   7,  21,   7,  10,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,  18,   0,   0,   0,   7,   7,   7,  21,   7,   7,   7,  21,
      7,   7, 102,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,  84, 100,   7,   7,  47,   0,   0,   0,   0,   0,   0,   0,   0,   7, 119,
      7,   7,   7,   7, 119,   0,  42, 109,   7,   7,   7,   4,   0,   7,  18,   1,
      7,   7,   7,  85, 155,   7,   7, 156,   7,   7,   7,   7, 157, 158,   0,   0,
      7,  14,   7, 159,   0,   0,   0,   0, 160,  19,  18,   7,   7,   7,   4,   1,
     23,  33,  24, 161,  50, 162, 163,  95,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   4,  22,   0,   0,   7,   7,   7,   7, 164,   1,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   7,   7,   7, 165,  47, 166,   0,   0,
      7,   7,   7,   7, 167,   1,   0,   0,   7,   7,   7,  18,   1,   0,   0,   0,
      7,  26,  29,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   4,   0,   0,   0,   0,   0,   0,   7,   7,   7,   7,   1, 109,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 168,   7,   7, 168, 169,   0,
      7,   7,   7,  76, 100,   7,   7,   7,   7, 170,   0,   0,   7,   7,   7,  18,
     24,   7,   7,   8,  47,   1,   0, 127,   7, 127,  83, 119,   0,   0,   0,   0,
    171,   7,   7, 172, 102,   1, 173,   7,  76, 174,   1,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7, 119,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   1,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,  76,   0,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7, 119,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,  18,   7,  76,   1,   0,   0,   0,   0,   0,   0,   7,  28,  95,
      7,   7,   7, 119,  96,   1,  31, 175,   7,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   7,   7,   7,   7,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   3,   7,   7,   7, 118,   7,   0,   0,   0,   0, 176,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 102,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  21,
      7,  76,   0,   0,   0,  21, 177,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  29,
      7,   7,   7,   7,   7,   7,   4,  84,  18, 178,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 179, 180, 181,   0, 182,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 183,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,  85,   7,   7,   7,  58, 184, 185, 186,   7,   7,   7,
    187, 188,   7, 189, 190,  59,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 165,   7,  59,  88,   7,  88,
      7,  85,   7,  85,  76,   7,  76,   7,  24,   7,  24,   7, 191,   7,   7,   7,
      7,   7,   7, 135,   7,   7,  84, 192, 110, 101,   2,   0,   0,   0,   0,   0,
      8, 128, 193,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  84,  28, 194,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   7,   7,   1,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  95, 119,   0,   0,
      7,   7,   7,   7,  29,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    186,   7, 195, 196, 197, 198, 199, 200, 104,  29, 201,  29,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 119,   0,   0,
      7,   7,   7,  95,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,  28,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  10,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  47,   0,
      7,  28,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_id_continue_stage_4[] = {
      0,   0, 255,   3, 254, 255, 255, 135, 255,   7,   0,   4, 160,   4, 255, 255,
    127, 255, 195, 255,   3,   0,  31,  80, 223, 188, 192, 215, 251, 255, 191, 255,
    251, 252, 127,   2, 255,   1, 255, 191, 182,   0,   7,   0, 255, 195, 239, 159,
    255, 253, 255, 159, 255, 231,  63,  36, 255,  63, 255,  15, 223,  63, 248, 255,
    207, 255, 249, 255, 197, 243, 159, 121, 128, 176,   3,  80, 238, 135, 109, 211,
    135,  57,   2,  94, 192, 255,  63,   0, 238, 191, 237, 243, 191,  59,   1,   0,
      0, 254, 238, 159, 159,  57, 192, 176,   2,   0, 236, 199,  61, 214,  24, 199,
    199,  61, 129,   0, 255, 223, 253, 255, 255, 227, 223,  61,  96,   7, 239, 223,
    239, 243,  96,  64,   6,   0, 223, 125, 240, 128,   0, 252, 236, 255, 127, 252,
    251,  47, 127, 132,  95, 255,  12,   0, 255, 127, 214, 247, 175, 255,  95,  63,
    255, 243,   0,   3, 160, 194, 255, 254, 255,  31, 223, 255,  64,   0, 191,  32,
    255, 247, 255,  61, 127,  61,  61, 127,  61, 255,  63,  63, 255, 199,  31,   0,
     15,   0,  13,   0, 143,  48,   0,  56, 128,   0,   0, 248, 255,   0, 247, 255,
    255, 251, 255, 170, 223,  95, 220,  31, 207,  15,   0, 128,  16,   0,   2, 128,
    226, 255, 132, 252,  47,  63,  80, 253, 224,  67,  31, 248, 255, 128, 127,   0,
    127, 127, 224,   0,  62,  31, 127, 254, 224, 255, 240, 191, 128, 255, 252, 255,
    255, 249, 124,   0, 255, 232,   1, 128, 126, 126, 126,   0, 255,  55, 127, 248,
    248, 224, 127,  95, 219, 255,  24,   0,   0, 224, 252, 252, 252,  28, 255, 239,
    255, 183,   0,  32,  15, 255,  62,   0,  63, 253, 191, 145,  55,   0, 255, 192,
    111, 240, 239, 254,  63, 135, 112,   0,  79,   0,  31,  30, 255,  23, 255,  64,
    127, 189, 237, 251, 129, 224, 207,  31, 191,   0,  63, 255,   0,  63,  17,   0,
    255, 252,  27,   0, 255,  35, 127, 251, 127, 180, 191, 253, 251,   1, 255, 224,
     11,   0, 240,   0, 255,  99, 224, 227,   7, 248, 231,  15,   0,  60,  28,   0,
    100, 222, 255, 235, 239, 255, 191, 231, 223, 223, 255, 123,  95, 252, 247, 207,
     32,   0, 219,   7, 255,  67, 150, 254, 247,  10, 132, 234, 150, 170, 150, 247,
    247,  94, 238, 251,
};

/* ID_Continue: 2900 bytes. */

RE_UINT32 re_get_id_continue(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_id_continue_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_id_continue_stage_2[pos + f] << 4;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_id_continue_stage_3[pos + f] << 4;
    pos += code;
    value = (re_id_continue_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* XID_Start. */

static RE_UINT8 re_xid_start_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20,  9,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 21, 22, 23,  5, 24, 25,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_xid_start_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  33,  31,  31,
     34,  35,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  36,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  37,
      1,   1,   1,   1,  38,   1,  39,  40,  41,  42,  43,  44,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  45,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  46,  47,  48,  49,  50,  51,
     52,  53,  54,  55,  56,  57,   1,  58,  59,  60,  61,  62,  63,  64,  31,  65,
     66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  31,  77,  78,  79,  31,
      1,   1,   1,  80,  81,  82,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  84,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  85,  86,  31,  31,  87,  88,
      1,   1,   1,   1,   1,   1,   1,  89,   1,   1,  90,  31,  31,  31,  31,  31,
      1,  91,  92,  31,  31,  31,  31,  31,  31,  31,  31,  31,  93,  31,  31,  31,
     31,  31,  31,  31,  94,  95,  96,  97,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  98,  99,  31,  31,  31,  31,  31, 100, 101,  31,  31,  31,  31, 102,  31,
      1,   1,   1,   1,   1,   1, 103,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 104, 105,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 106,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 107,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 108,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_xid_start_stage_3[] = {
      0,   0,   1,   1,   0,   2,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   5,   6,   0,   0,   0,   7,   8,   9,   4,  10,
      4,   4,   4,   4,  11,   4,   4,   4,   4,  12,  13,   4,  14,   0,  15,  16,
      0,   4,  17,  18,   4,   4,  19,  20,  21,  22,  23,   4,   4,  24,  25,  26,
     27,  28,  29,  17,   0,  30,   0,   0,  31,  32,  33,  34,  35,  36,  37,  38,
     39,  40,  41,  42,  43,  44,  45,  46,  47,  44,  48,  49,  50,  51,  45,   0,
     52,  53,  54,  55,  56,  57,  58,  59,  52,  60,  61,  62,  63,  64,  65,   0,
     66,  67,  65,   0,  68,  69,  70,   0,  71,   0,  72,  73,  74,   0,   0,   0,
      4,  75,  76,  77,  78,   4,  79,  80,   4,   4,  81,   4,  82,  83,  84,   4,
     85,   4,  86,   0,  22,   4,   4,  87,  66,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,  88,   1,   4,   4,  89,  90,  91,  91,  92,   4,  93,  94,   0,
      0,   4,   4,  29,   4,  95,   4,  96,  97,   0,  15,  98,   4,  99, 100,   0,
    101,   4, 102,   0,   0, 103,   0,   0, 104,  93, 105,   0, 106, 107,   4, 108,
      4, 109, 110, 111, 112, 113,   0, 114,   4,   4,   4,   4,   4,   4,   0,   0,
     87,   4, 115, 111,   4, 116, 117, 118,   0,   0,   0, 119, 120,   0,   0,   0,
    121, 122, 123,   4,  14,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      4, 124,  97,   4,   4,   4,   4, 125,   4,  79,   4, 126, 101, 127, 127,   0,
    128, 129,  66,   4, 130,  66,   4,  80, 104,  12,   4,   4, 131,  86,   0,  15,
      4,   4,   4,   4,   4,  96,   0,   0,   4,   4,   4,   4,   4,   4,   4,  22,
      4,   4,   4,   4,  73,   0,  15, 111, 132, 133,   4, 134, 111,   4,   4,  22,
    135, 136,   4,   4, 137,   4, 138, 135, 139, 140,   4,  93, 136,  93,   0, 141,
     25, 142,  65, 143,  31, 144, 145, 146,   4,  14, 147, 148,   4, 149, 150, 151,
    152, 153,  80, 154,   4,   4,   4, 140,   4,   4,   4,   4,   4, 155, 156, 157,
      4,   4,   4, 158,   4,   4, 159,   0, 160, 161, 162,   4,   4,  91, 163,   4,
      4,   4, 111,  31,   4,   4,   4,   4,   4, 111,  15,   4, 164,   4, 165, 166,
      0,   0,   0, 167,   4,   4,   4, 143,   0,   1,   1, 168, 111,  97, 169,   0,
    170, 171, 172,   0,   4,   4,   4,  86,   0,   0,   4, 102,   0,   0,   0,   0,
      0,   0,   0,   0, 143,   4, 173,   0,   4,  23, 174,  96, 111,   4, 175,   0,
      4,   4,   4,   4, 111,  15, 176, 157,   4, 154,   4, 109,   0,   0,   0,   0,
      4, 101,  96, 165,   0,   0,   0,   0, 177, 178,  96, 101,  97,   0,   0, 179,
     96, 159,   0,   0,   4, 180,   0,   0, 181,  96,   0, 143, 143,   0,  72, 182,
      4,  96,  96, 144,  91,   0,   0,   0,   4,   4,  14,   0,   4, 144,   4, 144,
      4, 109,   0,   0,   0,   0,   0,   0, 143, 183, 108,   0,   0,   0,   0, 101,
    106, 184,   0,   0, 106,  22,  15,  14, 106,  65, 185, 186, 106, 144, 187,   0,
    188, 189,   0,   0, 190, 112,  97,   0,  47,  44, 191,  55,   0,   0,   0,   0,
      4, 102, 192,   0,   4,  22, 193,   0,   0,   0,   0,   0,   4, 131, 194,   0,
      4,  22, 195,   0,   4, 196,   0,   0,  86,   0,   0,   0,   0,   0,   0,   0,
      4, 189,   0,   0,   0,   4,   4, 197,   0,   0,   0,   0,   0, 198, 173, 199,
    200, 201, 202,   4, 203,   0,   4,  29, 204, 131,  71, 205,  22,   0,   0,   0,
    206, 173, 207, 208, 209,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 144,
      4,   4,   4,   4, 159,   0,   0,   0,   4,   4,   4, 131,   4,   4,   4,   4,
      4,   4, 109,   0,   0,   0,   0,   0,   4, 131,   0,   0,   0,   0,   0,   0,
      4,   4,  65,   0,   0,   0,   0,   0,   4,  29,  97,   0,   0,   0,  15, 210,
      4,  22, 109, 211,  22,   0,   0,   0,   0,   0,   4,   4,   0,   0,   0,   0,
      4,   4, 212,   0, 163,   0,   0, 213,   4,   4,   4,   4,   4,   4,   4, 184,
      4,   4,   4,   4,   4,   4,   4, 144,  97,   0, 214, 215,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4, 157,   4,   4,   4, 216, 217,   0,   0,   0,
      4,   4, 218,   4, 219, 220, 221,   4, 222, 223, 224,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4, 225, 226,  80, 218, 218, 124, 124, 204, 204, 147,   0,
      4, 227, 228,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4, 189,
      4,   4,   4,   4,   4,   4, 182,   0,   4,   4, 229,   0,   0,   0,   0,   0,
    221, 230, 231, 232, 233, 234,   0,   0,   4,   4,   4,   4,   4,   4, 101,   0,
      4, 102,   4,   4,   4,   4,   4,   4, 111,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4, 235,   4,   4,   4,   4,   4,   4,   4,   4,   4,  71,
    111,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_xid_start_stage_4[] = {
      0,   0,   0,   0, 254, 255, 255,   7,   0,   4,  32,   4, 255, 255, 127, 255,
    255, 255, 255, 255, 195, 255,   3,   0,  31,  80,   0,   0,   0,   0, 223, 184,
     64, 215, 255, 255, 251, 255, 255, 255, 255, 255, 191, 255,   3, 252, 255, 255,
    255, 255, 254, 255, 255, 255, 127,   2, 255,   1,   0,   0,   0,   0, 255, 255,
    255, 135,   7,   0, 255,   7,   0,   0,   0, 192, 254, 255, 255, 255,  47,   0,
     96, 192,   0, 156,   0,   0, 253, 255, 255, 255,   0,   0,   0, 224, 255, 255,
     63,   0,   2,   0,   0, 252, 255, 255, 255,   7,  48,   4, 255, 255,  63,   4,
     16,   1,   0,   0, 255, 255, 255,   1, 255, 255, 223,  63, 240, 255, 255, 255,
    255, 255, 255,  35,   0,   0,   1, 255,   3,   0, 254, 255, 225, 159, 249, 255,
    255, 253, 197,  35,   0,  64,   0, 176,   3,   0,   3,  16, 224, 135, 249, 255,
    255, 253, 109,   3,   0,   0,   0,  94,   0,   0,  28,   0, 224, 191, 251, 255,
    255, 253, 237,  35,   0,   0,   1,   0,   3,   0,   0,   2, 224, 159, 249, 255,
      0,   0,   0, 176,   3,   0,   2,   0, 232, 199,  61, 214,  24, 199, 255,   3,
    224, 223, 253, 255, 255, 253, 255,  35,   0,   0,   0,   7,   3,   0,   0,   0,
    225, 223, 253, 255, 255, 253, 239,  35,   0,   0,   0,  64,   3,   0,   6,   0,
    255, 255, 255,  39,   0,  64, 112, 128,   3,   0,   0, 252, 224, 255, 127, 252,
    255, 255, 251,  47, 127,   0,   0,   0, 254, 255, 255, 255, 255, 255,   5,   0,
    214, 247, 255, 255, 175, 255,   5,  32,  95,   0,   0, 240,   1,   0,   0,   0,
    255, 254, 255, 255, 255,  31,   0,   0,   0,  31,   0,   0, 255,   7,   0, 128,
      0,   0,  63,  60,  98, 192, 225, 255,   3,  64,   0,   0, 191,  32, 255, 255,
    255, 255, 255, 247, 255,  61, 127,  61, 255,  61, 255, 255, 255, 255,  61, 127,
     61, 255, 127, 255, 255, 255,  61, 255, 255, 255, 255,   7, 255, 255,  63,  63,
    255, 159, 255, 255, 255, 199, 255,   1, 255, 223,   3,   0, 255, 255,   3,   0,
    255, 223,   1,   0, 255, 255,  15,   0,   0,   0, 128,  16, 255,   5, 255, 255,
    255, 255,  63,   0, 255, 255, 255, 127, 255,  63,  31,   0, 255,  15, 255, 255,
    255,   3,   0,   0, 255, 255, 127,   0, 255, 255,  31,   0, 128,   0,   0,   0,
    224, 255, 255, 255, 224,  15,   0,   0, 248, 255, 255, 255,   1, 192,   0, 252,
     63,   0,   0,   0,  15,   0,   0,   0,   0, 224,   0, 252, 255, 255, 255,  63,
    255,   1, 255, 255, 255, 255, 255, 231,   0, 222, 111,   4,  63,  63, 255, 170,
    255, 255, 223,  95, 220,  31, 207,  15, 255,  31, 220,  31,   0,   0,   2, 128,
      0,   0, 255,  31, 132, 252,  47,  63,  80, 253, 255, 243, 224,  67,   0,   0,
    255, 127, 255, 255,  31, 120,  12,   0, 255, 128,   0,   0, 127, 127, 127, 127,
    224,   0,   0,   0, 254,   3,  62,  31, 255, 255, 127, 224, 255, 127,   0,   0,
    255,  31, 255, 255,   0,  12,   0,   0, 255, 127,   0, 128,   0,   0, 128, 255,
    252, 255, 255, 255, 255, 249, 255, 255, 124,   0,   0,   0, 187, 247, 255, 255,
      7,   0,   0,   0,   0,   0, 252, 104,  63,   0, 255, 255, 255, 255, 255,  31,
    255, 255,   7,   0,   0, 128,   0,   0, 223, 255,   0, 124, 247,  15,   0,   0,
    255, 255, 127, 196, 255, 255,  98,  62,   5,   0,   0,  56, 255,   7,  28,   0,
    126, 126, 126,   0, 127, 127, 255, 255, 255,   0, 255, 255,  15,   0, 255, 255,
    127, 248, 255, 255, 255, 255, 255,  15, 255,  63, 255, 255, 255, 255, 255,   3,
    127,   0, 248, 160, 255, 253, 127,  95, 219, 255, 255, 255,   0,   0, 248, 255,
    255, 255, 252, 255, 255,   0,   0,   0,   0,   0, 255,   3,   0,   0, 138, 170,
    192, 255, 255, 255, 252, 252, 252,  28, 255, 239, 255, 255, 127, 255, 255, 183,
    255,  63, 255,  63, 255, 255,   1,   0, 255,   7, 255, 255,  15, 255,  62,   0,
    255, 255,  15, 255,  63, 253, 255, 255, 255, 255, 191, 145, 255, 255,  55,   0,
    255, 255, 255, 192,   1,   0, 239, 254,  31,   0,   0,   0, 128,   0, 255, 255,
    255, 255, 255,   0,  16,   0, 255, 255, 255, 255,  71,   0,  30,   0,   0,  20,
    255, 255, 251, 255, 255,  15,   0,   0, 127, 189, 255, 191,   0,   0,   1, 224,
    128,   7,   0, 128, 176,   0,   0,   0,   0,   0,   0,  15,  16,   0,   0,   0,
    255,   7,   0,   1,   0,   0,   0, 128, 255, 252, 255, 255,  10,   0,   0,   0,
      1, 248, 255, 255, 255, 255,   7,   4,   0,   0,   1, 240, 255,   3,   0,  32,
    255, 253, 255, 255,   0,   0, 252, 255, 127, 251, 255, 255,  64,   0,   0,   0,
    191, 253, 255, 255, 255,   3,   0,   1, 255,  63,   0,   0, 248, 255, 255, 224,
    255,   7,   1,   0,  11,   0,   0,   0,   0,   0,   7,   0, 240,   0, 255, 255,
    255,   7, 255,  31, 255,   1, 255,   3, 255, 255, 223, 255, 255, 255, 255, 223,
    100, 222, 255, 235, 239, 255, 255, 255, 191, 231, 223, 223, 255, 255, 255, 123,
     95, 252, 253, 255,  63, 255, 255, 255, 253, 255, 255, 247, 255,  31, 128,  63,
      0,  64,   0,   0,  15,   8,   0,   0, 150, 254, 247,  10, 132, 234, 150, 170,
    150, 247, 247,  94, 255, 251, 255,  15, 238, 251, 255,  15,   3,   0, 255, 255,
};

/* XID_Start: 2504 bytes. */

RE_UINT32 re_get_xid_start(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_xid_start_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_xid_start_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_xid_start_stage_3[pos + f] << 5;
    pos += code;
    value = (re_xid_start_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* XID_Continue. */

static RE_UINT8 re_xid_continue_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20,  9,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 21, 22, 23,  5, 24, 25,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    26,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_xid_continue_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  33,  31,  31,
     34,  35,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  36,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  37,
      1,   1,   1,   1,  38,   1,  39,  40,  41,  42,  43,  44,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  45,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  46,  47,  48,  49,  50,  51,
     52,  53,  54,  55,  56,  57,   1,  58,  59,  60,  61,  62,  63,  64,  31,  65,
     66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  31,  77,  78,  79,  31,
      1,   1,   1,  80,  81,  82,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  84,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  85,  86,  31,  31,  87,  88,
      1,   1,   1,   1,   1,   1,   1,  89,   1,   1,  90,  31,  31,  31,  31,  31,
      1,  91,  92,  31,  31,  31,  31,  31,  31,  31,  31,  31,  93,  31,  31,  31,
     31,  94,  95,  31,  96,  97,  98,  99,  31,  31, 100,  31,  31,  31,  31,  31,
    101, 102, 103,  31,  31,  31,  31,  31, 104, 105,  31,  31,  31,  31, 106,  31,
      1,   1,   1,   1,   1,   1, 107,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 108, 109,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 110,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 111,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 112,  31,  31,  31,  31,  31,
     31,  37,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_xid_continue_stage_3[] = {
      0,   0,   0,   1,   2,   3,   2,   4,   0,   0,   5,   6,   7,   8,   7,   8,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   9,  10,  11,   0,
      7,   7,   7,   7,   7,   7,   7,  12,  13,   7,  14,   7,   7,   7,   7,  15,
      7,   7,   7,   7,   7,   7,   7,   7,  16,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   2,   7,  17,   7,   7,  18,   2,   7,  19,  20,   7,   3,  21,
      0,   4,   7,   7,   7,   7,  22,   7,   7,   7,   7,   7,   7,  23,  24,  25,
      0,   7,   7,   7,  26,   7,   7,   7,   7,   7,   7,  10,   7,   7,   7,  27,
      7,   7,  28,   0,   7,  29,   4,   0,   0,   0,   7,  30,   0,  31,  14,   7,
      7,   7,   7,   7,   7,   7,  32,   2,  23,  33,  24,  34,  35,  36,  32,  37,
     38,  33,  24,  39,  40,  41,  42,  43,  44,  14,  24,  45,  46,  47,  32,  48,
     49,  33,  24,  45,  50,  51,  32,  52,  53,  54,  55,  22,  56,  57,  42,   0,
     58,  59,  24,  60,  61,  62,  32,   0,  63,  59,  24,  64,  61,  65,  32,  66,
     63,  59,   7,   7,  67,  68,  32,  69,  70,  71,   7,  72,  73,  74,  42,  75,
      2,   7,   7,   4,  76,   1,   0,   0,  77,   7,  78,  28,  79,  80,   0,   0,
     47,  81,   1,  82,  83,   7,  84,   2,  85,  83,   7,  84,  86,   0,   0,   0,
      7,   7,   7,   7,   1,   7,   7,   7,   7,  28,   7,   7,  87,   7,   7,  88,
      7,   7,   7,   7,  89,  90,   7,   7,  89,   7,   7,  91,  92,   8,   7,   7,
      7,  92,   7,   7,   7,  26,  48,  10,   7,   0,   7,   7,   7,   7,   7,  93,
      2,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,  25,   7,   2,   4,   7,   7,   7,   7,  94,  18,
     58,  95,   7,  95,   7,  96,  58,  97,   7,   7,   7,   7,   7,  98,   1,   0,
     99,   1,   7,   7,   7,   7,   7,  18,   7,   7,   4,   7,   7,   7,   7,  43,
      7,  76,  29,  29,  42,   7,  28,  95,   7,   7,  29,   7,   1,   4,   0,   0,
      7,  29,   7,   7,   7,  76,   7,  25,   1,   1, 100,  28,   0,   0,   0,   0,
      7,   7,   7,   7,  29,   1, 101,  96,   7,   7,   7,   7,   7,   7,   7,  96,
      7,   7,   7, 102,  60,   7,   7,  28,  18,   7,   7,  26,   0, 103,   7,   4,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 104,
      7,  93,   7,   7,  93, 105,   7,  28,   7,   7,   7, 106, 107, 108,  84, 107,
      0,   0,   0, 109,  47, 110,   0, 111,   0,  84,   0,   0,   0,  84, 112,  47,
    113, 114, 115,  80, 116,   0,   7,   7,  18,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  76,   7,   7,  76,   7,   7,   7,   7,   7,   7,   7,   7, 117,  96,
      7,   7,  87,   7,   7,   7, 118, 109,   7, 119, 120, 120, 120, 120,   7,   7,
    121,   0,   2, 122,   2,   7,   7,   7,   7, 123,   2,   7,   7,   7,   7,  88,
    124,   7,   7,   2,   7,   7,   7,   7,  76,   0,   7,   4,   0,   0,   0,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  43,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   0,
      7,   7,   7,   7,   7,   7,   7,   7,  84,   0,   0,   0,   0,   7,   7,  28,
     84,   7,  29,   0,   7,   7,   7, 125,   7,   7,   7,   7,   7,   7,   7,  10,
      0, 126, 127,   7,   7,   7,   7,   7, 128,   7,   7,   7, 129,   0,   0, 126,
      7,   7, 102,   0,   7,   7,   7,  96,   7,   7,   7,   7,  43,   1,   7, 130,
      7,   7,  28,   7,   7,  96,   7,  84,   7,   7,   7,   7, 131,   1,   7,  76,
      7,   7,   7, 119,  28,   1,   7,  71,   7,   7,   7,   7,  21,  99,   7, 129,
    132, 133, 120,   7,   7,  88, 102,   7,   7,   7,   7,   7,   7,   7, 134,   1,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  96,   7, 135,   7,   7,  29,
      7,   7,   7,   7,   7,   7,  28,   7,   7,   7,   7,   7,   7,   1,   0,   0,
    119, 136,  24, 137, 138,   7,   7,   7,   7,   7,   7,  10,   0,  31,   7,   7,
      7,   7,   7,   7,   7,  28, 139,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,  28,   0,   7,   7,   7,   7, 127,   7,   7, 102,   0,   0,   1,
      7,   0,   7, 140, 141,   0,   0, 142,   7,   7,   7,   7,   7,   7,   7,  84,
      0,   1,   2,   3,   2,   4,  42,   7,   7,   7,   7,  76, 143, 144,   0,   0,
    145,   7,   8, 146,  28,  28,   0,   0,   7,   7,   7,   7,   7,   7,   7,   4,
      0,   0,   0,   0,   7,   7,   7,  95,   0,   0,   0,   0,   0,   0,   0, 147,
      0,   0,   0,   0,   0,   0,   0,   0,   7,  84,   7,   7,   7,  47,  47,   0,
      7,   7, 141,   7,   4,   7,   7,   4,   7,  28,   7,   7, 148, 149,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,  28,   1,   7,   7, 148,   7,  29,
      7,   7, 102,   7,   7,   7,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7, 119,   7,  43, 102,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    150,   7,   7, 151,   7,  43,   7, 119,   7,  76,   0,   0,   0,   0,   7, 152,
      7,  43,   7,   1,   0,   0,   0,   0,   7,   7,   7, 153,   0,   0,   0,   0,
    154, 155,   7, 156,   0,   0,   7,  84,   7,  84,   0,   0,  83,   7, 119,   0,
      7,   7,   7,  43,   7,  43,   7,  21,   7,  10,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,  18,   0,   0,   0,   7,   7,   7,  21,   7,   7,   7,  21,
      7,   7, 102,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,  84, 100,   7,   7,  47,   0,   0,   0,   0,   0,   0,   0,   0,   7, 119,
      7,   7,   7,   7, 119,   0,  42, 109,   7,   7,   7,   4,   0,   7,  18,   1,
      7,   7,   7,  85, 157,   7,   7, 158,   7,   7,   7,   7, 159, 160,   0,   0,
      7,  14,   7, 161,   0,   0,   0,   0, 162,  19,  18,   7,   7,   7,   4,   1,
     23,  33,  24, 163,  50, 164, 165,  95,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   4,  22,   0,   0,   7,   7,   7,   7, 166,   1,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   7,   7,   7, 167,  47, 168,   0,   0,
      7,   7,   7,   7, 169,   1,   0,   0,   7,   7,   7,  18,   1,   0,   0,   0,
      7,  26,  29,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   4,   0,   0,   0,   0,   0,   0,   7,   7,   7,   7,   1, 109,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 170,   7,   7, 170, 171,   0,
      7,   7,   7,  76, 100,   7,   7,   7,   7, 172,   0,   0,   7,   7,   7,  18,
     24,   7,   7,   8,  47,   1,   0, 127,   7, 127,  83, 119,   0,   0,   0,   0,
    173,   7,   7, 174, 102,   1, 175,   7,  76, 176,   1,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7, 119,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   1,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,  76,   0,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  76,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7, 119,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,  18,   7,  76,   1,   0,   0,   0,   0,   0,   0,   7,  28,  95,
      7,   7,   7, 119,  96,   1,  31, 177,   7,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   7,   7,   7,   7,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   3,   7,   7,   7, 118,   7,   0,   0,   0,   0, 178,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 102,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  21,
      7,  76,   0,   0,   0,  21, 179,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  29,
      7,   7,   7,   7,   7,   7,   4,  84,  18, 180,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 181, 182, 183,   0, 184,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 185,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,  85,   7,   7,   7,  58, 186, 187, 188,   7,   7,   7,
    189, 190,   7, 191, 192,  59,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 167,   7,  59,  88,   7,  88,
      7,  85,   7,  85,  76,   7,  76,   7,  24,   7,  24,   7, 193,   7,   7,   7,
      7,   7,   7, 135,   7,   7,  84, 194, 110, 101,   2,   0,   0,   0,   0,   0,
      8, 128, 195,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  84,  28, 196,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   7,   7,   1,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  95, 119,   0,   0,
      7,   7,   7,   7,  29,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    188,   7, 197, 198, 199, 200, 201, 202, 104,  29, 203,  29,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 119,   0,   0,
      7,   7,   7,  95,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,  28,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  10,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  47,   0,
      7,  28,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_xid_continue_stage_4[] = {
      0,   0, 255,   3, 254, 255, 255, 135, 255,   7,   0,   4, 160,   4, 255, 255,
    127, 255, 195, 255,   3,   0,  31,  80, 223, 184, 192, 215, 251, 255, 191, 255,
    251, 252, 127,   2, 255,   1, 255, 191, 182,   0,   7,   0, 255, 195, 239, 159,
    255, 253, 255, 159, 255, 231,  63,  36, 255,  63, 255,  15, 223,  63, 248, 255,
    207, 255, 249, 255, 197, 243, 159, 121, 128, 176,   3,  80, 238, 135, 109, 211,
    135,  57,   2,  94, 192, 255,  63,   0, 238, 191, 237, 243, 191,  59,   1,   0,
      0, 254, 238, 159, 159,  57, 192, 176,   2,   0, 236, 199,  61, 214,  24, 199,
    199,  61, 129,   0, 255, 223, 253, 255, 255, 227, 223,  61,  96,   7, 239, 223,
    239, 243,  96,  64,   6,   0, 223, 125, 240, 128,   0, 252, 236, 255, 127, 252,
    251,  47, 127, 132,  95, 255,  12,   0, 255, 127, 214, 247, 175, 255,  95,  63,
    255, 243,   0,   3, 160, 194, 255, 254, 255,  31, 223, 255,  64,   0, 191,  32,
    255, 247, 255,  61, 127,  61,  61, 127,  61, 255,  63,  63, 255, 199,  31,   0,
     15,   0,  13,   0, 143,  48,   0,  56, 128,   0,   0, 248, 255,   0, 247, 255,
    255, 251, 255, 170, 223,  95, 220,  31, 207,  15,   0, 128,  16,   0,   2, 128,
    226, 255, 132, 252,  47,  63,  80, 253, 224,  67,  31, 248, 255, 128, 127,   0,
    127, 127, 224,   0,  62,  31, 127, 230, 224, 255, 240, 191, 128, 255, 252, 255,
    255, 249, 124,   0, 255, 232,   1, 128, 126, 126, 126,   0, 255,  55, 127, 248,
    248, 224, 127,  95, 219, 255, 240, 255,  24,   0,   0, 224, 138, 170, 252, 252,
    252,  28, 255, 239, 255, 183,   0,  32,  15, 255,  62,   0,  63, 253, 191, 145,
     55,   0, 255, 192, 111, 240, 239, 254,  63, 135, 112,   0,  79,   0,  31,  30,
    255,  23, 255,  64, 127, 189, 237, 251, 129, 224, 207,  31, 191,   0,  63, 255,
      0,  63,  17,   0, 255, 252,  27,   0, 255,  35, 127, 251, 127, 180, 191, 253,
    251,   1, 255, 224,  11,   0, 240,   0, 255,  99, 224, 227,   7, 248, 231,  15,
      0,  60,  28,   0, 100, 222, 255, 235, 239, 255, 191, 231, 223, 223, 255, 123,
     95, 252, 247, 207,  32,   0, 219,   7, 255,  67, 150, 254, 247,  10, 132, 234,
    150, 170, 150, 247, 247,  94, 238, 251,
};

/* XID_Continue: 2920 bytes. */

RE_UINT32 re_get_xid_continue(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_xid_continue_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_xid_continue_stage_2[pos + f] << 4;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_xid_continue_stage_3[pos + f] << 4;
    pos += code;
    value = (re_xid_continue_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Default_Ignorable_Code_Point. */

static RE_UINT8 re_default_ignorable_code_point_stage_1[] = {
    0, 1, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 4, 5, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_default_ignorable_code_point_stage_2[] = {
     0,  1,  2,  3,  2,  2,  2,  2,  4,  2,  2,  5,  6,  2,  2,  2,
     7,  2,  2,  2,  2,  2,  2,  2,  8,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  9,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 10,  2,
     2,  2,  2,  2,  2,  2,  2,  2, 11,  2,  2,  2,  2,  2,  2,  2,
    12, 12, 12, 12, 12, 12, 12, 12,  2,  2,  2,  2,  2,  2,  2,  2,
};

static RE_UINT8 re_default_ignorable_code_point_stage_3[] = {
     0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,
     6,  0,  0,  0,  0,  0,  0,  0,  7,  8,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  9,  0,  0, 10,  0,  0, 11,  0,  0, 12, 13,
     0,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 15,  0,  0,
    16, 16, 16, 16, 16, 16, 16, 16,
};

static RE_UINT8 re_default_ignorable_code_point_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,   0,   0,
      0, 128,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,
      0,   0,   0, 128,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,  48,   0,
      0, 120,   0,   0,   0,   0,   0,   0,   0, 248,   0,   0,   0, 124,   0,   0,
      0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,
    255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,
      0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   1,
      0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,   0,   0, 248,   7,
    255, 255, 255, 255, 255, 255, 255, 255,
};

/* Default_Ignorable_Code_Point: 488 bytes. */

RE_UINT32 re_get_default_ignorable_code_point(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_default_ignorable_code_point_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_default_ignorable_code_point_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_default_ignorable_code_point_stage_3[pos + f] << 6;
    pos += code;
    value = (re_default_ignorable_code_point_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Grapheme_Extend. */

static RE_UINT8 re_grapheme_extend_stage_1[] = {
     0,  1,  2,  2,  2,  3,  2,  4,  5,  2,  2,  6,  2,  7,  8,  9,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    10,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,
};

static RE_UINT8 re_grapheme_extend_stage_2[] = {
     0,  0,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,
    14,  0,  0, 15,  0,  0,  0, 16, 17, 18, 19, 20, 21, 22,  0,  0,
    23,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 24, 25,  0,  0,
    26,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 27,  0, 28, 29, 30, 31,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0, 33, 34,
     0, 35, 36, 37,  0,  0,  0,  0,  0,  0, 38,  0,  0, 39,  0, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,  0, 52, 53, 54,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 55, 56,  0,  0,  0, 57,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 59, 60,  0,  0,  0,  0,  0,  0,  0, 61,  0,  0,  0,  0,  0,
    62, 56, 63,  0,  0,  0,  0,  0, 64, 65,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    66, 67,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_grapheme_extend_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   4,   5,   6,   0,
      7,   0,   8,   9,   0,   0,  10,  11,  12,  13,  14,   0,   0,  15,   0,  16,
     17,  18,  19,   0,   0,   0,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,  31,  32,  33,  30,  31,  34,  35,  26,  36,  37,  25,  38,  39,  40,   0,
     41,  42,  43,  25,  26,  44,  45,  25,  46,  47,  28,  25,   0,   0,  48,   0,
      0,  49,  50,   0,   0,  51,  52,   0,  53,  54,   0,  55,  56,  57,  58,   0,
      0,  59,  60,  61,  62,   0,   0,   0,   0,   0,  63,   0,   0,   0,   0,   0,
     64,  64,  65,  65,   0,  66,  67,   0,  68,   0,   0,   0,  69,  70,   0,   0,
      0,  71,   0,   0,   0,   0,   0,   0,  72,   0,  73,  74,   0,  75,   0,   0,
     76,  77,  38,  78,  46,  79,   0,  80,   0,  81,   0,   0,   0,   0,  82,  83,
      0,   0,   0,   0,   0,   0,   1,  84,  85,   0,   0,   0,   0,   0,  13,  86,
      0,   0,   0,   0,   0,   0,   0,  87,   0,   0,   0,  88,   0,   0,   0,   1,
      0,  89,   0,   0,  90,   0,   0,   0,   0,   0,   0,  91,  42,   0,   0,  92,
     93,  69,   0,   0,   0,   0,  94,  95,   0,  96,  97,   0,  22,  98,   0,  99,
      0, 100, 101,  31,   0, 102,  26, 103,   0,   0,   0,   0,   0,   0,   0, 104,
     39,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  42,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 105,
      0,   0,   0,   0,   0,   0,   0, 106,   0,   0,   0, 107,   0,   0,   0,   0,
    108, 109,   0,   0,   0,   0,   0,  69,   0, 110,   0,   0,   0,   0,   0,   0,
      0,   0,  15,   0,   0,   0,   0,   0,  26, 111, 112,  88,  46, 113,   0,   0,
     22, 114,   0, 115,  46, 116, 117,   0,   0, 118,   0,   0,   0,   0,  88, 119,
     46,  47, 120, 121,   0,   0,   0,   0,   0, 111, 122,   0,   0, 123, 124,   0,
      0,   0,   0,   0,   0, 125, 126,   0,   0, 127, 106,   0,   0, 128,   0,   0,
     63, 129,   0,   0,   0,   0,   0,   0,   0, 130,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 131, 106, 132, 133, 134,   0, 135,   0,   0,   0,
      0, 136,   0,   0, 137, 138,   0,   0,   0, 139, 140,   0, 141,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 142,   0,   0,   0,   0,   0,   0,   0, 143,
      0, 144,   0,   0,   0,   0,   0,   0,   0,   0, 145,   0, 146,   0,   0,   0,
      0,   0,   0,   0, 147,   0,   0,   0,   0,   0,   0, 148, 149, 150,   0,   0,
      0,   0, 151,   0,   0,   0,   0,   0,   1, 152,   1, 153, 154, 155,   0,   0,
    156, 157,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 158,
      0,   0,   0,   0,   0,   0, 144,   0,   0,   0, 159,   0,   0,   0,   0,   0,
      0,   1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   2,
};

static RE_UINT8 re_grapheme_extend_stage_4[] = {
      0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 248,   3,   0,   0,
      0,   0, 254, 255, 255, 255, 255, 191, 182,   0,   0,   0,   0,   0, 255,   7,
      0, 248, 255, 255,   0,   0,   1,   0,   0,   0, 192, 159, 159,  61,   0,   0,
      0,   0,   2,   0,   0,   0, 255, 255, 255,   7,   0,   0, 192, 255,   1,   0,
      0, 248,  15,  32,   0,   0, 192, 251, 239,  62,   0,   0,   0,   0,   0,  14,
      0,   0, 248, 255, 251, 255, 255, 255,   7,   0,   0,   0,   0,   0,   0,  20,
    254,  33, 254,   0,  12,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,  80,
     30,  32, 128,   0,  12,   0,   0,  64,   6,   0,   0,   0,   0,   0,   0,  16,
    134,  57,   2,   0,   0,   0,  35,   0, 190,  33,   0,   0,  12,   0,   0, 252,
      0,   0,   0, 208,  30,  32, 192,   0,   4,   0,   0,   0,   0,   0,   0,  64,
      1,  32, 128,   0,  17,   0,   0,   0,   0,   0,   0, 192, 193,  61,  96,   0,
      0,   0,   0, 144,  68,  48,  96,   0,   3,   0,   0,   0,   0,   0,   0,  88,
      0, 132,  92, 128,   0,   0, 242,   7, 128, 127,   0,   0,   0,   0, 242,  31,
      0,  63,   0,   0,   0,   0,   0,   3,   0,   0, 160,   2,   0,   0, 254, 127,
    223, 224, 255, 254, 255, 255, 255,  31,  64,   0,   0,   0,   0, 224, 253, 102,
      0,   0,   0, 195,   1,   0,  30,   0, 100,  32,   0,  32,   0,   0,   0, 224,
      0,   0,  28,   0,   0,   0,  12,   0,   0,   0, 176,  63,  64, 254,  15,  32,
      0,  56,   0,   0,  96,   0,   0,   0,   0,   2,   0,   0, 135,   1,   4,  14,
      0,   0, 128,   9,   0,   0,  64, 127, 229,  31, 248, 159,   0,   0, 255, 127,
     15,   0,   0,   0,   0,   0, 240,  23,   0, 248,  15,   0,  60,  59,   0,   0,
     64, 163,   3,   0,   0, 240, 207,   0,   0,   0, 247, 255, 253,  33,  16,   3,
    255, 255, 255, 251,   0,  16,   0,   0, 255, 255,   1,   0,   0, 128,   3,   0,
      0,   0,   0, 128,   0, 252,   0,   0,   0,   0,   0,   6,   0, 128, 247,  63,
      0,   0,   3,   0,  68,   8,   0,   0,  48,   0,   0,   0, 255, 255,   3, 128,
    192,  63,   0,   0, 128, 255,   3,   0,   0,   0, 200,  51,  32,   0,   0,   0,
      0, 126, 102,   0,   8,  16,   0,   0,   0,   0, 157, 193,   0,  48,  64,   0,
     32,  33,   0,   0,   0,   0,   0,  32,   1,   0,   0,   0,   0,   0, 192,   7,
    110, 240,   0,   0,   0,   0,   0, 135, 240,   0,   0,   0,   0,   0,   0, 255,
    127,   0,   0,   0,   0,   0, 120,   6, 128, 239,  31,   0,   0,   0,   8,   0,
      0,   0, 192, 127,   0,  30,   0,   0,   0, 128, 211,  64, 248,   7,   0,   0,
      1,   0, 128,   0, 192,  31,  31,   0,  92,   0,   0,  64,   0,   0, 249, 165,
     13,   0,   0,   0,   0, 128,  60, 176,   1,   0,   0,  48,   0,   0, 248, 167,
      0,  40, 191,   0, 188,  15,   0,   0,   0, 128, 255,   6,   0,   0, 240,  12,
    254,   7,   0,   0,   0,   0, 248, 121, 128,   0, 126,  14,   0, 252, 127,   3,
      0,   0, 127, 191,   0,   0, 252, 255, 255, 252, 109,   0,   0,   0, 126, 180,
    191,   0,   0,   0,   0,   0, 163,   0,   0,   0,  24,   0,   0,   0,  31,   0,
      0,   0, 127,   0,   0, 128,   0,   0,   0, 128,   7,   0,   0,   0,   0,  96,
    160, 195,   7, 248, 231,  15,   0,   0,   0,  60,   0,   0,  28,   0,   0,   0,
    255, 255, 127, 248, 255,  31,  32,   0,  16,   0,   0, 248, 254, 255,   0,   0,
    127, 255, 255, 249, 219,   7,   0,   0,   0, 240,   0,   0, 240,   7,   0,   0,
};

/* Grapheme_Extend: 1672 bytes. */

RE_UINT32 re_get_grapheme_extend(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_grapheme_extend_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_grapheme_extend_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_grapheme_extend_stage_3[pos + f] << 5;
    pos += code;
    value = (re_grapheme_extend_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Grapheme_Base. */

static RE_UINT8 re_grapheme_base_stage_1[] = {
    0, 1, 2, 3, 4, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6,
};

static RE_UINT8 re_grapheme_base_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 13, 13,
    13, 13, 13, 14, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 15, 13, 16, 17, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 18, 19, 19, 19, 19, 19, 19, 19, 19, 20, 21,
    22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 19, 19, 13, 32, 19, 19,
    19, 33, 19, 19, 19, 19, 19, 19, 19, 19, 34, 35, 13, 13, 13, 13,
    13, 36, 37, 19, 19, 19, 19, 19, 19, 19, 19, 19, 38, 19, 19, 39,
    19, 19, 19, 19, 40, 41, 42, 19, 43, 19, 44, 45, 46, 47, 48, 19,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 49, 13, 13, 13, 50, 51, 13,
    13, 13, 13, 52, 13, 13, 13, 13, 13, 13, 53, 19, 19, 19, 54, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
};

static RE_UINT8 re_grapheme_base_stage_3[] = {
      0,   1,   2,   2,   2,   2,   3,   4,   2,   5,   6,   7,   8,   9,  10,  11,
     12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,
     28,  29,   2,   2,  30,  31,  32,  33,   2,   2,   2,   2,   2,  34,  35,  36,
     37,  38,  39,  40,  41,  42,  43,  44,  45,  46,   2,  47,   2,   2,  48,  49,
     50,  51,   2,  52,   2,   2,   2,   2,  53,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,  54,  55,  56,  57,  58,  59,  60,  61,   2,  62,
     63,  64,  65,  66,  67,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,  68,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  69,
      2,  70,   2,   2,  71,  72,   2,  73,  74,  75,  76,  77,  78,  79,  80,  81,
      2,   2,   2,   2,   2,   2,   2,  82,  83,  83,  83,  83,  83,  83,  83,  83,
     83,  83,   2,   2,  84,  85,  86,  87,   2,   2,  88,  89,  90,  91,  92,  93,
     94,  95,  96,  97,  83,  98,  99, 100,   2, 101, 102,  83,   2,   2, 103,  83,
    104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,  83, 115,  83, 116, 117,
    118, 119, 120, 121, 122, 123, 124,  83, 125, 126,  83, 127, 128, 129, 130,  83,
    131, 132,  83, 133, 134, 135,  83,  83, 136, 137, 138, 139,  83, 140,  83, 141,
      2,   2,   2,   2,   2,   2,   2, 142, 143,   2, 144,  83,  83,  83,  83,  83,
    145,  83,  83,  83,  83,  83,  83,  83,   2,   2,   2,   2, 146,  83,  83,  83,
      2,   2,   2,   2, 147, 148, 149, 150,  83,  83,  83,  83, 151, 152, 153, 154,
      2,   2,   2,   2,   2,   2,   2, 155,   2,   2,   2,   2,   2, 156,  83,  83,
      2,   2, 157,   2,   2, 158,  83,  83, 159, 160,  83,  83,  83,  83,  83,  83,
      2, 161, 162, 163, 164, 165, 166,  83, 167, 168, 169,   2,   2, 170,   2, 171,
      2,   2,   2,   2, 172, 173,  83,  83,  83,  83, 174,  83,  83, 175,  83,  83,
      2, 176, 177,  83,  83,  83,  83,  83, 178, 179, 180,  83, 181, 182,  83,  83,
    183, 184, 185, 186, 187,  83,   2,   2,   2,   2,   2,   2,   2, 188, 189, 190,
    191, 192, 193, 194, 195, 196,  83,  83,   2,   2,   2,   2,   2, 197,   2,   2,
      2,   2,   2,   2,   2,   2, 198,   2, 199,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2, 200,   2,   2,   2,   2,   2,   2,   2,   2,   2, 201,
      2,   2,   2,   2, 202,  83,  83,  83,
};

static RE_UINT8 re_grapheme_base_stage_4[] = {
      0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127,
      0,   0,   0,   0, 255, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 252,
    240, 215, 255, 255, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
      7, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 254, 255, 255, 255, 127, 254, 255, 255, 255, 255,
    255, 231,   0,   0,   0,   0,   0,  64,  73,   0, 255, 255, 255, 135,  31,   0,
    192, 255,   0, 200, 255, 255, 255, 255, 255,   7,   0,   0, 255, 255, 254, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63,  64,  96, 194, 255, 255,
    255,  63, 253, 255, 255, 255,   0,   0,   0, 224, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255,  63,   0,   2,   0, 255, 255, 255, 255, 255,   7, 240, 199,
    255, 255,  63,   4,  16,   1, 255, 127, 255, 255, 255,  65, 255,   7,   0,   0,
      0,   0,   0,   0, 255, 255, 223,  63,   0,   0,   0,   0,   0,   0,   0,   0,
    248, 255, 255, 255, 255, 255, 255, 235,   1, 222,   1, 255, 243, 255, 255, 255,
    237, 159, 249, 255, 255, 253, 197, 163, 129,  89,   0, 176, 195, 255, 255,  63,
    232, 135, 249, 255, 255, 253, 109, 195,   1,   0,   0,  94, 192, 255,  92,   0,
    232, 191, 251, 255, 255, 253, 237, 227,   1,  26,   1,   0, 195, 255,   3,   2,
    236, 159, 249, 255, 255, 253, 237,  35, 129,  25,   0, 176, 195, 255, 255,   0,
    232, 199,  61, 214,  24, 199, 255, 131, 198,  29,   1,   0, 192, 255, 255,   7,
    238, 223, 253, 255, 255, 253, 255,  35,  30,   0,   0,   7, 195, 255, 128, 255,
    253, 223, 253, 255, 255, 253, 239,  99, 155,  13,   0,  64, 195, 255,   6,   0,
    236, 223, 253, 255, 255, 255, 255, 167, 193, 221, 112, 255, 195, 255, 255, 255,
    236, 255, 127, 252, 255, 255, 251,  47, 127,   0,   3, 127, 192, 255,  28,   0,
    254, 255, 255, 255, 255, 255,  13, 128, 127, 128, 255,  15,   0,   0,   0,   0,
    214, 247, 255, 255, 175, 255,  13,  32,  95,   0, 255, 243,   0,   0,   0,   0,
    255, 255, 255, 252, 255, 255,  95, 253, 255, 254, 255, 255, 255,  31,   0, 128,
     32,  31,   0,   0,   0,   0,   0, 192, 191, 223, 255,   7,   0,   0,   0,   0,
    255, 255, 255, 255, 255,  31,   2, 153, 255, 255, 255,  60, 254, 255, 225, 255,
    155, 223, 255, 223, 255, 255, 255, 255, 191,  32, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255,  61, 127,  61, 255, 255, 255, 255,
    255,  61, 255, 255, 255, 255,  61, 127,  61, 255, 127, 255, 255, 255, 255, 255,
    255, 255,  61, 255, 255, 255, 255, 255, 255, 255, 255,   7, 255, 255, 255,  31,
    255, 255, 255,   3, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63,  63,
    255, 255, 255,  31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   1,
    255, 223,   3,   0, 255, 255,  99,   0, 255, 255,   3,   0, 255, 223,   1,   0,
    255, 255, 255, 255, 255, 255,  79, 192, 191,   1, 240,  31, 255,   3, 255,   3,
    255,   7, 255,   3, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   1,
    159, 255, 255, 255, 255,   5, 255, 255, 255, 255, 255, 255, 255, 255,  63,   0,
    255, 255, 255, 127, 120,  14, 251,   1, 241, 255, 255, 255, 255,  63,  31,   0,
    255, 255, 255, 255, 255,  15, 255, 255, 255,   3, 255, 199, 255, 255, 255, 255,
    255, 255, 127, 198, 255, 255, 255, 255, 255, 255, 191,   0,  26, 224,   7,   0,
    255,   3, 255,   3, 255,  63,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    240, 255, 255, 255, 255, 255,  15, 232, 251,  15, 255, 255, 255,   7, 240,  31,
    252, 255, 255, 255, 195, 196, 255, 255, 255, 255, 255, 255, 191,  92,  12, 240,
    255, 255, 255, 255, 255,  15,  48, 248, 255, 227, 255, 255, 255, 255, 255, 255,
    255,   1, 255, 255, 255, 255, 255, 231, 255,   0,   8,   0,   2, 222, 239,   4,
    255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255,  63,  63, 255, 255, 255, 255,  63,  63, 255, 170, 255, 255, 255,  63,
    255, 255, 255, 255, 255, 255, 223, 255, 223, 255, 207, 239, 255, 255, 220, 127,
    255,   7, 255, 255, 255, 128, 255, 255, 255, 255, 255, 255,   0,   0, 243, 255,
    255, 127, 255,  31, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
    255,  15, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 127,   0,   0,   0, 255,   7,   0,   0, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 207, 255,
    255, 255,  63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 127, 255, 255, 255, 255, 255, 127, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127,  12, 254,
    255, 255, 255, 255, 191,  32, 255, 255, 255, 255, 255, 255, 255, 128,   1,   0,
    255, 255, 127,   0, 127, 127, 127, 127, 127, 127, 127, 127,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  15,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63,   0,   0,   0, 255,  15,
    255, 255, 255, 255, 255,   3, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 127, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    224, 255, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 127, 255, 255, 255, 255, 255,   7, 255, 255, 255, 255,  15,   0, 255, 255,
    255, 255, 255, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255,  63,   0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,
    255,  31, 255, 255, 255, 255, 255, 255, 127,   0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,  15,   0,   0, 255, 255, 255, 255, 255, 127,   8, 192,
    255, 255, 255,  63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 124,   0,   0,   0,   0,   0, 128, 255,
    187, 247, 255, 255, 159,  15, 255,   3, 255, 255, 255, 255, 255, 255, 255,   0,
    255, 255, 255, 255, 255, 255, 255, 255,  15, 192, 255,   3,   0,   0, 252, 127,
    255, 255, 255, 255,  63, 192, 255, 255, 127,   0,  12, 128, 255, 255, 255,  31,
    248, 255, 255, 255, 255, 255,  55, 204, 255, 191, 255, 195, 223, 255, 255, 127,
    255, 255, 255, 255, 255, 129,  25,   0, 247,  47, 255, 243, 255, 255, 255, 239,
    255, 255, 255, 255, 255, 255,  98,  62,   5,   0,   0, 248, 255, 207,  63,   0,
    126, 126, 126,   0, 127, 127, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223,  30, 255,   3,
    255, 255, 255, 255,  15,   0, 255, 255, 127, 248, 255, 255, 255, 255, 255,  15,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   3,   0,   0,   0,   0,
    127,   0, 248, 160, 255, 255, 127,  95, 219, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255,   3,   0, 248, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,
    255, 255, 252, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255,  63,
      0,   0, 255,   3,   0,   0, 255, 255, 255, 255, 247, 255, 127,  15, 223, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  31,
    254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255,  63, 255, 255, 255, 127, 252, 252, 252,  28, 127, 127,   0,  48,
    255, 239, 255, 255, 127, 255, 255, 183, 255,  63, 255,  63,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   7,
    135, 255, 255, 255, 255, 255, 143, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 127, 255,  15,   1,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,  31,
    255, 255, 255,  31, 255, 255, 255, 255, 255, 255,   1,   0, 254, 255, 255,  15,
    255, 255, 255, 255,  15, 224, 255, 255, 255,   7, 255, 255, 255, 255,  63,   0,
    255, 255, 255, 191, 255, 255, 255, 255,  15, 255,  63,   0,   0,   0,   0,   0,
    255, 255, 255,  63, 255,   3, 255, 255, 255, 255,  15, 255, 255, 255, 255,  15,
    255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,  15, 128,   0,   0,
    255, 255, 255, 255, 255, 255, 127,   0, 255, 255,  63,   0, 255,   0,   0,   0,
     63, 253, 255, 255, 255, 255, 191, 145, 255, 255, 191, 255, 255, 255, 255, 255,
    255, 255, 255, 127, 128, 255,   0,   0,   0,   0,   0,   0, 255, 255,  55, 248,
    255, 255, 255, 143, 255, 255, 255, 131,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 240, 255, 255, 252, 255, 255, 255, 255, 255,
      1,   0, 239, 254, 255, 255,  63,   0, 255,   1, 255,   1, 255, 255, 255, 255,
    255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,  31, 248, 127,   0,
    255, 255, 255, 255, 255, 255,  63, 254, 255, 255,  63, 255, 255, 255,   7, 255,
    255, 255,   3,  30,   0, 254,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255,   1,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255,   7,   0, 255, 255, 255, 255, 255, 255,   7, 252,
    255, 255, 255, 255,  15,   0, 255,   3,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 127,
    255, 255, 255, 255, 255,   0, 255, 255,  63,   0, 254,   3,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 127,   0,
    253, 255, 255, 255, 255, 255, 255,   0, 128,  63, 252, 255, 255, 255,   0,   0,
    252, 255, 255, 255, 255, 255, 135, 217,   3,   0, 255, 255, 255,   1, 255,   3,
    248, 255, 255, 255, 127,  16, 192, 255, 127,   0, 255, 255, 255, 255, 119,   0,
    252, 255, 255, 255, 255, 255,  63, 128, 255,  33, 255, 255, 254, 255,  31,   0,
    255, 255, 251, 255, 255, 127,  44,  63,   0,   0,   0,   0,   0,   0,   0,   0,
    127, 189, 255, 191, 255,   3, 255, 255, 255, 255, 255, 127,   7,   0, 255,   3,
    236, 159, 249, 255, 255, 253, 237, 163, 158,  57,   1, 224,  15,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255,   0, 163, 255, 255, 171,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255,   6,  90, 242,   0, 255,   3,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 127,   3,  79, 254, 255, 255,  15,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255,   7,  88,  30,   0, 255,   3, 255,  31,   0,   0,
    255, 255, 255, 255, 255, 215,  64,   1, 255,   3,   0,   0,   0,   0,   0,   0,
    255, 255, 255,   7,  67,   0, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 127,   0,   9,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   7, 128,
      0,   0,   0,   0, 255, 252, 255, 255, 255, 255,  15, 240,  30,   0,   0,   0,
      1, 248, 255, 255, 255, 255,   7, 134, 127,   0, 129, 241, 255, 255, 255, 255,
    255,   3, 128, 252,   7,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   1,
    255, 253, 255, 255, 255, 255,   0,  64,  63,   0, 255, 255, 255,  31, 255, 255,
    255, 255,   0,   0,   0,   2,  18,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    127, 251, 255, 255, 255, 255,   1,   0,  64,   0, 255,   3, 191, 253, 255, 255,
    255, 127,  88,   1, 255,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 231,   1,
      0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   3, 128,
    255, 255, 255,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127,  31,   0,
    255, 255, 255, 255, 255, 255, 255, 255,  15,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 127,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 127,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255,   1, 255, 255, 255, 127, 255, 195,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,  63,  32,   0,
    255, 255, 255, 255, 255, 255, 128, 255,  63,   0, 255, 251, 251, 255, 255, 224,
    255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255,   7, 255, 255, 255, 255, 255, 255,
    255,   0, 248, 255,   0,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   7,   0,
    255, 255, 255, 127,   0,   0,   0,   0,   0,   0,   7,   0, 240,   0, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  15,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   7, 255,  31,
    255,   1, 255, 147,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63,   0,
    255, 255, 255, 255, 127, 254, 255, 255, 255, 255, 255, 255,  95,  60,   0,   0,
     24, 240, 255, 255, 255, 195, 255, 255, 255, 255, 255, 255, 255,   1,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255,  35,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255,  15,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127,   0, 255, 255, 255,   1,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 255, 255, 255, 255, 255,
    255, 255, 255, 223, 100, 222, 255, 235, 239, 255, 255, 255, 255, 255, 255, 255,
    191, 231, 223, 223, 255, 255, 255, 123,  95, 252, 253, 255, 255, 255, 255, 255,
    255, 255, 255, 255,  63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 207, 255, 255, 255, 255, 255, 255,
      0,   0,   0,   0,   0,   0, 128,   7,   0,   0,   0,   0,   0, 224, 223, 255,
    239,  15,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255,  31, 128,  63, 255, 195,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,  15, 255, 131,
    255, 255, 255, 255, 255, 255, 255, 255, 159, 255,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255,  15,   8, 255, 195,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 254, 255,
    255, 255, 255, 255, 255, 255,  31,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    254, 255, 255, 255, 255, 255, 255,  63,   0,   0,   0,   0,   0,   0,   0,   0,
    239, 255, 255, 255, 150, 254, 247,  10, 132, 234, 150, 170, 150, 247, 247,  94,
    255, 251, 255,  15, 238, 251, 255,  15,   0,   0,   0,   0,   0,   0,   3,   0,
    255, 255, 255, 255, 255,  15, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255,  15,   0, 255, 127, 254, 255, 254, 255, 254, 255, 255, 255,  63,   0,
    255,  31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  31, 255, 255,
    255, 255, 255, 255, 255,  31,   0,   0,   0,   0,   0,   0, 192, 255, 255, 255,
      7,   0, 255, 255, 255, 255, 255,  15, 255,   1,   3,   0,  63,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63,   0, 255,  31, 255,   7,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  15,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   1, 255,  15,   0,   0,
    255,  15, 255, 255, 255, 255, 255, 255, 255,   0, 255,   3, 255, 255, 255, 255,
    255,   0, 255, 255, 255,  63,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 123, 252,
    255, 255, 255, 255, 231, 199, 255, 255, 255, 231, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  15,   0, 255,  63,  15,   7,
      7,   0,  63,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255,  31,   0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255,  63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255,   3,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   1,   0,   0,   0,
    255, 255, 255,  63,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

/* Grapheme_Base: 3946 bytes. */

RE_UINT32 re_get_grapheme_base(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_grapheme_base_stage_1[f] << 5;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_grapheme_base_stage_2[pos + f] << 3;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_grapheme_base_stage_3[pos + f] << 7;
    pos += code;
    value = (re_grapheme_base_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Grapheme_Link. */

static RE_UINT8 re_grapheme_link_stage_1[] = {
    0, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_grapheme_link_stage_2[] = {
     0,  0,  1,  2,  3,  4,  5,  0,  0,  0,  0,  6,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  0,  0,  0,  0,  0,
     0,  0,  8,  0,  9, 10, 11, 12,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_grapheme_link_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  1,  0,  1,  0,  1,  0,  1,  0,  1,  0,  1,
     0,  1,  0,  1,  2,  1,  0,  3,  4,  0,  4,  0,  0,  0,  5,  0,
     6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  0,  0,  8,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  5, 10, 11,
     0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    13,  0,  0,  5,  0, 14,  0, 15,  0,  0,  0, 16,  0,  0,  0, 17,
     0,  0,  0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,
     0, 18, 19,  0, 20,  0,  0, 15, 21,  0,  0, 22,  0,  1,  0,  0,
     0, 23,  0, 23,  0,  0, 12,  0, 12,  0, 16,  0, 24,  0,  0,  0,
    19,  0,  0,  0,  0,  0,  0,  9, 25, 26, 27,  0,  0,  0,  0,  0,
    12,  0,  0,  0,  0, 28, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_grapheme_link_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  24,   0,   4,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   4,  16,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   6,   0,   0,  16,   0,   0,   0,  16,   0,
      0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0,  12,   0,   0,   0,   0,   0,   0,   0,   0,  12,   0,
      0,   0,   0,   0,   0,   0,   0, 128,  64,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   8,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  64,   0,   0,   0,   0,   0,   0,  32,   0,   0,
     64,   0,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,   0,   2,
      0,   0,   0,   0,   0,   0,  24,   0,   0,   0,   0,   0,   0,   0,  32,   0,
      0,   0,   0,   0,   0,   4,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   8,   0,   0,   0,   0,   0,   0,   0,   0,  16,   0,
    128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,
     48,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,
};

/* Grapheme_Link: 580 bytes. */

RE_UINT32 re_get_grapheme_link(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_grapheme_link_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_grapheme_link_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_grapheme_link_stage_3[pos + f] << 6;
    pos += code;
    value = (re_grapheme_link_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* White_Space. */

static RE_UINT8 re_white_space_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_white_space_stage_2[] = {
    0, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 4, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_white_space_stage_3[] = {
    0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 3, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2,
    3, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_white_space_stage_4[] = {
      0,  62,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     32,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255,   7,   0,   0,   0, 131,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,
};

/* White_Space: 218 bytes. */

RE_UINT32 re_get_white_space(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_white_space_stage_1[f] << 5;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_white_space_stage_2[pos + f] << 3;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_white_space_stage_3[pos + f] << 7;
    pos += code;
    value = (re_white_space_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Bidi_Control. */

static RE_UINT8 re_bidi_control_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_bidi_control_stage_2[] = {
    0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_bidi_control_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_bidi_control_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0, 192,   0,   0,   0, 124,   0,   0,   0,   0,   0,   0, 192,   3,   0,   0,
};

/* Bidi_Control: 162 bytes. */

RE_UINT32 re_get_bidi_control(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_bidi_control_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_bidi_control_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_bidi_control_stage_3[pos + f] << 7;
    pos += code;
    value = (re_bidi_control_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Join_Control. */

static RE_UINT8 re_join_control_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_join_control_stage_2[] = {
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_join_control_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_join_control_stage_4[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

/* Join_Control: 130 bytes. */

RE_UINT32 re_get_join_control(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_join_control_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_join_control_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_join_control_stage_3[pos + f] << 7;
    pos += code;
    value = (re_join_control_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Dash. */

static RE_UINT8 re_dash_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_dash_stage_2[] = {
    0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 3, 1, 4, 1, 1, 1,
    5, 6, 1, 1, 1, 1, 1, 7, 8, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9,
};

static RE_UINT8 re_dash_stage_3[] = {
     0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  2,  1,  3,  1,  1,  1,  1,  1,  1,  1,
     4,  1,  1,  1,  1,  1,  1,  1,  5,  6,  7,  1,  1,  1,  1,  1,
     8,  1,  1,  1,  1,  1,  1,  1,  9,  3,  1,  1,  1,  1,  1,  1,
    10,  1, 11,  1,  1,  1,  1,  1, 12, 13,  1,  1, 14,  1,  1,  1,
};

static RE_UINT8 re_dash_stage_4[] = {
      0,   0,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   4,   0,   0,   0,   0,   0,  64,   1,   0,   0,   0,   0,   0,   0,   0,
     64,   0,   0,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0,   0,   0,   0,
      0,   0,   8,   0,   0,   0,   0,   8,   0,   8,   0,   0,   0,   0,   0,   0,
      0,   0,   4,   0,   0,   0,   0,   0,   0,   0, 128,   4,   0,   0,   0,  12,
      0,   0,   0,  16,   0,   0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   1,   8,   0,   0,   0,
      0,  32,   0,   0,   0,   0,   0,   0,
};

/* Dash: 364 bytes. */

RE_UINT32 re_get_dash(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_dash_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_dash_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_dash_stage_3[pos + f] << 6;
    pos += code;
    value = (re_dash_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Hyphen. */

static RE_UINT8 re_hyphen_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_hyphen_stage_2[] = {
    0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1,
    4, 1, 1, 1, 1, 1, 1, 5, 6, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7,
};

static RE_UINT8 re_hyphen_stage_3[] = {
    0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1,
    4, 1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 6, 1, 1, 1, 1, 1, 7, 1, 1, 8, 9, 1, 1,
};

static RE_UINT8 re_hyphen_stage_4[] = {
      0,   0,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   4,   0,   0,   0,   0,   0,   0,  64,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   3,   0,   0,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   8,   0,   0,   0,   0,   8,   0,   0,   0,
      0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,   0,   0,   0,
};

/* Hyphen: 308 bytes. */

RE_UINT32 re_get_hyphen(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_hyphen_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_hyphen_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_hyphen_stage_3[pos + f] << 6;
    pos += code;
    value = (re_hyphen_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Quotation_Mark. */

static RE_UINT8 re_quotation_mark_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_quotation_mark_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    2, 1, 1, 1, 1, 1, 1, 3, 4, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5,
};

static RE_UINT8 re_quotation_mark_stage_3[] = {
    0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    3, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1,
    5, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 7, 8, 1, 1,
};

static RE_UINT8 re_quotation_mark_stage_4[] = {
      0,   0,   0,   0, 132,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   8,   0,   8,   0,   0,   0, 255,   0,   0,   0,   6,
      4,   0,   0,   0,   0,   0,   0,   0,   0, 240,   0, 224,   0,   0,   0,   0,
     30,   0,   0,   0,   0,   0,   0,   0, 132,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  12,   0,   0,   0,
};

/* Quotation_Mark: 284 bytes. */

RE_UINT32 re_get_quotation_mark(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_quotation_mark_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_quotation_mark_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_quotation_mark_stage_3[pos + f] << 6;
    pos += code;
    value = (re_quotation_mark_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Terminal_Punctuation. */

static RE_UINT8 re_terminal_punctuation_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 6, 2, 7, 2, 8, 9, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_terminal_punctuation_stage_2[] = {
     0,  1,  1,  2,  1,  3,  4,  5,  6,  7,  1,  1,  1,  1,  8,  9,
    10,  1,  1, 11,  1,  1, 12, 13, 14, 15, 16, 17, 18,  1,  1,  1,
    19,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20,  1,
    21,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22,  1, 23,  1, 24, 25, 26, 27,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 28, 29,
     1,  1,  1, 30,  1,  1,  1,  1, 31, 32, 33, 34,  1,  1,  1, 35,
    36, 37, 38,  1, 39, 40, 41, 42,  1,  1, 43,  1, 44,  1, 45,  1,
     1,  1,  1,  1, 46,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 47, 48,  1,  1, 49,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 50,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 51,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_terminal_punctuation_stage_3[] = {
     0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  2,  3,  0,  0,  0,  0,  0,  0,  0,  4,  0,  5,  0,
     6,  0,  0,  0,  0,  0,  7,  0,  8,  0,  0,  0,  0,  0,  0,  9,
     0, 10,  2,  0,  0,  0,  0,  0,  0,  0,  0, 11,  0,  0,  0,  0,
     0,  0, 12,  0,  0,  0,  0,  0, 13,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0, 15,  0,  0,  0,  0,
     0,  0,  0, 16,  0,  0,  0, 17,  0, 18,  0,  0,  0,  0, 19,  0,
    20,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 21,  0,  0,  0,  0, 22,  0,  0,  0,  0,  0,
     0, 23,  0, 24,  0,  0,  0,  0,  0, 25, 26,  0,  0,  0,  0,  0,
     0, 27, 28,  0,  0,  0,  0,  0, 29,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 24, 30,  0,  0,  0,  0,  0,  0, 31,
     0,  0,  0, 32,  0,  0, 33,  0,  0, 34,  0,  0,  0,  0, 26,  0,
     0,  0, 35,  0,  0,  0, 36, 37,  0,  0,  0,  0,  0,  0,  0, 38,
     0,  0, 39,  0,  0,  0,  0,  0,  1,  0,  0, 40,  0,  0,  0,  0,
     0,  0,  0,  0, 36,  0, 41,  0,  0,  0, 42,  0,  0,  0,  0,  0,
    36,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  0, 43,
     0, 44,  0,  0, 45,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,
     0,  0, 47,  0,  0, 24, 48,  0,  0,  0, 49,  0,  0,  0, 50,  0,
     0, 51,  0,  0,  0,  4,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 53,  0,  0,  0, 29,  0,  0,  0,  0,  0,
     0, 54,  0,  0,  0,  0,  0,  0,  0,  0, 55,  0, 56, 29,  0,  0,
     0,  0, 49, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 58,
     0,  0,  0, 59,  0,  0,  0,  0,  0,  0,  0, 33,  0,  0,  0, 60,
     0, 61, 62,  0,  0,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,
     0,  0,  0,  0, 36,  0,  0,  0,  0,  0,  0,  0, 63,  0,  0,  0,
};

static RE_UINT8 re_terminal_punctuation_stage_4[] = {
      0,   0,   0,   0,   2,  80,   0, 140,   0,   0,   0,  64, 128,   0,   0,   0,
      0,   2,   0,   0,   8,   0,   0,   0,   0,  16,   0, 200,   0,   0,  16,   0,
    255,  23,   0,   0,   0,   0,   0,   3,   0,   0, 255, 127,  48,   0,   0,   0,
      0,   0,   0,  12,   0, 225,   7,   0,   0,  12,   0,   0, 254,   1,   0,   0,
      0,  64,   0,   0,   0,  56,   0,   0,   0,   0,  96,   0,   0,   0, 112,   4,
     60,   3,   0,   0,   0,  15,   0,   0,   0,   0,   0, 236,   0,   0,   0, 248,
      0,   0,   0, 192,   0,   0,   0,  48, 128,   3,   0,   0,   0,  64,   0,  16,
      2, 208,   0,   0,   6,   0,   0,   0,   0, 224,   0,   0,   0,   0, 248,   0,
      0,   0, 192,   0,   0, 192,   0,   0,   0, 128,   0,   0,   0,   0,   0, 224,
      0,   0,   0, 128,   0,   0,   3,   0,   0,   8,   0,   0,   0,   0, 247,   0,
     18,   0,   0,   0,   0,   0,   1,   0,   0,   0, 128,   0,   0,   0,  63,   0,
      0,   0,   0, 252,   0,   0,   0,  30,   0,   0, 224,   3, 128,  63,   0,   0,
      3,   0,   0,   0,  14,   0,   0,   0,  96,  32,   0, 192,   0,   0,   0,  31,
      0,  56,   0,   8,  60, 254, 255,   0,   0,   0,   0, 112,  12,   0,   0,   0,
      0,   0,   0,  24,   0,   0,   2,   0,   0,   0, 128,   1,   0,   0,  31,   0,
      0,   0,  32,   0,   0,   0, 128,   3,  16,   0,   0,   0, 128,   7,   0,   0,
};

/* Terminal_Punctuation: 1128 bytes. */

RE_UINT32 re_get_terminal_punctuation(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_terminal_punctuation_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_terminal_punctuation_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_terminal_punctuation_stage_3[pos + f] << 5;
    pos += code;
    value = (re_terminal_punctuation_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_Math. */

static RE_UINT8 re_other_math_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_other_math_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5,
    1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1,
};

static RE_UINT8 re_other_math_stage_3[] = {
     0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3,  4,  5,  6,  7,  8,  9, 10,  0,  0,  0,  0, 11,  0, 12, 13,
     0,  0,  0,  0,  0,  0, 14, 15, 16, 17,  0,  0,  0,  0,  0, 18,
     0,  0,  0,  0,  0,  0, 19, 20,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0, 22,  0,  0,  0,
    23, 24, 25, 26, 27, 28, 23, 23, 23, 23, 29, 30, 31, 32, 33, 34,
     0,  0,  0,  0,  0,  0,  0,  0, 35, 36, 37,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_other_math_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  64,   0,   0,   0,   0,
      0,   0,  39,   0,   0,   0,  51,   0,   0,   0,  64,   0,   0,   0,  28,   0,
      1,   0,   0,   0,  30,   0,   0,  96,   0,  96,   0,   0,   0,   0,   0,   0,
      0,   0, 255,  31,  98, 248,   0,   0, 132, 252,  47,  62,  16, 179, 251, 241,
    224,   3,   0,   0,   0,   0,   0,   0,   0,   0, 224, 243, 182,  62, 195, 240,
    255,  63, 235,  47,  48,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 176,   0,   0,   0,   1,   0,   4,   0,   0,   0,
      0,   0,   0,   0,   3, 192, 127, 240, 193, 140,  15,   0, 148,  31,   0,   0,
     96,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,  15,  96,   0,   0,
     96,   0,   0,   0, 192, 255,   0,   0, 248, 255, 255,   1,   0,   0,   0,   0,
      0,   0,   0,  15,   0,   0,   0,  48,   0,   0,   0,   0,  10,   1,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  80, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 223, 255, 255, 255, 255, 255, 255, 255, 255, 223, 100, 222, 255, 235,
    239, 255, 255, 255, 255, 255, 255, 255, 191, 231, 223, 223, 255, 255, 255, 123,
     95, 252, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63, 255, 255, 255,
    253, 255, 255, 247, 255, 255, 255, 247, 255, 255, 223, 255, 255, 255, 223, 255,
    255, 127, 255, 255, 255, 127, 255, 255, 255, 253, 255, 255, 255, 253, 255, 255,
    247, 207, 255, 255, 255, 255, 255, 255, 239, 255, 255, 255, 150, 254, 247,  10,
    132, 234, 150, 170, 150, 247, 247,  94, 255, 251, 255,  15, 238, 251, 255,  15,
};

/* Other_Math: 564 bytes. */

RE_UINT32 re_get_other_math(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_other_math_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_other_math_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_other_math_stage_3[pos + f] << 6;
    pos += code;
    value = (re_other_math_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Hex_Digit. */

static RE_UINT8 re_hex_digit_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1,
};

static RE_UINT8 re_hex_digit_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_hex_digit_stage_3[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1,
};

static RE_UINT8 re_hex_digit_stage_4[] = {
      0,   0,   0,   0,   0,   0, 255,   3, 126,   0,   0,   0, 126,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0, 255,   3, 126,   0,   0,   0, 126,   0,   0,   0,   0,   0,   0,   0,
};

/* Hex_Digit: 177 bytes. */

RE_UINT32 re_get_hex_digit(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 16;
    code = ch ^ (f << 16);
    pos = (RE_UINT32)re_hex_digit_stage_1[f] << 5;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_hex_digit_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_hex_digit_stage_3[pos + f] << 7;
    pos += code;
    value = (re_hex_digit_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* ASCII_Hex_Digit. */

static RE_UINT8 re_ascii_hex_digit_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_ascii_hex_digit_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_ascii_hex_digit_stage_3[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_ascii_hex_digit_stage_4[] = {
      0,   0,   0,   0,   0,   0, 255,   3, 126,   0,   0,   0, 126,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

/* ASCII_Hex_Digit: 130 bytes. */

RE_UINT32 re_get_ascii_hex_digit(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_ascii_hex_digit_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_ascii_hex_digit_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_ascii_hex_digit_stage_3[pos + f] << 7;
    pos += code;
    value = (re_ascii_hex_digit_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_Alphabetic. */

static RE_UINT8 re_other_alphabetic_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 7, 2, 8,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_other_alphabetic_stage_2[] = {
     0,  0,  0,  1,  0,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12,
    13,  0,  0,  0,  0,  0,  0, 14, 15, 16, 17, 18, 19, 20,  0,  0,
     0,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0, 22,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 23,  0, 24, 25, 26, 27,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0,  0,
     0,  0,  0, 29,  0,  0,  0,  0,  0,  0, 30,  0,  0, 31,  0,  0,
    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,  0, 43, 44, 45,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 47,  0,  0,  0,
    48,  0,  0,  0,  0,  0,  0,  0,  0, 49,  0,  0,  0,  0,  0,  0,
     0, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_other_alphabetic_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   2,   3,   0,   4,   0,   5,   6,   0,   0,   7,   8,
      9,  10,   0,   0,   0,  11,   0,   0,  12,  13,   0,   0,   0,   0,  14,  15,
     16,  17,  18,  19,  20,  21,  22,  19,  20,  21,  23,  24,  20,  21,  25,  26,
     20,  21,  27,  19,  28,  21,  29,   0,  16,  21,  30,  19,  20,  21,  30,  19,
     16,  21,  31,  19,  19,   0,  32,  33,   0,  34,  35,   0,   0,  36,  35,   0,
      0,   0,   0,  37,  38,  39,   0,   0,   0,  40,  41,  42,  43,   0,   0,   0,
     33,  33,  33,  33,   0,  44,  45,   0,   0,   0,   0,   0,  46,  47,   0,   0,
      0,  48,   0,   0,   0,   0,   0,   0,  49,   0,  50,  51,   0,   0,   0,   0,
     52,  53,  16,   0,  54,  55,   0,  56,   0,  57,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  58,   0,   0,   0,   0,   0,  44,  59,  60,
      0,   0,   0,   0,   0,   0,   0,  59,   0,   0,   0,  61,  21,   0,   0,   0,
     62,  63,   0,   0,  64,  14,  65,  66,   0,  67,  68,   0,  16,  14,   0,   1,
      0,  69,  70,  71,   0,  72,   0,  73,   0,   0,   0,   0,   0,   0,   0,  74,
     75,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  76,   0,   0,   0,   0,
     77,   0,   0,   0,   0,   0,   0,   0,   0,  78,   0,   0,   0,   0,   0,   0,
     54,  79,  80,   0,  28,  81,   0,   0,  54,  68,  46,   0,  54,  82,   0,   0,
      0,  83,   0,   0,   0,   0,  66,  45,  16,  21,  22,  19,   0,   0,   0,   0,
      0,  53,  84,   0,   0,  10,  64,   0,   0,   0,   0,   0,   0,  85,  86,   0,
      0,  87,  88,   0,   0,  89,   0,   0,  90,  91,   0,   0,   0,   0,   0,   0,
      0,  92,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  93,  94,
     95,  96,  97,   0,  98,   0,   0,   0,   0,  99,   0,   0, 100, 101,   0,   0,
      0, 102, 103,   0, 104,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 105,
      0,   0, 106,  59, 107,   0,   0,   0,   0,   0,   0,   0,  75,   0,   0,   0,
    108, 109,   0,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,
      0,  10, 111, 111,  60,   0,   0,   0,
};

static RE_UINT8 re_other_alphabetic_stage_4[] = {
      0,   0,   0,   0,  32,   0,   0,   0,   0,   0, 255, 191, 182,   0,   0,   0,
      0,   0, 255,   7,   0, 248, 255, 254,   0,   0,   1,   0,   0,   0, 192,  31,
    158,  33,   0,   0,   0,   0,   2,   0,   0,   0, 255, 255, 192, 255,   1,   0,
      0,   0, 192, 248, 239,  30,   0,   0,   0,   0, 240, 255, 248,   3, 255, 255,
     15,   0,   0,   0,   0,   0,   0, 204, 255, 223, 224,   0,  12,   0,   0,   0,
     14,   0,   0,   0,   0,   0,   0, 192, 159,  25, 128,   0, 135,  25,   2,   0,
      0,   0,  35,   0, 191,  27,   0,   0,  12,   0,   0,  28, 159,  25, 192,   0,
      4,   0,   0,   0, 199,  29, 128,   0, 223,  29,  96,   0, 223,  29, 128,   0,
      0, 128,  95, 255,   0,   0,  12,   0,   0,   0, 242,   7,   0,  32,   0,   0,
      0,   0, 242,  27,   0,   0, 254, 255,   3, 224, 255, 254, 255, 255, 255,  31,
      0, 248, 127, 121,   0,   0, 192, 195, 157,  63,  30,   0, 252, 191,   0,  60,
      0,   0, 192, 255, 255,   1,   0,   0,  96,   0,   0,   0,   0,   2,   0,   0,
    255,  15, 255,   1,   0,   0, 128,  15,   0,   0, 224, 127, 254, 255,  31,   0,
     31,   0,   0,   0,   0,   0, 224, 255,   7,   0,   0,   0, 254,  51,   0,   0,
    128, 255,   3,   0, 240, 255, 127,   0, 128, 255,  31,   0, 255, 255, 255, 255,
    255,   3,   0,   0,   0,   0, 240,  15,   4,   8,   0,   0, 248,   0,   0,   0,
      3,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0, 128, 192,   7,   0,   0,
    128, 255,   7,   0,   0, 254, 127,   0,   8,  48,   0,   0,   0,   0,   0,  56,
      0,   0, 157,  65,   0, 248,  32,   0, 248,   7,   0,   0,   0,   0,   0,  64,
      0,   0, 192,   7, 110, 240,   0,   0, 240,   0,   0,   0,   0,   0,   0, 255,
     63,   0,   0,   0,   0,   0, 255,   1,   0,   0, 248, 255,   0, 240, 159,  64,
     59,   0,   0,   0,   0, 128,  63, 127,   0,   0,   0,  48,   0,   0, 255, 127,
      1,   0,   0,   0,   0, 248,  63,   0,   0,   0,   0, 224, 255,   7,   0,   0,
      0, 240, 255,   1,   0,   0, 254, 252,  16,   0,   0,   0, 254,   7,   0,   0,
      0,   0, 224, 123,   0,   0, 254,  15,   0, 252, 255,   0,   0, 128, 127, 127,
      0,   0, 252, 255, 255, 254, 127,   0,   0,   0, 126, 180, 139,   0,   0,   0,
      0, 124, 123,   0,   0,   0, 120,   0,   0, 128, 254, 255, 255, 128,   7,   0,
    127, 255, 255, 249, 219,   7,   0,   0, 128,   0,   0,   0, 255,   3, 255, 255,
};

/* Other_Alphabetic: 1280 bytes. */

RE_UINT32 re_get_other_alphabetic(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_other_alphabetic_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_other_alphabetic_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_other_alphabetic_stage_3[pos + f] << 5;
    pos += code;
    value = (re_other_alphabetic_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Ideographic. */

static RE_UINT8 re_ideographic_stage_1[] = {
     0,  1,  2,  3,  4,  0,  0,  5,  0,  0,  0,  6,  7,  8,  0,  0,
     3,  3,  3,  3,  3,  9, 10, 11,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_ideographic_stage_2[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  4,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  6,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  7,  2,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  9, 10,  0,  0,  0,  0,  0,  0,
     2,  2,  2, 11,  2,  2,  2,  2,  2,  2,  2, 12, 13,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2, 14,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2, 15,  0,  0,  0,  0,  0,  0,  2, 16,  0,  0,
};

static RE_UINT8 re_ideographic_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  0,
     2,  2,  2,  2,  2,  2,  2,  4,  0,  0,  0,  0,  2,  2,  2,  2,
     2,  5,  2,  6,  0,  0,  0,  0,  2,  2,  2,  2,  2,  2,  2,  7,
     2,  2,  2,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,  2,  2,
     2,  2,  2, 10,  0,  0,  0,  0,  2,  2,  2, 11,  2,  2,  2,  2,
     2,  2,  2,  2, 12,  2,  2,  2, 13,  2,  2,  2,  2,  2,  2,  2,
     2,  2, 14,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 15,
    16,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_ideographic_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0, 192,   0,   0,   0, 254,   3,   0,   7,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63,   0,
    255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,  63, 255, 255,
    255, 255, 255,   3,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,
    255, 255, 255, 255, 255, 255,   7,   0,   0,   0,   0,   0,   0,   0, 255, 255,
    255, 255, 255, 255, 255, 255, 255,  15, 255, 255, 127,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255,  31,   0, 255, 255, 255,  63, 255, 255, 255, 255,
    255, 255, 255, 255,   3,   0, 255, 255, 255, 255, 255, 255,   1,   0,   0,   0,
    255, 255, 255,  63,   0,   0,   0,   0,
};

/* Ideographic: 600 bytes. */

RE_UINT32 re_get_ideographic(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_ideographic_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_ideographic_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_ideographic_stage_3[pos + f] << 6;
    pos += code;
    value = (re_ideographic_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Diacritic. */

static RE_UINT8 re_diacritic_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 7, 8,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_diacritic_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
    16,  1,  1, 17,  1,  1,  1, 18,  1, 19, 20, 21, 22, 23,  1, 24,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 25,  1, 26,  1,
    27,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 28, 29, 30, 31, 32, 33,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 34,  1,  1, 35, 36,
     1,  1, 37,  1,  1,  1,  1,  1,  1,  1, 38,  1,  1, 39,  1, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 37, 50,  1, 51, 52,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 53, 54,  1,  1,  1, 55,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, 56,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, 54, 57,  1,  1,  1,  1,  1, 58, 59,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_diacritic_stage_3[] = {
     0,  0,  1,  2,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  4,  5,  5,  5,  5,  6,  7,  8,  0,  0,  0,
     0,  0,  0,  0,  9,  0,  0,  0,  0,  0, 10,  0, 11, 12, 13,  0,
     0,  0, 14,  0,  0,  0, 15, 16,  0,  4, 17,  0,  0, 18,  0, 19,
    20,  0,  0,  0,  0,  0,  0, 21,  0, 22, 23, 24,  0, 22, 25,  0,
     0, 22, 25,  0,  0, 22, 25, 26,  0, 22, 25,  0,  0,  0, 25,  0,
     0,  0, 25,  0,  0, 22, 25,  0,  0, 27, 25,  0,  0,  0, 28,  0,
     0,  0, 29,  0,  0, 30, 31,  0, 20, 32,  0,  0, 33,  0, 34,  0,
     0, 35,  0, 36, 37,  0,  0,  0,  0,  0, 26,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 38,  0,  0, 39,  0,  0,  0,  0,  0,  0,
     0,  0,  0, 40,  0, 41,  0,  0,  0, 42, 43, 44,  0, 45,  0,  0,
     0, 46,  0, 47,  0,  0,  4, 48,  0, 49,  5, 17,  0,  0, 50, 51,
     0,  0,  0,  0,  0, 52, 53, 54,  0,  0,  0,  0,  0,  0,  0, 55,
     0, 56,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0, 58,  0,  0, 22,
     0,  0,  0, 59, 60,  0,  0, 61,  5, 62,  0,  0, 63,  0,  0, 20,
     0,  0,  0,  0,  0,  0, 43, 64,  0, 65, 66,  0,  0, 66,  2, 67,
     0,  0,  0, 68,  0, 15, 69, 70,  0,  0, 71,  0,  0,  0,  0, 72,
     1,  0,  0,  0,  0,  0,  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,
     0,  1,  2, 74, 75,  0,  0, 76,  0,  0,  0,  0,  0,  0,  0,  2,
     0,  0,  0,  0,  0,  0,  0, 77,  0, 78,  0,  0,  0,  0,  0,  0,
     0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 79,  0,  0,
     0, 80,  0, 66,  0,  0, 81,  0,  0, 82,  0,  0,  0,  0,  0, 83,
     0, 22, 25, 84,  0,  0,  0,  0,  0,  0, 85,  0,  0,  0, 86,  0,
     0,  0,  0,  0,  0, 15,  2,  0,  0, 15,  0,  0,  0, 46,  0,  0,
     0, 87,  0,  0,  0,  0,  0,  0,  0, 79,  0,  0,  0,  0,  0,  0,
     0, 42, 88,  0, 10,  0,  0,  0,  0, 15,  0,  0,  0,  0,  0,  0,
     0,  0, 89,  0, 90,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91,
     0, 92,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,
     0,  0,  0, 94, 95, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0, 97,
     0,  0,  0,  0,  0,  0, 92,  0,  0,  0, 98,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_diacritic_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,  64,   1,   0,   0,   0,   0, 129, 144,   1,
      0,   0, 255, 255, 255, 255, 255, 255, 255, 127, 255, 224,   7,   0,  48,   4,
     48,   0,   0,   0, 248,   0,   0,   0,   0,   0,   0,   2,   0,   0, 254, 255,
    251, 255, 255, 191,  22,   0,   0,   0,   0, 248, 135,   1,   0,   0,   0, 128,
     97,  28,   0,   0, 255,   7,   0,   0, 192, 255,   1,   0,   0, 248,  63,   0,
      0,   0,   0,   3, 248, 255, 255, 127,   0,   0,   0,  16,   0,  32,  30,   0,
      0,   0,   2,   0,   0,  32,   0,   0,   0,   0,   0, 224,   0,   0,   0,  24,
      0,   4,   0,   0, 128,  95,   0,   0,   0,   0,   0,   4,   0,  31,   0,   0,
      0,   0, 160, 194, 220,   0,   0,   0,  64,   0,   0,   0,   0,   0, 128,   6,
     24,  62,   0,   0, 128, 191,   0,  12,   0, 254,  15,  32,   0,   0,   0,  14,
      0,   0, 224, 159,   0,   0, 255,  63,   0,   0,  16,   0,  16,   0,   0,   0,
      0, 248,  15,   0,   0,  12,   0,   0,   0,   0, 192,   0,   0,   0,   0,  63,
    255,  33, 144,   3,   0, 240, 255, 255, 240, 255,   0,   0,   0,   0, 224, 227,
      0,   0,   0, 160,   3, 224,   0, 224,   0, 224,   0,  96,   0, 128,   3,   0,
      0, 128,   0,   0,   0, 252,   0,   0,   0,   0,   0,  30,   0, 128,   0, 176,
      0,   0,   0,  48,   0,   0,   3,   0,   3,   0,   0,   0,   0,   7,   0,   0,
    255, 255,   3,   0,   0, 120,   0,   0,   0,   0,   8,   0,  32,   0,   0,   0,
      0,   0,   0,  56,   7,   0,   0,   0,   0,   0,  64,   0,   0,   0,   0, 248,
      0,  48,   0,   0, 255, 255,   0,   0,   0,   0,   1,   0,   0,   0,   0, 192,
      8,   0,   0,   0,  96,   0,   0,   0, 252,   0,   0,   0,   0,   0,   0,   6,
      0,   0,  24,   0,   1,  28,   0,   0,   0,   0,  96,   0,   0,   6,   0,   0,
    192,  31,  31,   0,  68,   0,   0,   0,  12,   0,   0,   0,   0,   8,   0,   0,
    128,   0,   0,   0,  52,   0,   0,   0,   0,   0, 128,   0,   0,   0,  31,   0,
      0,   0, 127,   0,   0, 128, 255, 255, 128, 227,   7, 248, 231,  15,   0,   0,
      0,  60,   0,   0,   0, 240,   0,   0, 112,   7,   0,   0,
};

/* Diacritic: 1300 bytes. */

RE_UINT32 re_get_diacritic(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_diacritic_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_diacritic_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_diacritic_stage_3[pos + f] << 5;
    pos += code;
    value = (re_diacritic_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Extender. */

static RE_UINT8 re_extender_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 2, 7,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_extender_stage_2[] = {
     0,  1,  2,  3,  2,  2,  2,  4,  2,  2,  2,  2,  5,  6,  7,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  8,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     9,  2,  2, 10, 11, 12,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 13,
     2,  2,  2,  2,  2,  2,  2,  2,  2, 14, 15,  2,  2, 16,  2,  2,
     2,  2,  2,  2,  2, 17,  2, 18,  2,  2,  2,  2,  2,  2,  2,  2,
    19,  2,  2,  2, 20,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
};

static RE_UINT8 re_extender_stage_3[] = {
     0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0,  0,  4,
     0,  5,  0,  5,  0,  0,  0,  0,  6,  7,  0,  0,  0,  0,  0,  0,
     0,  0,  8,  0,  0,  0,  0,  0,  9, 10,  0,  0,  0,  0,  0,  0,
    11,  0, 12, 13,  0,  0,  0,  0, 14,  0,  0,  0,  0,  0,  0,  0,
    15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,
     0, 17,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,
     0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,
     0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 23,  0,  0,  0,  0, 24,  0,  0,  0,
     0,  0,  0,  0,  0, 25,  0,  0,
};

static RE_UINT8 re_extender_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,   0,
      0,   0,   3,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   4,  64,   0,   0,   0,   0,   0,   0,   0,
      0,   4,   0,   0,   0,   0,   0,   0,   8,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,   0,   0,   0,  64,   0,
      0,   0,   0,   0,   0,   0,   0,   8,  32,   0,   0,   0,   0,   0,  62,   0,
      0,   0,   0,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 112,
      0,   0,  32,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,
      0, 128,   0,   0,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
      0,   0,   0,  32,   0,   0,  24,   0,   0,   0,   0,  32,   0,   0,   0,   0,
    192,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,
     12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  11,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  48, 112,   0,   0,   0,   0,   0,   0,   0,
};

/* Extender: 640 bytes. */

RE_UINT32 re_get_extender(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_extender_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_extender_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_extender_stage_3[pos + f] << 6;
    pos += code;
    value = (re_extender_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_Lowercase. */

static RE_UINT8 re_other_lowercase_stage_1[] = {
    0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_other_lowercase_stage_2[] = {
    0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2,
    4, 2, 5, 2, 2, 2, 6, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 7, 2, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_other_lowercase_stage_3[] = {
     0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  2,  3,  0,  4,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  6,  7,  0,
     0,  8,  9,  0,  0, 10,  0,  0,  0,  0,  0, 11,  0,  0,  0,  0,
     0, 12,  0,  0,  0,  0,  0,  0,  0,  0, 13,  0,  0, 14,  0, 15,
     0,  0,  0,  0,  0, 16,  0,  0,
};

static RE_UINT8 re_other_lowercase_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   4,
      0,   0,   0,   0,   0,   0, 255,   1,   3,   0,   0,   0,  31,   0,   0,   0,
     32,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0, 240, 255, 255,
    255, 255, 255, 255, 255,   7,   0,   1,   0,   0,   0, 248, 255, 255, 255, 255,
      0,   0,   0,   0,   0,   0,   2, 128,   0,   0, 255,  31,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 255, 255,   0,   0, 255, 255, 255,   3,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  48,   0,   0,   0,  48,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   3,
      0,   0,   0, 240,   0,   0,   0,   0,
};

/* Other_Lowercase: 372 bytes. */

RE_UINT32 re_get_other_lowercase(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_other_lowercase_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_other_lowercase_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_other_lowercase_stage_3[pos + f] << 6;
    pos += code;
    value = (re_other_lowercase_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_Uppercase. */

static RE_UINT8 re_other_uppercase_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_other_uppercase_stage_2[] = {
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
};

static RE_UINT8 re_other_uppercase_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_other_uppercase_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255,   0,   0,
      0,   0,   0,   0,   0,   0, 192, 255, 255, 255,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 255, 255, 255,   3, 255, 255, 255,   3, 255, 255,
    255,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

/* Other_Uppercase: 210 bytes. */

RE_UINT32 re_get_other_uppercase(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_other_uppercase_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_other_uppercase_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_other_uppercase_stage_3[pos + f] << 7;
    pos += code;
    value = (re_other_uppercase_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Noncharacter_Code_Point. */

static RE_UINT8 re_noncharacter_code_point_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1,
};

static RE_UINT8 re_noncharacter_code_point_stage_2[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
};

static RE_UINT8 re_noncharacter_code_point_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
};

static RE_UINT8 re_noncharacter_code_point_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192,
};

/* Noncharacter_Code_Point: 177 bytes. */

RE_UINT32 re_get_noncharacter_code_point(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 16;
    code = ch ^ (f << 16);
    pos = (RE_UINT32)re_noncharacter_code_point_stage_1[f] << 5;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_noncharacter_code_point_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_noncharacter_code_point_stage_3[pos + f] << 7;
    pos += code;
    value = (re_noncharacter_code_point_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_Grapheme_Extend. */

static RE_UINT8 re_other_grapheme_extend_stage_1[] = {
    0, 1, 1, 2, 3, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_other_grapheme_extend_stage_2[] = {
     0,  0,  1,  2,  0,  0,  3,  0,  4,  0,  0,  0,  5,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,
     0,  0,  0,  0,  7,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_other_grapheme_extend_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  1,  1,
     0,  2,  1,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,
     5,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  7,  0,  0,  0,  0,  0,  0,  1,  0,
     0,  8,  0,  9,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  0,  0,
    11,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_other_grapheme_extend_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  64,   0,   0, 128,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   4,   0,  96,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0, 128,   0, 128,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,  16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 192,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0, 192,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   1,  32,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32, 192,   7,   0,
      0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
};

/* Other_Grapheme_Extend: 444 bytes. */

RE_UINT32 re_get_other_grapheme_extend(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_other_grapheme_extend_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_other_grapheme_extend_stage_2[pos + f] << 3;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_other_grapheme_extend_stage_3[pos + f] << 7;
    pos += code;
    value = (re_other_grapheme_extend_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* IDS_Binary_Operator. */

static RE_UINT8 re_ids_binary_operator_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_ids_binary_operator_stage_2[] = {
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_ids_binary_operator_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
};

static RE_UINT8 re_ids_binary_operator_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 243,  15,
};

/* IDS_Binary_Operator: 130 bytes. */

RE_UINT32 re_get_ids_binary_operator(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_ids_binary_operator_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_ids_binary_operator_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_ids_binary_operator_stage_3[pos + f] << 7;
    pos += code;
    value = (re_ids_binary_operator_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* IDS_Trinary_Operator. */

static RE_UINT8 re_ids_trinary_operator_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_ids_trinary_operator_stage_2[] = {
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_ids_trinary_operator_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
};

static RE_UINT8 re_ids_trinary_operator_stage_4[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12,  0,
};

/* IDS_Trinary_Operator: 130 bytes. */

RE_UINT32 re_get_ids_trinary_operator(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_ids_trinary_operator_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_ids_trinary_operator_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_ids_trinary_operator_stage_3[pos + f] << 7;
    pos += code;
    value = (re_ids_trinary_operator_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Radical. */

static RE_UINT8 re_radical_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_radical_stage_2[] = {
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_radical_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3,
};

static RE_UINT8 re_radical_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255, 255, 255, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  15,   0,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255,  63,   0,   0,   0,   0,   0,
};

/* Radical: 162 bytes. */

RE_UINT32 re_get_radical(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_radical_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_radical_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_radical_stage_3[pos + f] << 7;
    pos += code;
    value = (re_radical_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Unified_Ideograph. */

static RE_UINT8 re_unified_ideograph_stage_1[] = {
    0, 1, 2, 2, 3, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2,
};

static RE_UINT8 re_unified_ideograph_stage_2[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
    1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 1, 6, 7, 1,
    1, 1, 1, 8, 1, 1, 1, 1, 1, 1, 9, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_unified_ideograph_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3,
    0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1,
    7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9,
};

static RE_UINT8 re_unified_ideograph_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255,  63,   0, 255, 255, 255, 255, 255, 255,   0,   0,
      0, 192,  26, 128, 154,   3,   0,   0, 255, 255, 127,   0,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255,  31,   0, 255, 255, 255,  63, 255, 255, 255, 255,
    255, 255, 255, 255,   3,   0, 255, 255, 255, 255, 255, 255,   1,   0,   0,   0,
};

/* Unified_Ideograph: 434 bytes. */

RE_UINT32 re_get_unified_ideograph(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_unified_ideograph_stage_1[f] << 5;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_unified_ideograph_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_unified_ideograph_stage_3[pos + f] << 6;
    pos += code;
    value = (re_unified_ideograph_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_Default_Ignorable_Code_Point. */

static RE_UINT8 re_other_default_ignorable_code_point_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_other_default_ignorable_code_point_stage_2[] = {
    0, 1, 0, 0, 0, 0, 0, 0, 2, 0, 0, 3, 0, 0, 0, 0,
    4, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6,
    7, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_other_default_ignorable_code_point_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,
     0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,
     0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,
     0,  0,  0,  0,  0,  0,  6,  7,  8,  0,  9,  9,  0,  0,  0, 10,
     9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_other_default_ignorable_code_point_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,
      0,   0,   0, 128,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,  48,   0,
      0,   0,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,
      0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   1,
    253, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,
      0,   0,   0,   0,   0,   0, 255, 255,
};

/* Other_Default_Ignorable_Code_Point: 356 bytes. */

RE_UINT32 re_get_other_default_ignorable_code_point(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_other_default_ignorable_code_point_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_other_default_ignorable_code_point_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_other_default_ignorable_code_point_stage_3[pos + f] << 6;
    pos += code;
    value = (re_other_default_ignorable_code_point_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Deprecated. */

static RE_UINT8 re_deprecated_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_deprecated_stage_2[] = {
    0, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 4, 1, 1, 1, 1,
    5, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_deprecated_stage_3[] = {
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 4, 0, 0, 5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_deprecated_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   8,   0,   0,   0,   0,   0,   0,   0, 128,   2,
      0,   0,   0,   0,  24,   0,   0,   0,   0,   0,   0,   0,   0, 252,   0,   0,
      0,   0,   0,   0,   0,   6,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,
};

/* Deprecated: 292 bytes. */

RE_UINT32 re_get_deprecated(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_deprecated_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_deprecated_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_deprecated_stage_3[pos + f] << 6;
    pos += code;
    value = (re_deprecated_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Soft_Dotted. */

static RE_UINT8 re_soft_dotted_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_soft_dotted_stage_2[] = {
    0, 1, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 5,
    6, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 9, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
};

static RE_UINT8 re_soft_dotted_stage_3[] = {
     0,  0,  0,  1,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,
     0,  0,  3,  4,  5,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,
     0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9, 10, 11,  0,  0,
     0, 12,  0,  0,  0,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0, 14,  0,  0,  0,  0,  0,  0, 15,  0,  0,  0,  0,  0,
     0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 17, 18,  0, 19, 20,  0, 21,  0, 22, 23,  0, 24,  0, 17, 18,
     0, 19, 20,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_soft_dotted_stage_4[] = {
      0,   0,   0,   0,   0,   6,   0,   0,   0, 128,   0,   0,   0,   2,   0,   0,
      0,   1,   0,   0,   0,   0,   0,  32,   0,   0,   4,   0,   0,   0,   8,   0,
      0,   0,  64,   1,   4,   0,   0,   0,   0,   0,  64,   0,  16,   1,   0,   0,
      0,  32,   0,   0,   0,   8,   0,   0,   0,   0,   2,   0,   0,   3,   0,   0,
      0,   0,   0,  16,  12,   0,   0,   0,   0,   0, 192,   0,   0,  12,   0,   0,
      0,   0,   0, 192,   0,   0,  12,   0, 192,   0,   0,   0,   0,   0,   0,  12,
      0, 192,   0,   0,
};

/* Soft_Dotted: 424 bytes. */

RE_UINT32 re_get_soft_dotted(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_soft_dotted_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_soft_dotted_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_soft_dotted_stage_3[pos + f] << 5;
    pos += code;
    value = (re_soft_dotted_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Logical_Order_Exception. */

static RE_UINT8 re_logical_order_exception_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1,
};

static RE_UINT8 re_logical_order_exception_stage_2[] = {
    0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_logical_order_exception_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0,
    0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_logical_order_exception_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  31,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 224,   4,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  96,  26,   0,   0,   0,   0,   0,   0,   0,   0,
};

/* Logical_Order_Exception: 209 bytes. */

RE_UINT32 re_get_logical_order_exception(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 16;
    code = ch ^ (f << 16);
    pos = (RE_UINT32)re_logical_order_exception_stage_1[f] << 5;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_logical_order_exception_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_logical_order_exception_stage_3[pos + f] << 7;
    pos += code;
    value = (re_logical_order_exception_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_ID_Start. */

static RE_UINT8 re_other_id_start_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_other_id_start_stage_2[] = {
    0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_other_id_start_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_other_id_start_stage_4[] = {
     0,  0,  0,  0,  0,  0,  0,  0, 96,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  1,  0, 64,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,
};

/* Other_ID_Start: 194 bytes. */

RE_UINT32 re_get_other_id_start(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_other_id_start_stage_1[f] << 5;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_other_id_start_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_other_id_start_stage_3[pos + f] << 6;
    pos += code;
    value = (re_other_id_start_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Other_ID_Continue. */

static RE_UINT8 re_other_id_continue_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_other_id_continue_stage_2[] = {
    0, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_other_id_continue_stage_3[] = {
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_other_id_continue_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,   0,
    128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 254,   3,   0,
      0,   0,   0,   4,   0,   0,   0,   0,
};

/* Other_ID_Continue: 202 bytes. */

RE_UINT32 re_get_other_id_continue(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_other_id_continue_stage_1[f] << 5;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_other_id_continue_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_other_id_continue_stage_3[pos + f] << 6;
    pos += code;
    value = (re_other_id_continue_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Sentence_Terminal. */

static RE_UINT8 re_sentence_terminal_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 7, 8, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_sentence_terminal_stage_2[] = {
     0,  1,  1,  1,  1,  2,  3,  4,  5,  6,  1,  1,  1,  1,  1,  1,
     7,  1,  1,  8,  1,  1,  9, 10, 11, 12, 13, 14, 15,  1,  1,  1,
    16,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 17,  1,
    18,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 19,  1, 20,  1, 21, 22, 23, 24,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 25, 26,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 27,  1,  1,  1,  1, 28,
    29, 30, 31,  1, 32, 33, 34, 35,  1,  1, 36,  1, 34,  1, 37,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 38, 39,  1,  1, 40,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 41,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 42,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_sentence_terminal_stage_3[] = {
     0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  0,  0,  4,  0,
     5,  0,  0,  0,  0,  0,  0,  6,  0,  7,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,
     0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0, 11,  0,  0,  0,  0,
     0, 12,  0,  0,  0,  0,  0,  0, 13,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14,  0,  0,
     0,  0, 15,  0,  0,  0,  0,  0,  0, 16,  0,  3,  0,  0,  0,  0,
     0, 17, 18,  0,  0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,
    20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,
    22,  0,  0,  0,  0,  0,  0, 23,  0,  0,  0, 24,  0,  0, 22,  0,
     0, 25,  0,  0,  0,  0, 26,  0,  0,  0, 27,  0,  0,  0,  0, 28,
     0,  0,  0,  0,  0,  0,  0, 29,  0,  0, 30,  0,  0,  0,  0,  0,
     1,  0,  0, 31,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,
     0,  0, 32,  0,  0,  0,  0,  0,  0,  0, 33,  0,  0,  3, 34,  0,
     0,  0, 35,  0,  0,  0, 36,  0,  0, 37,  0,  0,  0,  2,  0,  0,
     0,  0, 38,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 39,  0,
     0,  0, 40,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
     0,  0, 42,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 43,
     0,  0,  0, 22,  0,  0,  0, 44,  0, 43, 45,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,
     0,  0,  0,  0, 47,  0,  0,  0,
};

static RE_UINT8 re_sentence_terminal_stage_4[] = {
      0,   0,   0,   0,   2,  64,   0, 128,   0,   2,   0,   0,   0,   0,   0, 192,
      0,   0,  16,   0,   7,   0,   0,   0,   0,   0,   0,   2,   0,   0, 128,  98,
     48,   0,   0,   0,   0,  12,   0,   0, 132,   1,   0,   0,   0,  64,   0,   0,
      0,   0,  96,   0,   8,   2,   0,   0,   0,  15,   0,   0,   0,   0,   0, 204,
      0,   0,   0,  24,   0,   0,   0,  48, 128,   3,   0,   0,   0,  64,   0,  16,
      4,   0,   0,   0,   0,   0,   0, 128,   0, 192,   0,   0,   0,   0, 136,   0,
      0,   0, 192,   0,   0, 128,   0,   0,   0,   3,   0,   0,   0,   0,   0, 224,
      0,   0,   3,   0,   0,   8,   0,   0,   0,   0, 196,   0,   2,   0,   0,   0,
      0,   0, 224,   3, 128,   1,   0,   0,   3,   0,   0,   0,  14,   0,   0,   0,
     96,  32,   0, 192,   0,   0,   0,  27,   0,  24,   0,   0,  12, 254, 255,   0,
      6,   0,   0,   0,   0,   0,   0, 112,  12,   0,   0,   0,   0,   0, 128,   1,
      0,   0,  32,   0,  16,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,
};

/* Sentence_Terminal: 960 bytes. */

RE_UINT32 re_get_sentence_terminal(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_sentence_terminal_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_sentence_terminal_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_sentence_terminal_stage_3[pos + f] << 5;
    pos += code;
    value = (re_sentence_terminal_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Variation_Selector. */

static RE_UINT8 re_variation_selector_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_variation_selector_stage_2[] = {
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2,
    3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_variation_selector_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_variation_selector_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,  56,   0,   0,   0,   0,   0,   0,
    255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255,   0,   0,
};

/* Variation_Selector: 236 bytes. */

RE_UINT32 re_get_variation_selector(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_variation_selector_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_variation_selector_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_variation_selector_stage_3[pos + f] << 6;
    pos += code;
    value = (re_variation_selector_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Pattern_White_Space. */

static RE_UINT8 re_pattern_white_space_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_pattern_white_space_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_pattern_white_space_stage_3[] = {
    0, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_pattern_white_space_stage_4[] = {
      0,  62,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     32,   0,   0,   0,   0,   0,   0,   0,   0, 192,   0,   0,   0,   3,   0,   0,
};

/* Pattern_White_Space: 178 bytes. */

RE_UINT32 re_get_pattern_white_space(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_pattern_white_space_stage_1[f] << 5;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_pattern_white_space_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_pattern_white_space_stage_3[pos + f] << 6;
    pos += code;
    value = (re_pattern_white_space_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Pattern_Syntax. */

static RE_UINT8 re_pattern_syntax_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_pattern_syntax_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    2, 3, 4, 5, 3, 3, 1, 6, 7, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 9,
};

static RE_UINT8 re_pattern_syntax_stage_3[] = {
     0,  1,  2,  3,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     5,  6,  4,  4,  4,  4,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  9,  4,  4,  8,  8,  8,  8,  8,  8,  8,  8,  8, 10, 11,  8,
     8,  8,  4,  4,  4,  4,  4,  4, 12,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4, 13,  4,  4,  4,  4, 14,  4,  4,  4,  4,  4,  4,
};

static RE_UINT8 re_pattern_syntax_stage_4[] = {
      0,   0,   0,   0, 254, 255,   0, 252,   1,   0,   0, 120,   1,   0,   0, 120,
      0,   0,   0,   0, 254,  90,  67, 136,   0,   0, 128,   0,   0,   0, 128,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 127,
    254, 255, 239, 127,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
    255, 255, 255, 255, 255, 255,  63,   0,   0,   0, 240, 255, 255, 255, 255, 255,
     14, 255, 255, 255,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0, 192,
     96,   0,   0,   0,   0,   0,   0,   0,
};

/* Pattern_Syntax: 364 bytes. */

RE_UINT32 re_get_pattern_syntax(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_pattern_syntax_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_pattern_syntax_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_pattern_syntax_stage_3[pos + f] << 6;
    pos += code;
    value = (re_pattern_syntax_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Prepended_Concatenation_Mark. */

static RE_UINT8 re_prepended_concatenation_mark_stage_1[] = {
    0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_prepended_concatenation_mark_stage_2[] = {
    0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_prepended_concatenation_mark_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 3, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_prepended_concatenation_mark_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  32,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,
      0,  32,   0,   0,   0,   0,   0,   0,
};

/* Prepended_Concatenation_Mark: 236 bytes. */

RE_UINT32 re_get_prepended_concatenation_mark(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_prepended_concatenation_mark_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_prepended_concatenation_mark_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_prepended_concatenation_mark_stage_3[pos + f] << 6;
    pos += code;
    value = (re_prepended_concatenation_mark_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Regional_Indicator. */

static RE_UINT8 re_regional_indicator_stage_1[] = {
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,
};

static RE_UINT8 re_regional_indicator_stage_2[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
};

static RE_UINT8 re_regional_indicator_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_regional_indicator_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 255, 255, 255,
};

/* Regional_Indicator: 130 bytes. */

RE_UINT32 re_get_regional_indicator(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_regional_indicator_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_regional_indicator_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_regional_indicator_stage_3[pos + f] << 7;
    pos += code;
    value = (re_regional_indicator_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Hangul_Syllable_Type. */

static RE_UINT8 re_hangul_syllable_type_stage_1[] = {
    0, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_hangul_syllable_type_stage_2[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  3,  4,  5,  6,
     7,  8,  9,  3,  4,  5,  6,  7,  8,  9,  3,  4,  5,  6,  7,  8,
     9,  3,  4,  5,  6,  7,  8,  9,  3,  4,  5,  6,  7,  8,  9,  3,
     4,  5,  6,  7,  8,  9,  3, 10,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_hangul_syllable_type_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  3,  4,  4,  4,  4,  4,
     0,  0,  0,  0,  0,  0,  1,  5,  0,  0,  0,  0,  0,  0,  0,  0,
     6,  7,  8,  9,  8, 10,  8,  6,  7,  8,  9,  8, 10,  8,  6,  7,
     8,  9,  8, 10,  8,  6,  7,  8,  9,  8, 10,  8,  6,  7,  8,  9,
     8, 10,  8,  6,  7,  8,  9,  8, 10,  8,  6,  7,  8,  9,  8, 10,
     8,  6,  7,  8,  9,  8, 10,  8,  6,  7,  8,  9,  8, 10,  8,  6,
     7,  8,  9,  8, 10,  8,  6,  7,  8,  9,  8, 10,  8,  6,  7,  8,
     9,  8, 10,  8,  6,  7,  8,  9,  8, 10,  8,  6,  7,  8,  9,  8,
    10,  8,  6,  7,  8,  9,  8, 10,  8,  6,  7,  8,  9,  8, 10,  8,
     8,  9,  8, 10,  8,  6,  7,  8,  9,  8, 11,  2, 12,  4,  4, 13,
};

static RE_UINT8 re_hangul_syllable_type_stage_4[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
    4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0,
};

/* Hangul_Syllable_Type: 664 bytes. */

RE_UINT32 re_get_hangul_syllable_type(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_hangul_syllable_type_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_hangul_syllable_type_stage_2[pos + f] << 4;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_hangul_syllable_type_stage_3[pos + f] << 4;
    value = re_hangul_syllable_type_stage_4[pos + code];

    return value;
}

/* Bidi_Class. */

static RE_UINT8 re_bidi_class_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  5,  6,  5,  5,  5,  5,  7,
     8,  9,  5,  5,  5,  5, 10,  5,  5,  5,  5, 11,  5, 12, 13, 14,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
    16,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
};

static RE_UINT8 re_bidi_class_stage_2[] = {
      0,   1,   2,   3,   4,   4,   4,   4,   4,   4,   5,   6,   7,   8,   9,  10,
      4,   4,  11,   4,   4,   4,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,
     22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  30,  32,  33,  34,  35,  36,
     37,  38,  28,  39,  40,  41,   4,  42,  43,  44,  45,  46,  47,  48,  49,  50,
     51,  52,  53,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,  54,  55,   4,
     56,   4,   4,   4,   4,   4,   4,   4,   4,   4,  57,   4,  58,  59,  60,  61,
     62,   4,  63,   4,  64,  65,   4,  66,  67,  68,  69,   4,  70,  71,  72,  73,
     74,   4,   4,  75,   4,   4,   4,  76,   4,   4,   4,   4,   4,   4,  77,  78,
     79,  80,  81,  82,  83,  84,  85,  86,  87,  86,  86,  86,  88,  89,  90,  86,
     91,  92,  93,  94,  86,  86,  86,  86,  86,  86,  95,  86,  86,  86,  86,  86,
      4,   4,   4,   4,  86,  86,  86,  86,  86,  86,  86,  86,  86,  96,  97,  86,
      4,   4,   4,  98,   4,  99,   4, 100,  86, 101, 102, 103,  86,  86,  86, 104,
    105,   4, 106, 107,   4,   4,   4, 108, 109, 110, 111, 112,   4, 113,   4, 114,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,  86,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4, 115, 116,   4,   4,   4,   4, 117, 118, 119, 120, 121,   4, 122,   4,
    123, 124,   4, 125, 126, 127, 128, 129, 130, 131, 132, 133,   4,   4,   4, 134,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 135, 136,  16,  16,
     16,  16,  16,  16, 137,  16,  16, 138, 139, 140,  16, 141, 142, 143,   4, 144,
      4,   4,   4,   4, 145,  86, 146, 147,   4,   4,   4, 148,   4, 149,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
    150, 150, 150, 150, 151, 150, 150, 150, 152, 150, 150, 153, 154, 150, 150, 150,
    150, 150, 150, 150, 155, 150, 150, 150, 150, 156, 150, 150, 157, 158, 150, 150,
    159, 160, 161,   4, 162, 163, 164, 165, 166,   4,   4, 167,  40, 168,   4,   4,
    169, 170, 171, 172,   4,   4, 173, 174, 175, 176, 177,   4, 178,   4,   4,   4,
    179,   4,   4,   4,   4,   4,   4, 180, 181, 182, 183,   4,   4,   4,   4,   4,
    184,   4, 185,   4, 186, 187, 188,   4,   4,   4,   4, 189,   4,   4,   4, 190,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 191, 192,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 193, 194, 195,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4, 196,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4, 197, 198,   4,  86, 199,   4,   4,  86, 200,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 201, 202, 203, 204, 205,
      4,   4,   4,   4,   4,   4,   4,   4, 206, 207, 208,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
    209,   4,   4,   4, 192,   4,   4,   4,   4,   4,   4, 210,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
    150, 150, 150, 211, 150, 212, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150,
    150, 157,  16, 150,  16, 213, 150, 150,  16,  16,  16, 214, 150, 150, 150, 150,
    215,  86, 216, 217, 218, 219,   4,   4,   4, 220,   4,   4,  86,  86,  86,  86,
     86,  86,  86,  86,  86,  86,  86,  86,  86,  86,  86, 221,  86, 103,  86, 222,
    223, 224, 225,   4, 226, 227, 228, 229,  86, 230, 231,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 232,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4, 232,
    233, 233, 233, 233,   7,   7,   7, 234, 233, 233, 233, 233, 233, 233, 233, 233,
    233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
    233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
    233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
};

static RE_UINT8 re_bidi_class_stage_3[] = {
      0,   1,   0,   2,   3,   4,   5,   6,   7,   8,   8,   9,   7,   8,   8,  10,
     11,   0,   0,   0,  12,  13,  14,  15,   8,   8,  16,   8,   8,   8,  16,   8,
      8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  17,
     18,  19,  18,  19,  20,  21,  19,  19,  22,  22,  22,  22,  22,  22,  22,  22,
     22,  22,  22,  22,  22,  22,  23,  24,  25,   8,   8,   8,   8,   8,   8,   8,
      8,   8,   8,   8,   8,   8,  24,   8,  26,  27,   8,   8,   8,   8,   8,   8,
      8,  28,  29,  22,  22,  22,  22,  30,  31,  32,  32,  32,  32,  32,  32,  32,
     33,  34,  22,  35,  36,  36,  36,  36,  36,  37,  22,  22,  38,  39,  40,  36,
     36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  41,  42,  43,  44,   5,  45,
     36,  36,  46,  36,  36,  36,  22,  22,  22,  35,  36,  36,  36,  36,  36,  36,
     36,  36,  36,  36,  41,  22,  40,  36,  32,  32,  32,  32,  32,  47,  48,  49,
     32,  32,  50,  51,  52,  53,  32,  32,  32,  32,  32,  54,  36,  36,  32,  32,
     32,  32,  32,  32,  36,  36,  36,  36,  36,  36,  37,  22,  55,  22,  22,  22,
     56,   8,   8,   8,   8,   8,   8,  57,  58,  59,  58,   8,  60,   8,   8,   8,
     61,   8,   8,   8,   8,   8,   8,  62,  63,  64,   8,   8,  60,   8,  65,  66,
     67,   8,   8,   8,   8,   8,   8,  62,  68,  69,  61,   8,   8,   8,  70,   8,
     71,  59,   8,   8,  60,   8,  72,  73,  61,   8,   8,   8,   8,   8,   8,  74,
     63,  64,  75,   8,  60,   8,   8,   8,  76,   8,   8,   8,   8,   8,   8,   8,
     77,  64,   8,   8,   8,   8,   9,  78,  79,   8,   8,   8,   8,   8,   8,  80,
     81,  82,  83,   8,  60,   8,   8,  84,   8,  85,   8,   8,  60,   8,   8,   8,
     27,   8,   8,   8,   8,   8,   8,  86,  63,  64,   8,   8,  60,   8,   8,   8,
      8,  76,  87,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  88,  89,
     90,  91,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  88,  92,
      8,  93,   8,   8,   8,   8,   8,   8,   8,   8,   8,  27,   8,   8,  94,  95,
      8,   8,   8,   8,   8,   8,  58,  91,  96,  97,  22,  58,  22,  22,  22,  92,
     75,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  97,  98,  99,
      8,   8,   8, 100,  77,   8,  63,   8, 101,  64,   8,  64,   8,   8,   8,   8,
      8,   8,   8,  97,   8,   8,   8,   8,   8,   8,  19, 102,   8,   8,   8,   8,
      7,   8,   8,   8,   8,   8,   8,   8, 103,   8,   8, 104,   8,   8,   8,   8,
      8,   8, 105,   8,   8,   8, 105,   8,   8,   8,  60,   8,   8,   8,  60,   8,
      8,   8,   8,   8,   8,   8, 106,  93,  75,  58, 107, 108,   8,   8,  19, 102,
     19, 109,   8,   8,   8,   8,   8,   8,  83,   8,   8,   8,   8,  61,   8,   8,
      8,   8,   8,   8, 110,  77,  76, 111, 112,   8,   8,   8,   8,   8,   8,   8,
      8,   8,   8, 113,  19,  19,  19,  19,   8,   8,  90, 114,   8,   8,   8,   8,
      8,   8,  75,  91, 115,  92,  26, 116,   8,   8,   8,   8,   8,   8,  22,  91,
    107,   8,   8,   8,   8,   8, 117, 118,  76,   8,   8,   8,   8,  26, 107,   8,
     27,   8,   8,   8, 119, 120,   8,   8,   8,   8,   8,   8,  75, 121,  27,   8,
      8,   8,   8,   8,   8, 122, 123,   8,   8,   8, 124,  22,  98,  59,  62,  27,
     22,  22,  22,  22,  22,  22,  22, 125,   8,   8,   8,   8,   8,   8,   8, 126,
    102,  20,   8,  20,   8,  20,   8, 127, 128, 129,  19,  19,  19, 130, 131,  19,
    132,  19,  19, 133, 134, 135, 136, 137,   5, 137,   8,   8, 138, 138, 138, 138,
    138, 138,  22,  22,  22,  22,  77,   8, 139, 102, 140, 141, 142, 143,   8, 144,
    145, 146,  19,  19,   8,   8,   8,   8,   8, 147,  19,  19,  19,  19,  19,  19,
     19,  19,  19,  19,  19,  19,  19,  19,  19,  19, 148,  19,  19,  19,  19,  19,
     19,  19,  19,  19,  19,  19, 149,   8,   8,   8,   8,   8,   8,   8,   8,   9,
     19,  19, 150,  19,  19,  19,  19,  19,  19,  19,  19,  19,  84,   8,   8,   8,
     19, 151,   8,   8,  19,  19,  19,  19,  19,   5,   5, 152,   8,   8,   8,   8,
      8,   8,   8,   8,   8,  18,  19,  19,  19,  19,  19,  19,  19, 153,  19,  19,
     19,  19,  19,  19,  19,  19, 154,  19,  19,  19, 149,  19,  19,  19,  19,  19,
      8,   8,   8,   8,  20, 155,  27, 156,   8,   8,   8,   8,   8,   8,   8,  90,
      8,   8,   8,   8,  22,  22,  22,  22,  19,  19,   8,   8,   8,   8,   8,   8,
     19,  19,  19, 157,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19, 158,   8,
     19,  19, 149,   8,   8,   8,  19, 158, 159,  19,  19,  19,   7, 119, 141,  20,
      8,   8,   8, 160,   7,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8, 161,
     19,  19,  19,  19, 158,   8,   8,   8,   8,   8,   8, 127,   8,   8,   8,   8,
      8,   8,  19,  19,   8,   8,   8, 162,   8,   8,   8,   8,   8,   8, 156,  19,
      8, 163,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  16, 151,
      8,   8,   8, 113,   8,   8,   8,  16,   8,   8,  19,  19,  19,  19,  19,  19,
     84,   8,   8,   8,   8,   8,   8,   8,   8,  20,   8,   8,   8,   8,   8,   8,
      8,   8,   8,   8,   8,  90, 164, 165,   8,   8,   8,  80,   8,   8,   8,   8,
      8,   8,   8,   8,   8,   8,  27,   8,  19,  19,  19,  19, 102,   8,   8,   8,
      8,   7,   8,   8,   8,   8,   8,   8, 166, 167,   8,   8,  83, 158,   8, 168,
      8,   8,   8,   8,   8,   8, 163,   8,  85,   8,   8,   8,  22,  22,  27,  90,
      8,   8,   8,   8,  80,  93,   8,   8,  90,  22,  27,   8,   8,   8,   8,   8,
     56,   8,   8,   8,   8,   8, 169, 170,   8,   8,   8,   8,  64,   8,   8,   8,
      8,   8,   8,   8,   8, 171,  99,   8, 167,  62,   8,   8,   8,   8,   8,  62,
      8,   8,   8,   8,   8,   8, 172,  81,  61,   8,   8,   8,   8,  85,  75,   8,
      8,   8,   8,   8,  64,  59,   8,   8,   8,   8,   8, 173,  32, 174,  32,  32,
     32,  32,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36,  36, 175,
     36,  36,   0,   0,   0,   0,  36, 176,  22,  22,  19, 102,  22,  22,  19,  19,
     19,  19, 177, 178, 179, 180,  36,  36,  36,  36,  36,  36,  36,  36,  36, 181,
    182,   4,   5,   6,   7,   8,   8,   9,   7,   8,   8,   9, 149,   8,   8,   8,
      8,   8,   8,   8, 183,  84,   0, 184, 185,   8,   8,   8,   8,   8,   8,   8,
     19, 145,  19, 158,   7,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  64,
      8,   8,   8,   8, 186,   5,   5, 152,   8,   8,   8,   8,   8,   8,  80,  56,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 187,  32,  32,  32,  32,
    188, 189,  32,  32,  32,  32,  32, 190,  32,  32,  32,  32, 191,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32, 192,  36,  36,  36,  36, 193,  36,  38, 194,
     32,  32,  32,  32,  38,  38,  38, 195,  32,  32,  32,  32,  32,  32,  36,  36,
     41,  22,  40,  36,  36,  36,  32,  32,  61,   8,   8,   8,   8,   8,   8,  22,
     91,   8,  18,  19, 149,   8,   8,  90,  27,   8,   8,   8,   8,   8, 196,  67,
     56,   8,   8,   8,  90, 197,  92,   8,   8,   8,   8,   8,   8,   8, 167,   8,
     27,   8,   8,   8,   8,   8,  80,  91,   8,  63,   8,   8,   8,   8,   8,   8,
      8,   8,   8,   8,   8,  90, 198,  75,   8,   8,   8,  90,  26,  56,   8,   8,
     77,   8,   8,   8,  80,  92,  92,   8,   8,   8,   8,   8,   8,   8,   8,  22,
     87,   8,   8,  75,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  26, 199,
    200,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8, 119, 106,
     77,   8,   8,  85,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  26, 201,
     77,   8,   8,   8,  19, 145,   8,   8,   8,   8,   8,   8,   8, 202, 203,   8,
      8,   8,   8,  97, 204, 107,   8,   8,   8,   8,   8,   8,   8,  90,  22,  67,
      8,   8, 122,  60,  77,   8,   8,   8, 171,  67,   8,   8,   8,   8,  26, 205,
     90,   8, 171, 111,   8,   8,   8,   8,   8,  73,  91,  27,   8,   8,   8,   8,
      8,   8,   8,   8,   8,   8,  91,  93,   8,   8,  73,  22,  22,  73, 206,   8,
      8,   8,   8,   8,   8,   8, 171, 207, 203,   8,   8,   8,   8,   8,   8,   8,
      8,   8, 121,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  86,   8,
      8,   8,  20, 208, 209,  19, 102,   8,   8,   8,   8,   8,   8,   8,  92,   8,
      8,   8,   8,   8,   8,   8,  91,   8,   8,  90,   8,   8,   8,   8,   8,   8,
      8,  90,  56,   8,   8,   8,   8,   8,   8,   8,   8,   8, 210,   8,   8,   8,
      8,   8,   8,  83, 211,   8,   8,   8,   8,   8,   8,   8,  90,  27, 212, 213,
    214, 107,   8,   8,   8, 119,   8,   8, 215,   8,   8,   8,   8,   8,   8,   8,
     19,  19,  84,   8,   8,   8,   8,   8,   8,   8,   8, 161,   8,   8,   8,   8,
      8,   8, 216,   8,   8,   8,   8,   8,   8,  16,   8,   8,   8,   8,   8,   8,
      8, 185,   8,   8,   8,   8,   8,   8, 161, 217,   5,   5,   5,   5,   5,   5,
     22,  22,  22,  22,  22,  22,  91,  26,  22,  22,  22,  22,  22,  92,  64,   8,
     62,   8,   8,  26,  58,  22,   8,   8,  91,  22,  22, 218, 219,  56,   8,   8,
      8,   8,   8,   8,   8, 122,   8, 220,  32,  32, 221,  32,  32,  32,  32,  32,
    189, 222,  32,  32,  32,  32,  32,  32,  36,  36,  32,  32,  32,  32,  32,  32,
     36,  36,  36,  36,  36,  36, 223,  36,  19,  19,  19,  19,  19, 158,  19,  19,
     19,  19, 158,   8,  19,  84, 156,  19, 156,  19, 156,  19,  19,  19, 149,   8,
      5, 224,   8,   8,   8,  16,   8,   8,   8,   8,   8,   8,   8, 225,   8,   8,
      8,   8,   8,   8, 149,   8,   8,   8,  19,  19, 149,   8,  19, 145,  19, 151,
     19,  19,  19,   7,  19, 158,   8,   8,  19, 158,  19,  19,  19,  19,  19,  19,
     19,   8,  19, 102,  19,  19,  19,  19,  19,   8,  19,  19,  19, 149,   8,   8,
     19, 153,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19, 139,  18,
     19,  19,  19,  19, 226, 227,  19,  19,  19, 226,  19,  19,  19,  19,  19,  19,
     19,  19, 158,   8,  19, 149, 158, 151, 151,   8, 149,   8,   8,   8,   8,   8,
      8,   8,   8,   8,   8,   8,   8, 228,   0,   0,   0,   0,   0,   0,   0,   0,
     22,  22,  22,  22,  22,  22,   0,   0,
};

static RE_UINT8 re_bidi_class_stage_4[] = {
    11, 11, 11, 11, 11, 11, 11, 11, 11,  8,  7,  8,  9,  7, 11, 11,
    11, 11, 11, 11,  7,  7,  7,  8,  9, 10, 10,  4,  4,  4, 10, 10,
    10, 10, 10,  3,  6,  3,  6,  6,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  6, 10, 10, 10, 10, 10, 10,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10, 10, 10, 10, 10,
     0,  0,  0, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11,  7, 11, 11,
     6, 10,  4,  4,  4,  4, 10, 10, 10, 10,  0, 10, 10, 11, 10, 10,
     4,  4,  2,  2, 10,  0, 10, 10, 10,  2,  0, 10, 10, 10, 10, 10,
     0,  0,  0,  0,  0,  0,  0, 10,  0, 10, 10,  0,  0,  0,  0,  0,
     0,  0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
     0,  0,  0,  0,  0, 10, 10, 10, 10, 10, 10, 10, 10, 10,  0, 10,
    12, 12, 12, 12, 12, 12, 12, 12,  0,  0,  0,  0, 10, 10,  0,  0,
     0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  0,  0, 10, 10,  0, 10,
     0,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0,  0,  0,  0,  0,  0,
     0,  0, 10,  0,  0, 10, 10,  4,  1, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12,  1, 12,  1, 12, 12,  1, 12, 12,  1, 12,
     1,  1,  1,  1,  1,  1,  1,  1,  5,  5,  5,  5,  5,  5, 10, 10,
    13,  4,  4, 13,  6, 13, 10, 10, 12, 12, 12, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  4,  5,  5, 13, 13, 13,
    12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 12, 12,
    12, 12, 12, 12, 12,  5, 10, 12, 12, 12, 12, 12, 12, 13, 13, 12,
    12, 10, 12, 12, 12, 12, 13, 13,  2,  2, 13, 13, 13, 13, 13, 13,
    13, 12, 13, 13, 13, 13, 13, 13,  1,  1,  1, 12, 12, 12, 12, 12,
    12, 12, 12, 12,  1,  1, 10, 10, 10, 10,  1,  1,  1, 12,  1,  1,
     1,  1,  1,  1,  1,  1, 12, 12, 12, 12,  1, 12, 12, 12, 12, 12,
    12, 12, 12, 12,  1, 12, 12, 12,  1, 12, 12, 12, 12, 12,  1,  1,
     1, 12, 12, 12,  1,  1,  1,  1, 12, 12,  5, 12, 12, 12, 12, 12,
    12, 12, 12,  0,  0,  0,  0,  0,  0,  0, 12,  0, 12,  0,  0,  0,
     0, 12, 12, 12, 12, 12, 12, 12, 12,  0,  0,  0,  0, 12,  0,  0,
     0,  0, 12, 12,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 12,  0,  0,  0,  0, 12, 12, 12, 12,  0,  0,  0,
     0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  4,  4,  0,  0,  0,  0,
     0,  0,  0,  4,  0,  0, 12,  0,  0, 12, 12,  0,  0,  0,  0,  0,
     0, 12, 12,  0,  0,  0,  0, 12, 12,  0,  0, 12, 12, 12,  0,  0,
    12, 12,  0,  0,  0, 12,  0,  0,  0, 12, 12, 12, 12, 12,  0, 12,
     0,  4,  0,  0,  0,  0,  0,  0,  0,  0, 12, 12, 12, 12, 12, 12,
     0,  0,  0,  0, 12,  0,  0, 12,  0,  0,  0,  0,  0,  0, 12,  0,
     0,  0, 12,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,
    10,  4, 10,  0,  0,  0,  0,  0, 12,  0,  0,  0, 12,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 12, 12, 12,  0,  0,  0,  0,  0, 12, 12,
    12,  0, 12, 12, 12, 12,  0,  0,  0,  0,  0,  0,  0, 12, 12,  0,
    10, 10, 10, 10, 10, 10, 10,  0,  0,  0,  0,  0, 12, 12,  0,  0,
     0,  0,  0, 12, 12,  0,  0,  0,  0,  0, 12, 12, 12,  0, 12,  0,
     0, 12,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0,  0,  0,  0,  4,
     0,  0,  0,  0,  0,  0,  0, 12, 12, 12, 12, 12, 12, 12, 12,  0,
    12, 12, 12, 12, 12,  0,  0,  0, 12, 12, 12, 12, 12, 12,  0,  0,
     0,  0,  0,  0,  0, 12,  0, 12,  0, 12, 10, 10, 10, 10,  0,  0,
    12, 12, 12, 12, 12,  0, 12, 12,  0,  0,  0,  0,  0, 12, 12, 12,
    12,  0, 12, 12, 12, 12, 12, 12,  0, 12, 12,  0,  0, 12, 12,  0,
    12, 12,  0,  0,  0,  0, 12, 12,  0,  0, 12,  0,  0, 12, 12,  0,
    10, 10,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0, 10, 10,  0,  0,  0,  0,  0, 12, 12, 12,  0,  0,  0,
     0,  0,  0,  0, 12, 12,  0, 12, 12, 12, 12, 12,  0,  0,  0,  0,
     0,  0,  0,  4,  0, 12,  0,  0, 10, 10, 10, 12, 12, 12, 11,  0,
    12, 12, 12,  0,  0,  0,  0, 12,  0, 12, 12, 12,  0,  0,  0,  0,
    10,  0,  0,  0, 10, 10,  0,  0,  0,  0,  0,  0,  0,  0, 10, 10,
    12,  0,  0, 12,  0,  0,  0,  0, 12,  0, 12,  0,  0, 12, 12, 12,
    12, 12, 12, 12, 12,  0,  0, 12,  0,  0,  0,  0, 12,  0, 12, 12,
    12, 12, 12,  0, 12,  0,  0,  0,  0,  0, 12, 12, 12, 12,  0,  0,
    12, 12,  0, 12, 12, 12,  0,  0, 12, 12,  0,  0,  0, 12,  0, 12,
     0,  0,  0,  0, 12, 12, 12, 12, 12, 12, 12, 12,  0,  0, 12, 12,
    12, 12, 12,  0, 12, 12, 12, 12, 12, 12,  0, 12, 12, 12, 12, 12,
     0,  0,  0,  0,  0, 10,  0, 10,  0,  0,  0,  0,  0, 10, 10,  0,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 11, 11, 11,  0,  1,
     9,  7, 16, 17, 18, 14, 15,  6,  4,  4,  4,  4,  4, 10, 10, 10,
    10, 10, 10, 10,  6, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  9,
    11, 11, 11, 11, 11, 11, 19, 20, 21, 22, 11, 11, 11, 11, 11, 11,
     2,  0,  0,  0,  2,  2,  2,  2,  2,  2,  3,  3, 10, 10, 10,  0,
     4,  4,  4,  4,  4,  4,  4,  4, 10, 10,  0, 10, 10, 10, 10,  0,
     0,  0,  0,  0, 10,  0, 10, 10, 10,  0,  0,  0,  0,  0, 10, 10,
    10, 10, 10, 10,  0, 10,  0, 10,  0, 10,  0,  0,  0,  0,  4,  0,
     0,  0, 10, 10,  0,  0,  0,  0, 10, 10, 10, 10, 10,  0,  0,  0,
     0,  0, 10, 10, 10, 10,  0,  0,  0, 10, 10, 10,  0,  0,  0,  0,
    10, 10,  3,  4, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  0,  0,
    10, 10, 10, 10, 10,  0, 10, 10, 10, 10, 10,  0,  0,  0,  0,  0,
     2,  2,  2,  2,  0,  0,  0,  0, 10, 10, 10, 10,  0, 10, 10, 10,
    10, 10, 10, 10,  0,  0, 10, 10, 10, 10, 10,  0,  0,  0,  0, 12,
     0, 10, 10, 10, 10, 10, 10, 10, 10, 10,  0, 10, 10, 10, 10, 10,
    10, 10, 10, 10,  0,  0,  0,  0,  9, 10, 10, 10, 10,  0,  0,  0,
     0, 12, 12, 10, 10,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  0,
     0,  0,  0,  0, 10, 10, 10,  0,  0,  0,  0,  0, 10, 10, 10, 10,
    12, 12, 12, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 10, 10,
     0,  0, 12,  0,  0,  0, 12,  0,  0,  0,  0, 12,  0,  0,  0,  0,
     4,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12,  0,  0, 12, 12,
    12, 12,  0,  0, 12, 12,  0,  0,  0, 12, 12, 12, 12, 12, 12,  0,
    12,  0, 12, 12, 12,  0,  0, 12,  0,  0,  0,  0,  0,  1, 12,  1,
     1,  3,  1,  1,  1,  1,  1,  1, 13, 13, 13, 13, 13, 13, 10, 10,
    13, 13, 13, 13, 13, 10, 13, 13,  6, 10,  6,  0, 10,  6, 10, 10,
    10, 10, 10, 10, 10, 10, 10,  4, 10, 10,  3,  3, 10, 10, 10,  0,
    10,  4,  4, 10,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 11,
     0, 10, 10,  4,  4,  4, 10, 10,  4,  4, 10, 10, 10,  4,  4,  0,
    11, 10, 10, 10, 10, 10, 11, 11,  0, 10,  0,  0,  0,  0,  0,  0,
    12,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1, 10,
     1, 12, 12, 12,  1, 12, 12,  1,  1,  1,  1,  1, 12, 12, 12, 12,
    12, 12, 12,  1,  1,  1,  1, 12,  1,  1,  1,  1,  1, 12, 12,  1,
     1, 10, 10, 10, 10, 10, 10, 10, 13, 13, 13, 13, 12, 12, 12, 12,
     5,  5, 13, 13, 13, 13, 13, 13,  5,  5,  5,  5,  5,  5,  5,  1,
     0,  0,  0, 12, 12, 12, 12,  0, 12, 12, 12, 12,  0, 12, 12, 12,
    12, 12,  0,  0, 12,  0, 12, 12, 12,  0, 12,  0,  0,  0,  0, 12,
    12,  0, 12, 12,  0,  0,  0,  0, 12, 12, 12,  0,  0, 12,  0, 12,
     0,  0,  0, 12,  0, 12,  0,  0, 12, 12, 12, 12, 12, 12,  0, 12,
     0,  0, 12, 12, 12, 12,  0, 12, 12,  0,  0, 12, 12, 12, 12,  0,
    12,  0, 12, 12,  0, 12, 12,  0,  0,  0, 12,  0, 12, 12,  0, 12,
    10, 10, 10, 10, 10,  4,  4,  4,  4, 10, 10, 10, 10, 10, 10, 10,
     0,  0, 10,  0,  0,  0,  0,  0, 11, 11, 11, 11,  0,  0,  0,  0,
     0,  0,  0, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12,
    12, 12, 12,  0,  0, 12, 12, 12, 10, 10, 12, 12, 12, 10,  0,  0,
     0,  0,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,
    12,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 12, 12,  0, 12, 12,
     0,  0,  0,  0,  0,  0,  0,  4, 12, 12, 12, 12, 12, 12, 12,  1,
    12, 12, 12,  1,  1,  1,  1,  1, 10, 10, 13, 13, 13, 13, 13, 13,
     2,  2,  2, 10, 10,  0,  0,  0,  0,  0, 10, 10, 10,  0,  0,  0,
    10, 10, 10,  0,  0, 10, 10, 10, 10, 10, 10,  0,  0,  0, 10, 10,
     0,  0,  0,  0,  0,  0, 11, 11,
};

/* Bidi_Class: 5072 bytes. */

RE_UINT32 re_get_bidi_class(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_bidi_class_stage_1[f] << 6;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_bidi_class_stage_2[pos + f] << 3;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_bidi_class_stage_3[pos + f] << 3;
    value = re_bidi_class_stage_4[pos + code];

    return value;
}

/* Canonical_Combining_Class. */

static RE_UINT8 re_canonical_combining_class_stage_1[] = {
     0,  1,  2,  3,  4,  4,  4,  4,  4,  4,  5,  4,  4,  4,  4,  6,
     7,  8,  4,  4,  4,  4,  9,  4,  4,  4,  4, 10,  4, 11, 12,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
};

static RE_UINT8 re_canonical_combining_class_stage_2[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   0,   0,
      0,   0,   3,   0,   0,   0,   4,   5,   6,   7,   0,   8,   9,  10,   0,  11,
     12,  13,   0,  14,  15,  16,  15,  17,  15,  18,  15,  18,  15,  18,   0,  18,
      0,  19,  15,  18,  20,  18,   0,  21,  22,  23,  24,  25,  26,  27,  28,  29,
     30,   0,  31,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  33,   0,   0,  34,
      0,   0,  35,   0,  36,   0,   0,   0,  37,  38,  39,   0,  40,  41,  42,  43,
     44,   0,   0,  45,   0,   0,   0,  46,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  48,   0,  49,   0,  50,   0,   0,   0,   0,   0,   0,   0,   0,
     51,   0,  52,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  53,  54,  55,   0,   0,   0,   0,
     56,   0,   0,  57,  58,  59,  60,  61,   0,   0,  62,  63,   0,   0,   0,  64,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  65,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  66,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,  68,   0,  69,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  70,   0,   0,  71,   0,   0,   0,   0,
      0,   0,   0,   0,  72,   0,   0,   0,   0,   0,   0,   0,   0,  73,   0,   0,
      0,  74,  75,   0,  76,  60,   0,  77,  78,   0,   0,  79,  80,  81,   0,   0,
      0,  82,   0,  83,   0,   0,  49,  84,  49,   0,  85,   0,  86,   0,   0,   0,
     75,   0,   0,   0,   0,   0,   0,  87,  88,  89,  90,   0,   0,   0,   0,   0,
     49,   0,   0,   0,   0,  91,  92,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  93,  94,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  95,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  96,  97,   0,   0,  98,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     99,   0,   0,   0,  94,   0,   0,   0,   0,   0,   0, 100,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0, 101,   0, 102,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_canonical_combining_class_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   2,   3,   4,   5,   6,   7,
      8,   9,  10,  11,  12,   1,   0,   0,  13,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  14,  15,  16,  17,  18,  19,  20,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   1,  21,   0,   0,   0,   0,   0,  22,  23,  24,   0,   0,  25,   0,
      0,   0,  26,  27,  28,  29,   0,   0,   0,   0,  30,   0,   0,   0,  31,  32,
     33,  34,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  13,  35,  36,
      0,   0,  26,  37,  38,  39,   0,   0,   0,   0,   0,  40,   0,   0,   0,   0,
      0,   0,  41,   1,  42,  43,  44,  45,   0,   0,   0,   0,   0,   0,   0,  46,
      0,  47,  48,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,  49,
      0,  47,   0,   0,   0,   0,   0,   0,   0,  47,  50,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  51,   0,  52,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  53,   0,  54,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  55,   0,  56,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  57,   0,   0,  58,  59,   0,   0,   0,   0,   0,   0,  60,  61,
     62,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  64,  65,   0,  36,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  66,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,  67,   0,
      0,   0,  52,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,  69,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  70,   0,   0,  71,  72,   0,   0,   0,   0,
      0,   0,   0,   0,  73,   0,  66,  74,   0,   0,   0,   0,   0,   0,  75,  76,
      0,   0,   0,   0,   0,   0,  46,   0,  67,   0,   0,   0,   0,  77,  78,   0,
      0,   0,   0,   0,   0,  79,   0,   0,   0,   0,   0,   0,  80,   0,  79,   0,
      0,   0,   0,   0,   0,   0,  64,   0,   0,   0,  81,  82,  83,  84,  85,  86,
     87,  88,  89,   1,   1,   1,  90,  91,   0,   0,  92,  93,  94,  95,  96,   0,
      0,   0,   0,   0,   0,  71,  86,   0,   0,   0,   0,   0,   0,   0,   0,  97,
      0,   0,   0,   0,   1,   1,   1,   1,   0,   0,   0,   0,   0,  98,   0,   0,
      0,   0,   0,  99,   0,   0,   0,   0,   0,   0,   0,   0,   0,  71, 100, 101,
      0,   0,   0,  26,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  86,   0,
    102,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   1,   1,  86,   0,
      0,   0,   0,   0,   0, 103,   0,   0,   0,   0, 104,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 105,   0,  73,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 106, 107, 108,   0,   0,   0,   0,   0, 102,   0,
      0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0, 109,   0,   0,   0,   0,
      0,   0,   0,   0, 110, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36,
      0,   0,   0,   0,  72,   0,   0,   0,   0,   0,   0,   0,   0,   0,  26, 112,
      0, 113,   0,   0,   0,   0,   0, 114,   0,   0,   0,   0, 115,   0,   0,   0,
      0,   0,   0,   0, 100,   0,   0,   0, 116, 117,  72,   0,   0,   0,   0,   0,
    102,   0,   0,   0,   0,   0,   0,  97,   0,   0,   0,   0,   0,   0,   0, 118,
    112,   0,   0,   0,   0,   0,  51,   0,  73, 119,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 120,   0,   0,   0,   0,   0,   0, 121,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 122,   0,  47,   0,   0,  26, 123, 123,   0,
    124,   0,   0,  49,   0,   0,   0,   0, 125,   0,   0,   0,   0,   0,   0,   0,
    126,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 127,   0,
      0,   0,   0,   0,   0, 104,   0,   0,   0,   0,   0,   0,  73,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  67,   0,  97,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0, 128,   0,   0,   0,   0, 129,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  97,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 130,   0,
      0,   0,   0,   0,   0,   0, 131,   0,   0,   0,   0, 132,   0,   0,   0,   0,
      0,   0,   0,   0, 133, 134, 135, 136, 137, 138,   0,   0,   0, 139,   0,   0,
    140,   0,   0,   0,   0,   0,   0,   0, 131,   1,   1, 141, 142, 112,   0,   0,
      0,   0,   0,   0,   0, 100,   0,   0,   0,   0, 143,   0,   0,   0,   0,   0,
    100, 144,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_canonical_combining_class_stage_4[] = {
     0,  0,  0,  0,  0,  0,  0,  0, 50, 50, 50, 50, 50, 50, 50, 50,
    50, 50, 50, 50, 50, 51, 45, 45, 45, 45, 51, 43, 45, 45, 45, 45,
    45, 41, 41, 45, 45, 45, 45, 41, 41, 45, 45, 45, 45, 45, 45, 45,
    45, 45, 45, 45,  1,  1,  1,  1,  1, 45, 45, 45, 45, 50, 50, 50,
    50, 50, 50, 50, 50, 54, 50, 45, 45, 45, 50, 50, 50, 45, 45,  0,
    50, 50, 50, 45, 45, 45, 45, 50, 51, 45, 45, 50, 52, 53, 53, 52,
    53, 53, 52, 50, 50, 50, 50, 50,  0,  0,  0, 50, 50, 50, 50, 50,
     0, 45, 50, 50, 50, 50, 45, 50, 50, 50, 46, 45, 50, 50, 50, 50,
    50, 50, 45, 45, 45, 45, 45, 45, 50, 50, 45, 50, 50, 46, 49, 50,
     5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 14, 15, 16, 17,  0, 18,
     0, 19, 20,  0, 50, 45,  0, 13, 25, 26, 27,  0,  0,  0,  0,  0,
     0,  0,  0, 22, 23, 24, 25, 26, 27, 28, 29, 50, 50, 45, 45, 50,
    50, 50, 50, 50, 45, 50, 50, 45, 30,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 50, 50, 50, 50, 50, 50, 50,  0,  0, 50,
    50, 50, 50, 45, 50,  0,  0, 50, 50,  0, 45, 50, 50, 45,  0,  0,
     0, 31,  0,  0,  0,  0,  0,  0, 50, 45, 50, 50, 45, 50, 50, 45,
    45, 45, 50, 45, 45, 50, 45, 50, 50, 50, 45, 50, 45, 50, 45, 50,
    45, 50, 50,  0,  0,  0,  0,  0, 50, 50, 45, 50,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 45,  0,  0, 50, 50,  0, 50, 50, 50, 50, 50,
    50, 50, 50, 50,  0, 50, 50, 50,  0, 50, 50, 50, 50, 50,  0,  0,
     0, 45, 45, 45,  0,  0,  0,  0,  0,  0,  0, 45, 50, 50, 50, 50,
    50, 50,  0, 45, 50, 50, 45, 50, 50, 45, 50, 50, 50, 45, 45, 45,
    22, 23, 24, 50, 50, 50, 45, 50, 50, 45, 45, 50, 50, 50, 50, 50,
     0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,
     0, 50, 45, 50, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0, 50,  0,
     0,  0,  0,  0,  0, 32, 33,  0,  0,  0,  0,  4,  4,  0,  0,  0,
     0,  0,  4,  0,  0,  0,  0,  0, 34, 34,  4,  0,  0,  0,  0,  0,
    35, 35, 35, 35,  0,  0,  0,  0, 36, 36,  4,  0,  0,  0,  0,  0,
    37, 37, 37, 37,  0,  0,  0,  0, 45, 45,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 45,  0, 45,  0, 43,  0,  0,  0,  0,  0,  0,
     0, 38, 39,  0, 40,  0,  0,  0,  0,  0, 39, 39, 39, 39,  0,  0,
    39,  0, 50, 50,  4,  0, 50, 50,  0,  0,  0,  0,  0,  0, 45,  0,
     0,  0,  0,  0,  0,  0,  0,  2,  0,  4,  4,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 50, 50, 50,  0,  0,  0,  0,  4,  0,  0,  0,
     0,  0,  0,  0,  0, 50,  0,  0,  0, 49,  0,  0,  0,  0,  0,  0,
     0, 46, 50, 45,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 50,
    45,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
    50, 50, 50, 50, 50,  0,  0, 45, 50, 50, 50, 50, 50, 45, 45, 45,
    45, 45, 45, 50, 50, 45,  0,  0,  0,  0,  0, 50, 45, 50, 50, 50,
    50, 50, 50, 50,  0,  0,  0,  0,  0,  0,  4,  4,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  2,  0, 50, 50, 50,  0,  1, 45, 45, 45,
    45, 45, 50, 50, 45, 45, 45, 45, 50,  0,  1,  1,  1,  1,  1,  1,
     1,  0,  0,  0,  0, 45,  0,  0,  0,  0,  0,  0, 50,  0,  0,  0,
    50, 50,  0,  0,  0,  0,  0,  0, 50, 50, 45, 50, 50, 50, 50, 50,
    50, 50, 45, 50, 50, 53, 42, 45, 41, 50, 50, 50, 50, 50, 50, 50,
    50, 50, 50, 50, 50, 50, 51, 49, 49, 45,  0, 50, 52, 45, 50, 45,
    50, 50,  1,  1, 50, 50, 50, 50,  1,  1,  1, 50, 50,  0,  0,  0,
     0, 50,  0,  0,  0,  1,  1, 50, 45, 50,  1,  1, 45, 45, 45, 45,
    50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,
     0,  0, 44, 49, 51, 46, 47, 47,  0,  3,  3,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,  0,  0,
     0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0, 45, 45, 45,  0,  0,
     0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,
    50,  0, 50, 50, 45,  0,  0, 50, 50,  0,  0,  0,  0,  0, 50, 50,
     0, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,  0,
    50, 50, 50, 50, 50, 50, 50, 45, 45, 45, 45, 45, 45, 45, 50, 50,
    50, 50, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,  0, 50,
    50,  1, 45,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0, 50, 45,  0,
     0,  0,  0,  0,  0,  0, 45, 45, 50, 50, 50, 45, 50, 45, 45, 45,
     0,  4,  2,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  4,  2,  0,  0,  2,  4,  0,  0,  0,  0,  0,
     0,  0,  0,  2,  2,  0,  0,  0, 50, 50, 50, 50, 50,  0,  0,  0,
     0,  0,  4,  0,  0,  0,  2,  0,  0,  0,  4,  2,  0,  0,  0,  0,
     2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  2,
     0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  4,  4,  0,  0,
     1,  1,  1,  1,  1,  0,  0,  0, 50, 50, 50, 50, 50, 50, 50,  0,
     0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0, 43, 43,  1,
     1,  1,  0,  0,  0, 48, 43, 43, 43, 43, 43,  0,  0,  0,  0,  0,
     0,  0,  0, 45, 45, 45, 45, 45, 45, 45, 45,  0,  0, 50, 50, 50,
    50, 50, 45, 45,  0,  0,  0,  0,  0,  0, 50, 50, 50, 50,  0,  0,
     0,  0, 50, 50, 50,  0,  0,  0, 50,  0,  0, 50, 50, 50, 50, 50,
    50, 50,  0, 50, 50,  0, 50, 50, 45, 45, 45, 45, 45, 45, 45,  0,
    50, 50,  2,  0,  0,  0,  0,  0,
};

/* Canonical_Combining_Class: 3088 bytes. */

RE_UINT32 re_get_canonical_combining_class(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_canonical_combining_class_stage_1[f] << 6;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_canonical_combining_class_stage_2[pos + f] << 3;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_canonical_combining_class_stage_3[pos + f] << 3;
    value = re_canonical_combining_class_stage_4[pos + code];

    return value;
}

/* Decomposition_Type. */

static RE_UINT8 re_decomposition_type_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  8,  9, 10, 10, 10, 10, 11,  7,  7,  7,  7, 12,
     7,  7, 13,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 14,  7,  7, 15, 16,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 17,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
};

static RE_UINT8 re_decomposition_type_stage_2[] = {
      0,   0,   0,   0,   0,   1,   2,   3,   4,   5,   6,   7,   0,   8,   9,  10,
     11,  12,   0,   0,   0,  13,  14,  15,   0,   0,  16,  17,  18,  19,  20,  21,
     22,  23,  24,  25,   0,   0,  26,  27,   0,   0,   0,   0,  28,   0,   0,   0,
      0,  29,   0,  30,   0,   0,  31,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  32,  33,   0,   0,   0,  34,   0,
      0,  35,  36,   0,   0,   0,   0,   0,   0,   0,  37,   0,  38,   0,  39,   0,
      0,   0,  40,   0,   0,   0,  41,   0,   0,   0,  39,   0,   0,   0,  42,   0,
      0,  43,   0,   0,   0,  43,  44,   0,  45,   0,  46,  47,  48,  49,   0,   0,
      0,  50,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  52,  53,  54,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  55,  56,  57,  58,  59,   0,   0,
     60,  60,  60,  60,  61,  60,  60,  62,  63,  60,  64,  65,  60,  66,  67,  68,
     69,  70,  71,  72,  73,  74,   0,   0,  75,  76,  77,  78,  79,  80,  81,   0,
     82,  83,  84,  85,  86,  87,   0,  88,   0,  89,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  90,  78,  91,  92,  93,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     94,   0,   0,  95,   0,   0,  96,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  97,   0,   0,   0,   0,   0,   0,   0,  98,   0,   0,   0,   0,
      0,   0,   0,   0,  99,   0,   0,  43,  78,  78,  78,  78,  78,  78, 100,   0,
    101, 102, 103, 104, 105, 103, 104, 106,   0, 107,  78,  78, 108,   0,   0,   0,
    109,  78, 110, 111,  92,  92, 112, 113, 114, 114, 115, 116, 114, 114, 114, 117,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 118,   0,   0,   0,   0,   0,   0, 119,   0,   0,   0, 120,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 121,   0,   0,   0,   0,   0,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60, 122,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  60,  60,  60,  60,  60,  60,  60,  60,
    123, 124,  60, 125,  60,  60,  62,   0, 126, 127, 128, 129, 130, 131, 132, 133,
    134, 134, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147,
    148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 157, 158, 159, 160, 161, 162,
      0,   0,   0,   0, 163, 164,   0,   0,   0, 165,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 166,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 167,   0,   0,   0,   0,   0,   0,   0, 168,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 169, 170,   0, 171, 172,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    173, 173, 174, 173, 175, 176, 177, 173, 178, 179, 180, 173, 173, 173, 173, 173,
    173, 173, 173, 173, 173, 181, 173, 173, 173, 173, 173, 173, 173, 173, 182, 173,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    177, 183, 184, 185, 186, 187,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 188, 189, 190, 191, 192,   0,   0,   0,
    193, 194, 195,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
     65,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_decomposition_type_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   2,   3,   4,   5,   6,   7,
      8,   9,   8,   8,  10,  11,  10,  12,   8,   9,   8,   8,  10,  11,  10,   9,
      8,   8,   8,   8,  13,   8,   8,   8,   8,  12,   8,   8,  14,   8,  10,  15,
     16,   8,  17,   8,  12,   8,   8,   8,   8,  12,   8,   8,   8,   8,   8,  15,
     12,   0,   0,  18,  19,   0,   0,   0,   0,  20,  20,  21,   8,   8,   8,  22,
      8,  13,   8,   8,  23,  12,   8,   8,   8,   8,   8,   8,   8,   8,   8,  13,
      0,  13,   8,   8,   8,   0,   0,   0,   0,   0,   0,   0,  24,  24,  25,   0,
      0,   0,   0,   0,   0,   0,  20,   5,  24,  25,   0,   0,   0,   0,   0,   0,
      9,  19,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  19,  26,  27,
      0,  21,  11,  22,  19,   0,   0,   0,   0,   0,  13,   8,  19,   0,   0,   0,
      0,   0,  13,  11,  28,  29,   0,   0,   0,   0,   0,   0,  30,   5,  31,   0,
      9,  18,   0,  11,   0,   0,  32,   0,   0,   0,   0,   0,   0,   0,  32,   0,
      0,   0,   0,   0,   9,  18,   0,  11,   0,   0,   0,   0,   0,  13,   0,   0,
     33,   0,   0,   0,   8,  13,  13,   8,  13,   8,  13,   8,   8,  12,  12,   0,
      0,   3,   0,   0,   0,   0,   0,   0,  13,  11,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  34,  35,   0,  36,   0,   0,   0,  18,   0,   0,   0,
      0,   0,  32,   0,  32,  19,   0,   0,   0,   0,   0,   0,   0,   0,   8,   8,
      0,   0,  18,  19,   0,   0,   0,   9,   0,   0,   0,   0,  18,  27,   0,   0,
      0,   0,   0,   0,   0,   0,  10,  27,   0,   0,  37,  19,   0,   0,   0,  12,
      0,   0,   0,   0,   0,  19,   0,   0,   0,   0,  13,  19,   0,   0,   0,   0,
      0,   0,  19,   0,   0,   0,   0,   0,  19,  18,  22,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  27,  11,   0,   0,   0,   0,   3,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   1,   0,   0,   0,   0,
     18,   0,   0,  32,  27,  18,   0,  19,   0,   0,  32,   0,  18,  38,  17,   0,
     32,   0,   0,   0,  18,   0,   0,  32,  27,  18,   0,  19,   0,   0,  32,   0,
      0,  27,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  25,
      0,  27,  36,  36,  27,   0,   0,   0,   0,   0,   0,   0,   0,   0,  18,  32,
      9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  39,  24,  24,  39,  24,
     24,  24,  24,  40,  24,  24,  24,  24,  41,  42,  43,   0,   0,   0,  25,   0,
      0,   0,   0,   0,   0,   0,  44,  24,  24,  24,  24,  24,  24,  24,  24,  24,
      8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,  45,   0,
      8,   8,   8,   8,   8,   8,  12,   0,   8,   8,   8,   8,   8,  12,   8,  12,
      8,  12,   8,  12,   8,   8,  46,  46,   8,   8,   8,   8,   8,   8,   8,  12,
      8,   8,   8,   8,   8,  22,   8,  47,  21,  22,   8,   8,   8,  13,   8,  10,
      8,   8,   8,   8,  13,  22,   8,  48,  49,  50,  30,   0,  51,   3,   0,   0,
      0,  30,   0,  52,   3,  53,   0,  54,   0,   3,   5,   0,   0,   3,   0,   3,
      0,   0,   0,   0,  55,  24,  24,  24,  42,  42,  42,  43,  42,  42,  42,  56,
      0,   0,  35,   0,   0,   0,   0,   0,  57,  34,  58,  59,  59,  60,  61,  62,
     63,  64,  65,  66,  66,  67,  68,  59,  69,  61,  62,   0,  70,  70,  70,  70,
     20,  20,  20,  20,  20,  20,  20,  20,   0,   0,  71,   0,   0,   0,  13,   0,
      0,   0,   0,  27,   0,   0,   0,   0,   0,   0,   0,  10,   0,   0,   0,   0,
      0,  19,  32,  19,   0,   0,   0,   0,   0,  36,   0,  72,  35,   0,   0,   0,
     32,  37,  32,   0,   0,   0,   0,   0,  36,   0,   0,  10,  12,  12,  12,   0,
     12,  12,  12,   0,   0,   0,   0,   0,   0,   0,   0,   8,   0,   0,   0,   0,
      8,   0,  13,  12,   0,   0,   0,   0,   0,   0,  33,   0,   0,   0,   0,   0,
     73,  73,  73,  73,  73,  20,  20,  20,  20,  20,  20,  20,  20,  74,  73,  73,
     73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  75,   0,   0,   0,   0,   0,
      0,   0,   0,  35,   0,   0,   0,   0,   0,   0,   0,   0,   0,  30,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  19,   0,   0,   0,   0,   0,   0,   0,  76,
      0,   0,   0,  44,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,
     20,  20,  20,  20,  20,   5,   0,   0,  77,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  26,  30,   0,   0,   0,   0,  36,  36,  36,  36,  36,
     36,  46,  32,   0,   9,  22,  33,  12,   0,   0,   0,   0,   0,  19,   3,  78,
      0,   0,   0,   0,   0,  37,  11,  79,   0,   0,   0,   0,  34,  20,  20,  20,
     20,  20,  20,  30,   4,  24,  24,  24,  20,  20,  20,  20,  20,  20,  20,  30,
     20,  73,   0,   0,  80,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  75,
     20,  20,  20,  81,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  82,
     81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  81,  20,  20,
     20,  20,  20,  20,  83,  81,  81,  81,  20,  20,  20,  20,  20,  20,  20,  84,
      0,   0,   0,   0,   0,   0,   0,  55,   0,   0,   0,   0,  25,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  55,   0,   0,   0,   0,   0,   0,   0,   0,  24,
      8,   0,   0,   0,   0,   0,   0,   0,   8,   8,   8,  12,  36,  10,   8,  11,
     36,  33,  13,   8,   8,   8,   8,   8,   8,   8,   8,  12,   8,   8,   8,   8,
     20,  30,   0,   0,   3,  20,   0,  46,  59,  59,  85,   8,   8,  11,   8,  36,
      9,  22,   8,  15,  86,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,  87,
     87,  86,  86,  86,  87,  87,  87,  87,  88,  86,  87,  87,  89,   0,   0,   0,
      0,   0,   0,   0,  90,  91,  92,  93,  86,  88,  87,  86,  86,  86,  94,  88,
     95,  95,  95,  95,  95,  95,  95,  95,  95,  96,  96,  96,  96,  96,  96,  96,
     96,  96,  96,  96,  96,  97,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98,
     98,  98,  98,  98,  98,  98,  98,  99, 100, 100, 100, 100, 100, 101,  95,  95,
     95,  95,  95,  95, 102,  96,  96,  96,  96,  96,  96, 103,  98, 100, 100, 104,
      0,   0,   0,   0, 105,  98, 106, 107, 108, 106, 109, 106, 105,  97,  96, 106,
     97, 110, 111,  98, 112, 107, 113, 106,  96,  96,  96,  96,  96, 107, 114,  96,
     97, 107,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  95,  95,  95, 115,
      0,   0,   0,   0, 116, 116, 117,   0,   0,   0,   0,   0, 116, 116, 116, 116,
    116, 118, 119,  20, 120, 121, 121, 121, 121, 120, 121,   0, 122, 123, 124, 124,
    125,  92, 126, 127,  91, 126, 128, 128, 128, 128, 127,  92, 126, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 127, 126, 127,  92, 129,
    130, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,
    132, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133,
    133, 133, 133, 133, 133, 133, 133, 134, 135, 133, 135, 133, 135, 133, 135, 136,
    131, 137, 133, 134,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  27,  19,
      0,   0,  18,   0,   0,   0,   0,   0,   0,   0,   0,  13,   0,   0,   0,   0,
      0,   0,  18,  19,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  18,  36,
      0,   0,   0,   0,   0,   0,  13,   0,   0,   0,   0,   0,   0,   0,   0,  13,
      8,  19,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  18,   8,
     19,   0,   0,   0,   0,   0,   0,   0,  59,  59,  59,  59,  59,  59,  59,  59,
     59,  59,  59,  59,  59, 138,  59,  59,  59,  59,  59,  59,  59,  59,  59, 138,
    139, 140,  61, 138,  59,  59,  66,  61,  59,  61,  59,  59,  59,  59,  59,  59,
     59,  66, 141,  61,  59, 138,  59, 138,  59,  59,  59,  59,  59,  59,  66, 141,
     59, 142, 143,  59, 138,  59,  59,  59,  59,  62,  59,  59,  59,  59,  59,  59,
     59,  59,  59, 143,  59,  59,  59,  59, 140, 144,  61,  59, 141,  59, 145,   0,
    139, 146, 145,  61, 140, 144, 145, 145, 140, 144, 141,  59, 141,  59,  61, 142,
     59,  59,  66,  59,  59,  59,  59,   0,  61,  61,  66,  59,  59,  59,  59,   0,
     20,  20,  30,   0,  20,  20,  20,  20,  20,  20, 147,  75,  81,  81,  81,  81,
     81,  81,  81,  81,   0,   0,   0,   0,   0,   0,   4,  25,   0,   0,   0,   0,
      0,   0,   0,   0, 148,   0,   0,   0, 149,   0,   0,   0,  81,  81,  81,  81,
     81,  81,  81,  81,  81,  81,  81,   0,  20,  20,  35,   0, 150,   0,   0,   0,
};

static RE_UINT8 re_decomposition_type_stage_4[] = {
     0,  0,  0,  0,  4,  0,  0,  0,  2,  0, 10,  0,  0,  0,  0,  2,
     0,  0, 10, 10,  2,  2,  0,  0,  2, 10, 10,  0, 17, 17, 17,  0,
     1,  1,  1,  1,  1,  1,  0,  1,  0,  1,  1,  1,  1,  1,  1,  0,
     1,  1,  0,  0,  0,  0,  1,  1,  1,  0,  2,  2,  1,  1,  1,  2,
     2,  0,  0,  1,  1,  2,  0,  0,  0,  0,  0,  1,  1,  0,  0,  0,
     2,  2,  2,  2,  2,  1,  1,  1,  1,  0,  1,  1,  1,  2,  2,  2,
    10, 10, 10, 10, 10,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,
     2,  2,  2,  1,  1,  2,  2,  0,  2,  2,  2,  0,  0,  2,  0,  0,
     0,  1,  0,  0,  0,  1,  1,  0,  0,  2,  2,  2,  2,  0,  0,  0,
     1,  0,  1,  0,  1,  0,  0,  1,  0,  1,  1,  2, 10, 10, 10,  0,
    10, 10,  0, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11,  0,
     0,  0,  0, 10,  1,  1,  2,  1,  0,  1,  0,  1,  1,  2,  1,  2,
     1,  1,  2,  0,  1,  1,  2,  2,  2,  2,  2,  4,  0,  4,  0,  0,
     0,  0,  0,  4,  2,  0,  2,  2,  2,  0,  2,  0, 10, 10,  0,  0,
    11,  0,  0,  0,  2,  2,  3,  2,  0,  2,  3,  3,  3,  3,  3,  3,
     0,  3,  2,  0,  0,  3,  3,  3,  3,  3,  0,  0, 10,  2, 10,  0,
     3,  0,  1,  0,  3,  0,  1,  1,  3,  3,  0,  3,  3,  2,  2,  2,
     2,  3,  0,  2,  3,  0,  0,  0, 17, 17, 17, 17,  0, 17,  0,  0,
     2,  2,  0,  2,  9,  9,  9,  9,  2,  2,  9,  9,  9,  9,  9,  0,
    11, 10,  0,  0, 13,  0,  0,  0,  2,  0,  1, 12,  0,  0,  1, 12,
    16,  9,  9,  9, 16, 16, 16, 16,  9,  9,  9, 16,  2, 16, 16, 16,
     2,  2,  2, 16,  3,  3,  1,  1,  8,  7,  8,  7,  5,  6,  8,  7,
     8,  7,  5,  6,  8,  7,  0,  0,  0,  0,  0,  8,  7,  5,  6,  8,
     7,  8,  7,  8,  7,  8,  8,  7,  5,  8,  7,  5,  8,  8,  8,  8,
     7,  7,  7,  7,  7,  7,  7,  5,  5,  5,  5,  5,  5,  5,  5,  6,
     6,  6,  6,  6,  6,  8,  8,  8,  8,  7,  7,  7,  7,  5,  5,  5,
     7,  8,  0,  0,  5,  7,  5,  5,  7,  5,  7,  7,  5,  5,  7,  7,
     5,  5,  7,  5,  5,  7,  7,  5,  7,  7,  5,  7,  5,  5,  5,  7,
     0,  0,  5,  5,  5,  7,  7,  7,  5,  7,  5,  7,  8,  0,  0,  0,
    12, 12, 12, 12, 12, 12,  0,  0, 12,  0,  0, 12, 12,  2,  2,  2,
    15, 15, 15,  0, 15, 15, 15, 15,  8,  6,  8,  0,  8,  0,  8,  6,
     8,  6,  8,  6,  8,  8,  7,  8,  7,  8,  7,  5,  6,  8,  7,  8,
     6,  8,  7,  5,  7,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13,
    13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,  0,  0,  0, 14, 14,
    14,  0,  0,  0, 13, 13, 13,  0,  3,  0,  3,  3,  0,  0,  3,  0,
     0,  3,  3,  0,  3,  3,  3,  0,  3,  0,  3,  0,  0,  0,  3,  3,
     3,  0,  0,  3,  0,  3,  0,  3,  0,  0,  0,  3,  2,  2,  2,  9,
    16,  0,  0,  0, 16, 16, 16,  0,  9,  9,  0,  0,
};

/* Decomposition_Type: 3868 bytes. */

RE_UINT32 re_get_decomposition_type(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_decomposition_type_stage_1[f] << 6;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_decomposition_type_stage_2[pos + f] << 3;
    f = code >> 2;
    code ^= f << 2;
    pos = (RE_UINT32)re_decomposition_type_stage_3[pos + f] << 2;
    value = re_decomposition_type_stage_4[pos + code];

    return value;
}

/* East_Asian_Width. */

static RE_UINT8 re_east_asian_width_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  5,  6,  5,  5,  7,  8,  9,
    10, 10, 10, 10, 10, 10, 11,  5, 12, 10, 10, 13, 10, 10, 10, 14,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 15,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    16, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8, 17,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8, 17,
};

static RE_UINT8 re_east_asian_width_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9, 10,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
     9,  9,  9, 27,  9,  9, 28,  9,  9,  9,  9,  9,  9, 29, 30, 31,
    32, 33, 34, 35, 36, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 37, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 38,  9,  9,  9,  9,  9,  9,
     9,  9, 39,  9,  9,  9,  9,  9, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 40,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
    41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
    41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
    41, 41, 30, 30, 30, 30,  9,  9,  9,  9,  9,  9, 42,  9, 43, 44,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 45,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 46,
    30, 30, 30, 30, 30, 47,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    30, 30, 48, 30, 30, 49,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    50, 51, 52, 53, 54,  9, 55, 56, 57, 58, 59, 60, 61, 62,  9, 63,
     9,  9, 64, 65, 66, 67,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 68,
     9,  9, 41,  6,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
    41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 69,
};

static RE_UINT8 re_east_asian_width_stage_3[] = {
      0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,
      0,   0,   0,   0,   3,   4,   5,   6,   7,   0,   8,   9,  10,  11,  12,  13,
     14,   0,  15,  16,  17,  16,  18,   8,  19,  20,  21,   0,  17,  16,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   7,  22,  23,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  14,   0,  14,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  24,  25,  26,  27,   0,   0,   0,   0,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,   0,   0,
      0,   0,  29,  28,  30,  31,  29,  28,  30,  31,   0,   0,   0,   0,   0,   0,
     14,   0,  28,  28,  28,  28,  28,  28,  28,  28,  14,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   0,
      0,   0,  33,  34,   6,   0,  35,  36,   0,   0,   0,   0,   0,   0,  37,  38,
     39,   0,   0,   0,   0,  40,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     41,  14,  36,   0,  42,  16,   0,   0,   0,   0,  43,  44,  28,  45,  28,  31,
      0,  14,  28,  31,   0,   0,   0,  31,   0,   0,  46,   0,  38,   0,   0,   0,
     12,  47,  48,  49,  50,  51,  52,  53,   0,  54,  55,   0,  56,  57,   0,   0,
     57,   0,  58,  14,  58,   0,   0,  38,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  55,  59,   0,  60,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  61,  62,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  30,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  45,  28,  28,  28,  28,  45,   0,
     28,  28,  63,   0,  30,  31,  57,  53,  64,  65,  31,   0,  63,  38,   0,  66,
     67,  68,  69,  70,   0,   0,   0,   0,  71,  32,  72,   0,  73,  74,   0,  75,
      0,   0,  76,  17,  77,  59,   0,  78,  79,  80,  81,  28,  82,  83,  84,  85,
     86,  59,   0,   0,   0,  87,   0,  58,   0,  88,  89,   0,   0,   0,  17,  28,
      0,   0,  90,   0,   0,   0,  87,  75,   0,   0,   0,   0,  91,  92,   0,   0,
     93,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  94,   0,   0,   0,   0,   0,   0,  95,  31,   0,   0,   0,   0,
     32,  32,  32,  96,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  72,   0,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  97,   0,   0,   0,  32,  72,
     98,  32,  32,  32,  32,  32,  32,  99, 100,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  99, 100,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,
     90,  32,  32,  32,  32,  32, 100,  32,  32,  32,  32,  32,  32,  32,  32,  32,
     32,  99,  32,  32,  32,  32,  32, 101,  32,  32,  32,  32,  72,   0,  32,  32,
     32,  32,  32,  99,  32,  32,  32,  32,  32,  28,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   0,   0,   0,   0,   0,
     32, 102,  32,  32,  32,  32,  32,  32,  99,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,  32,  32, 102,
     32,  32,  32,  32,  72,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  32, 103,   0,   0,  32,  32,  32,  32, 104,  32,  99,  72,   0,   0,
    105, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 107, 108, 108, 108,
    108, 108, 108, 108, 108, 108, 108, 109, 110, 110, 110, 111, 112, 109,   0,  58,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  72,   0,   0,   0,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   0,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 101,   0,
     32,  32,  32,  99,   0,   0,   0,   0,   0,   0, 101,   0, 113,   0,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  72,
    114,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  75,   0,   0,   0,   0,   0,   0,
     28, 115,  28,  28,  28, 116,  28,  28,  28,  28,  28,  28,  28,  31,  28,  28,
     28,  80, 117, 118,  28, 119,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    101,   0,  32,  32,  32,  32,  32,  72,  32,  87, 103,   0,  97,   0,   0,   0,
     32,  32,  32,  32,  87,  90, 120,  32,  32,  32,  32,  32,  32,  32,  32, 121,
     32,  32,  72,   0,  32,  32,  32,  32,  32, 122,  72,   0,  32,  32, 123,  32,
     32,  32,  32,  32,  32,  32,  32,  99, 124,  32,  32,  32,  32,  32,  32,  32,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 125,
     32,  32,  32,  32,  32,  32,  32,  97,   0, 126,  32,  32,  32,   0,   0, 127,
      0,   0,  66,   0, 114,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,   0,   0,   0,   0,   0,   0,
     32,  32,  32,  32,  32,  32,  32,  32,  97, 114, 129,   0,   0,  94, 113, 101,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,  72,   0,   0,
      0,  90,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32, 130, 131,
     32,  32,  32,  32, 132, 133,  32,  32,  32, 132,  32,  32,  32,  32,  32,  32,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  72, 101,
    101,   0,  97,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  32,  97,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28, 116,
};

static RE_UINT8 re_east_asian_width_stage_4[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 0, 0, 1, 5, 5, 1, 5, 5, 1,
    1, 0, 1, 0, 5, 1, 1, 5, 1, 1, 1, 1, 1, 0, 1, 1,
    1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0,
    1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0,
    1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0,
    0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
    0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0,
    1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
    1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 3, 1, 0, 0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0,
    0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0,
    0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0,
    0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1,
    0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1,
    1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0,
    0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0,
    1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0,
    0, 3, 3, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0,
    3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1,
    0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 1, 1, 0,
    0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 3, 3, 0, 0,
    0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1,
    1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 3, 1, 0, 0, 0, 0, 3, 3, 1, 1,
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1,
    1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 3, 1, 1, 1, 1, 1,
    1, 1, 3, 3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1,
    0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 3, 3, 3, 0, 3,
    0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 0, 5, 5,
    5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0,
    0, 0, 0, 3, 3, 0, 0, 0, 3, 0, 0, 0, 0, 3, 1, 1,
    3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0,
    4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0,
    0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 0, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 2, 2, 2, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 3, 3, 3, 3,
    0, 0, 0, 0, 3, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 0, 0, 1, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
    3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 0, 3, 3,
    3, 3, 3, 0, 0, 0, 0, 3, 3, 0, 0, 0, 3, 0, 0, 0,
    3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3,
    0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 0, 0,
    3, 3, 0, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3,
};

/* East_Asian_Width: 3040 bytes. */

RE_UINT32 re_get_east_asian_width(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_east_asian_width_stage_1[f] << 5;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_east_asian_width_stage_2[pos + f] << 4;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_east_asian_width_stage_3[pos + f] << 3;
    value = re_east_asian_width_stage_4[pos + code];

    return value;
}

/* Joining_Group. */

static RE_UINT8 re_joining_group_stage_1[] = {
    0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_joining_group_stage_2[] = {
    0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_joining_group_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  1,  2,  3,  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,
     0, 14, 15,  0, 16, 17, 18, 19,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 20,  0,  0,  0, 21, 22,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 23, 24, 25,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    26, 27, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_joining_group_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     45,   0,   3,   3,  43,   3,  45,   3,   4,  41,   4,   4,  13,  13,  13,   6,
      6,  31,  31,  35,  35,  33,  33,  39,  39,   1,   1,  11,  11,  55,  55,  55,
      0,   9,  29,  19,  22,  24,  26,  16,  43,  45,  45,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,  29,
      0,   3,   3,   3,   0,   3,  43,  43,  45,   4,   4,   4,   4,   4,   4,   4,
      4,  13,  13,  13,  13,  13,  13,  13,   6,   6,   6,   6,   6,   6,   6,   6,
      6,  31,  31,  31,  31,  31,  31,  31,  31,  31,  35,  35,  35,  33,  33,  39,
      1,   9,   9,   9,   9,   9,   9,  29,  29,  11,  38,  11,  19,  19,  19,  11,
     11,  11,  11,  11,  11,  22,  22,  22,  22,  26,  26,  26,  26,  56,  21,  13,
     41,  17,  17,  14,  43,  43,  43,  43,  43,  43,  43,  43,  55,  47,  55,  43,
     45,  45,  46,  46,   0,  41,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,  31,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  35,  33,   1,   0,   0,  21,
      2,   0,   5,  12,  12,   7,   7,  15,  44,  50,  18,  42,  42,  48,  49,  20,
     23,  25,  27,  36,  10,   8,  28,  32,  34,  30,   7,  37,  40,   5,  12,   7,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  51,  52,  53,
      4,   4,   4,   4,   4,   4,   4,  13,  13,   6,   6,  31,  35,   1,   1,   1,
      9,   9,  11,  11,  11,  24,  24,  26,  26,  26,  22,  31,  31,  35,  13,  13,
     35,  31,  13,   3,   3,  55,  55,  45,  43,  43,  54,  54,  13,  35,  35,  19,
     89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,   0,   0,   0,   0,   0,
      4,   4,  13,  39,   9,  29,  22,  24,  45,  45,  31,  43,  57,   0,   6,  33,
     11,  58,  31,   1,  19,   0,   4,   4,   4,  31,  45,  86,  87,  88,   0,   0,
     59,  61,  61,  65,  65,  62,   0,  83,   0,  85,  85,   0,   0,  66,  80,  84,
     68,  68,  68,  69,  63,  81,  70,  71,  77,  60,  60,  73,  73,  76,  74,  74,
     74,  75,   0,   0,  78,   0,   0,   0,   0,   0,   0,  72,  64,  79,  82,  67,
      0,   0, 100,   0,   0,   0,   0,   0,   0, 100,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0, 101,   0,   0, 100,   0, 101,   0,
    101,   0,   0, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

/* Joining_Group: 788 bytes. */

RE_UINT32 re_get_joining_group(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_joining_group_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_joining_group_stage_2[pos + f] << 5;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_joining_group_stage_3[pos + f] << 4;
    value = re_joining_group_stage_4[pos + code];

    return value;
}

/* Joining_Type. */

static RE_UINT8 re_joining_type_stage_1[] = {
     0,  1,  2,  3,  4,  4,  4,  4,  4,  4,  5,  4,  4,  4,  4,  6,
     7,  8,  4,  9,  4,  4, 10,  4,  4,  4,  4, 11,  4, 12, 13,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
    14,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
};

static RE_UINT8 re_joining_type_stage_2[] = {
      0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   3,   0,   0,
      0,   0,   4,   0,   0,   0,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,
     15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  23,  25,  26,  27,  28,  29,
     30,  31,  26,  32,  33,  34,   0,  35,  36,  37,  38,  39,  40,  41,  42,  43,
     44,  45,  46,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  48,  49,  50,  51,
     52,  53,  54,   0,  55,   0,   0,   0,  56,  57,  58,   0,  59,  60,  61,  62,
     63,   0,   0,  64,   0,   0,   0,  65,   0,   0,   0,   0,   0,   0,   0,   0,
     66,  67,   0,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  69,   0,  70,   0,  71,   0,   0,   0,   0,   0,   0,   0,   0,
     72,   0,  73,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  74,  75,  76,   0,   0,   0,   0,
     77,  78,   0,  79,  80,  81,  82,  83,  84,  85,  86,  87,   0,   0,   0,  88,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  89,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  90,   0,   0,  70,   0,   0,   0,  91,
      0,   0,   0,   0,   0,   0,   0,  92,   0,   0,   0,  93,   0,  94,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  95,   0,   0,  96,   0,   0,  97,   0,
      0,   0,   0,   0,  98,   0,   0,   0,   0,   0,   0,   0,  99, 100,   0,   0,
    101, 102, 103,   0, 104, 105, 106, 107, 108,   0,   0, 109,  33, 110,   0,   0,
    111, 112, 113, 114,   0,   0, 115, 116, 117, 118, 119,   0, 120,   0,   0,   0,
    121,   0,   0,   0,   0,   0,   0, 122, 123, 124, 125,   0,   0,   0,   0,   0,
    126,   0, 127,   0, 128, 129, 130,   0,   0,   0,   0, 131,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    132,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 133, 134,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 135, 136,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0, 137,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 138, 139,   0,   0, 140,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 141, 142, 143,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    144,   0,   0,   0, 134,   0,   0,   0,   0,   0,   0, 145,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0, 146, 147, 148,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    149,   2,   0,   0,   2,   2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_joining_type_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,
      3,   4,   0,   0,   0,   0,   0,   0,   0,   0,   5,   2,   2,   2,   2,   6,
      7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   8,   9,  10,  11,  12,
     13,  14,   2,   2,   0,  15,  16,  12,  12,  17,  17,  18,  12,  12,  12,  12,
     19,  20,  21,  22,  22,  23,   0,  24,   0,  25,  26,  27,  12,  28,   2,   2,
      2,  29,  12,  30,  12,  31,  32,  18,   0,   0,   0,   0,  33,   2,  34,   0,
      0,  35,  12,  12,  12,  36,  37,  38,   0,   0,  33,  39,  40,  41,   0,   0,
     42,  43,  44,  45,  46,  47,   0,   0,   0,   0,   0,   0,  12,  48,  49,  50,
      0,   0,   3,   2,  39,   2,   2,   2,  51,   0,   0,   0,   0,   0,   0,  52,
      5,  53,   5,   0,  54,   0,   0,   0,  55,   0,   0,   0,   0,   0,   0,  56,
     57,   1,   0,   0,  54,   0,   0,  58,  59,   0,   0,   0,   0,   0,   0,  56,
     60,  61,  55,   0,   0,   0,  62,   0,  63,  53,   0,   0,  54,   0,   0,  64,
     55,   0,   0,   0,   0,   0,   0,  65,  57,   1,  58,   0,  54,   0,   0,   0,
     66,   0,   0,   0,   0,   0,   0,   0,  34,   1,   0,   0,   0,   0,   0,   0,
     67,   0,   0,   0,   0,   0,   0,  33,  68,  69,  70,   0,  54,   0,   0,   0,
     58,  71,   0,   0,  54,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,  72,
     57,   1,   0,   0,  54,   0,   0,   0,   0,  66,  73,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  74,  51,  25,  75,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  74,  76,   0,  77,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   4,   0,   0,  78,  55,   0,   0,   0,   0,   0,   0,   5,  75,
     79,  80,   2,   5,   2,   2,   2,  76,  58,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  80,  81,  82,   0,   0,   0,  83,  34,   0,  57,   0,
     84,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,  80,   0,   0,   0,   0,
      0,   0,  85,   0,   0,   0,  85,   0,   0,   0,  54,   0,   0,   0,  54,   0,
      0,   0,   0,   0,   0,   0,  86,  77,  58,   5,  37,   1,   0,   0,   0,   0,
     87,  88,   0,   0,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  89,
     90,  12,  12,  12,  12,  91,   0,   0,   0,   0,   0,   0,  92,  34,  66,  45,
      0,   0,  25,  93,   0,   0,   0,   0,   0,   0,  58,  75,  94,  76,   3,  22,
      0,   0,   0,   0,   0,   0,   2,  75,  37,   0,   0,   0,   0,   0,  95,   8,
     66,   0,   0,   0,   0,   3,  37,   0,   4,   0,   0,   0,  96,  97,   0,   0,
      0,   0,   0,   0,  58,  98,   4,   0,   0,   0,   0,   0,   0,  99, 100,   0,
      0,   0, 101,   2,  81,  53,  56,   4,   2,   2,   2,   2,   2,   2,   2,  39,
      0, 102,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,  76,  64,   0,   0,
      0,   0,   2,   2,   2,   2,  34,   0,   0,   0,   0,   0,   0,  25,   4,   0,
      0,   0,   0,   0,   0,   0,   0,  25,   0,   0,   0,   0,   2,   2,   2,   2,
      0,   0,   0,   0,   0,  96,   0,   0,   0,   0,   0,  59,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  25, 101,  77,   0,   0,   0,  33,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   4,   0, 104, 105,   0,   0,  70,   0,   0,   0,
     12,  12,  12,  12,  12,  12, 106,   0,  71,   0,   0,   0,   2,   2,   4,  25,
      0,   0,   0,   0,  33,  77,   0,   0,  25,   2,   4,   0,   0,   0,   0,   0,
     51,   0,   0,   0,   0,   0, 107, 108,   0,   0,   0,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0, 109,  82,   0, 105,  56,   0,   0,   0,   0,   0,  56,
      0,   0,   0,   0,   0,   0, 110,  68,  55,   0,   0,   0,   0,  71,  58,   0,
      0,   0,   0,   0,   1,  53,   0,   0,   0,   0,   0,  58,   0,   0,   0,   0,
      2,   2,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,  45,
      0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,  34,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  33,  51, 111,  99,   0,   0,   0,   0,   0,  92,
    112, 113, 114, 115, 116, 117,   0,   0, 118, 119, 120,   0,   0, 121,   0,   0,
    122,  12,  12,  12, 123,   0,   0,   0,   0,   0,   0,   0,   0,   0, 124,  12,
    125,   2, 126,   0,   0,   0,   0,   0,  55,   0,   0,   0,   0,   0,   0,   2,
     75,   0,   0,   0,   0,   0,   0,  25,   4,   0,   0,   0,   0,   0, 127,  59,
     51,   0,   0,   0,  25,  40,  76,   0,   0,   0,   0,   0,   0,   0, 105,   0,
      4,   0,   0,   0,   0,   0,  33,  75,   0,  57,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  25, 128,  58,   0,   0,   0,  25,   3,  51,   0,   0,
     34,   0,   0,   0,  33,  76,  76,   0,   0,   0,   0,   0,   0,   0,   0,   2,
     73,   0,   0,  58,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3, 129,
    130,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  96,  86,
     34,   0,   0,  71,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3, 131,
     34,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 132,   6,   0,
      0,   0,   0,  80, 133,  37,   0,   0,   0,   0,   0,   0,   0,  25,   2,  59,
      0,   0,  99,  54,  34,   0,   0,   0,   5,  51,   0,   0,   0,   0,   3, 134,
     25,   0, 109,  45,   0,   0,   0,   0,   0,  64,  75,   4,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  75,   6,   0,   0,  64,   2,   2,  64, 135,   0,
      0,   0,   0,   0,   0,   0, 109, 136,   6,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  98,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  72,   0,
      0,   0,   0,   0,   0,   0,   2,  34,   0,   0,   0,   0,   0,   0,  76,   0,
      0,   0,   0,   0,   0,   0,  75,   0,   0,  25,   0,   0,   0,   0,   0,   0,
      0,  25,  51,   0,   0,   0,   0,   0,   0,   0,   0,  70,  37,   0,   0,   0,
      0,   0,   0,   0,  25,   4,   3,   2, 137,  37,   0,   0,   0,  96,   0,   0,
     85,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,  75,   3,
      2,   2,   2,   2,   2,  76,   1,   0,  56,   0,   0,   3,   5,   2,   0,   0,
     75,   2,   2, 138, 139,  51,   0,   0,   0,   0,   0,   0,   0,  99,   0,   0,
      0,   0,  75,   0,   0,   0,   0,   0,  12,  12,  12,  12,  12,  12,  12,  12,
    140,  37,   0,   0,   0,   0,   0,   0,  55,   0,   0,   0,   2,   2,   2,   2,
};

static RE_UINT8 re_joining_type_stage_4[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0,
    5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 5, 5, 5, 5, 5,
    5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 0, 5, 0, 5, 5, 0, 5, 5, 0, 5,
    5, 5, 5, 0, 5, 0, 0, 0, 2, 0, 3, 3, 3, 3, 2, 3,
    2, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2,
    3, 2, 2, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 2, 2,
    5, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 2, 3, 2, 3, 2, 2, 3, 3, 0, 3, 5, 5,
    5, 5, 5, 5, 5, 0, 0, 5, 5, 0, 5, 5, 5, 5, 3, 3,
    0, 0, 2, 2, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 5,
    3, 5, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 2,
    3, 2, 3, 2, 3, 2, 2, 3, 5, 5, 5, 0, 0, 3, 2, 2,
    2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2,
    2, 3, 2, 3, 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 5, 5,
    5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 5, 0, 0, 5, 5, 0, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 0, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 0,
    3, 2, 2, 2, 2, 2, 3, 3, 2, 3, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 3, 2, 0, 0, 0, 5, 5, 5, 0, 0, 0, 0,
    2, 0, 2, 2, 2, 2, 0, 3, 2, 3, 3, 0, 0, 0, 0, 0,
    2, 2, 3, 3, 3, 0, 3, 2, 2, 3, 3, 2, 2, 0, 2, 2,
    2, 3, 2, 2, 2, 2, 0, 0, 5, 5, 5, 0, 0, 0, 0, 0,
    0, 0, 5, 0, 5, 0, 0, 0, 5, 0, 0, 0, 0, 5, 0, 0,
    0, 0, 5, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5, 0, 0, 0, 0, 5, 5, 5, 5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 0, 0, 5, 5, 0, 0, 0, 0, 0,
    0, 5, 5, 0, 0, 0, 0, 5, 5, 0, 0, 5, 5, 5, 0, 0,
    5, 5, 0, 0, 0, 5, 0, 0, 0, 5, 5, 5, 5, 5, 0, 5,
    0, 0, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 5, 0, 0, 5,
    0, 0, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 5, 0, 0, 0,
    5, 0, 0, 0, 0, 0, 5, 5, 5, 0, 5, 5, 5, 5, 0, 0,
    0, 0, 0, 0, 0, 5, 5, 0, 0, 0, 0, 0, 5, 5, 0, 0,
    0, 0, 0, 5, 5, 0, 0, 0, 0, 0, 5, 5, 5, 0, 5, 0,
    0, 5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0,
    5, 5, 5, 5, 5, 0, 0, 0, 5, 5, 5, 5, 5, 5, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 5, 5, 5, 5, 5, 5, 0, 5, 5,
    0, 0, 0, 0, 0, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,
    0, 5, 5, 0, 0, 5, 5, 0, 5, 5, 0, 0, 0, 0, 5, 5,
    0, 0, 5, 0, 0, 5, 5, 0, 0, 0, 5, 5, 5, 0, 0, 0,
    0, 0, 0, 0, 5, 5, 0, 5, 0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 1, 5, 5, 5, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 5, 2, 2, 5, 2, 0, 0, 0, 0, 0,
    5, 5, 5, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0,
    5, 0, 5, 0, 0, 5, 5, 5, 0, 0, 0, 0, 5, 0, 5, 5,
    0, 0, 5, 5, 5, 5, 0, 0, 5, 5, 0, 5, 5, 5, 0, 0,
    5, 5, 0, 0, 0, 5, 0, 5, 0, 0, 0, 0, 5, 5, 5, 5,
    5, 5, 5, 5, 0, 0, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5,
    0, 0, 0, 5, 0, 1, 5, 5, 0, 0, 5, 5, 5, 5, 5, 0,
    0, 0, 5, 0, 0, 0, 5, 0, 0, 0, 0, 5, 0, 0, 0, 0,
    2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 5, 5,
    5, 5, 0, 0, 5, 5, 0, 0, 0, 5, 5, 5, 5, 5, 5, 0,
    5, 0, 5, 5, 5, 0, 0, 5, 0, 5, 5, 5, 0, 5, 5, 0,
    2, 2, 2, 2, 2, 3, 0, 3, 0, 3, 3, 0, 0, 4, 3, 3,
    3, 3, 3, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 3, 2, 2,
    2, 3, 0, 0, 3, 5, 5, 0, 0, 0, 0, 2, 2, 2, 2, 3,
    2, 3, 2, 3, 3, 3, 2, 2, 2, 3, 2, 2, 3, 2, 3, 3,
    2, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 2, 2, 0,
    4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 5, 5, 5, 5,
    2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 5, 5,
    5, 2, 2, 2, 3, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 0,
    5, 5, 0, 0, 5, 0, 5, 5, 5, 0, 5, 0, 0, 0, 0, 5,
    5, 0, 5, 5, 0, 0, 0, 0, 5, 5, 5, 0, 0, 5, 0, 5,
    0, 0, 0, 5, 0, 5, 0, 0, 0, 0, 5, 5, 5, 5, 0, 5,
    5, 0, 0, 5, 5, 5, 5, 0, 5, 0, 5, 5, 0, 5, 5, 0,
    0, 0, 5, 0, 5, 5, 0, 5, 5, 5, 5, 0, 0, 5, 5, 5,
    5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 0, 5, 5,
    2, 2, 2, 2, 5, 5, 5, 5,
};

/* Joining_Type: 3560 bytes. */

RE_UINT32 re_get_joining_type(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_joining_type_stage_1[f] << 6;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_joining_type_stage_2[pos + f] << 3;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_joining_type_stage_3[pos + f] << 3;
    value = re_joining_type_stage_4[pos + code];

    return value;
}

/* Line_Break. */

static RE_UINT8 re_line_break_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  5,  6,  7,  8,  9, 10, 11,
    12, 13, 14, 15, 16, 10, 17,  5, 18, 10, 10, 19, 10, 20, 21, 22,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 23,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 23,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    24, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
};

static RE_UINT8 re_line_break_stage_2[] = {
      0,   1,   2,   2,   2,   3,   4,   5,   2,   6,   7,   8,   9,  10,  11,  12,
     13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,
     29,  30,  31,  32,  33,  34,  35,  36,  37,   2,   2,   2,   2,  38,  39,  40,
     41,  42,  43,  44,  45,  46,  47,  48,  49,  50,   2,  51,   2,   2,  52,  53,
     54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,
      2,   2,   2,  70,   2,   2,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,
     81,  82,  83,  84,  85,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  86,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
     87,  79,  79,  79,  79,  79,  79,  79,  79,  88,   2,   2,  89,  90,   2,  91,
     92,  93,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 100,
    101, 102, 103, 104, 105, 106, 100, 101, 102, 103, 104, 105, 106, 100, 101, 102,
    103, 104, 105, 106, 100, 101, 102, 103, 104, 105, 106, 100, 101, 102, 103, 104,
    105, 106, 100, 101, 102, 103, 104, 105, 106, 100, 101, 102, 103, 104, 105, 106,
    100, 101, 102, 103, 104, 105, 106, 100, 101, 102, 103, 104, 105, 106, 100, 101,
    102, 103, 104, 105, 106, 100, 101, 102, 103, 104, 105, 106, 100, 101, 102, 107,
    108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 109,  79,  79,  79,  79, 110, 111,   2,   2, 112, 113, 114, 115, 116, 117,
    118, 119, 120, 121, 109, 122, 123, 124,   2, 125, 126, 109,   2,   2, 127, 109,
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 109, 139, 109, 140, 141,
    142, 143, 144, 145, 146, 147, 148, 109, 149, 150, 109, 151, 152, 153, 154, 109,
    155, 156, 109, 157, 158, 159, 109, 109, 160, 161, 162, 163, 109, 164, 109, 165,
      2,   2,   2,   2,   2,   2,   2, 166, 167,   2, 168, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
      2,   2,   2,   2, 169, 170, 171,   2, 172, 109, 109, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109,   2,   2,   2, 173, 174, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
      2,   2,   2,   2, 175, 176, 177, 178, 109, 109, 109, 109, 179, 180, 181, 182,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79, 183,
     79,  79,  79,  79,  79, 184, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
     79,  79, 185,  79,  79, 186, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 187, 188, 109, 109, 109, 109, 109, 109,
      2, 189, 190, 191, 192, 193, 194, 109, 195, 196, 197,   2,   2, 198,   2, 199,
      2,   2,   2,   2, 200, 201, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    202, 109, 203, 109, 109, 204, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
      2, 205, 206, 109, 109, 109, 109, 109, 207, 208, 209, 109, 210, 211, 109, 109,
     79,  79, 212, 213,  79,  79,  79, 214, 215, 216, 217, 218, 219, 220, 221, 222,
    223, 224, 225, 226, 227,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79, 228,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79, 228,
    229, 109, 230, 231, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
    109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
};

static RE_UINT16 re_line_break_stage_3[] = {
      0,   1,   0,   0,   2,   3,   4,   5,   6,   6,   6,   7,   6,   6,   6,   8,
      9,   0,   0,   0,  10,  11,  12,  13,   6,   6,  14,   6,   6,   6,  14,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,  14,  15,  16,  17,   6,   6,   6,   6,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  18,   0,  19,  20,   0,   6,  21,
     22,  23,   6,   6,  24,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
     25,  26,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,  27,   6,   6,   6,  28,  27,   6,   6,   6,   6,
      6,  29,  30,   0,   0,   0,   0,  31,  32,  33,  34,  34,  34,  35,  36,  33,
      6,  37,   0,  38,   6,   6,   6,   6,   6,  25,   0,   0,   4,  39,  40,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  41,  42,  42,  43,   4,  44,
      6,  45,  46,   6,   6,   6,   0,   0,   0,  47,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,  48,   0,  49,  33,   4,  44,   6,   6,   6,  25,  50,  51,
      6,   6,  48,  52,  53,  54,   6,  28,   6,   6,   6,  55,   6,  56,  33,  33,
     33,  33,  33,  33,   6,   6,  57,  58,  33,  33,  59,   0,  52,   0,   0,   0,
     50,   6,   6,   6,   6,   6,   6,  60,   0,   0,  61,   6,  62,   4,   6,   6,
     63,  64,  65,   6,   6,  66,  67,  68,  69,  70,  71,  72,  73,   4,  74,  75,
     76,  77,  65,   6,   6,  66,  78,  79,  80,  81,  82,  83,  84,   4,  85,  33,
     76,  45,  24,   6,   6,  66,  86,  68,  87,  88,  89,  33,  73,   4,  90,  91,
     76,  64,  65,   6,   6,  66,  86,  68,  69,  81,  92,  72,  73,   4,   6,  33,
     93,  94,  95,  96,  97,  94,   6,  98,  99, 100, 101,  33,  84,   4,   6, 102,
    103,  57,  66,   6,   6,  66,   6, 104, 105, 100, 106,  56,  73,   4, 107,   6,
    108,  57,  66,   6,   6,  66, 109,  68, 105, 100, 106, 110,  73,   4, 111,  33,
    112,  57,  66,   6,   6,   6,   6, 113, 105, 114, 115,   6,  73,   4,   6, 116,
    117,   6,  28, 118,   6,   6,  24, 119,  28, 120, 121,   0,  84,   4, 122,  33,
    123, 124, 124, 124, 124, 124, 124, 125, 124, 126,   4, 127,  33,  33,  33,  33,
    128, 129, 124, 124, 130, 124, 124, 131, 132, 131,   4, 133,  33,  33,  33,  33,
    134, 135, 136,  26,   4,  44, 137, 138,   6,  27,   6,   6,   6, 139,  30, 140,
    141, 142,   0,  30,   0,   0,   0, 143, 144,  57, 145, 146,  33,  33,  33,  33,
    124, 124, 124, 124, 124, 124, 124, 124,   4, 147, 124, 124, 124, 124, 124, 124,
    124, 124,   4, 148,   6,   6,   6,   6,  45, 149,   6,   6,   6,   6,   6,   6,
    150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 151, 151, 151, 151,
    151, 151, 151, 151, 151, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152,
      6,   6,   6,   6,   6,   6,   6,   6,   6,  95,  28,  95,   6,   6,   6,   6,
      6,  95,   6,   6,   6,   6,  95,  28,  95,   6,  28,   6,   6,   6,   6,   6,
      6,   6,  95,   6,   6,   6,   6,   6,   6,   6,   6, 153, 154,   6,   6, 139,
      6,   6,   6, 155,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  58,  58,
    156,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
    156,   6,   6, 157,   6,   6,   6,   6,   6,   6,   6,   6,   6, 158,   6,  89,
      6,  57, 159,  33,   6,   6, 160,  33,   6,   6, 161,  33,   6,  57, 162,  33,
    124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 163, 164,   4, 165,   6, 155,
    166, 167,   4, 165,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  89,
    168,   6,   6,   6,   6, 169,   6,   6,   6,   6,   6,   6,   6,   6,  58,  33,
      6,   6,   6,  28,   0, 170,   0, 170, 171,   4, 124, 124, 124, 131, 172,  33,
    124, 124, 124, 124, 124, 173, 124, 124, 124, 174,   4, 175,   6,   6,   6,   6,
      6,   6, 176, 177, 124, 124, 124, 124, 124, 124, 124, 178, 124, 124, 124, 179,
      4, 165,   4, 165, 124, 131,   0, 180,  33,  33,  33,  33,  33,  33,  33,  33,
    103,   6,   6,   6,   6,   6, 181,   0, 103, 182,   4, 183, 156,  25,  50, 139,
    184,   6,   6,   6,  61, 185,   4,  44,   6,   6,   6,   6,  48,   0, 170,  22,
      6,   6,   6,   6, 181,   0,   0, 186,   4, 187,   4,  44,   6,   6,   6, 188,
      6,  89,   6,   6,   6,   6,   6, 189,   6,  33, 190,   0,   0, 191, 192, 193,
      6,   6,   6,   6,   6,   6,   6,   6,   0,   0,   0,   0,   0,   0,   0, 194,
      6,   6,  58,  58,   6,   6,   6,   6,  58,  58,   6, 195,   6,   6,   6,  58,
      6,   6,   6,   6,   6,   6,  57,   6,  57,   6, 196, 109,   6,   6, 197, 198,
    199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211,   0, 212, 213,
    214, 215,   6, 139, 216, 217, 218, 219, 217, 217,   0,   0,   0,   0, 220,  33,
    221, 116, 222,   6, 223, 224,   6,   6,   6,   6, 225, 226, 227, 228, 227, 229,
      6, 230, 227, 229,   6,   6,   6,   6,   6,   6, 231,   6,   6,   6,   6,   6,
    232, 233, 234, 235, 236, 237, 238, 225,   6, 239, 240,   6, 241, 242,   6,   6,
    242,   6, 243, 244, 243,   6,   6,  14,   6,   6,   6,   6,   6, 245,   6,   6,
      6, 246, 240, 247,   6, 248,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 249,   6,
      6,   6,   6,   6,  28,  33,  33,  33,   6,  56,  33,  33, 227, 227, 227, 227,
    227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 227, 250,
    227, 227, 227, 227, 227, 227, 227, 227, 227, 228, 227, 227, 227, 227, 251,   6,
    227, 227, 252,   6, 253, 229, 242, 225, 254, 255, 229,   6, 252,  14,   6,   6,
    256, 257, 258, 259,   6,   6,   6, 260, 261,   6,   6,   6, 262, 263,   6, 264,
      6,   6,   6, 265,   6,   6,   6, 266, 267, 268, 269, 270, 271, 272, 273, 274,
    275, 276,   6,   6,   6,   6,   6,   6,   6,   6,  14, 277, 278, 279, 280, 227,
    227, 227, 228,   6,   6,   6,   6,   6, 281,   6,   6,   6, 282, 279,   6,   6,
    283, 284, 284, 285,   6,   6,   6,   6,   6,   6,   6, 246,   6,   6,   6, 286,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 287, 229,   6,   6, 196,   6,
      6,   6,  58,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,  28,   6,   6,   6,   6,   6,  28,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 176, 288, 289,
      6,   6,   6,   6,  45, 149,   6,   6,   6,   6,   6,   6,   6, 290, 291,  71,
      6,   6,  28,  33,  28,  28,  28,  28,  28,  28,  28,  28,   0,   0,   0,   0,
    292, 293, 294, 295, 296, 297, 298, 299, 300, 301,  33,  33,  33,  33,  33,  33,
    267, 267, 267, 302, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 303,  33,
    267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,
    267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 304,  33,  33,  33, 267, 303,
    305, 279, 306, 307, 267, 308, 309, 310, 311, 312, 267, 267, 313, 267, 267, 267,
    314, 315, 316, 317, 318, 312, 267, 267, 313, 267, 267, 267, 314, 315, 319, 320,
    321, 267, 267, 267, 267, 267, 322, 267, 267, 267, 267, 267, 267, 267, 267, 267,
    267, 323, 267, 267, 267, 267, 267, 324, 267, 267, 267, 267, 303,  33, 325, 325,
    267, 267, 267, 323, 267, 267, 267, 267, 267, 227, 267, 267, 267, 267, 267, 267,
    267, 267, 267, 267, 267, 267, 267, 267,   6,   6,   6,   6,   6,   6,   6,   6,
    267, 267, 326, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,
    267, 327, 267, 267, 267, 267, 267, 267, 323,  33,   6,   6,   6,   6,   6, 188,
      6, 328,   6,   6,   4, 329,  33,  33,   6,   6,   6,   6,   6, 176, 190, 185,
      6,   6,   6,  48,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 330,  33,
      6,   6,   6,   6,   6,   6,   6,   6, 331,  33,  33,  33,  33,  33, 290,   6,
    332, 333,   6,   6,  25, 182,   6, 334,   6,   6,   6,   6,   6,   6, 335,  33,
     26,   6,   6,   6,   6,   6, 181,   0, 336, 337,   4, 165,   0,   0,  26, 338,
      4,  44,   6,   6,  48, 339,   6,   6, 176,   0, 170, 290, 150, 150, 150, 340,
     50,   6,   6,   6,   6,   6,  25,   0, 341, 342,   4, 343, 124, 124,   4, 344,
      6,   6,   6,   6,   6,  61, 180,  33, 333, 345,   4, 346, 124, 124, 124, 124,
    124, 124, 124, 124, 124, 124, 124, 124, 347,  33,  33, 348,   6,  25, 349,  33,
    350, 350, 350,  33,  28,  28,   6,   6,   6,   6,   6,   6,   6,  33,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  25, 351,   4, 165,
    352, 353, 353, 354, 353, 353, 353, 352, 353, 353, 354, 353, 353, 353, 352, 353,
    353, 354, 353, 353, 353, 352, 353, 353, 354, 353, 353, 353, 352, 353, 353, 354,
    353, 353, 353, 352, 353, 353, 354, 353, 353, 353, 352, 353, 353, 354, 353, 353,
    353, 352, 353, 353, 354, 353, 353, 353, 352, 353, 353, 354, 353, 353, 353, 352,
    353, 353, 354, 353, 353, 353, 352, 353, 353, 354, 353, 353, 353, 352, 353, 353,
    354, 353, 353, 353, 352, 353, 353, 354, 353, 353, 353, 352, 353, 353, 354, 353,
    353, 353, 352, 353, 353, 354, 353, 353, 353, 352, 353, 353, 354, 353, 353, 353,
    353, 352, 353, 353, 355,  33, 151, 151, 356, 357, 152, 152, 152, 152, 152, 358,
    359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359, 359,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
     28,  33, 360, 361,  34, 362, 363, 364, 365,  34,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6, 155,  33, 360,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6, 366,  33,  33,   6,   6,   6,   6,   6,   6,
      6,   6, 118,   6,   6,   6,   6,   6,   6,  33,  33,  33,  33,  33,   6, 367,
      0,   0, 368, 369,   0,   0, 370, 284, 371, 372, 373, 374, 323, 375,  57,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 376,
    377, 378, 267, 379, 267, 267, 267, 380, 267, 267, 267, 381, 382, 325, 383, 267,
    267, 267, 267, 384, 267, 267, 267, 323, 385, 385, 385, 386, 387,  28,  33, 388,
      6, 109,   6,   6,  28,   6,   6, 389,   6,  58,   6,  58,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  56,
    390,   6,   6,   6,   6,   6, 391,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,  28,   6, 182,  89,  33,  33,  33,  33,  33,   6,   6,   6,   6,   6, 392,
      6,   6,   6, 139,   6,   6,   6,   6,   6,   6,  89,  33,  40,   6,   6, 182,
      6,   6,   6,   6, 182, 393,   6,   6,   6,  56,   6,   6,   6,   6,  48, 394,
      6,   6,   6, 395,   6,   6,   6,   6, 182,   6, 396,  33,  33,  33,  33,  33,
      6,   6,   6,  58,   4, 165,   6,   6,   6,   6, 182,   6,   6,   6,   6, 182,
      6,   6,   6,   6,   6,  33,   6,   6,   6,   6,   6,   6, 182, 290,  33,  33,
      6,   6,   6,   6,   6,   6,  28,  33,   6,   6,  58,  33,   6,  33,  33,  33,
     58,  66,   6,   6,   6,   6,  45, 397,   6,   6, 395,   6,   6,   6,   6,   6,
      6,   6,   6,  28, 290,   6,  33,  33,  33,  33,  33,  33,   6,   6, 398, 360,
      6,   6,   6, 399,   6,   6,   6, 400,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,  22,   6,   6, 118,   6,   6,   6,   6,   6,
    401, 402, 109,  27,   6,   6,  58,  80,   6,  89, 403,  89,   6,   6,   6,   6,
      6,   6,   6,   6,  33,  33,  33,  33,   6,   6,   6,   6, 404, 360, 405,  33,
      6,   6,   6,   6,   6,   6,  58, 406,   6,   6,  58,   6,   6,   6,  56,   6,
      6,   6, 155, 407,  33,  27,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6,  89,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,  56,  33,   6,   6,   6,   6,   6,   6,  56, 118,
      6,   6,   6,   6, 181,  33,   4, 165,  33,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   6,   6,   6,  28,
      6,   6,   6,   6,   6,  33,   6,   6,  48,   0,  40, 155,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   6,   6,  28,  33,
    184,   6,   6,   6,   6,   6,   6,   0, 140, 396, 118,   6, 408,   4,  33,  71,
    184,   6,   6,   6,   6,   6,   0, 409, 410, 149,   6,   6,   6,  89,   4, 165,
    184,   6,   6,   6, 176,   0, 411,   4, 412,  33,   6,   6,   6,   6, 413,  33,
    184,   6,   6,   6,   6,   6,  25,   0, 414, 415,   4, 416,  27,   6, 139,  33,
      6,   6,  24,   6,   6, 181,   0, 417,  33,  33,  33,  33,  33,  33,  33,  33,
     28, 418,   6,  45,   6, 419,   6,   6,   6,   6,   6, 176,   0, 394,   4, 165,
    112,  64,  65,   6,   6,  66,  86, 420,  69,  81, 101, 393, 421, 422, 422,  33,
      6,   6,   6,   6,   6,   6, 142,   0, 423, 424,   4, 425,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   0,   0,  50,  33,   4, 165,  33,  33,  33,  33,
      6,   6,   6,   6,   6, 176, 336,   0, 426, 427, 403, 345,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   0,   0, 428,  33,   4, 165, 429, 430,  33,  33,
      6,   6,   6,   6,   6,  25,   0,  89,   4, 165,  33,  33,  33,  33,  33,  33,
    124, 124, 124, 431, 124, 173,   4, 432,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6, 181,   0, 433,  33,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,   6,   6,   6,   6,   6,   6,   6,   6,   4,  44,  56, 290,
     33,  33,  33,  33,   6, 118,   6,   6,   6,   6,  61, 434, 435,  33,  33,  33,
     61, 184,   6,   6,   6,   6,  25, 436, 437,  33,  61,  50,   6,   6,   6,   6,
      6, 438,   0, 439, 440,  33,  33,  33,   6,   6,   6,   6,   6,   6,   6,  89,
      6,  66,   6,   6,   6, 176, 180,   0, 441,  33,   4,  44,   6, 139, 442,   6,
      6,   6, 434,   0,   0,  30, 180,  33,  33,  33,  33,  33,  33,  33,  33,  33,
     28,  24,   6,   6,   6,   6, 443, 444, 445,  33,   4, 165,  45,  66,   6,   6,
      6, 446, 194,  89,   4, 165,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   6,   6, 447,  89,
     33,  33,  33,  33,  33,  33,  33,  33,   6,   6,   6, 448, 449,   6, 155, 450,
      6,   6,   6, 155,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  28, 451,  33,
      6,   6,   6,   6,   6,   6,   6,   6, 182,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 452,   6,   6,   6,   6,
    453, 454,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 455,
      6,   6,   6,   6,   6,  28, 456, 457,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6, 282,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,  28,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,  89,   6,   6,   6,  28,   4, 458,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   6,   6,   6,  58, 459,  33,
      6,   6,   6,   6,   6,   6, 140, 460, 461,  33,   4, 462,  24,   6,   6, 393,
      6,   6,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6, 463, 464,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6, 465,  61,   0,   0,   0,   0,   0,
      0,  71, 184,   6,  33,  33,  33,  33,  33,  33,  33,  33, 466,  33,  33,  33,
    267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,  33,
    267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 324,  33,
    267, 267, 267, 323,  33,  33,  33,  33,  33,  33, 467,  33, 468,  33, 267, 267,
    267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 303,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  56,   6, 139,
      6,  89,   6, 469, 170,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  58,  33,
      6,   6,   6,   6,  28,  27,   6,   6,   6,   6,   6,   6, 142, 470,   0,   0,
    471,  50,   6,   6,   6, 472,   6,   6,   6,   6,   6,   6,   6,  89,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6, 473,  33,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,   6,   6, 182,  33,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  28,  33,   6,   6,   6,  89,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  57,   6,   6,   6,   6,   6,
      6,   6,   6,  57, 474, 475,   6, 476, 109,   6,   6,   6,   6,   6,   6,   6,
     45, 189,  57,  57,   6,   6,   6, 477, 478, 118,  66,   6,   6,   6,   6,   6,
      6,   6,   6,   6,  58,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6, 479,   4,   4,   4,   4,   4,   4,
      0,   0,   0,   0,   0,   0, 423,  25,   0,   0,   0,   0,   0, 103, 480,   6,
    481, 482,  33,  59,  30,   0,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
    180,   0,   0, 483, 484, 394,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6, 139, 423,  58,   4, 343,  33,  33,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,   6,   6,   6,   6,   6, 181,   4, 485,
      6,   6,   6,   6,   6,   6,   6,   6,  64,   6, 180,  33,  33,  33,  33,  33,
      6,   6,   6,   6,   6,   6,   6,   6, 181, 433,   4, 486,  33,  33,  33,  33,
     33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  33,  27,   6,
      6,   6,   6,   6,   6, 487, 488,  33,  33,  33,  33,  33,  33,  33,  33,  33,
     27,   6,   6,   6,   6,   6,   6,  58,  33,  33,  33,  33,  33,  33,  33,  33,
    109,   6,   6,   6, 489,  27, 490, 491, 492, 493, 489, 195, 489, 490, 490,  83,
      6,  24,   6, 182, 494,  24,   6, 182,  33,  33,  33,  33,  33,  33, 155,  33,
    227, 495, 227, 227, 227, 496, 227, 227, 227, 227, 227, 227, 227, 497, 227, 227,
    227, 227, 227, 227, 227, 495, 267, 267, 267, 267, 267, 267, 498, 499, 499, 499,
    500, 267, 267, 501, 267, 267, 502, 503, 504, 505, 267, 267, 267, 267, 267, 506,
    267, 267, 267, 267, 267, 267, 267, 267, 507, 508, 509, 267, 510, 508, 508, 511,
    512, 513, 514, 267, 515, 516, 517, 267, 267, 267, 267, 267, 267, 267, 267, 267,
    264, 267, 518,   6, 266, 267, 519,   6,   6, 520, 267, 267, 267, 267, 521, 522,
    267, 267, 523, 267, 267, 267, 267, 267, 267, 267, 249, 524, 267, 267, 249, 520,
    267, 267, 267, 267, 267, 267, 267, 267, 525, 526,   6,   6,   6,   6, 527, 528,
    267, 267, 267, 267, 529, 267, 530, 267, 509, 531, 267, 267, 267, 267, 267, 267,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 524, 267,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 266, 267, 267, 267, 267, 267,
      6, 524,   6,   6,   6,   6,   6,   6,   6, 267,   6, 520,   6,   6,   6,   6,
      6, 267,   6,   6,   6, 532, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,
      6, 533, 267, 508, 534, 267, 508, 535, 267, 267, 267, 267, 267, 267, 267, 267,
    267, 267, 267, 267, 267, 267, 536, 537, 267, 525, 538, 539, 267, 267, 267, 267,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 524, 267, 267, 267, 267, 267,
    267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 304,
     82,  33,  33,  33,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  33,  33,
};

static RE_UINT8 re_line_break_stage_4[] = {
    16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 22, 20, 20, 21, 16, 16,
    19,  6,  3, 12,  9, 10, 12,  3,  1, 36, 12,  9,  8, 15,  8,  7,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  8,  8, 12, 12, 12,  6,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  1,  9, 36, 12, 12,
    12, 12, 12,  1, 18,  2, 12, 16, 16, 16, 16, 16, 16, 29, 16, 16,
     4,  1, 10,  9,  9,  9, 12, 25, 25, 12, 25,  3, 12, 18, 12, 12,
    10,  9, 25, 25, 17, 12, 25, 25, 25, 25, 25,  3, 25, 25, 25,  1,
    12, 12, 12, 12, 12, 12, 12, 25, 17, 25, 25, 25, 17, 25, 12, 12,
    25, 12, 12, 12, 12, 12, 12, 12, 25, 25, 25, 25, 12, 25, 12, 17,
    16, 16, 16, 16, 16, 16, 16,  4, 16, 16, 16, 16,  4,  4,  4,  4,
     4,  4,  4, 16, 16, 16, 16, 16,  0,  0, 12, 12, 12, 12,  8, 12,
     0,  0,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 12,  0, 12, 12,
    12, 12,  0, 12, 12, 12, 12, 12, 12, 12, 12, 16, 16, 16, 16, 16,
    16, 16, 12, 12, 12, 12, 12, 12,  0, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12,  0, 12,  8, 18,  0,  0, 12, 12,  9,
     0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18, 16,
    12, 16, 16, 12, 16, 16,  6, 16,  0,  0,  0,  0,  0,  0,  0,  0,
    37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,  0,  0,  0,  0, 37,
    37, 37, 37, 12, 12,  0,  0,  0, 12, 10, 10, 10,  8,  8, 12, 12,
    16, 16, 16,  6, 16,  0,  6,  6, 11, 11, 10, 11, 11, 12, 12, 12,
    16, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  6, 12, 16, 16,
    16, 16, 16, 16, 16, 12, 12, 16, 16, 12, 16, 16, 16, 16, 12, 12,
    11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  0, 12,
    12, 16, 12, 12, 12, 12, 12, 12, 16, 16, 16,  0,  0, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 16, 16, 16, 12,  0,  0,  0,  0,  0,  0,
    16, 16, 16, 16, 12, 12, 12, 12,  8,  6, 12,  0,  0, 16,  9,  9,
    16, 16, 12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 16, 16, 16,
    12, 16, 16, 16, 16, 16,  0,  0, 12, 16, 16, 16,  0,  0, 12,  0,
    12, 12, 12,  0,  0,  0,  0,  0, 12, 12, 12, 12, 12,  0, 12, 12,
    12, 12, 12, 12, 12, 12,  0,  0,  0,  0,  0, 16, 16, 16, 16, 16,
    12, 12, 16, 16, 16, 12, 16, 16, 12, 16, 16, 16, 16, 16, 16, 16,
    12, 12, 16, 16, 18, 18, 11, 11, 12, 16, 16, 16,  0, 12, 12, 12,
    12, 12, 12, 12, 12,  0,  0, 12, 12,  0,  0, 12, 12, 12, 12, 12,
    12,  0, 12, 12, 12, 12, 12, 12, 12,  0, 12,  0,  0,  0, 12, 12,
    12, 12,  0,  0, 16, 12, 16, 16, 16, 16, 16, 16, 16,  0,  0, 16,
    16,  0,  0, 16, 16, 16, 12,  0,  0,  0,  0,  0,  0,  0,  0, 16,
     0,  0,  0,  0, 12, 12,  0, 12, 12, 12, 16, 16,  0,  0, 11, 11,
    12, 12, 10, 10, 12, 12, 12, 12, 12, 10, 12,  9, 12, 12, 16,  0,
     0, 16, 16, 16,  0, 12, 12, 12, 12, 12, 12,  0,  0,  0,  0, 12,
    12,  0, 12, 12,  0, 12, 12,  0, 12, 12,  0,  0, 16,  0, 16, 16,
    16, 16, 16,  0,  0,  0,  0, 16, 16,  0,  0, 16, 16, 16,  0,  0,
     0, 16,  0,  0,  0,  0,  0,  0,  0, 12, 12, 12, 12,  0, 12,  0,
     0,  0,  0,  0,  0,  0, 11, 11, 16, 16, 12, 12, 12, 16, 12,  0,
    12,  0, 12, 12,  0, 12, 12, 12, 16, 16, 16, 16, 16, 16,  0, 16,
    16, 16,  0, 16, 16, 16,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,
    12,  9,  0,  0,  0,  0,  0,  0,  0, 12, 16, 16, 16, 16, 16, 16,
     0,  0,  0,  0,  0,  0, 16, 16,  0,  0, 16, 12,  0, 12, 12, 12,
    12, 12, 12,  0,  0,  0, 12, 12, 12,  0, 12, 12, 12, 12,  0,  0,
     0, 12, 12,  0, 12,  0, 12, 12,  0,  0,  0, 12, 12,  0,  0,  0,
    12, 12,  0,  0,  0,  0, 16, 16, 16, 16, 16,  0,  0,  0, 16, 16,
    16,  0, 16, 16, 16, 16,  0,  0, 12,  0,  0,  0,  0,  0,  0, 16,
    12,  9, 12,  0,  0,  0,  0,  0, 16, 16, 16, 16, 16, 12, 12, 12,
    12, 12,  0,  0,  0, 12, 16, 16, 16, 16, 16, 16, 16,  0, 16, 16,
     0,  0,  0,  0,  0, 16, 16,  0,  0,  0,  0,  0,  0,  0,  0, 17,
    12, 16, 16, 16, 17, 12, 12, 12, 12, 12, 12, 12,  0, 12, 12, 12,
     0,  0,  0,  0,  0,  0, 12,  0,  0, 12, 12,  0,  0,  0,  0,  0,
    16, 16, 16, 16,  0, 12, 12, 12, 12, 12, 12, 16, 16, 12, 16, 16,
    16,  0, 16, 16, 16, 16, 12, 12,  0,  0,  0,  0, 12, 12, 12, 16,
    12, 10, 12, 12, 12, 12, 12, 12,  0,  0, 16, 16,  0, 12, 12, 12,
     0,  0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  0, 12,  0,  0,
     0,  0, 16,  0,  0,  0,  0, 16, 16, 16, 16, 16, 16,  0, 16,  0,
     0,  0, 16, 16, 12,  0,  0,  0,  0, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,  0,  0,  0,  0,  9,
    24, 24, 24, 24, 24, 24, 24, 12, 11, 11, 18, 18,  0,  0,  0,  0,
     0, 24, 24,  0, 24,  0, 24, 24, 24, 24, 24,  0, 24, 24, 24, 24,
    24, 24, 24, 24,  0, 24,  0, 24, 24, 24, 24, 24, 24, 24,  0,  0,
    24, 24, 24, 24, 24,  0, 24,  0, 11, 11,  0,  0, 24, 24, 24, 24,
    12, 17, 17, 17, 17, 12, 17, 17,  4, 17, 17, 18,  4,  6,  6,  6,
     6,  6,  4, 12,  6, 12, 12, 12, 12, 12, 12, 12, 18, 16, 12, 16,
    12, 16,  1,  2,  1,  2, 16, 16, 12, 12, 12, 12, 12,  0,  0,  0,
    16, 16, 16, 16, 16, 16, 16, 18, 16, 16, 16, 16, 16, 18, 16, 16,
    12, 12, 12, 12, 12, 16, 16, 16, 16, 16, 16, 16, 16,  0, 18, 18,
    12, 12, 12, 12, 12, 12, 16, 12, 17, 17, 18, 17, 12, 12, 12, 12,
    12,  4,  4,  0,  0,  0,  0,  0, 11, 11, 18, 18, 12, 12, 12, 12,
    11, 11, 24, 24, 24, 24, 24, 24,  0,  0,  0,  0,  0, 12,  0,  0,
    31, 31, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 32, 32,
    33, 33, 33, 33, 33, 33, 33, 33, 12, 12, 12,  0,  0, 16, 16, 16,
    12, 18, 12, 12, 12, 12, 12, 12, 12, 12,  0,  0,  0,  0,  0,  0,
    18, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  1,  2,  0,  0,  0,
    12, 12, 12, 18, 18, 18, 12, 12, 12, 12, 16, 16, 16,  0,  0,  0,
    12, 12, 16, 16, 16, 18, 18,  0, 12, 12, 16, 16,  0,  0,  0,  0,
    12,  0, 16, 16,  0,  0,  0,  0, 24, 24, 24, 24, 18, 18,  5, 24,
    18, 12, 18,  9, 24, 24,  0,  0, 11, 11,  0,  0,  0,  0,  0,  0,
    12, 12,  6,  6, 18, 18, 17, 12,  6,  6, 12, 16, 16, 16,  4,  0,
    12, 12, 12, 12, 12, 16, 16, 12, 12, 16, 12,  0,  0,  0,  0,  0,
    16, 16, 16, 16,  0,  0,  0,  0, 12,  0,  0,  0,  6,  6, 11, 11,
    24, 24, 24, 24, 24,  0,  0,  0, 24, 24, 24, 24,  0,  0,  0,  0,
    24, 24,  0,  0,  0,  0,  0,  0, 11, 11, 24,  0,  0,  0, 24, 24,
    12, 12, 12, 12, 12, 12, 12, 16, 16, 16, 16, 16,  0,  0, 12, 12,
    24, 24, 24, 24, 24, 24, 24,  0, 24, 24, 24, 24, 24,  0,  0, 16,
    16, 16, 16, 16, 16, 16, 16,  0, 12, 12, 12, 12, 16, 16, 16, 16,
    12, 12, 12, 12,  0,  0,  0,  0, 11, 11, 18, 18, 12, 18, 18, 18,
    16, 16, 16, 12, 12, 12, 12, 12, 16, 16, 16, 16, 16, 16, 12, 12,
     0,  0,  0, 18, 18, 18, 18, 18, 11, 11,  0,  0,  0, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 18, 18, 12, 12, 12,  0,  0, 12, 12, 12,
    16, 16, 16, 12, 16, 16, 16, 16, 16, 12, 12, 12, 12, 16, 12, 12,
    12, 12, 12, 12, 16, 12, 12, 16, 16, 16, 12,  0,  0,  0,  0,  0,
    16, 16,  0, 16, 16, 16, 16, 16,  0, 12,  0, 12,  0, 12,  0, 12,
    12, 12, 12, 12,  0,  0, 12, 12,  0,  0, 12, 12, 12,  0, 12, 12,
    12, 12, 12, 12, 12, 17, 12,  0, 18, 18, 18, 18, 18, 18, 18,  4,
    18, 18, 18, 28, 16, 42, 16, 16, 18,  4, 18, 18, 26, 25, 25, 12,
     3,  3,  1,  3,  3,  3,  1,  3, 25, 25, 12, 12, 14, 14, 14, 18,
    20, 20, 16, 16, 16, 16, 16,  4, 10, 10, 10, 10, 10, 10, 10, 10,
    12,  3,  3, 25,  5,  5, 12, 12, 12, 12, 12, 12,  8,  1,  2,  5,
     5,  5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 18, 12,
    18, 18, 18, 18, 12, 18, 18, 18, 30, 12, 12, 12, 12,  0, 16, 16,
    12, 12,  0,  0, 25, 12, 12, 12, 12, 12, 12, 12, 12,  1,  2, 25,
    12, 25, 25, 25, 25, 12, 12, 12, 12, 12, 12, 12, 12,  1,  2,  0,
     9,  9,  9,  9,  9,  9,  9, 10,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9, 10,  9,  9,  9,  9, 10,  9,  9, 10,  9,
    16,  0,  0,  0,  0,  0,  0,  0, 12, 12, 12, 10, 12, 25, 12, 12,
    12, 12, 12, 25, 12, 12,  9, 12, 12, 25, 25, 12, 12, 12, 12, 12,
    12, 12, 12, 25, 12, 12, 12, 12, 12, 12, 12, 12, 25, 25, 12, 12,
    12, 12, 12, 25, 12, 12, 25, 12, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 12, 12, 12, 12, 25, 25, 12, 12, 12, 12, 12, 12,
    12, 25, 12, 12,  0,  0,  0,  0, 12, 12, 25, 12, 25, 12, 12, 12,
    25, 12, 25, 25, 12, 12, 12, 25, 25, 12, 12, 25, 12, 12, 12, 25,
    12, 25,  9,  9, 12, 25, 12, 12, 12, 12, 25, 12, 12, 25, 25, 25,
    25, 12, 12, 25, 12, 25, 12, 25, 25, 25, 25, 25, 25, 12, 25, 12,
    12, 12, 12, 12, 25, 25, 25, 25, 25, 12, 12, 12, 25, 12, 12, 12,
    12, 12, 25, 12, 12, 12, 12, 12, 25, 25, 12, 12, 25, 25, 25, 25,
    12, 12, 25, 25, 12, 12, 25, 25, 12, 12, 12, 12, 12, 25, 12, 12,
    12, 25, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 14,
     1,  2,  1,  2, 12, 12, 12, 12, 12, 12, 13, 13, 12, 12, 12, 12,
    12,  1,  2, 12, 12, 12, 12, 12, 13, 13, 13, 13, 12, 12, 12, 12,
    25, 25, 25, 25, 25, 25, 25, 12, 25, 25, 25, 25, 25, 12, 12, 12,
    12, 12, 25, 25, 25, 25, 12, 12, 25, 25, 12, 25, 25, 25, 25, 25,
    25, 25, 12, 12, 12, 12, 25, 25, 25, 12, 12, 25, 12, 12, 25, 25,
    13, 13, 13, 13, 12, 25, 25, 12, 12, 25, 12, 12, 12, 12, 25, 25,
    12, 12, 12, 12, 13, 13, 25, 25, 13, 12, 13, 13, 13, 40, 13, 13,
    12, 13, 13, 13, 12, 12, 12, 12, 25, 12, 25, 12, 12, 12, 12, 12,
    25, 25, 12, 25, 25, 25, 12, 25, 13, 25, 25, 12, 25, 25, 12, 25,
    12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12, 12, 12, 25, 25,
    12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 25, 25, 25, 25, 13, 12, 13, 13, 13, 25, 13, 13, 25, 25, 25,
    13, 13, 25, 25, 13, 25, 25, 13, 13, 13, 12, 25, 12, 12, 12, 12,
    25, 25, 13, 25, 25, 25, 25, 25, 25, 13, 13, 13, 13, 13, 25, 13,
    13, 40, 13, 25, 25, 13, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12,
    13, 13, 40, 40, 40, 40, 12, 12, 12, 12, 12,  3,  3,  3,  3,  3,
     3, 12,  6,  6, 13, 12, 12, 12,  1,  2,  1,  2,  1,  2,  1,  2,
     1,  2,  1,  2,  1,  2, 25, 25, 12, 12, 12, 12, 12,  1,  2, 12,
    12, 12, 12, 12, 12, 12,  1,  2, 12, 12, 12,  1,  2,  1,  2,  1,
     2,  1,  2,  1,  2,  1,  2,  1,  2, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12,  1,  2, 12, 12, 12, 12, 12, 12, 12, 25, 25, 25,
    16, 16, 12, 12,  0,  0,  0,  0,  0,  6, 18, 18, 18, 12,  6, 18,
     0,  0,  0,  0,  0,  0,  0, 12, 18,  0,  0,  0,  0,  0,  0,  0,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 18, 18,
    18, 18, 18, 18, 18, 18, 12, 18,  1, 18, 12, 12,  3,  3, 12, 12,
     3,  3,  1,  2,  1,  2,  1,  2,  1,  2, 18, 18, 18, 18,  6, 12,
    18, 18, 12, 18, 18, 12, 12, 12, 12, 12, 26, 26, 18, 18, 18, 12,
    18, 18,  1, 18, 18, 18, 18, 18, 18, 18, 18, 12, 18, 12, 18, 18,
    13, 13,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,  0,  0,
    13, 13, 13, 13, 13, 13,  0,  0, 18,  2,  2, 13, 13,  5, 13, 13,
     1,  2, 13, 13,  1,  2,  1,  2,  1,  2,  1,  2,  5,  1,  2,  2,
    13, 13, 16, 16, 16, 16, 16, 16, 13, 13, 13, 13, 13, 16, 13, 13,
    13, 13, 13,  5,  5, 13, 13, 13,  0, 38, 13, 38, 13, 38, 13, 38,
    13, 38, 13, 13, 13, 13, 13, 13, 13, 13, 13, 38, 13, 13, 13, 13,
    13, 13, 13, 38, 13, 38, 13, 38, 13, 13, 13, 13, 13, 13, 38, 13,
    13, 13, 13, 13, 13, 38, 38,  0,  0, 16, 16,  5,  5,  5,  5, 13,
     5, 38, 13, 38, 13, 38, 13, 38, 13, 13, 13, 13, 13, 38, 38, 13,
    13, 13, 13,  5, 38,  5,  5, 13,  0,  0,  0,  0,  0, 13, 13, 13,
     0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,
    13, 13, 13,  0,  0,  0,  0,  0, 38, 38, 38, 38, 38, 38, 38, 38,
    13, 13, 13, 13, 13,  5, 13, 13, 13, 13, 13, 13, 13,  0,  0,  0,
    12, 12, 12, 12, 12, 18,  6, 18, 11, 11, 12, 12,  0,  0,  0,  0,
    16, 16, 12, 18, 18, 18, 18, 18,  0,  0, 12, 12, 12, 12, 12,  0,
    12, 12, 16, 12, 12, 12, 16, 12, 12, 12, 12, 16, 12, 12, 12, 12,
    10, 12,  0,  0,  0,  0,  0,  0, 12, 12, 12, 12, 17, 17,  6,  6,
    16, 16, 16, 16, 16, 16,  0,  0,  0,  0,  0,  0,  0,  0, 18, 18,
    12, 12, 12, 12, 17, 12, 12, 16, 16, 16, 16, 16, 16, 16, 18, 18,
    31, 31, 31, 31, 31,  0,  0,  0, 16, 12, 12, 12, 12, 12, 12, 18,
    18, 18, 12, 12, 12, 12,  0, 12, 11, 11,  0,  0,  0,  0, 12, 12,
    11, 11, 24, 24, 24, 24, 24,  0, 12, 12, 12, 12, 16, 16,  0,  0,
    11, 11,  0,  0, 12, 18, 18, 18, 24, 24, 24,  0,  0,  0,  0,  0,
     0,  0,  0, 24, 24, 24, 24, 24, 18, 18, 12, 12, 12, 16, 16,  0,
     0, 12, 12, 12, 12, 12, 12,  0, 16, 16, 16, 18, 16, 16,  0,  0,
    34, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 34, 35, 35, 35, 35, 35, 35, 35,  0,  0,  0,  0,
    32, 32, 32, 32, 32, 32, 32,  0,  0,  0,  0, 33, 33, 33, 33, 33,
    33, 33, 33, 33,  0,  0,  0,  0, 27, 27, 27, 27, 27, 27, 27, 27,
     0,  0,  0, 12, 12, 12, 12, 12,  0,  0,  0,  0,  0, 37, 16, 37,
    37, 12, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,  0,
    37, 37, 37, 37, 37,  0, 37,  0, 37, 37,  0, 37, 37,  0, 37, 37,
    12, 12, 12, 12, 12, 12,  2,  1, 12, 12, 12, 12, 10, 12,  0,  0,
     8,  2,  2,  8,  8,  6,  6,  1,  2, 14,  0,  0,  0,  0,  0,  0,
    13, 13, 13, 13, 13,  1,  2,  1,  2,  1,  2,  1,  2, 13, 13,  1,
     2, 13, 13, 13, 13, 13, 13, 13,  2, 13,  2,  0,  5,  5,  6,  6,
    13,  1,  2,  1,  2,  1,  2, 13, 13,  9, 10, 13,  0,  0,  0,  0,
    12, 12, 12, 12, 12,  0,  0, 30,  0,  6, 13, 13,  9, 10, 13, 13,
     1,  2, 13, 13,  2, 13,  2, 13, 13, 13,  5,  5, 13, 13, 13,  6,
    13, 13, 13,  1, 13,  2, 13, 13, 13, 13, 13,  1, 13,  2, 13,  1,
     2,  2,  1,  2,  2,  5, 13, 38, 38, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13,  5,  5,  0,  0, 13, 13, 13, 13, 13, 13,
     0,  0, 13, 13, 13,  0,  0,  0, 10,  9, 13, 13, 13,  9,  9,  0,
     0, 16, 16, 16, 23, 25,  0,  0, 12, 12, 12,  0, 12, 12,  0, 12,
    18, 18, 18,  0,  0,  0,  0, 12, 12, 12, 12, 12,  0,  0,  0, 12,
    12, 12, 12, 12, 12, 16,  0,  0,  0,  0,  0,  0,  0, 12, 12, 12,
    16, 16, 16,  0,  0,  0,  0,  0, 12, 12, 12, 12, 12, 12,  0, 18,
    18, 12, 12, 12, 12, 12,  0,  0, 12,  0,  0,  0, 12,  0,  0, 12,
    12, 12, 12,  0, 12, 12,  0,  0, 12, 12, 12, 12,  0,  0,  0, 18,
    12, 12,  0,  0,  0,  0,  0, 12, 12, 16, 16, 16,  0, 16, 16,  0,
     0,  0,  0,  0, 16, 16, 16, 16, 18, 18, 18, 18, 18, 18, 18, 18,
    12, 12, 12, 12, 12, 16, 16,  0, 18, 18, 18, 18, 18, 18, 14,  0,
     0, 18, 18, 18, 18, 18, 18, 18,  0, 12, 12, 12, 12,  0,  0,  0,
    12, 12, 12, 12, 12, 12, 11, 11, 16, 16, 16, 12, 12, 12, 18, 18,
    18, 18,  0,  0,  0,  0,  0,  0, 16, 16, 16, 16, 16,  0, 11, 11,
    18, 18, 18, 18, 12, 16, 16,  0, 12, 12, 12, 16, 12, 17, 12,  0,
    16, 12, 12, 12, 12, 18, 18, 12, 18, 16, 16, 16, 16, 12,  0,  0,
    11, 11, 12, 17, 12, 18, 18, 18, 18, 18, 12, 18, 18, 12, 16,  0,
    12,  0, 12, 12, 12, 12,  0, 12, 12, 18,  0,  0,  0,  0,  0,  0,
    12, 12,  0, 16, 16, 12, 16, 16, 12, 12, 16, 16,  0,  0, 16, 16,
    16, 16, 16, 16, 16,  0,  0,  0, 16, 16, 16, 16, 16, 16, 16, 12,
    12, 12, 12, 18, 18, 18, 18, 12, 11, 11,  0, 18,  0, 12, 16, 12,
    16, 17, 18, 18,  6,  6, 12, 12, 12, 18, 18, 18, 18, 18, 18, 18,
    16, 18, 18, 12, 12,  0,  0,  0, 17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17,  0,  0,  0, 24, 24, 24,  0,  0, 24, 24, 24,
    11, 11, 24, 24, 18, 18, 18, 24, 16, 16, 16, 12,  0,  0,  0,  0,
     0,  0, 16, 16, 16, 16, 16, 16, 16, 12, 17, 12, 16,  0,  0,  0,
    16, 16, 12, 16, 16, 16, 16, 17, 12, 18, 18, 18, 18, 17, 12, 16,
    12, 12, 16, 16, 16, 16, 16, 16, 16, 16, 18, 18, 18, 12, 17, 17,
    17, 18, 18,  0,  0,  0,  0,  0, 12, 18, 18, 18, 18, 18,  0,  0,
    17,  6, 12, 12, 12, 12, 12, 12, 12, 16, 16, 16, 16, 16, 16,  0,
     0,  0, 16,  0, 16, 16,  0, 16, 16, 16, 16, 16, 16, 16, 12, 16,
    12, 12, 16, 16, 16, 16, 16,  0, 12, 12, 12, 16, 16, 16, 16, 12,
    12, 12, 12, 12, 12, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12,
     0,  0,  0,  0,  0,  0,  0, 18, 18, 18, 18, 18, 18,  0,  0,  0,
     1,  1,  1,  2,  2,  2, 12, 12, 12, 12,  2, 12, 12, 12,  1,  2,
     1,  2, 12, 12, 12, 12, 12, 12, 12,  1,  2,  2, 12, 12, 12, 12,
     4,  4,  4,  4,  4,  4,  4,  1,  2,  0,  0,  0,  0,  0,  0,  0,
    11, 11,  0,  0,  0,  0, 18, 18, 16, 16, 16, 16, 16, 18,  0,  0,
    18, 18, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 18, 12,  0,  0,
    11, 11,  0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 18,
    18, 12, 12,  0,  0,  0,  0,  0, 12, 12, 12,  0,  0,  0,  0, 16,
     5,  5,  5,  5,  0,  0,  0,  0, 38, 38, 38,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 38, 38, 38, 38, 12, 12,  0,  0, 12, 16, 16, 18,
    16, 16, 12, 12, 12, 16, 16, 16, 16, 16, 16, 12, 12, 16, 16, 16,
    12, 12, 16, 16, 16, 16, 12, 12, 12, 12, 16, 16, 16, 12,  0,  0,
     0,  0, 12,  0,  0, 12, 12,  0,  0, 12, 12, 12, 12,  0, 12, 12,
    12, 12,  0, 12,  0, 12, 12, 12, 12, 12,  0, 12, 12, 12, 12,  0,
    12, 12, 12, 12, 12,  0, 12,  0, 12, 12, 12, 12,  0,  0, 11, 11,
    12, 12, 12, 12, 12, 16, 12, 12, 12, 12, 12, 12, 16, 12, 12, 18,
    18, 18, 18, 12,  0,  0,  0,  0, 16,  0,  0, 16, 16, 16, 16, 16,
    16, 16,  0, 16, 16,  0, 16, 16, 11, 11,  0,  0,  0,  0,  0,  9,
    11, 11,  0,  0,  0,  0,  1,  1, 12, 12, 12, 12, 10, 12, 12, 12,
    10, 12, 12, 12, 12,  0,  0,  0,  0, 12, 12,  0, 12,  0,  0, 12,
    12, 12, 12,  0, 12, 12, 12, 12,  0, 12,  0, 12,  0,  0,  0,  0,
     0,  0, 12,  0,  0,  0,  0, 12,  0, 12,  0, 12,  0, 12, 12, 12,
     0, 12, 12, 12,  0, 12, 12, 12, 25, 25, 25, 25, 25, 13, 13, 13,
    25, 25, 25, 25, 25, 25, 12, 12, 25, 25, 12, 12, 12, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
    13, 13, 13, 13, 13, 40, 13, 13, 13, 13, 13, 13, 12, 12, 13, 13,
    13, 13, 13, 13, 13, 12, 12, 13, 13, 13, 13, 13, 12, 13, 13, 13,
    13, 13, 40, 40, 40, 13, 13, 40, 13, 13, 40, 40, 40, 13, 13, 13,
    13, 13, 13, 41, 41, 41, 41, 41, 13, 13, 40, 40, 13, 13, 40, 40,
    40, 40, 40, 40, 40, 40, 40, 40, 40, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 40, 40, 40, 13, 13, 13, 40, 13, 13, 13,
    13, 40, 40, 40, 13, 40, 40, 40, 13, 13, 13, 13, 13, 13, 13, 40,
    13, 40, 13, 13, 13, 13, 13, 13, 12, 13, 12, 13, 12, 13, 13, 13,
    13, 13, 40, 13, 13, 13, 13, 12, 13, 12, 12, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 12, 13, 13, 12, 12, 12, 12, 12, 12,
    12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 40, 40, 13, 13,
    13, 13, 40, 13, 13, 13, 13, 13, 40, 13, 13, 13, 13, 40, 40, 13,
    12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 40, 40, 40,
    13, 13, 13, 40, 40, 40, 40, 40, 12, 12, 12, 12, 12, 12,  3,  3,
     3,  5,  5,  5, 12, 12, 12, 12, 13, 13, 13, 40, 13, 13, 13, 13,
    13, 13, 13, 13, 40, 40, 40, 13, 13, 13, 13, 13, 40, 13, 13, 13,
    12, 12, 12, 12, 12, 12, 13, 13, 12, 12, 12, 12, 13, 13, 13, 40,
    13, 13, 13, 13, 13, 13, 40, 13, 40, 40, 13, 13, 40, 40, 40, 13,
    13, 13, 13, 13, 13, 40, 40, 13, 40, 40, 13, 40, 13, 13, 13, 13,
    13, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 13, 13,
};

/* Line_Break: 12816 bytes. */

RE_UINT32 re_get_line_break(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_line_break_stage_1[f] << 5;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_line_break_stage_2[pos + f] << 4;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_line_break_stage_3[pos + f] << 3;
    value = re_line_break_stage_4[pos + code];

    return value;
}

/* Numeric_Type. */

static RE_UINT8 re_numeric_type_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,  8,
    15, 16, 17,  8, 18, 19,  8,  8,  8,  8,  8,  8,  8,  8,  8, 20,
    21, 22, 23, 24, 25,  8,  8,  8,  8,  8,  8,  8,  8, 26,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8, 27,  8, 28, 29, 30,  8,
    31, 32,  8,  8, 33, 34,  8, 35,  8,  8,  8,  8, 36,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8, 37,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
};

static RE_UINT8 re_numeric_type_stage_2[] = {
      0,   1,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   1,   0,   1,   1,   1,   4,
      1,   1,   1,   1,   1,   5,   1,   6,   1,   5,   1,   5,   1,   7,   1,   8,
      1,   9,   1,   5,   1,  10,   1,   5,   1,  11,   1,  11,  12,   1,   1,   1,
      1,   4,  11,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  13,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  14,   1,   1,   1,  15,
     11,   1,   1,   1,   1,  16,   1,  17,   1,   1,  18,   1,   1,  11,   0,   1,
      1,  18,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  19,  20,   1,   1,  21,  22,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  23,  24,  25,   1,   1,   1,   1,   1,   1,   1,   1,   1,  26,  27,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,  28,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     29,   1,   1,   1,   1,   1,  30,   1,  31,  32,  33,   1,   1,   1,   1,   1,
     34,   1,  35,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     36,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  37,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,  38,  39,  40,  41,  37,  42,   1,   1,
      1,   1,   1,   1,  43,  44,   1,   1,   1,   1,   1,   1,   1,  45,   1,  46,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  47,   1,   1,   1,   1,
      1,   1,   1,  48,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,  49,   1,  50,  51,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  52,   1,  53,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  54,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  55,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  56,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,  52,   1,   1,   1,   1,   1,   1,
      1,   1,  55,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     57,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,  58,   1,  42,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,  59,  60,   1,  61,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   3,   1,   1,  62,   1,   1,   1,   1,
     63,   1,   1,  11,   4,   1,   1,  64,   1,  11,   1,   1,   1,   1,   1,   0,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,  65,  66,  67,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  11,   1,   1,   1,
      1,   1,   1,   1,  68,  69,  70,   1,   1,   1,   1,  71,  72,  73,   1,  74,
      1,   1,   3,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  75,  76,  77,  78,   1,  79,  80,   1,  81,  82,  83,   1,  84,  85,   1,
      1,   1,   1,  86,   0,   1,   1,   1,   1,  87,   1,   1,  88,  89,   1,   1,
      1,  90,   1,   0,  91,   1,   1,  92,   1,   1,   1,   0,   1,   1,   1,   1,
      1,  11,   1,  11,   1,   1,   1,   1,   1,  11,   1,   4,  93,   1,   1,   1,
      1,   1,   1,  94,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  95,   1,   1,   1,  11,   3,   1,   1,   1,   1,   1,   1,   1,   1,  96,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     97,  98,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   1,   1,   1,  99,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 100,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 101,   1, 102,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 103,
      1,   1,   1,   1,   1,   4,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1, 104,   1,  11,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1, 105, 106,   1, 107,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1, 108,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
    109, 110,   1, 111,  59,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,  36,   1, 112,   1,   1,   1,   1, 113, 114,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 115,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1, 116,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  47,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1, 117,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1, 115,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
};

static RE_UINT8 re_numeric_type_stage_3[] = {
     0,  0,  0,  0,  0,  0,  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  3,  4,  0,  0,  0,  0,  1,  2,  0,  0,
     1,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  1,  0,  0,
     0,  0,  0,  0,  5,  1,  6,  7,  0,  0,  0,  0,  5,  1,  8,  0,
     0,  0,  0,  0,  5,  1,  9,  0,  0,  0,  0,  0,  5,  1,  0, 10,
     0,  0,  0, 10,  5,  1, 11, 12,  0,  0,  1,  2,  0,  0,  0,  0,
     0,  0,  0,  0,  1, 13, 14,  0,  0,  0,  0,  0,  0, 15, 16, 17,
     0,  0,  0,  0,  0, 18, 12,  0,  0,  0,  0,  0,  1,  2, 11,  7,
     5,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1, 19,  0,  0,  0,  0,
     1,  2,  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20, 21,
    22, 21,  0,  0,  0,  0,  0,  0,  0,  0, 11, 11, 11, 11, 11, 11,
    23,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22, 24, 25, 26,
    11, 22, 24, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0, 27, 28, 29,
     0,  0,  0,  0,  0,  0, 30, 31, 22, 32, 33,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 34, 35,  0,  0,  0, 36,  7,  0,  9,
     0,  0, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11,  7,  0,  0,
     0, 11, 36, 11,  0,  0,  0,  0, 11,  7,  0,  0,  0,  0, 36, 11,
    34,  0,  0,  0,  0,  0,  0,  0, 38,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 39,  0,  0,  0, 34,  0,  0,  0,  0,  0,  0,
    40, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0, 34,  0,  0,  0,  0,
     0, 42, 43,  0,  0,  0,  0, 35, 12,  0,  0, 35,  0, 12,  0,  0,
     0,  0,  0,  0,  0,  0, 12,  0, 42,  0,  0,  0,  0,  0,  0,  0,
    44,  0,  0,  0,  0, 45,  0,  0, 46, 42,  0,  0,  0,  0,  0,  0,
    47,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 38,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0,  0,  0, 39,
     0,  0,  0,  0,  0,  0,  0, 18,  0, 48, 12,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 44,  0, 42,  0,  0,  0,  0,  0,  0,
     0,  0, 39,  0,  0,  0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 44,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 42,  0,  0,
     0,  0,  0,  0,  0, 44, 38,  0,  0,  0,  0,  0, 41,  0,  0,  0,
    44, 42,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0, 44,  0,
     0,  0,  0,  0, 18, 11,  0,  0,  0,  0,  0,  0,  0,  0, 49,  0,
     0,  0,  1,  2,  0,  0,  1,  2,  0,  0,  0,  0,  0, 38, 38, 12,
     0,  0,  0,  0,  0,  0, 39,  0,  0,  0, 50,  0,  0,  0,  0, 34,
    35, 11, 11, 11, 11, 11, 14,  0, 11, 11, 11, 11, 11, 11, 11, 12,
     0, 51,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 36, 11, 11, 14,
     0,  0,  0,  0, 14,  0,  0,  0, 41, 39,  0,  0,  0,  0,  0,  0,
     0,  0, 52,  0,  0,  0,  0,  0,  0,  0,  0, 11,  0,  0,  0, 36,
     0,  0,  0,  0, 35, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0, 53,
     0,  0, 18, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 54,
    11, 11,  8, 11, 11, 11, 11, 11, 55, 12,  0,  0,  0,  0,  0, 56,
     0,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0, 53,  0,  0,
     0,  0,  0, 11,  0,  0,  0, 11,  0,  0,  0,  0,  0, 36,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0, 22, 24, 11, 10,
     0,  0,  0, 57, 10,  0,  0,  0,  0,  0, 47,  0,  0,  0,  0,  0,
     0,  0, 58, 59, 60,  1,  0,  0,  0,  0,  0,  0,  0,  0,  5,  1,
     0,  0,  1,  2, 36, 11, 17,  0,  0,  0,  0,  0,  0,  0,  1, 61,
     0,  0,  0,  0,  1, 13,  9,  0,  0,  0,  1, 13, 11, 17,  0,  0,
    11, 11, 17,  0,  0,  0,  0,  0, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 10,  0,  0,  0,  0,  1, 62,  7,  0,  0,  0,
    11, 11, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11, 11, 14,  0,
     0,  0,  0,  0, 11, 11, 11, 12,  0,  5,  1,  1,  1,  1,  1,  1,
    35, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 36, 11,
    11, 11, 11, 11, 11, 63, 47,  0, 36, 11, 11, 11, 11, 64, 11, 49,
    22, 65,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 42,  0,  0,  0,  0,  0,  0,  0, 39,  0,  0,  0,
    38, 42,  0, 42,  0,  0,  0,  0,  0,  0,  0,  0,  0, 39,  0, 34,
     0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,
     0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0, 34,  0,  0,
};

static RE_UINT8 re_numeric_type_stage_4[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0,
    0, 2, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 3, 3,
    0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 2, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 0, 0, 1, 1, 1,
    2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 1, 1, 1, 0, 0, 2, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2,
    0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1,
    2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
    0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
    1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0,
    0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0,
    0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 1, 1, 0, 0, 2, 2, 2, 2, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1,
    0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 0, 0, 0, 0,
    3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1, 2, 2, 2, 1, 1, 0, 0, 0,
};

/* Numeric_Type: 3232 bytes. */

RE_UINT32 re_get_numeric_type(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_numeric_type_stage_1[f] << 5;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_numeric_type_stage_2[pos + f] << 3;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_numeric_type_stage_3[pos + f] << 3;
    value = re_numeric_type_stage_4[pos + code];

    return value;
}

/* Numeric_Value. */

static RE_UINT8 re_numeric_value_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,  8,
    15, 16, 17,  8, 18, 19,  8,  8,  8,  8,  8,  8,  8,  8,  8, 20,
    21, 22, 23, 24, 25,  8,  8,  8,  8,  8,  8,  8,  8, 26,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8, 27,  8, 28, 29, 30,  8,
    31, 32,  8,  8, 33, 34,  8, 35,  8,  8,  8,  8, 36,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8, 37,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
};

static RE_UINT8 re_numeric_value_stage_2[] = {
      0,   1,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   1,   0,   1,   1,   1,   4,
      1,   1,   1,   1,   1,   5,   1,   6,   1,   5,   1,   5,   1,   7,   1,   8,
      1,   9,   1,   5,   1,  10,   1,   5,   1,  11,   1,  11,  12,   1,   1,   1,
      1,   4,  11,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  13,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  14,   1,   1,   1,  15,
     11,   1,   1,   1,   1,  16,   1,  17,   1,   1,  18,   1,   1,  11,   0,   1,
      1,  18,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  19,   4,   1,   1,  20,  21,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  22,  23,  24,   1,   1,   1,   1,   1,   1,   1,   1,   1,  25,  26,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,  27,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     28,   1,   1,   1,   1,   1,  29,   1,  30,  31,  32,   1,   1,   1,   1,   1,
     33,   1,  34,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     35,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  36,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,  37,  38,  39,  40,  41,  42,   1,   1,
      1,   1,   1,   1,  43,  44,   1,   1,   1,   1,   1,   1,   1,  45,   1,  46,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  47,   1,   1,   1,   1,
      1,   1,   1,  48,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,  49,   1,  50,  51,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  52,   1,  53,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  54,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  55,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  56,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,  57,   1,   1,   1,   1,   1,   1,
      1,   1,  58,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     59,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,  60,   1,  61,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,  62,  63,   1,  64,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   3,   1,   1,  65,   1,   1,   1,   1,
     66,   1,   1,  11,   4,   1,   1,  67,   1,  11,   1,   1,   1,   1,   1,   0,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,  68,  69,  70,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  11,   1,   1,   1,
      1,   1,   1,   1,  71,  72,  73,   1,   1,   1,   1,  74,  75,  76,   1,  77,
      1,   1,   3,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  78,  79,  80,  81,   1,  82,  83,   1,  84,  85,  86,   1,  87,  88,   1,
      1,   1,   1,  89,   0,   1,   1,   1,   1,  90,   1,   1,  91,  92,   1,   1,
      1,  93,   1,   0,  94,   1,   1,  95,   1,   1,   1,   0,   1,   1,   1,   1,
      1,  11,   1,  11,   1,   1,   1,   1,   1,  11,   1,   4,  96,   1,   1,   1,
      1,   1,   1,  97,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,  98,   1,   1,   1,  11,   3,   1,   1,   1,   1,   1,   1,   1,   1,  99,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
    100, 101,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   1,   1,   1, 102,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 103,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 104,   1, 105,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 106,
      1,   1,   1,   1,   1,   4,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1, 107,   1,  11,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1, 108, 109,   1, 110,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1, 111,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
    112, 113,   1, 114, 115,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1, 116,   1, 117,   1,   1,   1,   1, 118, 119,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 120,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1, 121,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 122,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1, 123,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1, 124,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
};

static RE_UINT8 re_numeric_value_stage_3[] = {
      0,   0,   0,   0,   0,   0,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   3,   4,   0,   0,   0,   0,   1,   2,   0,   0,
      1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   6,   0,   0,
      0,   0,   0,   0,   5,   6,   7,   8,   0,   0,   0,   0,   5,   6,   9,   0,
      0,   0,   0,   0,   5,   6,  10,   0,   0,   0,   0,   0,   5,   6,   0,  11,
      0,   0,   0,  12,   5,   6,  13,  14,   0,   0,   1,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   1,  15,  16,   0,   0,   0,   0,   0,   0,  17,  18,  19,
      0,   0,   0,   0,   0,  20,  21,   0,   0,   0,   0,   0,   1,   2,   1,   2,
      5,   6,   0,   0,   0,   0,   0,   0,   0,   0,   1,  22,   0,   0,   0,   0,
      1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  23,   2,
      0,   0,  24,  25,  26,  27,  26,  27,  28,  29,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  26,  30,  31,  32,  33,  26,  30,  34,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  35,  36,  37,   0,   0,   0,   0,   0,   0,  38,  39,
     26,  40,  41,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  42,
     43,   0,   0,   0,  17,   2,   0,  44,   0,   0,  45,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  26,  46,   0,   0,   0,  47,  48,  49,   0,   0,   0,   0,
     26,  46,   0,   0,   0,   0,  50,  51,  52,   0,   0,   0,   0,   0,   0,   0,
     53,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,
      0,  55,   0,   0,   0,   0,   0,   0,  56,  57,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  58,   0,   0,   0,   0,   0,  59,  60,   0,   0,   0,   0,  61,
     62,   0,   0,  63,   0,  64,   0,   0,   0,  52,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  65,   0,  66,   0,   0,   0,   0,   0,   0,   0,
     67,   0,   0,   0,   0,  68,   0,   0,  69,  70,   0,   0,   0,   0,   0,   0,
     71,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  72,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  73,  73,   0,   0,   0,   0,   0,   0,   0,  74,
      0,   0,   0,   0,   0,   0,   0,  75,   0,  76,  77,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  78,   0,  79,   0,   0,   0,   0,   0,   0,
      0,   0,  80,   0,   0,   0,   0,   0,  81,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  82,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  83,
     84,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  85,   0,   0,
      0,   0,   0,   0,   0,  86,  53,   0,   0,   0,   0,   0,   0,   0,  77,   0,
      0,   0,   0,   0,  87,   0,   0,   0,  88,  89,   0,   0,   0,   0,   0,  90,
      0,   0,   0,   0,   0,   0,  91,   0,   0,   0,   0,   0,  38,  92,   0,   0,
      0,   0,   0,   0,   0,   0,  93,   0,   0,   0,   1,   2,   0,   0,   1,   2,
      0,   0,   0,   0,   0,  94,  95,  77,   0,   0,   0,   0,   0,   0,  96,   0,
      0,   0,  97,   0,   0,   0,   0,  98,  99,   6,  47, 100, 101, 102, 103,   0,
    104, 105, 106, 107, 108, 109, 110, 111,   0, 112,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  17,  18, 113, 114,   0,   0,   0,   0, 115,   0,   0,   0,
    116, 117,   0,   0,   0,   0,   0,   0,   0,   0, 118,   0,   0,   0,   0,   0,
      0,   0,   0, 119,   0,   0,   0, 120,   0,   0,   0,   0,  99, 121,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 122,   0,   0, 123, 124,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 125,  26, 126, 127, 128, 129, 130, 131, 132,
    133, 134,   0,   0,   0,   0,   0, 135,   0,   0,   0, 136,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 122,   0,   0,   0,   0,   0, 133,   0,   0,   0, 133,
      0,   0,   0,   0,   0, 137,   0,   0,   0,   0,   0,   0,   0,   0,   0, 138,
      0,   0,   0,   0,  26, 126, 139, 140,   0,   0,   0, 141, 142,   0,   0,   0,
      0,   0, 143,   0,   0,   0,   0,   0,   0,   0, 144, 145, 146,   6,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   6,   0,   0,   1,   2,  17,  18, 147,   0,
      0,   0,   0,   0,   0,   0,   1, 148,   0,   0,   0,   0,   1,  18, 149,   0,
      0,   0,   1, 150, 145, 151,   0,   0, 152, 153, 154,   0,   0,   0,   0,   0,
      6, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167,   0,   0,
      0,   0,   1, 168, 169,   0,   0,   0,   1, 170, 171,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   1, 170, 172,   0,   0,   0,   0,   0,  26, 126, 173, 174,
      0,   5,   6,   1, 175, 176, 177,   6,  99,   6,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  17,  18, 113, 178, 179, 180, 181, 182, 183,   0,
     17,  18, 113, 178, 179, 184,  39, 185, 186, 187,   0,   0,   0,   0,   0,   0,
    188,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 189,   0,   0,   0,
      0,   0,   0,   0, 190,   0,   0,   0,   0,   0,   0,   0, 191,   0,   0,   0,
      0,   0,   0,   0,   0,  74,   0,   0, 192,  70,   0,  70,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 193,   0, 194,   0,   0,   0,  57,   0,   0,   0,   0,
      0,   0,  77,   0,   0,   0,   0,   0,   0,   0,   0,  64,   0,   0,   0,   0,
      0,   0,   0,  94,   0,   0,   0,   0,   0,   0,   0,   0,   0, 195,   0,   0,
      0,   0, 196,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_numeric_value_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   2,  37,  39,  41,  43,  45,  47,  49,
     51,  53,   0,   0,   0,   0,   0,   0,   0,   0,  39,  41,   0,   0,   0,   0,
      0,  37,   0,   0,  22,  27,  32,   0,   0,   0,   0,   0,   0,   0,   2,  37,
     39,  41,  43,  45,  47,  49,  51,  53,   0,   0,   0,   0,  12,  16,  20,  22,
     32,  60,   0,   0,   0,   0,   0,   0,   0,   0,  22,  27,  32,  12,  16,  20,
     54,  99, 108,   0,   0,   0,   0,   0,   2,  37,  39,  41,  37,  39,  41,   0,
      4,   7,   9,  11,  14,  18,  21,   0,  54,  99, 108,  22,  27,  32,  12,  16,
     20,   0,   0,   0,   0,   0,   0,   0,  51,  53,  27,  38,  40,  42,  44,  46,
     48,  50,  52,   1,   0,   0,   0,   0,   0,  37,  39,  41,  43,  45,  47,  49,
     51,  53,  54,  64,  74,  84,  94,  95,  96,  97,  98,  99, 117,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  61,  62,  63,   0,   0,   0,   0,   0,   0,   0,
     51,  53,  37,   0,   0,   0,   0,   0,   2,   0,   0,   0,  43,  45,  47,  49,
     17,  15,  14,  23,  31,  21,  25,  29,  33,  19,  34,  16,  24,  30,  35,  37,
     37,  39,  41,  43,  45,  47,  49,  51,  53,  54,  55,  56,  94,  99, 103, 108,
    108, 112, 117,   0,   0,  47,  94, 121, 126,   2,   0,   0,   0,   0,   0,   0,
     53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  37,  39,  41,  43,
     45,  47,  49,  51,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,
     61,  62,  63,  64,   0,   0,   0,   0,   0,   0,   2,  55,  56,  57,  58,  59,
     60,  61,  62,  63,  64,  37,  39,  41,  43,  45,  47,  49,  51,  53,  54,   2,
      0,   0,   0,   0,   0,   0,  37,  39,  41,  43,  45,  47,  49,  51,  53,  54,
     53,  54,  37,  39,  41,  43,  45,  47,  49,  51,  53,  54,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  27,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
     54,  64,  74,   0,   0,   0,   0,   0,   0,   0,  37,  39,  41,  43,   0,   0,
     53,  54,   0,   0,   0,   0,   0,   0,  54,  64,  74,  84,  94,  95,  96,  97,
      0,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
      0,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,
      0,   0,   0,   0,   0,  45,   0,   0,   0,   0,   0,  39,   0,   0,   0,   0,
      0,   0,  45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  49,   0,   0,
     37,   0,   0,  49,   0,   0,   0, 117,   0,  41,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  53,   0,   0,   0,   0,   0,   0,  39,   0,   0,   0,
      0,   0,   0,   0,  45,   0,  43,   0,   0,   0,   0,   0,   0,   0,   0, 140,
     54,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 108,
     41,   0,   0,   0,   0,   0,   0,   0,  99,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,   0,   0, 142,   0,
      0,  39,   0,  51,   0,  47,   0,   0,   0,  54,   0, 108,  64,  74,   0,   0,
      0,   0,   0,   0,  84,   0,   0,   0,   0,  41,  41,  41,  41,   0,   0,   0,
      0,   0,   0,  43,   0,   0,   0,   0,   0,  37,   0,   0,   0,   0,   0,   0,
      0,   0,  37,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  53,  64,
      0,   0,   0,   0,  37,  39,  41,   0,  39,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,  51,   0,   0,   0,
      0,   0,  49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  49,   0,
      0,   0,   0,   0,   0,   0,  53,   0,   0,   0,   0,   0,   0,   0,  99,   0,
      0,   0,   0,   0,   0,   0,  43,   0,   0,   0,   0,   0, 117,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  39,   0,   0, 108,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,  99,   0,   0,   0,
     47,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,
     41,  43,  45,  47,  49,  51,  53,   2,  22,  27,  32,  12,  16,  20,   0,   0,
      0,   0,   0,  41,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,
      0,   0,   2,   0,   0,   0,   0,   0,   0,  47,   0,  47,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0,   0,   0,  37,
     98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
    114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,   0,   0,   0,   0,
     22,  27,  37,  45,  94, 103, 112, 121,  45,  54,  94,  99, 103, 108, 112,  45,
     54,  94,  99, 103, 108, 117, 121,  54,  37,  37,  37,  39,  39,  39,  39,  45,
     54,  54,  54,  54,  54,  74,  94,  94,  94,  94,  99, 101, 103, 103, 103, 103,
    103, 108, 112,  45,  94,  27,  27,  31,  32,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   2,  22,   0,   0,   0,   0,  96,  97,  98,  99, 100, 101, 102, 103,
    104, 105, 106, 107,   0,   0,   0,   0,  37,  45,  54,  94,   0,   0,   0,   0,
      0,  98,   0,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,
      0,  37,  39,  54,  64,  99,   0,   0,  37,  39,  41,  54,  64,  99, 108, 117,
      0,  37,  39,  41,  43,  45,  54,  64,  39,  41,  43,  43,  45,  54,  64,  99,
      0,   0,   0,  37,  45,  54,  64,  99,   0,   0,   0,   0,   0,   0,  37,  54,
     64,  99,  39,  41,   0,   0,   0,   0,   0,   0,   0,   0,  36,  27,   0,   0,
     53,  54,  64,  74,  84,  94,  95,  96,   0,   0,  99, 100, 101, 102, 103, 104,
    105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
    121, 122, 123, 124, 125, 126, 127, 129, 130, 132, 133, 134, 135, 136,  13,  19,
     22,  23,  26,  27,  28,  31,  32,  34,  37,  39,  41,  43,  54,  64,  99, 108,
     27,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  37,  94,   0,
      0,   0,   0,   0,   0,  37,  54,  64,   0,  37,  39,  41,  43,  54,  64,  99,
      0,   0,  37,  45,  54,  94,  99, 108,  97,  98,  99, 100, 101, 102, 103, 104,
    105, 106, 107,  27,  22,  23,  31,   0,   0,   0,   0,   0,   0,  37,  39,  41,
     43,  45,  54,  64,  74,  99,  27,   0,   0,  37,  54,  64,  99,   0,   0,   0,
      0,   0,  37,  39,  41,  43,  45,  47,  49,  51,  53,  54,  64,  74,  84,  94,
     95,  96,  97,  98,  99, 108,   2,  37,  96,  97,  98,  99, 108,   0,   0,   0,
     51,  53,  54,  64,   0,   0,   0,   0,  96,  97,  98,   0,   0,   0,   0,   0,
     51,  53,  37,  39,  41,  43,  45,  47,  95,  96,  97,  98,  99,   0,   0,   0,
      3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  12,  14,  16,  18,  20,  21,
     22,  27,  27,  32,   3,   0,   0,   0,  41,  43,  45,  47,  49,  51,  53,  43,
     45,  47,  49,  51,  53,  37,  39,  41,  43,  45,  47,  49,  51,  53,  37,  39,
     41,  43,  45,  39,  41,  41,  43,  45,  47,  49,  51,  53,  37,  39,  41,  41,
     43,  45, 128, 131,  37,  39,  41,  41,  43,  45,  41,  41,  43,  43,  43,  43,
     47,  49,  49,  49,  51,  51,  53,  53,  53,  53,  39,  41,  43,  45,  47,  37,
     39,  41,  43,  43,  45,  45,  39,  41,  37,  39,  23,  31,  34,  23,  31,  16,
     22,  19,  22,  22,  27,  23,  31,  84,  94,  43,  45,  47,  49,  51,  53,   0,
     51,  53,   0,  54,  99, 117, 137, 140, 141, 142,   0,   0,   0,   0,   0,   0,
     51,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  37,  39,  41,   0,
     60,  61,  62,  63,   0,   0,   0,   0,  97,  98,  37,  39,  41,  43,  45,  37,
     45,   0,   0,   0,   0,   0,   0,   0,  51,  53,   2,  37,  39,  41,  43,  45,
     47,  49,  51,  53,   2,  37,  39,  41,  43,  45,  47,  49,  51,  53,   2,  37,
    104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
    120, 121, 122, 123, 124, 125, 126, 127, 126, 138, 139,  37,  39,  41,  43,  45,
     47,  49,  51,  53,   0,  22,  27,  32,   0,  37,  39, 117, 126,   0,   0,   0,
    120, 121, 122, 123, 124, 125,   0,  39, 102, 104, 109, 117,  27,  19,   0,   0,
      2,   2,  37,  39,  41,  43,  45,  47,  49,  51,  53,   2,   2,   0,   0,   0,
      0,  49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  43,   0,   0,   0,
      0,   0,  43,   0,   0,   0,   0,   0,   0,  45,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  74,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  41,   0,   0,   0,   0,   0,   0,   0,  43,   0,   0,
     53,   0,   0,   0,   0,   0,   0,   0,
};

/* Numeric_Value: 4336 bytes. */

RE_UINT32 re_get_numeric_value(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_numeric_value_stage_1[f] << 5;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_numeric_value_stage_2[pos + f] << 3;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_numeric_value_stage_3[pos + f] << 3;
    value = re_numeric_value_stage_4[pos + code];

    return value;
}

/* Bidi_Mirrored. */

static RE_UINT8 re_bidi_mirrored_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_bidi_mirrored_stage_2[] = {
     0,  1,  1,  1,  1,  1,  1,  2,  1,  1,  1,  3,  1,  1,  1,  1,
     4,  5,  1,  6,  7,  8,  1,  9, 10,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 11,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 12,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_bidi_mirrored_stage_3[] = {
     0,  1,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  4,  3,  3,  3,  3,  3,  5,  3,  3,  3,  3,  3,
     6,  7,  8,  3,  3,  9,  3,  3, 10, 11, 12, 13, 14,  3,  3,  3,
     3,  3,  3,  3,  3, 15,  3, 16,  3,  3,  3,  3,  3,  3, 17, 18,
    19, 20, 21, 22,  3,  3,  3, 23, 24,  3,  3,  3,  3,  3,  3,  3,
    25,  3,  3,  3,  3,  3,  3,  3,  3, 26,  3,  3, 27, 28,  3,  3,
     3,  3,  3, 29, 30, 31, 32, 33,
};

static RE_UINT8 re_bidi_mirrored_stage_4[] = {
      0,   0,   0,   0,   0,   3,   0,  80,   0,   0,   0,  40,   0,   0,   0,  40,
      0,   0,   0,   0,   0,   8,   0,   8,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  60,   0,   0,   0,  24,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   6,  96,   0,   0,   0,   0,   0,   0,  96,
      0,  96,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
     30,  63,  98, 188,  87, 248,  15, 250, 255,  31,  60, 128, 245, 207, 255, 255,
    255, 159,   7,   1, 204, 255, 255, 193,   0,  62, 195, 255, 255,  63, 255, 255,
      0,  15,   0,   0,   3,   6,   0,   0,   0,   0,   0,   0,   0, 255,  63,   0,
    121,  59, 120, 112, 252, 255,   0,   0, 248, 255, 255, 249, 253, 255,   0,   1,
     63, 194,  55,  31,  58,   3, 240,  51,   0, 252, 255, 223,  83, 122,  48, 112,
      0,   0, 128,   1,  48, 188,  25, 254, 255, 255, 255, 255, 207, 191, 255, 255,
    255, 255, 127,  80, 124, 112, 136,  47,   0,   0,   0,   0,   0,   0,   0,  64,
     60,  54,   0,  48, 255,   3,   0,   0,   0, 255, 243,  15,   0,   0,   0,   0,
      0,   0,   0, 126,  48,   0,   0,   0,   0,   3,   0,  80,   0,   0,   0,  40,
      0,   0,   0, 168,  13,   0,   0,   0,   0,   0,   0,   8,   0,   0,   0,   0,
      0,   0,  32,   0,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,
      0,   2,   0,   0,   0,   0,   0,   0,   8,   0,   0,   0,   0,   0,   0,   0,
};

/* Bidi_Mirrored: 572 bytes. */

RE_UINT32 re_get_bidi_mirrored(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_bidi_mirrored_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_bidi_mirrored_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_bidi_mirrored_stage_3[pos + f] << 6;
    pos += code;
    value = (re_bidi_mirrored_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Indic_Positional_Category. */

static RE_UINT8 re_indic_positional_category_stage_1[] = {
    0, 1, 2, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_indic_positional_category_stage_2[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   3,   4,   5,   6,   7,   8,
      9,   6,  10,  11,   9,   6,  12,  13,   5,  14,  15,   4,  16,  17,  18,   0,
     19,  20,  21,   4,   5,  14,  22,   4,  23,  24,  25,   4,  26,   0,  27,  28,
      0,  29,  30,   0,   0,  31,  32,   0,  33,  34,   0,  35,  36,  37,  38,   0,
      0,  39,  40,  41,  42,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  43,  43,  44,  44,   0,  45,  46,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,  48,  49,   0,
     50,   0,  51,  52,   0,   0,   0,   0,  53,  54,  55,  56,  57,  58,   0,  59,
      0,  60,   0,   0,   0,   0,  61,  62,   0,   0,   0,   0,   0,   0,   0,  63,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  64,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     65,  66,   0,   0,  67,  68,  69,  70,   0,  71,  72,   0,   1,  73,  74,  75,
      0,  76,  77,  78,   0,  79,  80,  81,   0,   0,   0,   0,   0,   0,   0,  82,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     83,  84,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     85,  86,  87,   0,  57,  88,   0,   0,  89,  90,  91,  92,  57,  93,  94,   0,
      0,  95,   0,   0,   0,   0,  96,  97,  23,  98,  99, 100,   0,   0,   0,   0,
      0, 101, 102,   0,   0, 103, 104,   0,   0,   0,   0,   0,   0, 105, 106,   0,
      0, 107, 108,   0,   0, 109,   0,   0, 110, 111,   0,   0,   0,   0,   0,   0,
      0, 112,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 113, 114,
    115, 116, 117,   0, 118,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0, 119,   0,   0, 120, 121,   0,   0,   0, 122, 123,   0, 124,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 125,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_indic_positional_category_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   2,   3,   4,   5,   6,   7,   8,   9,   0,   0,
     10,   0,   0,   0,   0,   0,   0,   0,  11,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   3,   4,  12,  13,  14,   0,  15,   0,   0,
     10,   0,   0,   0,   0,   0,   0,  16,  17,   0,   0,   0,   0,   0,   0,   0,
     18,  19,  20,  21,  22,   0,   0,   0,   0,   0,   0,   0,  23,  22,   0,   0,
      4,  24,  25,  26,   0,   0,   0,   0,  10,   0,   0,   0,   0,   0,  27,  28,
      0,   0,   0,   0,   0,   0,   0,  29,   4,  12,  30,  31,   0,  32,   0,   0,
     16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  33,
     34,  35,  36,  37,   0,  15,   0,   0,   6,  38,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  27,   6,  39,  40,  23,   0,  41,   0,   0,
     42,  43,  44,  23,   0,  45,   0,   0,  46,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  19,  47,  48,  49,  36,  37,   0,  15,   0,   0,
     33,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,  15,  50,  51,  52,  53,
      0,   0,   0,   0,  33,   0,   0,   0,   0,   0,   0,   0,  54,  28,  55,   0,
     56,  57,  28,  58,   0,   0,   0,   0,   0,   0,   0,   0,  54,  28,  59,  60,
     56,  61,  28,  23,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  62,   0,
      0,   0,   0,   0,   0,  63,  64,  65,   0,   0,   0,   0,  66,  67,  68,   1,
     69,  70,   0,  71,  72,  72,  71,  72,  72,  72,  72,  72,  72,  72,  72,  60,
      0,  73,   0,   0,   0,   0,   0,   0,   0,   0,  15,  74,  75,  76,  77,  78,
      0,   0,   0,   0,   0,  33,  62,  10,  79,  80,  81,  82,  83,  38,   0,   0,
     84,  85,  81,  86,   0,   0,  33,  87,   0,   0,   0,   0,  88,  60,   0,   0,
      0,   0,   0,   0,  88,   0,   0,   0,   0,   0,   0,   0,   0,  89,  76,  90,
     91,  92,  93,  28,  94,   0,   0,  64,  95,  96,   6,   0,  97,  81,  98,   0,
      0,   0,   0,   0,  81,  99, 100,  81, 101,   0,  82,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  19, 102,   0,   0,   0,   0,   0,   0, 103,  76,  55,
    104,  93, 105, 106, 107,  28,  28, 108,  28, 101,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 109, 110, 111, 112, 101,   0,   0,   0,   0,   0,   0,
      0,   0,  19,   5,  28,   0,   0,   0, 113,   0,   0,   0,   0,   0,   0,   0,
    114, 115, 113,  62,   0,   0,   0,   0,   0,   2,  46, 116,  46,   0,   0,   0,
      0, 117, 118,   5,  28, 119,   0,   0,   0,   0,   0,   0,  58, 120, 121,  72,
    122, 123, 124,  22,   0, 125,   0,   0,   0,   0,   0,   0,   0,   0,  19,   0,
      0,   0,   0,   0,  38,   0,   0,   0,  16,  16,  19,   0,   0,   0,   0,   0,
     15, 126,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  81,  81,  81,  81, 127,   0,   0,   0,   0,   0,   0,
     28,  28,  28,  28,  23,   0,   0,  19,   0,   0, 128,  62,   0,   0,   0,   0,
      0, 128, 129,  59,  46,   0,   0,   0,   0,   0,   0,   0,  19,  50, 130, 131,
    132,   0,   0,   0,   0,   0,   0,   0,   0,  64,   0,   0,   0,   0,   0,   0,
      0,   0,  83, 133, 134, 135,   0,   0,  19,   0,   0, 136,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  15, 136,   0,   0,   0,   0, 109, 137, 138, 139,
     64,   0,   0,   0,   0,   0,   0,   0,   0,   0, 140, 141,   0, 142,   0,   0,
     15,  54, 143,  26,   0,   0,   0,   0, 144, 145,   0,  59,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 146,   0, 147,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  28,  72, 121,  58,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 148, 149,  18,   0,  58,   0,   0,   0,   0,   0,   0,   0,
      0,  19,   9, 150, 146,  38,   0,   0,   0,  45,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,   0,  15, 151,  72, 152,
    101,   0, 153,  60,   0,   0,   0,   0,   0,   0,   0,  48, 154, 109,   0,  16,
      0,   0,   0,   0,   0,   0,   0,  19, 148,   5, 146,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 128,  79,   6, 155,  13, 156,   0,  15,   0,   0,
     33,  27,  28,  38,  28,  38,   0,   0,   0,   0,   0,   0,   0, 157,  72, 121,
    158, 159,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0, 148,  72, 160, 161,
    162,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  15, 151,  62, 163, 164,
     60,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,  48,  72, 149, 165,
     38,   0,   0,   0,   0,   0,   0,   0,   0,   0,  19, 166, 121, 164,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 167,  50, 168,   5,   0,   0,   0,   0,   0,
      0,   0,   0, 148,  59,  28,  18,   0,   0,   0,   0,   0, 157,  72,  27,  81,
     60, 169,   0,   0,   0,   0,   0,   0, 170,  28, 171,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 128,   5, 172,  55,   0,   0,   0,   0, 170,   1,   4,   0,
      0,   0,  10,  72,  72, 173,  38,   0,   0,   0,   0,  15,   9,  55,  28, 164,
      0,   0,   0,   0,  10,  72,  72,  72,  72,  72, 114,  72, 174, 175,   0,   0,
      0,   0,   0,   0,  83, 171,  16,  94, 176, 177,   0,   0,   0,   0,   0,   0,
      0,   0,  33, 178, 179, 147,   0,   0,   0,   0,   0,   0,  19, 180,   0,   0,
};

static RE_UINT8 re_indic_positional_category_stage_4[] = {
     0,  0,  0,  0,  5,  5,  5,  1,  0,  0,  5,  1,  6,  0,  1,  2,
     1,  6,  6,  6,  6,  5,  5,  5,  5,  1,  1,  1,  1,  6,  2,  1,
     0,  5,  6,  5,  5,  5,  6,  6,  0,  0,  6,  6,  0,  5,  1,  1,
     6,  0,  0,  2,  2,  0,  0,  4,  4,  6,  0,  0,  0,  0,  0,  1,
     0,  0,  5,  0,  0,  5,  5,  1,  1,  6,  6,  0,  0,  0,  0,  5,
     5,  0,  0,  5,  5,  6,  0,  0,  0,  6,  0,  0,  5,  5,  0,  0,
     6,  5,  0,  5,  5,  8,  0,  1,  1,  6,  0,  0,  0,  0,  5,  5,
     5,  5,  5,  5,  6,  0,  1,  5,  9,  0,  0,  4, 10,  6,  0,  0,
     0,  0,  5,  8,  0,  0,  1,  1,  5,  1,  1,  0,  0,  0,  2,  2,
     2,  0,  4,  4,  4,  5,  0,  0,  5,  0,  0,  0,  1,  0,  5,  5,
     7,  0,  5,  5,  0,  5,  6,  0,  8,  1,  1,  1,  1,  0,  5,  8,
     8,  0,  8,  8,  0,  1,  1,  0,  5,  5,  1,  1,  5,  0,  1,  1,
     1,  1,  1,  6,  6,  0,  2,  2,  1,  1,  5,  5,  6,  0,  6,  0,
     1,  2,  9,  2,  4, 10,  4,  1,  1,  5,  1,  1,  6,  6,  6,  0,
     3,  3,  3,  3,  3,  1,  0,  5,  5,  5,  5,  0,  6,  6,  6,  5,
     6,  0,  0,  0,  3,  0,  0,  0,  6,  6,  0,  0,  0,  6,  0,  6,
     0,  5,  0,  0,  0,  0,  1,  2,  0,  6,  5,  7,  6,  6,  7,  7,
     7,  7,  5,  5,  5,  7,  5,  5,  6,  0,  5,  5,  0,  6,  6,  6,
     6,  6,  6,  6,  0,  0,  6,  0,  1,  5,  5,  6,  6,  2,  5,  5,
     5,  5,  5,  6,  1,  0,  5,  1,  0,  6,  6,  0,  6,  0,  1,  1,
     1,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  5,  5,  5,
     0,  0,  6,  1,  2,  5,  5,  1,  1,  6,  0,  1,  1,  5,  0,  0,
     0,  0,  5,  6,  0,  0,  1,  5,  6,  6,  9, 10,  4,  2,  2,  2,
     4,  4,  5,  1,  1,  5,  5,  5,  5,  5,  0,  5,  5,  5,  6,  1,
     1,  8,  8,  5,  1,  1,  6,  1,  1,  6,  5,  6,  1,  3,  3,  3,
     1,  1,  3,  1,  1,  0,  0,  0,  6,  2,  1,  5,  0,  2,  6,  1,
     0,  1,  5,  1,  5,  6,  6,  5,  6,  1,  2,  2,  2,  2,  2,  5,
     5,  0,  0,  6,  5,  1,  5,  5,  6,  6,  6, 11,  7, 13,  2,  2,
     4,  4,  5,  8,  5,  5,  1,  0,  0,  1,  6,  6,  5,  6,  2,  1,
     1,  5,  1,  5,  1,  1,  1,  2,  2,  9,  1,  1,  2,  2,  5,  6,
    14,  6,  6,  6,  6,  6,  5,  5,  5,  1, 14, 14, 14, 14, 14, 14,
    14,  0,  0,  0,  5,  0,  0,  1,  1,  6,  5,  1,  6,  5,  0,  0,
     0,  0,  0,  6,  6,  6,  5,  6,  6,  6,  2,  2,  5,  6,  1, 12,
    11,  0,  0,  0,  5,  6,  5,  2,  2,  5,  6,  1,  2,  6,  6,  0,
     5,  1,  0,  0,  6,  3,  3,  5,  5,  3,  1,  3,  3,  1,  5,  5,
     0,  0,  0,  2,  6,  5,  2,  1,  0,  1,  0,  0,  6,  1,  1,  0,
     0, 14,  6,  6,  0,  5, 14,  0,  5,  6,  6,  0,  1,  5,  1,  0,
     1,  2,  1,  6,  6,  5,  5,  1,  2,  5,  7,  7,  2,  1,  6,  6,
     5,  5,  5,  8,  0,  6,  6,  5,  5,  5,  8,  8,  1,  0,  0,  2,
     4,  1,  0,  0,  0,  1,  2,  1,  1,  1,  6,  5,  5,  1,  6,  0,
     6,  2,  5,  9,  4,  1,  4,  5,  5,  1,  6,  6,  2,  9,  4, 10,
     5,  5,  1,  6,  1,  5,  1,  6,  1,  5,  2,  1,  0,  6,  0,  5,
     6,  6,  2,  5,  2,  0,  0,  0,  0,  5,  6,  6,  5,  5,  6,  0,
     5,  1,  0,  6,  6,  6,  5,  1,  6,  2,  6,  5,  1,  5,  5,  0,
     5,  5,  6,  5,  6,  0,  0,  6,  1,  1,  1,  0,  5,  5,  0,  1,
     6,  2,  1,  0,
};

/* Indic_Positional_Category: 2852 bytes. */

RE_UINT32 re_get_indic_positional_category(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_indic_positional_category_stage_1[f] << 6;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_indic_positional_category_stage_2[pos + f] << 3;
    f = code >> 2;
    code ^= f << 2;
    pos = (RE_UINT32)re_indic_positional_category_stage_3[pos + f] << 2;
    value = re_indic_positional_category_stage_4[pos + code];

    return value;
}

/* Indic_Syllabic_Category. */

static RE_UINT8 re_indic_syllabic_category_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_indic_syllabic_category_stage_2[] = {
     0,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
    17, 18,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 19, 20,
     2,  2, 21, 22, 23, 24, 25, 26, 27, 28,  2, 29,  2,  2,  2,  2,
    30, 31,  2,  2,  2,  2,  2,  2,  2,  2,  2, 32,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    33, 34, 35, 36, 37, 38,  2, 39,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  2, 40,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    41, 42, 43, 44, 45, 46, 47,  2, 48, 49,  2, 50, 51, 52, 53,  2,
    54,  2,  2, 55, 56, 57,  2,  2, 58, 59, 60, 61,  2, 62,  2,  2,
};

static RE_UINT8 re_indic_syllabic_category_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   2,   3,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   5,   0,   0,   0,
      0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   8,   8,   8,   8,   9,  10,  10,  10,  10,  10,  10,  10,  10,  11,  12,
     13,  13,  13,  14,  15,  16,  10,  10,  17,  18,   2,   2,  19,   8,  10,  10,
     20,  21,   8,  22,  22,   9,  10,  10,  10,  10,  23,  10,  24,  25,  26,  12,
     13,  27,  27,  28,   0,  29,   0,  30,  17,  18,   2,   2,  26,   0,   0,  31,
     32,  21,  33,  34,  22,   9,  10,  10,  10,  10,  23,  10,  23,  35,  26,  36,
     37,  29,  27,  38,  39,   0,  40,  24,   0,  18,   2,   2,  41,  42,   0,   0,
     32,  21,   8,  43,  43,   9,  10,  10,  10,  10,  23,  10,  23,  40,  26,  12,
     13,  44,  44,  38,   0,   0,   0,   0,  17,  18,   2,   2,   0,   0,  45,  46,
     32,  21,   8,  22,  22,   9,  10,  10,  10,  10,  23,  10,  23,  40,  26,  12,
     13,  27,  27,  38,   0,  47,   0,  30,  17,  18,   2,   2,  48,   0,   0,   0,
     49,  21,  33,  19,  50,  51,  35,  23,  52,  53,  54,  25,  10,  10,  26,  47,
     37,  47,  55,  38,   0,  29,   0,   0,   0,  18,   2,   2,   0,   0,   0,   0,
      7,  56,   8,  50,  50,   9,  10,  10,  10,  10,  23,  10,  10,  10,  26,  57,
     13,  55,  55,  38,   0,  58,  54,   0,  17,  18,   2,   2,   0,   0,   0,   0,
      7,  21,   8,  50,  50,   9,  10,  10,  10,  10,  23,  10,  10,  40,  26,  12,
     13,  55,  55,  38,   0,  58,   0,  59,  17,  18,   2,   2,  60,   0,   0,   0,
      7,  21,   8,  50,  50,   9,  10,  10,  10,  10,  10,  10,  10,  10,  61,  62,
     13,  55,  55,  63,   0,  64,   0,  34,  17,  18,   2,   2,   0,   0,  65,  66,
     67,  21,   8,   8,   8,  33,  25,  10,  10,  10,  10,  10,  30,  10,  10,  48,
     10,  54,  68,  29,  13,  69,  13,  13,   0,  18,   2,   2,  47,   0,   0,   0,
     40,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  54,  13,  13,  70,   0,
     13,  44,  71,  72,   2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     35,  23,  54,  10,  10,  10,  10,  10,  10,  73,  10,  54,  13,  13,  74,  75,
     13,  76,  71,  77,   2,   2,   3,  10,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,  78,  79,   0,
     10,  10,  40,  10,  10,  10,  10,  10,  10,  10,  10,  53,  16,  13,  13,  80,
     81,  82,  83,  84,  85,  85,  86,  85,  85,  85,  85,  85,  85,  85,  85,  87,
      0,  88,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  10,  10,  10,  10,  10,  10,  10,  89,   8,  90,  13,  13,  91,  92,  93,
      2,   2,  94,  95,  96,  17,  97,  98,  99, 100, 101, 102, 103, 104,  10,  10,
    105, 106,  71, 107,   2,   2, 108, 109,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    110,  10,  10,  23,  11, 111,   0,   0, 110,  10,  10,  10,  11, 111,   0,   0,
    110,  10,  10,  10,  11,   0,   0,   0, 110,  10,  10,  23, 112,   0,   0,   0,
     10,  10,  10,  10,  10,  10,  10,  10, 113,   8,   8,   8,   8,  47,  13,  13,
     13,  80, 114, 115, 116,   0,   0, 117,   2,   2,   3,   0,   0,   0,   0,   0,
    118,  10,  10,  10,  10,  10,  10,  54,  13,  13, 119,   0, 120, 121, 122,   0,
      0,  18,   2,   2,  10,  10,  10,  10, 123, 124, 124, 125, 126, 127,   0,   0,
     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,   0,  13,  13,  13,  13,
    128, 121, 129,   0,   2,   2, 130,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  10,  10,  10,  10, 131,  13,   0,  10,  10,  10,  10,  10,  10,  10,  10,
     10,  10,  10,  89, 110, 132, 133, 134, 135,  13,  13,  13,  13, 136, 137, 138,
      2,   2,   3,   0,   2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    139, 140,   8,   8, 110,  10,  10,  10,  10,  10,  10,  10,  10, 141,  13,  13,
     13, 142,  10,   0,   2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    143,   8, 144,  10,  10,  10,  10,  10, 145,  13, 146, 147,   2,   2, 148, 149,
     10,  10,  10,  10,  10,  10,  10,  10,  10, 150,  13,  13, 151,   0,   0,   0,
     10,  10,  10,  10,  10,  10,  10,  10,  10, 152,  13, 128, 121, 153,   0,   0,
      2,   2,   3,  40,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 154, 155, 155, 155, 156,   0,   0,   0,  65, 157, 158,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 159,   0,
      0,   0,   0, 160, 161,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 162,   0,   0,
      5, 162,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 163,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    164, 165, 166,  10,  10,  10,  10,  10, 131,  13,   0,   0,   0,   0,   0,   0,
     10,  10,  10,  10,  10,  10,  10, 167, 168, 169, 170,  10, 171,   0,   0,   0,
    172,   8,   8,   8, 144,  10,  10,  10,  10,  10,  10,  10,  10, 173,  13,  13,
     13, 174,   0,   0,   2,   2,   3,   0, 155, 155, 155, 155, 175,   0,   0, 176,
      2,   2, 177,  10,  10,  10,  10,  10, 167, 124, 178, 129,  10,  10,  10,  10,
     10, 131,  13, 179, 180,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    181,   8,   9, 110,  10,  10,  10,  10,  10,  10,  10,  10, 182,  13,  13, 183,
    184,   0,   0,   0,   2,   2,   3,   0,  10, 185,  10,  10,   2,   2, 177,  54,
      8, 144,  10,  10,  10,  10,  10,  10,  10,  10, 103,  13, 186, 187,   0,   0,
    121, 121, 121, 188,   2,   2,   3,   0,  10,  10,  10,  10,  40, 189, 190, 102,
     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  13,  13,  13, 106,
    191,   0,   0,   0,   0,   0,   0,   0, 144,  10, 131,  13,   0, 192,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  10,  10,  96, 193,  10, 194, 121, 195,  13,  37, 196,   2,   2,   3,   0,
    103,  58,   0,  80,  10,  40,  40,  10,  10,  10,  10,  10,  10,  26, 197, 198,
      2,   2, 199,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    200, 201,   8,   8, 110,  10,  10,  10,  10,  10,  10,  10,  10,  10,  13,  13,
     13, 202,   0,   0, 203, 204, 204, 204, 204, 205,   2,   2,   0,   0,   0, 206,
    207,   8,   8,   9,  10,  10,  10,  10,  10,  10,  10,  10,  13,  13, 208,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    207, 110,  10,  10,  10,  10,  10,  10,  10, 131,  13,  13, 209, 210,   2,   2,
      0, 211,   0,   0, 124, 212,  10,  10,  10,  10,  10,  10, 182,   0,   0,   0,
    207,   8,   8,   8,   9,  10,  10,  10,  10,  10,  10,  10, 131,  13,  13,  13,
    213,   0, 214,  76,   2,   2,   3,   0, 215,   2,   2,   2,   2, 199,   0,   0,
      8,   8,  10,  10,  30,  10,  10,  10,  10,  10,  10,  13,  13, 216,   0, 217,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      8,  54,  23,  30,  10,  10,  10,  30,  10,  10,  53,   0,   8,   8, 144,  10,
     10,  10,  10,  10,  10,  10,  10, 166,  13,  13, 218,   0,   2,   2,   3,   0,
      7,  21,   8,  22,  22,   9,  10,  10,  10,  10,  23,  10,  23,  40, 219,  12,
     13,  27,  27,  38,   0,  29,   0, 220,  17, 221, 155, 163, 155, 163,   0,   0,
      8,   8,   8, 144,  10,  10,  10,  10,  10,  10,  10,  10,  10, 103,  13,  13,
    222, 223,   0,   0,   2,   2,   3, 224,   0,   0,   0,   0,   0,   0,   0,   0,
     21,   8,   8, 110,  10,  10,  10,  10,  10,  10,  10,  10,  13,  13,  13, 225,
    226, 227,   0,   0,   2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      8,   8,   8, 144,  10,  10,  10,  10,  10,  10,  10, 131,  13, 109,  13, 228,
    229,   0,   0,   0,   0,   0,   8, 109,   0,   0,   0,   0,   0,   0,   0,   0,
      8,   8,   8, 144,  10,  10,  10,  10,  10,  10,  10,  10,  13,  13,  13, 230,
     76,   0,   0,   0,   2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      8,   8, 144,  10,  10,  10,  10,  10,  10,  10, 166, 231,  13, 232,  53,   0,
      2,   2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     10,  10,  10,  10,  10,  10,  54, 233,  13,  13, 234,   0,   2,   2,   2,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      8,   8, 144,  10,  10,  10,  10,  10,  10,  10,  10,  13,  13, 225, 235,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   8,   8,  19, 144,  10,  10,  10,  10,
     10,  10,  10,  10, 103,  13,  47,  80, 236,  76,   0,   0,   0,   0,   0,   0,
    237,  13, 238,  10,  10,  10,  10,  10,  10,  10,  10,  10, 239, 240, 241, 242,
      0, 243,   0,   0, 237,  13,  13,  10,  10,  10,  10,  10,  10,  10,  10,  10,
     10, 244, 245, 121, 121, 246, 247, 248,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      8,   8,  50, 144,  10,  10,  10,  10,  10,  10,  10, 131,  13,  37,  13, 228,
    227,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2, 199,  25,  10,  10,  10,
     10,  10,  10,  10, 249,  85,  85,  85,  85,  85,  86,  85,  13, 250,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      8,  33,  43,  10,  10,  10,  10,  10,  10,  10,  10,  10, 103,  37, 251,  44,
    252, 253,   0,   0,   2,   2,   3,   0,   8,  43,  50,  10,  10,  10,  10,  10,
     10,  10,  11,  37,  44, 254,   0,   0,   2,   2,   3,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  10,  10,  10,  10, 255,  37,   0,   0,
};

static RE_UINT8 re_indic_syllabic_category_stage_4[] = {
     0,  0,  0,  0,  0, 11,  0,  0, 34, 34, 34, 34, 34, 34,  0,  0,
    11,  0,  0,  0,  0,  0, 29, 29,  0,  0,  0, 11,  1,  1,  1,  2,
     8,  8,  8,  8,  8, 12, 12, 12, 12, 12, 12, 12, 12, 12,  9,  9,
     4,  3,  9,  9,  9,  9,  9,  9,  9,  5,  9,  9,  0, 27, 27,  0,
     0,  9,  9,  9,  8,  8,  9,  9,  0,  0, 34, 34,  0,  0,  8,  8,
    11,  1,  1,  2,  0,  8,  8,  8,  8,  0,  0,  8, 12,  0, 12, 12,
    12,  0, 12,  0,  0,  0, 12, 12, 12, 12,  0,  0,  9,  0,  0,  9,
     9,  5, 13,  0,  0,  0,  0,  9, 12, 12,  0, 12,  1,  0, 29,  0,
     0,  1,  1,  2,  8,  8,  8,  0,  0,  0,  0,  8,  0, 12, 12,  0,
     4,  0,  9,  9,  9,  9,  9,  0,  9,  5,  0,  0,  0, 27,  0,  0,
     0, 12, 12, 12,  1, 26, 11, 11,  0, 20,  0,  0,  8,  8,  0,  8,
     9,  9,  0,  9,  0, 12, 27, 27, 27,  4,  4,  4,  0,  0,  9,  9,
     0, 12,  0,  0,  0,  0,  1, 23,  8,  0,  8,  8,  8, 12,  0,  0,
     0,  0,  0, 12, 12,  0,  0,  0, 12, 12, 12,  0,  9,  0,  9,  9,
     1,  8,  8,  8,  0,  3,  9,  9,  0,  9,  9,  0,  0,  0, 12,  0,
     0, 14, 14,  0, 12, 12, 12,  6,  6,  3,  9,  9,  9,  5, 16,  0,
    13, 13, 13,  9,  0,  0, 13, 13, 13, 13, 13, 13,  0,  0,  1,  2,
     0,  0,  5,  0,  9,  0,  9,  0,  9,  9,  6,  0, 25, 25, 25, 25,
    30,  1,  6,  0,  0, 12,  0, 12,  9,  9,  6,  9, 20, 20,  0,  0,
     9,  0,  0,  0,  0,  1,  0,  0,  0, 29,  0, 29,  0,  4,  0,  0,
     9,  9,  1,  2,  9,  9,  1,  1,  6,  3,  0,  0, 22, 22, 22, 22,
    22, 19, 19, 19, 19, 19, 19, 19,  0, 19, 19, 19, 19,  0,  0,  0,
     0,  0, 29,  0, 12,  8,  8,  8,  8,  8,  8,  9,  9,  9,  1, 25,
     2,  7,  6, 20, 20, 20, 20, 12, 34, 34,  0, 11,  0,  0, 11,  0,
    12, 12,  8,  8,  9,  9, 12, 12, 12, 12, 20, 20, 20, 12,  9, 25,
    25, 12, 12,  9,  9, 25, 25, 25, 25, 25, 12, 12, 12,  9,  9,  9,
     9, 12, 12, 12, 12, 12, 20,  9,  9,  9,  9, 25, 25, 25, 12, 25,
    34, 34, 25, 25,  9,  9,  0,  0,  8,  8,  8, 12,  6,  0,  0,  0,
    12,  0,  9,  9, 12, 12, 12,  8,  9, 28, 28, 29, 18, 30, 29, 29,
    29,  6,  7, 29,  3, 29,  0,  0, 11, 12, 12, 12,  9, 19, 19, 19,
    21, 21,  1, 21, 21, 21, 21, 21, 21, 21,  9, 29, 12, 12, 12, 10,
    10, 10, 10, 10, 10, 10,  0,  0, 24, 24, 24, 24, 24,  0,  0,  0,
     9, 21, 21, 21, 25, 25,  0,  0, 34, 34, 34,  0, 12, 12, 12,  9,
    12, 20, 20, 19, 21, 21, 17, 19, 19, 19, 19,  0,  7,  9,  9,  9,
     1, 25, 25, 25, 25, 25,  6, 29, 29,  0,  0, 29,  1,  1,  1, 18,
     2,  8,  8,  8,  4,  9,  9,  9,  5, 12, 12, 12,  1, 18,  2,  8,
     8,  8, 12, 12, 12, 19, 19, 19,  9,  9,  6,  7, 19, 19, 12, 12,
    34, 34,  3, 12, 12, 12, 21, 21,  8,  8,  4,  9, 21, 21,  6,  6,
    19, 19,  9,  9,  1,  1, 29,  4, 27, 27, 27,  0, 27, 27, 27, 27,
    27, 27,  0,  0, 27, 14, 14, 27, 27, 27, 11,  0,  0,  0,  0, 29,
    31, 32,  0,  0, 11, 11, 11, 11, 29,  0,  0,  0, 27,  0,  0,  0,
     8,  8,  9,  8,  8,  8,  5, 12, 12, 12, 12,  1, 12, 12, 10, 10,
    10, 10, 12, 12, 12, 12, 10, 19, 19, 12, 12, 12, 12, 19, 12,  1,
     1,  2,  8,  8, 20,  9,  9,  9,  5,  1,  0,  0, 27, 27,  1,  1,
     0,  0,  8,  9, 34, 34, 12, 12, 10, 10, 10, 25,  9,  9,  9, 21,
    21, 21, 21,  6,  1,  1, 18,  2, 12, 12, 12,  4,  9, 20, 20, 20,
     5,  0,  0,  0, 12,  9,  0, 12,  9,  9,  9, 20, 20, 20, 20,  0,
    21, 21,  0,  0, 11, 11, 11,  0,  0,  0, 12, 25, 24, 25, 24,  0,
     0,  2,  7,  0, 12,  8, 12, 12, 12, 12, 12, 21, 21, 21, 21,  9,
    25,  6,  0,  0,  4,  4,  4,  0,  0,  0,  0,  7, 34,  0,  0,  0,
     1,  1,  2, 14, 14,  8,  8,  8,  9,  9,  5,  0,  0,  0, 35, 35,
    35, 35, 35, 35, 35, 35, 34, 34,  0,  0,  0, 33,  1,  1,  2,  8,
     9,  5,  4,  0,  9,  9,  9,  7,  6,  0, 34, 34, 12,  9,  9,  0,
    10, 12, 12, 12,  5,  3, 15, 15,  0, 29,  4,  9,  0, 34, 34, 34,
     1,  5,  4, 26,  0,  0, 27,  0,  9,  4,  6,  0, 12, 12,  0,  4,
     0,  0,  1,  1,  0,  0, 27, 27,  9,  9,  5,  1,  1,  2,  4,  3,
     0,  0, 29,  1,  9,  9,  9,  1,  1,  2,  5,  4,  3,  0,  0,  0,
     1,  1,  2,  5,  4,  0,  0,  0,  9,  1,  2,  5,  2,  9,  9,  9,
     9,  9,  5,  4,  0, 20, 20, 20,  9,  9,  9,  6,  2,  5,  4,  0,
     5,  3,  0,  0,  8,  9,  9,  9,  9,  9,  9, 12, 12, 12, 12, 29,
     6,  1,  1,  1,  1,  2, 15, 20, 20, 20, 20, 11,  0, 11,  0,  7,
    15, 15, 15, 15, 15, 15, 21, 21, 21, 21,  1,  2, 26,  7,  0,  0,
     0,  3,  0,  0,  0,  0, 19, 19,  9,  1,  1,  0,  0,  0,  9,  0,
     1,  2,  4,  9,  6,  7, 16, 20,  9,  1,  2,  7, 12, 12, 11,  9,
};

/* Indic_Syllabic_Category: 3496 bytes. */

RE_UINT32 re_get_indic_syllabic_category(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_indic_syllabic_category_stage_1[f] << 6;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_indic_syllabic_category_stage_2[pos + f] << 5;
    f = code >> 2;
    code ^= f << 2;
    pos = (RE_UINT32)re_indic_syllabic_category_stage_3[pos + f] << 2;
    value = re_indic_syllabic_category_stage_4[pos + code];

    return value;
}

/* Emoji. */

static RE_UINT8 re_emoji_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_emoji_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4, 1, 5, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 7, 8, 1,
};

static RE_UINT8 re_emoji_stage_3[] = {
     0,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     3,  4,  1,  1,  5,  1,  6,  1,  1,  1,  1,  1,  7,  1,  1,  8,
     1,  1,  1,  9,  1,  1, 10, 11, 12, 13, 14, 15, 16, 17, 18,  1,
     1,  1,  1,  1, 19,  1,  1,  1,  1,  1,  1,  1, 20, 21,  1,  1,
    22,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  1,  1,  1,  1,  1,
    24,  1,  1, 25,  1, 26, 27, 28, 29, 30,  1,  1, 31, 32, 33, 34,
    32, 32, 32, 35, 36, 37, 38, 39, 32, 40, 32, 41,  1,  1,  1, 42,
     1,  1,  1,  1, 43, 44, 45, 46,  1, 47, 48,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_emoji_stage_4[] = {
      0,   0,   0,   0,   8,   4, 255,   3,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  66,   0,   0,   0,   0,   0,   0,   0,   0,   0,  16,
      0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   2,
      0,   0, 240,   3,   0,   6,   0,   0,   0,   0,   0,  12,   0,   1,   0,   0,
      0, 128,   0,   0,   0, 254,  15,   7,   4,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  12,  64,   0,   1,   0,   0,   0,   0,   0,   0, 120,
     31,  64,  50,  33,  77, 196,   0,   7,   5, 255,  15, 128, 105,   1,   0, 200,
      0,   0, 252,  26,   3,  12,   3,  96,  48, 193,  26,   0,   0,   6, 191,  39,
     36, 191,  84,  32,   2,   1,  24,   0, 144,  80, 184,   0,  24,   0,   0,   0,
      0,   0, 224,   0,   2,   0,   1, 128,   0,   0,   0,   0,   0,   0,  48,   0,
    224,   0,   0,  24,   0,   0,   0,   0,   0,   0,  33,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   1,  32,   0,   0, 128,   2,   0,   0,   0,   0,
     16,   0,   0,   0,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   3, 192,   0,  64, 254,   7,   0,   0,   0,   0,
      0,   0,   0,   0, 192, 255, 255, 255,   6,   0,   0,   4,   0, 128, 252,   7,
      0,   0,   3,   0,   0,   0,   0,   0, 255, 255, 255, 255, 243, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 207, 206, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 185, 255, 255, 255, 255, 255, 255, 255, 255, 191,
    255, 255, 255, 255, 255, 255, 255,  63,   0, 126, 255, 255, 255, 128, 249,   7,
    128,  60,  97,   0,  48,   1,   6,  16,  28,   0,  14, 112,  10, 129,   8, 252,
    255, 255,   0,   0,   0,   0,   0,   0,  63, 248,  39,   0,  63,  26, 249,   7,
      0,   0,   0,   0, 255,  15,   0,   0,   0, 224, 255, 255, 255, 255, 255, 247,
    191, 255, 255, 255, 255, 255, 123, 252, 255, 255, 255, 255, 231, 199, 255, 255,
    255, 231, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,  15,   7,
      7,   0,  63,   0,   0,   0,   0,   0,
};

/* Emoji: 652 bytes. */

RE_UINT32 re_get_emoji(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_emoji_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_emoji_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_emoji_stage_3[pos + f] << 6;
    pos += code;
    value = (re_emoji_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Emoji_Presentation. */

static RE_UINT8 re_emoji_presentation_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_emoji_presentation_stage_2[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  1,  2,  3,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  5,  6,  7,  8,  9, 10,  0,  0,
};

static RE_UINT8 re_emoji_presentation_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  2,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,
     4,  0,  5,  6,  7,  8,  9, 10, 11, 12, 13,  0, 14, 15,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 16,  0, 17,  0,  0,  0,  0,  0,
    18,  0,  0,  0,  0,  0, 19,  0,  0,  0,  0,  0, 20,  0,  0, 21,
    22, 23, 24,  0,  0,  0,  0,  0, 25, 26, 25, 27, 28, 25, 29, 30,
    25, 31, 32, 25, 25, 25, 25, 33, 25, 34, 35, 36, 37, 18,  0, 38,
    25, 25, 39,  0, 25, 25, 40, 41,  0,  0,  0,  0,  0,  0,  0, 42,
     0,  0,  0,  0,  0,  0,  0,  0, 43, 44, 45, 46, 25, 47, 48, 25,
     0,  0,  0, 49, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_emoji_presentation_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,  12,   0,  30,   9,   0,   0,   0,   0,  96,
      0,   0,  48,   0,   0, 255,  15,   0,   0,   0,   0, 128,   0,   0,   8,   0,
      2,  12,   0,  96,  48,  64,  16,   0,   0,   4,  44,  36,  32,  12,   0,   0,
      0,   1,   0,   0,   0,  80, 184,   0,   0,   0, 224,   0,   0,   0,   1, 128,
      0,   0,   0,  24,   0,   0,  33,   0,  16,   0,   0,   0,   0, 128,   0,   0,
      0,  64, 254,   7, 192, 255, 255, 255,   2,   0,   0,   4,   0, 128, 124,   7,
      0,   0,   3,   0, 255, 255, 255, 255,   1, 224, 191, 255, 255, 255, 255, 223,
    255, 255,  15,   0, 255, 135,  15,   0, 255, 255,  17, 255, 255, 255, 255, 127,
    253, 255, 255, 255, 255, 255, 255, 159, 255, 255, 255,  63,   0, 120, 255, 255,
    255,   0,   0,   4,   0,   0,  96,   0,   0,   0,   0, 248, 255, 255,   0,   0,
     63,  16,  39,   0,   0,  24, 240,   7, 255,  15,   0,   0,   0, 224, 255, 255,
    255, 255, 255, 247, 191, 255, 255, 255, 255, 255, 123, 252, 231, 199, 255, 255,
    255, 231, 255, 255,   0,   0,  15,   7,   7,   0,  63,   0,
};

/* Emoji_Presentation: 544 bytes. */

RE_UINT32 re_get_emoji_presentation(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_emoji_presentation_stage_1[f] << 5;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_emoji_presentation_stage_2[pos + f] << 4;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_emoji_presentation_stage_3[pos + f] << 5;
    pos += code;
    value = (re_emoji_presentation_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Emoji_Modifier. */

static RE_UINT8 re_emoji_modifier_stage_1[] = {
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,
};

static RE_UINT8 re_emoji_modifier_stage_2[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
};

static RE_UINT8 re_emoji_modifier_stage_3[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
};

static RE_UINT8 re_emoji_modifier_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 248,
};

/* Emoji_Modifier: 130 bytes. */

RE_UINT32 re_get_emoji_modifier(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_emoji_modifier_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_emoji_modifier_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_emoji_modifier_stage_3[pos + f] << 7;
    pos += code;
    value = (re_emoji_modifier_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Emoji_Modifier_Base. */

static RE_UINT8 re_emoji_modifier_base_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_emoji_modifier_base_stage_2[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 0,
};

static RE_UINT8 re_emoji_modifier_base_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  2,  3,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  5,
     0,  6,  7,  0,  0,  8,  9,  0,  0, 10, 11, 12,  0,  0,  0,  0,
     0,  0,  0,  0, 13,  0, 14, 15,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_emoji_modifier_base_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   2,   0,  60,   0,   0,   0,   0,   0,   0,
     32,   0,   0,   0,   0,   0,   0,   0, 156,  28,   0,   0,   0,   0,   0,   0,
    204, 255,   1,   0, 192, 255, 255,  17, 238, 128,   2,   0,   0,   4,   0,   0,
      0,   0,   0,   0,   0,   0,  48,   4,   0,   0,  97,   0,   0,   0,   0,   0,
    224, 248,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   0, 112,   0,
      1,  16,   0,   0,   0,   0,   0,   0,   0, 128,   0, 255,  64,   0, 255, 115,
      0,   0,   0,   0,   0,   0,  96,  11,   0, 224, 254,  63,   0,   0,   0,   0,
};

/* Emoji_Modifier_Base: 324 bytes. */

RE_UINT32 re_get_emoji_modifier_base(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_emoji_modifier_base_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_emoji_modifier_base_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_emoji_modifier_base_stage_3[pos + f] << 6;
    pos += code;
    value = (re_emoji_modifier_base_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Emoji_Component. */

static RE_UINT8 re_emoji_component_stage_1[] = {
    0, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_emoji_component_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 5, 1,
    6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_emoji_component_stage_3[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 1, 1, 1, 1, 1, 6,
    1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    8, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_emoji_component_stage_4[] = {
      0,   0,   0,   0,   8,   4, 255,   3,   0,   0,   0,   0,   0,   0,   0,   0,
      0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   0,   0,   0,
      0, 128,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 255, 255, 255,
      0,   0,   0,   0,   0,   0,   0, 248,   0,   0,   0,   0,   0,   0,  15,   0,
      0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
};

/* Emoji_Component: 340 bytes. */

RE_UINT32 re_get_emoji_component(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_emoji_component_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_emoji_component_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_emoji_component_stage_3[pos + f] << 6;
    pos += code;
    value = (re_emoji_component_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Extended_Pictographic. */

static RE_UINT8 re_extended_pictographic_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_extended_pictographic_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4, 1, 5, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 7, 8, 9,
};

static RE_UINT8 re_extended_pictographic_stage_3[] = {
     0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     2,  3,  0,  0,  4,  0,  5,  0,  0,  0,  0,  0,  6,  0,  7,  8,
     0,  0,  0,  9,  0,  0, 10, 11, 12, 13, 14, 13, 15, 16, 17,  0,
     0,  0,  0,  0, 18,  0,  0,  0,  0,  0,  0,  0, 19, 20,  0,  0,
    21,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22,  0,  0,  0,  0,  0,
    13, 13, 13, 13, 23, 24, 25, 26, 27, 28, 13, 13, 13, 13, 13, 29,
    13, 13, 13, 13, 30, 31, 13, 13, 13, 32, 13, 13,  0, 33,  0, 34,
    35, 36, 37, 13, 38, 39, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 30,
};

static RE_UINT8 re_extended_pictographic_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  66,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  16,   0,   2,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   4,   0,   0,   2,   0,   0, 240,   3,   0,   6,   0,   0,
      0,   0,   0,  12,   0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
      0, 128,   0,   0,   0, 254,  15,   7,   4,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  12,  64,   0,   1,   0,   0,   0,   0,   0,   0, 120,
    191, 255, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     63,   0, 255, 255, 255, 255, 255, 255,  63, 255,  87,  32,   2,   1,  24,   0,
    144,  80, 184,   0, 248,   0,   0,   0,   0,   0, 224,   0,   2,   0,   1, 128,
      0,   0,   0,   0,   0,   0,  48,   0, 224,   0,   0,  24,   0,   0,   0,   0,
      0,   0,  33,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,  32,
      0,   0, 128,   2,   0,   0,   0,   0,   0, 224,   0,   0,   0, 128,   0,   0,
      0,   0,   0,   0,   0, 240,   3, 192,   0,  64, 254,   7,   0, 224, 255, 255,
    255, 255, 255, 255,  63,   0,   0,   0, 254, 255,   0,   4,   0, 128, 252, 247,
      0, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   7,
    255, 255, 255, 255, 255, 255, 255,  63, 192, 255, 255, 255, 255, 255, 255, 255,
    255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 240, 255,
      0,   0, 224, 255, 255, 255, 255, 255,   0, 240,   0,   0,   0,   0,   0,   0,
      0, 255,   0, 252,   0,   0,   0,   0,   0, 255,   0,   0,   0, 192, 255, 255,
      0, 240, 255, 255, 255, 255, 255, 247, 191, 255, 255, 255, 255, 255, 255, 255,
};

/* Extended_Pictographic: 596 bytes. */

RE_UINT32 re_get_extended_pictographic(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_extended_pictographic_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_extended_pictographic_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_extended_pictographic_stage_3[pos + f] << 6;
    pos += code;
    value = (re_extended_pictographic_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* NFD_Quick_Check. */

static RE_UINT8 re_nfd_quick_check_stage_1[] = {
    0, 1, 2, 3, 4, 1, 1, 5, 1, 1, 1, 6, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1,
};

static RE_UINT8 re_nfd_quick_check_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  5,  9,  5, 10,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 12,  5,  5,  5,  5,  5,  5,  5,  5, 13,  5,
     5,  5,  5,  5, 14, 15,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5, 16,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 17,  5,
};

static RE_UINT8 re_nfd_quick_check_stage_3[] = {
     0,  0,  0,  1,  2,  3,  4,  5,  6,  0,  0,  0,  0,  7,  8,  9,
    10, 11,  0, 12,  0,  0,  0,  0, 13,  0,  0, 14,  0,  0,  0,  0,
     0,  0,  0,  0, 15, 16,  0, 17, 18, 19,  0,  0,  0, 20, 21, 22,
     0, 23,  0, 24,  0, 22,  0, 25,  0,  0,  0,  0,  0, 26, 27,  0,
    28,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 29, 30,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 31, 31, 32, 33, 34, 35, 36, 37,
    38,  0,  0,  0, 39,  0, 40, 41, 42, 43, 44, 45, 46,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 47,  0,  0,  0,  0,
     0, 48, 49, 50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 51,  0,
     0,  0,  0,  0, 31, 31, 31, 31, 52, 53, 31, 54, 55, 56,  0,  0,
     0,  0, 57,  0, 58,  0,  0,  0,  0,  0,  0,  0,  0, 59,  0,  0,
     0,  0, 60,  0,  0,  0, 61,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 62, 63, 64,  0,  0,  0,  0,  0,  0,  0,  0,
    31, 31, 31, 31, 31, 31, 31, 31, 65,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_nfd_quick_check_stage_4[] = {
      0,   0,   0,   0,   0,   0,   0,   0, 191, 255, 126,  62, 191, 255, 126, 190,
    255, 255, 252, 255,  63, 255, 241, 126, 248, 241, 243, 255,  63, 255, 255, 127,
      0,   0,   0,   0,   3, 128,   1,   0,   0, 224, 255, 223, 207, 255,  49, 255,
    255, 255, 255, 207, 192, 255,  15,   0,  27,   0,   0,   0,   0,   0,  16,  64,
    224, 215,   1,   0,   0, 252,   1,   0,   0, 124,  24,   0,   0,   0,   0,   0,
    139, 112,   0,   2,   0,   0,   0,   2,   0,   0, 139, 112,   0,   0, 192,   0,
      6,   0, 207, 252, 252, 252,  63,   3,   0,   0,   0,   0, 124,   0,   0,   0,
      5,   0,   8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  18,   0,
      0,   0,   0, 255,   0,   0,   0,   0,   0,  24,   0, 176,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  72,   0,   0,   0,   0,  78,   0,   0,   0,   0,
      0,  25,   0,  48,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,
      0,  28,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
    129,  13,   0,   0,   0,   0,   0,   0,   0,   0,   0, 116,   0,   0,   0,   0,
      8,  32, 132,  16,   0,   2, 104,   1,   2,   0,   8,  32, 132,  16,   0,   2,
      0,   0,   0,   0,  64,   0,   0,   0,  64,  85,   4,   0,   0,   0,   0,  40,
     11,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255,  11, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   3,
    255, 255,  63,  63, 255, 255, 255, 255,  63,  63, 255, 170, 255, 255, 255,  63,
    255, 255, 255, 255, 255, 255, 223,  95, 222, 255, 207, 239, 255, 255, 220,  63,
      3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  64,  12,   0,   0,
      0,   0,   0,  12,   0,  64,   0,   0,   0, 224,   0,   0,   0,   0,   0,   0,
     16,  18,   0,   0,  80,   0,   0,   0, 146,   2,   0,   0,   5, 224,  51,   3,
     51,   3,   0,   0,   0, 240,   0,   0,   0,   0,   0,   0,  15,  60,   0,   0,
      0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,
      0,  80,  85,  85, 165,   2, 219,  54,   0,   0,  16,  64,   0,  80,  85,  85,
    165,   2, 219,  54,   0,   0, 144,  71, 255, 255, 255, 255,  15,   0,   0,   0,
    255,  63, 229, 127, 101, 252, 255, 255, 255, 255, 255, 255, 255,  63, 255, 255,
    255, 255, 255,   3,   0,   0,   0,   0,   0,   0,   0, 160,   0, 252, 127,  95,
    219, 127,   0,   0,   0,   0,   0,   0,   0,   0,   0,  20,   0,   8,   0,   0,
      0,   0,   0,   0,   0, 192,   0,   0,   0,  24,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  88,   0,   0,   0,   0,   0,   0,   0,  12,
      0,   0,   0, 192,  31,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 248,
      1,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,  63,   0,   0,   0,   0,
};

/* NFD_Quick_Check: 996 bytes. */

RE_UINT32 re_get_nfd_quick_check(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 14;
    code = ch ^ (f << 14);
    pos = (RE_UINT32)re_nfd_quick_check_stage_1[f] << 4;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_nfd_quick_check_stage_2[pos + f] << 4;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_nfd_quick_check_stage_3[pos + f] << 6;
    pos += code;
    value = (re_nfd_quick_check_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* NFC_Quick_Check. */

static RE_UINT8 re_nfc_quick_check_stage_1[] = {
    0, 1, 2, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5,
    4, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
};

static RE_UINT8 re_nfc_quick_check_stage_2[] = {
     0,  0,  0,  0,  0,  0,  1,  2,  0,  0,  0,  0,  3,  0,  0,  0,
     0,  0,  4,  5,  6,  0,  7,  8,  9, 10,  8, 11,  0,  0, 12, 13,
    14,  0, 15, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  0,  0,  0,  0, 18, 19,
    20,  0, 21,  0,  0,  0, 22,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 23,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 25, 25, 26, 27, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0, 29, 30,  0,  0,  0,  8,  0,  0, 31,  0, 32,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 33, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    25, 25, 25, 25, 35,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_nfc_quick_check_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     1,  2,  3,  4,  5,  6,  7,  8,  9,  0,  0,  0,  0,  0, 10, 11,
    12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 14,  0,  0,  0, 15,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 16,  0,  0, 17, 18,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 19,  0,  0,  0,  0, 20,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 16,  0,  0, 21, 22,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 16,  0,  0, 17,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 23,  0, 24,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 25,  0, 17,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 26, 27, 28, 10,  0, 29, 30, 31,
    29,  0, 26, 27, 28, 10,  0, 29,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32, 33, 34,  0,
     0,  0,  0,  0,  0, 33, 33, 33, 35,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 36,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 37, 38,
     0,  0,  0,  0,  0,  0,  0, 19,  0, 39, 26, 26, 26, 40,  0, 38,
    41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 11, 42,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 43,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  0,
     0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 45, 46, 47, 48, 49, 15, 15, 15, 15, 15, 15, 15, 45, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 41,  0,  0,  0,  0,
     0,  0,  0, 50,  0, 49, 47, 51, 52, 47,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 23,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  8, 53,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 54, 55,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 56, 31,  0,  0,  0,  0,  0,  0,  0,
    15, 15, 15, 45,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

static RE_UINT8 re_nfc_quick_check_stage_4[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 2, 2,
    2, 2, 2, 2, 2, 0, 0, 2, 0, 2, 0, 2, 2, 0, 0, 0,
    0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2,
    2, 0, 0, 0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 2, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 2, 2, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0,
    0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2,
    0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 2,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
    0, 2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0,
    1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 2, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 1, 1, 1, 1, 1,
};

/* NFC_Quick_Check: 1592 bytes. */

RE_UINT32 re_get_nfc_quick_check(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_nfc_quick_check_stage_1[f] << 5;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_nfc_quick_check_stage_2[pos + f] << 4;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_nfc_quick_check_stage_3[pos + f] << 3;
    value = re_nfc_quick_check_stage_4[pos + code];

    return value;
}

/* NFKD_Quick_Check. */

static RE_UINT8 re_nfkd_quick_check_stage_1[] = {
    0, 1, 2, 2, 2, 3, 4, 5, 6, 2, 2, 2, 2, 2, 7, 8,
    2, 2, 2, 2, 2, 2, 2, 9, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_nfkd_quick_check_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  7,  8,  9, 10, 11, 12, 13, 14,
    15,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 16,  7, 17, 18, 19,
    20, 21, 22, 23, 24,  7,  7,  7,  7,  7, 25,  7, 26, 27, 28, 29,
    30, 31, 32, 33,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7, 34, 35,  7,  7,  7, 36, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 33, 37,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7, 33, 38, 39, 33, 40, 41, 42,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    43, 44,  7, 45, 46, 47,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7, 48,  7,  7, 49, 50, 51, 52,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 53,  7,
     7, 54, 55,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7, 33, 33, 56,  7,  7,  7,  7,  7,
};

static RE_UINT8 re_nfkd_quick_check_stage_3[] = {
      0,   0,   0,   0,   0,   1,   2,   3,   4,   5,   6,   7,   0,   8,   9,  10,
     11,  12,   0,   0,   0,  13,  14,  15,   0,   0,  16,  17,  18,  19,  20,  21,
     22,  23,  24,  25,   0,   0,  26,  27,   0,   0,   0,   0,  28,   0,   0,   0,
      0,  29,   0,  30,   0,   0,  31,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,  32,  33,   0,   0,   0,  34,   0,   0,  35,  36,   0,   0,   0,   0,   0,
      0,   0,  37,   0,  38,   0,  39,   0,   0,   0,  40,   0,   0,   0,  41,   0,
      0,   0,  39,   0,   0,   0,  42,   0,   0,  43,   0,   0,   0,  43,  44,   0,
     45,   0,  46,  47,  48,  49,   0,   0,   0,  50,   0,   0,   0,   0,   0,  51,
     52,  53,  54,   0,   0,   0,   0,   0,   0,  55,  56,  57,  58,  59,   0,   0,
     59,  59,  59,  59,  60,  59,  59,  61,  62,  59,  63,  64,  59,  65,  66,  67,
     68,  69,  70,  71,  72,  40,   0,   0,  73,  74,  75,  59,  76,  77,  78,   0,
     79,  80,  81,  82,  83,  84,   0,  85,   0,  86,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  59,  59,  59,  59,  87,  45,   0,   0,  88,   0,   0,  51,   0,
      0,   0,   0,  44,   0,   0,   0,   0,   0,   0,   0,  89,   0,   0,   0,   0,
      0,   0,   0,   0,  90,   0,   0,  43,  59,  59,  59,  59,  59,  59,  91,   0,
     92,  93,  94,  95,  96,  94,  95,  97,   0,  98,  59,  59,  99,   0,   0,   0,
    100,  59, 101, 100,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,
      0,   0,   0,   0,  44,   0,   0,   0,   0,   0,   0, 102,   0,   0,   0, 103,
      0,   0, 104,   0,   0,   0,   0,   0,  59,  59,  59,  59,  59, 105,   0,   0,
    106, 107,  59, 108,  59,  59,  61,   0, 109, 110, 111,  59,  59, 112, 113,  59,
     59,  64, 114,  59,   4,  59, 115, 116, 117, 114, 118, 119,  59,  59,  59, 120,
    121,  59,  59,  59,  59, 100, 122, 123,   0,   0,   0,   0, 124, 125,   0,   0,
      0, 126,   0,   0,   0,   0,   0,   0,   0,   0, 127,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 128,   0,   0,   0,   0,   0,   0,   0, 129,   0,   0,
      0,   0, 130,  15,   0,  58,  92,   0,  59,  59,  65,  59, 131, 132, 133,  59,
    134, 135, 136,  59,  59,  59,  59,  59,  59,  59,  59,  59,  59,   7,  59,  59,
     59,  59,  59,  59,  59,  59, 137,  59, 133, 138, 139, 140, 141, 142,   0,   0,
    143, 144, 145,  39, 102,   0,   0,   0, 146,  60, 147,   0,   0,   0,   0,   0,
     64,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_nfkd_quick_check_stage_4[] = {
      0,   0,   0,   0,   1, 133,  60, 119, 191, 255, 126,  62, 191, 255, 126, 190,
    255, 255, 252, 255,  63, 255, 253, 254, 249, 243, 243, 255,  63, 255, 255, 255,
      3, 128,   1,   0, 240, 255, 255, 223, 207, 255,  63, 255, 255, 255, 255, 207,
    192, 255,  15,   0,   0,   0, 255,   1,   0,   0,   0,  63,  31,   0,   0,   0,
     27,   0,   0,   0,   0,   0,  16,  68, 240, 215,   1,   0,   0, 252,   1,   0,
      0, 124, 127,   0,   0,   0,  55,   2, 139, 112,   0,   2,   0,   0,   0,   2,
      0,   0, 139, 112,   0,   0, 192,   0,   6,   0, 207, 252, 252, 252,  63,   3,
    128,   0,   0,   0, 124,   0,   0,   0,   0,   0, 224,   1,   5,   0,   8,   0,
      0,   2,  18,   0,   0,   0,   0, 255,   0,  24,   0, 176,   0,   0,  72,   0,
      0,   0,   0,  78,   0,  25,   0,  48,   0,   0,  16,   0,   0,  28,   0,   0,
      0,   1,   0,   0, 129,  13,   0,   0,   0,   0,   0, 116,   0,   0,   8,   0,
      0,   0,   0,  48,   0,  16,   0,   0,   8,  32, 132,  16,   0,   2, 232,   3,
      2,   0,   8,  32, 132,  16,   0,   2,  64,   0,   0,   0,   0,   0,   0,  16,
     64,  85,   4,   0,   0,   0,   0,  40,  11,   0,   0,   0,   0, 112, 255, 247,
    255, 191, 255, 255, 255,   7,   0,   1,   0,   0,   0, 248, 255, 255, 255, 255,
    255, 255, 255,  15, 255, 255, 255,   3, 255, 255,  63,  63,  63,  63, 255, 170,
    255, 255, 255,  63, 255, 255, 223, 255, 223, 255, 207, 239, 255, 255, 220, 127,
    255,   7, 130,   0, 112, 128, 216,  80, 128,   3, 128, 128,   0,   0, 243, 255,
    255, 127, 255,  31, 239, 254, 111,  62,  87, 189, 251, 251, 225,   3, 255, 255,
      0,   2,   0,  12,   0,  64,   0,   0,   0, 224,   0,   0,  16,  18,   0,   0,
     80, 176,   1,   0, 146,   2,   0,   0,   5, 224,  51,   3,  51,   3,   0,   0,
      0, 240,   0,   0,  15,  60,   0,   0,   0,   6,   0,   0, 255,   7,   0,   0,
      0,   0, 112,   0,   0, 128,   0,   0,   0,   0,   0, 128, 255, 255,  63,   0,
      1,   0,   0,   0,   0,   0,  64,   7,   0,  80,  85,  85, 165,   2, 219,  54,
      0,   0,  16, 216,   0,   0, 144, 199,   0,   0, 254, 255, 255, 127, 252, 255,
    255, 255, 255, 127, 255,   0, 255, 255,   0,   0,   1,   0,   0,   0,   0,   3,
      0,   0,   0, 240,  15,   0,   0,   0, 255,  63, 229, 127, 101, 252, 255, 255,
    255,  63, 255, 255, 127,   0, 248, 160, 255, 255, 127,  95, 219, 255, 255, 255,
    255, 255,   3,   0,   0,   0, 248, 255,   0,   0, 255, 255, 255,   0,   0,   0,
      0,   0, 255,  31,   0,   0, 255,   3, 159, 255, 247, 255, 127,  15, 215, 255,
    255, 255, 255,  31, 254, 255, 255, 255, 252, 252, 252,  28, 127, 127,   0,   0,
      0,   0,   0,  20,   0,   8,   0,   0,   0, 192,   0,   0,   0,  24,   0,   0,
      0,   0,   0,  88,   0,   0,   0,  12,   0,   0,   0, 192, 255, 255, 255, 223,
    100, 222, 255, 235, 239, 255, 255, 255, 191, 231, 223, 223, 255, 255, 255, 123,
     95, 252, 253, 255, 255, 207, 255, 255, 150, 254, 247,  10, 132, 234, 150, 170,
    150, 247, 247,  94, 255, 251, 255,  15, 238, 251, 255,  15, 255,   7, 255, 255,
    255, 127, 255, 255, 255, 255,   0,   0,   7,   0, 255, 255, 255,   1,   3,   0,
};

/* NFKD_Quick_Check: 1504 bytes. */

RE_UINT32 re_get_nfkd_quick_check(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_nfkd_quick_check_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_nfkd_quick_check_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_nfkd_quick_check_stage_3[pos + f] << 5;
    pos += code;
    value = (re_nfkd_quick_check_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* NFKC_Quick_Check. */

static RE_UINT8 re_nfkc_quick_check_stage_1[] = {
     0,  1,  2,  3,  4,  4,  4,  4,  4,  4,  5,  4,  4,  4,  4,  6,
     4,  7,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  8,  9, 10,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4, 11,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
};

static RE_UINT8 re_nfkc_quick_check_stage_2[] = {
      0,   0,   1,   0,   2,   3,   0,   4,   0,   0,   5,   6,   7,   8,   9,  10,
      0,   0,   0,   0,   0,   0,  11,   0,   0,  12,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  13,  14,  15,  16,  17,  18,   0,   0,  15,  19,  15,  20,
      0,  21,   0,  22,  15,  20,   0,  23,  24,   0,  24,  25,  26,  27,  28,   0,
     29,   0,   0,  30,   0,  31,  32,  33,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  34,   0,   0,   0,
      0,   0,   0,   0,  35,  36,  37,   0,   0,   0,  38,   0,   0,  39,  40,  41,
     42,  43,  44,   0,  45,  46,  47,   0,  48,   0,   0,   0,  49,   0,   0,   0,
      0,  50,  51,  52,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  26,  53,   0,  54,   0,   0,   0,   0,
      0,  55,   0,   0,   0,  56,   0,   0,   0,   0,  57,  24,  51,  51,  51,  58,
     59,   0,  60,  61,  62,  51,  63,   0,  64,  65,  51,  51,  51,  51,  51,  51,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  25,   0,   0,  66,   0,  67,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  68,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  51,  51,  51,  51,  69,  70,  51,  71,  72,  73,  74,  75,
     51,  51,  51,  51,  76,  77,  78,  79,  80,  81,  51,  82,  83,  51,  84,  85,
      0,   0,  86,   0,  87,   0,   0,   0,   0,   0,   0,   0,  15,  20,   0,   0,
      0,   0,  88,   0,   0,   0,  89,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  90,  91,  92,   0,   0,   0,   0,   0,   0,   0,   0,
     51,  93,  94,  95,  96,  97,  51,  51,  51,  51,  98,  51,  51,  51,  51,  99,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 100, 101, 102,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 103, 104, 105,   0, 106, 107,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     51,  51,  51,  51,  51,  51,  51,  51, 108,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_nfkc_quick_check_stage_3[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,
     0,  0,  0,  0,  0,  0,  5,  6,  1,  7,  0,  0,  0,  0,  0,  6,
     8,  9,  0,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0, 11,  1,
     0,  0,  0, 12,  9,  0,  0,  0, 13, 14, 15, 16, 17, 18, 19, 20,
    21,  0,  0,  0,  0,  0, 22, 23, 24,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 25,  0,  0,  0, 26,  7,  6,  0,  0,  0,  0,  0,  0,  0,
     0,  0, 27,  0,  0,  0, 28,  1,  0,  0,  0,  0,  0,  0,  0, 29,
     0,  0,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30,
     0,  0, 31, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 32,  0,
     0,  0,  0, 33,  0,  0,  0,  0,  0,  0, 34, 35,  0,  0,  0,  0,
     0,  0, 31,  0,  0,  0,  0,  0,  0,  0, 30,  0,  0,  0,  0,  0,
    36,  0, 37,  0,  0,  0,  0,  0,  0, 38,  0, 31,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 39,  0,  0,  0,  0, 35,  0,  0,  0,  0,
     0, 22,  0,  0,  0,  0,  0,  0, 39, 40, 41, 22,  0,  7, 42, 43,
     7,  0, 39, 40, 41, 22,  0,  7,  0,  0,  0,  0,  0, 30,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 22,  0,  0,  0,  0, 44, 45, 46,  0,
     0,  0,  0,  0,  0, 45, 45, 45, 47,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0, 49, 11, 50,
    11, 51, 11, 11, 11, 52,  0,  1,  0,  0,  0, 53, 11, 11, 11, 11,
     0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 54, 55,
     0,  0,  0,  0,  0,  0,  0, 42, 43, 56, 39, 42, 39, 42,  0, 57,
    11, 52, 58,  0, 49,  6, 59, 60,  6, 43,  6,  6,  0,  0, 61, 11,
    11, 25, 11,  9,  0,  1,  0,  0, 62, 63, 64, 65, 66, 67, 68, 68,
    69, 43, 11, 11, 11, 11, 11, 11,  0,  7,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0, 24,  1,  0,  0,  0,  0,  0,  0, 70,  0,  0,
     0,  0,  0,  0, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 52,  0,  0,  0,  0,  0,  0,  0,  0, 49,  0,
     0,  0,  0, 22,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 35,
     0,  0,  0,  0,  0,  6,  0,  0,  0,  0,  0,  6,  0,  0,  0,  0,
    11, 11, 12,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0, 71, 52,
     0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,
     0,  0,  0,  0,  0,  0, 63, 11, 11, 25, 73, 11,  0,  0,  0,  0,
    11, 11, 11, 25, 11, 11, 11, 11, 11,  0, 11, 11, 11, 11, 11, 25,
     0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0, 43,
     0,  0,  0,  8,  0,  0,  0,  0, 11, 12, 74, 25, 75, 73, 11, 11,
    11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 43,  0,  0,  0,  0,
    25,  0, 53, 76, 11, 11, 25, 77, 78, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 43,  0,  0,  0, 53, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 12,  0,  0, 11, 11, 11, 11, 11, 11,
    11, 11, 73, 11, 11, 11, 11, 11, 11,  0,  0,  0,  0,  0, 11,  9,
     0,  0, 11, 43,  0,  0, 11, 11, 79, 11, 50, 11, 25, 80, 81, 11,
    11, 11, 11, 11, 11, 11, 11,  9, 63, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 25, 73, 73, 73, 82, 25, 25,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 36,  0,  0,  0,  0, 31,  0,  0,  0,
     0,  0,  0,  0,  0,  0, 20, 83,  0,  0,  0,  0,  0, 31,  0,  0,
     0,  0,  0, 84,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 53,
     1,  0,  0,  0,  0,  0,  0,  0, 11, 11, 85, 11, 11, 11, 11, 11,
    11, 11, 11, 85, 86, 87, 11, 88, 62, 11, 11, 11, 11, 11, 11, 11,
    51, 89, 85, 85, 11, 11, 11, 90, 77, 73, 91, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 12, 11, 11, 11, 11, 92, 11, 11, 11, 11, 11, 11,
    62, 11, 11, 11, 93, 63, 50, 94, 41, 56, 93, 54, 93, 50, 50, 95,
    11, 68, 11, 80, 96, 68, 11, 80, 11, 52, 11, 11, 11, 25, 11, 11,
    11, 11,  0,  0,  0, 82,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,
    52,  0, 11, 11, 11, 11, 11, 80, 11,  1, 43,  0,  0,  0,  0,  0,
    11, 11, 11, 12,  0,  0,  0,  0,
};

static RE_UINT8 re_nfkc_quick_check_stage_4[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
    0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0, 2, 2, 2, 2, 2, 0, 2, 2,
    2, 2, 2, 2, 2, 0, 0, 2, 0, 2, 0, 2, 2, 0, 0, 0,
    0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2,
    2, 0, 0, 0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 2, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0,
    0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 1, 1, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0,
    0, 0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1,
    0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0,
    1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0,
    0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0,
    0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1,
    0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1,
    1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1,
    0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
    0, 2, 2, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1,
    1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1,
    0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1,
    0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1,
    1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1,
    0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0,
    0, 1, 1, 1, 0, 1, 1, 1,
};

/* NFKC_Quick_Check: 2688 bytes. */

RE_UINT32 re_get_nfkc_quick_check(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_nfkc_quick_check_stage_1[f] << 6;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_nfkc_quick_check_stage_2[pos + f] << 3;
    f = code >> 3;
    code ^= f << 3;
    pos = (RE_UINT32)re_nfkc_quick_check_stage_3[pos + f] << 3;
    value = re_nfkc_quick_check_stage_4[pos + code];

    return value;
}

/* Alphanumeric. */

static RE_UINT8 re_alphanumeric_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20, 21,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 22, 23, 24,  5, 25, 26,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_alphanumeric_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  32,  31,  31,  31,  31,  31,  31,  31,  33,  34,  35,  31,
     36,  37,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  38,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  39,
      1,   1,   1,   1,  40,   1,  41,  42,  43,  44,  45,  46,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  47,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  48,  49,   1,  50,  51,  52,
     53,  54,  55,  56,  57,  58,   1,  59,  60,  61,  62,  63,  64,  65,  31,  66,
     67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  31,  78,  79,  80,  31,
      1,   1,   1,  81,  82,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  84,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  85,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  86,  87,  31,  31,  88,  89,
      1,   1,   1,   1,   1,   1,   1,  90,   1,   1,  91,  31,  31,  31,  31,  31,
      1,  92,  93,  31,  31,  31,  31,  31,  31,  31,  31,  31,  94,  31,  31,  31,
     31,  31,  31,  31,  95,  96,  97,  98,  31,  31,  31,  31,  31,  31,  31,  31,
     99, 100, 101,  31,  31,  31,  31,  31, 102, 103,  31,  31,  31,  31, 104,  31,
     31, 105,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,   1,   1, 106,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 107, 108,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 109,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 110,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 111,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_alphanumeric_stage_3[] = {
      0,   0,   0,   1,   2,   3,   2,   3,   0,   0,   4,   5,   6,   7,   6,   7,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   8,   9,  10,   0,
      0,   0,   0,   0,  11,   0,   0,  12,  13,   6,  14,   6,   6,   6,   6,  15,
      6,   6,   6,   6,   6,   6,   6,   6,  16,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   2,   6,  17,   6,   6,  18,   0,   0,  19,  20,   6,  21,  22,
      0,   3,   6,   6,   6,  23,  24,   6,   6,   6,   6,   6,   6,  25,  26,  27,
      0,   6,   6,   6,  28,   6,   6,   6,   6,   6,   6,   9,   6,   6,   3,  29,
      6,  30,  31,   0,   6,  18,   3,   0,   0,   0,   6,  32,   0,  33,  34,   6,
      6,   6,   6,  35,  36,  37,  38,   2,  39,  40,  41,  42,  43,  44,  38,  45,
     46,  40,  41,  47,  48,  49,  50,  51,  52,  14,  41,  53,  54,  55,  38,  56,
     57,  40,  41,  53,  58,  59,  38,  60,  61,  62,  63,  24,  64,  65,  50,   0,
     66,  67,  41,  68,  69,  70,  38,   0,  66,  67,  41,  71,  69,  72,  38,  73,
     66,  67,   6,  74,  75,  76,  38,  77,  78,  79,   6,  80,  81,  82,  50,  83,
      2,   6,   6,   3,  84,   1,   0,   0,  85,   6,  86,  87,  88,  89,   0,   0,
     55,   0,   1,   0,  23,   6,  31,   2,  90,  23,   6,  31,   0,   0,   0,   0,
      6,   6,   6,  91,   1,   6,   6,   6,   6,  92,   6,   6,  93,   6,   6,  94,
      6,   6,   6,   6,  95,  96,   6,   6,  95,   6,   6,  97,  98,   7,   6,   6,
      6,  98,   6,   6,   6,   3,   0,   0,   6,   0,   6,   6,   6,   6,   6,  99,
      2,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,  27,   6,   2,   3,   6,   6,   6,   6, 100,  18,
     36, 101,   6, 101,   6, 101,  36, 102,   6,   6,   6,  38,  18, 103,   1,   0,
      0,   1,   6,   6,   6,   6,   6,  18,   6,   6,   3,   6,   6,   6,   6,  51,
      6, 104, 105,  18,  50,   6,  92, 106,   6,   6, 105,   6,   1,   1,   0,   0,
      6, 105,   6,   6,   6, 104,   2, 106,   1,   1, 107,   0,   0,   0,   0,   0,
      6,   6,   6, 108, 109,   1,   0,   0,   6,   6,  89,   6,   6,   6,  15,   9,
      6,   6,   6, 110,  68,   6,   6,  92,  18,   6,   6,  74,   0,   0, 111, 112,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   0,   0, 113, 106,
      6,  99,   6,   6,  99, 114,   6,  92,   6,   6,   6, 115, 116, 117,  31, 116,
      0,   0,   0,   0,   0,   0,   0, 118,   0,  31,   0,   0,   0,   0,   0,   0,
    119, 120, 121,  89, 122,   0,   6,   6,  18,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  50,   6,   6,   1,   0,
      6,   6, 104,   6,   6, 104,   6,   6,   6,   6,   6,   6,   6,   6, 123,  83,
      6,   6,  93,   6,   6,   6, 124,   0,   6, 110, 125, 125, 125, 125,   6,   6,
      0,   0, 126,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    127,   0, 128, 129,   2,   6,   6,   6,   6, 130,   2,   6,   6,   6,   6,  94,
    131,   6,   6,   2,   6,   6,   6,   6, 104,   0,   6,   3,   0,   0,   0,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  51,   0,   0,   0,   0,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   0,
      6,   6,   6,   6,   6,   6,   6,   6,  31,   0,   0,   0,   0,   6,   6,  92,
     31,   6, 105,   0,   6,   6, 104, 132,   6,   6,   6,   6,   6,   6,   6,   0,
      0, 113, 133,   6,   6,   6,   6,   6, 134,   6,   6,   6, 135,   0,   0, 113,
     15,   6, 136,   0,   6,   6,   6, 101,   6,   6,   6,   6, 137,   1,   0, 138,
      6,   6,   3,   6,   6,  22,   6,  31,   6,   6,   6, 139, 126,   1,   6, 104,
      6,   6,   6, 110,  92,   1,   6,  79,   6,   6,   6, 104, 140, 141,   6, 142,
    143, 144, 125,   6,   6,  94, 136,   6,   6,   6,   6,   6,   6,   6,   3,   1,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 101,   6, 145,   6,   6, 105,
      6,   6,   6,   6,   6,   6,  92,   6,   6,   6,   6,   6,   6,   1,   0,   0,
    110, 146,  41, 147, 148,   6,   6,   6,   6,   6,   6,   9,   0, 149,   6,   6,
      6,   6,   6,  92,   0,   6,   6,   6,   6, 133,   6,   6, 136,   0,   0, 105,
      0,   0,   0,   0,   0,   0,   0, 150,   6,   6,   6,   6,   6,   6,   6,  31,
      0,   1,   2,   3,   2,   3,  50,   6,   6,   6,   6, 104, 151, 152,   0,   0,
     35,   6,   7, 153,  92,  92,   0,   0,   6,   6,   6,   6,   6,   6,   6,   3,
      0,   0,   0,   0,   6,   6,   6, 106,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   6,  31,   6,   6,   6,  55,   0,   0,
      6,   6,  28,   6,   3,   6,   6,   3,   6,  92,   6,   6, 154, 155,   0,   0,
      6,   6,   6,   6,   6,   6,   6,   6,   6,  92,   1,   6,   6, 154,   6, 105,
      6,   6, 136,   6,   6,   6, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6,   6, 110,   6,  51, 136,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    156,   6,   6, 157,   6,  51,   6, 110,   6, 104,   0,   0,   0,   0,   6, 158,
      6,  51,   6,   1,   0,   0,   0,   0,   6,   6,   6, 159,   0,   0,   0,   0,
    160, 161,   6,  51,   0,   0,   6,  31,   6,  31,   0,   0,  23,   6, 106,   0,
      6,   6,   6,  51,   6,  51,   6,  22,   6,   9,   0,   0,   0,   0,   0,   0,
      6,   6,   6,   6,  18,   0,   0,   0,   6,   6,   6,  22,   6,   6,   6,  22,
      6,   6, 136,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,  31, 107,   6,  51,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6, 110,
      6,   6,   6,   6,  51,   0,  50,   0, 133,   6,   6,  18,   0,   6,  18,   1,
      6,   6,   6, 162, 163,   6,   6, 164,   6,   6,   6,   6, 165, 166,   0,   0,
      6,  14,   6, 167,   0,   0,   0,   0, 168,  19,  18,   6,   6,   6,  18,   1,
     39,  40,  41,  53,  58, 169, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6,   6,   6, 170, 171,   0,   0,   6,   6,   6,   6, 172,   1,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   6,   6,   6, 173,   0, 174,   0,   0,
      6,   6,   6, 104, 175,   1,   0,   0,   6,   6,   6, 176,   1,   0,   0,   0,
      6,  74,   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6,   6,  18,   0,   0,   0,   0,   0,   0,   6,   6,   6,   6,   1, 126,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  30,   6,   6,  30, 177,   0,
      6,   6,   6, 178,   0,   6,   6,   6,   6, 179,   0,   0,   6,   6,   6,  18,
     41,   6,   6, 125,  55,   1,   0, 133,   6, 133,  23, 110,   0,   0,   0,   0,
    180,   6,   6, 181, 182,   1, 183,   6, 104, 184,   1,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6, 110,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   1,   0,   0,   0,   0,   0,   0,
      6,   6,   6,   6,   6,   6, 104,   0,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6, 104,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6,   6,   6, 110,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6,   6,  18,   6, 104,   1,   0,   0,   0,   0,   0,   0,   6,  92,   0,
      6,   6,   6,   0, 101,   1, 149, 185,   6,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   6,   6,   6,   6,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6,   6,   6,  21,   6,   6,   6, 124,   6,   0,   0,   0,   0, 186,   0,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 136,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  22,
      6, 104,   0,   0,   0,  22, 187,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 105,
      6,   6,   6,   6,   6,   6,   3,  31,  18, 188,   0,   0,   0,   0,   0,   0,
      6,   6,   6,   6,   6, 150,   6,   6,   6,  36, 189, 190, 108,   6,   6,   6,
    191, 192,   6, 193, 194,  67,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 195,   6,  67,  94,   6,  94,
      6, 150,   6, 150, 104,   6, 104,   6,  41,   6,  41,   6, 196,   6,   6,   6,
      7, 134, 197,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      6,   6,  31, 198, 188,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   6, 105,   1,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 106,   0,   0,   0,
      6,   6,   6,   6, 199,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    108,   6, 200, 201, 202, 203, 204, 205, 206, 105, 207, 105,   0,   0,   0,   0,
      0,   0,   0,   6,   1,   6,   1,   6,   1,   0,   0,   0,   0,   0,   0,   0,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6, 110,   0,   0,
      6,   6,   6, 106,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,  92,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   9,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,  55,   0,
      6,  92,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_alphanumeric_stage_4[] = {
      0,   0, 255,   3, 254, 255, 255,   7,   0,   4,  32,   4, 255, 255, 127, 255,
    195, 255,   3,   0,  31,  80,  32,   0, 223, 188,  64, 215, 251, 255, 191, 255,
      3, 252, 127,   2, 255,   1, 255, 191, 182,   0, 255, 135,   7,   0, 255, 254,
    255, 195, 239,  31, 254, 225, 255, 159,   0, 224,  48,   4, 255, 252, 255,  31,
    223,  63, 240, 255, 248,   3, 255, 239, 255, 223, 225, 255, 207, 255, 239, 159,
    249, 255, 255, 253, 197, 227, 159,  89, 128, 176,   3,  16, 238, 135, 109, 195,
    135,  25,   2,  94, 192, 255,  63,   0, 238, 191, 237, 227, 191,  27,   1,   0,
      0,  30, 238, 159, 159,  25, 192, 176,   2,   0, 236, 199,  61, 214,  24, 199,
    199,  29, 129,   0, 239, 223, 253, 255, 255, 227, 223,  29,  96,   7, 239, 227,
     96,  64,   6,   0, 255, 231, 223,  93, 240, 128,   0, 252, 236, 255, 127, 252,
    251,  47, 127, 128,  95, 255,  12,   0, 127,  32, 214, 247, 175, 255, 255,  59,
     95,  32, 255, 243,   3, 255, 127, 249, 255,  63, 191,  32, 255, 247, 255,  61,
    127,  61,  61, 127,  61, 255,  63,  63, 255, 199,  15,   0,  13,   0, 128,  16,
    255, 127, 255,  15,  31,   0, 128,   0, 239, 255, 239,  15, 127,   0,   0, 222,
    111,   4, 128, 255, 255, 170, 223,  95, 220,  31, 207,  15,   2, 128, 132, 252,
     47,  62,  80, 189, 224,  67,  31, 120, 255, 128, 127, 127,   0, 128, 224,   0,
    254,   3,  62,  31, 127, 224, 224, 255, 240, 143, 252, 255, 255, 249, 124,   0,
    255,   0,  47,   0, 252, 232, 247, 255,   5,   0,   0,  56,  60,   0, 126, 126,
    126,   0, 127, 248, 248, 224, 127,  95, 219, 255, 248, 255, 223, 255, 252, 252,
    252,  28, 255, 183,  15, 255,  62,   0,  63, 253, 191, 145,  55,   0, 255, 192,
    111, 240, 239, 254, 199, 255, 112,   0,  71,   0,  30,   0, 255,  23, 159,  64,
    127, 189, 129, 224, 187,   7, 255, 131, 179,   0,  63, 127,   0,  63,  17,   0,
     63,   1,  26,   0, 231, 127, 255,  32, 127, 251, 127, 180, 203,   0, 191, 253,
    123,   1, 255, 224,  11,   0, 240,   0, 255,  67, 100, 222, 255, 235, 191, 231,
    223, 223, 255, 123,  95, 252,  63, 255, 247, 207, 219,   7, 128,  63, 143,   8,
    150, 254, 247,  10, 132, 234, 150, 170, 150, 247, 247,  94, 255, 251, 238, 251,
};

/* Alphanumeric: 2912 bytes. */

RE_UINT32 re_get_alphanumeric(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_alphanumeric_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_alphanumeric_stage_2[pos + f] << 4;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_alphanumeric_stage_3[pos + f] << 4;
    pos += code;
    value = (re_alphanumeric_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Any. */

RE_UINT32 re_get_any(RE_UINT32 ch) {
    return 1;
}

/* Blank. */

static RE_UINT8 re_blank_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_blank_stage_2[] = {
    0, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 4, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_blank_stage_3[] = {
    0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 3, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2,
    3, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_blank_stage_4[] = {
      0,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    255,   7,   0,   0,   0, 128,   0,   0,   0,   0,   0, 128,   0,   0,   0,   0,
};

/* Blank: 218 bytes. */

RE_UINT32 re_get_blank(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_blank_stage_1[f] << 5;
    f = code >> 10;
    code ^= f << 10;
    pos = (RE_UINT32)re_blank_stage_2[pos + f] << 3;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_blank_stage_3[pos + f] << 7;
    pos += code;
    value = (re_blank_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Graph. */

static RE_UINT8 re_graph_stage_1[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  7,  8,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  9, 10, 11,  7,  7,  7,  7, 12, 13,  7,  7,  7, 14,
    15, 16, 17, 18, 19, 13, 20, 13, 21, 13, 13, 13, 13, 22,  7,  7,
    23, 24, 13, 13, 13, 13, 25, 26, 13, 13, 27, 28, 29, 30, 31, 32,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 33,  7, 34, 35,  7, 36,  7,  7,  7, 37, 13, 38,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    39, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 40,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 40,
};

static RE_UINT8 re_graph_stage_2[] = {
      0,   1,   2,   2,   2,   2,   3,   4,   2,   2,   5,   6,   7,   2,   8,   9,
     10,  11,   2,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
      2,  25,   2,   2,  26,  27,  28,  29,   2,   2,   2,   2,   2,  30,  31,  32,
     33,  34,  35,  36,  37,  38,  39,  40,  41,  42,   2,  43,   2,   2,  44,  45,
     46,  47,   2,  48,   2,   2,   2,   2,  49,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,  50,  51,  52,  53,  54,  55,  56,  57,   2,  58,
     59,  60,  61,  62,  63,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  64,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  65,
      2,   2,   2,   2,   2,   2,   2,   2,   2,  66,   2,   2,  67,  68,   2,  69,
     70,  71,  72,  73,  74,  75,  76,  77,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  78,
     79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
      2,   2,   2,   2,  80,  81,  82,  83,   2,   2,  84,  85,  86,  87,  88,  89,
     90,  91,  92,  93,  79,  94,  95,  96,   2,  97,  98,  79,   2,   2,  99,  79,
    100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,  79, 111,  79, 112, 113,
    114, 115, 116, 117, 118, 119, 120,  79, 121, 122,  79, 123, 124, 125, 126,  79,
    127, 128,  79, 129, 130, 131,  79,  79, 132, 133, 134, 135,  79, 136,  79, 137,
      2,   2,   2,   2,   2,   2,   2, 138, 139,   2, 140,  79,  79,  79,  79,  79,
      2,   2,   2,   2,   2,   2,   2,   2, 141,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79,   2,   2,   2,   2, 142,  79,  79,  79,
      2,   2,   2,   2, 143, 144, 145, 146,  79,  79,  79,  79, 147, 148, 149, 150,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  68,
      2,   2,   2,   2,   2, 151,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
      2,   2, 152,   2,   2, 153,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
     79,  79,  79,  79,  79,  79,  79,  79, 154, 155,  79,  79,  79,  79,  79,  79,
      2, 156, 157, 158, 159, 160, 161,  79, 162, 163, 164,   2,   2, 165,   2, 166,
      2,   2,   2,   2,   2, 167,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
    168,  79, 169,  79,  79, 170,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
      2, 171, 172,  79,  79,  79,  79,  79, 173, 174, 175,  79, 176, 177,  79,  79,
    178, 179, 180, 181, 182,  79,   2,   2,   2,   2,   2,   2,   2, 183, 184, 185,
    186, 187, 188, 189, 190, 191,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, 192,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, 193,   2,
    194,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, 195,   2,   2,
      2,   2,   2,   2,   2,   2,   2, 196,  79,  79,  79,  79,  79,  79,  79,  79,
      2,   2,   2,   2, 197,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
    198,  79,   2,  65,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,  79,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, 199,
};

static RE_UINT8 re_graph_stage_3[] = {
      0,   0,   1,   2,   2,   2,   2,   3,   0,   0,   1,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   4,
      5,   2,   6,   2,   2,   2,   2,   2,   2,   2,   2,   1,   2,   7,   2,   2,
      8,   1,   2,   2,   9,   2,  10,  11,   2,  12,   2,   2,   2,   2,   2,   2,
     13,   2,   2,   2,   8,   2,   2,   2,   2,   2,   2,  14,   2,   2,   2,   8,
      2,   2,  15,   3,   2,  16,  17,   0,   0,   0,   2,  18,   0,  19,   2,   2,
     20,  21,  22,  23,  24,  25,  26,   3,  27,  21,  22,  28,  29,  30,  31,  32,
     33,   6,  22,  34,  35,  36,  26,  37,  38,  21,  22,  34,  39,  40,  26,   9,
     41,  42,  43,  44,  45,  46,  31,  17,  12,  47,  22,  48,  49,  50,  26,  51,
     12,  47,  22,  52,  49,  53,  26,  54,  55,  47,   2,   2,  56,  57,  26,   2,
     58,  59,   2,  60,  61,  62,  31,  63,   1,   2,   2,  10,   2,  64,   0,   0,
     65,   2,  66,  15,  67,  68,   0,   0,   2,   2,   2,   2,  69,   2,  70,   1,
      2,  69,   2,  12,  12,  17,   0,   0,   2,   2,   2,   2,  71,   2,   2,   2,
      2,   2,   2,   2,  72,  73,   2,   2,  72,   2,   2,  74,  75,  76,   2,   2,
      2,  75,   2,   2,   2,   8,   2,  70,   2,  77,   2,   2,   2,   2,   2,  78,
      1,  70,   2,   2,   2,   2,   2,  79,  12,  11,   2,  32,   2,  80,  12,  81,
      2,   2,   2,   2,   2,  15,  77,  77,   3,  77,   2,   2,   2,   2,   2,  79,
      2,   2,  17,   2,   2,   2,   2,  82,   2,   3,  64,  64,  83,   2,  15,  11,
      2,   2,  64,   2,  77,  84,   2,   2,   2,  85,   2,   2,   2,   3,   2,  86,
     77,  77,  15,   3,   0,   0,   0,   0,   2,   2,   2,   2,  64,   2,   2,  70,
      2,   2,   2,   2,   2,   2,   2,  87,   2,   2,   2,  88,  48,   2,   2,   2,
     79,   2,   2,   8,   9,   2,   2,  17,   2,   2,   2,   2,   2,   2,   2,  89,
      2,  78,   2,   2,  78,  90,   2,  15,   2,   2,   2,  91,  91,  92,   2,  93,
     94,   2,  95,   2,   2,   3,  91,  96,   3,  70,   2,   2,   0,   2,   2,  36,
     64,   2,   2,   2,   2,   2,   2,   2,   2,   2,  32,   0,  17,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,  26,   2,  97,   2,   2,   2,   2,   2,   2,
      2,   2,   3,   2,   2,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,  98,
      2,   2,  71,   2,   2,   2,  99, 100,   2,  32, 101, 101, 101, 101,   2,   2,
      2,   2,   2,   2,   2,   0,   0,   0,   2,  89,   2,   2,   2,   2,   2,  80,
      2,   2,   2,   2,   2,  82,   0,  64,   1,   2,   2,   2,   1,   2,   2,   2,
      2,   7,   2,   2,   2,   2,   2,   2, 102,   2,   2,   1,   2,   2,   2,   2,
      3,   2,   2,  17,   2,   2,  80,   2,   2,   3,   2,   2,   2,   2,   2,   2,
      2,   2,   2,  82,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,
     70,   2,   2,   2,  32,   2,   2,   2,   2,   2,  64,   0,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   9,   2,   2,   2,   2, 103,   0,   0,  51,
      2,   2,  64,  77,   2,   2,   2,   9,   2,   2,   2,   2, 104,  77,   2,   2,
      2,   2,   2,   2,   2, 105,   2,  70,   2,   2,   2,   2,  13,  44,   2,   3,
      2,   2,   2,  32,  15,  68,   2,   2,   2,   2,   2,   2, 106,  94,   2,  32,
    107, 108, 101,   2,   2,   2,   9,   2,   2,   2,   2,   2,   2,   2,  15,  77,
      2,   2,  80,   2, 109,   2,   2,  64,   0,   0,   0,   0,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   2,  15,   2,   2,   2,   2,   2,   2,  77,   0,   0,
     32, 110,   2, 111, 112,   2,   2,   2,   2,   2,   2,   2,  14,  19,   2,   2,
      2,   2,   2,   2,   0,   2,   2,   2,   2, 113,   2,   2,   9,   0,   0,  15,
      2,  77,   2,   2,   2, 114, 115,  91,   2,   2,   2,   2,   2,   2,   2,  86,
      1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3, 116, 117, 101, 118,
    119,   2,  76, 120,  15,  15,   0,   0,   2,   2,   2,   2,   2,   2,   2,  17,
    121,   2,   2, 122,   2,   2,   2,   2,   3,  64,  36,   0,   0,   2,   2,  15,
      2,  70,   2,   2,   2,  36,   2,  64,   2,   2, 123,   2,  17,   2,   2,  17,
      2,  13,   2,   2, 124,  82,   0,   0,   2,  15,  77,   2,   2, 124,   2,  64,
      2,   2,   9,   2,   2,   2, 105,   0,   2,   2,   2,  32,   2,  82,   9,   0,
    125,   2,   2, 126,   2, 127,   2,   2,   2,   3,  51,   0,   0,   0,   2, 128,
      2, 129,   2, 130,   0,   0,   0,   0,   2,   2,   2, 131,   2, 113,   2,   2,
    132, 133,   2, 134,  79,  79,   2,   2,   2,   2,   0,   0,   2,   2, 109,  32,
      2,   2,   2, 135,   2,  97,   2, 136,   2, 137, 138,   0,   0,   0,   0,   0,
      2,   2,   2,   2,  79,   0,   0,   0,   2,   2,   2, 106,   2,   2,   2, 139,
      2,   2,   9,  77,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   3,
      2,   2,   9,   2,   2,  77,   0,   0,   0,   0,   0,   0,   0,   0,   2,  32,
      2,   2,   2,   2,  15, 113,   2, 140,   2,   2,   2,   2, 141,   2,  79,  77,
      2,   2,   2,  91,  32,   2,   2,  32,   2,   2,   2,   2,  15,   2,   1,  11,
      2,   6,   2,   3,   0,   0,   0,   0, 142,  13,  77,   2,   2,   2,  17,  77,
     20,  21,  22, 143,  39, 144, 145,  11,   2,   2,   2,   2,   2, 146,   0,   0,
      2,   2,   2,   2,   9,  77,   0,   0,   2,   2,   2,  97,   2,  15,   0,   0,
      2,   2,   2,   2,  11,  77,  70,   0,   2,   2,   2,  79,  77,   0,   0,   0,
      2,   8,  64,   2,   0,   0,   0,   0,   2,   2,   2,  64,   0,   0,   0,   0,
      0,   0,   2,   2,   2,   2,   2, 147,   0,   0,   4,   2,   2,   4,  11,   0,
      2,   2,   2,   2,   9,   2,   2,   2,   2,   2, 106,   0,   2,   2,   2,  79,
     22,   2,   2,  76,  82,   2,  70,   2,   2, 113,  69,  32,   0,   0,   0,   0,
    148,   2,   2, 149,   9,  77, 150,   2,   3, 151,  77,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   2,  79,   0,   0,   0,   0,   2,   2,   2, 152,
      2,  77,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   3,  11,
      2,   2,   2,   2,  80,   0,   0,   0,   2,   2,   3,  79,   0,   0,   0,   0,
      2,   2,   2,   2,  32,   0,   0,   0,   2,   2,   2,  79,   2,   3,  44,   0,
      0,   0,   0,   0,   0,   2,  15,  82,   2,   2,   2,   2,  82,  89,   6, 153,
      2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,
      2,  17,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,  10,   2,   2,   2,
     99,   2,   0,   0,   0,   0,  80,   0,   2,   2,   2,   2,   2,   2,   2, 106,
      2,   3,   0,   0,   0, 106, 154,   2,   2,   2,   2,   2,   2,   2,   2,  64,
      2,   2,   2,   2,   2,   2,  17,  70,  79,  68,  80,   0,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   2,   2,  82,   2,   2,   7,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,  79,   0,   2,   2,   2,   2,  82,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   2,  80,   2,   2,   2,   2,   2,  32,   2,  79,
      2,   2,   2,   2,   2,  91,   2,   2,   2,  12, 155, 146, 156,   2,   2,   2,
    157, 158,   2, 159, 160,  47,   2,   2,   2,   2,  97,   2,   2,   2,   2,   2,
      2,   2,   2,   2,  85,   2,   2,   2,  64,  94,   1,   0,   0,   0,   0,   0,
     76, 161, 162,   0,   0,   0,   0,   0,   2,   2,  70,  15,  44,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2, 130,   2,   2,   2,   2, 163,  32,   0,   0,
      2,   2,   2,   2,  64,  44,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
      2,   2,   2,  11,   0,   0,   0,   0,   1,   2,   2,  15,   0,   0,   0,   0,
    156,   2, 164, 165, 166, 167, 168, 169,  89,  64, 170,  64,   0,   0,   0,  14,
      2,   2,  64,   2,   2,   2,   2,   2,   2,  80,   3,   1,   1,   1,   2,  82,
     70,   2,   2,   2,   2,   2,  70,   2,   2,   2,  70,   0,   0,   0,  31,   2,
    106,   2,   2,  64,  79,  14,  82,   0,   2,   2,   2,   2,   2,  82,  70,  17,
      2,   2,   2,   2,   2,   2,   2,  80,   2,   2,   2,   2,   2,  79,  64,   0,
     64,   2,   2,   2,   9,  77,   2,   2,   9,   2,  15,   0,   0,   0,   0,   0,
    119,   2,   2,   2,   2,   2,   2, 171,   2,   2, 172,   2,   8,   2,   2,   2,
      2,   2,   2,   2,   2,  80,  15, 173, 106,  82,   0,   0,   0,   0,   0,   0,
      2,   2,   2,   2,   2,  32,   0,   0,   2,   2,   2,  11,   2,   2,   2,   2,
      2,  15,   2,   2,   2,   2,   2,   2,   2,   2,  14,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,  36,   0,   2,  15,   0,   0,   0,   0,   0,   0,
    174,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  15,
};

static RE_UINT8 re_graph_stage_4[] = {
      0,   0, 254, 255, 255, 255, 255, 127, 255, 252, 240, 215, 251, 255, 127, 254,
    255, 231, 255,   0, 255, 135,  31,   0, 255, 223, 255, 191,   3,   0, 255,  63,
    255,  79, 255,   7, 223,  63, 248, 255, 239, 159, 249, 255, 255, 253, 197, 243,
    159, 121, 128, 176, 207, 255, 238, 135, 109, 211, 135,  57,   2,  94, 192, 255,
    127,   0, 238, 191, 237, 243, 191,  59,   1,   0,   3, 254, 238, 159, 159,  57,
    192, 176, 236, 199,  61, 214,  24, 199, 255, 195, 199,  61, 129,   0, 253, 255,
    255, 227, 223,  61,  96,   7, 128, 255, 239, 243,  96,  64,   6,   0, 239, 223,
    223, 253, 240, 255, 236, 255, 127, 252, 251,  47, 127, 132,  95, 255,  28,   0,
    255,  15, 214, 247, 175, 255,  95,  63, 255, 243, 255, 254, 255,  31, 191,  32,
    255,  61, 127,  61,  61, 127,  61, 255, 127, 255, 255,   3,  63,  63, 255,   1,
     15,   0,  13,   0,  63,   0, 241, 255, 255, 199, 255, 207, 255, 159,  15, 240,
    255, 248, 255, 251, 255, 170, 223, 255, 207, 239, 220, 127,   0, 248, 255, 124,
    243, 255,  63, 255,  15, 254, 255, 128,   1, 128, 127, 127, 224, 255, 124,   0,
     63, 192,  15, 128,   7,   0, 126, 126, 126,   0, 127, 248, 248, 224, 127,  95,
    219, 255, 252, 255, 247, 255, 127,  15, 252, 252, 252,  28,   0,  62, 255, 239,
    255, 183, 135, 255, 143, 255,  15, 224,  15, 255,  63, 253, 191, 145, 191, 255,
     55, 248, 255, 143, 255, 131, 255, 240, 111, 240, 239, 254,  63, 135,  63, 254,
      7, 255,   3,  30,   0, 254,   7, 252,   0, 128,   3,  32, 127, 189, 237, 251,
    129, 224, 207,  31, 255, 235,   7, 128, 127, 251, 127, 180, 191, 253, 251,   1,
      3, 128, 255, 224, 240,   0, 100, 222, 239, 255, 191, 231, 223, 223, 255, 123,
     95, 252, 255, 249, 219,   7, 159, 255, 150, 254, 247,  10, 132, 234, 150, 170,
    150, 247, 247,  94, 238, 251, 123, 252, 231, 199,  15,   7,   2,   0,
};

/* Graph: 3150 bytes. */

RE_UINT32 re_get_graph(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 11;
    code = ch ^ (f << 11);
    pos = (RE_UINT32)re_graph_stage_1[f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_graph_stage_2[pos + f] << 3;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_graph_stage_3[pos + f] << 4;
    pos += code;
    value = (re_graph_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Print. */

static RE_UINT8 re_print_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  5,  9,
    10, 11, 12, 13, 14, 15, 16,  5, 17, 15, 15, 18, 15, 19, 20, 21,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 22, 23, 24,  5, 25, 26,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    27, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 28,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 28,
};

static RE_UINT8 re_print_stage_2[] = {
      0,   1,   1,   2,   1,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,
     14,   1,  15,  16,   1,   1,  17,  18,  19,  20,  21,  22,  23,  24,   1,  25,
     26,  27,   1,   1,  28,   1,   1,   1,   1,   1,   1,  29,  30,  31,  32,  33,
     34,  35,  36,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  37,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  38,
      1,   1,   1,   1,  39,   1,  40,  41,  42,  43,  44,  45,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  46,  47,  47,  47,  47,  47,  47,  47,  47,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  48,  49,   1,  50,  51,  52,
     53,  54,  55,  56,  57,  58,   1,  59,  60,  61,  62,  63,  64,  65,  66,  67,
     68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  47,  79,  80,  81,  82,
      1,   1,   1,  83,  84,  85,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
      1,   1,   1,   1,  86,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,   1,   1,  87,  47,  47,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,  47,  47,  47,  47,   1,   1,  88,  89,  47,  47,  90,  91,
      1,   1,   1,   1,   1,   1,   1,  92,   1,   1,  93,  47,  47,  47,  47,  47,
      1,  94,  95,  47,  47,  47,  47,  47,  47,  47,  47,  47,  96,  47,  47,  47,
     97,  98,  99, 100, 101, 102, 103, 104,   1,   1, 105,  47,  47,  47,  47,  47,
    106, 107, 108,  47,  47,  47,  47,  47, 109, 110,  47,  47, 111, 112, 113,  47,
    114, 115, 116,   1,   1,   1, 117, 118, 119, 120, 121,  47,  47,  47,  47,  47,
      1,   1,   1,   1,   1,   1, 122,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 123, 124,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 125,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 126,  47,  47,  47,  47,
     47,  47,  47,  47,  47,  47,  47,  47,   1,   1, 127,  47,  47,  47,  47,  47,
    128,  38,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 129,
};

static RE_UINT8 re_print_stage_3[] = {
      0,   1,   1,   2,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   3,   4,   5,   1,   1,   1,   6,   7,   1,   8,   1,   9,  10,
     11,   1,   1,   1,   1,   1,   1,   1,  12,   1,  13,   1,   1,  14,   1,  15,
      1,  16,  17,  18,   0,  19,  20,   1,   1,   1,   1,   1,  21,  22,  23,  24,
     25,  26,  27,  28,  29,  30,  31,  32,  33,  30,  34,  35,  36,  37,  38,  39,
     40,  41,  42,  43,  40,  44,  45,  46,  47,   1,  48,  49,  50,  51,  52,  53,
     54,  55,  56,   0,  57,  58,  59,   0,   1,   1,  60,  61,  62,  11,  63,   0,
      1,   1,   1,   1,   1,   1,  64,   1,   1,   1,  65,   1,  66,  67,  68,   1,
     69,   1,  15,  70,  71,   1,   1,  72,   1,   1,   1,   1,  70,   1,   1,  73,
     74,  75,  76,  77,   1,   1,  78,  79,  80,   1,   1,  73,   1,  81,   1,  82,
      2,  83,  84,  85,   1,  86,  87,   1,  88,   1,   2,  89,  79,  16,   0,   0,
      1,   1,  86,  70,   1,   1,   1,  90,   1,  91,  92,   1,  93,  15,   9,  94,
      1,   1,   1,   1,   1,   1,   1,  95,  72,   1,  96,  78,   1,  97,  98,  99,
      1, 100,   1, 101, 102,   1, 103, 104,   1,   1,   1,   1,  86,   1,   1,   1,
      1, 105,  18,   1,   1,   1,   1,   1,   1,   1,   1, 106, 107,   1,   1,   1,
      1, 108,   2,   1,   1,   1,   1, 109,   1,  64,   1, 110,  75, 111, 111,   1,
      1,   1, 112,   0,  95,   1,   1,  76,   1,   1,   1,   1,   1,   1,  82, 113,
      1,   1,  54,   1,   7,   1,   1,   1, 114,   6,   1,   1, 108,  94,   1, 115,
      2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  82,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 112,   1,   1,   1,   1, 116,   1, 117,   1,
      1, 118,   1,   1,   1,   1,   1, 119,   1,   1,   1,   1,   1,   1, 120, 121,
      1, 122,   1, 119,   1,   1, 123,   1,   1,   1, 124,  70,   1,   1, 125,   2,
      1,  75, 126,   1,   1,   1, 127,  75, 128, 129,   1,   9,   1,   1,   1, 130,
      1,   1,   1,   1,   1, 115, 131,  56,   0,   0,   0,   0,   0,   0,   0,   0,
      1,   1,   1, 132,   1,   1,  71,   0, 133, 134, 135,   1,   1,   1, 136,   1,
      1,   1, 103,   1, 137,   1, 138, 139,  71,   1, 140, 141,   1,   1,   1,  89,
     54,   1,   1,   1,   1,   2, 142, 143, 144, 145, 146,   0,   1,   1,   1,  94,
    147, 148,   1,   1, 149, 150, 103,  78,   0,   0,   0,   0,  70,   1, 104,  56,
      1, 151,  81,  94, 152,   1, 153,   0,   1,   1,   1,   1,  78, 154, 155,  56,
      1,   9,   1, 156,   0,   0,   0,   0,   1,  75,  82, 138,   0,   0,   0,   0,
    157, 158, 159,   1,   2, 160,   0, 161, 162, 163,   0,   0,   1, 164, 137,   1,
    165, 166, 167,   1,   1,   0,   1, 168,   1, 169, 107, 170, 171, 172,   0,   0,
      1,   1, 173,   0,   1, 174,   1, 175,   1, 176,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   2,   0,   0,   0,   0,   1,   9,  71,   0,   0,   0,   0,  75,
      1,   1, 177, 178,   1,   1, 179, 180,   1,  97, 117,  75,   1,   1, 132, 181,
    182,   2,   0,   0, 183, 154,   1, 184,  21, 185, 186, 187,   0,   0,   0,   0,
      1,   1, 188,   0,   1,   1, 176,   0,   0,   0,   0,   0,   1, 107,  78,   0,
      1,   1, 189, 190,   1,  73, 191,   0,  15,  86,   0,   0,   0,   0,   0,   0,
      1,  56,   0,   0,   0,   1,   1, 192,   0,   0,   0,   0,   0, 100,   3, 193,
      1,   1,   9,   1,   1, 194,   1,  73, 195, 196, 197, 116, 137, 198,   0,   0,
    199, 200, 176, 201, 202, 191,   0,   0,   0,   0,   0,   0,   0,   0,   0,  73,
      0,   0,   0,   0,   0,   0,   1, 203,   1,   1,   1,   1,  71,   0,   0,   0,
      1,   1,   1, 204,   1,   1,   1,   1,   1,   1, 205,   0,   0,   0,   0,   0,
      1, 206,   0,   0,   0,   0,   0,   0,   1,   1, 105,   0,   0,   0,   0,   0,
      1,  73,   2, 207,   0,   0, 103, 208,   1,   1, 209, 210, 112,   0,   0,   0,
      0,   0,   1,   1,  94,   0,   0,   0,   1,   1, 211,   1, 212,   0,   0, 205,
      1,   1,   1,   1,   1,   1,   1, 119,   1,   1,   1,   1,   1,   1,   1, 174,
      2,   0, 213, 214,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  56,
      1,   1,   1, 215, 216, 205,   0,   0,   1,   1,   1,   1,   1,   1,   1,  82,
      1, 217,   1,   1,   1,   1,   1, 173,   1,   1, 218,   0,   0,   0,   0,  76,
      1,   1,  75,  73,   0,   0,   0,   0,   1,   1,  97,   1,  11, 219, 220,   1,
    221, 222, 223,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 224,   1,   1,
      1,   1,   1,   1,   1,   1, 225,   1,   1,   1,   1,   1, 226, 227,   0,   0,
    228, 229,   0,   0,   0,   0,   0,   0,   1, 230, 207,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   1, 163,   1,   1,   1,   1,   1,   1, 231,   0,
      1,   1, 232,   0,   0,   0,   0,   0,   0,   0,   0, 233,   1, 234,   0,   0,
     54,  78,   0,   0,   0,   0,   0,   0, 220, 235, 236, 237, 238, 239,   0, 240,
      1,  86,   1,   1,  76, 241, 242,  82, 116,   1,   1, 116,   1, 190,   0, 243,
    244,  56, 245, 218,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,  82, 246,
      1,   1,   1,  76,   1,   1,  73, 118,  86,   1, 176,   1,   9, 247,   0,   0,
    144,   1,   1, 248,   1, 249,  13,   1,   1,   1,  76, 250, 251,   0,   0,   0,
      1,   1,   1,   1,   1,   1,  75,   0,   1, 234,   1,   1,   1,   1,   1,   1,
     78,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 252,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 150,  78,   0,   0,   0,   0,   0,   0,   0,
    253,   1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,  78,
};

static RE_UINT8 re_print_stage_4[] = {
      0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 127, 255, 255, 255, 252,
    240, 215, 255, 255, 251, 255, 255, 255, 255, 255, 254, 255, 255, 255, 127, 254,
    255, 231, 254, 255, 255,   0, 255, 255, 255, 135,  31,   0, 255, 255, 255, 223,
    255, 191, 255, 255, 255, 231, 255, 255, 255, 255,   3,   0, 255, 255, 255, 231,
    255,  63, 255, 127, 255, 255, 255,  79, 255,   7,   0,   0, 255, 255, 223,  63,
      0,   0, 248, 255, 239, 159, 249, 255, 255, 253, 197, 243, 159, 121, 128, 176,
    207, 255, 255, 127, 238, 135, 249, 255, 255, 253, 109, 211, 135,  57,   2,  94,
    192, 255, 127,   0, 238, 191, 251, 255, 255, 253, 237, 243, 191,  59,   1,   0,
    207, 255,   3, 254, 238, 159, 249, 255, 159,  57, 192, 176, 207, 255, 255,   0,
    236, 199,  61, 214,  24, 199, 255, 195, 199,  61, 129,   0, 192, 255, 255,   7,
    255, 223, 253, 255, 255, 253, 255, 227, 223,  61,  96,   7, 207, 255, 128, 255,
    255, 253, 239, 243, 223,  61,  96,  64, 207, 255,   6,   0, 239, 223, 253, 255,
    223, 253, 240, 255, 207, 255, 255, 255, 236, 255, 127, 252, 255, 255, 251,  47,
    127, 132,  95, 255, 192, 255,  28,   0, 254, 255, 255, 255, 255, 255, 255, 135,
    255, 255, 255,  15, 214, 247, 255, 255, 175, 255, 255,  63,  95,  63, 255, 243,
    255, 254, 255, 255, 255,  31, 254, 255, 255, 255, 255, 254, 255, 223, 255,   7,
    191,  32, 255, 255, 255,  61, 127,  61, 255,  61, 255, 255, 255, 255,  61, 127,
     61, 255, 127, 255, 255, 255,  61, 255, 255, 255, 255,  31, 255, 255, 255,   3,
    255, 255,  63,  63, 255, 255, 255,   1, 255, 223,  31,   0, 255, 255, 127,   0,
    255, 255,  15,   0, 255, 223,  13,   0, 255, 255, 255,  63, 255,   3, 255,   3,
    255, 127, 255,   3, 255,   7, 255, 255, 255, 255,  63,   0, 255,  15, 255,  15,
    241, 255, 255, 255, 255,  63,  31,   0, 255,  15, 255, 255, 255,   3, 255, 199,
    255, 255, 255, 207, 255, 255, 255, 159, 255, 255,  15, 240, 255, 255, 255, 248,
    255, 227, 255, 255, 255,   1, 255, 255, 255, 255, 255,   7, 255, 255, 255, 251,
     63,  63, 255, 170, 255, 255, 223, 255, 223, 255, 207, 239, 255, 255, 220, 127,
    255, 252, 255, 255, 223, 255, 243, 255, 255, 127, 255,  31,   0,   0, 255, 255,
    255, 255,   1,   0, 127,   0,   0,   0, 255, 255, 207, 255, 255, 255,  63, 255,
    255, 127, 255, 255, 255, 255,  15, 254, 255, 128,   1, 128, 127, 127, 127, 127,
    255, 255,   0,   0,   0,   0, 255,  15, 224, 255, 255, 255,  15,   0, 255, 255,
    255,  31, 255, 255, 127,   0, 255, 255, 255,  15,   0,   0, 255, 255, 255,   0,
    124,   0,   0,   0,   0,   0, 128, 255, 255,  15, 255,   3,  63, 192, 255,   3,
    255, 255,  15, 128, 255, 191, 255, 195, 255,  63, 255, 243,   7,   0,   0, 248,
    126, 126, 126,   0, 127, 127, 255, 255, 255,  63, 255,   3, 127, 248, 255, 255,
    255,  63, 255, 255, 127,   0, 248, 224, 255, 255, 127,  95, 219, 255, 255, 255,
      3,   0, 248, 255, 255, 255, 252, 255, 255,   0,   0,   0,   0,   0, 255,  63,
    255, 255, 247, 255, 127,  15, 223, 255, 252, 252, 252,  28, 127, 127,   0,  62,
    255, 239, 255, 255, 127, 255, 255, 183, 255,  63, 255,  63, 135, 255, 255, 255,
    255, 255, 143, 255, 255, 127, 255,  15,   1,   0,   0,   0,  15, 224, 255, 255,
    255, 255, 255, 191,  15, 255,  63,   0, 255,   3, 255, 255, 255, 255,  15, 255,
     15, 128,   0,   0,  63, 253, 255, 255, 255, 255, 191, 145, 255, 255, 191, 255,
    128, 255,   0,   0, 255, 255,  55, 248, 255, 255, 255, 143, 255, 255, 255, 131,
    255, 255, 255, 240, 111, 240, 239, 254, 255, 255,  63, 135, 255,   1, 255,   1,
    127, 248, 127,   0, 255, 255,  63, 254, 255, 255,   7, 255, 255, 255,   3,  30,
      0, 254,   0,   0, 255,   1,   0,   0, 255, 255,   7,   0, 255, 255,   7, 252,
    255,   0, 255,   3, 255,  63, 252, 255, 255, 255,   0, 128,   3,  32, 255, 255,
    255,   1, 255,   3, 254, 255,  31,   0, 255, 255, 251, 255, 127, 189, 255, 191,
    255,   7, 255,   3, 255, 253, 237, 251, 159,  57, 129, 224, 207,  31,  31,   0,
    255, 255, 255, 235,  31,   0, 255,   3, 255,  31,   0,   0, 255,   3,   0,   0,
    255, 255,   7, 128,  31,   0,   0,   0,   7,   0,   0,   0, 255, 253, 255, 255,
    255, 255, 127, 255,  63,   0, 255, 255, 255, 254, 127,   0, 127, 251, 255, 255,
    255, 255, 127, 180, 191, 253, 255, 255, 255, 127, 251,   1, 255, 255,   3, 128,
    255, 127,  31,   0,  15,   0,   0,   0, 255, 127, 255,   1, 255, 195,   0,   0,
    255,  63,  63,   0,  63,   0, 255, 251, 251, 255, 255, 224, 255, 135, 255, 255,
    255, 128, 255, 255,   0,   0,   7,   0, 240,   0, 255, 255, 255,   7, 255,  31,
    255,   1, 255, 243, 127, 254, 255, 255,  63,   0,   0,   0, 100, 222, 255, 235,
    239, 255, 255, 255, 191, 231, 223, 223, 255, 255, 255, 123,  95, 252, 253, 255,
     63, 255, 255, 255, 255, 207, 255, 255, 255,  15,   0, 248, 254, 255,   0,   0,
    127, 255, 255, 249, 219,   7,   0,   0, 255,  31, 255,  63, 159, 255, 127,   0,
    255,  15, 255, 195,   0,   0, 254, 255, 255, 255,  31,   0, 150, 254, 247,  10,
    132, 234, 150, 170, 150, 247, 247,  94, 255, 251, 255,  15, 238, 251, 255,  15,
      0,   0,   3,   0, 255, 127, 254, 255, 254, 255, 254, 255, 192, 255, 255, 255,
      7,   0, 255, 255, 255,   1,   3,   0, 255,  31, 255,   7, 255,  63,   0,   0,
    255, 255, 123, 252, 231, 199, 255, 255, 255,  63,  15,   7,   7,   0,  63,   0,
      3,   0, 255, 255,   2,   0,   0,   0,
};

/* Print: 2792 bytes. */

RE_UINT32 re_get_print(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_print_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_print_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_print_stage_3[pos + f] << 5;
    pos += code;
    value = (re_print_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Word. */

static RE_UINT8 re_word_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20, 21,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 22, 23, 24,  5, 25, 26,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    27,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_word_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  32,  31,  31,  31,  31,  31,  31,  31,  33,  34,  35,  31,
     36,  37,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  38,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  39,
      1,   1,   1,   1,  40,   1,  41,  42,  43,  44,  45,  46,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  47,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  48,  49,   1,  50,  51,  52,
     53,  54,  55,  56,  57,  58,   1,  59,  60,  61,  62,  63,  64,  65,  31,  66,
     67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  31,  78,  79,  80,  31,
      1,   1,   1,  81,  82,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  84,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  85,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  86,  87,  31,  31,  88,  89,
      1,   1,   1,   1,   1,   1,   1,  90,   1,   1,  91,  31,  31,  31,  31,  31,
      1,  92,  93,  31,  31,  31,  31,  31,  31,  31,  31,  31,  94,  31,  31,  31,
     31,  95,  96,  31,  97,  98,  99, 100,  31,  31, 101,  31,  31,  31,  31,  31,
    102, 103, 104,  31,  31,  31,  31,  31, 105, 106,  31,  31,  31,  31, 107,  31,
     31, 108,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,   1,   1, 109,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 110, 111,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 112,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 113,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 114,  31,  31,  31,  31,  31,
     31,  39,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_word_stage_3[] = {
      0,   0,   0,   1,   2,   3,   2,   4,   0,   0,   5,   6,   7,   8,   7,   8,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   9,  10,  11,   0,
      7,   7,   7,   7,   7,   7,   7,  12,  13,   7,  14,   7,   7,   7,   7,  15,
      7,   7,   7,   7,   7,   7,   7,   7,  14,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   2,   7,  16,   7,   7,  17,   2,   7,  18,  19,   7,   3,  20,
      0,   4,   7,   7,   7,   7,  21,   7,   7,   7,   7,   7,   7,  22,  23,  24,
      0,   7,   7,   7,  25,   7,   7,   7,   7,   7,   7,  10,   7,   7,   7,  26,
      7,   7,  27,   0,   7,  28,   4,   0,   0,   0,   7,  29,   0,  30,  14,   7,
      7,   7,   7,   7,   7,   7,  31,   2,  22,  32,  23,  33,  34,  35,  31,  36,
     37,  32,  23,  38,  39,  40,  41,  42,  43,  14,  23,  44,  45,  46,  31,  47,
     48,  32,  23,  44,  49,  50,  31,  51,  52,  53,  54,  21,  55,  56,  41,   0,
     57,  58,  23,  59,  60,  61,  31,   0,  62,  58,  23,  63,  60,  64,  31,  65,
     62,  58,   7,   7,  66,  67,  31,  68,  69,  70,   7,  71,  72,  73,  41,  74,
      2,   7,   7,   4,  75,   1,   0,   0,  76,   7,  77,  27,  78,  79,   0,   0,
     46,  80,   1,  81,  82,   7,  83,   2,  84,  82,   7,  83,  85,   0,   0,   0,
      7,   7,   7,   7,   1,   7,   7,   7,   7,  27,   7,   7,  86,   7,   7,  87,
      7,   7,   7,   7,  88,  89,   7,   7,  88,   7,   7,  90,  91,   8,   7,   7,
      7,  91,   7,   7,   7,  25,   0,   0,   7,   0,   7,   7,   7,   7,   7,  92,
      2,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,  24,   7,   2,   4,   7,   7,   7,   7,  93,  17,
     57,  94,   7,  94,   7,  95,  57,  96,   7,   7,   7,   7,   7,  97,   1,   0,
     98,   1,   7,   7,   7,   7,   7,  17,   7,   7,   4,   7,   7,   7,   7,  42,
      7,  75,  28,  28,  41,   7,  27,  94,   7,   7,  28,   7,   1,   1,   0,   0,
      7,  28,   7,   7,   7,  75,   7,  24,   1,   1,  99,  75,   0,   0,   0,   0,
      7,   7,   7,   7,  28,   1, 100,  95,   7,   7,   7,   7,   7,   7,   7,  95,
      7,   7,   7, 101,  59,   7,   7,  27,  17,   7,   7,  25,   0, 102,   7,   4,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 103,
      7,  92,   7,   7,  92, 104,   7,  27,   7,   7,   7, 105, 106, 107,  83, 106,
    108,   0,   0, 109,  46, 110,   0, 111,   0,  83,   0,   0,   0,   7,   7,  46,
    112, 113, 114,  79, 115,   0,   7,   7,  17,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  41,   7,   7,   1,   0,
      7,   7,  75,   7,   7,  75,   7,   7,   7,   7,   7,   7,   7,   7, 116,  95,
      7,   7,  86,   7,   7,   7, 117, 109,   7, 118, 119, 119, 119, 119,   7,   7,
      0,   0, 109,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    120,   0,   2, 121,   2,   7,   7,   7,   7, 122,   2,   7,   7,   7,   7,  87,
    123,   7,   7,   2,   7,   7,   7,   7,  75,   0,   7,   4,   0,   0,   0,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  42,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   0,
      7,   7,   7,   7,   7,   7,   7,   7,  83,   0,   0,   0,   0,   7,   7,  27,
     83,   7,  28,   0,   7,   7,   7, 124,   7,   7,   7,   7,   7,   7,   7,  10,
      0, 125, 126,   7,   7,   7,   7,   7, 127,   7,   7,   7, 128,   0,   0, 125,
      7,   7, 101,   0,   7,   7,   7,  95,   7,   7,   7,   7,  42,   1,   7, 129,
      7,   7,  27,   7,   7,  95,   7,  83,   7,   7,   7,   7, 130,   1,   7,  75,
      7,   7,   7, 118,  27,   1,   7,  70,   7,   7,   7,   7,  20,  98,   7, 128,
    131, 132, 119,   7,   7,  87, 101,   7,   7,   7,   7,   7,   7,   7, 133,   1,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  95,   7, 134,   7,   7,  28,
      7,   7,   7,   7,   7,   7,  27,   7,   7,   7,   7,   7,   7,   1,   0,   0,
    118, 135,  23, 136, 137,   7,   7,   7,   7,   7,   7,  10,   0,  30,   7,   7,
      7,   7,   7,  27,   0,   7,   7,   7,   7, 126,   7,   7, 101,   0,   0,  28,
      7,   0,   7, 138, 139,   0,   0,  84,   7,   7,   7,   7,   7,   7,   7,  83,
      0,   1,   2,   3,   2,   4,  41,   7,   7,   7,   7,  75, 140, 141,   0,   0,
    142,   7,   8, 143,  27,  27,   0,   0,   7,   7,   7,   7,   7,   7,   7,   4,
      0,   0,   0,   0,   7,   7,   7,  94,   0,   0,   0,   0,   0,   0,   0, 144,
      0,   0,   0,   0,   0,   0,   0,   0,   7,  83,   7,   7,   7,  46,  46,   0,
      7,   7, 139,   7,   4,   7,   7,   4,   7,  27,   7,   7, 145, 146,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,  27,   1,   7,   7, 145,   7,  28,
      7,   7, 101,   7,   7,   7,  95,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7, 118,   7,  42, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    147,   7,   7, 148,   7,  42,   7, 118,   7,  75,   0,   0,   0,   0,   7, 149,
      7,  42,   7,   1,   0,   0,   0,   0,   7,   7,   7, 150,   0,   0,   0,   0,
    151, 152,   7, 153,   0,   0,   7,  83,   7,  83,   0,   0,  82,   7, 118,   0,
      7,   7,   7,  42,   7,  42,   7,  20,   7,  10,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,  17,   0,   0,   0,   7,   7,   7,  20,   7,   7,   7,  20,
      7,   7, 101,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,  83,  99,   7,   7,  46,   0,   0,   0,   0,   0,   0,   0,   0,   7, 118,
      7,   7,   7,   7, 118,   0,  41, 109,   7,   7,   7,   4,   0,   7,  17,   1,
      7,   7,   7,  84, 154,   7,   7, 155,   7,   7,   7,   7, 156, 157,   0,   0,
      7,  14,   7, 158,   0,   0,   0,   0, 159,  18,  17,   7,   7,   7,   4,   1,
     22,  32,  23, 160,  49, 161, 162,  94,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   4,  21,   0,   0,   7,   7,   7,   7, 163,   1,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   7,   7,   7, 164,  46, 165,   0,   0,
      7,   7,   7,   7, 166,   1,   0,   0,   7,   7,   7,  17,   1,   0,   0,   0,
      7,  25,  28,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   4,   0,   0,   0,   0,   0,   0,   7,   7,   7,   7,   1, 109,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 167,   7,   7, 167, 168,   0,
      7,   7,   7,  75,  99,   7,   7,   7,   7, 169,   0,   0,   7,   7,   7,  17,
     23,   7,   7,   8,  46,   1,   0, 126,   7, 126,  82, 118,   0,   0,   0,   0,
    170,   7,   7, 171, 101,   1, 172,   7,  75, 173,   1,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7, 118,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   1,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,  75,   0,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,  95,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  75,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7, 118,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,  17,   7,  75,   1,   0,   0,   0,   0,   0,   0,   7,  27,  94,
      7,   7,   7, 118,  95,   1,  30, 174,   7,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   7,   7,   7,   7,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   3,   7,   7,   7, 117,   7,   0,   0,   0,   0, 175,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 101,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  20,
      7,  75,   0,   0,   0,  20, 176,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  28,
      7,   7,   7,   7,   7,   7,   4,  83,  17, 177,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 178, 179, 180,   0, 181,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 182,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,  84,   7,   7,   7,  57, 183, 184, 185,   7,   7,   7,
    186, 187,   7, 188, 189,  58,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 164,   7,  58,  87,   7,  87,
      7,  84,   7,  84,  75,   7,  75,   7,  23,   7,  23,   7, 190,   7,   7,   7,
      7,   7,   7, 134,   7,   7,  83, 191, 110, 100,   2,   0,   0,   0,   0,   0,
      8, 127, 192,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      7,   7,  83,  27, 193,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   7,   7,   1,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  94, 118,   0,   0,
      7,   7,   7,   7,  28,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    185,   7, 194, 195, 196, 197, 198, 199, 103,  28, 200,  28,   0,   0,   0,   0,
      0,   0,   0,   7,   1,   7,   1,   7,   1,   0,   0,   0,   0,   0,   0,   0,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 118,   0,   0,
      7,   7,   7,  94,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,  27,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  10,   7,   7,   7,   7,   7,
      7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,  46,   0,
      7,  27,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_word_stage_4[] = {
      0,   0, 255,   3, 254, 255, 255, 135, 255,   7,   0,   4,  32,   4, 255, 255,
    127, 255, 195, 255,   3,   0,  31,  80, 223, 188,  64, 215, 251, 255, 191, 255,
    127,   2, 255,   1, 255, 191, 182,   0,   7,   0, 255, 195, 239, 159, 255, 253,
    255, 159, 255, 231,  63,  36, 255,  63, 255,  15, 223,  63, 248, 255, 207, 255,
    249, 255, 197, 243, 159, 121, 128, 176,   3,  80, 238, 135, 109, 211, 135,  57,
      2,  94, 192, 255,  63,   0, 238, 191, 237, 243, 191,  59,   1,   0,   0, 254,
    238, 159, 159,  57, 192, 176,   2,   0, 236, 199,  61, 214,  24, 199, 199,  61,
    129,   0, 255, 223, 253, 255, 255, 227, 223,  61,  96,   7, 239, 223, 239, 243,
     96,  64,   6,   0, 223, 125, 240, 128,   0, 252, 236, 255, 127, 252, 251,  47,
    127, 132,  95, 255,  12,   0, 255, 127, 214, 247, 175, 255,  95,  63, 255, 243,
      0,   3, 160, 194, 255, 254, 255,  31, 223, 255,  64,   0, 191,  32, 255, 247,
    255,  61, 127,  61,  61, 127,  61, 255,  63,  63, 255, 199,  31,   0,  15,   0,
     13,   0, 143,  48,   0,  56, 128,   0,   0, 248, 255,   0, 247, 255, 255, 251,
    255, 170, 223,  95, 220,  31, 207,  15,   0,  48,   0, 128,  16,   0,   2, 128,
    132, 252,  47,  62,  80, 189, 224,  67,  31, 248, 255, 128, 127,   0, 127, 127,
    224,   0,  62,  31, 127, 230, 224, 255, 247, 191, 128, 255, 252, 255, 255, 249,
    124,   0, 255, 232,   1, 128, 126, 126, 126,   0, 255,  55, 127, 248, 248, 224,
    127,  95, 219, 255,  24,   0,   0, 224, 252, 252, 252,  28, 255, 239, 255, 183,
      0,  32,  15, 255,  62,   0,  63, 253, 191, 145,  55,   0, 255, 192, 111, 240,
    239, 254,  63, 135, 112,   0,  79,   0,  31,  30, 255,  23, 255,  64, 127, 189,
    237, 251, 129, 224, 207,  31, 191,   0,  63, 255,   0,  63,  17,   0, 255, 252,
     27,   0, 255,  35, 127, 251, 127, 180, 191, 253, 251,   1, 255, 224,  11,   0,
    240,   0, 255,  99, 224, 227,   7, 248, 231,  15,   0,  60,  28,   0, 100, 222,
    255, 235, 239, 255, 191, 231, 223, 223, 255, 123,  95, 252, 247, 207,  32,   0,
    219,   7, 255,  67, 150, 254, 247,  10, 132, 234, 150, 170, 150, 247, 247,  94,
    238, 251,
};

/* Word: 2962 bytes. */

RE_UINT32 re_get_word(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_word_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_word_stage_2[pos + f] << 4;
    f = code >> 4;
    code ^= f << 4;
    pos = (RE_UINT32)re_word_stage_3[pos + f] << 4;
    pos += code;
    value = (re_word_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* XDigit. */

static RE_UINT8 re_xdigit_stage_1[] = {
    0, 1, 1, 1, 1, 2, 1, 3, 4, 1, 1, 5, 1, 1, 6, 7,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_xdigit_stage_2[] = {
     0,  1,  1,  2,  3,  4,  4,  5,  6,  1,  1,  7,  8,  9, 10,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 11, 12, 13,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 14,
     1,  1, 15,  1,  1,  1, 16,  1, 17, 18, 19, 20, 21,  1, 22,  1,
     1,  1,  1,  1,  1, 23,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 24,  1,  1,  1,  1,
    25, 18,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_xdigit_stage_3[] = {
     0,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
     2,  3,  2,  0,  2,  2,  2,  4,  2,  2,  2,  2,  2,  5,  2,  5,
     2,  5,  2,  5,  2,  5,  2,  5,  2,  6,  2,  6,  3,  2,  2,  2,
     2,  4,  6,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,
     6,  2,  2,  2,  2,  7,  2,  6,  2,  2,  8,  2,  2,  6,  0,  2,
     2,  8,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,  2,  2,  2,  2,
     2,  2,  2,  6,  4,  2,  2,  9,  2,  6,  2,  2,  2,  2,  2,  0,
     2,  2,  2,  2, 10, 11,  2,  2,  2,  2,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  0,  2,  2,  2,  2,  5,  2,  0, 12,  2,  2,  6,
     2,  2,  2,  0,  2,  2,  2,  2,  2,  6,  2,  6,  2,  2,  2,  2,
     2,  6,  2,  4,  0,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,  2,
     2,  6,  2,  2,  2,  6,  3,  2,  2,  3,  2,  2,  2,  6,  2,  2,
     2,  2,  2,  2,  2,  2,  2, 13,  2,  2,  2,  2,  2,  4,  2,  2,
     2,  2,  2,  2,  2,  6,  2,  2,
};

static RE_UINT8 re_xdigit_stage_4[] = {
      0,   0,   0,   0,   0,   0, 255,   3, 126,   0,   0,   0, 126,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   3,   0,   0,
    255,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 192, 255,   0,   0,
      0,   0, 255,   3,   0,   0,   0,   0, 192, 255,   0,   0,   0,   0,   0,   0,
    255,   3, 255,   3,   0,   0,   0,   0,   0,   0, 255,   3,   0,   0, 255,   3,
      0,   0, 255,   3, 126,   0,   0,   0, 126,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 192, 255,   0, 192, 255, 255, 255, 255, 255, 255,
};

/* XDigit: 592 bytes. */

RE_UINT32 re_get_xdigit(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_xdigit_stage_1[f] << 4;
    f = code >> 9;
    code ^= f << 9;
    pos = (RE_UINT32)re_xdigit_stage_2[pos + f] << 3;
    f = code >> 6;
    code ^= f << 6;
    pos = (RE_UINT32)re_xdigit_stage_3[pos + f] << 6;
    pos += code;
    value = (re_xdigit_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Posix_Digit. */

static RE_UINT8 re_posix_digit_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_posix_digit_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_posix_digit_stage_3[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_posix_digit_stage_4[] = {
      0,   0,   0,   0,   0,   0, 255,   3,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

/* Posix_Digit: 130 bytes. */

RE_UINT32 re_get_posix_digit(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_posix_digit_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_posix_digit_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_posix_digit_stage_3[pos + f] << 7;
    pos += code;
    value = (re_posix_digit_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Posix_AlNum. */

static RE_UINT8 re_posix_alnum_stage_1[] = {
     0,  1,  2,  3,  4,  5,  5,  5,  5,  6,  7,  5,  5,  8,  9, 10,
    11, 12, 13, 14, 15,  9, 16,  5, 17,  9,  9, 18,  9, 19, 20, 21,
     5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 22, 23, 24,  5, 25, 26,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
};

static RE_UINT8 re_posix_alnum_stage_2[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
     16,   1,  17,  18,  19,   1,  20,  21,  22,  23,  24,  25,  26,  27,   1,  28,
     29,  30,  31,  31,  32,  31,  31,  31,  31,  31,  31,  31,  33,  34,  35,  31,
     36,  37,  31,  31,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  38,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,  39,
      1,   1,   1,   1,  40,   1,  41,  42,  43,  44,  45,  46,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,  47,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,  31,   1,  48,  49,   1,  50,  51,  52,
     53,  54,  55,  56,  57,  58,   1,  59,  60,  61,  62,  63,  64,  65,  31,  66,
     67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  31,  78,  79,  80,  31,
      1,   1,   1,  81,  82,  83,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,  84,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,   1,   1,  85,  31,  31,  31,  31,  31,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1,  86,  87,  31,  31,  88,  89,
      1,   1,   1,   1,   1,   1,   1,  90,   1,   1,  91,  31,  31,  31,  31,  31,
      1,  92,  93,  31,  31,  31,  31,  31,  31,  31,  31,  31,  94,  31,  31,  31,
     31,  31,  31,  31,  95,  96,  97,  98,  31,  31,  31,  31,  31,  31,  31,  31,
     99, 100, 101,  31,  31,  31,  31,  31, 102, 103,  31,  31,  31,  31, 104,  31,
     31, 105,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,
      1,   1,   1,   1,   1,   1, 106,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1, 107, 108,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 109,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1, 110,  31,  31,  31,  31,
     31,  31,  31,  31,  31,  31,  31,  31,   1,   1, 111,  31,  31,  31,  31,  31,
};

static RE_UINT8 re_posix_alnum_stage_3[] = {
      0,   1,   2,   2,   0,   3,   4,   4,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   6,   7,   0,   0,   8,   9,  10,  11,   5,  12,
      5,   5,   5,   5,  13,   5,   5,   5,   5,  14,  15,   5,  16,  17,  18,  19,
     20,   5,  21,  22,   5,   5,  23,  24,  25,   5,  26,   5,   5,  27,  28,  29,
     30,  31,  32,  33,   0,  34,  35,  36,   5,  37,  38,  39,  40,  41,  42,  43,
     44,  45,  46,  47,  48,  49,  50,  51,  52,  49,  53,  54,  55,  56,  57,   0,
     58,  59,  60,  61,  58,  62,  63,  64,  58,  65,  66,  67,  68,  69,  70,  71,
     72,  73,  74,   0,  75,  76,  77,   0,  78,   0,  79,  80,  81,  82,   0,   0,
      5,  83,  25,   5,  84,   5,  85,  86,   5,   5,  87,   5,  88,  89,  90,   5,
     91,   5,  73,   0,  92,   5,   5,  93,  72,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,  94,   2,   5,   5,  95,  96,  97,  97,  98,   5,  99, 100,   0,
      0,   5,   5,  32,   5, 101,   5, 102, 103, 104,  25, 105,   5, 106, 107,   0,
    108,   5, 103, 109,   0, 110,   0,   0,   5, 111, 112,   0,   5, 113,   5, 114,
      5, 115, 116, 117, 118,  65,   0, 119,   5,   5,   5,   5,   5,   5,   0, 120,
     93,   5, 121, 117,   5, 122, 123, 124,   0,   0,   0, 125, 126,   0,   0,   0,
    127, 128, 129,   5,  16,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 130,   5, 107,   5, 131, 103,   5,   5,   5,   5, 132,
      5,  85,   5, 133, 115, 134, 134,   5,   0, 135,   0,   0,   0,   0,   0,   0,
    136, 137,  72,   5, 138,  72,   5,  86, 139,  14,   5,   5, 140,  73,   0,  25,
      5,   5,   5,   5,   5, 102,   0,   0,   5,   5,   5,   5,   5,   5,   5,  92,
      5,   5,   5,   5,  31,   0,  25, 117, 141, 142,   5, 143,   5,   5,   5,  92,
    144, 145,   5,   5, 146,   5, 147, 144, 148, 149,   5,  97,   5,   5, 150, 151,
     28, 101, 152,  82,   5, 153, 135, 154,   5, 115, 155, 156,   5, 103, 157, 158,
    159, 160,  86, 161,   5,   5,   5,  33,   5,   5,   5,   5,   5, 162, 163, 108,
      5,   5,   5, 164,   5,   5, 165,   0, 166, 167, 168,   5,   5,  27, 169,   5,
      5, 117,  25,   5, 170,   5, 149, 171,   0,   0,   0, 172,   5,   5,   5,  82,
      0,   2,   2, 173,   5, 103, 174,   0, 175, 176, 177,   0,   5,   5,   5,  73,
      0,   0,   5, 178,   0,   0,   0,   0,   0,   0,   0,   0,  82,   5, 179,   0,
      5,  26, 101,  73, 117,   5, 180,   0,   5,   5,   5,   5, 117,  25, 181, 108,
      5, 161,   5,  61,   0,   0,   0,   0,   5, 115, 102, 149,   0,   0,   0,   0,
    182, 183, 102, 115, 103,   0,   0, 184, 102, 165,   0,   0,   5, 185,   0,   0,
    186, 102,   0,  82,  82,   0,  79, 187,   5, 102, 102, 152,  27,   0,   0,   0,
      5,   5,  16,   0,   5, 152,   5, 152,   5, 149,   0,   0,   0,   0,   0,   0,
     82, 188, 189,   0,   0,   0,   0, 115,   5,   5, 189,   0, 145,  32,  25,  16,
      5, 152, 190, 191,   5,   5, 192,   0, 193, 194,   0,   0, 195, 118,   5,  16,
     40,  49, 196,  61,   0,   0,   0,   0,   5,   5, 197,   0,   5,   5, 198,   0,
      0,   0,   0,   0,   5, 199, 200,   0,   5, 103, 201,   0,   5, 202,   0,   0,
     65,  33,   0,   0,   0,   0,   0,   0,   5,  32,   0,   0,   0,   5,   5, 203,
      0,   0,   0,   0,   0, 204,  30, 205,   5, 206,  25,   5, 207,   0,   5,  32,
    208, 209,  78, 210, 170, 211,   0,   0, 212, 213, 214, 215, 216,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0, 115,   5,   5,   5,   5, 165,   0,   0,   0,
      5,   5,   5, 140,   5,   5,   5,   5,   5,   5,  61,   0,   0,   0,   0,   0,
      5, 140,   0,   0,   0,   0,   0,   0,   5,   5, 217,   0,   0,   0,   0,   0,
      5,  32, 103,   0,   0,   0,  25, 155,   5,  92,  61, 218,  92,   0,   0,   0,
      0,   0,   5,   5,   0,   0,   0,   0,   5,   5, 219,   5, 220,   0,   0, 221,
      5,   5,   5,   5,   5,   5,   5, 222,   5,   5,   5,   5,   5,   5,   5, 152,
    103,   0, 223, 224,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5, 108,
      5,   5,   5, 225, 226,   0,   0,   0,   5,   5, 227,   5, 228, 229, 230,   5,
    231, 232, 233,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5, 234, 235,  86,
    227, 227, 131, 131, 208, 208, 236,   0, 237, 238,   0,   0,   0,   0,   0,   0,
      5, 239, 240,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5, 241,
      5,   5,   5,   5,   5,   5, 187,   0,   5,   5, 242,   0,   0,   0,   0,   0,
    230, 243, 244, 245, 246, 247,   0,   0,   0,  25, 248, 248, 107,   0,   0,   0,
      5,   5,   5,   5,   5,   5, 115,   0,   5, 178,   5,   5,   5,   5,   5,   5,
    117,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5, 249,   5,   5,
      5,   5,   5,   5,   5,   5,   5,  78, 117,   0,   0,   0,   0,   0,   0,   0,
};

static RE_UINT8 re_posix_alnum_stage_4[] = {
      0,   0,   0,   0,   0,   0, 255,   3, 254, 255, 255,   7,   0,   4,  32,   4,
    255, 255, 127, 255, 255, 255, 255, 255, 195, 255,   3,   0,  31,  80,   0,   0,
     32,   0,   0,   0,   0,   0, 223, 188,  64, 215, 255, 255, 251, 255, 255, 255,
    255, 255, 191, 255,   3, 252, 255, 255, 255, 255, 254, 255, 255, 255, 127,   2,
    255,   1,   0,   0,   0,   0, 255, 191, 182,   0, 255, 255, 255, 135,   7,   0,
      0,   0, 255,   7, 255, 255, 255, 254,   0, 192, 255, 255, 255, 255, 239,  31,
    254, 225,   0, 156,   0,   0, 255, 255,   0, 224, 255, 255, 255, 255,   3,   0,
      0, 252, 255, 255, 255,   7,  48,   4, 255, 255, 255, 252, 255,  31,   0,   0,
    255, 255, 255,   1, 255,   7,   0,   0, 255, 255, 223,  63,   0,   0, 240, 255,
    248,   3, 255, 255, 255, 255, 255, 239, 255, 223, 225, 255,  15,   0, 254, 255,
    239, 159, 249, 255, 255, 253, 197, 227, 159,  89, 128, 176,  15,   0,   3,  16,
    238, 135, 249, 255, 255, 253, 109, 195, 135,  25,   2,  94,   0,   0,  63,   0,
    238, 191, 251, 255, 255, 253, 237, 227, 191,  27,   1,   0,  15,   0,   0,  30,
    238, 159, 249, 255, 159,  25, 192, 176,  15,   0,   2,   0, 236, 199,  61, 214,
     24, 199, 255, 195, 199,  29, 129,   0, 239, 223, 253, 255, 255, 253, 255, 227,
    223,  29,  96,   7,  15,   0,   0,   0, 255, 253, 239, 227, 223,  29,  96,  64,
     15,   0,   6,   0, 255, 255, 255, 231, 223,  93, 240, 128,  15,   0,   0, 252,
    236, 255, 127, 252, 255, 255, 251,  47, 127, 128,  95, 255,   0,   0,  12,   0,
    254, 255, 255, 255, 255, 255, 255,   7, 127,  32,   0,   0, 214, 247, 255, 255,
    175, 255, 255,  59,  95,  32,   0, 240,   1,   0,   0,   0, 255, 254, 255, 255,
    255,  31, 254, 255,   3, 255, 255, 254, 255, 255, 255,  31, 255, 255, 127, 249,
    255, 255,   0,  60, 191,  32, 255, 255, 255, 255, 255, 247, 255,  61, 127,  61,
    255,  61, 255, 255, 255, 255,  61, 127,  61, 255, 127, 255, 255, 255,  61, 255,
    255, 255,   0,   0, 255, 255,  63,  63, 255, 159, 255, 255, 255, 199, 255,   1,
    255, 223,  15,   0, 255, 255,  15,   0, 255, 223,  13,   0, 255, 255, 207, 255,
    255,   1, 128,  16, 255,   7, 255, 255, 255, 255,  63,   0, 255, 255, 255, 127,
    255,  15, 255,   1, 255,  63,  31,   0, 255,  15, 255, 255, 255,   3,   0,   0,
    255, 255, 255,  15, 254, 255,  31,   0, 128,   0,   0,   0, 255, 255, 239, 255,
    239,  15,   0,   0, 255, 243,   0, 252, 191, 255,   3,   0, 255, 255, 127,   0,
      0, 224,   0, 252, 255, 255, 255,  63, 255,   1, 255, 255,   0, 222, 111,   4,
    128, 255,  31,   0,  63,  63, 255, 170, 255, 255, 223,  95, 220,  31, 207,  15,
    255,  31, 220,  31,   0,   0,   2, 128,   0,   0, 255,  31, 132, 252,  47,  62,
     80, 189, 255, 243, 224,  67,   0,   0,   0,   0, 192, 255, 255, 127, 255, 255,
     31, 120,  12,   0, 255, 128,   0,   0, 127, 127, 127, 127,   0, 128,   0,   0,
    224,   0,   0,   0, 254,   3,  62,  31, 255, 255, 127, 224, 224, 255, 255, 255,
    255, 127,   0,   0, 255,  31, 255, 255,   0,  12,   0,   0, 255, 127, 240, 143,
      0,   0, 128, 255, 252, 255, 255, 255, 255, 249, 255, 255, 124,   0,   0,   0,
    191, 255, 255, 255, 255,   0,   0,   0,  47,   0,   0,   0,   0,   0, 252, 232,
    255, 255,   7,   0, 255, 255, 247, 255, 255, 255,   0, 124, 255,  63,   0,   0,
    255, 255, 127, 252,   5,   0,   0,  56, 255, 255,  60,   0, 126, 126, 126,   0,
    127, 127, 255, 255, 255,   0, 255, 255,  15,   0, 255, 255, 127, 248, 255, 255,
    255,  63, 255, 255, 255, 255, 255,   3, 127,   0, 248, 224, 255, 253, 127,  95,
    219, 255, 255, 255,   0,   0, 248, 255, 255, 255, 252, 255,   0,   0, 255,  15,
      0,   0, 223, 255, 192, 255, 255, 255, 252, 252, 252,  28, 255, 239, 255, 255,
    127, 255, 255, 183, 255,  63, 255,  63, 255, 255,  31,   0, 255, 255,   1,   0,
     15, 255,  62,   0, 255, 255,  15, 255,  63, 253, 255, 255, 255, 255, 191, 145,
    255, 255,  55,   0, 255, 255, 255, 192, 111, 240, 239, 254,  31,   0,   0,   0,
    128,   0, 255, 255,  63,   0,   0,   0, 112,   0, 255, 255, 255, 255,  71,   0,
     30,   0,   0,  20, 255, 255, 251, 255, 255, 255, 159,  64, 127, 189, 255, 191,
    159,  25, 129, 224, 187,   7,   0, 128, 179,   0,   0,   0, 255, 255,  63, 127,
      0,   0,   0,  63,  17,   0,   0,   0, 255, 255,  63,   1,   0,   0,   0, 128,
    255, 252, 255, 255,  26,   0,   0,   0, 255, 255, 231, 127, 255, 255, 255,  32,
    255, 253, 255, 255, 255, 255, 127, 127,   0,   0, 252, 255, 255, 254, 127,   0,
    127, 251, 255, 255, 255, 255, 127, 180, 203,   0,   0,   0, 191, 253, 255, 255,
    255, 127, 123,   1, 127,   0,   0,   0, 248, 255, 255, 224, 255, 135, 255, 255,
    255, 128, 255, 255,  11,   0,   0,   0, 255, 255, 255,   0,   0,   0,   7,   0,
    240,   0, 255, 255, 255,   7, 255,  31, 255,   1, 255,  67, 255, 255, 223, 255,
    255, 255, 255, 223, 100, 222, 255, 235, 239, 255, 255, 255, 191, 231, 223, 223,
    255, 255, 255, 123,  95, 252, 253, 255,  63, 255, 255, 255, 253, 255, 255, 247,
    247,  15,   0,   0, 127, 255, 255, 249, 219,   7,   0,   0, 255,  31, 128,  63,
      0,  64,   0,   0, 255,  15,   0,   0, 143,   8,   0,   0, 150, 254, 247,  10,
    132, 234, 150, 170, 150, 247, 247,  94, 255, 251, 255,  15, 238, 251, 255,  15,
    255,   3, 255, 255,   3,   0, 255, 255,
};

/* Posix_AlNum: 2600 bytes. */

RE_UINT32 re_get_posix_alnum(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 12;
    code = ch ^ (f << 12);
    pos = (RE_UINT32)re_posix_alnum_stage_1[f] << 4;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_posix_alnum_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_posix_alnum_stage_3[pos + f] << 5;
    pos += code;
    value = (re_posix_alnum_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Posix_Punct. */

static RE_UINT8 re_posix_punct_stage_1[] = {
     0,  1,  2,  3,  3,  4,  3,  5,  6,  7,  3,  8,  3,  9, 10, 11,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     3,  3,  3,  3,  3,  3,  3,  3,
};

static RE_UINT8 re_posix_punct_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
    16,  1,  1, 17, 18,  1, 19, 20, 21, 22, 23, 24, 25,  1,  1, 26,
    27, 28, 29, 29, 30, 29, 29, 31, 29, 29, 29, 32, 33, 34, 35, 36,
    37, 38, 39, 29,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 40,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 41,  1, 42, 43, 44, 45, 46, 47,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 48,  1, 49, 50, 51,
     1, 52,  1, 53,  1, 54,  1,  1, 55, 56, 57, 58,  1,  1,  1, 59,
    60, 61, 62,  1, 63, 64, 65, 66, 67, 68, 69,  1, 70,  1, 71, 72,
     1,  1,  1,  1, 73,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 74, 75,  1,  1, 76, 68,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 77,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    78, 79, 80, 81,  1,  1, 82, 83, 29, 29, 84,  1,  1,  1,  1,  1,
     1, 85, 86,  1,  1,  1,  1,  1,  1, 87,  1,  1, 88, 89, 90,  1,
    91, 92, 93, 29, 29, 29, 94, 95, 96, 97, 98,  1,  1,  1,  1,  1,
};

static RE_UINT8 re_posix_punct_stage_3[] = {
      0,   1,   2,   3,   0,   4,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   6,   7,   0,   0,   0,   8,   9,   0,   0,  10,
      0,   0,   0,   0,  11,   0,   0,   0,   0,   0,  12,   0,  13,  14,  15,  16,
     17,   0,   0,  18,   0,   0,  19,  20,  21,   0,   0,   0,   0,   0,   0,  22,
      0,  23,  14,   0,   0,   0,   0,   0,   0,   0,   0,  24,   0,   0,   0,  25,
      0,   0,   0,  10,   0,   0,   0,  26,   0,   0,   0,  27,   0,   0,   0,  28,
      0,   0,   0,  29,  30,   0,   0,   0,   0,   0,  31,  32,   0,   0,   0,  33,
      0,  34,  35,   0,   0,   0,   0,   0,  36,  37,   0,   0,  38,  39,  40,   0,
      0,   0,  41,   0,  39,   0,   0,  42,   0,   0,   0,  43,  44,   0,   0,   0,
     45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  46,  47,   0,   0,  48,
      0,  49,   0,   0,   0,   0,  50,   0,  51,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  52,   0,   0,   0,  39,  53,  39,   0,   0,   0,   0,  54,   0,   0,
      0,   0,  12,  55,   0,   0,   0,  56,   0,  57,   0,  39,   0,   0,  58,   0,
      0,   0,   0,   0,   0,  59,  60,  61,  62,  63,  64,  65,  66,  53,   0,   0,
     67,  68,  69,   0,  70,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,
     53,  71,  51,   0,  56,  72,   0,   0,  53,  53,  53,  72,  73,  53,  53,  53,
     53,  53,  53,  74,  75,  53,  53,  53,   0,   0,   0,   0,   0,   0,   0,  76,
      0,   0,   0,  27,   0,   0,   0,   0,  53,  77,  78,   0,  79,  53,  53,  80,
     53,  53,  53,  53,  53,  53,  72,  81,  82,  83,   0,   0,  47,  45,   0,  42,
      0,   0,   0,   0,  84,   0,  53,  85,  64,  86,  87,  53,  86,  88,  53,  53,
      0,   0,   0,   0,   0,   0,  53,  53,   0,   0,   0,   0,  62,  53,  71,  39,
     89,   0,   0,  90,   0,   0,   0,  91,  92,  93,   0,   0,  94,   0,   0,   0,
      0,  95,   0,  96,   0,   0,  97,  98,   0,  97,  34,   0,   0,   0,  99,   0,
      0,   0,  56, 100,   0,   0,  39,  26,   0,   0,  42,   0,   0,   0,   0, 101,
      0, 102,   0,   0,   0, 103,  93,   0,   0,  39,   0,   0,   0,   0,   0, 104,
     44,  62, 105, 106,   0,   0,   0,   0,   1,   2,   2, 107,   0,   0,   0, 108,
    109, 110,   0, 111, 112,  45,  62, 113,   0,   0,   0,   0,  34,   0,  27,   0,
      0,   0,   0,  31,   0,   0,   0,   0,   0,   0,   5, 114,   0,   0,   0,   0,
     34,  34,   0,   0,   0,   0,   0,   0,   0,   0, 115,  34,   0,   0, 116, 117,
      0, 111,   0,   0, 118,   0,   0,   0,   0,   0, 119,   0,   0,   0,   0,   0,
      0,   0, 120,   0,   0, 121,  93,   0,   0,   0,  85, 122,   0,   0, 123,   0,
      0, 124,   0,   0,   0, 102,   0,   0,   0,   0, 125,   0,   0,   0, 126,   0,
      0,   0,   0,   0,   0,   0, 127,   0,   0,   0, 128, 129,   0,   0,   0,   0,
      0,  56,   0,   0,   0,   0,   0,   0,   0,  42,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  11,   0,  34,  71,   0, 130, 109,   0,   0,
      0,   0, 131,  26,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 114,
      0,   0,   0,   0,   0,   0, 132, 133,   0,   0,   0, 134,   0,   0,   0,   0,
      0,   0,   0,  97,   0,   0,   0, 135,   0, 110, 136,   0,   0,   0,   0,   0,
      0,   0,   0,   0, 137,   0,   0,   0,   0,   0,   0,   0, 138,   0,   0,   0,
     53,  53,  53,  53,  53,  53,  53,  72,  53, 139,  53, 140, 141, 142,  53,  43,
     53,  53, 143,   0,   0,   0,   0,   0,  53,  53,  92,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 144,  42, 135, 135,  31,  31, 102, 102, 145,   0,
      0, 137,   0, 146, 147,   0,   0,   0,   0,   0,  31,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  34,   0,   0,  39,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0, 148,   0,   0,   0, 149,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  26,  53, 150,  53,  53,  80, 151, 152,  72,
     62,  78,  41, 153,  86, 129,   0, 154, 155, 156, 157, 107,   0,   0,   0,   0,
     53,  53,  53,  53,  53,  53,  72, 158,  53,  53,  53,  80,  53,  53, 159, 160,
    150,  53, 161,  53,  63,  21,   0,   0, 162,  53,  53, 163,  53, 164, 165,  53,
     53,  53,  80, 166, 167,   0,   0,   0,
};

static RE_UINT8 re_posix_punct_stage_4[] = {
      0,   0,   0,   0, 254, 255,   0, 252,   1,   0,   0, 248,   1,   0,   0, 120,
    254, 219, 211, 137,   0,   0, 128,   0,  60,   0, 252, 255, 224, 175, 255, 255,
      0,   0,  32,  64, 176,   0,   0,   0,   0,   0,  64,   0,   4,   0,   0,   0,
      0,   0,   0, 252,   0, 230,   0,   0,   0,   0,   0,  64,  73,   0,   0,   0,
      0,   0,  24,   0, 192, 255,   0, 200,   0,  60,   0,   0,   0,   0,  16,  64,
      0,   2,   0,  96, 255,  63,   0,   0,   0,   0, 192, 195,   0,   0, 255, 127,
     48,   0,   1,   0,   0,   0,  12,  44,   0,   0,   3,   0,   0,   0,   1,   0,
      0,   0, 248,   7,   0,   0, 128, 128,  16,   0,   0,   0,   0, 128,   0,   0,
      0,   0,   0,   2,   0,   0,  16,   0,   0,   0,   0, 128,   0, 128,   0,  12,
    254, 255, 255, 252,   0,   0,  80,  61,  32,   0,   0,   0,   0,   0,   0, 192,
    191, 223, 255,   7,   0, 252,   0,   0,   0,   0,   0,   8, 255,   1,   0,   0,
      0,   0, 255,   3,   1,   0,   0,   0,   0,  96,   0,   0,   0,   0,   0,  24,
      0,  56,   0,   0,   0,   0,  96,   0,   0,   0, 112,  15, 255,   7,   0,   0,
     49,   0,   0,   0, 255, 255, 255, 255, 127,  63,   0,   0, 255,   7, 240,  31,
      0,   0,   0, 240,   0,   0,   0, 248, 255,   0,   8,   0,   0,   0,   0, 160,
      3, 224,   0, 224,   0, 224,   0,  96,   0,   0, 255, 255, 255,   0, 255, 255,
    255, 255, 255, 127,   0,   0,   0, 124,   0, 124,   0,   0, 123,   3, 208, 193,
    175,  66,   0,  12,  31, 188,   0,   0,   0,  12, 255, 255, 127,   0,   0,   0,
    255, 255,  63,   0,   0,   0, 240, 255, 255, 255, 207, 255, 255, 255,  63, 255,
    224,   7,   0, 222, 255, 127, 255, 255, 255, 255,   0,   0, 255, 255, 255, 251,
    255, 255,  15,   0,   0,   0, 255,  15,  30, 255, 255, 255,   1,   0, 193, 224,
      0,   0, 195, 255,  15,   0,   0,   0,   0, 252, 255, 255, 255,   0,   1,   0,
    255, 255,   1,   0,   0, 224,   0,   0,   0,   0,   8,  64,   0,   0, 252,   0,
    255, 255, 127,   0,   3,   0,   0,   0,   0,   6,   0,   0,   0,  15, 192,   3,
      0,   0, 240,   0,   0, 192,   0,   0,   0,   0,   0,  23, 254,  63,   0, 192,
      0,   0, 128,   3,   0,   8,   0,   0,   0,   2,   0,   0,   0,   0, 252, 255,
      0,   0,   0,  48, 255, 255, 247, 255, 127,  15,   0,   0,  63,   0,   0,   0,
    127, 127,   0,  48,   7,   0,   0,   0,   0,   0, 128, 255,   0,   0,   0, 254,
    255, 115, 255,  15, 255, 255, 255,  31,   0,   0, 128,   1,   0,   0, 255,   1,
      0,   1,   0,   0,   0,   0, 127,   0,   0,   0,   0,  30,   0,   0, 224,   3,
    128,  63,   0,   0,   0,   0,   0, 216,   0,   0,  48,   0, 224,  33,   0, 232,
      0,   0,   0,  63,   0, 248,   0,  40,  64,   0,   0,   0, 254, 255, 255,   0,
     14,   0,   0,   0, 255,  31,   0,   0,   0,   0,   0, 220,  62,   0,   0,   0,
      0,   0, 224, 255, 255, 255,   3, 128,   0,   0,  31,   0,   0,   0,  32,   0,
     48,   0,   0,   0,   0,   0, 128,   7,   0,   0,   0, 144, 127, 254, 255, 255,
     31,  28,   0,   0,  24, 240, 255, 255, 255, 195, 255, 255,  35,   0,   0,   0,
      2,   0,   0,   8,   8,   0,   0,   0,   0, 224, 223, 255, 239,  15,   0,   0,
      0,  16,   1,   0,   0,  64,   0,   0, 255,  15, 255, 255, 255, 127, 254, 255,
    254, 255, 254, 255,   0,  28,   0,   0, 192, 255, 255, 255,   7,   0, 255, 255,
    255, 255, 255,  15, 255,   1,   3,   0, 255,  31, 255,   7, 255, 255, 255,   1,
    255,  15,   0,   0, 255,   0, 255,   3, 255, 239, 255, 255, 255, 255, 123, 252,
    231, 199, 255, 255, 255, 231, 255, 255, 255,  63,  15,   7,   7,   0,  63,   0,
};

/* Posix_Punct: 1984 bytes. */

RE_UINT32 re_get_posix_punct(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 13;
    code = ch ^ (f << 13);
    pos = (RE_UINT32)re_posix_punct_stage_1[f] << 5;
    f = code >> 8;
    code ^= f << 8;
    pos = (RE_UINT32)re_posix_punct_stage_2[pos + f] << 3;
    f = code >> 5;
    code ^= f << 5;
    pos = (RE_UINT32)re_posix_punct_stage_3[pos + f] << 5;
    pos += code;
    value = (re_posix_punct_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* Posix_XDigit. */

static RE_UINT8 re_posix_xdigit_stage_1[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1,
};

static RE_UINT8 re_posix_xdigit_stage_2[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_posix_xdigit_stage_3[] = {
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

static RE_UINT8 re_posix_xdigit_stage_4[] = {
      0,   0,   0,   0,   0,   0, 255,   3, 126,   0,   0,   0, 126,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

/* Posix_XDigit: 130 bytes. */

RE_UINT32 re_get_posix_xdigit(RE_UINT32 ch) {
    RE_UINT32 code;
    RE_UINT32 f;
    RE_UINT32 pos;
    RE_UINT32 value;

    f = ch >> 15;
    code = ch ^ (f << 15);
    pos = (RE_UINT32)re_posix_xdigit_stage_1[f] << 4;
    f = code >> 11;
    code ^= f << 11;
    pos = (RE_UINT32)re_posix_xdigit_stage_2[pos + f] << 4;
    f = code >> 7;
    code ^= f << 7;
    pos = (RE_UINT32)re_posix_xdigit_stage_3[pos + f] << 7;
    pos += code;
    value = (re_posix_xdigit_stage_4[pos >> 3] >> (pos & 0x7)) & 0x1;

    return value;
}

/* All_Cases. */

static RE_UINT8 re_all_cases_stage_1[] = {
    0, 1, 2, 2, 2, 3, 2, 4, 5, 2, 2, 6, 2, 2, 2, 7,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
};

static RE_UINT8 re_all_cases_stage_2[] = {
     0,  1,  2,  3,  4,  5,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     7,  6,  6,  8,  6,  6,  6,  6,  6,  6,  6,  6,  9, 10, 11, 12,
     6, 13,  6,  6, 14,  6,  6,  6,  6,  6,  6,  6, 15, 16,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6, 17, 18,  6,  6,  6, 19,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6, 20,  6,  6,  6, 21,
     6,  6,  6,  6, 22,  6,  6,  6,  6,  6,  6,  6, 23,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6, 24,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6, 25,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6, 26,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
};

static RE_UINT8 re_all_cases_stage_3[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   3,   4,   5,   6,   7,   8,
      0,   0,   0,   0,   0,   0,   9,   0,  10,  11,  12,  13,  14,  15,  16,  17,
     18,  18,  18,  18,  18,  18,  19,  20,  21,  22,  18,  18,  18,  18,  18,  23,
     24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  21,  34,  18,  18,  35,  18,
     18,  18,  18,  18,  36,  18,  37,  38,  39,  18,  40,  41,  42,  43,  44,  45,
     46,  47,  48,  49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  50,   0,   0,   0,   0,   0,  51,  52,
     53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  18,  18,  18,  64,  65,
     66,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  75,  76,  18,  18,  18,
     77,  78,  18,  18,  18,  18,  18,  18,  79,  80,  18,  18,  18,  18,  18,  18,
     18,  18,  18,  18,  18,  18,  81,  82,  82,  82,  83,   0,  84,  85,  85,  85,
     86,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  87,  87,  87,  87,  88,  89,  90,  90,  90,  90,  90,  91,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  93,  94,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     95,  96,  97,  97,  97,  97,  97,  98,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  99,
      0, 100,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18, 101,  18,  18,  18,
     18,  18, 102, 103,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,
    104, 105,  93,  94, 104, 105, 104, 105,  93,  94, 106, 107, 104, 105, 108, 109,
    104, 105, 104, 105, 104, 105, 110, 111, 112, 113, 114, 115, 116, 117, 112, 118,
      0,   0,   0,   0, 119, 120, 121,   0,   0, 122,   0,   0, 123, 123, 124, 124,
    125,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 126, 127, 127, 127, 128, 128, 128, 129,   0,   0,
     82,  82,  82,  82,  82,  83,  85,  85,  85,  85,  85,  86, 130, 131, 132, 133,
     18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  37, 134, 135,   0,
    136, 136, 136, 136, 137, 138,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  18, 139,  18,  18,  18, 102,   0,   0,
     18,  18,  18,  37,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  78,  18,  78,  18,  18,  18,  18,  18,  18,  18,   0, 140,
     18, 141, 142,  18,  18, 143, 144,  18, 145,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 146,   0,   0,   0, 147, 147,
    147, 147, 147, 147, 147, 147, 147, 147,   0,   0,   0,   0,   0,   0,   0,   0,
    148,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   1,  11,  11,   4,   5,  15,  15,   8,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    149, 149, 149, 149, 149, 150, 150, 150, 150, 150,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 149, 149, 149, 149, 151, 150, 150, 150, 150, 152,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    153, 153, 153, 153, 153, 153, 154,   0, 155, 155, 155, 155, 155, 155, 156,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  11,  11,  11,  11,  15,  15,  15,  15,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  11,  11,  11,  11,  15,  15,  15,  15,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    157, 157, 157, 157, 158, 159, 159, 159, 160,   0,   0,