% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mcmc_plot.brmsfit}
\alias{mcmc_plot.brmsfit}
\alias{stanplot}
\alias{stanplot.brmsfit}
\alias{mcmc_plot}
\title{MCMC Plots Implemented in \pkg{bayesplot}}
\usage{
\method{mcmc_plot}{brmsfit}(
  object,
  pars = NA,
  type = "intervals",
  variable = NULL,
  regex = FALSE,
  fixed = FALSE,
  ...
)

mcmc_plot(object, ...)
}
\arguments{
\item{object}{An \R object typically of class \code{brmsfit}}

\item{pars}{Deprecated alias of \code{variable}.
Names of the parameters to plot, as given by a
character vector or a regular expression.}

\item{type}{The type of the plot. 
Supported types are (as names) \code{hist}, \code{dens}, 
\code{hist_by_chain}, \code{dens_overlay}, 
\code{violin}, \code{intervals}, \code{areas}, \code{acf}, 
\code{acf_bar},\code{trace}, \code{trace_highlight}, \code{scatter},
\code{rhat}, \code{rhat_hist}, \code{neff}, \code{neff_hist}
\code{nuts_acceptance}, \code{nuts_divergence},
\code{nuts_stepsize}, \code{nuts_treedepth}, and \code{nuts_energy}. 
For an overview on the various plot types see
\code{\link[bayesplot:MCMC-overview]{MCMC-overview}}.}

\item{variable}{Names of the variables (parameters) to plot, as given by a
character vector or a regular expression (if \code{regex = TRUE}). By
default, a hopefully not too large selection of variables is plotted.}

\item{regex}{Logical; Indicates whether \code{variable} should
be treated as regular expressions. Defaults to \code{FALSE}.}

\item{fixed}{(Deprecated) Indicates whether parameter names 
should be matched exactly (\code{TRUE}) or treated as
regular expressions (\code{FALSE}). Default is \code{FALSE}
and only works with argument \code{pars}.}

\item{...}{Additional arguments passed to the plotting functions.
See \code{\link[bayesplot:MCMC-overview]{MCMC-overview}} for
more details.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object 
  that can be further customized using the \pkg{ggplot2} package.
}
\description{
Convenient way to call MCMC plotting functions 
implemented in the \pkg{bayesplot} package.
}
\details{
Also consider using the \pkg{shinystan} package available via 
  method \code{\link{launch_shinystan}} in \pkg{brms} for flexible 
  and interactive visual analysis.
}
\examples{
\dontrun{
model <- brm(count ~ zAge + zBase * Trt + (1|patient),
             data = epilepsy, family = "poisson")
             
# plot posterior intervals
mcmc_plot(model)

# only show population-level effects in the plots
mcmc_plot(model, variable = "^b_", regex = TRUE)

# show histograms of the posterior distributions
mcmc_plot(model, type = "hist")

# plot some diagnostics of the sampler
mcmc_plot(model, type = "neff")
mcmc_plot(model, type = "rhat")

# plot some diagnostics specific to the NUTS sampler
mcmc_plot(model, type = "nuts_acceptance")
mcmc_plot(model, type = "nuts_divergence")
}

}
