% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-sp.R
\name{mo}
\alias{mo}
\title{Monotonic Predictors in \pkg{brms} Models}
\usage{
mo(x, id = NA)
}
\arguments{
\item{x}{An integer variable or an ordered factor to be modeled as monotonic.}

\item{id}{Optional character string. All monotonic terms
with the same \code{id} within one formula will be modeled as
having the same simplex (shape) parameter vector. If all monotonic terms
of the same predictor have the same \code{id}, the resulting
predictions will be conditionally monotonic for all values of
interacting covariates (Bürkner & Charpentier, 2020).}
}
\description{
Specify a monotonic predictor term in \pkg{brms}. The function does not
evaluate its arguments -- it exists purely to help set up a model.
}
\details{
See Bürkner and Charpentier (2020) for the underlying theory. For
  detailed documentation of the formula syntax used for monotonic terms, 
  see \code{help(brmsformula)} as well as \code{vignette("brms_monotonic")}.
}
\examples{
  
\dontrun{
# generate some data
income_options <- c("below_20", "20_to_40", "40_to_100", "greater_100")
income <- factor(sample(income_options, 100, TRUE), 
                 levels = income_options, ordered = TRUE)
mean_ls <- c(30, 60, 70, 75)
ls <- mean_ls[income] + rnorm(100, sd = 7)
dat <- data.frame(income, ls)

# fit a simple monotonic model
fit1 <- brm(ls ~ mo(income), data = dat)
summary(fit1)
plot(fit1, N = 6)
plot(conditional_effects(fit1), points = TRUE)

# model interaction with other variables
dat$x <- sample(c("a", "b", "c"), 100, TRUE)
fit2 <- brm(ls ~ mo(income)*x, data = dat)
summary(fit2)
plot(conditional_effects(fit2), points = TRUE)

# ensure conditional monotonicity
fit3 <- brm(ls ~ mo(income, id = "i")*x, data = dat)
summary(fit3)
plot(conditional_effects(fit3), points = TRUE)
} 
 
}
\references{
Bürkner P. C. & Charpentier E. (2020). Modeling Monotonic Effects of Ordinal
Predictors in Regression Models. British Journal of Mathematical and 
Statistical Psychology. doi:10.1111/bmsp.12195
}
\seealso{
\code{\link{brmsformula}}
}
