% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_mixture.R
\name{pp_mixture.brmsfit}
\alias{pp_mixture.brmsfit}
\alias{pp_mixture}
\title{Posterior Probabilities of Mixture Component Memberships}
\usage{
\method{pp_mixture}{brmsfit}(
  x,
  newdata = NULL,
  re_formula = NULL,
  resp = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  log = FALSE,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ...
)

pp_mixture(x, ...)
}
\arguments{
\item{x}{An \R object usually of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{log}{Logical; Indicates whether to return 
probabilities on the log-scale.}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\value{
If \code{summary = TRUE}, an N x E x K array,
where N is the number of observations, K is the number
of mixture components, and E is equal to \code{length(probs) + 2}.
If \code{summary = FALSE}, an S x N x K array, where
S is the number of posterior draws.
}
\description{
Compute the posterior probabilities of mixture component 
memberships for each observation including uncertainty
estimates.
}
\details{
The returned probabilities can be written as
\eqn{P(Kn = k | Yn)}, that is the posterior probability 
that observation n originates from component k. 
They are computed using Bayes' Theorem
\deqn{P(Kn = k | Yn) = P(Yn | Kn = k) P(Kn = k) / P(Yn),}
where \eqn{P(Yn | Kn = k)} is the (posterior) likelihood
of observation n for component k, \eqn{P(Kn = k)} is 
the (posterior) mixing probability of component k 
(i.e. parameter \code{theta<k>}), and 
\deqn{P(Yn) = \sum (k=1,...,K) P(Yn | Kn = k) P(Kn = k)}
is a normalizing constant.
}
\examples{
\dontrun{
## simulate some data
set.seed(1234)
dat <- data.frame(
  y = c(rnorm(100), rnorm(50, 2)), 
  x = rnorm(150)
)
## fit a simple normal mixture model
mix <- mixture(gaussian, nmix = 2)
prior <- c(
  prior(normal(0, 5), Intercept, nlpar = mu1),
  prior(normal(0, 5), Intercept, nlpar = mu2),
  prior(dirichlet(2, 2), theta)
)
fit1 <- brm(bf(y ~ x), dat, family = mix,
            prior = prior, chains = 2, inits = 0)
summary(fit1)
   
## compute the membership probabilities         
ppm <- pp_mixture(fit1)
str(ppm)

## extract point estimates for each observation
head(ppm[, 1, ])

## classify every observation according to 
## the most likely component
apply(ppm[, 1, ], 1, which.max)
}

}
