% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{recode}
\alias{recode}
\alias{recode_factor}
\title{Recode values}
\usage{
recode(.x, ..., .default = NULL, .missing = NULL)

recode_factor(.x, ..., .default = NULL, .missing = NULL, .ordered = FALSE)
}
\arguments{
\item{.x}{A vector to modify}

\item{...}{Replacements. These should be named for character and factor
\code{.x}, and can be named for numeric \code{.x}. The argument names should be the
current values to be replaced, and the argument values should be the new
(replacement) values.

All replacements must be the same type, and must have either
length one or the same length as x.

These dots are evaluated with \link[rlang:dots_list]{explicit splicing}.}

\item{.default}{If supplied, all values not otherwise matched will
be given this value. If not supplied and if the replacements are
the same type as the original values in \code{.x}, unmatched
values are not changed. If not supplied and if the replacements
are not compatible, unmatched values are replaced with \code{NA}.

\code{.default} must be either length 1 or the same length as
\code{.x}.}

\item{.missing}{If supplied, any missing values in \code{.x} will be
replaced by this value. Must be either length 1 or the same length as
\code{.x}.}

\item{.ordered}{If \code{TRUE}, \code{recode_factor()} creates an
ordered factor.}
}
\value{
A vector the same length as \code{.x}, and the same type as
the first of \code{...}, \code{.default}, or \code{.missing}.
\code{recode_factor()} returns a factor whose levels are in the
same order as in \code{...}.
}
\description{
This is a vectorised version of \code{\link[=switch]{switch()}}: you can replace
numeric values based on their position, and character values by their
name. This is an S3 generic: dplyr provides methods for numeric, character,
and factors. For logical vectors, use \code{\link[=if_else]{if_else()}}. For more complicated
criteria, use \code{\link[=case_when]{case_when()}}.
}
\details{
You can use \code{recode()} directly with factors; it will preserve the existing
order of levels while changing the values. Alternatively, you can
use \code{recode_factor()}, which will change the order of levels to match
the order of replacements. See the \href{http://forcats.tidyverse.org/}{forcats}
package for more tools for working with factors and their levels.
}
\examples{
# Recode values with named arguments
x <- sample(c("a", "b", "c"), 10, replace = TRUE)
recode(x, a = "Apple")
recode(x, a = "Apple", .default = NA_character_)

# Named arguments also work with numeric values
x <- c(1:5, NA)
recode(x, `2` = 20L, `4` = 40L)

# Note that if the replacements are not compatible with .x,
# unmatched values are replaced by NA and a warning is issued.
recode(x, `2` = "b", `4` = "d")

# If you don't name the arguments, recode() matches by position
recode(x, "a", "b", "c")
recode(x, "a", "b", "c", .default = "other")
recode(x, "a", "b", "c", .default = "other", .missing = "missing")

# Supply default with levels() for factors
x <- factor(c("a", "b", "c"))
recode(x, a = "Apple", .default = levels(x))

# Use recode_factor() to create factors with levels ordered as they
# appear in the recode call. The levels in .default and .missing
# come last.
x <- c(1:4, NA)
recode_factor(x, `1` = "z", `2` = "y", `3` = "x")
recode_factor(x, `1` = "z", `2` = "y", .default = "D")
recode_factor(x, `1` = "z", `2` = "y", .default = "D", .missing = "M")

# When the input vector is a compatible vector (character vector or
# factor), it is reused as default.
recode_factor(letters[1:3], b = "z", c = "y")
recode_factor(factor(letters[1:3]), b = "z", c = "y")
}
