% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-vars.R
\name{select_vars}
\alias{select_vars}
\alias{rename_vars}
\title{Select variables.}
\usage{
select_vars(vars, ..., include = character(), exclude = character())

rename_vars(vars, ..., strict = TRUE)
}
\arguments{
\item{vars}{A character vector of existing column names.}

\item{..., args}{Expressions to compute

These arguments are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in a context where elements of
\code{vars} are objects representing their positions within
\code{vars}. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.

Note that except for \code{:}, \code{-} and \code{c()}, all complex expressions
are evaluated outside that context. This is to prevent accidental
matching to \code{vars} elements when you refer to variables from the
calling context.}

\item{include, exclude}{Character vector of column names to always
include/exclude.}

\item{strict}{If \code{TRUE}, will throw an error if you attempt to rename a
variable that doesn't exist.}
}
\value{
A named character vector. Values are existing column names,
names are new names.
}
\description{
These functions power \code{\link[=select]{select()}} and \code{\link[=rename]{rename()}}.
}
\details{
For historic reasons, the \code{vars} and \code{include} arguments are not
prefixed with \code{.}. This means that any argument starting with \code{v}
might partial-match on \code{vars} if it is not explicitly named. Also
\code{...} cannot accept arguments named \code{exclude} or \code{include}. You can
enquose and splice the dots to work around these limitations (see
examples).
}
\examples{
# Keep variables
select_vars(names(iris), everything())
select_vars(names(iris), starts_with("Petal"))
select_vars(names(iris), ends_with("Width"))
select_vars(names(iris), contains("etal"))
select_vars(names(iris), matches(".t."))
select_vars(names(iris), Petal.Length, Petal.Width)
select_vars(names(iris), one_of("Petal.Length", "Petal.Width"))

df <- as.data.frame(matrix(runif(100), nrow = 10))
df <- df[c(3, 4, 7, 1, 9, 8, 5, 2, 6, 10)]
select_vars(names(df), num_range("V", 4:6))

# Drop variables
select_vars(names(iris), -starts_with("Petal"))
select_vars(names(iris), -ends_with("Width"))
select_vars(names(iris), -contains("etal"))
select_vars(names(iris), -matches(".t."))
select_vars(names(iris), -Petal.Length, -Petal.Width)

# Rename variables
select_vars(names(iris), petal_length = Petal.Length)
select_vars(names(iris), petal = starts_with("Petal"))

# Rename variables preserving all existing
rename_vars(names(iris), petal_length = Petal.Length)

# You can unquote names or formulas (or lists of)
select_vars(names(iris), !!! list(quo(Petal.Length)))
select_vars(names(iris), !! quote(Petal.Length))

# The .data pronoun is available:
select_vars(names(mtcars), .data$cyl)
select_vars(names(mtcars), .data$mpg : .data$disp)

# However it isn't available within calls since those are evaluated
# outside of the data context. This would fail if run:
# select_vars(names(mtcars), identical(.data$cyl))


# If you're writing a wrapper around select_vars(), pass the dots
# via splicing to avoid matching dotted arguments to select_vars()
# named arguments (`vars`, `include` and `exclude`):
wrapper <- function(...) {
  select_vars(names(mtcars), !!! quos(...))
}

# This won't partial-match on `vars`:
wrapper(var = cyl)

# This won't match on `include`:
wrapper(include = cyl)
}
\seealso{
\code{\link[=select_var]{select_var()}}
}
\keyword{internal}
